/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.commons.lang3.time.FastTimeZone;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.DefaultLocale;
import org.junitpioneer.jupiter.DefaultTimeZone;

public class FastDateFormatTest {
    private static final int NTHREADS = 10;
    private static final int NROUNDS = 10000;

    @Test
    public void test_getInstance() {
        FastDateFormat format1 = FastDateFormat.getInstance();
        FastDateFormat format2 = FastDateFormat.getInstance();
        Assertions.assertSame((Object)format1, (Object)format2);
    }

    @Test
    public void test_getInstance_String() {
        FastDateFormat format1 = FastDateFormat.getInstance((String)"MM/DD/yyyy");
        FastDateFormat format2 = FastDateFormat.getInstance((String)"MM-DD-yyyy");
        FastDateFormat format3 = FastDateFormat.getInstance((String)"MM-DD-yyyy");
        Assertions.assertNotSame((Object)format1, (Object)format2);
        Assertions.assertSame((Object)format2, (Object)format3);
        Assertions.assertEquals((Object)"MM/DD/yyyy", (Object)format1.getPattern());
        Assertions.assertEquals((Object)TimeZone.getDefault(), (Object)format1.getTimeZone());
        Assertions.assertEquals((Object)TimeZone.getDefault(), (Object)format2.getTimeZone());
    }

    @DefaultLocale(language="en", country="US")
    @DefaultTimeZone(value="America/New_York")
    @Test
    public void test_getInstance_String_TimeZone() {
        FastDateFormat format1 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (TimeZone)TimeZone.getTimeZone("Atlantic/Reykjavik"));
        FastDateFormat format2 = FastDateFormat.getInstance((String)"MM/DD/yyyy");
        FastDateFormat format3 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (TimeZone)TimeZone.getDefault());
        FastDateFormat format4 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (TimeZone)TimeZone.getDefault());
        FastDateFormat format5 = FastDateFormat.getInstance((String)"MM-DD-yyyy", (TimeZone)TimeZone.getDefault());
        FastDateFormat format6 = FastDateFormat.getInstance((String)"MM-DD-yyyy");
        Assertions.assertNotSame((Object)format1, (Object)format2);
        Assertions.assertEquals((Object)TimeZone.getTimeZone("Atlantic/Reykjavik"), (Object)format1.getTimeZone());
        Assertions.assertEquals((Object)TimeZone.getDefault(), (Object)format2.getTimeZone());
        Assertions.assertSame((Object)format3, (Object)format4);
        Assertions.assertNotSame((Object)format3, (Object)format5);
        Assertions.assertNotSame((Object)format4, (Object)format6);
    }

    @DefaultLocale(language="en", country="US")
    @Test
    public void test_getInstance_String_Locale() {
        FastDateFormat format1 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (Locale)Locale.GERMANY);
        FastDateFormat format2 = FastDateFormat.getInstance((String)"MM/DD/yyyy");
        FastDateFormat format3 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (Locale)Locale.GERMANY);
        Assertions.assertNotSame((Object)format1, (Object)format2);
        Assertions.assertSame((Object)format1, (Object)format3);
        Assertions.assertEquals((Object)Locale.GERMANY, (Object)format1.getLocale());
    }

    @DefaultLocale(language="en", country="US")
    @Test
    public void test_changeDefault_Locale_DateInstance() {
        FastDateFormat format1 = FastDateFormat.getDateInstance((int)0, (Locale)Locale.GERMANY);
        FastDateFormat format2 = FastDateFormat.getDateInstance((int)0);
        Locale.setDefault(Locale.GERMANY);
        FastDateFormat format3 = FastDateFormat.getDateInstance((int)0);
        Assertions.assertSame((Object)Locale.GERMANY, (Object)format1.getLocale());
        Assertions.assertEquals((Object)Locale.US, (Object)format2.getLocale());
        Assertions.assertSame((Object)Locale.GERMANY, (Object)format3.getLocale());
        Assertions.assertNotSame((Object)format1, (Object)format2);
        Assertions.assertNotSame((Object)format2, (Object)format3);
    }

    @DefaultLocale(language="en", country="US")
    @Test
    public void test_changeDefault_Locale_DateTimeInstance() {
        FastDateFormat format1 = FastDateFormat.getDateTimeInstance((int)0, (int)0, (Locale)Locale.GERMANY);
        FastDateFormat format2 = FastDateFormat.getDateTimeInstance((int)0, (int)0);
        Locale.setDefault(Locale.GERMANY);
        FastDateFormat format3 = FastDateFormat.getDateTimeInstance((int)0, (int)0);
        Assertions.assertSame((Object)Locale.GERMANY, (Object)format1.getLocale());
        Assertions.assertEquals((Object)Locale.US, (Object)format2.getLocale());
        Assertions.assertSame((Object)Locale.GERMANY, (Object)format3.getLocale());
        Assertions.assertNotSame((Object)format1, (Object)format2);
        Assertions.assertNotSame((Object)format2, (Object)format3);
    }

    @DefaultLocale(language="en", country="US")
    @DefaultTimeZone(value="America/New_York")
    @Test
    public void test_getInstance_String_TimeZone_Locale() {
        FastDateFormat format1 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (TimeZone)TimeZone.getTimeZone("Atlantic/Reykjavik"), (Locale)Locale.GERMANY);
        FastDateFormat format2 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (Locale)Locale.GERMANY);
        FastDateFormat format3 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (TimeZone)TimeZone.getDefault(), (Locale)Locale.GERMANY);
        Assertions.assertNotSame((Object)format1, (Object)format2);
        Assertions.assertEquals((Object)TimeZone.getTimeZone("Atlantic/Reykjavik"), (Object)format1.getTimeZone());
        Assertions.assertEquals((Object)TimeZone.getDefault(), (Object)format2.getTimeZone());
        Assertions.assertEquals((Object)TimeZone.getDefault(), (Object)format3.getTimeZone());
        Assertions.assertEquals((Object)Locale.GERMANY, (Object)format1.getLocale());
        Assertions.assertEquals((Object)Locale.GERMANY, (Object)format2.getLocale());
        Assertions.assertEquals((Object)Locale.GERMANY, (Object)format3.getLocale());
    }

    @Test
    public void testCheckDefaults() {
        FastDateFormat format = FastDateFormat.getInstance();
        FastDateFormat medium = FastDateFormat.getDateTimeInstance((int)3, (int)3);
        Assertions.assertEquals((Object)medium, (Object)format);
        SimpleDateFormat sdf = new SimpleDateFormat();
        Assertions.assertEquals((Object)sdf.toPattern(), (Object)format.getPattern());
        Assertions.assertEquals((Object)Locale.getDefault(), (Object)format.getLocale());
        Assertions.assertEquals((Object)TimeZone.getDefault(), (Object)format.getTimeZone());
    }

    @Test
    public void testCheckDifferingStyles() {
        FastDateFormat shortShort = FastDateFormat.getDateTimeInstance((int)3, (int)3, (Locale)Locale.US);
        FastDateFormat shortLong = FastDateFormat.getDateTimeInstance((int)3, (int)1, (Locale)Locale.US);
        FastDateFormat longShort = FastDateFormat.getDateTimeInstance((int)1, (int)3, (Locale)Locale.US);
        FastDateFormat longLong = FastDateFormat.getDateTimeInstance((int)1, (int)1, (Locale)Locale.US);
        Assertions.assertNotEquals((Object)shortShort, (Object)shortLong);
        Assertions.assertNotEquals((Object)shortShort, (Object)longShort);
        Assertions.assertNotEquals((Object)shortShort, (Object)longLong);
        Assertions.assertNotEquals((Object)shortLong, (Object)longShort);
        Assertions.assertNotEquals((Object)shortLong, (Object)longLong);
        Assertions.assertNotEquals((Object)longShort, (Object)longLong);
    }

    @Test
    public void testDateDefaults() {
        Assertions.assertEquals((Object)FastDateFormat.getDateInstance((int)1, (Locale)Locale.CANADA), (Object)FastDateFormat.getDateInstance((int)1, (TimeZone)TimeZone.getDefault(), (Locale)Locale.CANADA));
        Assertions.assertEquals((Object)FastDateFormat.getDateInstance((int)1, (TimeZone)TimeZone.getTimeZone("America/New_York")), (Object)FastDateFormat.getDateInstance((int)1, (TimeZone)TimeZone.getTimeZone("America/New_York"), (Locale)Locale.getDefault()));
        Assertions.assertEquals((Object)FastDateFormat.getDateInstance((int)1), (Object)FastDateFormat.getDateInstance((int)1, (TimeZone)TimeZone.getDefault(), (Locale)Locale.getDefault()));
    }

    @Test
    public void testTimeDefaults() {
        Assertions.assertEquals((Object)FastDateFormat.getTimeInstance((int)1, (Locale)Locale.CANADA), (Object)FastDateFormat.getTimeInstance((int)1, (TimeZone)TimeZone.getDefault(), (Locale)Locale.CANADA));
        Assertions.assertEquals((Object)FastDateFormat.getTimeInstance((int)1, (TimeZone)TimeZone.getTimeZone("America/New_York")), (Object)FastDateFormat.getTimeInstance((int)1, (TimeZone)TimeZone.getTimeZone("America/New_York"), (Locale)Locale.getDefault()));
        Assertions.assertEquals((Object)FastDateFormat.getTimeInstance((int)1), (Object)FastDateFormat.getTimeInstance((int)1, (TimeZone)TimeZone.getDefault(), (Locale)Locale.getDefault()));
    }

    @Test
    public void testTimeDateDefaults() {
        Assertions.assertEquals((Object)FastDateFormat.getDateTimeInstance((int)1, (int)2, (Locale)Locale.CANADA), (Object)FastDateFormat.getDateTimeInstance((int)1, (int)2, (TimeZone)TimeZone.getDefault(), (Locale)Locale.CANADA));
        Assertions.assertEquals((Object)FastDateFormat.getDateTimeInstance((int)1, (int)2, (TimeZone)TimeZone.getTimeZone("America/New_York")), (Object)FastDateFormat.getDateTimeInstance((int)1, (int)2, (TimeZone)TimeZone.getTimeZone("America/New_York"), (Locale)Locale.getDefault()));
        Assertions.assertEquals((Object)FastDateFormat.getDateTimeInstance((int)1, (int)2), (Object)FastDateFormat.getDateTimeInstance((int)1, (int)2, (TimeZone)TimeZone.getDefault(), (Locale)Locale.getDefault()));
    }

    @Test
    public void testParseSync() throws InterruptedException {
        String pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS";
        final SimpleDateFormat inner = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        Format sdf = new Format(){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition fieldPosition) {
                1 var4_4 = this;
                synchronized (var4_4) {
                    return inner.format(obj, toAppendTo, fieldPosition);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object parseObject(String source, ParsePosition pos) {
                1 var3_3 = this;
                synchronized (var3_3) {
                    return inner.parseObject(source, pos);
                }
            }
        };
        AtomicLongArray sdfTime = this.measureTime(sdf, sdf);
        FastDateFormat fdf = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSS");
        AtomicLongArray fdfTime = this.measureTime((Format)fdf, (Format)fdf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AtomicLongArray measureTime(Format printer, Format parser) throws InterruptedException {
        ExecutorService pool = Executors.newFixedThreadPool(10);
        AtomicInteger failures = new AtomicInteger(0);
        AtomicLongArray totalElapsed = new AtomicLongArray(2);
        try {
            for (int i = 0; i < 10; ++i) {
                pool.submit(() -> {
                    for (int j = 0; j < 10000; ++j) {
                        try {
                            Date date = new Date();
                            long t0 = System.currentTimeMillis();
                            String formattedDate = printer.format(date);
                            totalElapsed.addAndGet(0, System.currentTimeMillis() - t0);
                            long t1 = System.currentTimeMillis();
                            Object pd = parser.parseObject(formattedDate);
                            totalElapsed.addAndGet(1, System.currentTimeMillis() - t1);
                            if (date.equals(pd)) continue;
                            failures.incrementAndGet();
                            continue;
                        }
                        catch (Exception e) {
                            failures.incrementAndGet();
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
        finally {
            pool.shutdown();
            if (!pool.awaitTermination(30L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                Assertions.fail((String)"did not complete tasks");
            }
        }
        Assertions.assertEquals((int)0, (int)failures.get());
        return totalElapsed;
    }

    @Test
    public void testLANG_954() {
        String pattern = "yyyy-MM-dd'T'";
        FastDateFormat.getInstance((String)"yyyy-MM-dd'T'");
    }

    @Test
    public void testLANG_1152() {
        TimeZone utc = FastTimeZone.getGmtTimeZone();
        Date date = new Date(Long.MAX_VALUE);
        String dateAsString = FastDateFormat.getInstance((String)"yyyy-MM-dd", (TimeZone)utc, (Locale)Locale.US).format(date);
        Assertions.assertEquals((Object)"292278994-08-17", (Object)dateAsString);
        dateAsString = FastDateFormat.getInstance((String)"dd/MM/yyyy", (TimeZone)utc, (Locale)Locale.US).format(date);
        Assertions.assertEquals((Object)"17/08/292278994", (Object)dateAsString);
    }

    @Test
    public void testLANG_1267() {
        FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    }
}

