/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.tuple;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ImmutablePairTest {
    @Test
    public void testEmptyArrayLength() {
        ImmutablePair[] empty = ImmutablePair.EMPTY_ARRAY;
        Assertions.assertEquals((int)0, (int)empty.length);
    }

    @Test
    public void testEmptyArrayGenerics() {
        ImmutablePair[] empty = ImmutablePair.emptyArray();
        Assertions.assertEquals((int)0, (int)empty.length);
    }

    @Test
    public void testBasic() {
        ImmutablePair oldPair = new ImmutablePair((Object)0, (Object)"foo");
        for (int i = 0; i < 4; ++i) {
            ImmutablePair nowPair = ImmutablePair.of((Map.Entry)oldPair);
            Assertions.assertEquals((int)0, (int)((Integer)nowPair.left));
            Assertions.assertEquals((int)0, (int)((Integer)nowPair.getLeft()));
            Assertions.assertEquals((Object)"foo", (Object)nowPair.right);
            Assertions.assertEquals((Object)"foo", (Object)nowPair.getRight());
            Assertions.assertEquals((Object)oldPair, (Object)nowPair);
            oldPair = nowPair;
        }
        ImmutablePair oldPair2 = new ImmutablePair(null, (Object)"bar");
        for (int i = 0; i < 4; ++i) {
            ImmutablePair nowPair2 = ImmutablePair.of((Map.Entry)oldPair2);
            Assertions.assertNull((Object)nowPair2.left);
            Assertions.assertNull((Object)nowPair2.getLeft());
            Assertions.assertEquals((Object)"bar", (Object)nowPair2.right);
            Assertions.assertEquals((Object)"bar", (Object)nowPair2.getRight());
            oldPair2 = nowPair2;
        }
    }

    @Test
    public void testEquals() {
        Assertions.assertEquals((Object)ImmutablePair.of(null, (Object)"foo"), (Object)ImmutablePair.of(null, (Object)"foo"));
        Assertions.assertNotEquals((Object)ImmutablePair.of((Object)"foo", (Object)0), (Object)ImmutablePair.of((Object)"foo", null));
        Assertions.assertNotEquals((Object)ImmutablePair.of((Object)"foo", (Object)"bar"), (Object)ImmutablePair.of((Object)"xyz", (Object)"bar"));
        ImmutablePair p = ImmutablePair.of((Object)"foo", (Object)"bar");
        Assertions.assertEquals((Object)p, (Object)p);
        Assertions.assertNotEquals((Object)p, (Object)new Object());
    }

    @Test
    public void testHashCode() {
        Assertions.assertEquals((int)ImmutablePair.of(null, (Object)"foo").hashCode(), (int)ImmutablePair.of(null, (Object)"foo").hashCode());
    }

    @Test
    public void testNullPairEquals() {
        Assertions.assertEquals((Object)ImmutablePair.nullPair(), (Object)ImmutablePair.nullPair());
    }

    @Test
    public void testNullPairKey() {
        Assertions.assertNull((Object)ImmutablePair.nullPair().getKey());
    }

    @Test
    public void testNullPairLeft() {
        Assertions.assertNull((Object)ImmutablePair.nullPair().getLeft());
    }

    @Test
    public void testNullPairRight() {
        Assertions.assertNull((Object)ImmutablePair.nullPair().getRight());
    }

    @Test
    public void testNullPairSame() {
        Assertions.assertSame((Object)ImmutablePair.nullPair(), (Object)ImmutablePair.nullPair());
    }

    @Test
    public void testNullPairTyped() {
        ImmutablePair pair = ImmutablePair.nullPair();
        Assertions.assertNotNull((Object)pair);
    }

    @Test
    public void testNullPairValue() {
        Assertions.assertNull((Object)ImmutablePair.nullPair().getValue());
    }

    @Test
    public void testPairOfMapEntry() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(0, "foo");
        Map.Entry entry = map.entrySet().iterator().next();
        ImmutablePair pair = ImmutablePair.of(entry);
        Assertions.assertEquals((Integer)((Integer)entry.getKey()), (Integer)((Integer)pair.getLeft()));
        Assertions.assertEquals(entry.getValue(), (Object)pair.getRight());
    }

    @Test
    public void testPairOfObjects() {
        ImmutablePair pair = ImmutablePair.of((Object)0, (Object)"foo");
        Assertions.assertEquals((int)0, (int)((Integer)pair.left));
        Assertions.assertEquals((int)0, (int)((Integer)pair.getLeft()));
        Assertions.assertEquals((Object)"foo", (Object)pair.right);
        Assertions.assertEquals((Object)"foo", (Object)pair.getRight());
        ImmutablePair pair2 = ImmutablePair.of(null, (Object)"bar");
        Assertions.assertNull((Object)pair2.left);
        Assertions.assertNull((Object)pair2.getLeft());
        Assertions.assertEquals((Object)"bar", (Object)pair2.right);
        Assertions.assertEquals((Object)"bar", (Object)pair2.getRight());
        ImmutablePair pair3 = ImmutablePair.of(null, null);
        Assertions.assertNull((Object)pair3.left);
        Assertions.assertNull((Object)pair3.right);
    }

    @Test
    public void testSerialization() throws Exception {
        ImmutablePair origPair = ImmutablePair.of((Object)0, (Object)"foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(origPair);
        ImmutablePair deserializedPair = (ImmutablePair)new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray())).readObject();
        Assertions.assertEquals((Object)origPair, (Object)deserializedPair);
        Assertions.assertEquals((int)origPair.hashCode(), (int)deserializedPair.hashCode());
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"(null,null)", (Object)ImmutablePair.of(null, null).toString());
        Assertions.assertEquals((Object)"(null,two)", (Object)ImmutablePair.of(null, (Object)"two").toString());
        Assertions.assertEquals((Object)"(one,null)", (Object)ImmutablePair.of((Object)"one", null).toString());
        Assertions.assertEquals((Object)"(one,two)", (Object)ImmutablePair.of((Object)"one", (Object)"two").toString());
    }

    @Test
    public void testUseAsKeyOfHashMap() {
        HashMap<ImmutablePair, String> map = new HashMap<ImmutablePair, String>();
        Object o1 = new Object();
        Object o2 = new Object();
        ImmutablePair key1 = ImmutablePair.of((Object)o1, (Object)o2);
        String value1 = "a1";
        map.put(key1, "a1");
        Assertions.assertEquals((Object)"a1", map.get(key1));
        Assertions.assertEquals((Object)"a1", map.get(ImmutablePair.of((Object)o1, (Object)o2)));
    }

    @Test
    public void testUseAsKeyOfTreeMap() {
        TreeMap<ImmutablePair, String> map = new TreeMap<ImmutablePair, String>();
        map.put(ImmutablePair.of((Object)1, (Object)2), "12");
        map.put(ImmutablePair.of((Object)1, (Object)1), "11");
        map.put(ImmutablePair.of((Object)0, (Object)1), "01");
        ArrayList<ImmutablePair> expected = new ArrayList<ImmutablePair>();
        expected.add(ImmutablePair.of((Object)0, (Object)1));
        expected.add(ImmutablePair.of((Object)1, (Object)1));
        expected.add(ImmutablePair.of((Object)1, (Object)2));
        Iterator it = map.entrySet().iterator();
        for (ImmutablePair item : expected) {
            Map.Entry entry = it.next();
            Assertions.assertEquals((Object)item, entry.getKey());
            Assertions.assertEquals((Object)(item.getLeft() + "" + item.getRight()), entry.getValue());
        }
    }

    @Test
    public void testComparableLeftOnly() {
        Pair pair1 = ImmutablePair.left((Object)"A");
        Pair pair2 = ImmutablePair.left((Object)"B");
        Assertions.assertEquals((Object)"A", (Object)pair1.getLeft());
        Assertions.assertEquals((Object)"B", (Object)pair2.getLeft());
        Assertions.assertEquals((int)0, (int)pair1.compareTo(pair1));
        Assertions.assertTrue((pair1.compareTo(pair2) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)pair2.compareTo(pair2));
        Assertions.assertTrue((pair2.compareTo(pair1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testComparableRightOnly() {
        Pair pair1 = ImmutablePair.right((Object)"A");
        Pair pair2 = ImmutablePair.right((Object)"B");
        Assertions.assertEquals((Object)"A", (Object)pair1.getRight());
        Assertions.assertEquals((Object)"B", (Object)pair2.getRight());
        Assertions.assertEquals((int)0, (int)pair1.compareTo(pair1));
        Assertions.assertTrue((pair1.compareTo(pair2) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)pair2.compareTo(pair2));
        Assertions.assertTrue((pair2.compareTo(pair1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testToStringLeft() {
        Pair pair = ImmutablePair.left((Object)"Key");
        Assertions.assertEquals((Object)"(Key,null)", (Object)pair.toString());
    }

    @Test
    public void testToStringRight() {
        Pair pair = ImmutablePair.right((Object)"Value");
        Assertions.assertEquals((Object)"(null,Value)", (Object)pair.toString());
    }
}

