/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.tuple;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.MutablePair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MutablePairTest {
    @Test
    public void testEmptyArrayLength() {
        MutablePair[] empty = MutablePair.EMPTY_ARRAY;
        Assertions.assertEquals((int)0, (int)empty.length);
    }

    @Test
    public void testEmptyArrayGenerics() {
        MutablePair[] empty = MutablePair.emptyArray();
        Assertions.assertEquals((int)0, (int)empty.length);
    }

    @Test
    public void testBasic() {
        MutablePair oldPair = new MutablePair((Object)0, (Object)"foo");
        for (int i = 0; i < 4; ++i) {
            MutablePair nowPair = MutablePair.of((Map.Entry)oldPair);
            Assertions.assertEquals((int)0, (int)((Integer)nowPair.left));
            Assertions.assertEquals((int)0, (int)((Integer)nowPair.getLeft()));
            Assertions.assertEquals((Object)"foo", (Object)nowPair.right);
            Assertions.assertEquals((Object)"foo", (Object)nowPair.getRight());
            Assertions.assertEquals((Object)oldPair, (Object)nowPair);
            oldPair = nowPair;
        }
        MutablePair oldPair2 = new MutablePair(null, (Object)"bar");
        for (int i = 0; i < 4; ++i) {
            MutablePair nowPair2 = MutablePair.of((Map.Entry)oldPair2);
            Assertions.assertNull((Object)nowPair2.left);
            Assertions.assertNull((Object)nowPair2.getLeft());
            Assertions.assertEquals((Object)"bar", (Object)nowPair2.right);
            Assertions.assertEquals((Object)"bar", (Object)nowPair2.getRight());
            oldPair2 = nowPair2;
        }
    }

    @Test
    public void testDefault() {
        MutablePair pair = new MutablePair();
        Assertions.assertNull((Object)pair.getLeft());
        Assertions.assertNull((Object)pair.getRight());
    }

    @Test
    public void testEquals() {
        Assertions.assertEquals((Object)MutablePair.of(null, (Object)"foo"), (Object)MutablePair.of(null, (Object)"foo"));
        Assertions.assertNotEquals((Object)MutablePair.of((Object)"foo", (Object)0), (Object)MutablePair.of((Object)"foo", null));
        Assertions.assertNotEquals((Object)MutablePair.of((Object)"foo", (Object)"bar"), (Object)MutablePair.of((Object)"xyz", (Object)"bar"));
        MutablePair p = MutablePair.of((Object)"foo", (Object)"bar");
        Assertions.assertEquals((Object)p, (Object)p);
        Assertions.assertNotEquals((Object)p, (Object)new Object());
    }

    @Test
    public void testHashCode() {
        Assertions.assertEquals((int)MutablePair.of(null, (Object)"foo").hashCode(), (int)MutablePair.of(null, (Object)"foo").hashCode());
    }

    @Test
    public void testMutate() {
        MutablePair pair = new MutablePair((Object)0, (Object)"foo");
        pair.setLeft((Object)42);
        pair.setRight((Object)"bar");
        Assertions.assertEquals((int)42, (int)((Integer)pair.getLeft()));
        Assertions.assertEquals((Object)"bar", (Object)pair.getRight());
    }

    @Test
    public void testPairOfMapEntry() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(0, "foo");
        Map.Entry entry = map.entrySet().iterator().next();
        MutablePair pair = MutablePair.of(entry);
        Assertions.assertEquals((Integer)((Integer)entry.getKey()), (Integer)((Integer)pair.getLeft()));
        Assertions.assertEquals(entry.getValue(), (Object)pair.getRight());
    }

    @Test
    public void testPairOfObjects() {
        MutablePair pair = MutablePair.of((Object)0, (Object)"foo");
        Assertions.assertEquals((int)0, (int)((Integer)pair.getLeft()));
        Assertions.assertEquals((Object)"foo", (Object)pair.getRight());
        MutablePair pair2 = MutablePair.of(null, (Object)"bar");
        Assertions.assertNull((Object)pair2.getLeft());
        Assertions.assertEquals((Object)"bar", (Object)pair2.getRight());
        MutablePair pair3 = MutablePair.of(null, null);
        Assertions.assertNull((Object)pair3.left);
        Assertions.assertNull((Object)pair3.right);
    }

    @Test
    public void testSerialization() throws Exception {
        MutablePair origPair = MutablePair.of((Object)0, (Object)"foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(origPair);
        MutablePair deserializedPair = (MutablePair)new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray())).readObject();
        Assertions.assertEquals((Object)origPair, (Object)deserializedPair);
        Assertions.assertEquals((int)origPair.hashCode(), (int)deserializedPair.hashCode());
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"(null,null)", (Object)MutablePair.of(null, null).toString());
        Assertions.assertEquals((Object)"(null,two)", (Object)MutablePair.of(null, (Object)"two").toString());
        Assertions.assertEquals((Object)"(one,null)", (Object)MutablePair.of((Object)"one", null).toString());
        Assertions.assertEquals((Object)"(one,two)", (Object)MutablePair.of((Object)"one", (Object)"two").toString());
    }
}

