/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.CloneFailedException;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.text.StrBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ObjectUtilsTest {
    private static final String FOO = "foo";
    private static final String BAR = "bar";
    private static final String[] NON_EMPTY_ARRAY = new String[]{"foo", "bar"};
    private static final List<String> NON_EMPTY_LIST = Arrays.asList(NON_EMPTY_ARRAY);
    private static final Set<String> NON_EMPTY_SET = new HashSet<String>(NON_EMPTY_LIST);
    private static final Map<String, String> NON_EMPTY_MAP = new HashMap<String, String>();

    @Test
    public void testAllNotNull() {
        Assertions.assertFalse((boolean)ObjectUtils.allNotNull((Object[])new Object[]{null}));
        Assertions.assertFalse((boolean)ObjectUtils.allNotNull((Object[])null));
        Assertions.assertFalse((boolean)ObjectUtils.allNotNull((Object[])new Object[]{null, null, null}));
        Assertions.assertFalse((boolean)ObjectUtils.allNotNull((Object[])new Object[]{null, FOO, BAR}));
        Assertions.assertFalse((boolean)ObjectUtils.allNotNull((Object[])new Object[]{FOO, BAR, null}));
        Assertions.assertFalse((boolean)ObjectUtils.allNotNull((Object[])new Object[]{FOO, BAR, null, FOO, BAR}));
        Assertions.assertTrue((boolean)ObjectUtils.allNotNull((Object[])new Object[0]));
        Assertions.assertTrue((boolean)ObjectUtils.allNotNull((Object[])new Object[]{FOO}));
        Assertions.assertTrue((boolean)ObjectUtils.allNotNull((Object[])new Object[]{FOO, BAR, 1, Boolean.TRUE, new Object(), new Object[0]}));
    }

    @Test
    public void testAllNull() {
        Assertions.assertTrue((boolean)ObjectUtils.allNull((Object[])new Object[0]));
        Assertions.assertTrue((boolean)ObjectUtils.allNull((Object[])new Object[]{null}));
        Assertions.assertTrue((boolean)ObjectUtils.allNull((Object[])null));
        Assertions.assertTrue((boolean)ObjectUtils.allNull((Object[])new Object[]{null, null, null}));
        Assertions.assertFalse((boolean)ObjectUtils.allNull((Object[])new Object[]{FOO}));
        Assertions.assertFalse((boolean)ObjectUtils.allNull((Object[])new Object[]{null, FOO, null}));
        Assertions.assertFalse((boolean)ObjectUtils.allNull((Object[])new Object[]{null, null, null, null, FOO, BAR}));
    }

    @Test
    public void testAnyNotNull() {
        Assertions.assertFalse((boolean)ObjectUtils.anyNotNull((Object[])new Object[0]));
        Assertions.assertFalse((boolean)ObjectUtils.anyNotNull((Object[])new Object[]{null}));
        Assertions.assertFalse((boolean)ObjectUtils.anyNotNull((Object[])null));
        Assertions.assertFalse((boolean)ObjectUtils.anyNotNull((Object[])new Object[]{null, null, null}));
        Assertions.assertTrue((boolean)ObjectUtils.anyNotNull((Object[])new Object[]{FOO}));
        Assertions.assertTrue((boolean)ObjectUtils.anyNotNull((Object[])new Object[]{null, FOO, null}));
        Assertions.assertTrue((boolean)ObjectUtils.anyNotNull((Object[])new Object[]{null, null, null, null, FOO, BAR}));
    }

    @Test
    public void testAnyNull() {
        Assertions.assertTrue((boolean)ObjectUtils.anyNull((Object[])new Object[]{null}));
        Assertions.assertTrue((boolean)ObjectUtils.anyNull((Object[])new Object[]{null, null, null}));
        Assertions.assertTrue((boolean)ObjectUtils.anyNull((Object[])new Object[]{null, FOO, BAR}));
        Assertions.assertTrue((boolean)ObjectUtils.anyNull((Object[])new Object[]{FOO, BAR, null}));
        Assertions.assertTrue((boolean)ObjectUtils.anyNull((Object[])new Object[]{FOO, BAR, null, FOO, BAR}));
        Assertions.assertFalse((boolean)ObjectUtils.anyNull((Object[])new Object[0]));
        Assertions.assertFalse((boolean)ObjectUtils.anyNull((Object[])new Object[]{FOO}));
        Assertions.assertFalse((boolean)ObjectUtils.anyNull((Object[])new Object[]{FOO, BAR, 1, Boolean.TRUE, new Object(), new Object[0]}));
    }

    @Test
    public void testCloneOfCloneable() {
        CloneableString string = new CloneableString("apache");
        CloneableString stringClone = (CloneableString)ObjectUtils.clone((Object)string);
        Assertions.assertEquals((Object)"apache", (Object)stringClone.getValue());
    }

    @Test
    public void testCloneOfNotCloneable() {
        String string = "apache";
        Assertions.assertNull((Object)ObjectUtils.clone((Object)"apache"));
    }

    @Test
    public void testCloneOfPrimitiveArray() {
        Assertions.assertArrayEquals((int[])new int[]{1}, (int[])((int[])ObjectUtils.clone((Object)new int[]{1})));
    }

    @Test
    public void testCloneOfStringArray() {
        Assertions.assertTrue((boolean)Arrays.deepEquals(new String[]{"string"}, (Object[])ObjectUtils.clone((Object)new String[]{"string"})));
    }

    @Test
    public void testCloneOfUncloneable() {
        UncloneableString string = new UncloneableString("apache");
        CloneFailedException e = (CloneFailedException)Assertions.assertThrows(CloneFailedException.class, () -> {
            UncloneableString cfr_ignored_0 = (UncloneableString)ObjectUtils.clone((Object)string);
        });
        Assertions.assertEquals(NoSuchMethodException.class, e.getCause().getClass());
    }

    @Test
    public void testComparatorMedian() {
        CharSequenceComparator cmp = new CharSequenceComparator();
        NonComparableCharSequence foo = new NonComparableCharSequence(FOO);
        NonComparableCharSequence bar = new NonComparableCharSequence(BAR);
        NonComparableCharSequence baz = new NonComparableCharSequence("baz");
        NonComparableCharSequence blah = new NonComparableCharSequence("blah");
        NonComparableCharSequence wah = new NonComparableCharSequence("wah");
        Assertions.assertSame((Object)foo, (Object)ObjectUtils.median((Comparator)cmp, (Object[])new CharSequence[]{foo}));
        Assertions.assertSame((Object)bar, (Object)ObjectUtils.median((Comparator)cmp, (Object[])new CharSequence[]{foo, bar}));
        Assertions.assertSame((Object)baz, (Object)ObjectUtils.median((Comparator)cmp, (Object[])new CharSequence[]{foo, bar, baz}));
        Assertions.assertSame((Object)baz, (Object)ObjectUtils.median((Comparator)cmp, (Object[])new CharSequence[]{foo, bar, baz, blah}));
        Assertions.assertSame((Object)blah, (Object)ObjectUtils.median((Comparator)cmp, (Object[])new CharSequence[]{foo, bar, baz, blah, wah}));
    }

    @Test
    public void testComparatorMedian_emptyItems() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            CharSequence cfr_ignored_0 = (CharSequence)ObjectUtils.median((Comparator)new CharSequenceComparator(), (Object[])new CharSequence[0]);
        });
    }

    @Test
    public void testComparatorMedian_nullComparator() {
        Assertions.assertThrows(NullPointerException.class, () -> {
            CharSequence cfr_ignored_0 = (CharSequence)ObjectUtils.median((Comparator)null, (Object[])new CharSequence[]{new NonComparableCharSequence(FOO)});
        });
    }

    @Test
    public void testComparatorMedian_nullItems() {
        Assertions.assertThrows(NullPointerException.class, () -> {
            CharSequence cfr_ignored_0 = (CharSequence)ObjectUtils.median((Comparator)new CharSequenceComparator(), (Object[])null);
        });
    }

    @Test
    public void testCompare() {
        Integer one = 1;
        Integer two = 2;
        Comparable nullValue = null;
        Assertions.assertEquals((int)0, (int)ObjectUtils.compare(nullValue, nullValue), (String)"Null Null false");
        Assertions.assertEquals((int)0, (int)ObjectUtils.compare(nullValue, nullValue, (boolean)true), (String)"Null Null true");
        Assertions.assertEquals((int)-1, (int)ObjectUtils.compare(nullValue, (Comparable)one), (String)"Null one false");
        Assertions.assertEquals((int)1, (int)ObjectUtils.compare(nullValue, (Comparable)one, (boolean)true), (String)"Null one true");
        Assertions.assertEquals((int)1, (int)ObjectUtils.compare((Comparable)one, nullValue), (String)"one Null false");
        Assertions.assertEquals((int)-1, (int)ObjectUtils.compare((Comparable)one, nullValue, (boolean)true), (String)"one Null true");
        Assertions.assertEquals((int)-1, (int)ObjectUtils.compare((Comparable)one, (Comparable)two), (String)"one two false");
        Assertions.assertEquals((int)-1, (int)ObjectUtils.compare((Comparable)one, (Comparable)two, (boolean)true), (String)"one two true");
    }

    @Test
    public void testConstMethods() {
        Assertions.assertTrue((boolean)ObjectUtils.CONST((boolean)true), (String)"CONST(boolean)");
        Assertions.assertEquals((byte)3, (byte)ObjectUtils.CONST((byte)3), (String)"CONST(byte)");
        Assertions.assertEquals((char)'\u0003', (char)ObjectUtils.CONST((char)'\u0003'), (String)"CONST(char)");
        Assertions.assertEquals((short)3, (short)ObjectUtils.CONST((short)3), (String)"CONST(short)");
        Assertions.assertEquals((int)3, (int)ObjectUtils.CONST((int)3), (String)"CONST(int)");
        Assertions.assertEquals((long)3L, (long)ObjectUtils.CONST((long)3L), (String)"CONST(long)");
        Assertions.assertEquals((float)3.0f, (float)ObjectUtils.CONST((float)3.0f), (String)"CONST(float)");
        Assertions.assertEquals((double)3.0, (double)ObjectUtils.CONST((double)3.0), (String)"CONST(double)");
        Assertions.assertEquals((Object)"abc", (Object)ObjectUtils.CONST((Object)"abc"), (String)"CONST(Object)");
        boolean MAGIC_FLAG = ObjectUtils.CONST((boolean)true);
        byte MAGIC_BYTE1 = ObjectUtils.CONST((byte)127);
        byte MAGIC_BYTE2 = ObjectUtils.CONST_BYTE((int)127);
        char MAGIC_CHAR = ObjectUtils.CONST((char)'a');
        short MAGIC_SHORT1 = ObjectUtils.CONST((short)123);
        short MAGIC_SHORT2 = ObjectUtils.CONST_SHORT((int)127);
        int MAGIC_INT = ObjectUtils.CONST((int)123);
        long MAGIC_LONG1 = ObjectUtils.CONST((long)123L);
        long MAGIC_LONG2 = ObjectUtils.CONST((int)3);
        float MAGIC_FLOAT = ObjectUtils.CONST((float)1.0f);
        double MAGIC_DOUBLE = ObjectUtils.CONST((double)1.0);
        String MAGIC_STRING = (String)ObjectUtils.CONST((Object)"abc");
        Assertions.assertTrue((boolean)MAGIC_FLAG);
        Assertions.assertEquals((int)127, (int)MAGIC_BYTE1);
        Assertions.assertEquals((int)127, (int)MAGIC_BYTE2);
        Assertions.assertEquals((char)'a', (char)MAGIC_CHAR);
        Assertions.assertEquals((int)123, (int)MAGIC_SHORT1);
        Assertions.assertEquals((int)127, (int)MAGIC_SHORT2);
        Assertions.assertEquals((int)123, (int)MAGIC_INT);
        Assertions.assertEquals((long)123L, (long)MAGIC_LONG1);
        Assertions.assertEquals((long)3L, (long)MAGIC_LONG2);
        Assertions.assertEquals((float)1.0f, (float)MAGIC_FLOAT);
        Assertions.assertEquals((double)1.0, (double)MAGIC_DOUBLE);
        Assertions.assertEquals((Object)"abc", (Object)MAGIC_STRING);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ObjectUtils.CONST_BYTE((int)-129), (String)"CONST_BYTE(-129): IllegalArgumentException should have been thrown.");
        Assertions.assertThrows(IllegalArgumentException.class, () -> ObjectUtils.CONST_BYTE((int)128), (String)"CONST_BYTE(128): IllegalArgumentException should have been thrown.");
        Assertions.assertThrows(IllegalArgumentException.class, () -> ObjectUtils.CONST_SHORT((int)-32769), (String)"CONST_SHORT(-32769): IllegalArgumentException should have been thrown.");
        Assertions.assertThrows(IllegalArgumentException.class, () -> ObjectUtils.CONST_BYTE((int)32768), (String)"CONST_SHORT(32768): IllegalArgumentException should have been thrown.");
    }

    @Test
    public void testConstructor() {
        Assertions.assertNotNull((Object)new ObjectUtils());
        Constructor<?>[] cons = ObjectUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(ObjectUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(ObjectUtils.class.getModifiers()));
    }

    @Test
    public void testDefaultIfNull() {
        String o = FOO;
        String dflt = BAR;
        Assertions.assertSame((Object)dflt, (Object)ObjectUtils.defaultIfNull(null, (Object)dflt), (String)"dflt was not returned when o was null");
        Assertions.assertSame((Object)o, (Object)ObjectUtils.defaultIfNull((Object)o, (Object)dflt), (String)"dflt was returned when o was not null");
        Assertions.assertSame((Object)dflt, (Object)ObjectUtils.getIfNull(null, () -> dflt), (String)"dflt was not returned when o was null");
        Assertions.assertSame((Object)o, (Object)ObjectUtils.getIfNull((Object)o, () -> dflt), (String)"dflt was returned when o was not null");
        Assertions.assertSame((Object)o, (Object)ObjectUtils.getIfNull((Object)FOO, () -> dflt), (String)"dflt was returned when o was not null");
        Assertions.assertSame((Object)o, (Object)ObjectUtils.getIfNull((Object)FOO, () -> dflt), (String)"dflt was returned when o was not null");
        MutableInt callsCounter = new MutableInt(0);
        Supplier<Object> countingDefaultSupplier = () -> {
            callsCounter.increment();
            return dflt;
        };
        ObjectUtils.getIfNull((Object)o, countingDefaultSupplier);
        Assertions.assertEquals((int)0, (Integer)callsCounter.getValue());
        ObjectUtils.getIfNull(null, countingDefaultSupplier);
        Assertions.assertEquals((int)1, (Integer)callsCounter.getValue());
    }

    @Test
    public void testEquals() {
        Assertions.assertTrue((boolean)ObjectUtils.equals(null, null), (String)"ObjectUtils.equals(null, null) returned false");
        Assertions.assertTrue((!ObjectUtils.equals((Object)FOO, null) ? 1 : 0) != 0, (String)"ObjectUtils.equals(\"foo\", null) returned true");
        Assertions.assertTrue((!ObjectUtils.equals(null, (Object)BAR) ? 1 : 0) != 0, (String)"ObjectUtils.equals(null, \"bar\") returned true");
        Assertions.assertTrue((!ObjectUtils.equals((Object)FOO, (Object)BAR) ? 1 : 0) != 0, (String)"ObjectUtils.equals(\"foo\", \"bar\") returned true");
        Assertions.assertTrue((boolean)ObjectUtils.equals((Object)FOO, (Object)FOO), (String)"ObjectUtils.equals(\"foo\", \"foo\") returned false");
    }

    @Test
    public void testFirstNonNull() {
        Assertions.assertEquals((Object)"", (Object)ObjectUtils.firstNonNull((Object[])new String[]{null, ""}));
        String firstNonNullGenerics = (String)ObjectUtils.firstNonNull((Object[])new String[]{null, null, "123", "456"});
        Assertions.assertEquals((Object)"123", (Object)firstNonNullGenerics);
        Assertions.assertEquals((Object)"123", (Object)ObjectUtils.firstNonNull((Object[])new String[]{"123", null, "456", null}));
        Assertions.assertSame((Object)Boolean.TRUE, (Object)ObjectUtils.firstNonNull((Object[])new Boolean[]{Boolean.TRUE}));
        Assertions.assertNull((Object)ObjectUtils.firstNonNull((Object[])new Object[0]));
        Assertions.assertNull((Object)ObjectUtils.firstNonNull((Object[])new Object[]{null, null}));
        Assertions.assertNull((Object)ObjectUtils.firstNonNull((Object[])new Object[]{null}));
        Assertions.assertNull((Object)ObjectUtils.firstNonNull((Object[])null));
    }

    @Test
    public void testGetFirstNonNull() {
        Assertions.assertEquals((Object)"", (Object)ObjectUtils.getFirstNonNull((Supplier[])new Supplier[]{() -> null, () -> ""}));
        Assertions.assertEquals((Object)"1", (Object)ObjectUtils.getFirstNonNull((Supplier[])new Supplier[]{() -> null, () -> "1", () -> "2", () -> null}));
        Assertions.assertEquals((Object)"123", (Object)ObjectUtils.getFirstNonNull((Supplier[])new Supplier[]{() -> "123", () -> null, () -> "456"}));
        Assertions.assertEquals((Object)"123", (Object)ObjectUtils.getFirstNonNull((Supplier[])new Supplier[]{() -> null, () -> "123", () -> (String)Assertions.fail((String)"Supplier after first non-null value should not be evaluated")}));
        Assertions.assertNull((Object)ObjectUtils.getFirstNonNull((Supplier[])new Supplier[]{null, () -> null}));
        Assertions.assertNull((Object)ObjectUtils.getFirstNonNull((Supplier[])new Supplier[0]));
        Assertions.assertNull((Object)ObjectUtils.getFirstNonNull((Supplier[])new Supplier[]{null}));
        Assertions.assertNull((Object)ObjectUtils.getFirstNonNull((Supplier[])null));
        Assertions.assertEquals((int)1, (Integer)((Integer)ObjectUtils.getFirstNonNull((Supplier[])new Supplier[]{() -> null, () -> 1})));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)ObjectUtils.getFirstNonNull((Supplier[])new Supplier[]{() -> null, () -> Boolean.TRUE}));
    }

    @Test
    public void testHashCode() {
        Assertions.assertEquals((int)0, (int)ObjectUtils.hashCode(null));
        Assertions.assertEquals((int)"a".hashCode(), (int)ObjectUtils.hashCode((Object)"a"));
    }

    @Test
    public void testHashCodeMulti_multiple_emptyArray() {
        Object[] array = new Object[]{};
        Assertions.assertEquals((int)1, (int)ObjectUtils.hashCodeMulti((Object[])array));
    }

    @Test
    public void testHashCodeMulti_multiple_likeList() {
        ArrayList list0 = new ArrayList(Collections.emptyList());
        Assertions.assertEquals((int)list0.hashCode(), (int)ObjectUtils.hashCodeMulti((Object[])new Object[0]));
        ArrayList<String> list1 = new ArrayList<String>(Collections.singletonList("a"));
        Assertions.assertEquals((int)list1.hashCode(), (int)ObjectUtils.hashCodeMulti((Object[])new Object[]{"a"}));
        ArrayList<String> list2 = new ArrayList<String>(Arrays.asList("a", "b"));
        Assertions.assertEquals((int)list2.hashCode(), (int)ObjectUtils.hashCodeMulti((Object[])new Object[]{"a", "b"}));
        ArrayList<String> list3 = new ArrayList<String>(Arrays.asList("a", "b", "c"));
        Assertions.assertEquals((int)list3.hashCode(), (int)ObjectUtils.hashCodeMulti((Object[])new Object[]{"a", "b", "c"}));
    }

    @Test
    public void testHashCodeMulti_multiple_nullArray() {
        Object[] array = null;
        Assertions.assertEquals((int)1, (int)ObjectUtils.hashCodeMulti(array));
    }

    @Test
    public void testIdentityToStringAppendable() throws IOException {
        Integer i = 121;
        String expected = "java.lang.Integer@" + Integer.toHexString(System.identityHashCode(i));
        StringBuilder appendable = new StringBuilder();
        ObjectUtils.identityToString((Appendable)appendable, (Object)i);
        Assertions.assertEquals((Object)expected, (Object)((Object)appendable).toString());
        Assertions.assertThrows(NullPointerException.class, () -> ObjectUtils.identityToString((Appendable)null, (Object)"tmp"));
        Assertions.assertThrows(NullPointerException.class, () -> ObjectUtils.identityToString((Appendable)new StringBuilder(), null));
    }

    @Test
    public void testIdentityToStringInteger() {
        Integer i = 90;
        String expected = "java.lang.Integer@" + Integer.toHexString(System.identityHashCode(i));
        Assertions.assertEquals((Object)expected, (Object)ObjectUtils.identityToString((Object)i));
    }

    @Test
    public void testIdentityToStringObjectNull() {
        Assertions.assertNull((Object)ObjectUtils.identityToString(null));
    }

    @Test
    public void testIdentityToStringStrBuilder() {
        Integer i = 102;
        String expected = "java.lang.Integer@" + Integer.toHexString(System.identityHashCode(i));
        StrBuilder builder = new StrBuilder();
        ObjectUtils.identityToString((StrBuilder)builder, (Object)i);
        Assertions.assertEquals((Object)expected, (Object)builder.toString());
        Assertions.assertThrows(NullPointerException.class, () -> ObjectUtils.identityToString((StrBuilder)null, (Object)"tmp"));
        Assertions.assertThrows(NullPointerException.class, () -> ObjectUtils.identityToString((StrBuilder)new StrBuilder(), null));
    }

    @Test
    public void testIdentityToStringString() {
        Assertions.assertEquals((Object)("java.lang.String@" + Integer.toHexString(System.identityHashCode(FOO))), (Object)ObjectUtils.identityToString((Object)FOO));
    }

    @Test
    public void testIdentityToStringStringBuffer() {
        Integer i = 45;
        String expected = "java.lang.Integer@" + Integer.toHexString(System.identityHashCode(i));
        StringBuffer buffer = new StringBuffer();
        ObjectUtils.identityToString((StringBuffer)buffer, (Object)i);
        Assertions.assertEquals((Object)expected, (Object)buffer.toString());
        Assertions.assertThrows(NullPointerException.class, () -> ObjectUtils.identityToString((StringBuffer)null, (Object)"tmp"));
        Assertions.assertThrows(NullPointerException.class, () -> ObjectUtils.identityToString((StringBuffer)new StringBuffer(), null));
    }

    @Test
    public void testIdentityToStringStringBuilder() {
        Integer i = 90;
        String expected = "java.lang.Integer@" + Integer.toHexString(System.identityHashCode(i));
        StringBuilder builder = new StringBuilder();
        ObjectUtils.identityToString((StringBuilder)builder, (Object)i);
        Assertions.assertEquals((Object)expected, (Object)builder.toString());
    }

    @Test
    public void testIdentityToStringStringBuilderInUse() {
        Integer i = 90;
        String expected = "ABC = java.lang.Integer@" + Integer.toHexString(System.identityHashCode(i));
        StringBuilder builder = new StringBuilder("ABC = ");
        ObjectUtils.identityToString((StringBuilder)builder, (Object)i);
        Assertions.assertEquals((Object)expected, (Object)builder.toString());
    }

    @Test
    public void testIdentityToStringStringBuilderNullStringBuilder() {
        Assertions.assertThrows(NullPointerException.class, () -> ObjectUtils.identityToString((StringBuilder)null, (Object)"tmp"));
    }

    @Test
    public void testIdentityToStringStringBuilderNullValue() {
        Assertions.assertThrows(NullPointerException.class, () -> ObjectUtils.identityToString((StringBuilder)new StringBuilder(), null));
    }

    @Test
    public void testIsEmpty() {
        Assertions.assertTrue((boolean)ObjectUtils.isEmpty(null));
        Assertions.assertTrue((boolean)ObjectUtils.isEmpty((Object)""));
        Assertions.assertTrue((boolean)ObjectUtils.isEmpty((Object)new int[0]));
        Assertions.assertTrue((boolean)ObjectUtils.isEmpty(Collections.emptyList()));
        Assertions.assertTrue((boolean)ObjectUtils.isEmpty(Collections.emptySet()));
        Assertions.assertTrue((boolean)ObjectUtils.isEmpty(Collections.emptyMap()));
        Assertions.assertFalse((boolean)ObjectUtils.isEmpty((Object)"  "));
        Assertions.assertFalse((boolean)ObjectUtils.isEmpty((Object)"ab"));
        Assertions.assertFalse((boolean)ObjectUtils.isEmpty((Object)NON_EMPTY_ARRAY));
        Assertions.assertFalse((boolean)ObjectUtils.isEmpty(NON_EMPTY_LIST));
        Assertions.assertFalse((boolean)ObjectUtils.isEmpty(NON_EMPTY_SET));
        Assertions.assertFalse((boolean)ObjectUtils.isEmpty(NON_EMPTY_MAP));
    }

    @Test
    public void testIsNotEmpty() {
        Assertions.assertFalse((boolean)ObjectUtils.isNotEmpty(null));
        Assertions.assertFalse((boolean)ObjectUtils.isNotEmpty((Object)""));
        Assertions.assertFalse((boolean)ObjectUtils.isNotEmpty((Object)new int[0]));
        Assertions.assertFalse((boolean)ObjectUtils.isNotEmpty(Collections.emptyList()));
        Assertions.assertFalse((boolean)ObjectUtils.isNotEmpty(Collections.emptySet()));
        Assertions.assertFalse((boolean)ObjectUtils.isNotEmpty(Collections.emptyMap()));
        Assertions.assertTrue((boolean)ObjectUtils.isNotEmpty((Object)"  "));
        Assertions.assertTrue((boolean)ObjectUtils.isNotEmpty((Object)"ab"));
        Assertions.assertTrue((boolean)ObjectUtils.isNotEmpty((Object)NON_EMPTY_ARRAY));
        Assertions.assertTrue((boolean)ObjectUtils.isNotEmpty(NON_EMPTY_LIST));
        Assertions.assertTrue((boolean)ObjectUtils.isNotEmpty(NON_EMPTY_SET));
        Assertions.assertTrue((boolean)ObjectUtils.isNotEmpty(NON_EMPTY_MAP));
    }

    @Test
    public void testMax() {
        Calendar calendar = Calendar.getInstance();
        Date nonNullComparable1 = calendar.getTime();
        Date nonNullComparable2 = calendar.getTime();
        Comparable[] nullArray = null;
        calendar.set(1, calendar.get(1) - 1);
        Date minComparable = calendar.getTime();
        Assertions.assertNotSame((Object)nonNullComparable1, (Object)nonNullComparable2);
        Assertions.assertNull((Object)ObjectUtils.max((Comparable[])new String[]{null}));
        Assertions.assertNull((Object)ObjectUtils.max(nullArray));
        Assertions.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.max((Comparable[])new Date[]{null, nonNullComparable1}));
        Assertions.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.max((Comparable[])new Date[]{nonNullComparable1, null}));
        Assertions.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.max((Comparable[])new Date[]{null, nonNullComparable1, null}));
        Assertions.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.max((Comparable[])new Date[]{nonNullComparable1, nonNullComparable2}));
        Assertions.assertSame((Object)nonNullComparable2, (Object)ObjectUtils.max((Comparable[])new Date[]{nonNullComparable2, nonNullComparable1}));
        Assertions.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.max((Comparable[])new Date[]{nonNullComparable1, minComparable}));
        Assertions.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.max((Comparable[])new Date[]{minComparable, nonNullComparable1}));
        Assertions.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.max((Comparable[])new Date[]{null, minComparable, null, nonNullComparable1}));
        Assertions.assertNull((Object)ObjectUtils.max((Comparable[])new Comparable[]{null, null}));
    }

    @Test
    public void testMedian() {
        Assertions.assertEquals((Object)FOO, (Object)ObjectUtils.median((Comparable[])new String[]{FOO}));
        Assertions.assertEquals((Object)BAR, (Object)ObjectUtils.median((Comparable[])new String[]{FOO, BAR}));
        Assertions.assertEquals((Object)"baz", (Object)ObjectUtils.median((Comparable[])new String[]{FOO, BAR, "baz"}));
        Assertions.assertEquals((Object)"baz", (Object)ObjectUtils.median((Comparable[])new String[]{FOO, BAR, "baz", "blah"}));
        Assertions.assertEquals((Object)"blah", (Object)ObjectUtils.median((Comparable[])new String[]{FOO, BAR, "baz", "blah", "wah"}));
        Assertions.assertEquals((Integer)5, (Integer)((Integer)ObjectUtils.median((Comparable[])new Integer[]{1, 5, 10})));
        Assertions.assertEquals((Integer)7, (Integer)((Integer)ObjectUtils.median((Comparable[])new Integer[]{5, 6, 7, 8, 9})));
        Assertions.assertEquals((Integer)6, (Integer)((Integer)ObjectUtils.median((Comparable[])new Integer[]{5, 6, 7, 8})));
    }

    @Test
    public void testMedian_emptyItems() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ObjectUtils.median((Comparable[])new String[0]));
    }

    @Test
    public void testMedian_nullItems() {
        Assertions.assertThrows(NullPointerException.class, () -> {
            String cfr_ignored_0 = (String)((Object)ObjectUtils.median((Comparable[])((String[])null)));
        });
    }

    @Test
    public void testMin() {
        Calendar calendar = Calendar.getInstance();
        Date nonNullComparable1 = calendar.getTime();
        Date nonNullComparable2 = calendar.getTime();
        Comparable[] nullArray = null;
        calendar.set(1, calendar.get(1) - 1);
        Date minComparable = calendar.getTime();
        Assertions.assertNotSame((Object)nonNullComparable1, (Object)nonNullComparable2);
        Assertions.assertNull((Object)ObjectUtils.min((Comparable[])new String[]{null}));
        Assertions.assertNull((Object)ObjectUtils.min(nullArray));
        Assertions.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.min((Comparable[])new Date[]{null, nonNullComparable1}));
        Assertions.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.min((Comparable[])new Date[]{nonNullComparable1, null}));
        Assertions.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.min((Comparable[])new Date[]{null, nonNullComparable1, null}));
        Assertions.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.min((Comparable[])new Date[]{nonNullComparable1, nonNullComparable2}));
        Assertions.assertSame((Object)nonNullComparable2, (Object)ObjectUtils.min((Comparable[])new Date[]{nonNullComparable2, nonNullComparable1}));
        Assertions.assertSame((Object)minComparable, (Object)ObjectUtils.min((Comparable[])new Date[]{nonNullComparable1, minComparable}));
        Assertions.assertSame((Object)minComparable, (Object)ObjectUtils.min((Comparable[])new Date[]{minComparable, nonNullComparable1}));
        Assertions.assertSame((Object)minComparable, (Object)ObjectUtils.min((Comparable[])new Date[]{null, nonNullComparable1, null, minComparable}));
        Assertions.assertNull((Object)ObjectUtils.min((Comparable[])new Comparable[]{null, null}));
    }

    @Test
    public void testMode() {
        Assertions.assertNull((Object)ObjectUtils.mode((Object[])null));
        Assertions.assertNull((Object)ObjectUtils.mode((Object[])new Object[0]));
        Assertions.assertNull((Object)ObjectUtils.mode((Object[])new String[]{FOO, BAR, "baz"}));
        Assertions.assertNull((Object)ObjectUtils.mode((Object[])new String[]{FOO, BAR, "baz", FOO, BAR}));
        Assertions.assertEquals((Object)FOO, (Object)ObjectUtils.mode((Object[])new String[]{FOO, BAR, "baz", FOO}));
        Assertions.assertEquals((Object)9, (Object)ObjectUtils.mode((Object[])new Serializable[]{FOO, BAR, "baz", Integer.valueOf(9), Integer.valueOf(10), Integer.valueOf(9)}));
    }

    @Test
    public void testNotEqual() {
        Assertions.assertFalse((boolean)ObjectUtils.notEqual(null, null), (String)"ObjectUtils.notEqual(null, null) returned false");
        Assertions.assertTrue((boolean)ObjectUtils.notEqual((Object)FOO, null), (String)"ObjectUtils.notEqual(\"foo\", null) returned true");
        Assertions.assertTrue((boolean)ObjectUtils.notEqual(null, (Object)BAR), (String)"ObjectUtils.notEqual(null, \"bar\") returned true");
        Assertions.assertTrue((boolean)ObjectUtils.notEqual((Object)FOO, (Object)BAR), (String)"ObjectUtils.notEqual(\"foo\", \"bar\") returned true");
        Assertions.assertFalse((boolean)ObjectUtils.notEqual((Object)FOO, (Object)FOO), (String)"ObjectUtils.notEqual(\"foo\", \"foo\") returned false");
    }

    @Test
    public void testNull() {
        Assertions.assertNotNull((Object)ObjectUtils.NULL);
        Assertions.assertTrue((boolean)(ObjectUtils.NULL instanceof ObjectUtils.Null));
        Assertions.assertSame((Object)ObjectUtils.NULL, (Object)SerializationUtils.clone((Serializable)ObjectUtils.NULL));
    }

    @Test
    public void testPossibleCloneOfCloneable() {
        CloneableString string = new CloneableString("apache");
        CloneableString stringClone = (CloneableString)ObjectUtils.cloneIfPossible((Object)string);
        Assertions.assertEquals((Object)"apache", (Object)stringClone.getValue());
    }

    @Test
    public void testPossibleCloneOfNotCloneable() {
        String string = "apache";
        Assertions.assertSame((Object)"apache", (Object)ObjectUtils.cloneIfPossible((Object)"apache"));
    }

    @Test
    public void testPossibleCloneOfUncloneable() {
        UncloneableString string = new UncloneableString("apache");
        CloneFailedException e = (CloneFailedException)Assertions.assertThrows(CloneFailedException.class, () -> {
            UncloneableString cfr_ignored_0 = (UncloneableString)ObjectUtils.cloneIfPossible((Object)string);
        });
        Assertions.assertEquals(NoSuchMethodException.class, e.getCause().getClass());
    }

    @Test
    public void testRequireNonEmpty() {
        Assertions.assertEquals((Object)FOO, (Object)ObjectUtils.requireNonEmpty((Object)FOO));
        Assertions.assertEquals((Object)FOO, (Object)ObjectUtils.requireNonEmpty((Object)FOO, (String)FOO));
        Assertions.assertThrows(NullPointerException.class, () -> ObjectUtils.requireNonEmpty(null));
        Assertions.assertThrows(NullPointerException.class, () -> ObjectUtils.requireNonEmpty(null, (String)FOO));
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            String cfr_ignored_0 = (String)ObjectUtils.requireNonEmpty((Object)"");
        });
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            String cfr_ignored_0 = (String)ObjectUtils.requireNonEmpty((Object)"", (String)FOO);
        });
    }

    @Test
    public void testToString_Object() {
        Assertions.assertEquals((Object)"", (Object)ObjectUtils.toString(null));
        Assertions.assertEquals((Object)Boolean.TRUE.toString(), (Object)ObjectUtils.toString((Object)Boolean.TRUE));
    }

    @Test
    public void testToString_ObjectString() {
        Assertions.assertEquals((Object)BAR, (Object)ObjectUtils.toString(null, (String)BAR));
        Assertions.assertEquals((Object)Boolean.TRUE.toString(), (Object)ObjectUtils.toString((Object)Boolean.TRUE, (String)BAR));
    }

    @Test
    public void testToString_SupplierString() {
        Assertions.assertEquals(null, (Object)ObjectUtils.toString(null, (Supplier)null));
        Assertions.assertEquals(null, (Object)ObjectUtils.toString(null, () -> null));
        Assertions.assertEquals((Object)BAR, (Object)ObjectUtils.toString(null, () -> BAR));
        Assertions.assertEquals((Object)Boolean.TRUE.toString(), (Object)ObjectUtils.toString((Object)Boolean.TRUE, () -> BAR));
    }

    @Test
    public void testWaitDuration() {
        Assertions.assertThrows(IllegalMonitorStateException.class, () -> ObjectUtils.wait((Object)new Object(), (Duration)Duration.ZERO));
    }

    static {
        NON_EMPTY_MAP.put(FOO, BAR);
    }

    static final class UncloneableString
    extends MutableObject<String>
    implements Cloneable {
        private static final long serialVersionUID = 1L;

        UncloneableString(String s) {
            super((Object)s);
        }
    }

    static final class NonComparableCharSequence
    implements CharSequence {
        final String value;

        NonComparableCharSequence(String value) {
            Validate.notNull((Object)value);
            this.value = value;
        }

        @Override
        public char charAt(int arg0) {
            return this.value.charAt(arg0);
        }

        @Override
        public int length() {
            return this.value.length();
        }

        @Override
        public CharSequence subSequence(int arg0, int arg1) {
            return this.value.subSequence(arg0, arg1);
        }

        @Override
        public String toString() {
            return this.value;
        }
    }

    static final class CloneableString
    extends MutableObject<String>
    implements Cloneable {
        private static final long serialVersionUID = 1L;

        CloneableString(String s) {
            super((Object)s);
        }

        public CloneableString clone() throws CloneNotSupportedException {
            return (CloneableString)super.clone();
        }
    }

    static final class CharSequenceComparator
    implements Comparator<CharSequence> {
        CharSequenceComparator() {
        }

        @Override
        public int compare(CharSequence o1, CharSequence o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

