/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.concurrent.AbstractConcurrentInitializerTest;
import org.apache.commons.lang3.concurrent.AtomicSafeInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AtomicSafeInitializerTest
extends AbstractConcurrentInitializerTest {
    private AtomicSafeInitializerTestImpl initializer;

    @BeforeEach
    public void setUp() {
        this.initializer = new AtomicSafeInitializerTestImpl();
    }

    @Override
    protected ConcurrentInitializer<Object> createInitializer() {
        return this.initializer;
    }

    @Test
    public void testNumberOfInitializeInvocations() throws ConcurrentException, InterruptedException {
        this.testGetConcurrent();
        Assertions.assertEquals((int)1, (int)this.initializer.initCounter.get(), (String)"Wrong number of invocations");
    }

    private static class AtomicSafeInitializerTestImpl
    extends AtomicSafeInitializer<Object> {
        final AtomicInteger initCounter = new AtomicInteger();

        private AtomicSafeInitializerTestImpl() {
        }

        protected Object initialize() {
            this.initCounter.incrementAndGet();
            return new Object();
        }
    }
}

