/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.time.FastTimeZone;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.DefaultLocale;
import org.junitpioneer.jupiter.DefaultTimeZone;

public class DateFormatUtilsTest {
    private void assertFormats(String expectedValue, String pattern, TimeZone timeZone, Calendar cal) {
        Assertions.assertEquals((Object)expectedValue, (Object)DateFormatUtils.format((Date)cal.getTime(), (String)pattern, (TimeZone)timeZone));
        Assertions.assertEquals((Object)expectedValue, (Object)DateFormatUtils.format((long)cal.getTime().getTime(), (String)pattern, (TimeZone)timeZone));
        Assertions.assertEquals((Object)expectedValue, (Object)DateFormatUtils.format((Calendar)cal, (String)pattern, (TimeZone)timeZone));
    }

    private Calendar createFebruaryTestDate(TimeZone timeZone) {
        Calendar cal = Calendar.getInstance(timeZone);
        cal.set(2002, 1, 23, 9, 11, 12);
        return cal;
    }

    private Calendar createJuneTestDate(TimeZone timeZone) {
        Calendar cal = Calendar.getInstance(timeZone);
        cal.set(2003, 5, 8, 10, 11, 12);
        return cal;
    }

    @Test
    public void testConstructor() {
        Assertions.assertNotNull((Object)new DateFormatUtils());
        Constructor<?>[] cons = DateFormatUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(DateFormatUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(DateFormatUtils.class.getModifiers()));
    }

    @Test
    public void testDateISO() {
        this.testGmtMinus3("2002-02-23", DateFormatUtils.ISO_DATE_FORMAT.getPattern());
        this.testGmtMinus3("2002-02-23-03:00", DateFormatUtils.ISO_DATE_TIME_ZONE_FORMAT.getPattern());
        this.testUTC("2002-02-23Z", DateFormatUtils.ISO_DATE_TIME_ZONE_FORMAT.getPattern());
    }

    @Test
    public void testDateTimeISO() {
        this.testGmtMinus3("2002-02-23T09:11:12", DateFormatUtils.ISO_DATETIME_FORMAT.getPattern());
        this.testGmtMinus3("2002-02-23T09:11:12-03:00", DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern());
        this.testUTC("2002-02-23T09:11:12Z", DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern());
    }

    @Test
    public void testFormat() {
        Calendar c = Calendar.getInstance(FastTimeZone.getGmtTimeZone());
        c.set(2005, 0, 1, 12, 0, 0);
        c.setTimeZone(TimeZone.getDefault());
        StringBuilder buffer = new StringBuilder();
        int year = c.get(1);
        int month = c.get(2) + 1;
        int day = c.get(5);
        int hour = c.get(11);
        buffer.append(year);
        buffer.append(month);
        buffer.append(day);
        buffer.append(hour);
        Assertions.assertEquals((Object)buffer.toString(), (Object)DateFormatUtils.format((Date)c.getTime(), (String)"yyyyMdH"));
        Assertions.assertEquals((Object)buffer.toString(), (Object)DateFormatUtils.format((long)c.getTime().getTime(), (String)"yyyyMdH"));
        Assertions.assertEquals((Object)buffer.toString(), (Object)DateFormatUtils.format((Date)c.getTime(), (String)"yyyyMdH", (Locale)Locale.US));
        Assertions.assertEquals((Object)buffer.toString(), (Object)DateFormatUtils.format((long)c.getTime().getTime(), (String)"yyyyMdH", (Locale)Locale.US));
    }

    @Test
    public void testFormatCalendar() {
        Calendar c = Calendar.getInstance(FastTimeZone.getGmtTimeZone());
        c.set(2005, 0, 1, 12, 0, 0);
        c.setTimeZone(TimeZone.getDefault());
        StringBuilder buffer = new StringBuilder();
        int year = c.get(1);
        int month = c.get(2) + 1;
        int day = c.get(5);
        int hour = c.get(11);
        buffer.append(year);
        buffer.append(month);
        buffer.append(day);
        buffer.append(hour);
        Assertions.assertEquals((Object)buffer.toString(), (Object)DateFormatUtils.format((Calendar)c, (String)"yyyyMdH"));
        Assertions.assertEquals((Object)buffer.toString(), (Object)DateFormatUtils.format((Date)c.getTime(), (String)"yyyyMdH"));
        Assertions.assertEquals((Object)buffer.toString(), (Object)DateFormatUtils.format((Calendar)c, (String)"yyyyMdH", (Locale)Locale.US));
        Assertions.assertEquals((Object)buffer.toString(), (Object)DateFormatUtils.format((Date)c.getTime(), (String)"yyyyMdH", (Locale)Locale.US));
    }

    @Test
    public void testFormatUTC() {
        Calendar c = Calendar.getInstance(FastTimeZone.getGmtTimeZone());
        c.set(2005, 0, 1, 12, 0, 0);
        Assertions.assertEquals((Object)"2005-01-01T12:00:00", (Object)DateFormatUtils.formatUTC((Date)c.getTime(), (String)DateFormatUtils.ISO_DATETIME_FORMAT.getPattern()));
        Assertions.assertEquals((Object)"2005-01-01T12:00:00", (Object)DateFormatUtils.formatUTC((long)c.getTime().getTime(), (String)DateFormatUtils.ISO_DATETIME_FORMAT.getPattern()));
        Assertions.assertEquals((Object)"2005-01-01T12:00:00", (Object)DateFormatUtils.formatUTC((Date)c.getTime(), (String)DateFormatUtils.ISO_DATETIME_FORMAT.getPattern(), (Locale)Locale.US));
        Assertions.assertEquals((Object)"2005-01-01T12:00:00", (Object)DateFormatUtils.formatUTC((long)c.getTime().getTime(), (String)DateFormatUtils.ISO_DATETIME_FORMAT.getPattern(), (Locale)Locale.US));
    }

    private void testGmtMinus3(String expectedValue, String pattern) {
        TimeZone timeZone = TimeZone.getTimeZone("GMT-3");
        this.assertFormats(expectedValue, pattern, timeZone, this.createFebruaryTestDate(timeZone));
    }

    @Test
    public void testLANG1000() throws Exception {
        String date = "2013-11-18T12:48:05Z";
        DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.parse("2013-11-18T12:48:05Z");
    }

    @DefaultTimeZone(value="UTC")
    @Test
    public void testLang530() throws ParseException {
        Date d = new Date();
        String isoDateStr = DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(d);
        Date d2 = DateUtils.parseDate((String)isoDateStr, (String[])new String[]{DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern()});
        Assertions.assertEquals((long)d.getTime(), (long)(d2.getTime() + d.getTime() % 1000L), (String)"Date not equal to itself ISO formatted and parsed");
    }

    @Test
    public void testLang916() {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("Europe/Paris"));
        cal.clear();
        cal.set(2009, 9, 16, 8, 42, 16);
        String value = DateFormatUtils.format((long)cal.getTimeInMillis(), (String)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern(), (TimeZone)TimeZone.getTimeZone("Europe/Paris"));
        Assertions.assertEquals((Object)"2009-10-16T08:42:16+02:00", (Object)value, (String)"long");
        value = DateFormatUtils.format((long)cal.getTimeInMillis(), (String)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern(), (TimeZone)TimeZone.getTimeZone("Asia/Kolkata"));
        Assertions.assertEquals((Object)"2009-10-16T12:12:16+05:30", (Object)value, (String)"long");
        value = DateFormatUtils.format((long)cal.getTimeInMillis(), (String)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern(), (TimeZone)TimeZone.getTimeZone("Europe/London"));
        Assertions.assertEquals((Object)"2009-10-16T07:42:16+01:00", (Object)value, (String)"long");
        value = DateFormatUtils.format((Calendar)cal, (String)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern(), (TimeZone)TimeZone.getTimeZone("Europe/Paris"));
        Assertions.assertEquals((Object)"2009-10-16T08:42:16+02:00", (Object)value, (String)"calendar");
        value = DateFormatUtils.format((Calendar)cal, (String)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern(), (TimeZone)TimeZone.getTimeZone("Asia/Kolkata"));
        Assertions.assertEquals((Object)"2009-10-16T12:12:16+05:30", (Object)value, (String)"calendar");
        value = DateFormatUtils.format((Calendar)cal, (String)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern(), (TimeZone)TimeZone.getTimeZone("Europe/London"));
        Assertions.assertEquals((Object)"2009-10-16T07:42:16+01:00", (Object)value, (String)"calendar");
    }

    @DefaultLocale(language="en")
    @Test
    public void testSMTP() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT-3");
        Calendar june = this.createJuneTestDate(timeZone);
        this.assertFormats("Sun, 08 Jun 2003 10:11:12 -0300", DateFormatUtils.SMTP_DATETIME_FORMAT.getPattern(), timeZone, june);
        timeZone = FastTimeZone.getGmtTimeZone();
        june = this.createJuneTestDate(timeZone);
        this.assertFormats("Sun, 08 Jun 2003 10:11:12 +0000", DateFormatUtils.SMTP_DATETIME_FORMAT.getPattern(), timeZone, june);
    }

    @Test
    public void testTimeISO() {
        this.testGmtMinus3("T09:11:12", DateFormatUtils.ISO_TIME_FORMAT.getPattern());
        this.testGmtMinus3("T09:11:12-03:00", DateFormatUtils.ISO_TIME_TIME_ZONE_FORMAT.getPattern());
        this.testUTC("T09:11:12Z", DateFormatUtils.ISO_TIME_TIME_ZONE_FORMAT.getPattern());
    }

    @Test
    public void testTimeNoTISO() {
        this.testGmtMinus3("09:11:12", DateFormatUtils.ISO_TIME_NO_T_FORMAT.getPattern());
        this.testGmtMinus3("09:11:12-03:00", DateFormatUtils.ISO_TIME_NO_T_TIME_ZONE_FORMAT.getPattern());
        this.testUTC("09:11:12Z", DateFormatUtils.ISO_TIME_NO_T_TIME_ZONE_FORMAT.getPattern());
    }

    private void testUTC(String expectedValue, String pattern) {
        TimeZone timeZone = FastTimeZone.getGmtTimeZone();
        this.assertFormats(expectedValue, pattern, timeZone, this.createFebruaryTestDate(timeZone));
    }
}

