/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.CharRange;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;

public class CharRangeTest {
    @Test
    public void testClass() {
        Assert.assertFalse((boolean)Modifier.isPublic(CharRange.class.getModifiers()));
        Assert.assertTrue((boolean)Modifier.isFinal(CharRange.class.getModifiers()));
    }

    @Test
    public void testConstructorAccessors_is() {
        CharRange rangea = CharRange.is((char)'a');
        Assert.assertEquals((long)97L, (long)rangea.getStart());
        Assert.assertEquals((long)97L, (long)rangea.getEnd());
        Assert.assertFalse((boolean)rangea.isNegated());
        Assert.assertEquals((Object)"a", (Object)rangea.toString());
    }

    @Test
    public void testConstructorAccessors_isNot() {
        CharRange rangea = CharRange.isNot((char)'a');
        Assert.assertEquals((long)97L, (long)rangea.getStart());
        Assert.assertEquals((long)97L, (long)rangea.getEnd());
        Assert.assertTrue((boolean)rangea.isNegated());
        Assert.assertEquals((Object)"^a", (Object)rangea.toString());
    }

    @Test
    public void testConstructorAccessors_isIn_Same() {
        CharRange rangea = CharRange.isIn((char)'a', (char)'a');
        Assert.assertEquals((long)97L, (long)rangea.getStart());
        Assert.assertEquals((long)97L, (long)rangea.getEnd());
        Assert.assertFalse((boolean)rangea.isNegated());
        Assert.assertEquals((Object)"a", (Object)rangea.toString());
    }

    @Test
    public void testConstructorAccessors_isIn_Normal() {
        CharRange rangea = CharRange.isIn((char)'a', (char)'e');
        Assert.assertEquals((long)97L, (long)rangea.getStart());
        Assert.assertEquals((long)101L, (long)rangea.getEnd());
        Assert.assertFalse((boolean)rangea.isNegated());
        Assert.assertEquals((Object)"a-e", (Object)rangea.toString());
    }

    @Test
    public void testConstructorAccessors_isIn_Reversed() {
        CharRange rangea = CharRange.isIn((char)'e', (char)'a');
        Assert.assertEquals((long)97L, (long)rangea.getStart());
        Assert.assertEquals((long)101L, (long)rangea.getEnd());
        Assert.assertFalse((boolean)rangea.isNegated());
        Assert.assertEquals((Object)"a-e", (Object)rangea.toString());
    }

    @Test
    public void testConstructorAccessors_isNotIn_Same() {
        CharRange rangea = CharRange.isNotIn((char)'a', (char)'a');
        Assert.assertEquals((long)97L, (long)rangea.getStart());
        Assert.assertEquals((long)97L, (long)rangea.getEnd());
        Assert.assertTrue((boolean)rangea.isNegated());
        Assert.assertEquals((Object)"^a", (Object)rangea.toString());
    }

    @Test
    public void testConstructorAccessors_isNotIn_Normal() {
        CharRange rangea = CharRange.isNotIn((char)'a', (char)'e');
        Assert.assertEquals((long)97L, (long)rangea.getStart());
        Assert.assertEquals((long)101L, (long)rangea.getEnd());
        Assert.assertTrue((boolean)rangea.isNegated());
        Assert.assertEquals((Object)"^a-e", (Object)rangea.toString());
    }

    @Test
    public void testConstructorAccessors_isNotIn_Reversed() {
        CharRange rangea = CharRange.isNotIn((char)'e', (char)'a');
        Assert.assertEquals((long)97L, (long)rangea.getStart());
        Assert.assertEquals((long)101L, (long)rangea.getEnd());
        Assert.assertTrue((boolean)rangea.isNegated());
        Assert.assertEquals((Object)"^a-e", (Object)rangea.toString());
    }

    @Test
    public void testEquals_Object() {
        CharRange rangea = CharRange.is((char)'a');
        CharRange rangeae = CharRange.isIn((char)'a', (char)'e');
        CharRange rangenotbf = CharRange.isIn((char)'b', (char)'f');
        Assert.assertFalse((boolean)rangea.equals(null));
        Assert.assertTrue((boolean)rangea.equals((Object)rangea));
        Assert.assertTrue((boolean)rangea.equals((Object)CharRange.is((char)'a')));
        Assert.assertTrue((boolean)rangeae.equals((Object)rangeae));
        Assert.assertTrue((boolean)rangeae.equals((Object)CharRange.isIn((char)'a', (char)'e')));
        Assert.assertTrue((boolean)rangenotbf.equals((Object)rangenotbf));
        Assert.assertTrue((boolean)rangenotbf.equals((Object)CharRange.isIn((char)'b', (char)'f')));
        Assert.assertFalse((boolean)rangea.equals((Object)rangeae));
        Assert.assertFalse((boolean)rangea.equals((Object)rangenotbf));
        Assert.assertFalse((boolean)rangeae.equals((Object)rangea));
        Assert.assertFalse((boolean)rangeae.equals((Object)rangenotbf));
        Assert.assertFalse((boolean)rangenotbf.equals((Object)rangea));
        Assert.assertFalse((boolean)rangenotbf.equals((Object)rangeae));
    }

    @Test
    public void testHashCode() {
        CharRange rangea = CharRange.is((char)'a');
        CharRange rangeae = CharRange.isIn((char)'a', (char)'e');
        CharRange rangenotbf = CharRange.isIn((char)'b', (char)'f');
        Assert.assertTrue((rangea.hashCode() == rangea.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((rangea.hashCode() == CharRange.is((char)'a').hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((rangeae.hashCode() == rangeae.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((rangeae.hashCode() == CharRange.isIn((char)'a', (char)'e').hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((rangenotbf.hashCode() == rangenotbf.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((rangenotbf.hashCode() == CharRange.isIn((char)'b', (char)'f').hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((rangea.hashCode() == rangeae.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((rangea.hashCode() == rangenotbf.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((rangeae.hashCode() == rangea.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((rangeae.hashCode() == rangenotbf.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((rangenotbf.hashCode() == rangea.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((rangenotbf.hashCode() == rangeae.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testContains_Char() {
        CharRange range = CharRange.is((char)'c');
        Assert.assertFalse((boolean)range.contains('b'));
        Assert.assertTrue((boolean)range.contains('c'));
        Assert.assertFalse((boolean)range.contains('d'));
        Assert.assertFalse((boolean)range.contains('e'));
        range = CharRange.isIn((char)'c', (char)'d');
        Assert.assertFalse((boolean)range.contains('b'));
        Assert.assertTrue((boolean)range.contains('c'));
        Assert.assertTrue((boolean)range.contains('d'));
        Assert.assertFalse((boolean)range.contains('e'));
        range = CharRange.isIn((char)'d', (char)'c');
        Assert.assertFalse((boolean)range.contains('b'));
        Assert.assertTrue((boolean)range.contains('c'));
        Assert.assertTrue((boolean)range.contains('d'));
        Assert.assertFalse((boolean)range.contains('e'));
        range = CharRange.isNotIn((char)'c', (char)'d');
        Assert.assertTrue((boolean)range.contains('b'));
        Assert.assertFalse((boolean)range.contains('c'));
        Assert.assertFalse((boolean)range.contains('d'));
        Assert.assertTrue((boolean)range.contains('e'));
        Assert.assertTrue((boolean)range.contains('\u0000'));
        Assert.assertTrue((boolean)range.contains('\uffff'));
    }

    @Test
    public void testContains_Charrange() {
        CharRange a = CharRange.is((char)'a');
        CharRange b = CharRange.is((char)'b');
        CharRange c = CharRange.is((char)'c');
        CharRange c2 = CharRange.is((char)'c');
        CharRange d = CharRange.is((char)'d');
        CharRange e = CharRange.is((char)'e');
        CharRange cd = CharRange.isIn((char)'c', (char)'d');
        CharRange bd = CharRange.isIn((char)'b', (char)'d');
        CharRange bc = CharRange.isIn((char)'b', (char)'c');
        CharRange ab = CharRange.isIn((char)'a', (char)'b');
        CharRange de = CharRange.isIn((char)'d', (char)'e');
        CharRange ef = CharRange.isIn((char)'e', (char)'f');
        CharRange ae = CharRange.isIn((char)'a', (char)'e');
        Assert.assertFalse((boolean)c.contains(b));
        Assert.assertTrue((boolean)c.contains(c));
        Assert.assertTrue((boolean)c.contains(c2));
        Assert.assertFalse((boolean)c.contains(d));
        Assert.assertFalse((boolean)c.contains(cd));
        Assert.assertFalse((boolean)c.contains(bd));
        Assert.assertFalse((boolean)c.contains(bc));
        Assert.assertFalse((boolean)c.contains(ab));
        Assert.assertFalse((boolean)c.contains(de));
        Assert.assertTrue((boolean)cd.contains(c));
        Assert.assertTrue((boolean)bd.contains(c));
        Assert.assertTrue((boolean)bc.contains(c));
        Assert.assertFalse((boolean)ab.contains(c));
        Assert.assertFalse((boolean)de.contains(c));
        Assert.assertTrue((boolean)ae.contains(b));
        Assert.assertTrue((boolean)ae.contains(ab));
        Assert.assertTrue((boolean)ae.contains(bc));
        Assert.assertTrue((boolean)ae.contains(cd));
        Assert.assertTrue((boolean)ae.contains(de));
        CharRange notb = CharRange.isNot((char)'b');
        CharRange notc = CharRange.isNot((char)'c');
        CharRange notd = CharRange.isNot((char)'d');
        CharRange notab = CharRange.isNotIn((char)'a', (char)'b');
        CharRange notbc = CharRange.isNotIn((char)'b', (char)'c');
        CharRange notbd = CharRange.isNotIn((char)'b', (char)'d');
        CharRange notcd = CharRange.isNotIn((char)'c', (char)'d');
        CharRange notde = CharRange.isNotIn((char)'d', (char)'e');
        CharRange notae = CharRange.isNotIn((char)'a', (char)'e');
        CharRange all = CharRange.isIn((char)'\u0000', (char)'\uffff');
        CharRange allbutfirst = CharRange.isIn((char)'\u0001', (char)'\uffff');
        Assert.assertFalse((boolean)c.contains(notc));
        Assert.assertFalse((boolean)c.contains(notbd));
        Assert.assertTrue((boolean)all.contains(notc));
        Assert.assertTrue((boolean)all.contains(notbd));
        Assert.assertFalse((boolean)allbutfirst.contains(notc));
        Assert.assertFalse((boolean)allbutfirst.contains(notbd));
        Assert.assertTrue((boolean)notc.contains(a));
        Assert.assertTrue((boolean)notc.contains(b));
        Assert.assertFalse((boolean)notc.contains(c));
        Assert.assertTrue((boolean)notc.contains(d));
        Assert.assertTrue((boolean)notc.contains(e));
        Assert.assertTrue((boolean)notc.contains(ab));
        Assert.assertFalse((boolean)notc.contains(bc));
        Assert.assertFalse((boolean)notc.contains(bd));
        Assert.assertFalse((boolean)notc.contains(cd));
        Assert.assertTrue((boolean)notc.contains(de));
        Assert.assertFalse((boolean)notc.contains(ae));
        Assert.assertFalse((boolean)notc.contains(all));
        Assert.assertFalse((boolean)notc.contains(allbutfirst));
        Assert.assertTrue((boolean)notbd.contains(a));
        Assert.assertFalse((boolean)notbd.contains(b));
        Assert.assertFalse((boolean)notbd.contains(c));
        Assert.assertFalse((boolean)notbd.contains(d));
        Assert.assertTrue((boolean)notbd.contains(e));
        Assert.assertTrue((boolean)notcd.contains(ab));
        Assert.assertFalse((boolean)notcd.contains(bc));
        Assert.assertFalse((boolean)notcd.contains(bd));
        Assert.assertFalse((boolean)notcd.contains(cd));
        Assert.assertFalse((boolean)notcd.contains(de));
        Assert.assertFalse((boolean)notcd.contains(ae));
        Assert.assertTrue((boolean)notcd.contains(ef));
        Assert.assertFalse((boolean)notcd.contains(all));
        Assert.assertFalse((boolean)notcd.contains(allbutfirst));
        Assert.assertFalse((boolean)notc.contains(notb));
        Assert.assertTrue((boolean)notc.contains(notc));
        Assert.assertFalse((boolean)notc.contains(notd));
        Assert.assertFalse((boolean)notc.contains(notab));
        Assert.assertTrue((boolean)notc.contains(notbc));
        Assert.assertTrue((boolean)notc.contains(notbd));
        Assert.assertTrue((boolean)notc.contains(notcd));
        Assert.assertFalse((boolean)notc.contains(notde));
        Assert.assertFalse((boolean)notbd.contains(notb));
        Assert.assertFalse((boolean)notbd.contains(notc));
        Assert.assertFalse((boolean)notbd.contains(notd));
        Assert.assertFalse((boolean)notbd.contains(notab));
        Assert.assertFalse((boolean)notbd.contains(notbc));
        Assert.assertTrue((boolean)notbd.contains(notbd));
        Assert.assertFalse((boolean)notbd.contains(notcd));
        Assert.assertFalse((boolean)notbd.contains(notde));
        Assert.assertTrue((boolean)notbd.contains(notae));
    }

    @Test
    public void testContainsNullArg() {
        CharRange range = CharRange.is((char)'a');
        try {
            boolean contains = range.contains(null);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"The Range must not be null", (Object)e.getMessage());
        }
    }

    @Test
    public void testIterator() {
        CharRange a = CharRange.is((char)'a');
        CharRange ad = CharRange.isIn((char)'a', (char)'d');
        CharRange nota = CharRange.isNot((char)'a');
        CharRange emptySet = CharRange.isNotIn((char)'\u0000', (char)'\uffff');
        CharRange notFirst = CharRange.isNotIn((char)'\u0001', (char)'\uffff');
        CharRange notLast = CharRange.isNotIn((char)'\u0000', (char)'\ufffe');
        Iterator aIt = a.iterator();
        Assert.assertNotNull((Object)aIt);
        Assert.assertTrue((boolean)aIt.hasNext());
        Assert.assertEquals((Object)Character.valueOf('a'), aIt.next());
        Assert.assertFalse((boolean)aIt.hasNext());
        Iterator adIt = ad.iterator();
        Assert.assertNotNull((Object)adIt);
        Assert.assertTrue((boolean)adIt.hasNext());
        Assert.assertEquals((Object)Character.valueOf('a'), adIt.next());
        Assert.assertEquals((Object)Character.valueOf('b'), adIt.next());
        Assert.assertEquals((Object)Character.valueOf('c'), adIt.next());
        Assert.assertEquals((Object)Character.valueOf('d'), adIt.next());
        Assert.assertFalse((boolean)adIt.hasNext());
        Iterator notaIt = nota.iterator();
        Assert.assertNotNull((Object)notaIt);
        Assert.assertTrue((boolean)notaIt.hasNext());
        while (notaIt.hasNext()) {
            Character c = (Character)notaIt.next();
            Assert.assertFalse(('a' == c.charValue() ? 1 : 0) != 0);
        }
        Iterator emptySetIt = emptySet.iterator();
        Assert.assertNotNull((Object)emptySetIt);
        Assert.assertFalse((boolean)emptySetIt.hasNext());
        try {
            emptySetIt.next();
            Assert.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            Assert.assertTrue((boolean)true);
        }
        Iterator notFirstIt = notFirst.iterator();
        Assert.assertNotNull((Object)notFirstIt);
        Assert.assertTrue((boolean)notFirstIt.hasNext());
        Assert.assertEquals((Object)Character.valueOf('\u0000'), notFirstIt.next());
        Assert.assertFalse((boolean)notFirstIt.hasNext());
        try {
            notFirstIt.next();
            Assert.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            Assert.assertTrue((boolean)true);
        }
        Iterator notLastIt = notLast.iterator();
        Assert.assertNotNull((Object)notLastIt);
        Assert.assertTrue((boolean)notLastIt.hasNext());
        Assert.assertEquals((Object)Character.valueOf('\uffff'), notLastIt.next());
        Assert.assertFalse((boolean)notLastIt.hasNext());
        try {
            notLastIt.next();
            Assert.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testSerialization() {
        CharRange range = CharRange.is((char)'a');
        Assert.assertEquals((Object)range, (Object)SerializationUtils.clone((Serializable)range));
        range = CharRange.isIn((char)'a', (char)'e');
        Assert.assertEquals((Object)range, (Object)SerializationUtils.clone((Serializable)range));
        range = CharRange.isNotIn((char)'a', (char)'e');
        Assert.assertEquals((Object)range, (Object)SerializationUtils.clone((Serializable)range));
    }
}

