/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.ClassPathUtils;
import org.junit.Assert;
import org.junit.Test;

public class ClassPathUtilsTest {
    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)new ClassPathUtils());
        Constructor<?>[] cons = ClassPathUtils.class.getDeclaredConstructors();
        Assert.assertEquals((long)1L, (long)cons.length);
        Assert.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assert.assertTrue((boolean)Modifier.isPublic(ClassPathUtils.class.getModifiers()));
        Assert.assertFalse((boolean)Modifier.isFinal(ClassPathUtils.class.getModifiers()));
    }

    @Test(expected=NullPointerException.class)
    public void testToFullyQualifiedNameNullClassString() throws Exception {
        ClassPathUtils.toFullyQualifiedName((Class)null, (String)"Test.properties");
    }

    @Test(expected=NullPointerException.class)
    public void testToFullyQualifiedNameClassNull() throws Exception {
        ClassPathUtils.toFullyQualifiedName(ClassPathUtils.class, null);
    }

    @Test
    public void testToFullyQualifiedNameClassString() throws Exception {
        String expected = "org.apache.commons.lang3.Test.properties";
        String actual = ClassPathUtils.toFullyQualifiedName(ClassPathUtils.class, (String)"Test.properties");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test(expected=NullPointerException.class)
    public void testToFullyQualifiedNameNullPackageString() throws Exception {
        ClassPathUtils.toFullyQualifiedName((Package)null, (String)"Test.properties");
    }

    @Test(expected=NullPointerException.class)
    public void testToFullyQualifiedNamePackageNull() throws Exception {
        ClassPathUtils.toFullyQualifiedName((Package)ClassPathUtils.class.getPackage(), null);
    }

    @Test
    public void testToFullyQualifiedNamePackageString() throws Exception {
        String expected = "org.apache.commons.lang3.Test.properties";
        String actual = ClassPathUtils.toFullyQualifiedName((Package)ClassPathUtils.class.getPackage(), (String)"Test.properties");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test(expected=NullPointerException.class)
    public void testToFullyQualifiedPathClassNullString() throws Exception {
        ClassPathUtils.toFullyQualifiedPath((Class)null, (String)"Test.properties");
    }

    @Test(expected=NullPointerException.class)
    public void testToFullyQualifiedPathClassNull() throws Exception {
        ClassPathUtils.toFullyQualifiedPath(ClassPathUtils.class, null);
    }

    @Test
    public void testToFullyQualifiedPathClass() throws Exception {
        String expected = "org/apache/commons/lang3/Test.properties";
        String actual = ClassPathUtils.toFullyQualifiedPath(ClassPathUtils.class, (String)"Test.properties");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test(expected=NullPointerException.class)
    public void testToFullyQualifiedPathPackageNullString() throws Exception {
        ClassPathUtils.toFullyQualifiedPath((Package)null, (String)"Test.properties");
    }

    @Test(expected=NullPointerException.class)
    public void testToFullyQualifiedPathPackageNull() throws Exception {
        ClassPathUtils.toFullyQualifiedPath((Package)ClassPathUtils.class.getPackage(), null);
    }

    @Test
    public void testToFullyQualifiedPathPackage() throws Exception {
        String expected = "org/apache/commons/lang3/Test.properties";
        String actual = ClassPathUtils.toFullyQualifiedPath((Package)ClassPathUtils.class.getPackage(), (String)"Test.properties");
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

