/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.RandomUtils;
import org.junit.Assert;
import org.junit.Test;

public class RandomUtilsTest {
    private static final double DELTA = 1.0E-5;

    @Test(expected=IllegalArgumentException.class)
    public void testNextBytesNegative() throws Exception {
        RandomUtils.nextBytes((int)-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNextIntNegative() throws Exception {
        RandomUtils.nextInt((int)-1, (int)1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNextLongNegative() throws Exception {
        RandomUtils.nextLong((long)-1L, (long)1L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNextDoubleNegative() throws Exception {
        RandomUtils.nextDouble((double)-1.0, (double)1.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNextFloatNegative() throws Exception {
        RandomUtils.nextFloat((float)-1.0f, (float)1.0f);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNextIntLowerGreaterUpper() throws Exception {
        RandomUtils.nextInt((int)2, (int)1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNextLongLowerGreaterUpper() throws Exception {
        RandomUtils.nextLong((long)2L, (long)1L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNextDoubleLowerGreaterUpper() throws Exception {
        RandomUtils.nextDouble((double)2.0, (double)1.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNextFloatLowerGreaterUpper() throws Exception {
        RandomUtils.nextFloat((float)2.0f, (float)1.0f);
    }

    @Test
    public void testZeroLengthNextBytes() throws Exception {
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])RandomUtils.nextBytes((int)0));
    }

    @Test
    public void testNextBytes() throws Exception {
        byte[] result = RandomUtils.nextBytes((int)20);
        Assert.assertEquals((long)20L, (long)result.length);
    }

    @Test
    public void testNextIntMinimalRange() throws Exception {
        Assert.assertEquals((long)42L, (long)RandomUtils.nextInt((int)42, (int)42));
    }

    @Test
    public void testNextInt() throws Exception {
        int result = RandomUtils.nextInt((int)33, (int)42);
        Assert.assertTrue((result >= 33 && result < 42 ? 1 : 0) != 0);
    }

    @Test
    public void testNextDoubleMinimalRange() throws Exception {
        Assert.assertEquals((double)42.1, (double)RandomUtils.nextDouble((double)42.1, (double)42.1), (double)1.0E-5);
    }

    @Test
    public void testNextFloatMinimalRange() throws Exception {
        Assert.assertEquals((double)42.1f, (double)RandomUtils.nextFloat((float)42.1f, (float)42.1f), (double)1.0E-5);
    }

    @Test
    public void testNextDouble() throws Exception {
        double result = RandomUtils.nextDouble((double)33.0, (double)42.0);
        Assert.assertTrue((result >= 33.0 && result <= 42.0 ? 1 : 0) != 0);
    }

    @Test
    public void testNextFloat() throws Exception {
        double result = RandomUtils.nextFloat((float)33.0f, (float)42.0f);
        Assert.assertTrue((result >= 33.0 && result <= 42.0 ? 1 : 0) != 0);
    }

    @Test
    public void testNextLongMinimalRange() throws Exception {
        Assert.assertEquals((long)42L, (long)RandomUtils.nextLong((long)42L, (long)42L));
    }

    @Test
    public void testNextLong() throws Exception {
        long result = RandomUtils.nextLong((long)33L, (long)42L);
        Assert.assertTrue((result >= 33L && result < 42L ? 1 : 0) != 0);
    }

    @Test
    public void testExtremeRangeInt() throws Exception {
        int result = RandomUtils.nextInt((int)0, (int)Integer.MAX_VALUE);
        Assert.assertTrue((result >= 0 && result < Integer.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    public void testExtremeRangeLong() throws Exception {
        long result = RandomUtils.nextLong((long)0L, (long)Long.MAX_VALUE);
        Assert.assertTrue((result >= 0L && result < Long.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    public void testExtremeRangeFloat() throws Exception {
        float result = RandomUtils.nextFloat((float)0.0f, (float)Float.MAX_VALUE);
        Assert.assertTrue((result >= 0.0f && result <= Float.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    public void testExtremeRangeDouble() throws Exception {
        double result = RandomUtils.nextDouble((double)0.0, (double)Double.MAX_VALUE);
        Assert.assertTrue((result >= 0.0 && result <= Double.MAX_VALUE ? 1 : 0) != 0);
    }
}

