/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.StringUtilsTest;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilsIsTest {
    @Test
    public void testIsAlpha() {
        Assert.assertFalse((boolean)StringUtils.isAlpha(null));
        Assert.assertFalse((boolean)StringUtils.isAlpha((CharSequence)""));
        Assert.assertFalse((boolean)StringUtils.isAlpha((CharSequence)" "));
        Assert.assertTrue((boolean)StringUtils.isAlpha((CharSequence)"a"));
        Assert.assertTrue((boolean)StringUtils.isAlpha((CharSequence)"A"));
        Assert.assertTrue((boolean)StringUtils.isAlpha((CharSequence)"kgKgKgKgkgkGkjkjlJlOKLgHdGdHgl"));
        Assert.assertFalse((boolean)StringUtils.isAlpha((CharSequence)"ham kso"));
        Assert.assertFalse((boolean)StringUtils.isAlpha((CharSequence)"1"));
        Assert.assertFalse((boolean)StringUtils.isAlpha((CharSequence)"hkHKHik6iUGHKJgU7tUJgKJGI87GIkug"));
        Assert.assertFalse((boolean)StringUtils.isAlpha((CharSequence)"_"));
        Assert.assertFalse((boolean)StringUtils.isAlpha((CharSequence)"hkHKHik*khbkuh"));
    }

    @Test
    public void testIsAlphanumeric() {
        Assert.assertFalse((boolean)StringUtils.isAlphanumeric(null));
        Assert.assertFalse((boolean)StringUtils.isAlphanumeric((CharSequence)""));
        Assert.assertFalse((boolean)StringUtils.isAlphanumeric((CharSequence)" "));
        Assert.assertTrue((boolean)StringUtils.isAlphanumeric((CharSequence)"a"));
        Assert.assertTrue((boolean)StringUtils.isAlphanumeric((CharSequence)"A"));
        Assert.assertTrue((boolean)StringUtils.isAlphanumeric((CharSequence)"kgKgKgKgkgkGkjkjlJlOKLgHdGdHgl"));
        Assert.assertFalse((boolean)StringUtils.isAlphanumeric((CharSequence)"ham kso"));
        Assert.assertTrue((boolean)StringUtils.isAlphanumeric((CharSequence)"1"));
        Assert.assertTrue((boolean)StringUtils.isAlphanumeric((CharSequence)"hkHKHik6iUGHKJgU7tUJgKJGI87GIkug"));
        Assert.assertFalse((boolean)StringUtils.isAlphanumeric((CharSequence)"_"));
        Assert.assertFalse((boolean)StringUtils.isAlphanumeric((CharSequence)"hkHKHik*khbkuh"));
    }

    @Test
    public void testIsWhitespace() {
        Assert.assertFalse((boolean)StringUtils.isWhitespace(null));
        Assert.assertTrue((boolean)StringUtils.isWhitespace((CharSequence)""));
        Assert.assertTrue((boolean)StringUtils.isWhitespace((CharSequence)" "));
        Assert.assertTrue((boolean)StringUtils.isWhitespace((CharSequence)"\t \n \t"));
        Assert.assertFalse((boolean)StringUtils.isWhitespace((CharSequence)"\t aa\n \t"));
        Assert.assertTrue((boolean)StringUtils.isWhitespace((CharSequence)" "));
        Assert.assertFalse((boolean)StringUtils.isWhitespace((CharSequence)" a "));
        Assert.assertFalse((boolean)StringUtils.isWhitespace((CharSequence)"a  "));
        Assert.assertFalse((boolean)StringUtils.isWhitespace((CharSequence)"  a"));
        Assert.assertFalse((boolean)StringUtils.isWhitespace((CharSequence)"aba"));
        Assert.assertTrue((boolean)StringUtils.isWhitespace((CharSequence)StringUtilsTest.WHITESPACE));
        Assert.assertFalse((boolean)StringUtils.isWhitespace((CharSequence)StringUtilsTest.NON_WHITESPACE));
    }

    @Test
    public void testIsAlphaspace() {
        Assert.assertFalse((boolean)StringUtils.isAlphaSpace(null));
        Assert.assertTrue((boolean)StringUtils.isAlphaSpace((CharSequence)""));
        Assert.assertTrue((boolean)StringUtils.isAlphaSpace((CharSequence)" "));
        Assert.assertTrue((boolean)StringUtils.isAlphaSpace((CharSequence)"a"));
        Assert.assertTrue((boolean)StringUtils.isAlphaSpace((CharSequence)"A"));
        Assert.assertTrue((boolean)StringUtils.isAlphaSpace((CharSequence)"kgKgKgKgkgkGkjkjlJlOKLgHdGdHgl"));
        Assert.assertTrue((boolean)StringUtils.isAlphaSpace((CharSequence)"ham kso"));
        Assert.assertFalse((boolean)StringUtils.isAlphaSpace((CharSequence)"1"));
        Assert.assertFalse((boolean)StringUtils.isAlphaSpace((CharSequence)"hkHKHik6iUGHKJgU7tUJgKJGI87GIkug"));
        Assert.assertFalse((boolean)StringUtils.isAlphaSpace((CharSequence)"_"));
        Assert.assertFalse((boolean)StringUtils.isAlphaSpace((CharSequence)"hkHKHik*khbkuh"));
    }

    @Test
    public void testIsAlphanumericSpace() {
        Assert.assertFalse((boolean)StringUtils.isAlphanumericSpace(null));
        Assert.assertTrue((boolean)StringUtils.isAlphanumericSpace((CharSequence)""));
        Assert.assertTrue((boolean)StringUtils.isAlphanumericSpace((CharSequence)" "));
        Assert.assertTrue((boolean)StringUtils.isAlphanumericSpace((CharSequence)"a"));
        Assert.assertTrue((boolean)StringUtils.isAlphanumericSpace((CharSequence)"A"));
        Assert.assertTrue((boolean)StringUtils.isAlphanumericSpace((CharSequence)"kgKgKgKgkgkGkjkjlJlOKLgHdGdHgl"));
        Assert.assertTrue((boolean)StringUtils.isAlphanumericSpace((CharSequence)"ham kso"));
        Assert.assertTrue((boolean)StringUtils.isAlphanumericSpace((CharSequence)"1"));
        Assert.assertTrue((boolean)StringUtils.isAlphanumericSpace((CharSequence)"hkHKHik6iUGHKJgU7tUJgKJGI87GIkug"));
        Assert.assertFalse((boolean)StringUtils.isAlphanumericSpace((CharSequence)"_"));
        Assert.assertFalse((boolean)StringUtils.isAlphanumericSpace((CharSequence)"hkHKHik*khbkuh"));
    }

    @Test
    public void testIsAsciiPrintable_String() {
        Assert.assertFalse((boolean)StringUtils.isAsciiPrintable(null));
        Assert.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)""));
        Assert.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)" "));
        Assert.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"a"));
        Assert.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"A"));
        Assert.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"1"));
        Assert.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"Ceki"));
        Assert.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"!ab2c~"));
        Assert.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"1000"));
        Assert.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"10 00"));
        Assert.assertFalse((boolean)StringUtils.isAsciiPrintable((CharSequence)"10\t00"));
        Assert.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"10.00"));
        Assert.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"10,00"));
        Assert.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"!ab-c~"));
        Assert.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"hkHK=Hik6i?UGH_KJgU7.tUJgKJ*GI87GI,kug"));
        Assert.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)" "));
        Assert.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"!"));
        Assert.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"~"));
        Assert.assertFalse((boolean)StringUtils.isAsciiPrintable((CharSequence)"\u007f"));
        Assert.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"G?lc?"));
        Assert.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"=?iso-8859-1?Q?G=FClc=FC?="));
        Assert.assertFalse((boolean)StringUtils.isAsciiPrintable((CharSequence)"G\u00fclc\u00fc"));
    }

    @Test
    public void testIsNumeric() {
        Assert.assertFalse((boolean)StringUtils.isNumeric(null));
        Assert.assertFalse((boolean)StringUtils.isNumeric((CharSequence)""));
        Assert.assertFalse((boolean)StringUtils.isNumeric((CharSequence)" "));
        Assert.assertFalse((boolean)StringUtils.isNumeric((CharSequence)"a"));
        Assert.assertFalse((boolean)StringUtils.isNumeric((CharSequence)"A"));
        Assert.assertFalse((boolean)StringUtils.isNumeric((CharSequence)"kgKgKgKgkgkGkjkjlJlOKLgHdGdHgl"));
        Assert.assertFalse((boolean)StringUtils.isNumeric((CharSequence)"ham kso"));
        Assert.assertTrue((boolean)StringUtils.isNumeric((CharSequence)"1"));
        Assert.assertTrue((boolean)StringUtils.isNumeric((CharSequence)"1000"));
        Assert.assertFalse((boolean)StringUtils.isNumeric((CharSequence)"2.3"));
        Assert.assertFalse((boolean)StringUtils.isNumeric((CharSequence)"10 00"));
        Assert.assertFalse((boolean)StringUtils.isNumeric((CharSequence)"hkHKHik6iUGHKJgU7tUJgKJGI87GIkug"));
        Assert.assertFalse((boolean)StringUtils.isNumeric((CharSequence)"_"));
        Assert.assertFalse((boolean)StringUtils.isNumeric((CharSequence)"hkHKHik*khbkuh"));
        Assert.assertFalse((boolean)StringUtils.isNumeric((CharSequence)"+123"));
        Assert.assertFalse((boolean)StringUtils.isNumeric((CharSequence)"-123"));
    }

    @Test
    public void testIsNumericSpace() {
        Assert.assertFalse((boolean)StringUtils.isNumericSpace(null));
        Assert.assertTrue((boolean)StringUtils.isNumericSpace((CharSequence)""));
        Assert.assertTrue((boolean)StringUtils.isNumericSpace((CharSequence)" "));
        Assert.assertFalse((boolean)StringUtils.isNumericSpace((CharSequence)"a"));
        Assert.assertFalse((boolean)StringUtils.isNumericSpace((CharSequence)"A"));
        Assert.assertFalse((boolean)StringUtils.isNumericSpace((CharSequence)"kgKgKgKgkgkGkjkjlJlOKLgHdGdHgl"));
        Assert.assertFalse((boolean)StringUtils.isNumericSpace((CharSequence)"ham kso"));
        Assert.assertTrue((boolean)StringUtils.isNumericSpace((CharSequence)"1"));
        Assert.assertTrue((boolean)StringUtils.isNumericSpace((CharSequence)"1000"));
        Assert.assertFalse((boolean)StringUtils.isNumericSpace((CharSequence)"2.3"));
        Assert.assertTrue((boolean)StringUtils.isNumericSpace((CharSequence)"10 00"));
        Assert.assertFalse((boolean)StringUtils.isNumericSpace((CharSequence)"hkHKHik6iUGHKJgU7tUJgKJGI87GIkug"));
        Assert.assertFalse((boolean)StringUtils.isNumericSpace((CharSequence)"_"));
        Assert.assertFalse((boolean)StringUtils.isNumericSpace((CharSequence)"hkHKHik*khbkuh"));
    }
}

