/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilsSubstringTest {
    private static final String FOO = "foo";
    private static final String BAR = "bar";
    private static final String BAZ = "baz";
    private static final String FOOBAR = "foobar";
    private static final String SENTENCE = "foo bar baz";

    @Test
    public void testSubstring_StringInt() {
        Assert.assertEquals(null, (Object)StringUtils.substring(null, (int)0));
        Assert.assertEquals((Object)"", (Object)StringUtils.substring((String)"", (int)0));
        Assert.assertEquals((Object)"", (Object)StringUtils.substring((String)"", (int)2));
        Assert.assertEquals((Object)"", (Object)StringUtils.substring((String)SENTENCE, (int)80));
        Assert.assertEquals((Object)BAZ, (Object)StringUtils.substring((String)SENTENCE, (int)8));
        Assert.assertEquals((Object)BAZ, (Object)StringUtils.substring((String)SENTENCE, (int)-3));
        Assert.assertEquals((Object)SENTENCE, (Object)StringUtils.substring((String)SENTENCE, (int)0));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.substring((String)"abc", (int)-4));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.substring((String)"abc", (int)-3));
        Assert.assertEquals((Object)"bc", (Object)StringUtils.substring((String)"abc", (int)-2));
        Assert.assertEquals((Object)"c", (Object)StringUtils.substring((String)"abc", (int)-1));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.substring((String)"abc", (int)0));
        Assert.assertEquals((Object)"bc", (Object)StringUtils.substring((String)"abc", (int)1));
        Assert.assertEquals((Object)"c", (Object)StringUtils.substring((String)"abc", (int)2));
        Assert.assertEquals((Object)"", (Object)StringUtils.substring((String)"abc", (int)3));
        Assert.assertEquals((Object)"", (Object)StringUtils.substring((String)"abc", (int)4));
    }

    @Test
    public void testSubstring_StringIntInt() {
        Assert.assertEquals(null, (Object)StringUtils.substring(null, (int)0, (int)0));
        Assert.assertEquals(null, (Object)StringUtils.substring(null, (int)1, (int)2));
        Assert.assertEquals((Object)"", (Object)StringUtils.substring((String)"", (int)0, (int)0));
        Assert.assertEquals((Object)"", (Object)StringUtils.substring((String)"", (int)1, (int)2));
        Assert.assertEquals((Object)"", (Object)StringUtils.substring((String)"", (int)-2, (int)-1));
        Assert.assertEquals((Object)"", (Object)StringUtils.substring((String)SENTENCE, (int)8, (int)6));
        Assert.assertEquals((Object)FOO, (Object)StringUtils.substring((String)SENTENCE, (int)0, (int)3));
        Assert.assertEquals((Object)"o", (Object)StringUtils.substring((String)SENTENCE, (int)-9, (int)3));
        Assert.assertEquals((Object)FOO, (Object)StringUtils.substring((String)SENTENCE, (int)0, (int)-8));
        Assert.assertEquals((Object)"o", (Object)StringUtils.substring((String)SENTENCE, (int)-9, (int)-8));
        Assert.assertEquals((Object)SENTENCE, (Object)StringUtils.substring((String)SENTENCE, (int)0, (int)80));
        Assert.assertEquals((Object)"", (Object)StringUtils.substring((String)SENTENCE, (int)2, (int)2));
        Assert.assertEquals((Object)"b", (Object)StringUtils.substring((String)"abc", (int)-2, (int)-1));
    }

    @Test
    public void testLeft_String() {
        Assert.assertSame(null, (Object)StringUtils.left(null, (int)-1));
        Assert.assertSame(null, (Object)StringUtils.left(null, (int)0));
        Assert.assertSame(null, (Object)StringUtils.left(null, (int)2));
        Assert.assertEquals((Object)"", (Object)StringUtils.left((String)"", (int)-1));
        Assert.assertEquals((Object)"", (Object)StringUtils.left((String)"", (int)0));
        Assert.assertEquals((Object)"", (Object)StringUtils.left((String)"", (int)2));
        Assert.assertEquals((Object)"", (Object)StringUtils.left((String)FOOBAR, (int)-1));
        Assert.assertEquals((Object)"", (Object)StringUtils.left((String)FOOBAR, (int)0));
        Assert.assertEquals((Object)FOO, (Object)StringUtils.left((String)FOOBAR, (int)3));
        Assert.assertSame((Object)FOOBAR, (Object)StringUtils.left((String)FOOBAR, (int)80));
    }

    @Test
    public void testRight_String() {
        Assert.assertSame(null, (Object)StringUtils.right(null, (int)-1));
        Assert.assertSame(null, (Object)StringUtils.right(null, (int)0));
        Assert.assertSame(null, (Object)StringUtils.right(null, (int)2));
        Assert.assertEquals((Object)"", (Object)StringUtils.right((String)"", (int)-1));
        Assert.assertEquals((Object)"", (Object)StringUtils.right((String)"", (int)0));
        Assert.assertEquals((Object)"", (Object)StringUtils.right((String)"", (int)2));
        Assert.assertEquals((Object)"", (Object)StringUtils.right((String)FOOBAR, (int)-1));
        Assert.assertEquals((Object)"", (Object)StringUtils.right((String)FOOBAR, (int)0));
        Assert.assertEquals((Object)BAR, (Object)StringUtils.right((String)FOOBAR, (int)3));
        Assert.assertSame((Object)FOOBAR, (Object)StringUtils.right((String)FOOBAR, (int)80));
    }

    @Test
    public void testMid_String() {
        Assert.assertSame(null, (Object)StringUtils.mid(null, (int)-1, (int)0));
        Assert.assertSame(null, (Object)StringUtils.mid(null, (int)0, (int)-1));
        Assert.assertSame(null, (Object)StringUtils.mid(null, (int)3, (int)0));
        Assert.assertSame(null, (Object)StringUtils.mid(null, (int)3, (int)2));
        Assert.assertEquals((Object)"", (Object)StringUtils.mid((String)"", (int)0, (int)-1));
        Assert.assertEquals((Object)"", (Object)StringUtils.mid((String)"", (int)0, (int)0));
        Assert.assertEquals((Object)"", (Object)StringUtils.mid((String)"", (int)0, (int)2));
        Assert.assertEquals((Object)"", (Object)StringUtils.mid((String)FOOBAR, (int)3, (int)-1));
        Assert.assertEquals((Object)"", (Object)StringUtils.mid((String)FOOBAR, (int)3, (int)0));
        Assert.assertEquals((Object)"b", (Object)StringUtils.mid((String)FOOBAR, (int)3, (int)1));
        Assert.assertEquals((Object)FOO, (Object)StringUtils.mid((String)FOOBAR, (int)0, (int)3));
        Assert.assertEquals((Object)BAR, (Object)StringUtils.mid((String)FOOBAR, (int)3, (int)3));
        Assert.assertEquals((Object)FOOBAR, (Object)StringUtils.mid((String)FOOBAR, (int)0, (int)80));
        Assert.assertEquals((Object)BAR, (Object)StringUtils.mid((String)FOOBAR, (int)3, (int)80));
        Assert.assertEquals((Object)"", (Object)StringUtils.mid((String)FOOBAR, (int)9, (int)3));
        Assert.assertEquals((Object)FOO, (Object)StringUtils.mid((String)FOOBAR, (int)-1, (int)3));
    }

    @Test
    public void testSubstringBefore_StringString() {
        Assert.assertEquals((Object)FOO, (Object)StringUtils.substringBefore((String)"fooXXbarXXbaz", (String)"XX"));
        Assert.assertEquals(null, (Object)StringUtils.substringBefore(null, null));
        Assert.assertEquals(null, (Object)StringUtils.substringBefore(null, (String)""));
        Assert.assertEquals(null, (Object)StringUtils.substringBefore(null, (String)"XX"));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringBefore((String)"", null));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringBefore((String)"", (String)""));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringBefore((String)"", (String)"XX"));
        Assert.assertEquals((Object)FOO, (Object)StringUtils.substringBefore((String)FOO, null));
        Assert.assertEquals((Object)FOO, (Object)StringUtils.substringBefore((String)FOO, (String)"b"));
        Assert.assertEquals((Object)"f", (Object)StringUtils.substringBefore((String)"foot", (String)"o"));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringBefore((String)"abc", (String)"a"));
        Assert.assertEquals((Object)"a", (Object)StringUtils.substringBefore((String)"abcba", (String)"b"));
        Assert.assertEquals((Object)"ab", (Object)StringUtils.substringBefore((String)"abc", (String)"c"));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringBefore((String)"abc", (String)""));
    }

    @Test
    public void testSubstringAfter_StringString() {
        Assert.assertEquals((Object)"barXXbaz", (Object)StringUtils.substringAfter((String)"fooXXbarXXbaz", (String)"XX"));
        Assert.assertEquals(null, (Object)StringUtils.substringAfter(null, null));
        Assert.assertEquals(null, (Object)StringUtils.substringAfter(null, (String)""));
        Assert.assertEquals(null, (Object)StringUtils.substringAfter(null, (String)"XX"));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringAfter((String)"", null));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringAfter((String)"", (String)""));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringAfter((String)"", (String)"XX"));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringAfter((String)FOO, null));
        Assert.assertEquals((Object)"ot", (Object)StringUtils.substringAfter((String)"foot", (String)"o"));
        Assert.assertEquals((Object)"bc", (Object)StringUtils.substringAfter((String)"abc", (String)"a"));
        Assert.assertEquals((Object)"cba", (Object)StringUtils.substringAfter((String)"abcba", (String)"b"));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringAfter((String)"abc", (String)"c"));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.substringAfter((String)"abc", (String)""));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringAfter((String)"abc", (String)"d"));
    }

    @Test
    public void testSubstringBeforeLast_StringString() {
        Assert.assertEquals((Object)"fooXXbar", (Object)StringUtils.substringBeforeLast((String)"fooXXbarXXbaz", (String)"XX"));
        Assert.assertEquals(null, (Object)StringUtils.substringBeforeLast(null, null));
        Assert.assertEquals(null, (Object)StringUtils.substringBeforeLast(null, (String)""));
        Assert.assertEquals(null, (Object)StringUtils.substringBeforeLast(null, (String)"XX"));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringBeforeLast((String)"", null));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringBeforeLast((String)"", (String)""));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringBeforeLast((String)"", (String)"XX"));
        Assert.assertEquals((Object)FOO, (Object)StringUtils.substringBeforeLast((String)FOO, null));
        Assert.assertEquals((Object)FOO, (Object)StringUtils.substringBeforeLast((String)FOO, (String)"b"));
        Assert.assertEquals((Object)"fo", (Object)StringUtils.substringBeforeLast((String)FOO, (String)"o"));
        Assert.assertEquals((Object)"abc\r\n", (Object)StringUtils.substringBeforeLast((String)"abc\r\n", (String)"d"));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.substringBeforeLast((String)"abcdabc", (String)"d"));
        Assert.assertEquals((Object)"abcdabc", (Object)StringUtils.substringBeforeLast((String)"abcdabcd", (String)"d"));
        Assert.assertEquals((Object)"a", (Object)StringUtils.substringBeforeLast((String)"abc", (String)"b"));
        Assert.assertEquals((Object)"abc ", (Object)StringUtils.substringBeforeLast((String)"abc \n", (String)"\n"));
        Assert.assertEquals((Object)"a", (Object)StringUtils.substringBeforeLast((String)"a", null));
        Assert.assertEquals((Object)"a", (Object)StringUtils.substringBeforeLast((String)"a", (String)""));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringBeforeLast((String)"a", (String)"a"));
    }

    @Test
    public void testSubstringAfterLast_StringString() {
        Assert.assertEquals((Object)BAZ, (Object)StringUtils.substringAfterLast((String)"fooXXbarXXbaz", (String)"XX"));
        Assert.assertEquals(null, (Object)StringUtils.substringAfterLast(null, null));
        Assert.assertEquals(null, (Object)StringUtils.substringAfterLast(null, (String)""));
        Assert.assertEquals(null, (Object)StringUtils.substringAfterLast(null, (String)"XX"));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringAfterLast((String)"", null));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringAfterLast((String)"", (String)""));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringAfterLast((String)"", (String)"a"));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringAfterLast((String)FOO, null));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringAfterLast((String)FOO, (String)"b"));
        Assert.assertEquals((Object)"t", (Object)StringUtils.substringAfterLast((String)"foot", (String)"o"));
        Assert.assertEquals((Object)"bc", (Object)StringUtils.substringAfterLast((String)"abc", (String)"a"));
        Assert.assertEquals((Object)"a", (Object)StringUtils.substringAfterLast((String)"abcba", (String)"b"));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringAfterLast((String)"abc", (String)"c"));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringAfterLast((String)"", (String)"d"));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringAfterLast((String)"abc", (String)""));
    }

    @Test
    public void testSubstringBetween_StringString() {
        Assert.assertEquals(null, (Object)StringUtils.substringBetween(null, (String)"tag"));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringBetween((String)"", (String)""));
        Assert.assertEquals(null, (Object)StringUtils.substringBetween((String)"", (String)"abc"));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringBetween((String)"    ", (String)" "));
        Assert.assertEquals(null, (Object)StringUtils.substringBetween((String)"abc", null));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringBetween((String)"abc", (String)""));
        Assert.assertEquals(null, (Object)StringUtils.substringBetween((String)"abc", (String)"a"));
        Assert.assertEquals((Object)"bc", (Object)StringUtils.substringBetween((String)"abca", (String)"a"));
        Assert.assertEquals((Object)"bc", (Object)StringUtils.substringBetween((String)"abcabca", (String)"a"));
        Assert.assertEquals((Object)BAR, (Object)StringUtils.substringBetween((String)"\nbar\n", (String)"\n"));
    }

    @Test
    public void testSubstringBetween_StringStringString() {
        Assert.assertEquals(null, (Object)StringUtils.substringBetween(null, (String)"", (String)""));
        Assert.assertEquals(null, (Object)StringUtils.substringBetween((String)"", null, (String)""));
        Assert.assertEquals(null, (Object)StringUtils.substringBetween((String)"", (String)"", null));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringBetween((String)"", (String)"", (String)""));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringBetween((String)FOO, (String)"", (String)""));
        Assert.assertEquals(null, (Object)StringUtils.substringBetween((String)FOO, (String)"", (String)"]"));
        Assert.assertEquals(null, (Object)StringUtils.substringBetween((String)FOO, (String)"[", (String)"]"));
        Assert.assertEquals((Object)"", (Object)StringUtils.substringBetween((String)"    ", (String)" ", (String)"  "));
        Assert.assertEquals((Object)BAR, (Object)StringUtils.substringBetween((String)"<foo>bar</foo>", (String)"<foo>", (String)"</foo>"));
    }

    @Test
    public void testSubstringsBetween_StringStringString() {
        String[] results = StringUtils.substringsBetween((String)"[one], [two], [three]", (String)"[", (String)"]");
        Assert.assertEquals((long)3L, (long)results.length);
        Assert.assertEquals((Object)"one", (Object)results[0]);
        Assert.assertEquals((Object)"two", (Object)results[1]);
        Assert.assertEquals((Object)"three", (Object)results[2]);
        results = StringUtils.substringsBetween((String)"[one], [two], three", (String)"[", (String)"]");
        Assert.assertEquals((long)2L, (long)results.length);
        Assert.assertEquals((Object)"one", (Object)results[0]);
        Assert.assertEquals((Object)"two", (Object)results[1]);
        results = StringUtils.substringsBetween((String)"[one], [two], three]", (String)"[", (String)"]");
        Assert.assertEquals((long)2L, (long)results.length);
        Assert.assertEquals((Object)"one", (Object)results[0]);
        Assert.assertEquals((Object)"two", (Object)results[1]);
        results = StringUtils.substringsBetween((String)"[one], two], three]", (String)"[", (String)"]");
        Assert.assertEquals((long)1L, (long)results.length);
        Assert.assertEquals((Object)"one", (Object)results[0]);
        results = StringUtils.substringsBetween((String)"one], two], [three]", (String)"[", (String)"]");
        Assert.assertEquals((long)1L, (long)results.length);
        Assert.assertEquals((Object)"three", (Object)results[0]);
        results = StringUtils.substringsBetween((String)"aabhellobabnonba", (String)"ab", (String)"ba");
        Assert.assertEquals((long)1L, (long)results.length);
        Assert.assertEquals((Object)"hello", (Object)results[0]);
        results = StringUtils.substringsBetween((String)"one, two, three", (String)"[", (String)"]");
        Assert.assertNull((Object)results);
        results = StringUtils.substringsBetween((String)"[one, two, three", (String)"[", (String)"]");
        Assert.assertNull((Object)results);
        results = StringUtils.substringsBetween((String)"one, two, three]", (String)"[", (String)"]");
        Assert.assertNull((Object)results);
        results = StringUtils.substringsBetween((String)"[one], [two], [three]", (String)"[", null);
        Assert.assertNull((Object)results);
        results = StringUtils.substringsBetween((String)"[one], [two], [three]", null, (String)"]");
        Assert.assertNull((Object)results);
        results = StringUtils.substringsBetween((String)"[one], [two], [three]", (String)"", (String)"");
        Assert.assertNull((Object)results);
        results = StringUtils.substringsBetween(null, (String)"[", (String)"]");
        Assert.assertNull((Object)results);
        results = StringUtils.substringsBetween((String)"", (String)"[", (String)"]");
        Assert.assertEquals((long)0L, (long)results.length);
    }

    @Test
    public void testCountMatches_String() {
        Assert.assertEquals((long)0L, (long)StringUtils.countMatches(null, null));
        Assert.assertEquals((long)0L, (long)StringUtils.countMatches((CharSequence)"blah", null));
        Assert.assertEquals((long)0L, (long)StringUtils.countMatches(null, (CharSequence)"DD"));
        Assert.assertEquals((long)0L, (long)StringUtils.countMatches((CharSequence)"x", (CharSequence)""));
        Assert.assertEquals((long)0L, (long)StringUtils.countMatches((CharSequence)"", (CharSequence)""));
        Assert.assertEquals((long)3L, (long)StringUtils.countMatches((CharSequence)"one long someone sentence of one", (CharSequence)"one"));
        Assert.assertEquals((long)0L, (long)StringUtils.countMatches((CharSequence)"one long someone sentence of one", (CharSequence)"two"));
        Assert.assertEquals((long)4L, (long)StringUtils.countMatches((CharSequence)"oooooooooooo", (CharSequence)"ooo"));
    }
}

