/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilsTest {
    static final String WHITESPACE;
    static final String NON_WHITESPACE;
    static final String HARD_SPACE;
    static final String TRIMMABLE;
    static final String NON_TRIMMABLE;
    private static final String[] ARRAY_LIST;
    private static final String[] EMPTY_ARRAY_LIST;
    private static final String[] NULL_ARRAY_LIST;
    private static final Object[] NULL_TO_STRING_LIST;
    private static final String[] MIXED_ARRAY_LIST;
    private static final Object[] MIXED_TYPE_LIST;
    private static final long[] LONG_PRIM_LIST;
    private static final int[] INT_PRIM_LIST;
    private static final byte[] BYTE_PRIM_LIST;
    private static final short[] SHORT_PRIM_LIST;
    private static final char[] CHAR_PRIM_LIST;
    private static final float[] FLOAT_PRIM_LIST;
    private static final double[] DOUBLE_PRIM_LIST;
    private static final String SEPARATOR = ",";
    private static final char SEPARATOR_CHAR = ';';
    private static final String TEXT_LIST = "foo,bar,baz";
    private static final String TEXT_LIST_CHAR = "foo;bar;baz";
    private static final String TEXT_LIST_NOSEP = "foobarbaz";
    private static final String FOO_UNCAP = "foo";
    private static final String FOO_CAP = "Foo";
    private static final String SENTENCE_UNCAP = "foo bar baz";
    private static final String SENTENCE_CAP = "Foo Bar Baz";

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)new StringUtils());
        Constructor<?>[] cons = StringUtils.class.getDeclaredConstructors();
        Assert.assertEquals((long)1L, (long)cons.length);
        Assert.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assert.assertTrue((boolean)Modifier.isPublic(StringUtils.class.getModifiers()));
        Assert.assertFalse((boolean)Modifier.isFinal(StringUtils.class.getModifiers()));
    }

    @Test
    public void testIsEmpty() {
        Assert.assertTrue((boolean)StringUtils.isEmpty(null));
        Assert.assertTrue((boolean)StringUtils.isEmpty((CharSequence)""));
        Assert.assertFalse((boolean)StringUtils.isEmpty((CharSequence)" "));
        Assert.assertFalse((boolean)StringUtils.isEmpty((CharSequence)"bob"));
        Assert.assertFalse((boolean)StringUtils.isEmpty((CharSequence)"  bob  "));
    }

    @Test
    public void testIsNotEmpty() {
        Assert.assertFalse((boolean)StringUtils.isNotEmpty(null));
        Assert.assertFalse((boolean)StringUtils.isNotEmpty((CharSequence)""));
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((CharSequence)" "));
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((CharSequence)"bob"));
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((CharSequence)"  bob  "));
    }

    @Test
    public void testIsAnyEmpty() {
        Assert.assertTrue((boolean)StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{null}));
        Assert.assertTrue((boolean)StringUtils.isAnyEmpty((CharSequence[])null));
        Assert.assertTrue((boolean)StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{null, FOO_UNCAP}));
        Assert.assertTrue((boolean)StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{"", "bar"}));
        Assert.assertTrue((boolean)StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{"bob", ""}));
        Assert.assertTrue((boolean)StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{"  bob  ", null}));
        Assert.assertFalse((boolean)StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{" ", "bar"}));
        Assert.assertFalse((boolean)StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{FOO_UNCAP, "bar"}));
    }

    @Test
    public void testIsNoneEmpty() {
        Assert.assertFalse((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{null}));
        Assert.assertFalse((boolean)StringUtils.isNoneEmpty((CharSequence[])null));
        Assert.assertFalse((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{null, FOO_UNCAP}));
        Assert.assertFalse((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{"", "bar"}));
        Assert.assertFalse((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{"bob", ""}));
        Assert.assertFalse((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{"  bob  ", null}));
        Assert.assertTrue((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{" ", "bar"}));
        Assert.assertTrue((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{FOO_UNCAP, "bar"}));
    }

    @Test
    public void testIsBlank() {
        Assert.assertTrue((boolean)StringUtils.isBlank(null));
        Assert.assertTrue((boolean)StringUtils.isBlank((CharSequence)""));
        Assert.assertTrue((boolean)StringUtils.isBlank((CharSequence)" "));
        Assert.assertFalse((boolean)StringUtils.isBlank((CharSequence)"bob"));
        Assert.assertFalse((boolean)StringUtils.isBlank((CharSequence)"  bob  "));
    }

    @Test
    public void testIsNotBlank() {
        Assert.assertFalse((boolean)StringUtils.isNotBlank(null));
        Assert.assertFalse((boolean)StringUtils.isNotBlank((CharSequence)""));
        Assert.assertFalse((boolean)StringUtils.isNotBlank((CharSequence)" "));
        Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)"bob"));
        Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)"  bob  "));
    }

    @Test
    public void testIsAnyBlank() {
        Assert.assertTrue((boolean)StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{null}));
        Assert.assertTrue((boolean)StringUtils.isAnyBlank((CharSequence[])null));
        Assert.assertTrue((boolean)StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{null, FOO_UNCAP}));
        Assert.assertTrue((boolean)StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{null, null}));
        Assert.assertTrue((boolean)StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{"", "bar"}));
        Assert.assertTrue((boolean)StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{"bob", ""}));
        Assert.assertTrue((boolean)StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{"  bob  ", null}));
        Assert.assertTrue((boolean)StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{" ", "bar"}));
        Assert.assertFalse((boolean)StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{FOO_UNCAP, "bar"}));
    }

    @Test
    public void testIsNoneBlank() {
        Assert.assertFalse((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{null}));
        Assert.assertFalse((boolean)StringUtils.isNoneBlank((CharSequence[])null));
        Assert.assertFalse((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{null, FOO_UNCAP}));
        Assert.assertFalse((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{null, null}));
        Assert.assertFalse((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{"", "bar"}));
        Assert.assertFalse((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{"bob", ""}));
        Assert.assertFalse((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{"  bob  ", null}));
        Assert.assertFalse((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{" ", "bar"}));
        Assert.assertTrue((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{FOO_UNCAP, "bar"}));
    }

    @Test
    public void testCaseFunctions() {
        Assert.assertNull((Object)StringUtils.upperCase(null));
        Assert.assertNull((Object)StringUtils.upperCase(null, (Locale)Locale.ENGLISH));
        Assert.assertNull((Object)StringUtils.lowerCase(null));
        Assert.assertNull((Object)StringUtils.lowerCase(null, (Locale)Locale.ENGLISH));
        Assert.assertNull((Object)StringUtils.capitalize(null));
        Assert.assertNull((Object)StringUtils.uncapitalize(null));
        Assert.assertEquals((String)"capitalize(empty-string) failed", (Object)"", (Object)StringUtils.capitalize((String)""));
        Assert.assertEquals((String)"capitalize(single-char-string) failed", (Object)"X", (Object)StringUtils.capitalize((String)"x"));
        Assert.assertEquals((String)"capitalize(String) failed", (Object)FOO_CAP, (Object)StringUtils.capitalize((String)FOO_CAP));
        Assert.assertEquals((String)"capitalize(string) failed", (Object)FOO_CAP, (Object)StringUtils.capitalize((String)FOO_UNCAP));
        Assert.assertEquals((String)"uncapitalize(String) failed", (Object)FOO_UNCAP, (Object)StringUtils.uncapitalize((String)FOO_CAP));
        Assert.assertEquals((String)"uncapitalize(string) failed", (Object)FOO_UNCAP, (Object)StringUtils.uncapitalize((String)FOO_UNCAP));
        Assert.assertEquals((String)"uncapitalize(empty-string) failed", (Object)"", (Object)StringUtils.uncapitalize((String)""));
        Assert.assertEquals((String)"uncapitalize(single-char-string) failed", (Object)"x", (Object)StringUtils.uncapitalize((String)"X"));
        Assert.assertEquals((String)"uncapitalize(capitalize(String)) failed", (Object)SENTENCE_UNCAP, (Object)StringUtils.uncapitalize((String)StringUtils.capitalize((String)SENTENCE_UNCAP)));
        Assert.assertEquals((String)"capitalize(uncapitalize(String)) failed", (Object)SENTENCE_CAP, (Object)StringUtils.capitalize((String)StringUtils.uncapitalize((String)SENTENCE_CAP)));
        Assert.assertEquals((String)"uncapitalize(capitalize(String)) failed", (Object)FOO_UNCAP, (Object)StringUtils.uncapitalize((String)StringUtils.capitalize((String)FOO_UNCAP)));
        Assert.assertEquals((String)"capitalize(uncapitalize(String)) failed", (Object)FOO_CAP, (Object)StringUtils.capitalize((String)StringUtils.uncapitalize((String)FOO_CAP)));
        Assert.assertEquals((String)"upperCase(String) failed", (Object)"FOO TEST THING", (Object)StringUtils.upperCase((String)"fOo test THING"));
        Assert.assertEquals((String)"upperCase(empty-string) failed", (Object)"", (Object)StringUtils.upperCase((String)""));
        Assert.assertEquals((String)"lowerCase(String) failed", (Object)"foo test thing", (Object)StringUtils.lowerCase((String)"fOo test THING"));
        Assert.assertEquals((String)"lowerCase(empty-string) failed", (Object)"", (Object)StringUtils.lowerCase((String)""));
        Assert.assertEquals((String)"upperCase(String, Locale) failed", (Object)"FOO TEST THING", (Object)StringUtils.upperCase((String)"fOo test THING", (Locale)Locale.ENGLISH));
        Assert.assertEquals((String)"upperCase(empty-string, Locale) failed", (Object)"", (Object)StringUtils.upperCase((String)"", (Locale)Locale.ENGLISH));
        Assert.assertEquals((String)"lowerCase(String, Locale) failed", (Object)"foo test thing", (Object)StringUtils.lowerCase((String)"fOo test THING", (Locale)Locale.ENGLISH));
        Assert.assertEquals((String)"lowerCase(empty-string, Locale) failed", (Object)"", (Object)StringUtils.lowerCase((String)"", (Locale)Locale.ENGLISH));
    }

    @Test
    public void testSwapCase_String() {
        Assert.assertNull((Object)StringUtils.swapCase(null));
        Assert.assertEquals((Object)"", (Object)StringUtils.swapCase((String)""));
        Assert.assertEquals((Object)"  ", (Object)StringUtils.swapCase((String)"  "));
        Assert.assertEquals((Object)"i", (Object)WordUtils.swapCase((String)"I"));
        Assert.assertEquals((Object)"I", (Object)WordUtils.swapCase((String)"i"));
        Assert.assertEquals((Object)"I AM HERE 123", (Object)StringUtils.swapCase((String)"i am here 123"));
        Assert.assertEquals((Object)"i aM hERE 123", (Object)StringUtils.swapCase((String)"I Am Here 123"));
        Assert.assertEquals((Object)"I AM here 123", (Object)StringUtils.swapCase((String)"i am HERE 123"));
        Assert.assertEquals((Object)"i am here 123", (Object)StringUtils.swapCase((String)"I AM HERE 123"));
        String test = "This String contains a TitleCase character: \u01c8";
        String expect = "tHIS sTRING CONTAINS A tITLEcASE CHARACTER: \u01c9";
        Assert.assertEquals((Object)"tHIS sTRING CONTAINS A tITLEcASE CHARACTER: \u01c9", (Object)WordUtils.swapCase((String)"This String contains a TitleCase character: \u01c8"));
    }

    @Test
    public void testJoin_Objects() {
        Assert.assertEquals((Object)"abc", (Object)StringUtils.join((Object[])new String[]{"a", "b", "c"}));
        Assert.assertEquals((Object)"a", (Object)StringUtils.join((Object[])new String[]{null, "", "a"}));
        Assert.assertNull((Object)StringUtils.join((Object[])null));
    }

    @Test
    public void testJoin_Objectarray() {
        Assert.assertNull((Object)StringUtils.join((Object[])null));
        Assert.assertEquals((Object)"", (Object)StringUtils.join((Object[])new Object[0]));
        Assert.assertEquals((Object)"", (Object)StringUtils.join((Object[])new Object[]{null}));
        Assert.assertEquals((Object)"", (Object)StringUtils.join((Object[])EMPTY_ARRAY_LIST));
        Assert.assertEquals((Object)"", (Object)StringUtils.join((Object[])NULL_ARRAY_LIST));
        Assert.assertEquals((Object)"null", (Object)StringUtils.join((Object[])NULL_TO_STRING_LIST));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.join((Object[])new String[]{"a", "b", "c"}));
        Assert.assertEquals((Object)"a", (Object)StringUtils.join((Object[])new String[]{null, "a", ""}));
        Assert.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.join((Object[])MIXED_ARRAY_LIST));
        Assert.assertEquals((Object)"foo2", (Object)StringUtils.join((Object[])MIXED_TYPE_LIST));
    }

    @Test
    public void testJoin_ArrayCharSeparator() {
        Assert.assertNull((Object)StringUtils.join((Object[])null, (char)','));
        Assert.assertEquals((Object)TEXT_LIST_CHAR, (Object)StringUtils.join((Object[])ARRAY_LIST, (char)';'));
        Assert.assertEquals((Object)"", (Object)StringUtils.join((Object[])EMPTY_ARRAY_LIST, (char)';'));
        Assert.assertEquals((Object)";;foo", (Object)StringUtils.join((Object[])MIXED_ARRAY_LIST, (char)';'));
        Assert.assertEquals((Object)"foo;2", (Object)StringUtils.join((Object[])MIXED_TYPE_LIST, (char)';'));
        Assert.assertEquals((Object)"/", (Object)StringUtils.join((Object[])MIXED_ARRAY_LIST, (char)'/', (int)0, (int)(MIXED_ARRAY_LIST.length - 1)));
        Assert.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.join((Object[])MIXED_TYPE_LIST, (char)'/', (int)0, (int)1));
        Assert.assertEquals((Object)"null", (Object)StringUtils.join((Object[])NULL_TO_STRING_LIST, (char)'/', (int)0, (int)1));
        Assert.assertEquals((Object)"foo/2", (Object)StringUtils.join((Object[])MIXED_TYPE_LIST, (char)'/', (int)0, (int)2));
        Assert.assertEquals((Object)"2", (Object)StringUtils.join((Object[])MIXED_TYPE_LIST, (char)'/', (int)1, (int)2));
        Assert.assertEquals((Object)"", (Object)StringUtils.join((Object[])MIXED_TYPE_LIST, (char)'/', (int)2, (int)1));
    }

    @Test
    public void testJoin_ArrayOfChars() {
        Assert.assertNull((Object)StringUtils.join((char[])null, (char)','));
        Assert.assertEquals((Object)"1;2", (Object)StringUtils.join((char[])CHAR_PRIM_LIST, (char)';'));
        Assert.assertEquals((Object)"2", (Object)StringUtils.join((char[])CHAR_PRIM_LIST, (char)';', (int)1, (int)2));
    }

    @Test
    public void testJoin_ArrayOfBytes() {
        Assert.assertNull((Object)StringUtils.join((byte[])null, (char)','));
        Assert.assertEquals((Object)"1;2", (Object)StringUtils.join((byte[])BYTE_PRIM_LIST, (char)';'));
        Assert.assertEquals((Object)"2", (Object)StringUtils.join((byte[])BYTE_PRIM_LIST, (char)';', (int)1, (int)2));
    }

    @Test
    public void testJoin_ArrayOfInts() {
        Assert.assertNull((Object)StringUtils.join((int[])null, (char)','));
        Assert.assertEquals((Object)"1;2", (Object)StringUtils.join((int[])INT_PRIM_LIST, (char)';'));
        Assert.assertEquals((Object)"2", (Object)StringUtils.join((int[])INT_PRIM_LIST, (char)';', (int)1, (int)2));
    }

    @Test
    public void testJoin_ArrayOfLongs() {
        Assert.assertNull((Object)StringUtils.join((long[])null, (char)','));
        Assert.assertEquals((Object)"1;2", (Object)StringUtils.join((long[])LONG_PRIM_LIST, (char)';'));
        Assert.assertEquals((Object)"2", (Object)StringUtils.join((long[])LONG_PRIM_LIST, (char)';', (int)1, (int)2));
    }

    @Test
    public void testJoin_ArrayOfFloats() {
        Assert.assertNull((Object)StringUtils.join((float[])null, (char)','));
        Assert.assertEquals((Object)"1.0;2.0", (Object)StringUtils.join((float[])FLOAT_PRIM_LIST, (char)';'));
        Assert.assertEquals((Object)"2.0", (Object)StringUtils.join((float[])FLOAT_PRIM_LIST, (char)';', (int)1, (int)2));
    }

    @Test
    public void testJoin_ArrayOfDoubles() {
        Assert.assertNull((Object)StringUtils.join((double[])null, (char)','));
        Assert.assertEquals((Object)"1.0;2.0", (Object)StringUtils.join((double[])DOUBLE_PRIM_LIST, (char)';'));
        Assert.assertEquals((Object)"2.0", (Object)StringUtils.join((double[])DOUBLE_PRIM_LIST, (char)';', (int)1, (int)2));
    }

    @Test
    public void testJoin_ArrayOfShorts() {
        Assert.assertNull((Object)StringUtils.join((short[])null, (char)','));
        Assert.assertEquals((Object)"1;2", (Object)StringUtils.join((short[])SHORT_PRIM_LIST, (char)';'));
        Assert.assertEquals((Object)"2", (Object)StringUtils.join((short[])SHORT_PRIM_LIST, (char)';', (int)1, (int)2));
    }

    @Test
    public void testJoin_ArrayString() {
        Assert.assertNull((Object)StringUtils.join((Object[])null, null));
        Assert.assertEquals((Object)TEXT_LIST_NOSEP, (Object)StringUtils.join((Object[])ARRAY_LIST, null));
        Assert.assertEquals((Object)TEXT_LIST_NOSEP, (Object)StringUtils.join((Object[])ARRAY_LIST, (String)""));
        Assert.assertEquals((Object)"", (Object)StringUtils.join((Object[])NULL_ARRAY_LIST, null));
        Assert.assertEquals((Object)"", (Object)StringUtils.join((Object[])EMPTY_ARRAY_LIST, null));
        Assert.assertEquals((Object)"", (Object)StringUtils.join((Object[])EMPTY_ARRAY_LIST, (String)""));
        Assert.assertEquals((Object)"", (Object)StringUtils.join((Object[])EMPTY_ARRAY_LIST, (String)SEPARATOR));
        Assert.assertEquals((Object)TEXT_LIST, (Object)StringUtils.join((Object[])ARRAY_LIST, (String)SEPARATOR));
        Assert.assertEquals((Object)",,foo", (Object)StringUtils.join((Object[])MIXED_ARRAY_LIST, (String)SEPARATOR));
        Assert.assertEquals((Object)"foo,2", (Object)StringUtils.join((Object[])MIXED_TYPE_LIST, (String)SEPARATOR));
        Assert.assertEquals((Object)"/", (Object)StringUtils.join((Object[])MIXED_ARRAY_LIST, (String)"/", (int)0, (int)(MIXED_ARRAY_LIST.length - 1)));
        Assert.assertEquals((Object)"", (Object)StringUtils.join((Object[])MIXED_ARRAY_LIST, (String)"", (int)0, (int)(MIXED_ARRAY_LIST.length - 1)));
        Assert.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.join((Object[])MIXED_TYPE_LIST, (String)"/", (int)0, (int)1));
        Assert.assertEquals((Object)"foo/2", (Object)StringUtils.join((Object[])MIXED_TYPE_LIST, (String)"/", (int)0, (int)2));
        Assert.assertEquals((Object)"2", (Object)StringUtils.join((Object[])MIXED_TYPE_LIST, (String)"/", (int)1, (int)2));
        Assert.assertEquals((Object)"", (Object)StringUtils.join((Object[])MIXED_TYPE_LIST, (String)"/", (int)2, (int)1));
    }

    @Test
    public void testJoin_IteratorChar() {
        Assert.assertNull((Object)StringUtils.join((Iterator)null, (char)','));
        Assert.assertEquals((Object)TEXT_LIST_CHAR, (Object)StringUtils.join(Arrays.asList(ARRAY_LIST).iterator(), (char)';'));
        Assert.assertEquals((Object)"", (Object)StringUtils.join(Arrays.asList(NULL_ARRAY_LIST).iterator(), (char)';'));
        Assert.assertEquals((Object)"", (Object)StringUtils.join(Arrays.asList(EMPTY_ARRAY_LIST).iterator(), (char)';'));
        Assert.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.join(Collections.singleton(FOO_UNCAP).iterator(), (char)'x'));
    }

    @Test
    public void testJoin_IteratorString() {
        Assert.assertNull((Object)StringUtils.join((Iterator)null, null));
        Assert.assertEquals((Object)TEXT_LIST_NOSEP, (Object)StringUtils.join(Arrays.asList(ARRAY_LIST).iterator(), null));
        Assert.assertEquals((Object)TEXT_LIST_NOSEP, (Object)StringUtils.join(Arrays.asList(ARRAY_LIST).iterator(), (String)""));
        Assert.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.join(Collections.singleton(FOO_UNCAP).iterator(), (String)"x"));
        Assert.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.join(Collections.singleton(FOO_UNCAP).iterator(), null));
        Assert.assertEquals((Object)"", (Object)StringUtils.join(Arrays.asList(NULL_ARRAY_LIST).iterator(), null));
        Assert.assertEquals((Object)"", (Object)StringUtils.join(Arrays.asList(EMPTY_ARRAY_LIST).iterator(), null));
        Assert.assertEquals((Object)"", (Object)StringUtils.join(Arrays.asList(EMPTY_ARRAY_LIST).iterator(), (String)""));
        Assert.assertEquals((Object)"", (Object)StringUtils.join(Arrays.asList(EMPTY_ARRAY_LIST).iterator(), (String)SEPARATOR));
        Assert.assertEquals((Object)TEXT_LIST, (Object)StringUtils.join(Arrays.asList(ARRAY_LIST).iterator(), (String)SEPARATOR));
    }

    @Test
    public void testJoin_IterableChar() {
        Assert.assertNull((Object)StringUtils.join((Iterable)null, (char)','));
        Assert.assertEquals((Object)TEXT_LIST_CHAR, (Object)StringUtils.join(Arrays.asList(ARRAY_LIST), (char)';'));
        Assert.assertEquals((Object)"", (Object)StringUtils.join(Arrays.asList(NULL_ARRAY_LIST), (char)';'));
        Assert.assertEquals((Object)"", (Object)StringUtils.join(Arrays.asList(EMPTY_ARRAY_LIST), (char)';'));
        Assert.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.join(Collections.singleton(FOO_UNCAP), (char)'x'));
    }

    @Test
    public void testJoin_IterableString() {
        Assert.assertNull((Object)StringUtils.join((Iterable)null, null));
        Assert.assertEquals((Object)TEXT_LIST_NOSEP, (Object)StringUtils.join(Arrays.asList(ARRAY_LIST), null));
        Assert.assertEquals((Object)TEXT_LIST_NOSEP, (Object)StringUtils.join(Arrays.asList(ARRAY_LIST), (String)""));
        Assert.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.join(Collections.singleton(FOO_UNCAP), (String)"x"));
        Assert.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.join(Collections.singleton(FOO_UNCAP), null));
        Assert.assertEquals((Object)"", (Object)StringUtils.join(Arrays.asList(NULL_ARRAY_LIST), null));
        Assert.assertEquals((Object)"", (Object)StringUtils.join(Arrays.asList(EMPTY_ARRAY_LIST), null));
        Assert.assertEquals((Object)"", (Object)StringUtils.join(Arrays.asList(EMPTY_ARRAY_LIST), (String)""));
        Assert.assertEquals((Object)"", (Object)StringUtils.join(Arrays.asList(EMPTY_ARRAY_LIST), (String)SEPARATOR));
        Assert.assertEquals((Object)TEXT_LIST, (Object)StringUtils.join(Arrays.asList(ARRAY_LIST), (String)SEPARATOR));
    }

    @Test
    public void testSplit_String() {
        Assert.assertNull((Object)StringUtils.split(null));
        Assert.assertEquals((long)0L, (long)StringUtils.split((String)"").length);
        String str = "a b  .c";
        String[] res = StringUtils.split((String)str);
        Assert.assertEquals((long)3L, (long)res.length);
        Assert.assertEquals((Object)"a", (Object)res[0]);
        Assert.assertEquals((Object)"b", (Object)res[1]);
        Assert.assertEquals((Object)".c", (Object)res[2]);
        str = " a ";
        res = StringUtils.split((String)str);
        Assert.assertEquals((long)1L, (long)res.length);
        Assert.assertEquals((Object)"a", (Object)res[0]);
        str = "a" + WHITESPACE + "b" + NON_WHITESPACE + "c";
        res = StringUtils.split((String)str);
        Assert.assertEquals((long)2L, (long)res.length);
        Assert.assertEquals((Object)"a", (Object)res[0]);
        Assert.assertEquals((Object)("b" + NON_WHITESPACE + "c"), (Object)res[1]);
    }

    @Test
    public void testSplit_StringChar() {
        Assert.assertNull((Object)StringUtils.split(null, (char)'.'));
        Assert.assertEquals((long)0L, (long)StringUtils.split((String)"", (char)'.').length);
        String str = "a.b.. c";
        String[] res = StringUtils.split((String)str, (char)'.');
        Assert.assertEquals((long)3L, (long)res.length);
        Assert.assertEquals((Object)"a", (Object)res[0]);
        Assert.assertEquals((Object)"b", (Object)res[1]);
        Assert.assertEquals((Object)" c", (Object)res[2]);
        str = ".a.";
        res = StringUtils.split((String)str, (char)'.');
        Assert.assertEquals((long)1L, (long)res.length);
        Assert.assertEquals((Object)"a", (Object)res[0]);
        str = "a b c";
        res = StringUtils.split((String)str, (char)' ');
        Assert.assertEquals((long)3L, (long)res.length);
        Assert.assertEquals((Object)"a", (Object)res[0]);
        Assert.assertEquals((Object)"b", (Object)res[1]);
        Assert.assertEquals((Object)"c", (Object)res[2]);
    }

    @Test
    public void testSplit_StringString_StringStringInt() {
        Assert.assertNull((Object)StringUtils.split(null, (String)"."));
        Assert.assertNull((Object)StringUtils.split(null, (String)".", (int)3));
        Assert.assertEquals((long)0L, (long)StringUtils.split((String)"", (String)".").length);
        Assert.assertEquals((long)0L, (long)StringUtils.split((String)"", (String)".", (int)3).length);
        this.innerTestSplit('.', ".", ' ');
        this.innerTestSplit('.', ".", ',');
        this.innerTestSplit('.', ".,", 'x');
        for (int i = 0; i < WHITESPACE.length(); ++i) {
            for (int j = 0; j < NON_WHITESPACE.length(); ++j) {
                this.innerTestSplit(WHITESPACE.charAt(i), null, NON_WHITESPACE.charAt(j));
                this.innerTestSplit(WHITESPACE.charAt(i), String.valueOf(WHITESPACE.charAt(i)), NON_WHITESPACE.charAt(j));
            }
        }
        String[] expectedResults = new String[]{"ab", "de fg"};
        String[] results = StringUtils.split((String)"ab   de fg", null, (int)2);
        Assert.assertEquals((long)expectedResults.length, (long)results.length);
        for (int i = 0; i < expectedResults.length; ++i) {
            Assert.assertEquals((Object)expectedResults[i], (Object)results[i]);
        }
        String[] expectedResults2 = new String[]{"ab", "cd:ef"};
        results = StringUtils.split((String)"ab:cd:ef", (String)":", (int)2);
        Assert.assertEquals((long)expectedResults2.length, (long)results.length);
        for (int i = 0; i < expectedResults2.length; ++i) {
            Assert.assertEquals((Object)expectedResults2[i], (Object)results[i]);
        }
    }

    private void innerTestSplit(char separator, String sepStr, char noMatch) {
        String msg = "Failed on separator hex(" + Integer.toHexString(separator) + "), noMatch hex(" + Integer.toHexString(noMatch) + "), sepStr(" + sepStr + ")";
        String str = "a" + separator + "b" + separator + separator + noMatch + "c";
        String[] res = StringUtils.split((String)str, (String)sepStr);
        Assert.assertEquals((String)msg, (long)3L, (long)res.length);
        Assert.assertEquals((String)msg, (Object)"a", (Object)res[0]);
        Assert.assertEquals((String)msg, (Object)"b", (Object)res[1]);
        Assert.assertEquals((String)msg, (Object)(noMatch + "c"), (Object)res[2]);
        String str2 = separator + "a" + separator;
        res = StringUtils.split((String)str2, (String)sepStr);
        Assert.assertEquals((String)msg, (long)1L, (long)res.length);
        Assert.assertEquals((String)msg, (Object)"a", (Object)res[0]);
        res = StringUtils.split((String)str, (String)sepStr, (int)-1);
        Assert.assertEquals((String)msg, (long)3L, (long)res.length);
        Assert.assertEquals((String)msg, (Object)"a", (Object)res[0]);
        Assert.assertEquals((String)msg, (Object)"b", (Object)res[1]);
        Assert.assertEquals((String)msg, (Object)(noMatch + "c"), (Object)res[2]);
        res = StringUtils.split((String)str, (String)sepStr, (int)0);
        Assert.assertEquals((String)msg, (long)3L, (long)res.length);
        Assert.assertEquals((String)msg, (Object)"a", (Object)res[0]);
        Assert.assertEquals((String)msg, (Object)"b", (Object)res[1]);
        Assert.assertEquals((String)msg, (Object)(noMatch + "c"), (Object)res[2]);
        res = StringUtils.split((String)str, (String)sepStr, (int)1);
        Assert.assertEquals((String)msg, (long)1L, (long)res.length);
        Assert.assertEquals((String)msg, (Object)str, (Object)res[0]);
        res = StringUtils.split((String)str, (String)sepStr, (int)2);
        Assert.assertEquals((String)msg, (long)2L, (long)res.length);
        Assert.assertEquals((String)msg, (Object)"a", (Object)res[0]);
        Assert.assertEquals((String)msg, (Object)str.substring(2), (Object)res[1]);
    }

    @Test
    public void testSplitByWholeString_StringStringBoolean() {
        Assert.assertArrayEquals(null, (Object[])StringUtils.splitByWholeSeparator(null, (String)"."));
        Assert.assertEquals((long)0L, (long)StringUtils.splitByWholeSeparator((String)"", (String)".").length);
        String stringToSplitOnNulls = "ab   de fg";
        String[] splitOnNullExpectedResults = new String[]{"ab", "de", "fg"};
        String[] splitOnNullResults = StringUtils.splitByWholeSeparator((String)"ab   de fg", null);
        Assert.assertEquals((long)splitOnNullExpectedResults.length, (long)splitOnNullResults.length);
        for (int i = 0; i < splitOnNullExpectedResults.length; ++i) {
            Assert.assertEquals((Object)splitOnNullExpectedResults[i], (Object)splitOnNullResults[i]);
        }
        String stringToSplitOnCharactersAndString = "abstemiouslyaeiouyabstemiously";
        String[] splitOnStringExpectedResults = new String[]{"abstemiously", "abstemiously"};
        String[] splitOnStringResults = StringUtils.splitByWholeSeparator((String)"abstemiouslyaeiouyabstemiously", (String)"aeiouy");
        Assert.assertEquals((long)splitOnStringExpectedResults.length, (long)splitOnStringResults.length);
        for (int i = 0; i < splitOnStringExpectedResults.length; ++i) {
            Assert.assertEquals((Object)splitOnStringExpectedResults[i], (Object)splitOnStringResults[i]);
        }
        String[] splitWithMultipleSeparatorExpectedResults = new String[]{"ab", "cd", "ef"};
        String[] splitWithMultipleSeparator = StringUtils.splitByWholeSeparator((String)"ab:cd::ef", (String)":");
        Assert.assertEquals((long)splitWithMultipleSeparatorExpectedResults.length, (long)splitWithMultipleSeparator.length);
        for (int i = 0; i < splitWithMultipleSeparatorExpectedResults.length; ++i) {
            Assert.assertEquals((Object)splitWithMultipleSeparatorExpectedResults[i], (Object)splitWithMultipleSeparator[i]);
        }
    }

    @Test
    public void testSplitByWholeString_StringStringBooleanInt() {
        Assert.assertArrayEquals(null, (Object[])StringUtils.splitByWholeSeparator(null, (String)".", (int)3));
        Assert.assertEquals((long)0L, (long)StringUtils.splitByWholeSeparator((String)"", (String)".", (int)3).length);
        String stringToSplitOnNulls = "ab   de fg";
        String[] splitOnNullExpectedResults = new String[]{"ab", "de fg"};
        String[] splitOnNullResults = StringUtils.splitByWholeSeparator((String)"ab   de fg", null, (int)2);
        Assert.assertEquals((long)splitOnNullExpectedResults.length, (long)splitOnNullResults.length);
        for (int i = 0; i < splitOnNullExpectedResults.length; ++i) {
            Assert.assertEquals((Object)splitOnNullExpectedResults[i], (Object)splitOnNullResults[i]);
        }
        String stringToSplitOnCharactersAndString = "abstemiouslyaeiouyabstemiouslyaeiouyabstemiously";
        String[] splitOnStringExpectedResults = new String[]{"abstemiously", "abstemiouslyaeiouyabstemiously"};
        String[] splitOnStringResults = StringUtils.splitByWholeSeparator((String)"abstemiouslyaeiouyabstemiouslyaeiouyabstemiously", (String)"aeiouy", (int)2);
        Assert.assertEquals((long)splitOnStringExpectedResults.length, (long)splitOnStringResults.length);
        for (int i = 0; i < splitOnStringExpectedResults.length; ++i) {
            Assert.assertEquals((Object)splitOnStringExpectedResults[i], (Object)splitOnStringResults[i]);
        }
    }

    @Test
    public void testSplitByWholeSeparatorPreserveAllTokens_StringStringInt() {
        int i;
        Assert.assertArrayEquals(null, (Object[])StringUtils.splitByWholeSeparatorPreserveAllTokens(null, (String)".", (int)-1));
        Assert.assertEquals((long)0L, (long)StringUtils.splitByWholeSeparatorPreserveAllTokens((String)"", (String)".", (int)-1).length);
        String input = "ab   de fg";
        String[] expected = new String[]{"ab", "", "", "de", "fg"};
        String[] actual = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)input, null, (int)-1);
        Assert.assertEquals((long)expected.length, (long)actual.length);
        for (i = 0; i < actual.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)actual[i]);
        }
        input = "1::2:::3::::4";
        expected = new String[]{"1", "", "2", "", "", "3", "", "", "", "4"};
        actual = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)input, (String)":", (int)-1);
        Assert.assertEquals((long)expected.length, (long)actual.length);
        for (i = 0; i < actual.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)actual[i]);
        }
        input = "1::2:::3::::4";
        expected = new String[]{"1", "2", ":3", "", "4"};
        actual = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)input, (String)"::", (int)-1);
        Assert.assertEquals((long)expected.length, (long)actual.length);
        for (i = 0; i < actual.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)actual[i]);
        }
        input = "1::2::3:4";
        expected = new String[]{"1", "", "2", ":3:4"};
        actual = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)input, (String)":", (int)4);
        Assert.assertEquals((long)expected.length, (long)actual.length);
        for (i = 0; i < actual.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)actual[i]);
        }
    }

    @Test
    public void testSplitPreserveAllTokens_String() {
        Assert.assertNull((Object)StringUtils.splitPreserveAllTokens(null));
        Assert.assertEquals((long)0L, (long)StringUtils.splitPreserveAllTokens((String)"").length);
        String str = "abc def";
        String[] res = StringUtils.splitPreserveAllTokens((String)str);
        Assert.assertEquals((long)2L, (long)res.length);
        Assert.assertEquals((Object)"abc", (Object)res[0]);
        Assert.assertEquals((Object)"def", (Object)res[1]);
        str = "abc  def";
        res = StringUtils.splitPreserveAllTokens((String)str);
        Assert.assertEquals((long)3L, (long)res.length);
        Assert.assertEquals((Object)"abc", (Object)res[0]);
        Assert.assertEquals((Object)"", (Object)res[1]);
        Assert.assertEquals((Object)"def", (Object)res[2]);
        str = " abc ";
        res = StringUtils.splitPreserveAllTokens((String)str);
        Assert.assertEquals((long)3L, (long)res.length);
        Assert.assertEquals((Object)"", (Object)res[0]);
        Assert.assertEquals((Object)"abc", (Object)res[1]);
        Assert.assertEquals((Object)"", (Object)res[2]);
        str = "a b .c";
        res = StringUtils.splitPreserveAllTokens((String)str);
        Assert.assertEquals((long)3L, (long)res.length);
        Assert.assertEquals((Object)"a", (Object)res[0]);
        Assert.assertEquals((Object)"b", (Object)res[1]);
        Assert.assertEquals((Object)".c", (Object)res[2]);
        str = " a b .c";
        res = StringUtils.splitPreserveAllTokens((String)str);
        Assert.assertEquals((long)4L, (long)res.length);
        Assert.assertEquals((Object)"", (Object)res[0]);
        Assert.assertEquals((Object)"a", (Object)res[1]);
        Assert.assertEquals((Object)"b", (Object)res[2]);
        Assert.assertEquals((Object)".c", (Object)res[3]);
        str = "a  b  .c";
        res = StringUtils.splitPreserveAllTokens((String)str);
        Assert.assertEquals((long)5L, (long)res.length);
        Assert.assertEquals((Object)"a", (Object)res[0]);
        Assert.assertEquals((Object)"", (Object)res[1]);
        Assert.assertEquals((Object)"b", (Object)res[2]);
        Assert.assertEquals((Object)"", (Object)res[3]);
        Assert.assertEquals((Object)".c", (Object)res[4]);
        str = " a  ";
        res = StringUtils.splitPreserveAllTokens((String)str);
        Assert.assertEquals((long)4L, (long)res.length);
        Assert.assertEquals((Object)"", (Object)res[0]);
        Assert.assertEquals((Object)"a", (Object)res[1]);
        Assert.assertEquals((Object)"", (Object)res[2]);
        Assert.assertEquals((Object)"", (Object)res[3]);
        str = " a  b";
        res = StringUtils.splitPreserveAllTokens((String)str);
        Assert.assertEquals((long)4L, (long)res.length);
        Assert.assertEquals((Object)"", (Object)res[0]);
        Assert.assertEquals((Object)"a", (Object)res[1]);
        Assert.assertEquals((Object)"", (Object)res[2]);
        Assert.assertEquals((Object)"b", (Object)res[3]);
        str = "a" + WHITESPACE + "b" + NON_WHITESPACE + "c";
        res = StringUtils.splitPreserveAllTokens((String)str);
        Assert.assertEquals((long)(WHITESPACE.length() + 1), (long)res.length);
        Assert.assertEquals((Object)"a", (Object)res[0]);
        for (int i = 1; i < WHITESPACE.length() - 1; ++i) {
            Assert.assertEquals((Object)"", (Object)res[i]);
        }
        Assert.assertEquals((Object)("b" + NON_WHITESPACE + "c"), (Object)res[WHITESPACE.length()]);
    }

    @Test
    public void testSplitPreserveAllTokens_StringChar() {
        Assert.assertNull((Object)StringUtils.splitPreserveAllTokens(null, (char)'.'));
        Assert.assertEquals((long)0L, (long)StringUtils.splitPreserveAllTokens((String)"", (char)'.').length);
        String str = "a.b. c";
        String[] res = StringUtils.splitPreserveAllTokens((String)str, (char)'.');
        Assert.assertEquals((long)3L, (long)res.length);
        Assert.assertEquals((Object)"a", (Object)res[0]);
        Assert.assertEquals((Object)"b", (Object)res[1]);
        Assert.assertEquals((Object)" c", (Object)res[2]);
        str = "a.b.. c";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)'.');
        Assert.assertEquals((long)4L, (long)res.length);
        Assert.assertEquals((Object)"a", (Object)res[0]);
        Assert.assertEquals((Object)"b", (Object)res[1]);
        Assert.assertEquals((Object)"", (Object)res[2]);
        Assert.assertEquals((Object)" c", (Object)res[3]);
        str = ".a.";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)'.');
        Assert.assertEquals((long)3L, (long)res.length);
        Assert.assertEquals((Object)"", (Object)res[0]);
        Assert.assertEquals((Object)"a", (Object)res[1]);
        Assert.assertEquals((Object)"", (Object)res[2]);
        str = ".a..";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)'.');
        Assert.assertEquals((long)4L, (long)res.length);
        Assert.assertEquals((Object)"", (Object)res[0]);
        Assert.assertEquals((Object)"a", (Object)res[1]);
        Assert.assertEquals((Object)"", (Object)res[2]);
        Assert.assertEquals((Object)"", (Object)res[3]);
        str = "..a.";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)'.');
        Assert.assertEquals((long)4L, (long)res.length);
        Assert.assertEquals((Object)"", (Object)res[0]);
        Assert.assertEquals((Object)"", (Object)res[1]);
        Assert.assertEquals((Object)"a", (Object)res[2]);
        Assert.assertEquals((Object)"", (Object)res[3]);
        str = "..a";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)'.');
        Assert.assertEquals((long)3L, (long)res.length);
        Assert.assertEquals((Object)"", (Object)res[0]);
        Assert.assertEquals((Object)"", (Object)res[1]);
        Assert.assertEquals((Object)"a", (Object)res[2]);
        str = "a b c";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)' ');
        Assert.assertEquals((long)3L, (long)res.length);
        Assert.assertEquals((Object)"a", (Object)res[0]);
        Assert.assertEquals((Object)"b", (Object)res[1]);
        Assert.assertEquals((Object)"c", (Object)res[2]);
        str = "a  b  c";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)' ');
        Assert.assertEquals((long)5L, (long)res.length);
        Assert.assertEquals((Object)"a", (Object)res[0]);
        Assert.assertEquals((Object)"", (Object)res[1]);
        Assert.assertEquals((Object)"b", (Object)res[2]);
        Assert.assertEquals((Object)"", (Object)res[3]);
        Assert.assertEquals((Object)"c", (Object)res[4]);
        str = " a b c";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)' ');
        Assert.assertEquals((long)4L, (long)res.length);
        Assert.assertEquals((Object)"", (Object)res[0]);
        Assert.assertEquals((Object)"a", (Object)res[1]);
        Assert.assertEquals((Object)"b", (Object)res[2]);
        Assert.assertEquals((Object)"c", (Object)res[3]);
        str = "  a b c";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)' ');
        Assert.assertEquals((long)5L, (long)res.length);
        Assert.assertEquals((Object)"", (Object)res[0]);
        Assert.assertEquals((Object)"", (Object)res[1]);
        Assert.assertEquals((Object)"a", (Object)res[2]);
        Assert.assertEquals((Object)"b", (Object)res[3]);
        Assert.assertEquals((Object)"c", (Object)res[4]);
        str = "a b c ";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)' ');
        Assert.assertEquals((long)4L, (long)res.length);
        Assert.assertEquals((Object)"a", (Object)res[0]);
        Assert.assertEquals((Object)"b", (Object)res[1]);
        Assert.assertEquals((Object)"c", (Object)res[2]);
        Assert.assertEquals((Object)"", (Object)res[3]);
        str = "a b c  ";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)' ');
        Assert.assertEquals((long)5L, (long)res.length);
        Assert.assertEquals((Object)"a", (Object)res[0]);
        Assert.assertEquals((Object)"b", (Object)res[1]);
        Assert.assertEquals((Object)"c", (Object)res[2]);
        Assert.assertEquals((Object)"", (Object)res[3]);
        Assert.assertEquals((Object)"", (Object)res[3]);
        String[] expectedResults = new String[]{"a", "", "b", "c"};
        String[] results = StringUtils.splitPreserveAllTokens((String)"a..b.c", (char)'.');
        Assert.assertEquals((long)expectedResults.length, (long)results.length);
        for (int i = 0; i < expectedResults.length; ++i) {
            Assert.assertEquals((Object)expectedResults[i], (Object)results[i]);
        }
    }

    @Test
    public void testSplitPreserveAllTokens_StringString_StringStringInt() {
        int i;
        Assert.assertNull((Object)StringUtils.splitPreserveAllTokens(null, (String)"."));
        Assert.assertNull((Object)StringUtils.splitPreserveAllTokens(null, (String)".", (int)3));
        Assert.assertEquals((long)0L, (long)StringUtils.splitPreserveAllTokens((String)"", (String)".").length);
        Assert.assertEquals((long)0L, (long)StringUtils.splitPreserveAllTokens((String)"", (String)".", (int)3).length);
        this.innerTestSplitPreserveAllTokens('.', ".", ' ');
        this.innerTestSplitPreserveAllTokens('.', ".", ',');
        this.innerTestSplitPreserveAllTokens('.', ".,", 'x');
        for (int i2 = 0; i2 < WHITESPACE.length(); ++i2) {
            for (int j = 0; j < NON_WHITESPACE.length(); ++j) {
                this.innerTestSplitPreserveAllTokens(WHITESPACE.charAt(i2), null, NON_WHITESPACE.charAt(j));
                this.innerTestSplitPreserveAllTokens(WHITESPACE.charAt(i2), String.valueOf(WHITESPACE.charAt(i2)), NON_WHITESPACE.charAt(j));
            }
        }
        String[] expectedResults = new String[]{"ab", "de fg"};
        String[] results = StringUtils.splitPreserveAllTokens((String)"ab de fg", null, (int)2);
        Assert.assertEquals((long)expectedResults.length, (long)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            Assert.assertEquals((Object)expectedResults[i], (Object)results[i]);
        }
        expectedResults = new String[]{"ab", "  de fg"};
        results = StringUtils.splitPreserveAllTokens((String)"ab   de fg", null, (int)2);
        Assert.assertEquals((long)expectedResults.length, (long)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            Assert.assertEquals((Object)expectedResults[i], (Object)results[i]);
        }
        expectedResults = new String[]{"ab", "::de:fg"};
        results = StringUtils.splitPreserveAllTokens((String)"ab:::de:fg", (String)":", (int)2);
        Assert.assertEquals((long)expectedResults.length, (long)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            Assert.assertEquals((Object)expectedResults[i], (Object)results[i]);
        }
        expectedResults = new String[]{"ab", "", " de fg"};
        results = StringUtils.splitPreserveAllTokens((String)"ab   de fg", null, (int)3);
        Assert.assertEquals((long)expectedResults.length, (long)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            Assert.assertEquals((Object)expectedResults[i], (Object)results[i]);
        }
        expectedResults = new String[]{"ab", "", "", "de fg"};
        results = StringUtils.splitPreserveAllTokens((String)"ab   de fg", null, (int)4);
        Assert.assertEquals((long)expectedResults.length, (long)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            Assert.assertEquals((Object)expectedResults[i], (Object)results[i]);
        }
        String[] expectedResults2 = new String[]{"ab", "cd:ef"};
        String[] results2 = StringUtils.splitPreserveAllTokens((String)"ab:cd:ef", (String)":", (int)2);
        Assert.assertEquals((long)expectedResults2.length, (long)results2.length);
        for (i = 0; i < expectedResults2.length; ++i) {
            Assert.assertEquals((Object)expectedResults2[i], (Object)results2[i]);
        }
        expectedResults = new String[]{"ab", ":cd:ef"};
        results = StringUtils.splitPreserveAllTokens((String)"ab::cd:ef", (String)":", (int)2);
        Assert.assertEquals((long)expectedResults.length, (long)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            Assert.assertEquals((Object)expectedResults[i], (Object)results[i]);
        }
        expectedResults = new String[]{"ab", "", ":cd:ef"};
        results = StringUtils.splitPreserveAllTokens((String)"ab:::cd:ef", (String)":", (int)3);
        Assert.assertEquals((long)expectedResults.length, (long)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            Assert.assertEquals((Object)expectedResults[i], (Object)results[i]);
        }
        expectedResults = new String[]{"ab", "", "", "cd:ef"};
        results = StringUtils.splitPreserveAllTokens((String)"ab:::cd:ef", (String)":", (int)4);
        Assert.assertEquals((long)expectedResults.length, (long)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            Assert.assertEquals((Object)expectedResults[i], (Object)results[i]);
        }
        expectedResults = new String[]{"", "ab", "", "", "cd:ef"};
        results = StringUtils.splitPreserveAllTokens((String)":ab:::cd:ef", (String)":", (int)5);
        Assert.assertEquals((long)expectedResults.length, (long)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            Assert.assertEquals((Object)expectedResults[i], (Object)results[i]);
        }
        expectedResults = new String[]{"", "", "ab", "", "", "cd:ef"};
        results = StringUtils.splitPreserveAllTokens((String)"::ab:::cd:ef", (String)":", (int)6);
        Assert.assertEquals((long)expectedResults.length, (long)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            Assert.assertEquals((Object)expectedResults[i], (Object)results[i]);
        }
    }

    private void innerTestSplitPreserveAllTokens(char separator, String sepStr, char noMatch) {
        String msg = "Failed on separator hex(" + Integer.toHexString(separator) + "), noMatch hex(" + Integer.toHexString(noMatch) + "), sepStr(" + sepStr + ")";
        String str = "a" + separator + "b" + separator + separator + noMatch + "c";
        String[] res = StringUtils.splitPreserveAllTokens((String)str, (String)sepStr);
        Assert.assertEquals((String)msg, (long)4L, (long)res.length);
        Assert.assertEquals((String)msg, (Object)"a", (Object)res[0]);
        Assert.assertEquals((String)msg, (Object)"b", (Object)res[1]);
        Assert.assertEquals((String)msg, (Object)"", (Object)res[2]);
        Assert.assertEquals((String)msg, (Object)(noMatch + "c"), (Object)res[3]);
        String str2 = separator + "a" + separator;
        res = StringUtils.splitPreserveAllTokens((String)str2, (String)sepStr);
        Assert.assertEquals((String)msg, (long)3L, (long)res.length);
        Assert.assertEquals((String)msg, (Object)"", (Object)res[0]);
        Assert.assertEquals((String)msg, (Object)"a", (Object)res[1]);
        Assert.assertEquals((String)msg, (Object)"", (Object)res[2]);
        res = StringUtils.splitPreserveAllTokens((String)str, (String)sepStr, (int)-1);
        Assert.assertEquals((String)msg, (long)4L, (long)res.length);
        Assert.assertEquals((String)msg, (Object)"a", (Object)res[0]);
        Assert.assertEquals((String)msg, (Object)"b", (Object)res[1]);
        Assert.assertEquals((String)msg, (Object)"", (Object)res[2]);
        Assert.assertEquals((String)msg, (Object)(noMatch + "c"), (Object)res[3]);
        res = StringUtils.splitPreserveAllTokens((String)str, (String)sepStr, (int)0);
        Assert.assertEquals((String)msg, (long)4L, (long)res.length);
        Assert.assertEquals((String)msg, (Object)"a", (Object)res[0]);
        Assert.assertEquals((String)msg, (Object)"b", (Object)res[1]);
        Assert.assertEquals((String)msg, (Object)"", (Object)res[2]);
        Assert.assertEquals((String)msg, (Object)(noMatch + "c"), (Object)res[3]);
        res = StringUtils.splitPreserveAllTokens((String)str, (String)sepStr, (int)1);
        Assert.assertEquals((String)msg, (long)1L, (long)res.length);
        Assert.assertEquals((String)msg, (Object)str, (Object)res[0]);
        res = StringUtils.splitPreserveAllTokens((String)str, (String)sepStr, (int)2);
        Assert.assertEquals((String)msg, (long)2L, (long)res.length);
        Assert.assertEquals((String)msg, (Object)"a", (Object)res[0]);
        Assert.assertEquals((String)msg, (Object)str.substring(2), (Object)res[1]);
    }

    @Test
    public void testSplitByCharacterType() {
        Assert.assertNull((Object)StringUtils.splitByCharacterType(null));
        Assert.assertEquals((long)0L, (long)StringUtils.splitByCharacterType((String)"").length);
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{"ab", " ", "de", " ", "fg"}, (Object)StringUtils.splitByCharacterType((String)"ab de fg")));
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{"ab", "   ", "de", " ", "fg"}, (Object)StringUtils.splitByCharacterType((String)"ab   de fg")));
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{"ab", ":", "cd", ":", "ef"}, (Object)StringUtils.splitByCharacterType((String)"ab:cd:ef")));
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{"number", "5"}, (Object)StringUtils.splitByCharacterType((String)"number5")));
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{FOO_UNCAP, "B", "ar"}, (Object)StringUtils.splitByCharacterType((String)"fooBar")));
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{FOO_UNCAP, "200", "B", "ar"}, (Object)StringUtils.splitByCharacterType((String)"foo200Bar")));
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{"ASFR", "ules"}, (Object)StringUtils.splitByCharacterType((String)"ASFRules")));
    }

    @Test
    public void testSplitByCharacterTypeCamelCase() {
        Assert.assertNull((Object)StringUtils.splitByCharacterTypeCamelCase(null));
        Assert.assertEquals((long)0L, (long)StringUtils.splitByCharacterTypeCamelCase((String)"").length);
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{"ab", " ", "de", " ", "fg"}, (Object)StringUtils.splitByCharacterTypeCamelCase((String)"ab de fg")));
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{"ab", "   ", "de", " ", "fg"}, (Object)StringUtils.splitByCharacterTypeCamelCase((String)"ab   de fg")));
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{"ab", ":", "cd", ":", "ef"}, (Object)StringUtils.splitByCharacterTypeCamelCase((String)"ab:cd:ef")));
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{"number", "5"}, (Object)StringUtils.splitByCharacterTypeCamelCase((String)"number5")));
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{FOO_UNCAP, "Bar"}, (Object)StringUtils.splitByCharacterTypeCamelCase((String)"fooBar")));
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{FOO_UNCAP, "200", "Bar"}, (Object)StringUtils.splitByCharacterTypeCamelCase((String)"foo200Bar")));
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{"ASF", "Rules"}, (Object)StringUtils.splitByCharacterTypeCamelCase((String)"ASFRules")));
    }

    @Test
    public void testDeleteWhitespace_String() {
        Assert.assertNull((Object)StringUtils.deleteWhitespace(null));
        Assert.assertEquals((Object)"", (Object)StringUtils.deleteWhitespace((String)""));
        Assert.assertEquals((Object)"", (Object)StringUtils.deleteWhitespace((String)"  \f  \t\t\u001f\n\n \u000b  "));
        Assert.assertEquals((Object)"", (Object)StringUtils.deleteWhitespace((String)WHITESPACE));
        Assert.assertEquals((Object)NON_WHITESPACE, (Object)StringUtils.deleteWhitespace((String)NON_WHITESPACE));
        Assert.assertEquals((Object)"\u00a0\u202f", (Object)StringUtils.deleteWhitespace((String)"  \u00a0  \t\t\n\n \u202f  "));
        Assert.assertEquals((Object)"\u00a0\u202f", (Object)StringUtils.deleteWhitespace((String)"\u00a0\u202f"));
        Assert.assertEquals((Object)"test", (Object)StringUtils.deleteWhitespace((String)"\u000bt  \t\n\te\rs\n\n   \tt"));
    }

    @Test
    public void testLang623() {
        Assert.assertEquals((Object)"t", (Object)StringUtils.replaceChars((String)"\u00de", (char)'\u00de', (char)'t'));
        Assert.assertEquals((Object)"t", (Object)StringUtils.replaceChars((String)"\u00fe", (char)'\u00fe', (char)'t'));
    }

    @Test
    public void testReplace_StringStringString() {
        Assert.assertNull((Object)StringUtils.replace(null, null, null));
        Assert.assertNull((Object)StringUtils.replace(null, null, (String)"any"));
        Assert.assertNull((Object)StringUtils.replace(null, (String)"any", null));
        Assert.assertNull((Object)StringUtils.replace(null, (String)"any", (String)"any"));
        Assert.assertEquals((Object)"", (Object)StringUtils.replace((String)"", null, null));
        Assert.assertEquals((Object)"", (Object)StringUtils.replace((String)"", null, (String)"any"));
        Assert.assertEquals((Object)"", (Object)StringUtils.replace((String)"", (String)"any", null));
        Assert.assertEquals((Object)"", (Object)StringUtils.replace((String)"", (String)"any", (String)"any"));
        Assert.assertEquals((Object)"FOO", (Object)StringUtils.replace((String)"FOO", (String)"", (String)"any"));
        Assert.assertEquals((Object)"FOO", (Object)StringUtils.replace((String)"FOO", null, (String)"any"));
        Assert.assertEquals((Object)"FOO", (Object)StringUtils.replace((String)"FOO", (String)"F", null));
        Assert.assertEquals((Object)"FOO", (Object)StringUtils.replace((String)"FOO", null, null));
        Assert.assertEquals((Object)"", (Object)StringUtils.replace((String)"foofoofoo", (String)FOO_UNCAP, (String)""));
        Assert.assertEquals((Object)"barbarbar", (Object)StringUtils.replace((String)"foofoofoo", (String)FOO_UNCAP, (String)"bar"));
        Assert.assertEquals((Object)"farfarfar", (Object)StringUtils.replace((String)"foofoofoo", (String)"oo", (String)"ar"));
    }

    @Test
    public void testReplacePattern() {
        Assert.assertEquals((Object)"X", (Object)StringUtils.replacePattern((String)"<A>\nxy\n</A>", (String)"<A>.*</A>", (String)"X"));
    }

    @Test
    public void testRemovePattern() {
        Assert.assertEquals((Object)"", (Object)StringUtils.removePattern((String)"<A>x\\ny</A>", (String)"<A>.*</A>"));
    }

    @Test
    public void testReplace_StringStringStringInt() {
        Assert.assertNull((Object)StringUtils.replace(null, null, null, (int)2));
        Assert.assertNull((Object)StringUtils.replace(null, null, (String)"any", (int)2));
        Assert.assertNull((Object)StringUtils.replace(null, (String)"any", null, (int)2));
        Assert.assertNull((Object)StringUtils.replace(null, (String)"any", (String)"any", (int)2));
        Assert.assertEquals((Object)"", (Object)StringUtils.replace((String)"", null, null, (int)2));
        Assert.assertEquals((Object)"", (Object)StringUtils.replace((String)"", null, (String)"any", (int)2));
        Assert.assertEquals((Object)"", (Object)StringUtils.replace((String)"", (String)"any", null, (int)2));
        Assert.assertEquals((Object)"", (Object)StringUtils.replace((String)"", (String)"any", (String)"any", (int)2));
        String str = new String(new char[]{'o', 'o', 'f', 'o', 'o'});
        Assert.assertSame((Object)str, (Object)StringUtils.replace((String)str, (String)"x", (String)"", (int)-1));
        Assert.assertEquals((Object)"f", (Object)StringUtils.replace((String)"oofoo", (String)"o", (String)"", (int)-1));
        Assert.assertEquals((Object)"oofoo", (Object)StringUtils.replace((String)"oofoo", (String)"o", (String)"", (int)0));
        Assert.assertEquals((Object)"ofoo", (Object)StringUtils.replace((String)"oofoo", (String)"o", (String)"", (int)1));
        Assert.assertEquals((Object)FOO_UNCAP, (Object)StringUtils.replace((String)"oofoo", (String)"o", (String)"", (int)2));
        Assert.assertEquals((Object)"fo", (Object)StringUtils.replace((String)"oofoo", (String)"o", (String)"", (int)3));
        Assert.assertEquals((Object)"f", (Object)StringUtils.replace((String)"oofoo", (String)"o", (String)"", (int)4));
        Assert.assertEquals((Object)"f", (Object)StringUtils.replace((String)"oofoo", (String)"o", (String)"", (int)-5));
        Assert.assertEquals((Object)"f", (Object)StringUtils.replace((String)"oofoo", (String)"o", (String)"", (int)1000));
    }

    @Test
    public void testReplaceOnce_StringStringString() {
        Assert.assertNull((Object)StringUtils.replaceOnce(null, null, null));
        Assert.assertNull((Object)StringUtils.replaceOnce(null, null, (String)"any"));
        Assert.assertNull((Object)StringUtils.replaceOnce(null, (String)"any", null));
        Assert.assertNull((Object)StringUtils.replaceOnce(null, (String)"any", (String)"any"));
        Assert.assertEquals((Object)"", (Object)StringUtils.replaceOnce((String)"", null, null));
        Assert.assertEquals((Object)"", (Object)StringUtils.replaceOnce((String)"", null, (String)"any"));
        Assert.assertEquals((Object)"", (Object)StringUtils.replaceOnce((String)"", (String)"any", null));
        Assert.assertEquals((Object)"", (Object)StringUtils.replaceOnce((String)"", (String)"any", (String)"any"));
        Assert.assertEquals((Object)"FOO", (Object)StringUtils.replaceOnce((String)"FOO", (String)"", (String)"any"));
        Assert.assertEquals((Object)"FOO", (Object)StringUtils.replaceOnce((String)"FOO", null, (String)"any"));
        Assert.assertEquals((Object)"FOO", (Object)StringUtils.replaceOnce((String)"FOO", (String)"F", null));
        Assert.assertEquals((Object)"FOO", (Object)StringUtils.replaceOnce((String)"FOO", null, null));
        Assert.assertEquals((Object)"foofoo", (Object)StringUtils.replaceOnce((String)"foofoofoo", (String)FOO_UNCAP, (String)""));
    }

    @Test
    public void testReplace_StringStringArrayStringArray() {
        Assert.assertNull((Object)StringUtils.replaceEach(null, (String[])new String[]{"a"}, (String[])new String[]{"b"}));
        Assert.assertEquals((Object)StringUtils.replaceEach((String)"", (String[])new String[]{"a"}, (String[])new String[]{"b"}), (Object)"");
        Assert.assertEquals((Object)StringUtils.replaceEach((String)"aba", null, null), (Object)"aba");
        Assert.assertEquals((Object)StringUtils.replaceEach((String)"aba", (String[])new String[0], null), (Object)"aba");
        Assert.assertEquals((Object)StringUtils.replaceEach((String)"aba", null, (String[])new String[0]), (Object)"aba");
        Assert.assertEquals((Object)StringUtils.replaceEach((String)"aba", (String[])new String[]{"a"}, null), (Object)"aba");
        Assert.assertEquals((Object)StringUtils.replaceEach((String)"aba", (String[])new String[]{"a"}, (String[])new String[]{""}), (Object)"b");
        Assert.assertEquals((Object)StringUtils.replaceEach((String)"aba", (String[])new String[]{null}, (String[])new String[]{"a"}), (Object)"aba");
        Assert.assertEquals((Object)StringUtils.replaceEach((String)"abcde", (String[])new String[]{"ab", "d"}, (String[])new String[]{"w", "t"}), (Object)"wcte");
        Assert.assertEquals((Object)StringUtils.replaceEach((String)"abcde", (String[])new String[]{"ab", "d"}, (String[])new String[]{"d", "t"}), (Object)"dcte");
        Assert.assertEquals((Object)"bcc", (Object)StringUtils.replaceEach((String)"abc", (String[])new String[]{"a", "b"}, (String[])new String[]{"b", "c"}));
        Assert.assertEquals((Object)"q651.506bera", (Object)StringUtils.replaceEach((String)"d216.102oren", (String[])new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "1", "2", "3", "4", "5", "6", "7", "8", "9"}, (String[])new String[]{"n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "5", "6", "7", "8", "9", "1", "2", "3", "4"}));
        Assert.assertEquals((Object)StringUtils.replaceEach((String)"aba", (String[])new String[]{"a"}, (String[])new String[]{null}), (Object)"aba");
        Assert.assertEquals((Object)StringUtils.replaceEach((String)"aba", (String[])new String[]{"a", "b"}, (String[])new String[]{"c", null}), (Object)"cbc");
    }

    @Test
    public void testReplace_StringStringArrayStringArrayBoolean() {
        Assert.assertNull((Object)StringUtils.replaceEachRepeatedly(null, (String[])new String[]{"a"}, (String[])new String[]{"b"}));
        Assert.assertEquals((Object)StringUtils.replaceEachRepeatedly((String)"", (String[])new String[]{"a"}, (String[])new String[]{"b"}), (Object)"");
        Assert.assertEquals((Object)StringUtils.replaceEachRepeatedly((String)"aba", null, null), (Object)"aba");
        Assert.assertEquals((Object)StringUtils.replaceEachRepeatedly((String)"aba", (String[])new String[0], null), (Object)"aba");
        Assert.assertEquals((Object)StringUtils.replaceEachRepeatedly((String)"aba", null, (String[])new String[0]), (Object)"aba");
        Assert.assertEquals((Object)StringUtils.replaceEachRepeatedly((String)"aba", (String[])new String[0], null), (Object)"aba");
        Assert.assertEquals((Object)StringUtils.replaceEachRepeatedly((String)"aba", (String[])new String[]{"a"}, (String[])new String[]{""}), (Object)"b");
        Assert.assertEquals((Object)StringUtils.replaceEachRepeatedly((String)"aba", (String[])new String[]{null}, (String[])new String[]{"a"}), (Object)"aba");
        Assert.assertEquals((Object)StringUtils.replaceEachRepeatedly((String)"abcde", (String[])new String[]{"ab", "d"}, (String[])new String[]{"w", "t"}), (Object)"wcte");
        Assert.assertEquals((Object)StringUtils.replaceEachRepeatedly((String)"abcde", (String[])new String[]{"ab", "d"}, (String[])new String[]{"d", "t"}), (Object)"tcte");
        try {
            StringUtils.replaceEachRepeatedly((String)"abcde", (String[])new String[]{"ab", "d"}, (String[])new String[]{"d", "ab"});
            Assert.fail((String)"Should be a circular reference");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testReplaceChars_StringCharChar() {
        Assert.assertNull((Object)StringUtils.replaceChars(null, (char)'b', (char)'z'));
        Assert.assertEquals((Object)"", (Object)StringUtils.replaceChars((String)"", (char)'b', (char)'z'));
        Assert.assertEquals((Object)"azcza", (Object)StringUtils.replaceChars((String)"abcba", (char)'b', (char)'z'));
        Assert.assertEquals((Object)"abcba", (Object)StringUtils.replaceChars((String)"abcba", (char)'x', (char)'z'));
    }

    @Test
    public void testReplaceChars_StringStringString() {
        Assert.assertNull((Object)StringUtils.replaceChars(null, null, null));
        Assert.assertNull((Object)StringUtils.replaceChars(null, (String)"", null));
        Assert.assertNull((Object)StringUtils.replaceChars(null, (String)"a", null));
        Assert.assertNull((Object)StringUtils.replaceChars(null, null, (String)""));
        Assert.assertNull((Object)StringUtils.replaceChars(null, null, (String)"x"));
        Assert.assertEquals((Object)"", (Object)StringUtils.replaceChars((String)"", null, null));
        Assert.assertEquals((Object)"", (Object)StringUtils.replaceChars((String)"", (String)"", null));
        Assert.assertEquals((Object)"", (Object)StringUtils.replaceChars((String)"", (String)"a", null));
        Assert.assertEquals((Object)"", (Object)StringUtils.replaceChars((String)"", null, (String)""));
        Assert.assertEquals((Object)"", (Object)StringUtils.replaceChars((String)"", null, (String)"x"));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.replaceChars((String)"abc", null, null));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.replaceChars((String)"abc", null, (String)""));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.replaceChars((String)"abc", null, (String)"x"));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.replaceChars((String)"abc", (String)"", null));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.replaceChars((String)"abc", (String)"", (String)""));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.replaceChars((String)"abc", (String)"", (String)"x"));
        Assert.assertEquals((Object)"ac", (Object)StringUtils.replaceChars((String)"abc", (String)"b", null));
        Assert.assertEquals((Object)"ac", (Object)StringUtils.replaceChars((String)"abc", (String)"b", (String)""));
        Assert.assertEquals((Object)"axc", (Object)StringUtils.replaceChars((String)"abc", (String)"b", (String)"x"));
        Assert.assertEquals((Object)"ayzya", (Object)StringUtils.replaceChars((String)"abcba", (String)"bc", (String)"yz"));
        Assert.assertEquals((Object)"ayya", (Object)StringUtils.replaceChars((String)"abcba", (String)"bc", (String)"y"));
        Assert.assertEquals((Object)"ayzya", (Object)StringUtils.replaceChars((String)"abcba", (String)"bc", (String)"yzx"));
        Assert.assertEquals((Object)"abcba", (Object)StringUtils.replaceChars((String)"abcba", (String)"z", (String)"w"));
        Assert.assertSame((Object)"abcba", (Object)StringUtils.replaceChars((String)"abcba", (String)"z", (String)"w"));
        Assert.assertEquals((Object)"jelly", (Object)StringUtils.replaceChars((String)"hello", (String)"ho", (String)"jy"));
        Assert.assertEquals((Object)"ayzya", (Object)StringUtils.replaceChars((String)"abcba", (String)"bc", (String)"yz"));
        Assert.assertEquals((Object)"ayya", (Object)StringUtils.replaceChars((String)"abcba", (String)"bc", (String)"y"));
        Assert.assertEquals((Object)"ayzya", (Object)StringUtils.replaceChars((String)"abcba", (String)"bc", (String)"yzx"));
        Assert.assertEquals((Object)"bcc", (Object)StringUtils.replaceChars((String)"abc", (String)"ab", (String)"bc"));
        Assert.assertEquals((Object)"q651.506bera", (Object)StringUtils.replaceChars((String)"d216.102oren", (String)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ123456789", (String)"nopqrstuvwxyzabcdefghijklmNOPQRSTUVWXYZABCDEFGHIJKLM567891234"));
    }

    @Test
    public void testOverlay_StringStringIntInt() {
        Assert.assertNull((Object)StringUtils.overlay(null, null, (int)2, (int)4));
        Assert.assertNull((Object)StringUtils.overlay(null, null, (int)-2, (int)-4));
        Assert.assertEquals((Object)"", (Object)StringUtils.overlay((String)"", null, (int)0, (int)0));
        Assert.assertEquals((Object)"", (Object)StringUtils.overlay((String)"", (String)"", (int)0, (int)0));
        Assert.assertEquals((Object)"zzzz", (Object)StringUtils.overlay((String)"", (String)"zzzz", (int)0, (int)0));
        Assert.assertEquals((Object)"zzzz", (Object)StringUtils.overlay((String)"", (String)"zzzz", (int)2, (int)4));
        Assert.assertEquals((Object)"zzzz", (Object)StringUtils.overlay((String)"", (String)"zzzz", (int)-2, (int)-4));
        Assert.assertEquals((Object)"abef", (Object)StringUtils.overlay((String)"abcdef", null, (int)2, (int)4));
        Assert.assertEquals((Object)"abef", (Object)StringUtils.overlay((String)"abcdef", null, (int)4, (int)2));
        Assert.assertEquals((Object)"abef", (Object)StringUtils.overlay((String)"abcdef", (String)"", (int)2, (int)4));
        Assert.assertEquals((Object)"abef", (Object)StringUtils.overlay((String)"abcdef", (String)"", (int)4, (int)2));
        Assert.assertEquals((Object)"abzzzzef", (Object)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)2, (int)4));
        Assert.assertEquals((Object)"abzzzzef", (Object)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)4, (int)2));
        Assert.assertEquals((Object)"zzzzef", (Object)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)-1, (int)4));
        Assert.assertEquals((Object)"zzzzef", (Object)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)4, (int)-1));
        Assert.assertEquals((Object)"zzzzabcdef", (Object)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)-2, (int)-1));
        Assert.assertEquals((Object)"zzzzabcdef", (Object)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)-1, (int)-2));
        Assert.assertEquals((Object)"abcdzzzz", (Object)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)4, (int)10));
        Assert.assertEquals((Object)"abcdzzzz", (Object)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)10, (int)4));
        Assert.assertEquals((Object)"abcdefzzzz", (Object)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)8, (int)10));
        Assert.assertEquals((Object)"abcdefzzzz", (Object)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)10, (int)8));
    }

    @Test
    public void testRepeat_StringInt() {
        Assert.assertNull((Object)StringUtils.repeat(null, (int)2));
        Assert.assertEquals((Object)"", (Object)StringUtils.repeat((String)"ab", (int)0));
        Assert.assertEquals((Object)"", (Object)StringUtils.repeat((String)"", (int)3));
        Assert.assertEquals((Object)"aaa", (Object)StringUtils.repeat((String)"a", (int)3));
        Assert.assertEquals((Object)"ababab", (Object)StringUtils.repeat((String)"ab", (int)3));
        Assert.assertEquals((Object)"abcabcabc", (Object)StringUtils.repeat((String)"abc", (int)3));
        String str = StringUtils.repeat((String)"a", (int)10000);
        Assert.assertEquals((long)10000L, (long)str.length());
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)str, (char[])new char[]{'a'}));
    }

    @Test
    public void testRepeat_StringStringInt() {
        Assert.assertNull((Object)StringUtils.repeat(null, null, (int)2));
        Assert.assertNull((Object)StringUtils.repeat(null, (String)"x", (int)2));
        Assert.assertEquals((Object)"", (Object)StringUtils.repeat((String)"", null, (int)2));
        Assert.assertEquals((Object)"", (Object)StringUtils.repeat((String)"ab", (String)"", (int)0));
        Assert.assertEquals((Object)"", (Object)StringUtils.repeat((String)"", (String)"", (int)2));
        Assert.assertEquals((Object)"xx", (Object)StringUtils.repeat((String)"", (String)"x", (int)3));
        Assert.assertEquals((Object)"?, ?, ?", (Object)StringUtils.repeat((String)"?", (String)", ", (int)3));
    }

    @Test
    public void testChop() {
        String[][] chopCases;
        for (String[] chopCase : chopCases = new String[][]{{"foo\r\n", FOO_UNCAP}, {"foo\n", FOO_UNCAP}, {"foo\r", FOO_UNCAP}, {"foo \r", "foo "}, {FOO_UNCAP, "fo"}, {"foo\nfoo", "foo\nfo"}, {"\n", ""}, {"\r", ""}, {"\r\n", ""}, {null, null}, {"", ""}, {"a", ""}}) {
            String original = chopCase[0];
            String expectedResult = chopCase[1];
            Assert.assertEquals((String)"chop(String) failed", (Object)expectedResult, (Object)StringUtils.chop((String)original));
        }
    }

    @Test
    public void testChomp() {
        String[][] chompCases;
        for (String[] chompCase : chompCases = new String[][]{{"foo\r\n", FOO_UNCAP}, {"foo\n", FOO_UNCAP}, {"foo\r", FOO_UNCAP}, {"foo \r", "foo "}, {FOO_UNCAP, FOO_UNCAP}, {"foo\n\n", "foo\n"}, {"foo\r\n\r\n", "foo\r\n"}, {"foo\nfoo", "foo\nfoo"}, {"foo\n\rfoo", "foo\n\rfoo"}, {"\n", ""}, {"\r", ""}, {"a", "a"}, {"\r\n", ""}, {"", ""}, {null, null}, {"foo\n\r", "foo\n"}}) {
            String original = chompCase[0];
            String expectedResult = chompCase[1];
            Assert.assertEquals((String)"chomp(String) failed", (Object)expectedResult, (Object)StringUtils.chomp((String)original));
        }
        Assert.assertEquals((String)"chomp(String, String) failed", (Object)FOO_UNCAP, (Object)StringUtils.chomp((String)"foobar", (String)"bar"));
        Assert.assertEquals((String)"chomp(String, String) failed", (Object)"foobar", (Object)StringUtils.chomp((String)"foobar", (String)"baz"));
        Assert.assertEquals((String)"chomp(String, String) failed", (Object)FOO_UNCAP, (Object)StringUtils.chomp((String)FOO_UNCAP, (String)"foooo"));
        Assert.assertEquals((String)"chomp(String, String) failed", (Object)"foobar", (Object)StringUtils.chomp((String)"foobar", (String)""));
        Assert.assertEquals((String)"chomp(String, String) failed", (Object)"foobar", (Object)StringUtils.chomp((String)"foobar", null));
        Assert.assertEquals((String)"chomp(String, String) failed", (Object)"", (Object)StringUtils.chomp((String)"", (String)FOO_UNCAP));
        Assert.assertEquals((String)"chomp(String, String) failed", (Object)"", (Object)StringUtils.chomp((String)"", null));
        Assert.assertEquals((String)"chomp(String, String) failed", (Object)"", (Object)StringUtils.chomp((String)"", (String)""));
        Assert.assertEquals((String)"chomp(String, String) failed", null, (Object)StringUtils.chomp(null, (String)FOO_UNCAP));
        Assert.assertEquals((String)"chomp(String, String) failed", null, (Object)StringUtils.chomp(null, null));
        Assert.assertEquals((String)"chomp(String, String) failed", null, (Object)StringUtils.chomp(null, (String)""));
        Assert.assertEquals((String)"chomp(String, String) failed", (Object)"", (Object)StringUtils.chomp((String)FOO_UNCAP, (String)FOO_UNCAP));
        Assert.assertEquals((String)"chomp(String, String) failed", (Object)" ", (Object)StringUtils.chomp((String)" foo", (String)FOO_UNCAP));
        Assert.assertEquals((String)"chomp(String, String) failed", (Object)"foo ", (Object)StringUtils.chomp((String)"foo ", (String)FOO_UNCAP));
    }

    @Test
    public void testRightPad_StringInt() {
        Assert.assertNull((Object)StringUtils.rightPad(null, (int)5));
        Assert.assertEquals((Object)"     ", (Object)StringUtils.rightPad((String)"", (int)5));
        Assert.assertEquals((Object)"abc  ", (Object)StringUtils.rightPad((String)"abc", (int)5));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.rightPad((String)"abc", (int)2));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.rightPad((String)"abc", (int)-1));
    }

    @Test
    public void testRightPad_StringIntChar() {
        Assert.assertNull((Object)StringUtils.rightPad(null, (int)5, (char)' '));
        Assert.assertEquals((Object)"     ", (Object)StringUtils.rightPad((String)"", (int)5, (char)' '));
        Assert.assertEquals((Object)"abc  ", (Object)StringUtils.rightPad((String)"abc", (int)5, (char)' '));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.rightPad((String)"abc", (int)2, (char)' '));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.rightPad((String)"abc", (int)-1, (char)' '));
        Assert.assertEquals((Object)"abcxx", (Object)StringUtils.rightPad((String)"abc", (int)5, (char)'x'));
        String str = StringUtils.rightPad((String)"aaa", (int)10000, (char)'a');
        Assert.assertEquals((long)10000L, (long)str.length());
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)str, (char[])new char[]{'a'}));
    }

    @Test
    public void testRightPad_StringIntString() {
        Assert.assertNull((Object)StringUtils.rightPad(null, (int)5, (String)"-+"));
        Assert.assertEquals((Object)"     ", (Object)StringUtils.rightPad((String)"", (int)5, (String)" "));
        Assert.assertNull((Object)StringUtils.rightPad(null, (int)8, null));
        Assert.assertEquals((Object)"abc-+-+", (Object)StringUtils.rightPad((String)"abc", (int)7, (String)"-+"));
        Assert.assertEquals((Object)"abc-+~", (Object)StringUtils.rightPad((String)"abc", (int)6, (String)"-+~"));
        Assert.assertEquals((Object)"abc-+", (Object)StringUtils.rightPad((String)"abc", (int)5, (String)"-+~"));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.rightPad((String)"abc", (int)2, (String)" "));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.rightPad((String)"abc", (int)-1, (String)" "));
        Assert.assertEquals((Object)"abc  ", (Object)StringUtils.rightPad((String)"abc", (int)5, null));
        Assert.assertEquals((Object)"abc  ", (Object)StringUtils.rightPad((String)"abc", (int)5, (String)""));
    }

    @Test
    public void testLeftPad_StringInt() {
        Assert.assertNull((Object)StringUtils.leftPad(null, (int)5));
        Assert.assertEquals((Object)"     ", (Object)StringUtils.leftPad((String)"", (int)5));
        Assert.assertEquals((Object)"  abc", (Object)StringUtils.leftPad((String)"abc", (int)5));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.leftPad((String)"abc", (int)2));
    }

    @Test
    public void testLeftPad_StringIntChar() {
        Assert.assertNull((Object)StringUtils.leftPad(null, (int)5, (char)' '));
        Assert.assertEquals((Object)"     ", (Object)StringUtils.leftPad((String)"", (int)5, (char)' '));
        Assert.assertEquals((Object)"  abc", (Object)StringUtils.leftPad((String)"abc", (int)5, (char)' '));
        Assert.assertEquals((Object)"xxabc", (Object)StringUtils.leftPad((String)"abc", (int)5, (char)'x'));
        Assert.assertEquals((Object)"\uffff\uffffabc", (Object)StringUtils.leftPad((String)"abc", (int)5, (char)'\uffff'));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.leftPad((String)"abc", (int)2, (char)' '));
        String str = StringUtils.leftPad((String)"aaa", (int)10000, (char)'a');
        Assert.assertEquals((long)10000L, (long)str.length());
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)str, (char[])new char[]{'a'}));
    }

    @Test
    public void testLeftPad_StringIntString() {
        Assert.assertNull((Object)StringUtils.leftPad(null, (int)5, (String)"-+"));
        Assert.assertNull((Object)StringUtils.leftPad(null, (int)5, null));
        Assert.assertEquals((Object)"     ", (Object)StringUtils.leftPad((String)"", (int)5, (String)" "));
        Assert.assertEquals((Object)"-+-+abc", (Object)StringUtils.leftPad((String)"abc", (int)7, (String)"-+"));
        Assert.assertEquals((Object)"-+~abc", (Object)StringUtils.leftPad((String)"abc", (int)6, (String)"-+~"));
        Assert.assertEquals((Object)"-+abc", (Object)StringUtils.leftPad((String)"abc", (int)5, (String)"-+~"));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.leftPad((String)"abc", (int)2, (String)" "));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.leftPad((String)"abc", (int)-1, (String)" "));
        Assert.assertEquals((Object)"  abc", (Object)StringUtils.leftPad((String)"abc", (int)5, null));
        Assert.assertEquals((Object)"  abc", (Object)StringUtils.leftPad((String)"abc", (int)5, (String)""));
    }

    @Test
    public void testLengthString() {
        Assert.assertEquals((long)0L, (long)StringUtils.length(null));
        Assert.assertEquals((long)0L, (long)StringUtils.length((CharSequence)""));
        Assert.assertEquals((long)0L, (long)StringUtils.length((CharSequence)""));
        Assert.assertEquals((long)1L, (long)StringUtils.length((CharSequence)"A"));
        Assert.assertEquals((long)1L, (long)StringUtils.length((CharSequence)" "));
        Assert.assertEquals((long)8L, (long)StringUtils.length((CharSequence)"ABCDEFGH"));
    }

    @Test
    public void testLengthStringBuffer() {
        Assert.assertEquals((long)0L, (long)StringUtils.length((CharSequence)new StringBuffer("")));
        Assert.assertEquals((long)0L, (long)StringUtils.length((CharSequence)new StringBuffer("")));
        Assert.assertEquals((long)1L, (long)StringUtils.length((CharSequence)new StringBuffer("A")));
        Assert.assertEquals((long)1L, (long)StringUtils.length((CharSequence)new StringBuffer(" ")));
        Assert.assertEquals((long)8L, (long)StringUtils.length((CharSequence)new StringBuffer("ABCDEFGH")));
    }

    @Test
    public void testLengthStringBuilder() {
        Assert.assertEquals((long)0L, (long)StringUtils.length((CharSequence)new StringBuilder("")));
        Assert.assertEquals((long)0L, (long)StringUtils.length((CharSequence)new StringBuilder("")));
        Assert.assertEquals((long)1L, (long)StringUtils.length((CharSequence)new StringBuilder("A")));
        Assert.assertEquals((long)1L, (long)StringUtils.length((CharSequence)new StringBuilder(" ")));
        Assert.assertEquals((long)8L, (long)StringUtils.length((CharSequence)new StringBuilder("ABCDEFGH")));
    }

    @Test
    public void testLength_CharBuffer() {
        Assert.assertEquals((long)0L, (long)StringUtils.length((CharSequence)CharBuffer.wrap("")));
        Assert.assertEquals((long)1L, (long)StringUtils.length((CharSequence)CharBuffer.wrap("A")));
        Assert.assertEquals((long)1L, (long)StringUtils.length((CharSequence)CharBuffer.wrap(" ")));
        Assert.assertEquals((long)8L, (long)StringUtils.length((CharSequence)CharBuffer.wrap("ABCDEFGH")));
    }

    @Test
    public void testCenter_StringInt() {
        Assert.assertNull((Object)StringUtils.center(null, (int)-1));
        Assert.assertNull((Object)StringUtils.center(null, (int)4));
        Assert.assertEquals((Object)"    ", (Object)StringUtils.center((String)"", (int)4));
        Assert.assertEquals((Object)"ab", (Object)StringUtils.center((String)"ab", (int)0));
        Assert.assertEquals((Object)"ab", (Object)StringUtils.center((String)"ab", (int)-1));
        Assert.assertEquals((Object)"ab", (Object)StringUtils.center((String)"ab", (int)1));
        Assert.assertEquals((Object)"    ", (Object)StringUtils.center((String)"", (int)4));
        Assert.assertEquals((Object)" ab ", (Object)StringUtils.center((String)"ab", (int)4));
        Assert.assertEquals((Object)"abcd", (Object)StringUtils.center((String)"abcd", (int)2));
        Assert.assertEquals((Object)" a  ", (Object)StringUtils.center((String)"a", (int)4));
        Assert.assertEquals((Object)"  a  ", (Object)StringUtils.center((String)"a", (int)5));
    }

    @Test
    public void testCenter_StringIntChar() {
        Assert.assertNull((Object)StringUtils.center(null, (int)-1, (char)' '));
        Assert.assertNull((Object)StringUtils.center(null, (int)4, (char)' '));
        Assert.assertEquals((Object)"    ", (Object)StringUtils.center((String)"", (int)4, (char)' '));
        Assert.assertEquals((Object)"ab", (Object)StringUtils.center((String)"ab", (int)0, (char)' '));
        Assert.assertEquals((Object)"ab", (Object)StringUtils.center((String)"ab", (int)-1, (char)' '));
        Assert.assertEquals((Object)"ab", (Object)StringUtils.center((String)"ab", (int)1, (char)' '));
        Assert.assertEquals((Object)"    ", (Object)StringUtils.center((String)"", (int)4, (char)' '));
        Assert.assertEquals((Object)" ab ", (Object)StringUtils.center((String)"ab", (int)4, (char)' '));
        Assert.assertEquals((Object)"abcd", (Object)StringUtils.center((String)"abcd", (int)2, (char)' '));
        Assert.assertEquals((Object)" a  ", (Object)StringUtils.center((String)"a", (int)4, (char)' '));
        Assert.assertEquals((Object)"  a  ", (Object)StringUtils.center((String)"a", (int)5, (char)' '));
        Assert.assertEquals((Object)"xxaxx", (Object)StringUtils.center((String)"a", (int)5, (char)'x'));
    }

    @Test
    public void testCenter_StringIntString() {
        Assert.assertNull((Object)StringUtils.center(null, (int)4, null));
        Assert.assertNull((Object)StringUtils.center(null, (int)-1, (String)" "));
        Assert.assertNull((Object)StringUtils.center(null, (int)4, (String)" "));
        Assert.assertEquals((Object)"    ", (Object)StringUtils.center((String)"", (int)4, (String)" "));
        Assert.assertEquals((Object)"ab", (Object)StringUtils.center((String)"ab", (int)0, (String)" "));
        Assert.assertEquals((Object)"ab", (Object)StringUtils.center((String)"ab", (int)-1, (String)" "));
        Assert.assertEquals((Object)"ab", (Object)StringUtils.center((String)"ab", (int)1, (String)" "));
        Assert.assertEquals((Object)"    ", (Object)StringUtils.center((String)"", (int)4, (String)" "));
        Assert.assertEquals((Object)" ab ", (Object)StringUtils.center((String)"ab", (int)4, (String)" "));
        Assert.assertEquals((Object)"abcd", (Object)StringUtils.center((String)"abcd", (int)2, (String)" "));
        Assert.assertEquals((Object)" a  ", (Object)StringUtils.center((String)"a", (int)4, (String)" "));
        Assert.assertEquals((Object)"yayz", (Object)StringUtils.center((String)"a", (int)4, (String)"yz"));
        Assert.assertEquals((Object)"yzyayzy", (Object)StringUtils.center((String)"a", (int)7, (String)"yz"));
        Assert.assertEquals((Object)"  abc  ", (Object)StringUtils.center((String)"abc", (int)7, null));
        Assert.assertEquals((Object)"  abc  ", (Object)StringUtils.center((String)"abc", (int)7, (String)""));
    }

    @Test
    public void testReverse_String() {
        Assert.assertNull((Object)StringUtils.reverse(null));
        Assert.assertEquals((Object)"", (Object)StringUtils.reverse((String)""));
        Assert.assertEquals((Object)"sdrawkcab", (Object)StringUtils.reverse((String)"backwards"));
    }

    @Test
    public void testReverseDelimited_StringChar() {
        Assert.assertNull((Object)StringUtils.reverseDelimited(null, (char)'.'));
        Assert.assertEquals((Object)"", (Object)StringUtils.reverseDelimited((String)"", (char)'.'));
        Assert.assertEquals((Object)"c.b.a", (Object)StringUtils.reverseDelimited((String)"a.b.c", (char)'.'));
        Assert.assertEquals((Object)"a b c", (Object)StringUtils.reverseDelimited((String)"a b c", (char)'.'));
        Assert.assertEquals((Object)"", (Object)StringUtils.reverseDelimited((String)"", (char)'.'));
    }

    @Test
    public void testDefault_String() {
        Assert.assertEquals((Object)"", (Object)StringUtils.defaultString(null));
        Assert.assertEquals((Object)"", (Object)StringUtils.defaultString((String)""));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.defaultString((String)"abc"));
    }

    @Test
    public void testDefault_StringString() {
        Assert.assertEquals((Object)"NULL", (Object)StringUtils.defaultString(null, (String)"NULL"));
        Assert.assertEquals((Object)"", (Object)StringUtils.defaultString((String)"", (String)"NULL"));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.defaultString((String)"abc", (String)"NULL"));
    }

    @Test
    public void testDefaultIfEmpty_StringString() {
        Assert.assertEquals((Object)"NULL", (Object)StringUtils.defaultIfEmpty(null, (CharSequence)"NULL"));
        Assert.assertEquals((Object)"NULL", (Object)StringUtils.defaultIfEmpty((CharSequence)"", (CharSequence)"NULL"));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.defaultIfEmpty((CharSequence)"abc", (CharSequence)"NULL"));
        Assert.assertNull((Object)StringUtils.defaultIfEmpty((CharSequence)"", null));
        String s = (String)StringUtils.defaultIfEmpty((CharSequence)"abc", (CharSequence)"NULL");
        Assert.assertEquals((Object)"abc", (Object)s);
    }

    @Test
    public void testDefaultIfBlank_StringString() {
        Assert.assertEquals((Object)"NULL", (Object)StringUtils.defaultIfBlank(null, (CharSequence)"NULL"));
        Assert.assertEquals((Object)"NULL", (Object)StringUtils.defaultIfBlank((CharSequence)"", (CharSequence)"NULL"));
        Assert.assertEquals((Object)"NULL", (Object)StringUtils.defaultIfBlank((CharSequence)" ", (CharSequence)"NULL"));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.defaultIfBlank((CharSequence)"abc", (CharSequence)"NULL"));
        Assert.assertNull((Object)StringUtils.defaultIfBlank((CharSequence)"", null));
        String s = (String)StringUtils.defaultIfBlank((CharSequence)"abc", (CharSequence)"NULL");
        Assert.assertEquals((Object)"abc", (Object)s);
    }

    @Test
    public void testDefaultIfEmpty_StringBuilders() {
        Assert.assertEquals((Object)"NULL", (Object)((StringBuilder)StringUtils.defaultIfEmpty((CharSequence)new StringBuilder(""), (CharSequence)new StringBuilder("NULL"))).toString());
        Assert.assertEquals((Object)"abc", (Object)((StringBuilder)StringUtils.defaultIfEmpty((CharSequence)new StringBuilder("abc"), (CharSequence)new StringBuilder("NULL"))).toString());
        Assert.assertNull((Object)StringUtils.defaultIfEmpty((CharSequence)new StringBuilder(""), null));
        StringBuilder s = (StringBuilder)StringUtils.defaultIfEmpty((CharSequence)new StringBuilder("abc"), (CharSequence)new StringBuilder("NULL"));
        Assert.assertEquals((Object)"abc", (Object)s.toString());
    }

    @Test
    public void testDefaultIfBlank_StringBuilders() {
        Assert.assertEquals((Object)"NULL", (Object)((StringBuilder)StringUtils.defaultIfBlank((CharSequence)new StringBuilder(""), (CharSequence)new StringBuilder("NULL"))).toString());
        Assert.assertEquals((Object)"NULL", (Object)((StringBuilder)StringUtils.defaultIfBlank((CharSequence)new StringBuilder(" "), (CharSequence)new StringBuilder("NULL"))).toString());
        Assert.assertEquals((Object)"abc", (Object)((StringBuilder)StringUtils.defaultIfBlank((CharSequence)new StringBuilder("abc"), (CharSequence)new StringBuilder("NULL"))).toString());
        Assert.assertNull((Object)StringUtils.defaultIfBlank((CharSequence)new StringBuilder(""), null));
        StringBuilder s = (StringBuilder)StringUtils.defaultIfBlank((CharSequence)new StringBuilder("abc"), (CharSequence)new StringBuilder("NULL"));
        Assert.assertEquals((Object)"abc", (Object)s.toString());
    }

    @Test
    public void testDefaultIfEmpty_StringBuffers() {
        Assert.assertEquals((Object)"NULL", (Object)((StringBuffer)StringUtils.defaultIfEmpty((CharSequence)new StringBuffer(""), (CharSequence)new StringBuffer("NULL"))).toString());
        Assert.assertEquals((Object)"abc", (Object)((StringBuffer)StringUtils.defaultIfEmpty((CharSequence)new StringBuffer("abc"), (CharSequence)new StringBuffer("NULL"))).toString());
        Assert.assertNull((Object)StringUtils.defaultIfEmpty((CharSequence)new StringBuffer(""), null));
        StringBuffer s = (StringBuffer)StringUtils.defaultIfEmpty((CharSequence)new StringBuffer("abc"), (CharSequence)new StringBuffer("NULL"));
        Assert.assertEquals((Object)"abc", (Object)s.toString());
    }

    @Test
    public void testDefaultIfBlank_StringBuffers() {
        Assert.assertEquals((Object)"NULL", (Object)((StringBuffer)StringUtils.defaultIfBlank((CharSequence)new StringBuffer(""), (CharSequence)new StringBuffer("NULL"))).toString());
        Assert.assertEquals((Object)"NULL", (Object)((StringBuffer)StringUtils.defaultIfBlank((CharSequence)new StringBuffer(" "), (CharSequence)new StringBuffer("NULL"))).toString());
        Assert.assertEquals((Object)"abc", (Object)((StringBuffer)StringUtils.defaultIfBlank((CharSequence)new StringBuffer("abc"), (CharSequence)new StringBuffer("NULL"))).toString());
        Assert.assertNull((Object)StringUtils.defaultIfBlank((CharSequence)new StringBuffer(""), null));
        StringBuffer s = (StringBuffer)StringUtils.defaultIfBlank((CharSequence)new StringBuffer("abc"), (CharSequence)new StringBuffer("NULL"));
        Assert.assertEquals((Object)"abc", (Object)s.toString());
    }

    @Test
    public void testDefaultIfEmpty_CharBuffers() {
        Assert.assertEquals((Object)"NULL", (Object)((CharBuffer)StringUtils.defaultIfEmpty((CharSequence)CharBuffer.wrap(""), (CharSequence)CharBuffer.wrap("NULL"))).toString());
        Assert.assertEquals((Object)"abc", (Object)((CharBuffer)StringUtils.defaultIfEmpty((CharSequence)CharBuffer.wrap("abc"), (CharSequence)CharBuffer.wrap("NULL"))).toString());
        Assert.assertNull((Object)StringUtils.defaultIfEmpty((CharSequence)CharBuffer.wrap(""), null));
        CharBuffer s = (CharBuffer)StringUtils.defaultIfEmpty((CharSequence)CharBuffer.wrap("abc"), (CharSequence)CharBuffer.wrap("NULL"));
        Assert.assertEquals((Object)"abc", (Object)s.toString());
    }

    @Test
    public void testDefaultIfBlank_CharBuffers() {
        Assert.assertEquals((Object)"NULL", (Object)((CharBuffer)StringUtils.defaultIfBlank((CharSequence)CharBuffer.wrap(""), (CharSequence)CharBuffer.wrap("NULL"))).toString());
        Assert.assertEquals((Object)"NULL", (Object)((CharBuffer)StringUtils.defaultIfBlank((CharSequence)CharBuffer.wrap(" "), (CharSequence)CharBuffer.wrap("NULL"))).toString());
        Assert.assertEquals((Object)"abc", (Object)((CharBuffer)StringUtils.defaultIfBlank((CharSequence)CharBuffer.wrap("abc"), (CharSequence)CharBuffer.wrap("NULL"))).toString());
        Assert.assertNull((Object)StringUtils.defaultIfBlank((CharSequence)CharBuffer.wrap(""), null));
        CharBuffer s = (CharBuffer)StringUtils.defaultIfBlank((CharSequence)CharBuffer.wrap("abc"), (CharSequence)CharBuffer.wrap("NULL"));
        Assert.assertEquals((Object)"abc", (Object)s.toString());
    }

    @Test
    public void testAbbreviate_StringInt() {
        Assert.assertNull((Object)StringUtils.abbreviate(null, (int)10));
        Assert.assertEquals((Object)"", (Object)StringUtils.abbreviate((String)"", (int)10));
        Assert.assertEquals((Object)"short", (Object)StringUtils.abbreviate((String)"short", (int)10));
        Assert.assertEquals((Object)"Now is ...", (Object)StringUtils.abbreviate((String)"Now is the time for all good men to come to the aid of their party.", (int)10));
        String raspberry = "raspberry peach";
        Assert.assertEquals((Object)"raspberry p...", (Object)StringUtils.abbreviate((String)"raspberry peach", (int)14));
        Assert.assertEquals((Object)"raspberry peach", (Object)StringUtils.abbreviate((String)"raspberry peach", (int)15));
        Assert.assertEquals((Object)"raspberry peach", (Object)StringUtils.abbreviate((String)"raspberry peach", (int)16));
        Assert.assertEquals((Object)"abc...", (Object)StringUtils.abbreviate((String)"abcdefg", (int)6));
        Assert.assertEquals((Object)"abcdefg", (Object)StringUtils.abbreviate((String)"abcdefg", (int)7));
        Assert.assertEquals((Object)"abcdefg", (Object)StringUtils.abbreviate((String)"abcdefg", (int)8));
        Assert.assertEquals((Object)"a...", (Object)StringUtils.abbreviate((String)"abcdefg", (int)4));
        Assert.assertEquals((Object)"", (Object)StringUtils.abbreviate((String)"", (int)4));
        try {
            String res = StringUtils.abbreviate((String)"abc", (int)3);
            Assert.fail((String)"StringUtils.abbreviate expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAbbreviate_StringIntInt() {
        String res;
        Assert.assertNull((Object)StringUtils.abbreviate(null, (int)10, (int)12));
        Assert.assertEquals((Object)"", (Object)StringUtils.abbreviate((String)"", (int)0, (int)10));
        Assert.assertEquals((Object)"", (Object)StringUtils.abbreviate((String)"", (int)2, (int)10));
        try {
            res = StringUtils.abbreviate((String)"abcdefghij", (int)0, (int)3);
            Assert.fail((String)"StringUtils.abbreviate expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            res = StringUtils.abbreviate((String)"abcdefghij", (int)5, (int)6);
            Assert.fail((String)"StringUtils.abbreviate expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        String raspberry = "raspberry peach";
        Assert.assertEquals((Object)"raspberry peach", (Object)StringUtils.abbreviate((String)"raspberry peach", (int)11, (int)15));
        Assert.assertNull((Object)StringUtils.abbreviate(null, (int)7, (int)14));
        this.assertAbbreviateWithOffset("abcdefg...", -1, 10);
        this.assertAbbreviateWithOffset("abcdefg...", 0, 10);
        this.assertAbbreviateWithOffset("abcdefg...", 1, 10);
        this.assertAbbreviateWithOffset("abcdefg...", 2, 10);
        this.assertAbbreviateWithOffset("abcdefg...", 3, 10);
        this.assertAbbreviateWithOffset("abcdefg...", 4, 10);
        this.assertAbbreviateWithOffset("...fghi...", 5, 10);
        this.assertAbbreviateWithOffset("...ghij...", 6, 10);
        this.assertAbbreviateWithOffset("...hijk...", 7, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 8, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 9, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 10, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 10, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 11, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 12, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 13, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 14, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 15, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 16, 10);
        this.assertAbbreviateWithOffset("...ijklmno", Integer.MAX_VALUE, 10);
    }

    private void assertAbbreviateWithOffset(String expected, int offset, int maxWidth) {
        String abcdefghijklmno = "abcdefghijklmno";
        String message = "abbreviate(String,int,int) failed";
        String actual = StringUtils.abbreviate((String)"abcdefghijklmno", (int)offset, (int)maxWidth);
        if (offset >= 0 && offset < "abcdefghijklmno".length()) {
            Assert.assertTrue((String)"abbreviate(String,int,int) failed -- should contain offset character", (actual.indexOf((char)(97 + offset)) != -1 ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)"abbreviate(String,int,int) failed -- should not be greater than maxWidth", (actual.length() <= maxWidth ? 1 : 0) != 0);
        Assert.assertEquals((String)"abbreviate(String,int,int) failed", (Object)expected, (Object)actual);
    }

    @Test
    public void testAbbreviateMiddle() {
        Assert.assertNull((Object)StringUtils.abbreviateMiddle(null, null, (int)0));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.abbreviateMiddle((String)"abc", null, (int)0));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.abbreviateMiddle((String)"abc", (String)".", (int)0));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.abbreviateMiddle((String)"abc", (String)".", (int)3));
        Assert.assertEquals((Object)"ab.f", (Object)StringUtils.abbreviateMiddle((String)"abcdef", (String)".", (int)4));
        Assert.assertEquals((Object)"A very long text with un...f the text is complete.", (Object)StringUtils.abbreviateMiddle((String)"A very long text with unimportant stuff in the middle but interesting start and end to see if the text is complete.", (String)"...", (int)50));
        String longText = "Start text" + StringUtils.repeat((String)"x", (int)10000) + "Close text";
        Assert.assertEquals((Object)"Start text->Close text", (Object)StringUtils.abbreviateMiddle((String)longText, (String)"->", (int)22));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.abbreviateMiddle((String)"abc", (String)".", (int)-1));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.abbreviateMiddle((String)"abc", (String)".", (int)1));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.abbreviateMiddle((String)"abc", (String)".", (int)2));
        Assert.assertEquals((Object)"a", (Object)StringUtils.abbreviateMiddle((String)"a", (String)".", (int)1));
        Assert.assertEquals((Object)"a.d", (Object)StringUtils.abbreviateMiddle((String)"abcd", (String)".", (int)3));
        Assert.assertEquals((Object)"a..f", (Object)StringUtils.abbreviateMiddle((String)"abcdef", (String)"..", (int)4));
        Assert.assertEquals((Object)"ab.ef", (Object)StringUtils.abbreviateMiddle((String)"abcdef", (String)".", (int)5));
    }

    @Test
    public void testDifference_StringString() {
        Assert.assertNull((Object)StringUtils.difference(null, null));
        Assert.assertEquals((Object)"", (Object)StringUtils.difference((String)"", (String)""));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.difference((String)"", (String)"abc"));
        Assert.assertEquals((Object)"", (Object)StringUtils.difference((String)"abc", (String)""));
        Assert.assertEquals((Object)"i am a robot", (Object)StringUtils.difference(null, (String)"i am a robot"));
        Assert.assertEquals((Object)"i am a machine", (Object)StringUtils.difference((String)"i am a machine", null));
        Assert.assertEquals((Object)"robot", (Object)StringUtils.difference((String)"i am a machine", (String)"i am a robot"));
        Assert.assertEquals((Object)"", (Object)StringUtils.difference((String)"abc", (String)"abc"));
        Assert.assertEquals((Object)"you are a robot", (Object)StringUtils.difference((String)"i am a robot", (String)"you are a robot"));
    }

    @Test
    public void testDifferenceAt_StringString() {
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfDifference(null, null));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfDifference(null, (CharSequence)"i am a robot"));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfDifference((CharSequence)"", (CharSequence)""));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfDifference((CharSequence)"", (CharSequence)"abc"));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfDifference((CharSequence)"abc", (CharSequence)""));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfDifference((CharSequence)"i am a machine", null));
        Assert.assertEquals((long)7L, (long)StringUtils.indexOfDifference((CharSequence)"i am a machine", (CharSequence)"i am a robot"));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfDifference((CharSequence)FOO_UNCAP, (CharSequence)FOO_UNCAP));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfDifference((CharSequence)"i am a robot", (CharSequence)"you are a robot"));
    }

    @Test
    public void testGetLevenshteinDistance_StringString() {
        Assert.assertEquals((long)0L, (long)StringUtils.getLevenshteinDistance((CharSequence)"", (CharSequence)""));
        Assert.assertEquals((long)1L, (long)StringUtils.getLevenshteinDistance((CharSequence)"", (CharSequence)"a"));
        Assert.assertEquals((long)7L, (long)StringUtils.getLevenshteinDistance((CharSequence)"aaapppp", (CharSequence)""));
        Assert.assertEquals((long)1L, (long)StringUtils.getLevenshteinDistance((CharSequence)"frog", (CharSequence)"fog"));
        Assert.assertEquals((long)3L, (long)StringUtils.getLevenshteinDistance((CharSequence)"fly", (CharSequence)"ant"));
        Assert.assertEquals((long)7L, (long)StringUtils.getLevenshteinDistance((CharSequence)"elephant", (CharSequence)"hippo"));
        Assert.assertEquals((long)7L, (long)StringUtils.getLevenshteinDistance((CharSequence)"hippo", (CharSequence)"elephant"));
        Assert.assertEquals((long)8L, (long)StringUtils.getLevenshteinDistance((CharSequence)"hippo", (CharSequence)"zzzzzzzz"));
        Assert.assertEquals((long)8L, (long)StringUtils.getLevenshteinDistance((CharSequence)"zzzzzzzz", (CharSequence)"hippo"));
        Assert.assertEquals((long)1L, (long)StringUtils.getLevenshteinDistance((CharSequence)"hello", (CharSequence)"hallo"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetLevenshteinDistance_NullString() throws Exception {
        StringUtils.getLevenshteinDistance((CharSequence)"a", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetLevenshteinDistance_StringNull() throws Exception {
        StringUtils.getLevenshteinDistance(null, (CharSequence)"a");
    }

    @Test
    public void testGetLevenshteinDistance_StringStringInt() {
        Assert.assertEquals((long)0L, (long)StringUtils.getLevenshteinDistance((CharSequence)"", (CharSequence)"", (int)0));
        Assert.assertEquals((long)7L, (long)StringUtils.getLevenshteinDistance((CharSequence)"aaapppp", (CharSequence)"", (int)8));
        Assert.assertEquals((long)7L, (long)StringUtils.getLevenshteinDistance((CharSequence)"aaapppp", (CharSequence)"", (int)7));
        Assert.assertEquals((long)-1L, (long)StringUtils.getLevenshteinDistance((CharSequence)"aaapppp", (CharSequence)"", (int)6));
        Assert.assertEquals((long)-1L, (long)StringUtils.getLevenshteinDistance((CharSequence)"b", (CharSequence)"a", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.getLevenshteinDistance((CharSequence)"a", (CharSequence)"b", (int)0));
        Assert.assertEquals((long)0L, (long)StringUtils.getLevenshteinDistance((CharSequence)"aa", (CharSequence)"aa", (int)0));
        Assert.assertEquals((long)0L, (long)StringUtils.getLevenshteinDistance((CharSequence)"aa", (CharSequence)"aa", (int)2));
        Assert.assertEquals((long)-1L, (long)StringUtils.getLevenshteinDistance((CharSequence)"aaa", (CharSequence)"bbb", (int)2));
        Assert.assertEquals((long)3L, (long)StringUtils.getLevenshteinDistance((CharSequence)"aaa", (CharSequence)"bbb", (int)3));
        Assert.assertEquals((long)6L, (long)StringUtils.getLevenshteinDistance((CharSequence)"aaaaaa", (CharSequence)"b", (int)10));
        Assert.assertEquals((long)7L, (long)StringUtils.getLevenshteinDistance((CharSequence)"aaapppp", (CharSequence)"b", (int)8));
        Assert.assertEquals((long)3L, (long)StringUtils.getLevenshteinDistance((CharSequence)"a", (CharSequence)"bbb", (int)4));
        Assert.assertEquals((long)7L, (long)StringUtils.getLevenshteinDistance((CharSequence)"aaapppp", (CharSequence)"b", (int)7));
        Assert.assertEquals((long)3L, (long)StringUtils.getLevenshteinDistance((CharSequence)"a", (CharSequence)"bbb", (int)3));
        Assert.assertEquals((long)-1L, (long)StringUtils.getLevenshteinDistance((CharSequence)"a", (CharSequence)"bbb", (int)2));
        Assert.assertEquals((long)-1L, (long)StringUtils.getLevenshteinDistance((CharSequence)"bbb", (CharSequence)"a", (int)2));
        Assert.assertEquals((long)-1L, (long)StringUtils.getLevenshteinDistance((CharSequence)"aaapppp", (CharSequence)"b", (int)6));
        Assert.assertEquals((long)-1L, (long)StringUtils.getLevenshteinDistance((CharSequence)"a", (CharSequence)"bbb", (int)1));
        Assert.assertEquals((long)-1L, (long)StringUtils.getLevenshteinDistance((CharSequence)"bbb", (CharSequence)"a", (int)1));
        Assert.assertEquals((long)-1L, (long)StringUtils.getLevenshteinDistance((CharSequence)"12345", (CharSequence)"1234567", (int)1));
        Assert.assertEquals((long)-1L, (long)StringUtils.getLevenshteinDistance((CharSequence)"1234567", (CharSequence)"12345", (int)1));
        Assert.assertEquals((long)1L, (long)StringUtils.getLevenshteinDistance((CharSequence)"frog", (CharSequence)"fog", (int)1));
        Assert.assertEquals((long)3L, (long)StringUtils.getLevenshteinDistance((CharSequence)"fly", (CharSequence)"ant", (int)3));
        Assert.assertEquals((long)7L, (long)StringUtils.getLevenshteinDistance((CharSequence)"elephant", (CharSequence)"hippo", (int)7));
        Assert.assertEquals((long)-1L, (long)StringUtils.getLevenshteinDistance((CharSequence)"elephant", (CharSequence)"hippo", (int)6));
        Assert.assertEquals((long)7L, (long)StringUtils.getLevenshteinDistance((CharSequence)"hippo", (CharSequence)"elephant", (int)7));
        Assert.assertEquals((long)-1L, (long)StringUtils.getLevenshteinDistance((CharSequence)"hippo", (CharSequence)"elephant", (int)6));
        Assert.assertEquals((long)8L, (long)StringUtils.getLevenshteinDistance((CharSequence)"hippo", (CharSequence)"zzzzzzzz", (int)8));
        Assert.assertEquals((long)8L, (long)StringUtils.getLevenshteinDistance((CharSequence)"zzzzzzzz", (CharSequence)"hippo", (int)8));
        Assert.assertEquals((long)1L, (long)StringUtils.getLevenshteinDistance((CharSequence)"hello", (CharSequence)"hallo", (int)1));
        Assert.assertEquals((long)1L, (long)StringUtils.getLevenshteinDistance((CharSequence)"frog", (CharSequence)"fog", (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)3L, (long)StringUtils.getLevenshteinDistance((CharSequence)"fly", (CharSequence)"ant", (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)7L, (long)StringUtils.getLevenshteinDistance((CharSequence)"elephant", (CharSequence)"hippo", (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)7L, (long)StringUtils.getLevenshteinDistance((CharSequence)"hippo", (CharSequence)"elephant", (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)8L, (long)StringUtils.getLevenshteinDistance((CharSequence)"hippo", (CharSequence)"zzzzzzzz", (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)8L, (long)StringUtils.getLevenshteinDistance((CharSequence)"zzzzzzzz", (CharSequence)"hippo", (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)1L, (long)StringUtils.getLevenshteinDistance((CharSequence)"hello", (CharSequence)"hallo", (int)Integer.MAX_VALUE));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetLevenshteinDistance_NullStringInt() throws Exception {
        StringUtils.getLevenshteinDistance(null, (CharSequence)"a", (int)0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetLevenshteinDistance_StringNullInt() throws Exception {
        StringUtils.getLevenshteinDistance((CharSequence)"a", null, (int)0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetLevenshteinDistance_StringStringNegativeInt() throws Exception {
        StringUtils.getLevenshteinDistance((CharSequence)"a", (CharSequence)"a", (int)-1);
    }

    @Test
    public void testGetJaroWinklerDistance_StringString() {
        Assert.assertEquals((double)0.93, (double)StringUtils.getJaroWinklerDistance((CharSequence)"frog", (CharSequence)"fog"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)StringUtils.getJaroWinklerDistance((CharSequence)"fly", (CharSequence)"ant"), (double)0.0);
        Assert.assertEquals((double)0.44, (double)StringUtils.getJaroWinklerDistance((CharSequence)"elephant", (CharSequence)"hippo"), (double)0.0);
        Assert.assertEquals((double)0.91, (double)StringUtils.getJaroWinklerDistance((CharSequence)"ABC Corporation", (CharSequence)"ABC Corp"), (double)0.0);
        Assert.assertEquals((double)0.93, (double)StringUtils.getJaroWinklerDistance((CharSequence)"D N H Enterprises Inc", (CharSequence)"D & H Enterprises, Inc."), (double)0.0);
        Assert.assertEquals((double)0.94, (double)StringUtils.getJaroWinklerDistance((CharSequence)"My Gym Children's Fitness Center", (CharSequence)"My Gym. Childrens Fitness"), (double)0.0);
        Assert.assertEquals((double)0.9, (double)StringUtils.getJaroWinklerDistance((CharSequence)"PENNSYLVANIA", (CharSequence)"PENNCISYLVNIA"), (double)0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetJaroWinklerDistance_NullNull() throws Exception {
        StringUtils.getJaroWinklerDistance(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetJaroWinklerDistance_StringNull() throws Exception {
        StringUtils.getJaroWinklerDistance((CharSequence)" ", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetJaroWinklerDistance_NullString() throws Exception {
        StringUtils.getJaroWinklerDistance(null, (CharSequence)"clear");
    }

    @Test
    public void testEMPTY() {
        Assert.assertNotNull((Object)"");
        Assert.assertEquals((Object)"", (Object)"");
        Assert.assertEquals((long)0L, (long)"".length());
    }

    @Test
    public void testIsAllLowerCase() {
        Assert.assertFalse((boolean)StringUtils.isAllLowerCase(null));
        Assert.assertFalse((boolean)StringUtils.isAllLowerCase((CharSequence)""));
        Assert.assertTrue((boolean)StringUtils.isAllLowerCase((CharSequence)"abc"));
        Assert.assertFalse((boolean)StringUtils.isAllLowerCase((CharSequence)"abc "));
        Assert.assertFalse((boolean)StringUtils.isAllLowerCase((CharSequence)"abC"));
    }

    @Test
    public void testIsAllUpperCase() {
        Assert.assertFalse((boolean)StringUtils.isAllUpperCase(null));
        Assert.assertFalse((boolean)StringUtils.isAllUpperCase((CharSequence)""));
        Assert.assertTrue((boolean)StringUtils.isAllUpperCase((CharSequence)"ABC"));
        Assert.assertFalse((boolean)StringUtils.isAllUpperCase((CharSequence)"ABC "));
        Assert.assertFalse((boolean)StringUtils.isAllUpperCase((CharSequence)"aBC"));
    }

    @Test
    public void testRemoveStart() {
        Assert.assertNull((Object)StringUtils.removeStart(null, null));
        Assert.assertNull((Object)StringUtils.removeStart(null, (String)""));
        Assert.assertNull((Object)StringUtils.removeStart(null, (String)"a"));
        Assert.assertEquals((Object)StringUtils.removeStart((String)"", null), (Object)"");
        Assert.assertEquals((Object)StringUtils.removeStart((String)"", (String)""), (Object)"");
        Assert.assertEquals((Object)StringUtils.removeStart((String)"", (String)"a"), (Object)"");
        Assert.assertEquals((Object)StringUtils.removeStart((String)"www.domain.com", (String)"www."), (Object)"domain.com");
        Assert.assertEquals((Object)StringUtils.removeStart((String)"domain.com", (String)"www."), (Object)"domain.com");
        Assert.assertEquals((Object)StringUtils.removeStart((String)"domain.com", (String)""), (Object)"domain.com");
        Assert.assertEquals((Object)StringUtils.removeStart((String)"domain.com", null), (Object)"domain.com");
    }

    @Test
    public void testRemoveStartIgnoreCase() {
        Assert.assertNull((String)"removeStartIgnoreCase(null, null)", (Object)StringUtils.removeStartIgnoreCase(null, null));
        Assert.assertNull((String)"removeStartIgnoreCase(null, \"\")", (Object)StringUtils.removeStartIgnoreCase(null, (String)""));
        Assert.assertNull((String)"removeStartIgnoreCase(null, \"a\")", (Object)StringUtils.removeStartIgnoreCase(null, (String)"a"));
        Assert.assertEquals((String)"removeStartIgnoreCase(\"\", null)", (Object)StringUtils.removeStartIgnoreCase((String)"", null), (Object)"");
        Assert.assertEquals((String)"removeStartIgnoreCase(\"\", \"\")", (Object)StringUtils.removeStartIgnoreCase((String)"", (String)""), (Object)"");
        Assert.assertEquals((String)"removeStartIgnoreCase(\"\", \"a\")", (Object)StringUtils.removeStartIgnoreCase((String)"", (String)"a"), (Object)"");
        Assert.assertEquals((String)"removeStartIgnoreCase(\"www.domain.com\", \"www.\")", (Object)StringUtils.removeStartIgnoreCase((String)"www.domain.com", (String)"www."), (Object)"domain.com");
        Assert.assertEquals((String)"removeStartIgnoreCase(\"domain.com\", \"www.\")", (Object)StringUtils.removeStartIgnoreCase((String)"domain.com", (String)"www."), (Object)"domain.com");
        Assert.assertEquals((String)"removeStartIgnoreCase(\"domain.com\", \"\")", (Object)StringUtils.removeStartIgnoreCase((String)"domain.com", (String)""), (Object)"domain.com");
        Assert.assertEquals((String)"removeStartIgnoreCase(\"domain.com\", null)", (Object)StringUtils.removeStartIgnoreCase((String)"domain.com", null), (Object)"domain.com");
        Assert.assertEquals((String)"removeStartIgnoreCase(\"www.domain.com\", \"WWW.\")", (Object)StringUtils.removeStartIgnoreCase((String)"www.domain.com", (String)"WWW."), (Object)"domain.com");
    }

    @Test
    public void testRemoveEnd() {
        Assert.assertNull((Object)StringUtils.removeEnd(null, null));
        Assert.assertNull((Object)StringUtils.removeEnd(null, (String)""));
        Assert.assertNull((Object)StringUtils.removeEnd(null, (String)"a"));
        Assert.assertEquals((Object)StringUtils.removeEnd((String)"", null), (Object)"");
        Assert.assertEquals((Object)StringUtils.removeEnd((String)"", (String)""), (Object)"");
        Assert.assertEquals((Object)StringUtils.removeEnd((String)"", (String)"a"), (Object)"");
        Assert.assertEquals((Object)StringUtils.removeEnd((String)"www.domain.com.", (String)".com"), (Object)"www.domain.com.");
        Assert.assertEquals((Object)StringUtils.removeEnd((String)"www.domain.com", (String)".com"), (Object)"www.domain");
        Assert.assertEquals((Object)StringUtils.removeEnd((String)"www.domain", (String)".com"), (Object)"www.domain");
        Assert.assertEquals((Object)StringUtils.removeEnd((String)"domain.com", (String)""), (Object)"domain.com");
        Assert.assertEquals((Object)StringUtils.removeEnd((String)"domain.com", null), (Object)"domain.com");
    }

    @Test
    public void testRemoveEndIgnoreCase() {
        Assert.assertNull((String)"removeEndIgnoreCase(null, null)", (Object)StringUtils.removeEndIgnoreCase(null, null));
        Assert.assertNull((String)"removeEndIgnoreCase(null, \"\")", (Object)StringUtils.removeEndIgnoreCase(null, (String)""));
        Assert.assertNull((String)"removeEndIgnoreCase(null, \"a\")", (Object)StringUtils.removeEndIgnoreCase(null, (String)"a"));
        Assert.assertEquals((String)"removeEndIgnoreCase(\"\", null)", (Object)StringUtils.removeEndIgnoreCase((String)"", null), (Object)"");
        Assert.assertEquals((String)"removeEndIgnoreCase(\"\", \"\")", (Object)StringUtils.removeEndIgnoreCase((String)"", (String)""), (Object)"");
        Assert.assertEquals((String)"removeEndIgnoreCase(\"\", \"a\")", (Object)StringUtils.removeEndIgnoreCase((String)"", (String)"a"), (Object)"");
        Assert.assertEquals((String)"removeEndIgnoreCase(\"www.domain.com.\", \".com\")", (Object)StringUtils.removeEndIgnoreCase((String)"www.domain.com.", (String)".com"), (Object)"www.domain.com.");
        Assert.assertEquals((String)"removeEndIgnoreCase(\"www.domain.com\", \".com\")", (Object)StringUtils.removeEndIgnoreCase((String)"www.domain.com", (String)".com"), (Object)"www.domain");
        Assert.assertEquals((String)"removeEndIgnoreCase(\"www.domain\", \".com\")", (Object)StringUtils.removeEndIgnoreCase((String)"www.domain", (String)".com"), (Object)"www.domain");
        Assert.assertEquals((String)"removeEndIgnoreCase(\"domain.com\", \"\")", (Object)StringUtils.removeEndIgnoreCase((String)"domain.com", (String)""), (Object)"domain.com");
        Assert.assertEquals((String)"removeEndIgnoreCase(\"domain.com\", null)", (Object)StringUtils.removeEndIgnoreCase((String)"domain.com", null), (Object)"domain.com");
        Assert.assertEquals((String)"removeEndIgnoreCase(\"www.domain.com\", \".COM\")", (Object)StringUtils.removeEndIgnoreCase((String)"www.domain.com", (String)".COM"), (Object)"www.domain");
        Assert.assertEquals((String)"removeEndIgnoreCase(\"www.domain.COM\", \".com\")", (Object)StringUtils.removeEndIgnoreCase((String)"www.domain.COM", (String)".com"), (Object)"www.domain");
    }

    @Test
    public void testRemove_String() {
        Assert.assertNull((Object)StringUtils.remove(null, null));
        Assert.assertNull((Object)StringUtils.remove(null, (String)""));
        Assert.assertNull((Object)StringUtils.remove(null, (String)"a"));
        Assert.assertEquals((Object)"", (Object)StringUtils.remove((String)"", null));
        Assert.assertEquals((Object)"", (Object)StringUtils.remove((String)"", (String)""));
        Assert.assertEquals((Object)"", (Object)StringUtils.remove((String)"", (String)"a"));
        Assert.assertNull((Object)StringUtils.remove(null, null));
        Assert.assertEquals((Object)"", (Object)StringUtils.remove((String)"", null));
        Assert.assertEquals((Object)"a", (Object)StringUtils.remove((String)"a", null));
        Assert.assertNull((Object)StringUtils.remove(null, (String)""));
        Assert.assertEquals((Object)"", (Object)StringUtils.remove((String)"", (String)""));
        Assert.assertEquals((Object)"a", (Object)StringUtils.remove((String)"a", (String)""));
        Assert.assertEquals((Object)"qd", (Object)StringUtils.remove((String)"queued", (String)"ue"));
        Assert.assertEquals((Object)"queued", (Object)StringUtils.remove((String)"queued", (String)"zz"));
    }

    @Test
    public void testRemove_char() {
        Assert.assertNull((Object)StringUtils.remove(null, (char)'a'));
        Assert.assertNull((Object)StringUtils.remove(null, (char)'a'));
        Assert.assertNull((Object)StringUtils.remove(null, (char)'a'));
        Assert.assertEquals((Object)"", (Object)StringUtils.remove((String)"", (char)'a'));
        Assert.assertEquals((Object)"", (Object)StringUtils.remove((String)"", (char)'a'));
        Assert.assertEquals((Object)"", (Object)StringUtils.remove((String)"", (char)'a'));
        Assert.assertEquals((Object)"qeed", (Object)StringUtils.remove((String)"queued", (char)'u'));
        Assert.assertEquals((Object)"queued", (Object)StringUtils.remove((String)"queued", (char)'z'));
    }

    @Test
    public void testDifferenceAt_StringArray() {
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfDifference((CharSequence[])null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfDifference((CharSequence[])new String[0]));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfDifference((CharSequence[])new String[]{"abc"}));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfDifference((CharSequence[])new String[]{null, null}));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfDifference((CharSequence[])new String[]{"", ""}));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfDifference((CharSequence[])new String[]{"", null}));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfDifference((CharSequence[])new String[]{"abc", null, null}));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfDifference((CharSequence[])new String[]{null, null, "abc"}));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfDifference((CharSequence[])new String[]{"", "abc"}));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfDifference((CharSequence[])new String[]{"abc", ""}));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfDifference((CharSequence[])new String[]{"abc", "abc"}));
        Assert.assertEquals((long)1L, (long)StringUtils.indexOfDifference((CharSequence[])new String[]{"abc", "a"}));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOfDifference((CharSequence[])new String[]{"ab", "abxyz"}));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOfDifference((CharSequence[])new String[]{"abcde", "abxyz"}));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfDifference((CharSequence[])new String[]{"abcde", "xyz"}));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfDifference((CharSequence[])new String[]{"xyz", "abcde"}));
        Assert.assertEquals((long)7L, (long)StringUtils.indexOfDifference((CharSequence[])new String[]{"i am a machine", "i am a robot"}));
    }

    @Test
    public void testGetCommonPrefix_StringArray() {
        Assert.assertEquals((Object)"", (Object)StringUtils.getCommonPrefix((String[])null));
        Assert.assertEquals((Object)"", (Object)StringUtils.getCommonPrefix((String[])new String[0]));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.getCommonPrefix((String[])new String[]{"abc"}));
        Assert.assertEquals((Object)"", (Object)StringUtils.getCommonPrefix((String[])new String[]{null, null}));
        Assert.assertEquals((Object)"", (Object)StringUtils.getCommonPrefix((String[])new String[]{"", ""}));
        Assert.assertEquals((Object)"", (Object)StringUtils.getCommonPrefix((String[])new String[]{"", null}));
        Assert.assertEquals((Object)"", (Object)StringUtils.getCommonPrefix((String[])new String[]{"abc", null, null}));
        Assert.assertEquals((Object)"", (Object)StringUtils.getCommonPrefix((String[])new String[]{null, null, "abc"}));
        Assert.assertEquals((Object)"", (Object)StringUtils.getCommonPrefix((String[])new String[]{"", "abc"}));
        Assert.assertEquals((Object)"", (Object)StringUtils.getCommonPrefix((String[])new String[]{"abc", ""}));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.getCommonPrefix((String[])new String[]{"abc", "abc"}));
        Assert.assertEquals((Object)"a", (Object)StringUtils.getCommonPrefix((String[])new String[]{"abc", "a"}));
        Assert.assertEquals((Object)"ab", (Object)StringUtils.getCommonPrefix((String[])new String[]{"ab", "abxyz"}));
        Assert.assertEquals((Object)"ab", (Object)StringUtils.getCommonPrefix((String[])new String[]{"abcde", "abxyz"}));
        Assert.assertEquals((Object)"", (Object)StringUtils.getCommonPrefix((String[])new String[]{"abcde", "xyz"}));
        Assert.assertEquals((Object)"", (Object)StringUtils.getCommonPrefix((String[])new String[]{"xyz", "abcde"}));
        Assert.assertEquals((Object)"i am a ", (Object)StringUtils.getCommonPrefix((String[])new String[]{"i am a machine", "i am a robot"}));
    }

    @Test
    public void testNormalizeSpace() {
        Assert.assertNull((Object)StringUtils.normalizeSpace(null));
        Assert.assertEquals((Object)"", (Object)StringUtils.normalizeSpace((String)""));
        Assert.assertEquals((Object)"", (Object)StringUtils.normalizeSpace((String)" "));
        Assert.assertEquals((Object)"", (Object)StringUtils.normalizeSpace((String)"\t"));
        Assert.assertEquals((Object)"", (Object)StringUtils.normalizeSpace((String)"\n"));
        Assert.assertEquals((Object)"", (Object)StringUtils.normalizeSpace((String)"\t"));
        Assert.assertEquals((Object)"", (Object)StringUtils.normalizeSpace((String)"\u000b"));
        Assert.assertEquals((Object)"", (Object)StringUtils.normalizeSpace((String)"\f"));
        Assert.assertEquals((Object)"", (Object)StringUtils.normalizeSpace((String)"\u001c"));
        Assert.assertEquals((Object)"", (Object)StringUtils.normalizeSpace((String)"\u001d"));
        Assert.assertEquals((Object)"", (Object)StringUtils.normalizeSpace((String)"\u001e"));
        Assert.assertEquals((Object)"", (Object)StringUtils.normalizeSpace((String)"\u001f"));
        Assert.assertEquals((Object)"", (Object)StringUtils.normalizeSpace((String)"\f"));
        Assert.assertEquals((Object)"", (Object)StringUtils.normalizeSpace((String)"\r"));
        Assert.assertEquals((Object)"a", (Object)StringUtils.normalizeSpace((String)"  a  "));
        Assert.assertEquals((Object)"a b c", (Object)StringUtils.normalizeSpace((String)"  a  b   c  "));
        Assert.assertEquals((Object)"a b c", (Object)StringUtils.normalizeSpace((String)"a\t\f\r  b\u000b   c\n"));
        Assert.assertEquals((Object)"a   b c", (Object)StringUtils.normalizeSpace((String)("a\t\f\r  " + HARD_SPACE + HARD_SPACE + "b\u000b   c\n")));
    }

    @Test
    public void testLANG666() {
        Assert.assertEquals((Object)"12", (Object)StringUtils.stripEnd((String)"120.00", (String)".0"));
        Assert.assertEquals((Object)"121", (Object)StringUtils.stripEnd((String)"121.00", (String)".0"));
    }

    @Test
    public void testStringUtilsCharSequenceContract() {
        Method[] methods;
        Class<StringUtils> c = StringUtils.class;
        for (Method m : methods = c.getMethods()) {
            Class<?>[] params;
            if (m.getReturnType() == String.class || m.getReturnType() == String[].class) {
                params = m.getParameterTypes();
                if (params.length <= 0 || params[0] != CharSequence.class && params[0] != CharSequence[].class) continue;
                Assert.fail((String)("The method " + m + " appears to be mutable in spirit and therefore must not accept a CharSequence"));
                continue;
            }
            params = m.getParameterTypes();
            if (params.length <= 0 || params[0] != String.class && params[0] != String[].class) continue;
            Assert.fail((String)("The method " + m + " appears to be immutable in spirit and therefore must not accept a String"));
        }
    }

    @Test
    public void testToString() throws UnsupportedEncodingException {
        String expectedString = "The quick brown fox jumped over the lazy dog.";
        String encoding = SystemUtils.FILE_ENCODING;
        byte[] expectedBytes = "The quick brown fox jumped over the lazy dog.".getBytes(encoding);
        Assert.assertArrayEquals((byte[])expectedBytes, (byte[])"The quick brown fox jumped over the lazy dog.".getBytes());
        Assert.assertEquals((Object)"The quick brown fox jumped over the lazy dog.", (Object)StringUtils.toString((byte[])expectedBytes, null));
        Assert.assertEquals((Object)"The quick brown fox jumped over the lazy dog.", (Object)StringUtils.toString((byte[])expectedBytes, (String)encoding));
        encoding = "UTF-16";
        expectedBytes = "The quick brown fox jumped over the lazy dog.".getBytes(encoding);
        Assert.assertEquals((Object)"The quick brown fox jumped over the lazy dog.", (Object)StringUtils.toString((byte[])expectedBytes, (String)encoding));
    }

    @Test
    public void testEscapeSurrogatePairs() throws Exception {
        Assert.assertEquals((Object)"\ud83d\ude30", (Object)StringEscapeUtils.escapeCsv((String)"\ud83d\ude30"));
        Assert.assertEquals((Object)"\ud800\udc00", (Object)StringEscapeUtils.escapeCsv((String)"\ud800\udc00"));
        Assert.assertEquals((Object)"\ud834\udd1e", (Object)StringEscapeUtils.escapeCsv((String)"\ud834\udd1e"));
        Assert.assertEquals((Object)"\udbff\udffd", (Object)StringEscapeUtils.escapeCsv((String)"\udbff\udffd"));
        Assert.assertEquals((Object)"\udbff\udffd", (Object)StringEscapeUtils.escapeHtml3((String)"\udbff\udffd"));
        Assert.assertEquals((Object)"\udbff\udffd", (Object)StringEscapeUtils.escapeHtml4((String)"\udbff\udffd"));
        Assert.assertEquals((Object)"\udbff\udffd", (Object)StringEscapeUtils.escapeXml((String)"\udbff\udffd"));
    }

    @Test
    public void testEscapeSurrogatePairsLang858() throws Exception {
        Assert.assertEquals((Object)"\\uDBFF\\uDFFD", (Object)StringEscapeUtils.escapeJava((String)"\udbff\udffd"));
        Assert.assertEquals((Object)"\\uDBFF\\uDFFD", (Object)StringEscapeUtils.escapeEcmaScript((String)"\udbff\udffd"));
    }

    @Test
    public void testUnescapeSurrogatePairs() throws Exception {
        Assert.assertEquals((Object)"\ud83d\ude30", (Object)StringEscapeUtils.unescapeCsv((String)"\ud83d\ude30"));
        Assert.assertEquals((Object)"\ud800\udc00", (Object)StringEscapeUtils.unescapeCsv((String)"\ud800\udc00"));
        Assert.assertEquals((Object)"\ud834\udd1e", (Object)StringEscapeUtils.unescapeCsv((String)"\ud834\udd1e"));
        Assert.assertEquals((Object)"\udbff\udffd", (Object)StringEscapeUtils.unescapeCsv((String)"\udbff\udffd"));
        Assert.assertEquals((Object)"\udbff\udffd", (Object)StringEscapeUtils.unescapeHtml3((String)"\udbff\udffd"));
        Assert.assertEquals((Object)"\udbff\udffd", (Object)StringEscapeUtils.unescapeHtml4((String)"\udbff\udffd"));
    }

    @Test
    public void testAppendIfMissing() {
        Assert.assertEquals((String)"appendIfMissing(null,null)", null, (Object)StringUtils.appendIfMissing(null, null, (CharSequence[])new CharSequence[0]));
        Assert.assertEquals((String)"appendIfMissing(abc,null)", (Object)"abc", (Object)StringUtils.appendIfMissing((String)"abc", null, (CharSequence[])new CharSequence[0]));
        Assert.assertEquals((String)"appendIfMissing(\"\",xyz)", (Object)"xyz", (Object)StringUtils.appendIfMissing((String)"", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]));
        Assert.assertEquals((String)"appendIfMissing(abc,xyz)", (Object)"abcxyz", (Object)StringUtils.appendIfMissing((String)"abc", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]));
        Assert.assertEquals((String)"appendIfMissing(abcxyz,xyz)", (Object)"abcxyz", (Object)StringUtils.appendIfMissing((String)"abcxyz", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]));
        Assert.assertEquals((String)"appendIfMissing(aXYZ,xyz)", (Object)"aXYZxyz", (Object)StringUtils.appendIfMissing((String)"aXYZ", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]));
        Assert.assertEquals((String)"appendIfMissing(null,null,null)", null, (Object)StringUtils.appendIfMissing(null, null, (CharSequence[])null));
        Assert.assertEquals((String)"appendIfMissing(abc,null,null)", (Object)"abc", (Object)StringUtils.appendIfMissing((String)"abc", null, (CharSequence[])null));
        Assert.assertEquals((String)"appendIfMissing(\"\",xyz,null))", (Object)"xyz", (Object)StringUtils.appendIfMissing((String)"", (CharSequence)"xyz", (CharSequence[])null));
        Assert.assertEquals((String)"appendIfMissing(abc,xyz,{null})", (Object)"abcxyz", (Object)StringUtils.appendIfMissing((String)"abc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{null}));
        Assert.assertEquals((String)"appendIfMissing(abc,xyz,\"\")", (Object)"abc", (Object)StringUtils.appendIfMissing((String)"abc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{""}));
        Assert.assertEquals((String)"appendIfMissing(abc,xyz,mno)", (Object)"abcxyz", (Object)StringUtils.appendIfMissing((String)"abc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}));
        Assert.assertEquals((String)"appendIfMissing(abcxyz,xyz,mno)", (Object)"abcxyz", (Object)StringUtils.appendIfMissing((String)"abcxyz", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}));
        Assert.assertEquals((String)"appendIfMissing(abcmno,xyz,mno)", (Object)"abcmno", (Object)StringUtils.appendIfMissing((String)"abcmno", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}));
        Assert.assertEquals((String)"appendIfMissing(abcXYZ,xyz,mno)", (Object)"abcXYZxyz", (Object)StringUtils.appendIfMissing((String)"abcXYZ", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}));
        Assert.assertEquals((String)"appendIfMissing(abcMNO,xyz,mno)", (Object)"abcMNOxyz", (Object)StringUtils.appendIfMissing((String)"abcMNO", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}));
    }

    @Test
    public void testAppendIfMissingIgnoreCase() {
        Assert.assertEquals((String)"appendIfMissingIgnoreCase(null,null)", null, (Object)StringUtils.appendIfMissingIgnoreCase(null, null, (CharSequence[])new CharSequence[0]));
        Assert.assertEquals((String)"appendIfMissingIgnoreCase(abc,null)", (Object)"abc", (Object)StringUtils.appendIfMissingIgnoreCase((String)"abc", null, (CharSequence[])new CharSequence[0]));
        Assert.assertEquals((String)"appendIfMissingIgnoreCase(\"\",xyz)", (Object)"xyz", (Object)StringUtils.appendIfMissingIgnoreCase((String)"", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]));
        Assert.assertEquals((String)"appendIfMissingIgnoreCase(abc,xyz)", (Object)"abcxyz", (Object)StringUtils.appendIfMissingIgnoreCase((String)"abc", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]));
        Assert.assertEquals((String)"appendIfMissingIgnoreCase(abcxyz,xyz)", (Object)"abcxyz", (Object)StringUtils.appendIfMissingIgnoreCase((String)"abcxyz", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]));
        Assert.assertEquals((String)"appendIfMissingIgnoreCase(abcXYZ,xyz)", (Object)"abcXYZ", (Object)StringUtils.appendIfMissingIgnoreCase((String)"abcXYZ", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]));
        Assert.assertEquals((String)"appendIfMissingIgnoreCase(null,null,null)", null, (Object)StringUtils.appendIfMissingIgnoreCase(null, null, (CharSequence[])null));
        Assert.assertEquals((String)"appendIfMissingIgnoreCase(abc,null,null)", (Object)"abc", (Object)StringUtils.appendIfMissingIgnoreCase((String)"abc", null, (CharSequence[])null));
        Assert.assertEquals((String)"appendIfMissingIgnoreCase(\"\",xyz,null)", (Object)"xyz", (Object)StringUtils.appendIfMissingIgnoreCase((String)"", (CharSequence)"xyz", (CharSequence[])null));
        Assert.assertEquals((String)"appendIfMissingIgnoreCase(abc,xyz,{null})", (Object)"abcxyz", (Object)StringUtils.appendIfMissingIgnoreCase((String)"abc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{null}));
        Assert.assertEquals((String)"appendIfMissingIgnoreCase(abc,xyz,\"\")", (Object)"abc", (Object)StringUtils.appendIfMissingIgnoreCase((String)"abc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{""}));
        Assert.assertEquals((String)"appendIfMissingIgnoreCase(abc,xyz,mno)", (Object)"abcxyz", (Object)StringUtils.appendIfMissingIgnoreCase((String)"abc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}));
        Assert.assertEquals((String)"appendIfMissingIgnoreCase(abcxyz,xyz,mno)", (Object)"abcxyz", (Object)StringUtils.appendIfMissingIgnoreCase((String)"abcxyz", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}));
        Assert.assertEquals((String)"appendIfMissingIgnoreCase(abcmno,xyz,mno)", (Object)"abcmno", (Object)StringUtils.appendIfMissingIgnoreCase((String)"abcmno", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}));
        Assert.assertEquals((String)"appendIfMissingIgnoreCase(abcXYZ,xyz,mno)", (Object)"abcXYZ", (Object)StringUtils.appendIfMissingIgnoreCase((String)"abcXYZ", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}));
        Assert.assertEquals((String)"appendIfMissingIgnoreCase(abcMNO,xyz,mno)", (Object)"abcMNO", (Object)StringUtils.appendIfMissingIgnoreCase((String)"abcMNO", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}));
    }

    @Test
    public void testPrependIfMissing() {
        Assert.assertEquals((String)"prependIfMissing(null,null)", null, (Object)StringUtils.prependIfMissing(null, null, (CharSequence[])new CharSequence[0]));
        Assert.assertEquals((String)"prependIfMissing(abc,null)", (Object)"abc", (Object)StringUtils.prependIfMissing((String)"abc", null, (CharSequence[])new CharSequence[0]));
        Assert.assertEquals((String)"prependIfMissing(\"\",xyz)", (Object)"xyz", (Object)StringUtils.prependIfMissing((String)"", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]));
        Assert.assertEquals((String)"prependIfMissing(abc,xyz)", (Object)"xyzabc", (Object)StringUtils.prependIfMissing((String)"abc", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]));
        Assert.assertEquals((String)"prependIfMissing(xyzabc,xyz)", (Object)"xyzabc", (Object)StringUtils.prependIfMissing((String)"xyzabc", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]));
        Assert.assertEquals((String)"prependIfMissing(XYZabc,xyz)", (Object)"xyzXYZabc", (Object)StringUtils.prependIfMissing((String)"XYZabc", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]));
        Assert.assertEquals((String)"prependIfMissing(null,null null)", null, (Object)StringUtils.prependIfMissing(null, null, (CharSequence[])null));
        Assert.assertEquals((String)"prependIfMissing(abc,null,null)", (Object)"abc", (Object)StringUtils.prependIfMissing((String)"abc", null, (CharSequence[])null));
        Assert.assertEquals((String)"prependIfMissing(\"\",xyz,null)", (Object)"xyz", (Object)StringUtils.prependIfMissing((String)"", (CharSequence)"xyz", (CharSequence[])null));
        Assert.assertEquals((String)"prependIfMissing(abc,xyz,{null})", (Object)"xyzabc", (Object)StringUtils.prependIfMissing((String)"abc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{null}));
        Assert.assertEquals((String)"prependIfMissing(abc,xyz,\"\")", (Object)"abc", (Object)StringUtils.prependIfMissing((String)"abc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{""}));
        Assert.assertEquals((String)"prependIfMissing(abc,xyz,mno)", (Object)"xyzabc", (Object)StringUtils.prependIfMissing((String)"abc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}));
        Assert.assertEquals((String)"prependIfMissing(xyzabc,xyz,mno)", (Object)"xyzabc", (Object)StringUtils.prependIfMissing((String)"xyzabc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}));
        Assert.assertEquals((String)"prependIfMissing(mnoabc,xyz,mno)", (Object)"mnoabc", (Object)StringUtils.prependIfMissing((String)"mnoabc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}));
        Assert.assertEquals((String)"prependIfMissing(XYZabc,xyz,mno)", (Object)"xyzXYZabc", (Object)StringUtils.prependIfMissing((String)"XYZabc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}));
        Assert.assertEquals((String)"prependIfMissing(MNOabc,xyz,mno)", (Object)"xyzMNOabc", (Object)StringUtils.prependIfMissing((String)"MNOabc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}));
    }

    @Test
    public void testPrependIfMissingIgnoreCase() {
        Assert.assertEquals((String)"prependIfMissingIgnoreCase(null,null)", null, (Object)StringUtils.prependIfMissingIgnoreCase(null, null, (CharSequence[])new CharSequence[0]));
        Assert.assertEquals((String)"prependIfMissingIgnoreCase(abc,null)", (Object)"abc", (Object)StringUtils.prependIfMissingIgnoreCase((String)"abc", null, (CharSequence[])new CharSequence[0]));
        Assert.assertEquals((String)"prependIfMissingIgnoreCase(\"\",xyz)", (Object)"xyz", (Object)StringUtils.prependIfMissingIgnoreCase((String)"", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]));
        Assert.assertEquals((String)"prependIfMissingIgnoreCase(abc,xyz)", (Object)"xyzabc", (Object)StringUtils.prependIfMissingIgnoreCase((String)"abc", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]));
        Assert.assertEquals((String)"prependIfMissingIgnoreCase(xyzabc,xyz)", (Object)"xyzabc", (Object)StringUtils.prependIfMissingIgnoreCase((String)"xyzabc", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]));
        Assert.assertEquals((String)"prependIfMissingIgnoreCase(XYZabc,xyz)", (Object)"XYZabc", (Object)StringUtils.prependIfMissingIgnoreCase((String)"XYZabc", (CharSequence)"xyz", (CharSequence[])new CharSequence[0]));
        Assert.assertEquals((String)"prependIfMissingIgnoreCase(null,null null)", null, (Object)StringUtils.prependIfMissingIgnoreCase(null, null, (CharSequence[])null));
        Assert.assertEquals((String)"prependIfMissingIgnoreCase(abc,null,null)", (Object)"abc", (Object)StringUtils.prependIfMissingIgnoreCase((String)"abc", null, (CharSequence[])null));
        Assert.assertEquals((String)"prependIfMissingIgnoreCase(\"\",xyz,null)", (Object)"xyz", (Object)StringUtils.prependIfMissingIgnoreCase((String)"", (CharSequence)"xyz", (CharSequence[])null));
        Assert.assertEquals((String)"prependIfMissingIgnoreCase(abc,xyz,{null})", (Object)"xyzabc", (Object)StringUtils.prependIfMissingIgnoreCase((String)"abc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{null}));
        Assert.assertEquals((String)"prependIfMissingIgnoreCase(abc,xyz,\"\")", (Object)"abc", (Object)StringUtils.prependIfMissingIgnoreCase((String)"abc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{""}));
        Assert.assertEquals((String)"prependIfMissingIgnoreCase(abc,xyz,mno)", (Object)"xyzabc", (Object)StringUtils.prependIfMissingIgnoreCase((String)"abc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}));
        Assert.assertEquals((String)"prependIfMissingIgnoreCase(xyzabc,xyz,mno)", (Object)"xyzabc", (Object)StringUtils.prependIfMissingIgnoreCase((String)"xyzabc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}));
        Assert.assertEquals((String)"prependIfMissingIgnoreCase(mnoabc,xyz,mno)", (Object)"mnoabc", (Object)StringUtils.prependIfMissingIgnoreCase((String)"mnoabc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}));
        Assert.assertEquals((String)"prependIfMissingIgnoreCase(XYZabc,xyz,mno)", (Object)"XYZabc", (Object)StringUtils.prependIfMissingIgnoreCase((String)"XYZabc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}));
        Assert.assertEquals((String)"prependIfMissingIgnoreCase(MNOabc,xyz,mno)", (Object)"MNOabc", (Object)StringUtils.prependIfMissingIgnoreCase((String)"MNOabc", (CharSequence)"xyz", (CharSequence[])new CharSequence[]{"mno"}));
    }

    @Test
    public void testToEncodedString() throws UnsupportedEncodingException {
        String expectedString = "The quick brown fox jumped over the lazy dog.";
        String encoding = SystemUtils.FILE_ENCODING;
        byte[] expectedBytes = "The quick brown fox jumped over the lazy dog.".getBytes(encoding);
        Assert.assertArrayEquals((byte[])expectedBytes, (byte[])"The quick brown fox jumped over the lazy dog.".getBytes());
        Assert.assertEquals((Object)"The quick brown fox jumped over the lazy dog.", (Object)StringUtils.toEncodedString((byte[])expectedBytes, (Charset)Charset.defaultCharset()));
        Assert.assertEquals((Object)"The quick brown fox jumped over the lazy dog.", (Object)StringUtils.toEncodedString((byte[])expectedBytes, (Charset)Charset.forName(encoding)));
        encoding = "UTF-16";
        expectedBytes = "The quick brown fox jumped over the lazy dog.".getBytes(encoding);
        Assert.assertEquals((Object)"The quick brown fox jumped over the lazy dog.", (Object)StringUtils.toEncodedString((byte[])expectedBytes, (Charset)Charset.forName(encoding)));
    }

    static {
        int i;
        String ws = "";
        String nws = "";
        String hs = String.valueOf('\u00a0');
        String tr = "";
        String ntr = "";
        for (i = 0; i < 65535; ++i) {
            if (Character.isWhitespace((char)i)) {
                ws = ws + String.valueOf((char)i);
                if (i <= 32) continue;
                ntr = ntr + String.valueOf((char)i);
                continue;
            }
            if (i >= 40) continue;
            nws = nws + String.valueOf((char)i);
        }
        for (i = 0; i <= 32; ++i) {
            tr = tr + String.valueOf((char)i);
        }
        WHITESPACE = ws;
        NON_WHITESPACE = nws;
        HARD_SPACE = hs;
        TRIMMABLE = tr;
        NON_TRIMMABLE = ntr;
        ARRAY_LIST = new String[]{FOO_UNCAP, "bar", "baz"};
        EMPTY_ARRAY_LIST = new String[0];
        NULL_ARRAY_LIST = new String[]{null};
        NULL_TO_STRING_LIST = new Object[]{new Object(){

            public String toString() {
                return null;
            }
        }};
        MIXED_ARRAY_LIST = new String[]{null, "", FOO_UNCAP};
        MIXED_TYPE_LIST = new Object[]{FOO_UNCAP, 2L};
        LONG_PRIM_LIST = new long[]{1L, 2L};
        INT_PRIM_LIST = new int[]{1, 2};
        BYTE_PRIM_LIST = new byte[]{1, 2};
        SHORT_PRIM_LIST = new short[]{1, 2};
        CHAR_PRIM_LIST = new char[]{'1', '2'};
        FLOAT_PRIM_LIST = new float[]{1.0f, 2.0f};
        DOUBLE_PRIM_LIST = new double[]{1.0, 2.0};
    }
}

