/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BasicThreadFactoryTest {
    private static final String PATTERN = "testThread-%d";
    private BasicThreadFactory.Builder builder;

    @Before
    public void setUp() throws Exception {
        this.builder = new BasicThreadFactory.Builder();
    }

    private void checkFactoryDefaults(BasicThreadFactory factory) {
        Assert.assertNull((String)"Got a naming pattern", (Object)factory.getNamingPattern());
        Assert.assertNull((String)"Got an exception handler", (Object)factory.getUncaughtExceptionHandler());
        Assert.assertNull((String)"Got a priority", (Object)factory.getPriority());
        Assert.assertNull((String)"Got a daemon flag", (Object)factory.getDaemonFlag());
        Assert.assertNotNull((String)"No wrapped factory", (Object)factory.getWrappedFactory());
    }

    @Test
    public void testBuildDefaults() {
        BasicThreadFactory factory = this.builder.build();
        this.checkFactoryDefaults(factory);
    }

    @Test(expected=NullPointerException.class)
    public void testBuildNamingPatternNull() {
        this.builder.namingPattern(null);
    }

    @Test(expected=NullPointerException.class)
    public void testBuildWrappedFactoryNull() {
        this.builder.wrappedFactory(null);
    }

    @Test(expected=NullPointerException.class)
    public void testBuildUncaughtExceptionHandlerNull() {
        this.builder.uncaughtExceptionHandler(null);
    }

    @Test
    public void testBuilderReset() {
        ThreadFactory wrappedFactory = (ThreadFactory)EasyMock.createMock(ThreadFactory.class);
        Thread.UncaughtExceptionHandler exHandler = (Thread.UncaughtExceptionHandler)EasyMock.createMock(Thread.UncaughtExceptionHandler.class);
        EasyMock.replay((Object[])new Object[]{wrappedFactory, exHandler});
        this.builder.namingPattern(PATTERN).daemon(true).priority(10).uncaughtExceptionHandler(exHandler).wrappedFactory(wrappedFactory);
        this.builder.reset();
        BasicThreadFactory factory = this.builder.build();
        this.checkFactoryDefaults(factory);
        Assert.assertNotSame((String)"Wrapped factory not reset", (Object)wrappedFactory, (Object)factory.getWrappedFactory());
        EasyMock.verify((Object[])new Object[]{wrappedFactory, exHandler});
    }

    @Test
    public void testBuilderResetAfterBuild() {
        this.builder.wrappedFactory((ThreadFactory)EasyMock.createNiceMock(ThreadFactory.class)).namingPattern(PATTERN).daemon(true).build();
        this.checkFactoryDefaults(this.builder.build());
    }

    @Test
    public void testNewThreadNamingPattern() {
        ThreadFactory wrapped = (ThreadFactory)EasyMock.createMock(ThreadFactory.class);
        Runnable r = (Runnable)EasyMock.createMock(Runnable.class);
        int count = 12;
        for (int i = 0; i < 12; ++i) {
            EasyMock.expect((Object)wrapped.newThread(r)).andReturn((Object)new Thread());
        }
        EasyMock.replay((Object[])new Object[]{wrapped, r});
        BasicThreadFactory factory = this.builder.wrappedFactory(wrapped).namingPattern(PATTERN).build();
        for (int i = 0; i < 12; ++i) {
            Thread t = factory.newThread(r);
            Assert.assertEquals((String)"Wrong thread name", (Object)String.format(PATTERN, i + 1), (Object)t.getName());
            Assert.assertEquals((String)"Wrong thread count", (long)(i + 1), (long)factory.getThreadCount());
        }
        EasyMock.verify((Object[])new Object[]{wrapped, r});
    }

    @Test
    public void testNewThreadNoNamingPattern() {
        ThreadFactory wrapped = (ThreadFactory)EasyMock.createMock(ThreadFactory.class);
        Runnable r = (Runnable)EasyMock.createMock(Runnable.class);
        String name = "unchangedThreadName";
        Thread t = new Thread("unchangedThreadName");
        EasyMock.expect((Object)wrapped.newThread(r)).andReturn((Object)t);
        EasyMock.replay((Object[])new Object[]{wrapped, r});
        BasicThreadFactory factory = this.builder.wrappedFactory(wrapped).build();
        Assert.assertSame((String)"Wrong thread", (Object)t, (Object)factory.newThread(r));
        Assert.assertEquals((String)"Name was changed", (Object)"unchangedThreadName", (Object)t.getName());
        EasyMock.verify((Object[])new Object[]{wrapped, r});
    }

    private void checkDaemonFlag(boolean flag) {
        ThreadFactory wrapped = (ThreadFactory)EasyMock.createMock(ThreadFactory.class);
        Runnable r = (Runnable)EasyMock.createMock(Runnable.class);
        Thread t = new Thread();
        EasyMock.expect((Object)wrapped.newThread(r)).andReturn((Object)t);
        EasyMock.replay((Object[])new Object[]{wrapped, r});
        BasicThreadFactory factory = this.builder.wrappedFactory(wrapped).daemon(flag).build();
        Assert.assertSame((String)"Wrong thread", (Object)t, (Object)factory.newThread(r));
        Assert.assertTrue((String)"Wrong daemon flag", (flag == t.isDaemon() ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{wrapped, r});
    }

    @Test
    public void testNewThreadDaemonTrue() {
        this.checkDaemonFlag(true);
    }

    @Test
    public void testNewThreadDaemonFalse() {
        this.checkDaemonFlag(false);
    }

    @Test
    public void testNewThreadNoDaemonFlag() {
        ThreadFactory wrapped = (ThreadFactory)EasyMock.createMock(ThreadFactory.class);
        Runnable r1 = (Runnable)EasyMock.createMock(Runnable.class);
        Runnable r2 = (Runnable)EasyMock.createMock(Runnable.class);
        Thread t1 = new Thread();
        Thread t2 = new Thread();
        t1.setDaemon(true);
        EasyMock.expect((Object)wrapped.newThread(r1)).andReturn((Object)t1);
        EasyMock.expect((Object)wrapped.newThread(r2)).andReturn((Object)t2);
        EasyMock.replay((Object[])new Object[]{wrapped, r1, r2});
        BasicThreadFactory factory = this.builder.wrappedFactory(wrapped).build();
        Assert.assertSame((String)"Wrong thread 1", (Object)t1, (Object)factory.newThread(r1));
        Assert.assertTrue((String)"No daemon thread", (boolean)t1.isDaemon());
        Assert.assertSame((String)"Wrong thread 2", (Object)t2, (Object)factory.newThread(r2));
        Assert.assertFalse((String)"A daemon thread", (boolean)t2.isDaemon());
        EasyMock.verify((Object[])new Object[]{wrapped, r1, r2});
    }

    @Test
    public void testNewThreadPriority() {
        ThreadFactory wrapped = (ThreadFactory)EasyMock.createMock(ThreadFactory.class);
        Runnable r = (Runnable)EasyMock.createMock(Runnable.class);
        Thread t = new Thread();
        EasyMock.expect((Object)wrapped.newThread(r)).andReturn((Object)t);
        EasyMock.replay((Object[])new Object[]{wrapped, r});
        int priority = 6;
        BasicThreadFactory factory = this.builder.wrappedFactory(wrapped).priority(6).build();
        Assert.assertSame((String)"Wrong thread", (Object)t, (Object)factory.newThread(r));
        Assert.assertEquals((String)"Wrong priority", (long)6L, (long)t.getPriority());
        EasyMock.verify((Object[])new Object[]{wrapped, r});
    }

    @Test
    public void testNewThreadNoPriority() {
        ThreadFactory wrapped = (ThreadFactory)EasyMock.createMock(ThreadFactory.class);
        Runnable r = (Runnable)EasyMock.createMock(Runnable.class);
        int orgPriority = 6;
        Thread t = new Thread();
        t.setPriority(6);
        EasyMock.expect((Object)wrapped.newThread(r)).andReturn((Object)t);
        EasyMock.replay((Object[])new Object[]{wrapped, r});
        BasicThreadFactory factory = this.builder.wrappedFactory(wrapped).build();
        Assert.assertSame((String)"Wrong thread", (Object)t, (Object)factory.newThread(r));
        Assert.assertEquals((String)"Wrong priority", (long)6L, (long)t.getPriority());
        EasyMock.verify((Object[])new Object[]{wrapped, r});
    }

    @Test
    public void testNewThreadExHandler() {
        ThreadFactory wrapped = (ThreadFactory)EasyMock.createMock(ThreadFactory.class);
        Runnable r = (Runnable)EasyMock.createMock(Runnable.class);
        Thread.UncaughtExceptionHandler handler = (Thread.UncaughtExceptionHandler)EasyMock.createMock(Thread.UncaughtExceptionHandler.class);
        Thread t = new Thread();
        EasyMock.expect((Object)wrapped.newThread(r)).andReturn((Object)t);
        EasyMock.replay((Object[])new Object[]{wrapped, r, handler});
        BasicThreadFactory factory = this.builder.wrappedFactory(wrapped).uncaughtExceptionHandler(handler).build();
        Assert.assertSame((String)"Wrong thread", (Object)t, (Object)factory.newThread(r));
        Assert.assertEquals((String)"Wrong exception handler", (Object)handler, (Object)t.getUncaughtExceptionHandler());
        EasyMock.verify((Object[])new Object[]{wrapped, r, handler});
    }

    @Test
    public void testNewThreadNoExHandler() {
        ThreadFactory wrapped = (ThreadFactory)EasyMock.createMock(ThreadFactory.class);
        Runnable r = (Runnable)EasyMock.createMock(Runnable.class);
        Thread.UncaughtExceptionHandler handler = (Thread.UncaughtExceptionHandler)EasyMock.createMock(Thread.UncaughtExceptionHandler.class);
        Thread t = new Thread();
        t.setUncaughtExceptionHandler(handler);
        EasyMock.expect((Object)wrapped.newThread(r)).andReturn((Object)t);
        EasyMock.replay((Object[])new Object[]{wrapped, r, handler});
        BasicThreadFactory factory = this.builder.wrappedFactory(wrapped).build();
        Assert.assertSame((String)"Wrong thread", (Object)t, (Object)factory.newThread(r));
        Assert.assertEquals((String)"Wrong exception handler", (Object)handler, (Object)t.getUncaughtExceptionHandler());
        EasyMock.verify((Object[])new Object[]{wrapped, r, handler});
    }
}

