/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.math;

import org.apache.commons.lang3.math.Fraction;
import org.junit.Assert;
import org.junit.Test;

public class FractionTest {
    private static final int SKIP = 500;

    @Test
    public void testConstants() {
        Assert.assertEquals((long)0L, (long)Fraction.ZERO.getNumerator());
        Assert.assertEquals((long)1L, (long)Fraction.ZERO.getDenominator());
        Assert.assertEquals((long)1L, (long)Fraction.ONE.getNumerator());
        Assert.assertEquals((long)1L, (long)Fraction.ONE.getDenominator());
        Assert.assertEquals((long)1L, (long)Fraction.ONE_HALF.getNumerator());
        Assert.assertEquals((long)2L, (long)Fraction.ONE_HALF.getDenominator());
        Assert.assertEquals((long)1L, (long)Fraction.ONE_THIRD.getNumerator());
        Assert.assertEquals((long)3L, (long)Fraction.ONE_THIRD.getDenominator());
        Assert.assertEquals((long)2L, (long)Fraction.TWO_THIRDS.getNumerator());
        Assert.assertEquals((long)3L, (long)Fraction.TWO_THIRDS.getDenominator());
        Assert.assertEquals((long)1L, (long)Fraction.ONE_QUARTER.getNumerator());
        Assert.assertEquals((long)4L, (long)Fraction.ONE_QUARTER.getDenominator());
        Assert.assertEquals((long)2L, (long)Fraction.TWO_QUARTERS.getNumerator());
        Assert.assertEquals((long)4L, (long)Fraction.TWO_QUARTERS.getDenominator());
        Assert.assertEquals((long)3L, (long)Fraction.THREE_QUARTERS.getNumerator());
        Assert.assertEquals((long)4L, (long)Fraction.THREE_QUARTERS.getDenominator());
        Assert.assertEquals((long)1L, (long)Fraction.ONE_FIFTH.getNumerator());
        Assert.assertEquals((long)5L, (long)Fraction.ONE_FIFTH.getDenominator());
        Assert.assertEquals((long)2L, (long)Fraction.TWO_FIFTHS.getNumerator());
        Assert.assertEquals((long)5L, (long)Fraction.TWO_FIFTHS.getDenominator());
        Assert.assertEquals((long)3L, (long)Fraction.THREE_FIFTHS.getNumerator());
        Assert.assertEquals((long)5L, (long)Fraction.THREE_FIFTHS.getDenominator());
        Assert.assertEquals((long)4L, (long)Fraction.FOUR_FIFTHS.getNumerator());
        Assert.assertEquals((long)5L, (long)Fraction.FOUR_FIFTHS.getDenominator());
    }

    @Test
    public void testFactory_int_int() {
        Fraction f = null;
        f = Fraction.getFraction((int)0, (int)1);
        Assert.assertEquals((long)0L, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        f = Fraction.getFraction((int)0, (int)2);
        Assert.assertEquals((long)0L, (long)f.getNumerator());
        Assert.assertEquals((long)2L, (long)f.getDenominator());
        f = Fraction.getFraction((int)1, (int)1);
        Assert.assertEquals((long)1L, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        f = Fraction.getFraction((int)2, (int)1);
        Assert.assertEquals((long)2L, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        f = Fraction.getFraction((int)23, (int)345);
        Assert.assertEquals((long)23L, (long)f.getNumerator());
        Assert.assertEquals((long)345L, (long)f.getDenominator());
        f = Fraction.getFraction((int)22, (int)7);
        Assert.assertEquals((long)22L, (long)f.getNumerator());
        Assert.assertEquals((long)7L, (long)f.getDenominator());
        f = Fraction.getFraction((int)-6, (int)10);
        Assert.assertEquals((long)-6L, (long)f.getNumerator());
        Assert.assertEquals((long)10L, (long)f.getDenominator());
        f = Fraction.getFraction((int)6, (int)-10);
        Assert.assertEquals((long)-6L, (long)f.getNumerator());
        Assert.assertEquals((long)10L, (long)f.getDenominator());
        f = Fraction.getFraction((int)-6, (int)-10);
        Assert.assertEquals((long)6L, (long)f.getNumerator());
        Assert.assertEquals((long)10L, (long)f.getDenominator());
        try {
            f = Fraction.getFraction((int)1, (int)0);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)2, (int)0);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)-3, (int)0);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)4, (int)Integer.MIN_VALUE);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)1, (int)Integer.MIN_VALUE);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testFactory_int_int_int() {
        Fraction f = null;
        f = Fraction.getFraction((int)0, (int)0, (int)2);
        Assert.assertEquals((long)0L, (long)f.getNumerator());
        Assert.assertEquals((long)2L, (long)f.getDenominator());
        f = Fraction.getFraction((int)2, (int)0, (int)2);
        Assert.assertEquals((long)4L, (long)f.getNumerator());
        Assert.assertEquals((long)2L, (long)f.getDenominator());
        f = Fraction.getFraction((int)0, (int)1, (int)2);
        Assert.assertEquals((long)1L, (long)f.getNumerator());
        Assert.assertEquals((long)2L, (long)f.getDenominator());
        f = Fraction.getFraction((int)1, (int)1, (int)2);
        Assert.assertEquals((long)3L, (long)f.getNumerator());
        Assert.assertEquals((long)2L, (long)f.getDenominator());
        try {
            f = Fraction.getFraction((int)1, (int)-6, (int)-10);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)1, (int)-6, (int)-10);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)1, (int)-6, (int)-10);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        f = Fraction.getFraction((int)-1, (int)6, (int)10);
        Assert.assertEquals((long)-16L, (long)f.getNumerator());
        Assert.assertEquals((long)10L, (long)f.getDenominator());
        try {
            f = Fraction.getFraction((int)-1, (int)-6, (int)10);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)-1, (int)6, (int)-10);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)-1, (int)-6, (int)-10);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)0, (int)1, (int)0);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)1, (int)2, (int)0);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)-1, (int)-3, (int)0);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)Integer.MAX_VALUE, (int)1, (int)2);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)-2147483647, (int)1, (int)2);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        f = Fraction.getFraction((int)-1, (int)0, (int)Integer.MAX_VALUE);
        Assert.assertEquals((long)-2147483647L, (long)f.getNumerator());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)f.getDenominator());
        try {
            f = Fraction.getFraction((int)0, (int)4, (int)Integer.MIN_VALUE);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)1, (int)1, (int)Integer.MAX_VALUE);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)-1, (int)2, (int)Integer.MAX_VALUE);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testReducedFactory_int_int() {
        Fraction f = null;
        f = Fraction.getReducedFraction((int)0, (int)1);
        Assert.assertEquals((long)0L, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        f = Fraction.getReducedFraction((int)1, (int)1);
        Assert.assertEquals((long)1L, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        f = Fraction.getReducedFraction((int)2, (int)1);
        Assert.assertEquals((long)2L, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        f = Fraction.getReducedFraction((int)22, (int)7);
        Assert.assertEquals((long)22L, (long)f.getNumerator());
        Assert.assertEquals((long)7L, (long)f.getDenominator());
        f = Fraction.getReducedFraction((int)-6, (int)10);
        Assert.assertEquals((long)-3L, (long)f.getNumerator());
        Assert.assertEquals((long)5L, (long)f.getDenominator());
        f = Fraction.getReducedFraction((int)6, (int)-10);
        Assert.assertEquals((long)-3L, (long)f.getNumerator());
        Assert.assertEquals((long)5L, (long)f.getDenominator());
        f = Fraction.getReducedFraction((int)-6, (int)-10);
        Assert.assertEquals((long)3L, (long)f.getNumerator());
        Assert.assertEquals((long)5L, (long)f.getDenominator());
        try {
            f = Fraction.getReducedFraction((int)1, (int)0);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getReducedFraction((int)2, (int)0);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getReducedFraction((int)-3, (int)0);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        f = Fraction.getReducedFraction((int)0, (int)2);
        Assert.assertEquals((long)0L, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        f = Fraction.getReducedFraction((int)2, (int)2);
        Assert.assertEquals((long)1L, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        f = Fraction.getReducedFraction((int)2, (int)4);
        Assert.assertEquals((long)1L, (long)f.getNumerator());
        Assert.assertEquals((long)2L, (long)f.getDenominator());
        f = Fraction.getReducedFraction((int)15, (int)10);
        Assert.assertEquals((long)3L, (long)f.getNumerator());
        Assert.assertEquals((long)2L, (long)f.getDenominator());
        f = Fraction.getReducedFraction((int)121, (int)22);
        Assert.assertEquals((long)11L, (long)f.getNumerator());
        Assert.assertEquals((long)2L, (long)f.getDenominator());
        f = Fraction.getReducedFraction((int)-2, (int)Integer.MIN_VALUE);
        Assert.assertEquals((long)1L, (long)f.getNumerator());
        Assert.assertEquals((long)0x40000000L, (long)f.getDenominator());
        try {
            f = Fraction.getReducedFraction((int)-7, (int)Integer.MIN_VALUE);
            Assert.fail((String)"Expecting ArithmeticException");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        f = Fraction.getReducedFraction((int)Integer.MIN_VALUE, (int)2);
        Assert.assertEquals((long)-1073741824L, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
    }

    @Test
    public void testFactory_double() {
        int j;
        int i;
        Fraction f = null;
        try {
            f = Fraction.getFraction((double)Double.NaN);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((double)Double.POSITIVE_INFINITY);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((double)Double.NEGATIVE_INFINITY);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((double)2.147483648E9);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        f = Fraction.getFraction((double)0.0);
        Assert.assertEquals((long)0L, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        f = Fraction.getFraction((double)1.0);
        Assert.assertEquals((long)1L, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        f = Fraction.getFraction((double)0.5);
        Assert.assertEquals((long)1L, (long)f.getNumerator());
        Assert.assertEquals((long)2L, (long)f.getDenominator());
        f = Fraction.getFraction((double)-0.875);
        Assert.assertEquals((long)-7L, (long)f.getNumerator());
        Assert.assertEquals((long)8L, (long)f.getDenominator());
        f = Fraction.getFraction((double)1.25);
        Assert.assertEquals((long)5L, (long)f.getNumerator());
        Assert.assertEquals((long)4L, (long)f.getDenominator());
        f = Fraction.getFraction((double)0.66666);
        Assert.assertEquals((long)2L, (long)f.getNumerator());
        Assert.assertEquals((long)3L, (long)f.getDenominator());
        f = Fraction.getFraction((double)9.999000099990002E-5);
        Assert.assertEquals((long)0L, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        Fraction f2 = null;
        for (i = 1; i <= 100; ++i) {
            for (j = 1; j <= i; ++j) {
                try {
                    f = Fraction.getFraction((double)((double)j / (double)i));
                }
                catch (ArithmeticException ex) {
                    System.err.println(j + " " + i);
                    throw ex;
                }
                f2 = Fraction.getReducedFraction((int)j, (int)i);
                Assert.assertEquals((long)f2.getNumerator(), (long)f.getNumerator());
                Assert.assertEquals((long)f2.getDenominator(), (long)f.getDenominator());
            }
        }
        for (i = 1001; i <= 10000; i += 500) {
            for (j = 1; j <= i; ++j) {
                try {
                    f = Fraction.getFraction((double)((double)j / (double)i));
                }
                catch (ArithmeticException ex) {
                    System.err.println(j + " " + i);
                    throw ex;
                }
                f2 = Fraction.getReducedFraction((int)j, (int)i);
                Assert.assertEquals((long)f2.getNumerator(), (long)f.getNumerator());
                Assert.assertEquals((long)f2.getDenominator(), (long)f.getDenominator());
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFactory_String() {
        Fraction.getFraction(null);
    }

    @Test
    public void testFactory_String_double() {
        Fraction f = null;
        f = Fraction.getFraction((String)"0.0");
        Assert.assertEquals((long)0L, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        f = Fraction.getFraction((String)"0.2");
        Assert.assertEquals((long)1L, (long)f.getNumerator());
        Assert.assertEquals((long)5L, (long)f.getDenominator());
        f = Fraction.getFraction((String)"0.5");
        Assert.assertEquals((long)1L, (long)f.getNumerator());
        Assert.assertEquals((long)2L, (long)f.getDenominator());
        f = Fraction.getFraction((String)"0.66666");
        Assert.assertEquals((long)2L, (long)f.getNumerator());
        Assert.assertEquals((long)3L, (long)f.getDenominator());
        try {
            f = Fraction.getFraction((String)"2.3R");
            Assert.fail((String)"Expecting NumberFormatException");
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((String)"2147483648");
            Assert.fail((String)"Expecting NumberFormatException");
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((String)".");
            Assert.fail((String)"Expecting NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testFactory_String_proper() {
        Fraction f = null;
        f = Fraction.getFraction((String)"0 0/1");
        Assert.assertEquals((long)0L, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        f = Fraction.getFraction((String)"1 1/5");
        Assert.assertEquals((long)6L, (long)f.getNumerator());
        Assert.assertEquals((long)5L, (long)f.getDenominator());
        f = Fraction.getFraction((String)"7 1/2");
        Assert.assertEquals((long)15L, (long)f.getNumerator());
        Assert.assertEquals((long)2L, (long)f.getDenominator());
        f = Fraction.getFraction((String)"1 2/4");
        Assert.assertEquals((long)6L, (long)f.getNumerator());
        Assert.assertEquals((long)4L, (long)f.getDenominator());
        f = Fraction.getFraction((String)"-7 1/2");
        Assert.assertEquals((long)-15L, (long)f.getNumerator());
        Assert.assertEquals((long)2L, (long)f.getDenominator());
        f = Fraction.getFraction((String)"-1 2/4");
        Assert.assertEquals((long)-6L, (long)f.getNumerator());
        Assert.assertEquals((long)4L, (long)f.getDenominator());
        try {
            f = Fraction.getFraction((String)"2 3");
            Assert.fail((String)"expecting NumberFormatException");
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((String)"a 3");
            Assert.fail((String)"expecting NumberFormatException");
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((String)"2 b/4");
            Assert.fail((String)"expecting NumberFormatException");
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((String)"2 ");
            Assert.fail((String)"expecting NumberFormatException");
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((String)" 3");
            Assert.fail((String)"expecting NumberFormatException");
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((String)" ");
            Assert.fail((String)"expecting NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testFactory_String_improper() {
        Fraction f = null;
        f = Fraction.getFraction((String)"0/1");
        Assert.assertEquals((long)0L, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        f = Fraction.getFraction((String)"1/5");
        Assert.assertEquals((long)1L, (long)f.getNumerator());
        Assert.assertEquals((long)5L, (long)f.getDenominator());
        f = Fraction.getFraction((String)"1/2");
        Assert.assertEquals((long)1L, (long)f.getNumerator());
        Assert.assertEquals((long)2L, (long)f.getDenominator());
        f = Fraction.getFraction((String)"2/3");
        Assert.assertEquals((long)2L, (long)f.getNumerator());
        Assert.assertEquals((long)3L, (long)f.getDenominator());
        f = Fraction.getFraction((String)"7/3");
        Assert.assertEquals((long)7L, (long)f.getNumerator());
        Assert.assertEquals((long)3L, (long)f.getDenominator());
        f = Fraction.getFraction((String)"2/4");
        Assert.assertEquals((long)2L, (long)f.getNumerator());
        Assert.assertEquals((long)4L, (long)f.getDenominator());
        try {
            f = Fraction.getFraction((String)"2/d");
            Assert.fail((String)"expecting NumberFormatException");
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((String)"2e/3");
            Assert.fail((String)"expecting NumberFormatException");
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((String)"2/");
            Assert.fail((String)"expecting NumberFormatException");
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((String)"/");
            Assert.fail((String)"expecting NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testGets() {
        Fraction f = null;
        f = Fraction.getFraction((int)3, (int)5, (int)6);
        Assert.assertEquals((long)23L, (long)f.getNumerator());
        Assert.assertEquals((long)3L, (long)f.getProperWhole());
        Assert.assertEquals((long)5L, (long)f.getProperNumerator());
        Assert.assertEquals((long)6L, (long)f.getDenominator());
        f = Fraction.getFraction((int)-3, (int)5, (int)6);
        Assert.assertEquals((long)-23L, (long)f.getNumerator());
        Assert.assertEquals((long)-3L, (long)f.getProperWhole());
        Assert.assertEquals((long)5L, (long)f.getProperNumerator());
        Assert.assertEquals((long)6L, (long)f.getDenominator());
        f = Fraction.getFraction((int)Integer.MIN_VALUE, (int)0, (int)1);
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)f.getNumerator());
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)f.getProperWhole());
        Assert.assertEquals((long)0L, (long)f.getProperNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
    }

    @Test
    public void testConversions() {
        Fraction f = null;
        f = Fraction.getFraction((int)3, (int)7, (int)8);
        Assert.assertEquals((long)3L, (long)f.intValue());
        Assert.assertEquals((long)3L, (long)f.longValue());
        Assert.assertEquals((float)3.875f, (float)f.floatValue(), (float)1.0E-5f);
        Assert.assertEquals((double)3.875, (double)f.doubleValue(), (double)1.0E-5);
    }

    @Test
    public void testReduce() {
        Fraction f = null;
        f = Fraction.getFraction((int)50, (int)75);
        Fraction result = f.reduce();
        Assert.assertEquals((long)2L, (long)result.getNumerator());
        Assert.assertEquals((long)3L, (long)result.getDenominator());
        f = Fraction.getFraction((int)-2, (int)-3);
        result = f.reduce();
        Assert.assertEquals((long)2L, (long)result.getNumerator());
        Assert.assertEquals((long)3L, (long)result.getDenominator());
        f = Fraction.getFraction((int)2, (int)-3);
        result = f.reduce();
        Assert.assertEquals((long)-2L, (long)result.getNumerator());
        Assert.assertEquals((long)3L, (long)result.getDenominator());
        f = Fraction.getFraction((int)-2, (int)3);
        result = f.reduce();
        Assert.assertEquals((long)-2L, (long)result.getNumerator());
        Assert.assertEquals((long)3L, (long)result.getDenominator());
        Assert.assertSame((Object)f, (Object)result);
        f = Fraction.getFraction((int)2, (int)3);
        result = f.reduce();
        Assert.assertEquals((long)2L, (long)result.getNumerator());
        Assert.assertEquals((long)3L, (long)result.getDenominator());
        Assert.assertSame((Object)f, (Object)result);
        f = Fraction.getFraction((int)0, (int)1);
        result = f.reduce();
        Assert.assertEquals((long)0L, (long)result.getNumerator());
        Assert.assertEquals((long)1L, (long)result.getDenominator());
        Assert.assertSame((Object)f, (Object)result);
        f = Fraction.getFraction((int)0, (int)100);
        result = f.reduce();
        Assert.assertEquals((long)0L, (long)result.getNumerator());
        Assert.assertEquals((long)1L, (long)result.getDenominator());
        Assert.assertSame((Object)result, (Object)Fraction.ZERO);
        f = Fraction.getFraction((int)Integer.MIN_VALUE, (int)2);
        result = f.reduce();
        Assert.assertEquals((long)-1073741824L, (long)result.getNumerator());
        Assert.assertEquals((long)1L, (long)result.getDenominator());
    }

    @Test
    public void testInvert() {
        Fraction f = null;
        f = Fraction.getFraction((int)50, (int)75);
        f = f.invert();
        Assert.assertEquals((long)75L, (long)f.getNumerator());
        Assert.assertEquals((long)50L, (long)f.getDenominator());
        f = Fraction.getFraction((int)4, (int)3);
        f = f.invert();
        Assert.assertEquals((long)3L, (long)f.getNumerator());
        Assert.assertEquals((long)4L, (long)f.getDenominator());
        f = Fraction.getFraction((int)-15, (int)47);
        f = f.invert();
        Assert.assertEquals((long)-47L, (long)f.getNumerator());
        Assert.assertEquals((long)15L, (long)f.getDenominator());
        f = Fraction.getFraction((int)0, (int)3);
        try {
            f = f.invert();
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        f = Fraction.getFraction((int)Integer.MIN_VALUE, (int)1);
        try {
            f = f.invert();
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        f = Fraction.getFraction((int)Integer.MAX_VALUE, (int)1);
        f = f.invert();
        Assert.assertEquals((long)1L, (long)f.getNumerator());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)f.getDenominator());
    }

    @Test
    public void testNegate() {
        Fraction f = null;
        f = Fraction.getFraction((int)50, (int)75);
        f = f.negate();
        Assert.assertEquals((long)-50L, (long)f.getNumerator());
        Assert.assertEquals((long)75L, (long)f.getDenominator());
        f = Fraction.getFraction((int)-50, (int)75);
        f = f.negate();
        Assert.assertEquals((long)50L, (long)f.getNumerator());
        Assert.assertEquals((long)75L, (long)f.getDenominator());
        f = Fraction.getFraction((int)0x7FFFFFFE, (int)Integer.MAX_VALUE);
        f = f.negate();
        Assert.assertEquals((long)-2147483646L, (long)f.getNumerator());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)f.getDenominator());
        f = Fraction.getFraction((int)Integer.MIN_VALUE, (int)1);
        try {
            f = f.negate();
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testAbs() {
        Fraction f = null;
        f = Fraction.getFraction((int)50, (int)75);
        f = f.abs();
        Assert.assertEquals((long)50L, (long)f.getNumerator());
        Assert.assertEquals((long)75L, (long)f.getDenominator());
        f = Fraction.getFraction((int)-50, (int)75);
        f = f.abs();
        Assert.assertEquals((long)50L, (long)f.getNumerator());
        Assert.assertEquals((long)75L, (long)f.getDenominator());
        f = Fraction.getFraction((int)Integer.MAX_VALUE, (int)1);
        f = f.abs();
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        f = Fraction.getFraction((int)Integer.MAX_VALUE, (int)-1);
        f = f.abs();
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        f = Fraction.getFraction((int)Integer.MIN_VALUE, (int)1);
        try {
            f = f.abs();
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testPow() {
        Fraction f = null;
        f = Fraction.getFraction((int)3, (int)5);
        Assert.assertEquals((Object)Fraction.ONE, (Object)f.pow(0));
        f = Fraction.getFraction((int)3, (int)5);
        Assert.assertSame((Object)f, (Object)f.pow(1));
        Assert.assertEquals((Object)f, (Object)f.pow(1));
        f = Fraction.getFraction((int)3, (int)5);
        f = f.pow(2);
        Assert.assertEquals((long)9L, (long)f.getNumerator());
        Assert.assertEquals((long)25L, (long)f.getDenominator());
        f = Fraction.getFraction((int)3, (int)5);
        f = f.pow(3);
        Assert.assertEquals((long)27L, (long)f.getNumerator());
        Assert.assertEquals((long)125L, (long)f.getDenominator());
        f = Fraction.getFraction((int)3, (int)5);
        f = f.pow(-1);
        Assert.assertEquals((long)5L, (long)f.getNumerator());
        Assert.assertEquals((long)3L, (long)f.getDenominator());
        f = Fraction.getFraction((int)3, (int)5);
        f = f.pow(-2);
        Assert.assertEquals((long)25L, (long)f.getNumerator());
        Assert.assertEquals((long)9L, (long)f.getDenominator());
        f = Fraction.getFraction((int)6, (int)10);
        Assert.assertEquals((Object)Fraction.ONE, (Object)f.pow(0));
        f = Fraction.getFraction((int)6, (int)10);
        Assert.assertEquals((Object)f, (Object)f.pow(1));
        Assert.assertFalse((boolean)f.pow(1).equals((Object)Fraction.getFraction((int)3, (int)5)));
        f = Fraction.getFraction((int)6, (int)10);
        f = f.pow(2);
        Assert.assertEquals((long)9L, (long)f.getNumerator());
        Assert.assertEquals((long)25L, (long)f.getDenominator());
        f = Fraction.getFraction((int)6, (int)10);
        f = f.pow(3);
        Assert.assertEquals((long)27L, (long)f.getNumerator());
        Assert.assertEquals((long)125L, (long)f.getDenominator());
        f = Fraction.getFraction((int)6, (int)10);
        f = f.pow(-1);
        Assert.assertEquals((long)10L, (long)f.getNumerator());
        Assert.assertEquals((long)6L, (long)f.getDenominator());
        f = Fraction.getFraction((int)6, (int)10);
        f = f.pow(-2);
        Assert.assertEquals((long)25L, (long)f.getNumerator());
        Assert.assertEquals((long)9L, (long)f.getDenominator());
        f = Fraction.getFraction((int)0, (int)1231);
        f = f.pow(1);
        Assert.assertTrue((0 == f.compareTo(Fraction.ZERO) ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)f.getNumerator());
        Assert.assertEquals((long)1231L, (long)f.getDenominator());
        f = f.pow(2);
        Assert.assertTrue((0 == f.compareTo(Fraction.ZERO) ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        try {
            f = f.pow(-1);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = f.pow(Integer.MIN_VALUE);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        f = Fraction.getFraction((int)1, (int)1);
        f = f.pow(0);
        Assert.assertEquals((Object)f, (Object)Fraction.ONE);
        f = f.pow(1);
        Assert.assertEquals((Object)f, (Object)Fraction.ONE);
        f = f.pow(-1);
        Assert.assertEquals((Object)f, (Object)Fraction.ONE);
        f = f.pow(Integer.MAX_VALUE);
        Assert.assertEquals((Object)f, (Object)Fraction.ONE);
        f = f.pow(Integer.MIN_VALUE);
        Assert.assertEquals((Object)f, (Object)Fraction.ONE);
        f = Fraction.getFraction((int)Integer.MAX_VALUE, (int)1);
        try {
            f = f.pow(2);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        f = Fraction.getFraction((int)Integer.MIN_VALUE, (int)1);
        try {
            f = f.pow(3);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        f = Fraction.getFraction((int)65536, (int)1);
        try {
            f = f.pow(2);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testAdd() {
        Fraction f = null;
        Fraction f1 = null;
        Fraction f2 = null;
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)1, (int)5);
        f = f1.add(f2);
        Assert.assertEquals((long)4L, (long)f.getNumerator());
        Assert.assertEquals((long)5L, (long)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)2, (int)5);
        f = f1.add(f2);
        Assert.assertEquals((long)1L, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)3, (int)5);
        f = f1.add(f2);
        Assert.assertEquals((long)6L, (long)f.getNumerator());
        Assert.assertEquals((long)5L, (long)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)-4, (int)5);
        f = f1.add(f2);
        Assert.assertEquals((long)-1L, (long)f.getNumerator());
        Assert.assertEquals((long)5L, (long)f.getDenominator());
        f1 = Fraction.getFraction((int)0x7FFFFFFE, (int)1);
        f2 = Fraction.ONE;
        f = f1.add(f2);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)1, (int)2);
        f = f1.add(f2);
        Assert.assertEquals((long)11L, (long)f.getNumerator());
        Assert.assertEquals((long)10L, (long)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)8);
        f2 = Fraction.getFraction((int)1, (int)6);
        f = f1.add(f2);
        Assert.assertEquals((long)13L, (long)f.getNumerator());
        Assert.assertEquals((long)24L, (long)f.getDenominator());
        f1 = Fraction.getFraction((int)0, (int)5);
        f2 = Fraction.getFraction((int)1, (int)5);
        f = f1.add(f2);
        Assert.assertSame((Object)f2, (Object)f);
        f = f2.add(f1);
        Assert.assertSame((Object)f2, (Object)f);
        f1 = Fraction.getFraction((int)-1, (int)676);
        f2 = Fraction.getFraction((int)-2, (int)442);
        f = f1.add(f2);
        Assert.assertEquals((long)11492L, (long)f.getDenominator());
        Assert.assertEquals((long)-69L, (long)f.getNumerator());
        try {
            f.add(null);
            Assert.fail((String)"expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        f1 = Fraction.getFraction((int)1, (int)98304);
        f2 = Fraction.getFraction((int)1, (int)59049);
        f = f1.add(f2);
        Assert.assertEquals((long)52451L, (long)f.getNumerator());
        Assert.assertEquals((long)1934917632L, (long)f.getDenominator());
        f1 = Fraction.getFraction((int)Integer.MIN_VALUE, (int)3);
        f2 = Fraction.ONE_THIRD;
        f = f1.add(f2);
        Assert.assertEquals((long)-2147483647L, (long)f.getNumerator());
        Assert.assertEquals((long)3L, (long)f.getDenominator());
        f1 = Fraction.getFraction((int)0x7FFFFFFE, (int)1);
        f2 = Fraction.ONE;
        f = f1.add(f2);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        try {
            f = f.add(Fraction.ONE);
            Assert.fail((String)("expecting ArithmeticException but got: " + f.toString()));
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        f1 = Fraction.getFraction((int)Integer.MIN_VALUE, (int)5);
        f2 = Fraction.getFraction((int)-1, (int)5);
        try {
            f = f1.add(f2);
            Assert.fail((String)("expecting ArithmeticException but got: " + f.toString()));
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)-2147483647, (int)1);
            f = f.add(f);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)-2147483647, (int)1);
            f = f.add(f);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        f1 = Fraction.getFraction((int)3, (int)327680);
        f2 = Fraction.getFraction((int)2, (int)59049);
        try {
            f = f1.add(f2);
            Assert.fail((String)("expecting ArithmeticException but got: " + f.toString()));
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
    }

    @Test
    public void testSubtract() {
        Fraction f = null;
        Fraction f1 = null;
        Fraction f2 = null;
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)1, (int)5);
        f = f1.subtract(f2);
        Assert.assertEquals((long)2L, (long)f.getNumerator());
        Assert.assertEquals((long)5L, (long)f.getDenominator());
        f1 = Fraction.getFraction((int)7, (int)5);
        f2 = Fraction.getFraction((int)2, (int)5);
        f = f1.subtract(f2);
        Assert.assertEquals((long)1L, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)3, (int)5);
        f = f1.subtract(f2);
        Assert.assertEquals((long)0L, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)-4, (int)5);
        f = f1.subtract(f2);
        Assert.assertEquals((long)7L, (long)f.getNumerator());
        Assert.assertEquals((long)5L, (long)f.getDenominator());
        f1 = Fraction.getFraction((int)0, (int)5);
        f2 = Fraction.getFraction((int)4, (int)5);
        f = f1.subtract(f2);
        Assert.assertEquals((long)-4L, (long)f.getNumerator());
        Assert.assertEquals((long)5L, (long)f.getDenominator());
        f1 = Fraction.getFraction((int)0, (int)5);
        f2 = Fraction.getFraction((int)-4, (int)5);
        f = f1.subtract(f2);
        Assert.assertEquals((long)4L, (long)f.getNumerator());
        Assert.assertEquals((long)5L, (long)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)1, (int)2);
        f = f1.subtract(f2);
        Assert.assertEquals((long)1L, (long)f.getNumerator());
        Assert.assertEquals((long)10L, (long)f.getDenominator());
        f1 = Fraction.getFraction((int)0, (int)5);
        f2 = Fraction.getFraction((int)1, (int)5);
        f = f2.subtract(f1);
        Assert.assertSame((Object)f2, (Object)f);
        try {
            f.subtract(null);
            Assert.fail((String)"expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        f1 = Fraction.getFraction((int)1, (int)98304);
        f2 = Fraction.getFraction((int)1, (int)59049);
        f = f1.subtract(f2);
        Assert.assertEquals((long)-13085L, (long)f.getNumerator());
        Assert.assertEquals((long)1934917632L, (long)f.getDenominator());
        f1 = Fraction.getFraction((int)Integer.MIN_VALUE, (int)3);
        f2 = Fraction.ONE_THIRD.negate();
        f = f1.subtract(f2);
        Assert.assertEquals((long)-2147483647L, (long)f.getNumerator());
        Assert.assertEquals((long)3L, (long)f.getDenominator());
        f1 = Fraction.getFraction((int)Integer.MAX_VALUE, (int)1);
        f2 = Fraction.ONE;
        f = f1.subtract(f2);
        Assert.assertEquals((long)0x7FFFFFFEL, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        try {
            f1 = Fraction.getFraction((int)1, (int)Integer.MAX_VALUE);
            f2 = Fraction.getFraction((int)1, (int)0x7FFFFFFE);
            f = f1.subtract(f2);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        f1 = Fraction.getFraction((int)Integer.MIN_VALUE, (int)5);
        f2 = Fraction.getFraction((int)1, (int)5);
        try {
            f = f1.subtract(f2);
            Assert.fail((String)("expecting ArithmeticException but got: " + f.toString()));
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)Integer.MIN_VALUE, (int)1);
            f = f.subtract(Fraction.ONE);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)Integer.MAX_VALUE, (int)1);
            f = f.subtract(Fraction.ONE.negate());
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        f1 = Fraction.getFraction((int)3, (int)327680);
        f2 = Fraction.getFraction((int)2, (int)59049);
        try {
            f = f1.subtract(f2);
            Assert.fail((String)("expecting ArithmeticException but got: " + f.toString()));
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
    }

    @Test
    public void testMultiply() {
        Fraction f = null;
        Fraction f1 = null;
        Fraction f2 = null;
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)2, (int)5);
        f = f1.multiplyBy(f2);
        Assert.assertEquals((long)6L, (long)f.getNumerator());
        Assert.assertEquals((long)25L, (long)f.getDenominator());
        f1 = Fraction.getFraction((int)6, (int)10);
        f2 = Fraction.getFraction((int)6, (int)10);
        f = f1.multiplyBy(f2);
        Assert.assertEquals((long)9L, (long)f.getNumerator());
        Assert.assertEquals((long)25L, (long)f.getDenominator());
        f = f.multiplyBy(f2);
        Assert.assertEquals((long)27L, (long)f.getNumerator());
        Assert.assertEquals((long)125L, (long)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)-2, (int)5);
        f = f1.multiplyBy(f2);
        Assert.assertEquals((long)-6L, (long)f.getNumerator());
        Assert.assertEquals((long)25L, (long)f.getDenominator());
        f1 = Fraction.getFraction((int)-3, (int)5);
        f2 = Fraction.getFraction((int)-2, (int)5);
        f = f1.multiplyBy(f2);
        Assert.assertEquals((long)6L, (long)f.getNumerator());
        Assert.assertEquals((long)25L, (long)f.getDenominator());
        f1 = Fraction.getFraction((int)0, (int)5);
        f2 = Fraction.getFraction((int)2, (int)7);
        f = f1.multiplyBy(f2);
        Assert.assertSame((Object)Fraction.ZERO, (Object)f);
        f1 = Fraction.getFraction((int)2, (int)7);
        f2 = Fraction.ONE;
        f = f1.multiplyBy(f2);
        Assert.assertEquals((long)2L, (long)f.getNumerator());
        Assert.assertEquals((long)7L, (long)f.getDenominator());
        f1 = Fraction.getFraction((int)Integer.MAX_VALUE, (int)1);
        f2 = Fraction.getFraction((int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE);
        f = f1.multiplyBy(f2);
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        try {
            f.multiplyBy(null);
            Assert.fail((String)"expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            f1 = Fraction.getFraction((int)1, (int)Integer.MAX_VALUE);
            f = f1.multiplyBy(f1);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f1 = Fraction.getFraction((int)1, (int)-2147483647);
            f = f1.multiplyBy(f1);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
    }

    @Test
    public void testDivide() {
        Fraction f = null;
        Fraction f1 = null;
        Fraction f2 = null;
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)2, (int)5);
        f = f1.divideBy(f2);
        Assert.assertEquals((long)3L, (long)f.getNumerator());
        Assert.assertEquals((long)2L, (long)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.ZERO;
        try {
            f = f1.divideBy(f2);
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        f1 = Fraction.getFraction((int)0, (int)5);
        f2 = Fraction.getFraction((int)2, (int)7);
        f = f1.divideBy(f2);
        Assert.assertSame((Object)Fraction.ZERO, (Object)f);
        f1 = Fraction.getFraction((int)2, (int)7);
        f2 = Fraction.ONE;
        f = f1.divideBy(f2);
        Assert.assertEquals((long)2L, (long)f.getNumerator());
        Assert.assertEquals((long)7L, (long)f.getDenominator());
        f1 = Fraction.getFraction((int)1, (int)Integer.MAX_VALUE);
        f = f1.divideBy(f1);
        Assert.assertEquals((long)1L, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        f1 = Fraction.getFraction((int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE);
        f2 = Fraction.getFraction((int)1, (int)Integer.MAX_VALUE);
        f = f1.divideBy(f2);
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        try {
            f.divideBy(null);
            Assert.fail((String)"IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            f1 = Fraction.getFraction((int)1, (int)Integer.MAX_VALUE);
            f = f1.divideBy(f1.invert());
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f1 = Fraction.getFraction((int)1, (int)-2147483647);
            f = f1.divideBy(f1.invert());
            Assert.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
    }

    @Test
    public void testEquals() {
        Fraction f1 = null;
        Fraction f2 = null;
        f1 = Fraction.getFraction((int)3, (int)5);
        Assert.assertFalse((boolean)f1.equals(null));
        Assert.assertFalse((boolean)f1.equals(new Object()));
        Assert.assertFalse((boolean)f1.equals((Object)6));
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)2, (int)5);
        Assert.assertFalse((boolean)f1.equals((Object)f2));
        Assert.assertTrue((boolean)f1.equals((Object)f1));
        Assert.assertTrue((boolean)f2.equals((Object)f2));
        f2 = Fraction.getFraction((int)3, (int)5);
        Assert.assertTrue((boolean)f1.equals((Object)f2));
        f2 = Fraction.getFraction((int)6, (int)10);
        Assert.assertFalse((boolean)f1.equals((Object)f2));
    }

    @Test
    public void testHashCode() {
        Fraction f1 = Fraction.getFraction((int)3, (int)5);
        Fraction f2 = Fraction.getFraction((int)3, (int)5);
        Assert.assertTrue((f1.hashCode() == f2.hashCode() ? 1 : 0) != 0);
        f2 = Fraction.getFraction((int)2, (int)5);
        Assert.assertTrue((f1.hashCode() != f2.hashCode() ? 1 : 0) != 0);
        f2 = Fraction.getFraction((int)6, (int)10);
        Assert.assertTrue((f1.hashCode() != f2.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testCompareTo() {
        Fraction f1 = null;
        Fraction f2 = null;
        f1 = Fraction.getFraction((int)3, (int)5);
        Assert.assertTrue((f1.compareTo(f1) == 0 ? 1 : 0) != 0);
        try {
            f1.compareTo(null);
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        f2 = Fraction.getFraction((int)2, (int)5);
        Assert.assertTrue((f1.compareTo(f2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((f2.compareTo(f2) == 0 ? 1 : 0) != 0);
        f2 = Fraction.getFraction((int)4, (int)5);
        Assert.assertTrue((f1.compareTo(f2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((f2.compareTo(f2) == 0 ? 1 : 0) != 0);
        f2 = Fraction.getFraction((int)3, (int)5);
        Assert.assertTrue((f1.compareTo(f2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((f2.compareTo(f2) == 0 ? 1 : 0) != 0);
        f2 = Fraction.getFraction((int)6, (int)10);
        Assert.assertTrue((f1.compareTo(f2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((f2.compareTo(f2) == 0 ? 1 : 0) != 0);
        f2 = Fraction.getFraction((int)-1, (int)1, (int)Integer.MAX_VALUE);
        Assert.assertTrue((f1.compareTo(f2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((f2.compareTo(f2) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        Fraction f = null;
        f = Fraction.getFraction((int)3, (int)5);
        String str = f.toString();
        Assert.assertEquals((Object)"3/5", (Object)str);
        Assert.assertSame((Object)str, (Object)f.toString());
        f = Fraction.getFraction((int)7, (int)5);
        Assert.assertEquals((Object)"7/5", (Object)f.toString());
        f = Fraction.getFraction((int)4, (int)2);
        Assert.assertEquals((Object)"4/2", (Object)f.toString());
        f = Fraction.getFraction((int)0, (int)2);
        Assert.assertEquals((Object)"0/2", (Object)f.toString());
        f = Fraction.getFraction((int)2, (int)2);
        Assert.assertEquals((Object)"2/2", (Object)f.toString());
        f = Fraction.getFraction((int)Integer.MIN_VALUE, (int)0, (int)1);
        Assert.assertEquals((Object)"-2147483648/1", (Object)f.toString());
        f = Fraction.getFraction((int)-1, (int)1, (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)"-2147483648/2147483647", (Object)f.toString());
    }

    @Test
    public void testToProperString() {
        Fraction f = null;
        f = Fraction.getFraction((int)3, (int)5);
        String str = f.toProperString();
        Assert.assertEquals((Object)"3/5", (Object)str);
        Assert.assertSame((Object)str, (Object)f.toProperString());
        f = Fraction.getFraction((int)7, (int)5);
        Assert.assertEquals((Object)"1 2/5", (Object)f.toProperString());
        f = Fraction.getFraction((int)14, (int)10);
        Assert.assertEquals((Object)"1 4/10", (Object)f.toProperString());
        f = Fraction.getFraction((int)4, (int)2);
        Assert.assertEquals((Object)"2", (Object)f.toProperString());
        f = Fraction.getFraction((int)0, (int)2);
        Assert.assertEquals((Object)"0", (Object)f.toProperString());
        f = Fraction.getFraction((int)2, (int)2);
        Assert.assertEquals((Object)"1", (Object)f.toProperString());
        f = Fraction.getFraction((int)-7, (int)5);
        Assert.assertEquals((Object)"-1 2/5", (Object)f.toProperString());
        f = Fraction.getFraction((int)Integer.MIN_VALUE, (int)0, (int)1);
        Assert.assertEquals((Object)"-2147483648", (Object)f.toProperString());
        f = Fraction.getFraction((int)-1, (int)1, (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)"-1 1/2147483647", (Object)f.toProperString());
        Assert.assertEquals((Object)"-1", (Object)Fraction.getFraction((double)-1.0).toProperString());
    }
}

