/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.math;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.lang3.math.NumberUtils;
import org.junit.Assert;
import org.junit.Test;

public class NumberUtilsTest {
    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)new NumberUtils());
        Constructor<?>[] cons = NumberUtils.class.getDeclaredConstructors();
        Assert.assertEquals((long)1L, (long)cons.length);
        Assert.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assert.assertTrue((boolean)Modifier.isPublic(NumberUtils.class.getModifiers()));
        Assert.assertFalse((boolean)Modifier.isFinal(NumberUtils.class.getModifiers()));
    }

    @Test
    public void testToIntString() {
        Assert.assertTrue((String)"toInt(String) 1 failed", (NumberUtils.toInt((String)"12345") == 12345 ? 1 : 0) != 0);
        Assert.assertTrue((String)"toInt(String) 2 failed", (NumberUtils.toInt((String)"abc") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"toInt(empty) failed", (NumberUtils.toInt((String)"") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"toInt(null) failed", (NumberUtils.toInt(null) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testToIntStringI() {
        Assert.assertTrue((String)"toInt(String,int) 1 failed", (NumberUtils.toInt((String)"12345", (int)5) == 12345 ? 1 : 0) != 0);
        Assert.assertTrue((String)"toInt(String,int) 2 failed", (NumberUtils.toInt((String)"1234.5", (int)5) == 5 ? 1 : 0) != 0);
    }

    @Test
    public void testToLongString() {
        Assert.assertTrue((String)"toLong(String) 1 failed", (NumberUtils.toLong((String)"12345") == 12345L ? 1 : 0) != 0);
        Assert.assertTrue((String)"toLong(String) 2 failed", (NumberUtils.toLong((String)"abc") == 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"toLong(String) 3 failed", (NumberUtils.toLong((String)"1L") == 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"toLong(String) 4 failed", (NumberUtils.toLong((String)"1l") == 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"toLong(Long.MAX_VALUE) failed", (NumberUtils.toLong((String)"9223372036854775807") == Long.MAX_VALUE ? 1 : 0) != 0);
        Assert.assertTrue((String)"toLong(Long.MIN_VALUE) failed", (NumberUtils.toLong((String)"-9223372036854775808") == Long.MIN_VALUE ? 1 : 0) != 0);
        Assert.assertTrue((String)"toLong(empty) failed", (NumberUtils.toLong((String)"") == 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"toLong(null) failed", (NumberUtils.toLong(null) == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testToLongStringL() {
        Assert.assertTrue((String)"toLong(String,long) 1 failed", (NumberUtils.toLong((String)"12345", (long)5L) == 12345L ? 1 : 0) != 0);
        Assert.assertTrue((String)"toLong(String,long) 2 failed", (NumberUtils.toLong((String)"1234.5", (long)5L) == 5L ? 1 : 0) != 0);
    }

    @Test
    public void testToFloatString() {
        Assert.assertTrue((String)"toFloat(String) 1 failed", (NumberUtils.toFloat((String)"-1.2345") == -1.2345f ? 1 : 0) != 0);
        Assert.assertTrue((String)"toFloat(String) 2 failed", (NumberUtils.toFloat((String)"1.2345") == 1.2345f ? 1 : 0) != 0);
        Assert.assertTrue((String)"toFloat(String) 3 failed", (NumberUtils.toFloat((String)"abc") == 0.0f ? 1 : 0) != 0);
        Assert.assertTrue((String)"toFloat(Float.MAX_VALUE) failed", (NumberUtils.toFloat((String)"3.4028235E38") == Float.MAX_VALUE ? 1 : 0) != 0);
        Assert.assertTrue((String)"toFloat(Float.MIN_VALUE) failed", (NumberUtils.toFloat((String)"1.4E-45") == Float.MIN_VALUE ? 1 : 0) != 0);
        Assert.assertTrue((String)"toFloat(empty) failed", (NumberUtils.toFloat((String)"") == 0.0f ? 1 : 0) != 0);
        Assert.assertTrue((String)"toFloat(null) failed", (NumberUtils.toFloat(null) == 0.0f ? 1 : 0) != 0);
    }

    @Test
    public void testToFloatStringF() {
        Assert.assertTrue((String)"toFloat(String,int) 1 failed", (NumberUtils.toFloat((String)"1.2345", (float)5.1f) == 1.2345f ? 1 : 0) != 0);
        Assert.assertTrue((String)"toFloat(String,int) 2 failed", (NumberUtils.toFloat((String)"a", (float)5.0f) == 5.0f ? 1 : 0) != 0);
    }

    @Test
    public void testStringCreateNumberEnsureNoPrecisionLoss() {
        String shouldBeFloat = "1.23";
        String shouldBeDouble = "3.40282354e+38";
        String shouldBeBigDecimal = "1.797693134862315759e+308";
        Assert.assertTrue((boolean)(NumberUtils.createNumber((String)shouldBeFloat) instanceof Float));
        Assert.assertTrue((boolean)(NumberUtils.createNumber((String)shouldBeDouble) instanceof Double));
        Assert.assertTrue((boolean)(NumberUtils.createNumber((String)shouldBeBigDecimal) instanceof BigDecimal));
    }

    @Test
    public void testStringToDoubleString() {
        Assert.assertTrue((String)"toDouble(String) 1 failed", (NumberUtils.toDouble((String)"-1.2345") == -1.2345 ? 1 : 0) != 0);
        Assert.assertTrue((String)"toDouble(String) 2 failed", (NumberUtils.toDouble((String)"1.2345") == 1.2345 ? 1 : 0) != 0);
        Assert.assertTrue((String)"toDouble(String) 3 failed", (NumberUtils.toDouble((String)"abc") == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"toDouble(Double.MAX_VALUE) failed", (NumberUtils.toDouble((String)"1.7976931348623157E308") == Double.MAX_VALUE ? 1 : 0) != 0);
        Assert.assertTrue((String)"toDouble(Double.MIN_VALUE) failed", (NumberUtils.toDouble((String)"4.9E-324") == Double.MIN_VALUE ? 1 : 0) != 0);
        Assert.assertTrue((String)"toDouble(empty) failed", (NumberUtils.toDouble((String)"") == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"toDouble(null) failed", (NumberUtils.toDouble(null) == 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testStringToDoubleStringD() {
        Assert.assertTrue((String)"toDouble(String,int) 1 failed", (NumberUtils.toDouble((String)"1.2345", (double)5.1) == 1.2345 ? 1 : 0) != 0);
        Assert.assertTrue((String)"toDouble(String,int) 2 failed", (NumberUtils.toDouble((String)"a", (double)5.0) == 5.0 ? 1 : 0) != 0);
    }

    @Test
    public void testToByteString() {
        Assert.assertTrue((String)"toByte(String) 1 failed", (NumberUtils.toByte((String)"123") == 123 ? 1 : 0) != 0);
        Assert.assertTrue((String)"toByte(String) 2 failed", (NumberUtils.toByte((String)"abc") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"toByte(empty) failed", (NumberUtils.toByte((String)"") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"toByte(null) failed", (NumberUtils.toByte(null) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testToByteStringI() {
        Assert.assertTrue((String)"toByte(String,byte) 1 failed", (NumberUtils.toByte((String)"123", (byte)5) == 123 ? 1 : 0) != 0);
        Assert.assertTrue((String)"toByte(String,byte) 2 failed", (NumberUtils.toByte((String)"12.3", (byte)5) == 5 ? 1 : 0) != 0);
    }

    @Test
    public void testToShortString() {
        Assert.assertTrue((String)"toShort(String) 1 failed", (NumberUtils.toShort((String)"12345") == 12345 ? 1 : 0) != 0);
        Assert.assertTrue((String)"toShort(String) 2 failed", (NumberUtils.toShort((String)"abc") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"toShort(empty) failed", (NumberUtils.toShort((String)"") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"toShort(null) failed", (NumberUtils.toShort(null) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testToShortStringI() {
        Assert.assertTrue((String)"toShort(String,short) 1 failed", (NumberUtils.toShort((String)"12345", (short)5) == 12345 ? 1 : 0) != 0);
        Assert.assertTrue((String)"toShort(String,short) 2 failed", (NumberUtils.toShort((String)"1234.5", (short)5) == 5 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateNumber() {
        Assert.assertEquals((String)"createNumber(String) 1 failed", (Object)Float.valueOf("1234.5"), (Object)NumberUtils.createNumber((String)"1234.5"));
        Assert.assertEquals((String)"createNumber(String) 2 failed", (Object)Integer.valueOf("12345"), (Object)NumberUtils.createNumber((String)"12345"));
        Assert.assertEquals((String)"createNumber(String) 3 failed", (Object)Double.valueOf("1234.5"), (Object)NumberUtils.createNumber((String)"1234.5D"));
        Assert.assertEquals((String)"createNumber(String) 3 failed", (Object)Double.valueOf("1234.5"), (Object)NumberUtils.createNumber((String)"1234.5d"));
        Assert.assertEquals((String)"createNumber(String) 4 failed", (Object)Float.valueOf("1234.5"), (Object)NumberUtils.createNumber((String)"1234.5F"));
        Assert.assertEquals((String)"createNumber(String) 4 failed", (Object)Float.valueOf("1234.5"), (Object)NumberUtils.createNumber((String)"1234.5f"));
        Assert.assertEquals((String)"createNumber(String) 5 failed", (Object)0x80000000L, (Object)NumberUtils.createNumber((String)"2147483648"));
        Assert.assertEquals((String)"createNumber(String) 6 failed", (Object)12345L, (Object)NumberUtils.createNumber((String)"12345L"));
        Assert.assertEquals((String)"createNumber(String) 6 failed", (Object)12345L, (Object)NumberUtils.createNumber((String)"12345l"));
        Assert.assertEquals((String)"createNumber(String) 7 failed", (Object)Float.valueOf("-1234.5"), (Object)NumberUtils.createNumber((String)"-1234.5"));
        Assert.assertEquals((String)"createNumber(String) 8 failed", (Object)Integer.valueOf("-12345"), (Object)NumberUtils.createNumber((String)"-12345"));
        Assert.assertTrue((String)"createNumber(String) 9a failed", (64222 == NumberUtils.createNumber((String)"0xFADE").intValue() ? 1 : 0) != 0);
        Assert.assertTrue((String)"createNumber(String) 9b failed", (64222 == NumberUtils.createNumber((String)"0Xfade").intValue() ? 1 : 0) != 0);
        Assert.assertTrue((String)"createNumber(String) 10a failed", (-64222 == NumberUtils.createNumber((String)"-0xFADE").intValue() ? 1 : 0) != 0);
        Assert.assertTrue((String)"createNumber(String) 10b failed", (-64222 == NumberUtils.createNumber((String)"-0Xfade").intValue() ? 1 : 0) != 0);
        Assert.assertEquals((String)"createNumber(String) 11 failed", (Object)Double.valueOf("1.1E200"), (Object)NumberUtils.createNumber((String)"1.1E200"));
        Assert.assertEquals((String)"createNumber(String) 12 failed", (Object)Float.valueOf("1.1E20"), (Object)NumberUtils.createNumber((String)"1.1E20"));
        Assert.assertEquals((String)"createNumber(String) 13 failed", (Object)Double.valueOf("-1.1E200"), (Object)NumberUtils.createNumber((String)"-1.1E200"));
        Assert.assertEquals((String)"createNumber(String) 14 failed", (Object)Double.valueOf("1.1E-200"), (Object)NumberUtils.createNumber((String)"1.1E-200"));
        Assert.assertEquals((String)"createNumber(null) failed", null, (Object)NumberUtils.createNumber(null));
        Assert.assertEquals((String)"createNumber(String) failed", (Object)new BigInteger("12345678901234567890"), (Object)NumberUtils.createNumber((String)"12345678901234567890L"));
        Assert.assertEquals((String)"createNumber(String) 15 failed", (Object)new BigDecimal("1.1E-700"), (Object)NumberUtils.createNumber((String)"1.1E-700F"));
        Assert.assertEquals((String)"createNumber(String) 16 failed", (Object)Long.valueOf("102147483647"), (Object)NumberUtils.createNumber((String)"102147483647L"));
        Assert.assertEquals((String)"createNumber(String) 17 failed", (Object)Long.valueOf("102147483647"), (Object)NumberUtils.createNumber((String)"102147483647"));
        Assert.assertEquals((String)"createNumber(String) 18 failed", (Object)new BigInteger("109223372036854775807"), (Object)NumberUtils.createNumber((String)"109223372036854775807"));
        Assert.assertEquals((String)"createNumber(String) LANG-521 failed", (Object)Float.valueOf("2."), (Object)NumberUtils.createNumber((String)"2."));
        Assert.assertFalse((String)"createNumber(String) succeeded", (boolean)this.checkCreateNumber("1eE"));
        Assert.assertEquals((String)"createNumber(String) LANG-693 failed", (Object)Double.MAX_VALUE, (Object)NumberUtils.createNumber((String)"1.7976931348623157E308"));
        Number bigNum = NumberUtils.createNumber((String)"-1.1E-700F");
        Assert.assertNotNull((Object)bigNum);
        Assert.assertEquals(BigDecimal.class, bigNum.getClass());
    }

    @Test
    public void TestLang747() {
        Assert.assertEquals((Object)32768, (Object)NumberUtils.createNumber((String)"0x8000"));
        Assert.assertEquals((Object)524288, (Object)NumberUtils.createNumber((String)"0x80000"));
        Assert.assertEquals((Object)0x800000, (Object)NumberUtils.createNumber((String)"0x800000"));
        Assert.assertEquals((Object)0x8000000, (Object)NumberUtils.createNumber((String)"0x8000000"));
        Assert.assertEquals((Object)Integer.MAX_VALUE, (Object)NumberUtils.createNumber((String)"0x7FFFFFFF"));
        Assert.assertEquals((Object)0x80000000L, (Object)NumberUtils.createNumber((String)"0x80000000"));
        Assert.assertEquals((Object)0xFFFFFFFFL, (Object)NumberUtils.createNumber((String)"0xFFFFFFFF"));
        Assert.assertEquals((Object)0x8000000, (Object)NumberUtils.createNumber((String)"0x08000000"));
        Assert.assertEquals((Object)Integer.MAX_VALUE, (Object)NumberUtils.createNumber((String)"0x007FFFFFFF"));
        Assert.assertEquals((Object)0x80000000L, (Object)NumberUtils.createNumber((String)"0x080000000"));
        Assert.assertEquals((Object)0xFFFFFFFFL, (Object)NumberUtils.createNumber((String)"0x00FFFFFFFF"));
        Assert.assertEquals((Object)0x800000000L, (Object)NumberUtils.createNumber((String)"0x800000000"));
        Assert.assertEquals((Object)0x8000000000L, (Object)NumberUtils.createNumber((String)"0x8000000000"));
        Assert.assertEquals((Object)0x80000000000L, (Object)NumberUtils.createNumber((String)"0x80000000000"));
        Assert.assertEquals((Object)0x800000000000L, (Object)NumberUtils.createNumber((String)"0x800000000000"));
        Assert.assertEquals((Object)0x8000000000000L, (Object)NumberUtils.createNumber((String)"0x8000000000000"));
        Assert.assertEquals((Object)0x80000000000000L, (Object)NumberUtils.createNumber((String)"0x80000000000000"));
        Assert.assertEquals((Object)0x800000000000000L, (Object)NumberUtils.createNumber((String)"0x800000000000000"));
        Assert.assertEquals((Object)Long.MAX_VALUE, (Object)NumberUtils.createNumber((String)"0x7FFFFFFFFFFFFFFF"));
        Assert.assertEquals((Object)new BigInteger("8000000000000000", 16), (Object)NumberUtils.createNumber((String)"0x8000000000000000"));
        Assert.assertEquals((Object)new BigInteger("FFFFFFFFFFFFFFFF", 16), (Object)NumberUtils.createNumber((String)"0xFFFFFFFFFFFFFFFF"));
        Assert.assertEquals((Object)0x80000000000000L, (Object)NumberUtils.createNumber((String)"0x00080000000000000"));
        Assert.assertEquals((Object)0x800000000000000L, (Object)NumberUtils.createNumber((String)"0x0800000000000000"));
        Assert.assertEquals((Object)Long.MAX_VALUE, (Object)NumberUtils.createNumber((String)"0x07FFFFFFFFFFFFFFF"));
        Assert.assertEquals((Object)new BigInteger("8000000000000000", 16), (Object)NumberUtils.createNumber((String)"0x00008000000000000000"));
        Assert.assertEquals((Object)new BigInteger("FFFFFFFFFFFFFFFF", 16), (Object)NumberUtils.createNumber((String)"0x0FFFFFFFFFFFFFFFF"));
    }

    @Test(expected=NumberFormatException.class)
    public void testCreateNumberFailure_1() {
        NumberUtils.createNumber((String)"--1.1E-700F");
    }

    @Test(expected=NumberFormatException.class)
    public void testCreateNumberFailure_2() {
        NumberUtils.createNumber((String)"-1.1E+0-7e00");
    }

    @Test(expected=NumberFormatException.class)
    public void testCreateNumberFailure_3() {
        NumberUtils.createNumber((String)"-11E+0-7e00");
    }

    @Test(expected=NumberFormatException.class)
    public void testCreateNumberFailure_4() {
        NumberUtils.createNumber((String)"1eE+00001");
    }

    @Test
    public void testCreateNumberMagnitude() {
        Assert.assertEquals((Object)Float.valueOf(Float.MAX_VALUE), (Object)NumberUtils.createNumber((String)"3.4028235e+38"));
        Assert.assertEquals((Object)3.4028236E38, (Object)NumberUtils.createNumber((String)"3.4028236e+38"));
        Assert.assertEquals((Object)Double.MAX_VALUE, (Object)NumberUtils.createNumber((String)"1.7976931348623157e+308"));
        Assert.assertEquals((Object)new BigDecimal("1.7976931348623159e+308"), (Object)NumberUtils.createNumber((String)"1.7976931348623159e+308"));
        Assert.assertEquals((Object)305419896, (Object)NumberUtils.createNumber((String)"0x12345678"));
        Assert.assertEquals((Object)4886718345L, (Object)NumberUtils.createNumber((String)"0x123456789"));
        Assert.assertEquals((Object)Long.MAX_VALUE, (Object)NumberUtils.createNumber((String)"0x7fffffffffffffff"));
        Assert.assertEquals((Object)new BigInteger("7fffffffffffffff0", 16), (Object)NumberUtils.createNumber((String)"0x7fffffffffffffff0"));
        Assert.assertEquals((Object)Long.MAX_VALUE, (Object)NumberUtils.createNumber((String)"#7fffffffffffffff"));
        Assert.assertEquals((Object)new BigInteger("7fffffffffffffff0", 16), (Object)NumberUtils.createNumber((String)"#7fffffffffffffff0"));
        Assert.assertEquals((Object)Integer.MAX_VALUE, (Object)NumberUtils.createNumber((String)"017777777777"));
        Assert.assertEquals((Object)0xFFFFFFFFL, (Object)NumberUtils.createNumber((String)"037777777777"));
        Assert.assertEquals((Object)Long.MAX_VALUE, (Object)NumberUtils.createNumber((String)"0777777777777777777777"));
        Assert.assertEquals((Object)new BigInteger("1777777777777777777777", 8), (Object)NumberUtils.createNumber((String)"01777777777777777777777"));
    }

    @Test
    public void testCreateFloat() {
        Assert.assertEquals((String)"createFloat(String) failed", (Object)Float.valueOf("1234.5"), (Object)NumberUtils.createFloat((String)"1234.5"));
        Assert.assertEquals((String)"createFloat(null) failed", null, (Object)NumberUtils.createFloat(null));
        this.testCreateFloatFailure("");
        this.testCreateFloatFailure(" ");
        this.testCreateFloatFailure("\b\t\n\f\r");
        this.testCreateFloatFailure("\u00a0\ufeff\u000b\f\u001c\u001d\u001e\u001f");
    }

    protected void testCreateFloatFailure(String str) {
        try {
            Float value = NumberUtils.createFloat((String)str);
            Assert.fail((String)("createFloat(\"" + str + "\") should have failed: " + value));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateDouble() {
        Assert.assertEquals((String)"createDouble(String) failed", (Object)Double.valueOf("1234.5"), (Object)NumberUtils.createDouble((String)"1234.5"));
        Assert.assertEquals((String)"createDouble(null) failed", null, (Object)NumberUtils.createDouble(null));
        this.testCreateDoubleFailure("");
        this.testCreateDoubleFailure(" ");
        this.testCreateDoubleFailure("\b\t\n\f\r");
        this.testCreateDoubleFailure("\u00a0\ufeff\u000b\f\u001c\u001d\u001e\u001f");
    }

    protected void testCreateDoubleFailure(String str) {
        try {
            Double value = NumberUtils.createDouble((String)str);
            Assert.fail((String)("createDouble(\"" + str + "\") should have failed: " + value));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateInteger() {
        Assert.assertEquals((String)"createInteger(String) failed", (Object)Integer.valueOf("12345"), (Object)NumberUtils.createInteger((String)"12345"));
        Assert.assertEquals((String)"createInteger(null) failed", null, (Object)NumberUtils.createInteger(null));
        this.testCreateIntegerFailure("");
        this.testCreateIntegerFailure(" ");
        this.testCreateIntegerFailure("\b\t\n\f\r");
        this.testCreateIntegerFailure("\u00a0\ufeff\u000b\f\u001c\u001d\u001e\u001f");
    }

    protected void testCreateIntegerFailure(String str) {
        try {
            Integer value = NumberUtils.createInteger((String)str);
            Assert.fail((String)("createInteger(\"" + str + "\") should have failed: " + value));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateLong() {
        Assert.assertEquals((String)"createLong(String) failed", (Object)Long.valueOf("12345"), (Object)NumberUtils.createLong((String)"12345"));
        Assert.assertEquals((String)"createLong(null) failed", null, (Object)NumberUtils.createLong(null));
        this.testCreateLongFailure("");
        this.testCreateLongFailure(" ");
        this.testCreateLongFailure("\b\t\n\f\r");
        this.testCreateLongFailure("\u00a0\ufeff\u000b\f\u001c\u001d\u001e\u001f");
    }

    protected void testCreateLongFailure(String str) {
        try {
            Long value = NumberUtils.createLong((String)str);
            Assert.fail((String)("createLong(\"" + str + "\") should have failed: " + value));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateBigInteger() {
        Assert.assertEquals((String)"createBigInteger(String) failed", (Object)new BigInteger("12345"), (Object)NumberUtils.createBigInteger((String)"12345"));
        Assert.assertEquals((String)"createBigInteger(null) failed", null, (Object)NumberUtils.createBigInteger(null));
        this.testCreateBigIntegerFailure("");
        this.testCreateBigIntegerFailure(" ");
        this.testCreateBigIntegerFailure("\b\t\n\f\r");
        this.testCreateBigIntegerFailure("\u00a0\ufeff\u000b\f\u001c\u001d\u001e\u001f");
        Assert.assertEquals((String)"createBigInteger(String) failed", (Object)new BigInteger("255"), (Object)NumberUtils.createBigInteger((String)"0xff"));
        Assert.assertEquals((String)"createBigInteger(String) failed", (Object)new BigInteger("255"), (Object)NumberUtils.createBigInteger((String)"#ff"));
        Assert.assertEquals((String)"createBigInteger(String) failed", (Object)new BigInteger("-255"), (Object)NumberUtils.createBigInteger((String)"-0xff"));
        Assert.assertEquals((String)"createBigInteger(String) failed", (Object)new BigInteger("255"), (Object)NumberUtils.createBigInteger((String)"0377"));
        Assert.assertEquals((String)"createBigInteger(String) failed", (Object)new BigInteger("-255"), (Object)NumberUtils.createBigInteger((String)"-0377"));
        Assert.assertEquals((String)"createBigInteger(String) failed", (Object)new BigInteger("-255"), (Object)NumberUtils.createBigInteger((String)"-0377"));
        Assert.assertEquals((String)"createBigInteger(String) failed", (Object)new BigInteger("-0"), (Object)NumberUtils.createBigInteger((String)"-0"));
        Assert.assertEquals((String)"createBigInteger(String) failed", (Object)new BigInteger("0"), (Object)NumberUtils.createBigInteger((String)"0"));
        this.testCreateBigIntegerFailure("#");
        this.testCreateBigIntegerFailure("-#");
        this.testCreateBigIntegerFailure("0x");
        this.testCreateBigIntegerFailure("-0x");
    }

    protected void testCreateBigIntegerFailure(String str) {
        try {
            BigInteger value = NumberUtils.createBigInteger((String)str);
            Assert.fail((String)("createBigInteger(\"" + str + "\") should have failed: " + value));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateBigDecimal() {
        Assert.assertEquals((String)"createBigDecimal(String) failed", (Object)new BigDecimal("1234.5"), (Object)NumberUtils.createBigDecimal((String)"1234.5"));
        Assert.assertEquals((String)"createBigDecimal(null) failed", null, (Object)NumberUtils.createBigDecimal(null));
        this.testCreateBigDecimalFailure("");
        this.testCreateBigDecimalFailure(" ");
        this.testCreateBigDecimalFailure("\b\t\n\f\r");
        this.testCreateBigDecimalFailure("\u00a0\ufeff\u000b\f\u001c\u001d\u001e\u001f");
        this.testCreateBigDecimalFailure("-");
        this.testCreateBigDecimalFailure("--");
        this.testCreateBigDecimalFailure("--0");
        this.testCreateBigDecimalFailure("+");
        this.testCreateBigDecimalFailure("++");
        this.testCreateBigDecimalFailure("++0");
    }

    protected void testCreateBigDecimalFailure(String str) {
        try {
            BigDecimal value = NumberUtils.createBigDecimal((String)str);
            Assert.fail((String)("createBigDecimal(\"" + str + "\") should have failed: " + value));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMinLong_nullArray() {
        NumberUtils.min((long[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMinLong_emptyArray() {
        NumberUtils.min((long[])new long[0]);
    }

    @Test
    public void testMinLong() {
        Assert.assertEquals((String)"min(long[]) failed for array length 1", (long)5L, (long)NumberUtils.min((long[])new long[]{5L}));
        Assert.assertEquals((String)"min(long[]) failed for array length 2", (long)6L, (long)NumberUtils.min((long[])new long[]{6L, 9L}));
        Assert.assertEquals((long)-10L, (long)NumberUtils.min((long[])new long[]{-10L, -5L, 0L, 5L, 10L}));
        Assert.assertEquals((long)-10L, (long)NumberUtils.min((long[])new long[]{-5L, 0L, -10L, 5L, 10L}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMinInt_nullArray() {
        NumberUtils.min((int[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMinInt_emptyArray() {
        NumberUtils.min((int[])new int[0]);
    }

    @Test
    public void testMinInt() {
        Assert.assertEquals((String)"min(int[]) failed for array length 1", (long)5L, (long)NumberUtils.min((int[])new int[]{5}));
        Assert.assertEquals((String)"min(int[]) failed for array length 2", (long)6L, (long)NumberUtils.min((int[])new int[]{6, 9}));
        Assert.assertEquals((long)-10L, (long)NumberUtils.min((int[])new int[]{-10, -5, 0, 5, 10}));
        Assert.assertEquals((long)-10L, (long)NumberUtils.min((int[])new int[]{-5, 0, -10, 5, 10}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMinShort_nullArray() {
        NumberUtils.min((short[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMinShort_emptyArray() {
        NumberUtils.min((short[])new short[0]);
    }

    @Test
    public void testMinShort() {
        Assert.assertEquals((String)"min(short[]) failed for array length 1", (long)5L, (long)NumberUtils.min((short[])new short[]{5}));
        Assert.assertEquals((String)"min(short[]) failed for array length 2", (long)6L, (long)NumberUtils.min((short[])new short[]{6, 9}));
        Assert.assertEquals((long)-10L, (long)NumberUtils.min((short[])new short[]{-10, -5, 0, 5, 10}));
        Assert.assertEquals((long)-10L, (long)NumberUtils.min((short[])new short[]{-5, 0, -10, 5, 10}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMinByte_nullArray() {
        NumberUtils.min((byte[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMinByte_emptyArray() {
        NumberUtils.min((byte[])new byte[0]);
    }

    @Test
    public void testMinByte() {
        Assert.assertEquals((String)"min(byte[]) failed for array length 1", (long)5L, (long)NumberUtils.min((byte[])new byte[]{5}));
        Assert.assertEquals((String)"min(byte[]) failed for array length 2", (long)6L, (long)NumberUtils.min((byte[])new byte[]{6, 9}));
        Assert.assertEquals((long)-10L, (long)NumberUtils.min((byte[])new byte[]{-10, -5, 0, 5, 10}));
        Assert.assertEquals((long)-10L, (long)NumberUtils.min((byte[])new byte[]{-5, 0, -10, 5, 10}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMinDouble_nullArray() {
        NumberUtils.min((double[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMinDouble_emptyArray() {
        NumberUtils.min((double[])new double[0]);
    }

    @Test
    public void testMinDouble() {
        Assert.assertEquals((String)"min(double[]) failed for array length 1", (double)5.12, (double)NumberUtils.min((double[])new double[]{5.12}), (double)0.0);
        Assert.assertEquals((String)"min(double[]) failed for array length 2", (double)6.23, (double)NumberUtils.min((double[])new double[]{6.23, 9.34}), (double)0.0);
        Assert.assertEquals((String)"min(double[]) failed for array length 5", (double)-10.45, (double)NumberUtils.min((double[])new double[]{-10.45, -5.56, 0.0, 5.67, 10.78}), (double)0.0);
        Assert.assertEquals((double)-10.0, (double)NumberUtils.min((double[])new double[]{-10.0, -5.0, 0.0, 5.0, 10.0}), (double)1.0E-4);
        Assert.assertEquals((double)-10.0, (double)NumberUtils.min((double[])new double[]{-5.0, 0.0, -10.0, 5.0, 10.0}), (double)1.0E-4);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMinFloat_nullArray() {
        NumberUtils.min((float[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMinFloat_emptyArray() {
        NumberUtils.min((float[])new float[0]);
    }

    @Test
    public void testMinFloat() {
        Assert.assertEquals((String)"min(float[]) failed for array length 1", (float)5.9f, (float)NumberUtils.min((float[])new float[]{5.9f}), (float)0.0f);
        Assert.assertEquals((String)"min(float[]) failed for array length 2", (float)6.8f, (float)NumberUtils.min((float[])new float[]{6.8f, 9.7f}), (float)0.0f);
        Assert.assertEquals((String)"min(float[]) failed for array length 5", (float)-10.6f, (float)NumberUtils.min((float[])new float[]{-10.6f, -5.5f, 0.0f, 5.4f, 10.3f}), (float)0.0f);
        Assert.assertEquals((float)-10.0f, (float)NumberUtils.min((float[])new float[]{-10.0f, -5.0f, 0.0f, 5.0f, 10.0f}), (float)1.0E-4f);
        Assert.assertEquals((float)-10.0f, (float)NumberUtils.min((float[])new float[]{-5.0f, 0.0f, -10.0f, 5.0f, 10.0f}), (float)1.0E-4f);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMaxLong_nullArray() {
        NumberUtils.max((long[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMaxLong_emptyArray() {
        NumberUtils.max((long[])new long[0]);
    }

    @Test
    public void testMaxLong() {
        Assert.assertEquals((String)"max(long[]) failed for array length 1", (long)5L, (long)NumberUtils.max((long[])new long[]{5L}));
        Assert.assertEquals((String)"max(long[]) failed for array length 2", (long)9L, (long)NumberUtils.max((long[])new long[]{6L, 9L}));
        Assert.assertEquals((String)"max(long[]) failed for array length 5", (long)10L, (long)NumberUtils.max((long[])new long[]{-10L, -5L, 0L, 5L, 10L}));
        Assert.assertEquals((long)10L, (long)NumberUtils.max((long[])new long[]{-10L, -5L, 0L, 5L, 10L}));
        Assert.assertEquals((long)10L, (long)NumberUtils.max((long[])new long[]{-5L, 0L, 10L, 5L, -10L}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMaxInt_nullArray() {
        NumberUtils.max((int[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMaxInt_emptyArray() {
        NumberUtils.max((int[])new int[0]);
    }

    @Test
    public void testMaxInt() {
        Assert.assertEquals((String)"max(int[]) failed for array length 1", (long)5L, (long)NumberUtils.max((int[])new int[]{5}));
        Assert.assertEquals((String)"max(int[]) failed for array length 2", (long)9L, (long)NumberUtils.max((int[])new int[]{6, 9}));
        Assert.assertEquals((String)"max(int[]) failed for array length 5", (long)10L, (long)NumberUtils.max((int[])new int[]{-10, -5, 0, 5, 10}));
        Assert.assertEquals((long)10L, (long)NumberUtils.max((int[])new int[]{-10, -5, 0, 5, 10}));
        Assert.assertEquals((long)10L, (long)NumberUtils.max((int[])new int[]{-5, 0, 10, 5, -10}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMaxShort_nullArray() {
        NumberUtils.max((short[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMaxShort_emptyArray() {
        NumberUtils.max((short[])new short[0]);
    }

    @Test
    public void testMaxShort() {
        Assert.assertEquals((String)"max(short[]) failed for array length 1", (long)5L, (long)NumberUtils.max((short[])new short[]{5}));
        Assert.assertEquals((String)"max(short[]) failed for array length 2", (long)9L, (long)NumberUtils.max((short[])new short[]{6, 9}));
        Assert.assertEquals((String)"max(short[]) failed for array length 5", (long)10L, (long)NumberUtils.max((short[])new short[]{-10, -5, 0, 5, 10}));
        Assert.assertEquals((long)10L, (long)NumberUtils.max((short[])new short[]{-10, -5, 0, 5, 10}));
        Assert.assertEquals((long)10L, (long)NumberUtils.max((short[])new short[]{-5, 0, 10, 5, -10}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMaxByte_nullArray() {
        NumberUtils.max((byte[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMaxByte_emptyArray() {
        NumberUtils.max((byte[])new byte[0]);
    }

    @Test
    public void testMaxByte() {
        Assert.assertEquals((String)"max(byte[]) failed for array length 1", (long)5L, (long)NumberUtils.max((byte[])new byte[]{5}));
        Assert.assertEquals((String)"max(byte[]) failed for array length 2", (long)9L, (long)NumberUtils.max((byte[])new byte[]{6, 9}));
        Assert.assertEquals((String)"max(byte[]) failed for array length 5", (long)10L, (long)NumberUtils.max((byte[])new byte[]{-10, -5, 0, 5, 10}));
        Assert.assertEquals((long)10L, (long)NumberUtils.max((byte[])new byte[]{-10, -5, 0, 5, 10}));
        Assert.assertEquals((long)10L, (long)NumberUtils.max((byte[])new byte[]{-5, 0, 10, 5, -10}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMaxDouble_nullArray() {
        NumberUtils.max((double[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMaxDouble_emptyArray() {
        NumberUtils.max((double[])new double[0]);
    }

    @Test
    public void testMaxDouble() {
        double[] d = null;
        try {
            NumberUtils.max(d);
            Assert.fail((String)"No exception was thrown for null input.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            NumberUtils.max((double[])new double[0]);
            Assert.fail((String)"No exception was thrown for empty input.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((String)"max(double[]) failed for array length 1", (double)5.1f, (double)NumberUtils.max((double[])new double[]{5.1f}), (double)0.0);
        Assert.assertEquals((String)"max(double[]) failed for array length 2", (double)9.2f, (double)NumberUtils.max((double[])new double[]{6.3f, 9.2f}), (double)0.0);
        Assert.assertEquals((String)"max(double[]) failed for float length 5", (double)10.4f, (double)NumberUtils.max((double[])new double[]{-10.5, -5.6f, 0.0, 5.7f, 10.4f}), (double)0.0);
        Assert.assertEquals((double)10.0, (double)NumberUtils.max((double[])new double[]{-10.0, -5.0, 0.0, 5.0, 10.0}), (double)1.0E-4);
        Assert.assertEquals((double)10.0, (double)NumberUtils.max((double[])new double[]{-5.0, 0.0, 10.0, 5.0, -10.0}), (double)1.0E-4);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMaxFloat_nullArray() {
        NumberUtils.max((float[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMaxFloat_emptyArray() {
        NumberUtils.max((float[])new float[0]);
    }

    @Test
    public void testMaxFloat() {
        Assert.assertEquals((String)"max(float[]) failed for array length 1", (float)5.1f, (float)NumberUtils.max((float[])new float[]{5.1f}), (float)0.0f);
        Assert.assertEquals((String)"max(float[]) failed for array length 2", (float)9.2f, (float)NumberUtils.max((float[])new float[]{6.3f, 9.2f}), (float)0.0f);
        Assert.assertEquals((String)"max(float[]) failed for float length 5", (float)10.4f, (float)NumberUtils.max((float[])new float[]{-10.5f, -5.6f, 0.0f, 5.7f, 10.4f}), (float)0.0f);
        Assert.assertEquals((float)10.0f, (float)NumberUtils.max((float[])new float[]{-10.0f, -5.0f, 0.0f, 5.0f, 10.0f}), (float)1.0E-4f);
        Assert.assertEquals((float)10.0f, (float)NumberUtils.max((float[])new float[]{-5.0f, 0.0f, 10.0f, 5.0f, -10.0f}), (float)1.0E-4f);
    }

    @Test
    public void testMinimumLong() {
        Assert.assertEquals((String)"minimum(long,long,long) 1 failed", (long)12345L, (long)NumberUtils.min((long)12345L, (long)12346L, (long)12347L));
        Assert.assertEquals((String)"minimum(long,long,long) 2 failed", (long)12345L, (long)NumberUtils.min((long)12346L, (long)12345L, (long)12347L));
        Assert.assertEquals((String)"minimum(long,long,long) 3 failed", (long)12345L, (long)NumberUtils.min((long)12346L, (long)12347L, (long)12345L));
        Assert.assertEquals((String)"minimum(long,long,long) 4 failed", (long)12345L, (long)NumberUtils.min((long)12346L, (long)12345L, (long)12345L));
        Assert.assertEquals((String)"minimum(long,long,long) 5 failed", (long)12345L, (long)NumberUtils.min((long)12345L, (long)12345L, (long)12345L));
    }

    @Test
    public void testMinimumInt() {
        Assert.assertEquals((String)"minimum(int,int,int) 1 failed", (long)12345L, (long)NumberUtils.min((int)12345, (int)12346, (int)12347));
        Assert.assertEquals((String)"minimum(int,int,int) 2 failed", (long)12345L, (long)NumberUtils.min((int)12346, (int)12345, (int)12347));
        Assert.assertEquals((String)"minimum(int,int,int) 3 failed", (long)12345L, (long)NumberUtils.min((int)12346, (int)12347, (int)12345));
        Assert.assertEquals((String)"minimum(int,int,int) 4 failed", (long)12345L, (long)NumberUtils.min((int)12346, (int)12345, (int)12345));
        Assert.assertEquals((String)"minimum(int,int,int) 5 failed", (long)12345L, (long)NumberUtils.min((int)12345, (int)12345, (int)12345));
    }

    @Test
    public void testMinimumShort() {
        int low = 1234;
        int mid = 1235;
        int high = 1236;
        Assert.assertEquals((String)"minimum(short,short,short) 1 failed", (long)1234L, (long)NumberUtils.min((short)1234, (short)1235, (short)1236));
        Assert.assertEquals((String)"minimum(short,short,short) 1 failed", (long)1234L, (long)NumberUtils.min((short)1235, (short)1234, (short)1236));
        Assert.assertEquals((String)"minimum(short,short,short) 1 failed", (long)1234L, (long)NumberUtils.min((short)1235, (short)1236, (short)1234));
        Assert.assertEquals((String)"minimum(short,short,short) 1 failed", (long)1234L, (long)NumberUtils.min((short)1234, (short)1235, (short)1234));
    }

    @Test
    public void testMinimumByte() {
        int low = 123;
        int mid = 124;
        int high = 125;
        Assert.assertEquals((String)"minimum(byte,byte,byte) 1 failed", (long)123L, (long)NumberUtils.min((byte)123, (byte)124, (byte)125));
        Assert.assertEquals((String)"minimum(byte,byte,byte) 1 failed", (long)123L, (long)NumberUtils.min((byte)124, (byte)123, (byte)125));
        Assert.assertEquals((String)"minimum(byte,byte,byte) 1 failed", (long)123L, (long)NumberUtils.min((byte)124, (byte)125, (byte)123));
        Assert.assertEquals((String)"minimum(byte,byte,byte) 1 failed", (long)123L, (long)NumberUtils.min((byte)123, (byte)124, (byte)123));
    }

    @Test
    public void testMinimumDouble() {
        double low = 12.3;
        double mid = 13.3;
        double high = 14.3;
        Assert.assertEquals((double)12.3, (double)NumberUtils.min((double)12.3, (double)13.3, (double)14.3), (double)1.0E-4);
        Assert.assertEquals((double)12.3, (double)NumberUtils.min((double)13.3, (double)12.3, (double)14.3), (double)1.0E-4);
        Assert.assertEquals((double)12.3, (double)NumberUtils.min((double)13.3, (double)14.3, (double)12.3), (double)1.0E-4);
        Assert.assertEquals((double)12.3, (double)NumberUtils.min((double)12.3, (double)13.3, (double)12.3), (double)1.0E-4);
        Assert.assertEquals((double)13.3, (double)NumberUtils.min((double)14.3, (double)13.3, (double)14.3), (double)1.0E-4);
    }

    @Test
    public void testMinimumFloat() {
        float low = 12.3f;
        float mid = 13.3f;
        float high = 14.3f;
        Assert.assertEquals((float)12.3f, (float)NumberUtils.min((float)12.3f, (float)13.3f, (float)14.3f), (float)1.0E-4f);
        Assert.assertEquals((float)12.3f, (float)NumberUtils.min((float)13.3f, (float)12.3f, (float)14.3f), (float)1.0E-4f);
        Assert.assertEquals((float)12.3f, (float)NumberUtils.min((float)13.3f, (float)14.3f, (float)12.3f), (float)1.0E-4f);
        Assert.assertEquals((float)12.3f, (float)NumberUtils.min((float)12.3f, (float)13.3f, (float)12.3f), (float)1.0E-4f);
        Assert.assertEquals((float)13.3f, (float)NumberUtils.min((float)14.3f, (float)13.3f, (float)14.3f), (float)1.0E-4f);
    }

    @Test
    public void testMaximumLong() {
        Assert.assertEquals((String)"maximum(long,long,long) 1 failed", (long)12345L, (long)NumberUtils.max((long)12345L, (long)12344L, (long)12343L));
        Assert.assertEquals((String)"maximum(long,long,long) 2 failed", (long)12345L, (long)NumberUtils.max((long)12344L, (long)12345L, (long)12343L));
        Assert.assertEquals((String)"maximum(long,long,long) 3 failed", (long)12345L, (long)NumberUtils.max((long)12344L, (long)12343L, (long)12345L));
        Assert.assertEquals((String)"maximum(long,long,long) 4 failed", (long)12345L, (long)NumberUtils.max((long)12344L, (long)12345L, (long)12345L));
        Assert.assertEquals((String)"maximum(long,long,long) 5 failed", (long)12345L, (long)NumberUtils.max((long)12345L, (long)12345L, (long)12345L));
    }

    @Test
    public void testMaximumInt() {
        Assert.assertEquals((String)"maximum(int,int,int) 1 failed", (long)12345L, (long)NumberUtils.max((int)12345, (int)12344, (int)12343));
        Assert.assertEquals((String)"maximum(int,int,int) 2 failed", (long)12345L, (long)NumberUtils.max((int)12344, (int)12345, (int)12343));
        Assert.assertEquals((String)"maximum(int,int,int) 3 failed", (long)12345L, (long)NumberUtils.max((int)12344, (int)12343, (int)12345));
        Assert.assertEquals((String)"maximum(int,int,int) 4 failed", (long)12345L, (long)NumberUtils.max((int)12344, (int)12345, (int)12345));
        Assert.assertEquals((String)"maximum(int,int,int) 5 failed", (long)12345L, (long)NumberUtils.max((int)12345, (int)12345, (int)12345));
    }

    @Test
    public void testMaximumShort() {
        int low = 1234;
        int mid = 1235;
        int high = 1236;
        Assert.assertEquals((String)"maximum(short,short,short) 1 failed", (long)1236L, (long)NumberUtils.max((short)1234, (short)1235, (short)1236));
        Assert.assertEquals((String)"maximum(short,short,short) 1 failed", (long)1236L, (long)NumberUtils.max((short)1235, (short)1234, (short)1236));
        Assert.assertEquals((String)"maximum(short,short,short) 1 failed", (long)1236L, (long)NumberUtils.max((short)1235, (short)1236, (short)1234));
        Assert.assertEquals((String)"maximum(short,short,short) 1 failed", (long)1236L, (long)NumberUtils.max((short)1236, (short)1235, (short)1236));
    }

    @Test
    public void testMaximumByte() {
        int low = 123;
        int mid = 124;
        int high = 125;
        Assert.assertEquals((String)"maximum(byte,byte,byte) 1 failed", (long)125L, (long)NumberUtils.max((byte)123, (byte)124, (byte)125));
        Assert.assertEquals((String)"maximum(byte,byte,byte) 1 failed", (long)125L, (long)NumberUtils.max((byte)124, (byte)123, (byte)125));
        Assert.assertEquals((String)"maximum(byte,byte,byte) 1 failed", (long)125L, (long)NumberUtils.max((byte)124, (byte)125, (byte)123));
        Assert.assertEquals((String)"maximum(byte,byte,byte) 1 failed", (long)125L, (long)NumberUtils.max((byte)125, (byte)124, (byte)125));
    }

    @Test
    public void testMaximumDouble() {
        double low = 12.3;
        double mid = 13.3;
        double high = 14.3;
        Assert.assertEquals((double)14.3, (double)NumberUtils.max((double)12.3, (double)13.3, (double)14.3), (double)1.0E-4);
        Assert.assertEquals((double)14.3, (double)NumberUtils.max((double)13.3, (double)12.3, (double)14.3), (double)1.0E-4);
        Assert.assertEquals((double)14.3, (double)NumberUtils.max((double)13.3, (double)14.3, (double)12.3), (double)1.0E-4);
        Assert.assertEquals((double)13.3, (double)NumberUtils.max((double)12.3, (double)13.3, (double)12.3), (double)1.0E-4);
        Assert.assertEquals((double)14.3, (double)NumberUtils.max((double)14.3, (double)13.3, (double)14.3), (double)1.0E-4);
    }

    @Test
    public void testMaximumFloat() {
        float low = 12.3f;
        float mid = 13.3f;
        float high = 14.3f;
        Assert.assertEquals((float)14.3f, (float)NumberUtils.max((float)12.3f, (float)13.3f, (float)14.3f), (float)1.0E-4f);
        Assert.assertEquals((float)14.3f, (float)NumberUtils.max((float)13.3f, (float)12.3f, (float)14.3f), (float)1.0E-4f);
        Assert.assertEquals((float)14.3f, (float)NumberUtils.max((float)13.3f, (float)14.3f, (float)12.3f), (float)1.0E-4f);
        Assert.assertEquals((float)13.3f, (float)NumberUtils.max((float)12.3f, (float)13.3f, (float)12.3f), (float)1.0E-4f);
        Assert.assertEquals((float)14.3f, (float)NumberUtils.max((float)14.3f, (float)13.3f, (float)14.3f), (float)1.0E-4f);
    }

    @Test
    public void testCompareDouble() {
        Assert.assertTrue((Double.compare(Double.NaN, Double.NaN) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.NaN, Double.POSITIVE_INFINITY) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.NaN, Double.MAX_VALUE) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.NaN, 1.2) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.NaN, 0.0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.NaN, -0.0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.NaN, -1.2) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.NaN, -1.7976931348623157E308) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.NaN, Double.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.POSITIVE_INFINITY, Double.NaN) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.POSITIVE_INFINITY, Double.MAX_VALUE) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.POSITIVE_INFINITY, 1.2) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.POSITIVE_INFINITY, 0.0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.POSITIVE_INFINITY, -0.0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.POSITIVE_INFINITY, -1.2) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.POSITIVE_INFINITY, -1.7976931348623157E308) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.MAX_VALUE, Double.NaN) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.MAX_VALUE, Double.POSITIVE_INFINITY) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.MAX_VALUE, Double.MAX_VALUE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.MAX_VALUE, 1.2) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.MAX_VALUE, 0.0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.MAX_VALUE, -0.0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.MAX_VALUE, -1.2) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.MAX_VALUE, -1.7976931348623157E308) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.MAX_VALUE, Double.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(1.2, Double.NaN) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(1.2, Double.POSITIVE_INFINITY) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(1.2, Double.MAX_VALUE) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(1.2, 1.2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(1.2, 0.0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(1.2, -0.0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(1.2, -1.2) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(1.2, -1.7976931348623157E308) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(1.2, Double.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(0.0, Double.NaN) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(0.0, Double.POSITIVE_INFINITY) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(0.0, Double.MAX_VALUE) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(0.0, 1.2) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(0.0, 0.0) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(0.0, -0.0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(0.0, -1.2) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(0.0, -1.7976931348623157E308) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(0.0, Double.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(-0.0, Double.NaN) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(-0.0, Double.POSITIVE_INFINITY) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(-0.0, Double.MAX_VALUE) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(-0.0, 1.2) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(-0.0, 0.0) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(-0.0, -0.0) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(-0.0, -1.2) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(-0.0, -1.7976931348623157E308) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(-0.0, Double.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(-1.2, Double.NaN) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(-1.2, Double.POSITIVE_INFINITY) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(-1.2, Double.MAX_VALUE) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(-1.2, 1.2) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(-1.2, 0.0) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(-1.2, -0.0) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(-1.2, -1.2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(-1.2, -1.7976931348623157E308) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(-1.2, Double.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(-1.7976931348623157E308, Double.NaN) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(-1.7976931348623157E308, Double.POSITIVE_INFINITY) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(-1.7976931348623157E308, Double.MAX_VALUE) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(-1.7976931348623157E308, 1.2) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(-1.7976931348623157E308, 0.0) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(-1.7976931348623157E308, -0.0) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(-1.7976931348623157E308, -1.2) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(-1.7976931348623157E308, -1.7976931348623157E308) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(-1.7976931348623157E308, Double.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.NEGATIVE_INFINITY, Double.NaN) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.NEGATIVE_INFINITY, Double.MAX_VALUE) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.NEGATIVE_INFINITY, 1.2) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.NEGATIVE_INFINITY, 0.0) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.NEGATIVE_INFINITY, -0.0) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.NEGATIVE_INFINITY, -1.2) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.NEGATIVE_INFINITY, -1.7976931348623157E308) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareFloat() {
        Assert.assertTrue((Float.compare(Float.NaN, Float.NaN) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.NaN, Float.POSITIVE_INFINITY) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.NaN, Float.MAX_VALUE) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.NaN, 1.2f) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.NaN, 0.0f) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.NaN, -0.0f) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.NaN, -1.2f) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.NaN, -3.4028235E38f) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.NaN, Float.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.POSITIVE_INFINITY, Float.NaN) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.POSITIVE_INFINITY, Float.MAX_VALUE) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.POSITIVE_INFINITY, 1.2f) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.POSITIVE_INFINITY, 0.0f) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.POSITIVE_INFINITY, -0.0f) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.POSITIVE_INFINITY, -1.2f) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.POSITIVE_INFINITY, -3.4028235E38f) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.MAX_VALUE, Float.NaN) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.MAX_VALUE, Float.POSITIVE_INFINITY) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.MAX_VALUE, Float.MAX_VALUE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.MAX_VALUE, 1.2f) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.MAX_VALUE, 0.0f) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.MAX_VALUE, -0.0f) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.MAX_VALUE, -1.2f) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.MAX_VALUE, -3.4028235E38f) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.MAX_VALUE, Float.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(1.2f, Float.NaN) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(1.2f, Float.POSITIVE_INFINITY) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(1.2f, Float.MAX_VALUE) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(1.2f, 1.2f) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(1.2f, 0.0f) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(1.2f, -0.0f) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(1.2f, -1.2f) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(1.2f, -3.4028235E38f) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(1.2f, Float.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(0.0f, Float.NaN) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(0.0f, Float.POSITIVE_INFINITY) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(0.0f, Float.MAX_VALUE) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(0.0f, 1.2f) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(0.0f, 0.0f) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(0.0f, -0.0f) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(0.0f, -1.2f) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(0.0f, -3.4028235E38f) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(0.0f, Float.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(-0.0f, Float.NaN) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(-0.0f, Float.POSITIVE_INFINITY) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(-0.0f, Float.MAX_VALUE) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(-0.0f, 1.2f) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(-0.0f, 0.0f) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(-0.0f, -0.0f) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(-0.0f, -1.2f) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(-0.0f, -3.4028235E38f) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(-0.0f, Float.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(-1.2f, Float.NaN) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(-1.2f, Float.POSITIVE_INFINITY) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(-1.2f, Float.MAX_VALUE) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(-1.2f, 1.2f) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(-1.2f, 0.0f) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(-1.2f, -0.0f) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(-1.2f, -1.2f) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(-1.2f, -3.4028235E38f) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(-1.2f, Float.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(-3.4028235E38f, Float.NaN) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(-3.4028235E38f, Float.POSITIVE_INFINITY) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(-3.4028235E38f, Float.MAX_VALUE) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(-3.4028235E38f, 1.2f) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(-3.4028235E38f, 0.0f) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(-3.4028235E38f, -0.0f) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(-3.4028235E38f, -1.2f) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(-3.4028235E38f, -3.4028235E38f) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(-3.4028235E38f, Float.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.NEGATIVE_INFINITY, Float.NaN) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.NEGATIVE_INFINITY, Float.MAX_VALUE) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.NEGATIVE_INFINITY, 1.2f) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.NEGATIVE_INFINITY, 0.0f) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.NEGATIVE_INFINITY, -0.0f) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.NEGATIVE_INFINITY, -1.2f) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.NEGATIVE_INFINITY, -3.4028235E38f) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.compare(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIsDigits() {
        Assert.assertFalse((String)"isDigits(null) failed", (boolean)NumberUtils.isDigits(null));
        Assert.assertFalse((String)"isDigits('') failed", (boolean)NumberUtils.isDigits((String)""));
        Assert.assertTrue((String)"isDigits(String) failed", (boolean)NumberUtils.isDigits((String)"12345"));
        Assert.assertFalse((String)"isDigits(String) neg 1 failed", (boolean)NumberUtils.isDigits((String)"1234.5"));
        Assert.assertFalse((String)"isDigits(String) neg 3 failed", (boolean)NumberUtils.isDigits((String)"1ab"));
        Assert.assertFalse((String)"isDigits(String) neg 4 failed", (boolean)NumberUtils.isDigits((String)"abc"));
    }

    @Test
    public void testIsNumber() {
        this.compareIsNumberWithCreateNumber("12345", true);
        this.compareIsNumberWithCreateNumber("1234.5", true);
        this.compareIsNumberWithCreateNumber(".12345", true);
        this.compareIsNumberWithCreateNumber("1234E5", true);
        this.compareIsNumberWithCreateNumber("1234E+5", true);
        this.compareIsNumberWithCreateNumber("1234E-5", true);
        this.compareIsNumberWithCreateNumber("123.4E5", true);
        this.compareIsNumberWithCreateNumber("-1234", true);
        this.compareIsNumberWithCreateNumber("-1234.5", true);
        this.compareIsNumberWithCreateNumber("-.12345", true);
        this.compareIsNumberWithCreateNumber("-1234E5", true);
        this.compareIsNumberWithCreateNumber("0", true);
        this.compareIsNumberWithCreateNumber("-0", true);
        this.compareIsNumberWithCreateNumber("01234", true);
        this.compareIsNumberWithCreateNumber("-01234", true);
        this.compareIsNumberWithCreateNumber("-0xABC123", true);
        this.compareIsNumberWithCreateNumber("-0x0", true);
        this.compareIsNumberWithCreateNumber("123.4E21D", true);
        this.compareIsNumberWithCreateNumber("-221.23F", true);
        this.compareIsNumberWithCreateNumber("22338L", true);
        this.compareIsNumberWithCreateNumber(null, false);
        this.compareIsNumberWithCreateNumber("", false);
        this.compareIsNumberWithCreateNumber("--2.3", false);
        this.compareIsNumberWithCreateNumber(".12.3", false);
        this.compareIsNumberWithCreateNumber("-123E", false);
        this.compareIsNumberWithCreateNumber("-123E+-212", false);
        this.compareIsNumberWithCreateNumber("-123E2.12", false);
        this.compareIsNumberWithCreateNumber("0xGF", false);
        this.compareIsNumberWithCreateNumber("0xFAE-1", false);
        this.compareIsNumberWithCreateNumber(".", false);
        this.compareIsNumberWithCreateNumber("-0ABC123", false);
        this.compareIsNumberWithCreateNumber("123.4E-D", false);
        this.compareIsNumberWithCreateNumber("123.4ED", false);
        this.compareIsNumberWithCreateNumber("1234E5l", false);
        this.compareIsNumberWithCreateNumber("11a", false);
        this.compareIsNumberWithCreateNumber("1a", false);
        this.compareIsNumberWithCreateNumber("a", false);
        this.compareIsNumberWithCreateNumber("11g", false);
        this.compareIsNumberWithCreateNumber("11z", false);
        this.compareIsNumberWithCreateNumber("11def", false);
        this.compareIsNumberWithCreateNumber("11d11", false);
        this.compareIsNumberWithCreateNumber("11 11", false);
        this.compareIsNumberWithCreateNumber(" 1111", false);
        this.compareIsNumberWithCreateNumber("1111 ", false);
        this.compareIsNumberWithCreateNumber("2.", true);
        this.compareIsNumberWithCreateNumber("1.1L", false);
    }

    @Test
    public void testLANG971() {
        this.compareIsNumberWithCreateNumber("0085", false);
        this.compareIsNumberWithCreateNumber("085", false);
        this.compareIsNumberWithCreateNumber("08", false);
        this.compareIsNumberWithCreateNumber("07", true);
        this.compareIsNumberWithCreateNumber("00", true);
    }

    @Test
    public void testLANG992() {
        this.compareIsNumberWithCreateNumber("0.0", true);
        this.compareIsNumberWithCreateNumber("0.4790", true);
    }

    @Test
    public void testLANG972() {
        this.compareIsNumberWithCreateNumber("0xABCD", true);
        this.compareIsNumberWithCreateNumber("0XABCD", true);
    }

    private void compareIsNumberWithCreateNumber(String val, boolean expected) {
        boolean isValid = NumberUtils.isNumber((String)val);
        boolean canCreate = this.checkCreateNumber(val);
        if (isValid == expected && canCreate == expected) {
            return;
        }
        Assert.fail((String)("Expecting " + expected + " for isNumber/createNumber using \"" + val + "\" but got " + isValid + " and " + canCreate));
    }

    private boolean checkCreateNumber(String val) {
        try {
            Number obj = NumberUtils.createNumber((String)val);
            return obj != null;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Test
    public void testConstants() {
        Assert.assertTrue((boolean)(NumberUtils.LONG_ZERO instanceof Long));
        Assert.assertTrue((boolean)(NumberUtils.LONG_ONE instanceof Long));
        Assert.assertTrue((boolean)(NumberUtils.LONG_MINUS_ONE instanceof Long));
        Assert.assertTrue((boolean)(NumberUtils.INTEGER_ZERO instanceof Integer));
        Assert.assertTrue((boolean)(NumberUtils.INTEGER_ONE instanceof Integer));
        Assert.assertTrue((boolean)(NumberUtils.INTEGER_MINUS_ONE instanceof Integer));
        Assert.assertTrue((boolean)(NumberUtils.SHORT_ZERO instanceof Short));
        Assert.assertTrue((boolean)(NumberUtils.SHORT_ONE instanceof Short));
        Assert.assertTrue((boolean)(NumberUtils.SHORT_MINUS_ONE instanceof Short));
        Assert.assertTrue((boolean)(NumberUtils.BYTE_ZERO instanceof Byte));
        Assert.assertTrue((boolean)(NumberUtils.BYTE_ONE instanceof Byte));
        Assert.assertTrue((boolean)(NumberUtils.BYTE_MINUS_ONE instanceof Byte));
        Assert.assertTrue((boolean)(NumberUtils.DOUBLE_ZERO instanceof Double));
        Assert.assertTrue((boolean)(NumberUtils.DOUBLE_ONE instanceof Double));
        Assert.assertTrue((boolean)(NumberUtils.DOUBLE_MINUS_ONE instanceof Double));
        Assert.assertTrue((boolean)(NumberUtils.FLOAT_ZERO instanceof Float));
        Assert.assertTrue((boolean)(NumberUtils.FLOAT_ONE instanceof Float));
        Assert.assertTrue((boolean)(NumberUtils.FLOAT_MINUS_ONE instanceof Float));
        Assert.assertTrue((NumberUtils.LONG_ZERO == 0L ? 1 : 0) != 0);
        Assert.assertTrue((NumberUtils.LONG_ONE == 1L ? 1 : 0) != 0);
        Assert.assertTrue((NumberUtils.LONG_MINUS_ONE == -1L ? 1 : 0) != 0);
        Assert.assertTrue((NumberUtils.INTEGER_ZERO == 0 ? 1 : 0) != 0);
        Assert.assertTrue((NumberUtils.INTEGER_ONE == 1 ? 1 : 0) != 0);
        Assert.assertTrue((NumberUtils.INTEGER_MINUS_ONE == -1 ? 1 : 0) != 0);
        Assert.assertTrue((NumberUtils.SHORT_ZERO == 0 ? 1 : 0) != 0);
        Assert.assertTrue((NumberUtils.SHORT_ONE == 1 ? 1 : 0) != 0);
        Assert.assertTrue((NumberUtils.SHORT_MINUS_ONE == -1 ? 1 : 0) != 0);
        Assert.assertTrue((NumberUtils.BYTE_ZERO == 0 ? 1 : 0) != 0);
        Assert.assertTrue((NumberUtils.BYTE_ONE == 1 ? 1 : 0) != 0);
        Assert.assertTrue((NumberUtils.BYTE_MINUS_ONE == -1 ? 1 : 0) != 0);
        Assert.assertTrue((NumberUtils.DOUBLE_ZERO == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((NumberUtils.DOUBLE_ONE == 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((NumberUtils.DOUBLE_MINUS_ONE == -1.0 ? 1 : 0) != 0);
        Assert.assertTrue((NumberUtils.FLOAT_ZERO.floatValue() == 0.0f ? 1 : 0) != 0);
        Assert.assertTrue((NumberUtils.FLOAT_ONE.floatValue() == 1.0f ? 1 : 0) != 0);
        Assert.assertTrue((NumberUtils.FLOAT_MINUS_ONE.floatValue() == -1.0f ? 1 : 0) != 0);
    }

    @Test
    public void testLang300() {
        NumberUtils.createNumber((String)"-1l");
        NumberUtils.createNumber((String)"01l");
        NumberUtils.createNumber((String)"1l");
    }

    @Test
    public void testLang381() {
        Assert.assertTrue((boolean)Double.isNaN(NumberUtils.min((double)1.2, (double)2.5, (double)Double.NaN)));
        Assert.assertTrue((boolean)Double.isNaN(NumberUtils.max((double)1.2, (double)2.5, (double)Double.NaN)));
        Assert.assertTrue((boolean)Float.isNaN(NumberUtils.min((float)1.2f, (float)2.5f, (float)Float.NaN)));
        Assert.assertTrue((boolean)Float.isNaN(NumberUtils.max((float)1.2f, (float)2.5f, (float)Float.NaN)));
        double[] a = new double[]{1.2, Double.NaN, 3.7, 27.0, 42.0, Double.NaN};
        Assert.assertTrue((boolean)Double.isNaN(NumberUtils.max((double[])a)));
        Assert.assertTrue((boolean)Double.isNaN(NumberUtils.min((double[])a)));
        double[] b = new double[]{Double.NaN, 1.2, Double.NaN, 3.7, 27.0, 42.0, Double.NaN};
        Assert.assertTrue((boolean)Double.isNaN(NumberUtils.max((double[])b)));
        Assert.assertTrue((boolean)Double.isNaN(NumberUtils.min((double[])b)));
        float[] aF = new float[]{1.2f, Float.NaN, 3.7f, 27.0f, 42.0f, Float.NaN};
        Assert.assertTrue((boolean)Float.isNaN(NumberUtils.max((float[])aF)));
        float[] bF = new float[]{Float.NaN, 1.2f, Float.NaN, 3.7f, 27.0f, 42.0f, Float.NaN};
        Assert.assertTrue((boolean)Float.isNaN(NumberUtils.max((float[])bF)));
    }
}

