/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import org.apache.commons.lang3.mutable.MutableDouble;
import org.junit.Assert;
import org.junit.Test;

public class MutableDoubleTest {
    @Test
    public void testConstructors() {
        Assert.assertEquals((double)0.0, (double)new MutableDouble().doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)new MutableDouble(1.0).doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)2.0, (double)new MutableDouble((Number)2.0).doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)3.0, (double)new MutableDouble((Number)new MutableDouble(3.0)).doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)2.0, (double)new MutableDouble("2.0").doubleValue(), (double)1.0E-4);
    }

    @Test(expected=NullPointerException.class)
    public void testConstructorNull() {
        new MutableDouble((Number)null);
    }

    @Test
    public void testGetSet() {
        MutableDouble mutNum = new MutableDouble(0.0);
        Assert.assertEquals((double)0.0, (double)new MutableDouble().doubleValue(), (double)1.0E-4);
        Assert.assertEquals((Object)0.0, (Object)new MutableDouble().getValue());
        mutNum.setValue(1.0);
        Assert.assertEquals((double)1.0, (double)mutNum.doubleValue(), (double)1.0E-4);
        Assert.assertEquals((Object)1.0, (Object)mutNum.getValue());
        mutNum.setValue((Number)2.0);
        Assert.assertEquals((double)2.0, (double)mutNum.doubleValue(), (double)1.0E-4);
        Assert.assertEquals((Object)2.0, (Object)mutNum.getValue());
        mutNum.setValue((Number)new MutableDouble(3.0));
        Assert.assertEquals((double)3.0, (double)mutNum.doubleValue(), (double)1.0E-4);
        Assert.assertEquals((Object)3.0, (Object)mutNum.getValue());
    }

    @Test(expected=NullPointerException.class)
    public void testSetNull() {
        MutableDouble mutNum = new MutableDouble(0.0);
        mutNum.setValue(null);
    }

    @Test
    public void testNanInfinite() {
        MutableDouble mutNum = new MutableDouble(Double.NaN);
        Assert.assertTrue((boolean)mutNum.isNaN());
        mutNum = new MutableDouble(Double.POSITIVE_INFINITY);
        Assert.assertTrue((boolean)mutNum.isInfinite());
        mutNum = new MutableDouble(Double.NEGATIVE_INFINITY);
        Assert.assertTrue((boolean)mutNum.isInfinite());
    }

    @Test
    public void testEquals() {
        MutableDouble mutNumA = new MutableDouble(0.0);
        MutableDouble mutNumB = new MutableDouble(0.0);
        MutableDouble mutNumC = new MutableDouble(1.0);
        Assert.assertTrue((boolean)mutNumA.equals((Object)mutNumA));
        Assert.assertTrue((boolean)mutNumA.equals((Object)mutNumB));
        Assert.assertTrue((boolean)mutNumB.equals((Object)mutNumA));
        Assert.assertTrue((boolean)mutNumB.equals((Object)mutNumB));
        Assert.assertFalse((boolean)mutNumA.equals((Object)mutNumC));
        Assert.assertFalse((boolean)mutNumB.equals((Object)mutNumC));
        Assert.assertTrue((boolean)mutNumC.equals((Object)mutNumC));
        Assert.assertFalse((boolean)mutNumA.equals(null));
        Assert.assertFalse((boolean)mutNumA.equals((Object)0.0));
        Assert.assertFalse((boolean)mutNumA.equals((Object)"0"));
    }

    @Test
    public void testHashCode() {
        MutableDouble mutNumA = new MutableDouble(0.0);
        MutableDouble mutNumB = new MutableDouble(0.0);
        MutableDouble mutNumC = new MutableDouble(1.0);
        Assert.assertTrue((mutNumA.hashCode() == mutNumA.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((mutNumA.hashCode() == mutNumB.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((mutNumA.hashCode() == mutNumC.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((mutNumA.hashCode() == Double.valueOf(0.0).hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testCompareTo() {
        MutableDouble mutNum = new MutableDouble(0.0);
        Assert.assertEquals((long)0L, (long)mutNum.compareTo(new MutableDouble(0.0)));
        Assert.assertEquals((long)1L, (long)mutNum.compareTo(new MutableDouble(-1.0)));
        Assert.assertEquals((long)-1L, (long)mutNum.compareTo(new MutableDouble(1.0)));
    }

    @Test(expected=NullPointerException.class)
    public void testCompareToNull() {
        MutableDouble mutNum = new MutableDouble(0.0);
        mutNum.compareTo(null);
    }

    @Test
    public void testPrimitiveValues() {
        MutableDouble mutNum = new MutableDouble(1.7);
        Assert.assertEquals((float)1.7f, (float)mutNum.floatValue(), (float)0.0f);
        Assert.assertEquals((double)1.7, (double)mutNum.doubleValue(), (double)0.0);
        Assert.assertEquals((long)1L, (long)mutNum.byteValue());
        Assert.assertEquals((long)1L, (long)mutNum.shortValue());
        Assert.assertEquals((long)1L, (long)mutNum.intValue());
        Assert.assertEquals((long)1L, (long)mutNum.longValue());
    }

    @Test
    public void testToDouble() {
        Assert.assertEquals((Object)0.0, (Object)new MutableDouble(0.0).toDouble());
        Assert.assertEquals((Object)12.3, (Object)new MutableDouble(12.3).toDouble());
    }

    @Test
    public void testIncrement() {
        MutableDouble mutNum = new MutableDouble(1.0);
        mutNum.increment();
        Assert.assertEquals((long)2L, (long)mutNum.intValue());
        Assert.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    public void testDecrement() {
        MutableDouble mutNum = new MutableDouble(1.0);
        mutNum.decrement();
        Assert.assertEquals((long)0L, (long)mutNum.intValue());
        Assert.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    public void testAddValuePrimitive() {
        MutableDouble mutNum = new MutableDouble(1.0);
        mutNum.add(1.1);
        Assert.assertEquals((double)2.1, (double)mutNum.doubleValue(), (double)0.01);
    }

    @Test
    public void testAddValueObject() {
        MutableDouble mutNum = new MutableDouble(1.0);
        mutNum.add((Number)1.1);
        Assert.assertEquals((double)2.1, (double)mutNum.doubleValue(), (double)0.01);
    }

    @Test
    public void testSubtractValuePrimitive() {
        MutableDouble mutNum = new MutableDouble(1.0);
        mutNum.subtract(0.9);
        Assert.assertEquals((double)0.1, (double)mutNum.doubleValue(), (double)0.01);
    }

    @Test
    public void testSubtractValueObject() {
        MutableDouble mutNum = new MutableDouble(1.0);
        mutNum.subtract((Number)0.9);
        Assert.assertEquals((double)0.1, (double)mutNum.doubleValue(), (double)0.01);
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"0.0", (Object)new MutableDouble(0.0).toString());
        Assert.assertEquals((Object)"10.0", (Object)new MutableDouble(10.0).toString());
        Assert.assertEquals((Object)"-123.0", (Object)new MutableDouble(-123.0).toString());
    }
}

