/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;
import org.junit.Assert;
import org.junit.Test;

public class MutableIntTest {
    @Test
    public void testConstructors() {
        Assert.assertEquals((long)0L, (long)new MutableInt().intValue());
        Assert.assertEquals((long)1L, (long)new MutableInt(1).intValue());
        Assert.assertEquals((long)2L, (long)new MutableInt((Number)2).intValue());
        Assert.assertEquals((long)3L, (long)new MutableInt((Number)new MutableLong(3L)).intValue());
        Assert.assertEquals((long)2L, (long)new MutableInt("2").intValue());
    }

    @Test(expected=NullPointerException.class)
    public void testConstructorNull() {
        new MutableInt((Number)null);
    }

    @Test
    public void testGetSet() {
        MutableInt mutNum = new MutableInt(0);
        Assert.assertEquals((long)0L, (long)new MutableInt().intValue());
        Assert.assertEquals((Object)0, (Object)new MutableInt().getValue());
        mutNum.setValue(1);
        Assert.assertEquals((long)1L, (long)mutNum.intValue());
        Assert.assertEquals((Object)1, (Object)mutNum.getValue());
        mutNum.setValue((Number)2);
        Assert.assertEquals((long)2L, (long)mutNum.intValue());
        Assert.assertEquals((Object)2, (Object)mutNum.getValue());
        mutNum.setValue((Number)new MutableLong(3L));
        Assert.assertEquals((long)3L, (long)mutNum.intValue());
        Assert.assertEquals((Object)3, (Object)mutNum.getValue());
    }

    @Test(expected=NullPointerException.class)
    public void testSetNull() {
        MutableInt mutNum = new MutableInt(0);
        mutNum.setValue(null);
    }

    @Test
    public void testEquals() {
        this.testEquals((Number)new MutableInt(0), (Number)new MutableInt(0), (Number)new MutableInt(1));
    }

    void testEquals(Number numA, Number numB, Number numC) {
        Assert.assertTrue((boolean)numA.equals(numA));
        Assert.assertTrue((boolean)numA.equals(numB));
        Assert.assertTrue((boolean)numB.equals(numA));
        Assert.assertTrue((boolean)numB.equals(numB));
        Assert.assertFalse((boolean)numA.equals(numC));
        Assert.assertFalse((boolean)numB.equals(numC));
        Assert.assertTrue((boolean)numC.equals(numC));
        Assert.assertFalse((boolean)numA.equals(null));
        Assert.assertFalse((boolean)numA.equals(0));
        Assert.assertFalse((boolean)numA.equals("0"));
    }

    @Test
    public void testHashCode() {
        MutableInt mutNumA = new MutableInt(0);
        MutableInt mutNumB = new MutableInt(0);
        MutableInt mutNumC = new MutableInt(1);
        Assert.assertTrue((mutNumA.hashCode() == mutNumA.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((mutNumA.hashCode() == mutNumB.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((mutNumA.hashCode() == mutNumC.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((mutNumA.hashCode() == Integer.valueOf(0).hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testCompareTo() {
        MutableInt mutNum = new MutableInt(0);
        Assert.assertEquals((long)0L, (long)mutNum.compareTo(new MutableInt(0)));
        Assert.assertEquals((long)1L, (long)mutNum.compareTo(new MutableInt(-1)));
        Assert.assertEquals((long)-1L, (long)mutNum.compareTo(new MutableInt(1)));
    }

    @Test(expected=NullPointerException.class)
    public void testCompareToNull() {
        MutableInt mutNum = new MutableInt(0);
        mutNum.compareTo(null);
    }

    @Test
    public void testPrimitiveValues() {
        MutableInt mutNum = new MutableInt(1);
        Assert.assertEquals((long)1L, (long)mutNum.byteValue());
        Assert.assertEquals((long)1L, (long)mutNum.shortValue());
        Assert.assertEquals((float)1.0f, (float)mutNum.floatValue(), (float)0.0f);
        Assert.assertEquals((double)1.0, (double)mutNum.doubleValue(), (double)0.0);
        Assert.assertEquals((long)1L, (long)mutNum.longValue());
    }

    @Test
    public void testToInteger() {
        Assert.assertEquals((Object)0, (Object)new MutableInt(0).toInteger());
        Assert.assertEquals((Object)123, (Object)new MutableInt(123).toInteger());
    }

    @Test
    public void testIncrement() {
        MutableInt mutNum = new MutableInt(1);
        mutNum.increment();
        Assert.assertEquals((long)2L, (long)mutNum.intValue());
        Assert.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    public void testDecrement() {
        MutableInt mutNum = new MutableInt(1);
        mutNum.decrement();
        Assert.assertEquals((long)0L, (long)mutNum.intValue());
        Assert.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    public void testAddValuePrimitive() {
        MutableInt mutNum = new MutableInt(1);
        mutNum.add(1);
        Assert.assertEquals((long)2L, (long)mutNum.intValue());
        Assert.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    public void testAddValueObject() {
        MutableInt mutNum = new MutableInt(1);
        mutNum.add((Number)1);
        Assert.assertEquals((long)2L, (long)mutNum.intValue());
        Assert.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    public void testSubtractValuePrimitive() {
        MutableInt mutNum = new MutableInt(1);
        mutNum.subtract(1);
        Assert.assertEquals((long)0L, (long)mutNum.intValue());
        Assert.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    public void testSubtractValueObject() {
        MutableInt mutNum = new MutableInt(1);
        mutNum.subtract((Number)1);
        Assert.assertEquals((long)0L, (long)mutNum.intValue());
        Assert.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"0", (Object)new MutableInt(0).toString());
        Assert.assertEquals((Object)"10", (Object)new MutableInt(10).toString());
        Assert.assertEquals((Object)"-123", (Object)new MutableInt(-123).toString());
    }
}

