/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConstructorUtilsTest {
    private final Map<Class<?>, Class<?>[]> classCache = new HashMap();

    @Before
    public void setUp() throws Exception {
        this.classCache.clear();
    }

    @Test
    public void testConstructor() throws Exception {
        Assert.assertNotNull(MethodUtils.class.newInstance());
    }

    @Test
    public void testInvokeConstructor() throws Exception {
        Assert.assertEquals((Object)"()", (Object)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])ArrayUtils.EMPTY_CLASS_ARRAY)).toString());
        Assert.assertEquals((Object)"()", (Object)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])null)).toString());
        Assert.assertEquals((Object)"()", (Object)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[0])).toString());
        Assert.assertEquals((Object)"(String)", (Object)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[]{""})).toString());
        Assert.assertEquals((Object)"(Object)", (Object)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[]{new Object()})).toString());
        Assert.assertEquals((Object)"(Object)", (Object)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[]{Boolean.TRUE})).toString());
        Assert.assertEquals((Object)"(Integer)", (Object)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[]{NumberUtils.INTEGER_ONE})).toString());
        Assert.assertEquals((Object)"(int)", (Object)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[]{NumberUtils.BYTE_ONE})).toString());
        Assert.assertEquals((Object)"(double)", (Object)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[]{NumberUtils.LONG_ONE})).toString());
        Assert.assertEquals((Object)"(double)", (Object)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[]{NumberUtils.DOUBLE_ONE})).toString());
    }

    @Test
    public void testInvokeExactConstructor() throws Exception {
        Assert.assertEquals((Object)"()", (Object)((TestBean)ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])ArrayUtils.EMPTY_CLASS_ARRAY)).toString());
        Assert.assertEquals((Object)"()", (Object)((TestBean)ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])null)).toString());
        Assert.assertEquals((Object)"(String)", (Object)((TestBean)ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])new Object[]{""})).toString());
        Assert.assertEquals((Object)"(Object)", (Object)((TestBean)ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])new Object[]{new Object()})).toString());
        Assert.assertEquals((Object)"(Integer)", (Object)((TestBean)ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])new Object[]{NumberUtils.INTEGER_ONE})).toString());
        Assert.assertEquals((Object)"(double)", (Object)((TestBean)ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])new Object[]{NumberUtils.DOUBLE_ONE}, (Class[])new Class[]{Double.TYPE})).toString());
        try {
            ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])new Object[]{NumberUtils.BYTE_ONE});
            Assert.fail((String)"should throw NoSuchMethodException");
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])new Object[]{NumberUtils.LONG_ONE});
            Assert.fail((String)"should throw NoSuchMethodException");
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])new Object[]{Boolean.TRUE});
            Assert.fail((String)"should throw NoSuchMethodException");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @Test
    public void testGetAccessibleConstructor() throws Exception {
        Assert.assertNotNull((Object)ConstructorUtils.getAccessibleConstructor(Object.class.getConstructor(ArrayUtils.EMPTY_CLASS_ARRAY)));
        Assert.assertNull((Object)ConstructorUtils.getAccessibleConstructor(PrivateClass.class.getConstructor(ArrayUtils.EMPTY_CLASS_ARRAY)));
        Assert.assertNull((Object)ConstructorUtils.getAccessibleConstructor(PrivateClass.PublicInnerClass.class, (Class[])new Class[0]));
    }

    @Test
    public void testGetAccessibleConstructorFromDescription() throws Exception {
        Assert.assertNotNull((Object)ConstructorUtils.getAccessibleConstructor(Object.class, (Class[])ArrayUtils.EMPTY_CLASS_ARRAY));
        Assert.assertNull((Object)ConstructorUtils.getAccessibleConstructor(PrivateClass.class, (Class[])ArrayUtils.EMPTY_CLASS_ARRAY));
    }

    @Test
    public void testGetMatchingAccessibleMethod() throws Exception {
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, ArrayUtils.EMPTY_CLASS_ARRAY, ArrayUtils.EMPTY_CLASS_ARRAY);
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, null, ArrayUtils.EMPTY_CLASS_ARRAY);
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(String.class), this.singletonArray(String.class));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Object.class), this.singletonArray(Object.class));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Boolean.class), this.singletonArray(Object.class));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Byte.class), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Byte.TYPE), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Short.class), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Short.TYPE), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Character.class), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Character.TYPE), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Integer.class), this.singletonArray(Integer.class));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Integer.TYPE), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Long.class), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Long.TYPE), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Float.class), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Float.TYPE), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Double.class), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Double.TYPE), this.singletonArray(Double.TYPE));
    }

    @Test
    public void testNullArgument() {
        this.expectMatchingAccessibleConstructorParameterTypes(MutableObject.class, this.singletonArray(null), this.singletonArray(Object.class));
    }

    private void expectMatchingAccessibleConstructorParameterTypes(Class<?> cls, Class<?>[] requestTypes, Class<?>[] actualTypes) {
        Constructor c = ConstructorUtils.getMatchingAccessibleConstructor(cls, (Class[])requestTypes);
        Assert.assertTrue((String)(this.toString(c.getParameterTypes()) + " not equals " + this.toString(actualTypes)), (boolean)Arrays.equals(actualTypes, c.getParameterTypes()));
    }

    private String toString(Class<?>[] c) {
        return Arrays.asList(c).toString();
    }

    private Class<?>[] singletonArray(Class<?> c) {
        Class<?>[] result = this.classCache.get(c);
        if (result == null) {
            result = new Class[]{c};
            this.classCache.put(c, result);
        }
        return result;
    }

    private static class PrivateClass {

        public static class PublicInnerClass {
        }
    }

    public static class TestBean {
        private final String toString;

        public TestBean() {
            this.toString = "()";
        }

        public TestBean(int i) {
            this.toString = "(int)";
        }

        public TestBean(Integer i) {
            this.toString = "(Integer)";
        }

        public TestBean(double d) {
            this.toString = "(double)";
        }

        public TestBean(String s) {
            this.toString = "(String)";
        }

        public TestBean(Object o) {
            this.toString = "(Object)";
        }

        public String toString() {
            return this.toString;
        }
    }
}

