/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.text.ExtendedMessageFormat;
import org.apache.commons.lang3.text.FormatFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExtendedMessageFormatTest {
    private final Map<String, FormatFactory> registry = new HashMap<String, FormatFactory>();

    @Before
    public void setUp() throws Exception {
        this.registry.put("lower", new LowerCaseFormatFactory());
        this.registry.put("upper", new UpperCaseFormatFactory());
    }

    @Test
    public void testExtendedFormats() {
        String pattern = "Lower: {0,lower} Upper: {1,upper}";
        ExtendedMessageFormat emf = new ExtendedMessageFormat("Lower: {0,lower} Upper: {1,upper}", this.registry);
        this.assertPatternsEqual("TOPATTERN", "Lower: {0,lower} Upper: {1,upper}", emf.toPattern());
        Assert.assertEquals((Object)"Lower: foo Upper: BAR", (Object)emf.format((Object)new Object[]{"foo", "bar"}));
        Assert.assertEquals((Object)"Lower: foo Upper: BAR", (Object)emf.format((Object)new Object[]{"Foo", "Bar"}));
        Assert.assertEquals((Object)"Lower: foo Upper: BAR", (Object)emf.format((Object)new Object[]{"FOO", "BAR"}));
        Assert.assertEquals((Object)"Lower: foo Upper: BAR", (Object)emf.format((Object)new Object[]{"FOO", "bar"}));
        Assert.assertEquals((Object)"Lower: foo Upper: BAR", (Object)emf.format((Object)new Object[]{"foo", "BAR"}));
    }

    @Test
    public void testEscapedQuote_LANG_477() {
        String pattern = "it''s a {0,lower} 'test'!";
        ExtendedMessageFormat emf = new ExtendedMessageFormat("it''s a {0,lower} 'test'!", this.registry);
        Assert.assertEquals((Object)"it's a dummy test!", (Object)emf.format((Object)new Object[]{"DUMMY"}));
    }

    @Test
    public void testEmbeddedPatternInChoice() {
        String pattern = "Hi {0,lower}, got {1,choice,0#none|1#one|1<{1,number}}, {2,upper}!";
        ExtendedMessageFormat emf = new ExtendedMessageFormat("Hi {0,lower}, got {1,choice,0#none|1#one|1<{1,number}}, {2,upper}!", this.registry);
        Assert.assertEquals((Object)emf.format((Object)new Object[]{"there", 3, "great"}), (Object)"Hi there, got 3, GREAT!");
    }

    @Test
    public void testExtendedAndBuiltInFormats() {
        Calendar cal = Calendar.getInstance();
        cal.set(2007, 0, 23, 18, 33, 5);
        Object[] args = new Object[]{"John Doe", cal.getTime(), Double.valueOf("12345.67")};
        String builtinsPattern = "DOB: {1,date,short} Salary: {2,number,currency}";
        String extendedPattern = "Name: {0,upper} ";
        String pattern = "Name: {0,upper} DOB: {1,date,short} Salary: {2,number,currency}";
        HashSet<Locale> testLocales = new HashSet<Locale>();
        testLocales.addAll(Arrays.asList(DateFormat.getAvailableLocales()));
        testLocales.retainAll(Arrays.asList(NumberFormat.getAvailableLocales()));
        testLocales.add(null);
        for (Locale locale : testLocales) {
            MessageFormat builtins = this.createMessageFormat("DOB: {1,date,short} Salary: {2,number,currency}", locale);
            String expectedPattern = "Name: {0,upper} " + builtins.toPattern();
            DateFormat df = null;
            NumberFormat nf = null;
            ExtendedMessageFormat emf = null;
            if (locale == null) {
                df = DateFormat.getDateInstance(3);
                nf = NumberFormat.getCurrencyInstance();
                emf = new ExtendedMessageFormat("Name: {0,upper} DOB: {1,date,short} Salary: {2,number,currency}", this.registry);
            } else {
                df = DateFormat.getDateInstance(3, locale);
                nf = NumberFormat.getCurrencyInstance(locale);
                emf = new ExtendedMessageFormat("Name: {0,upper} DOB: {1,date,short} Salary: {2,number,currency}", locale, this.registry);
            }
            StringBuilder expected = new StringBuilder();
            expected.append("Name: ");
            expected.append(args[0].toString().toUpperCase());
            expected.append(" DOB: ");
            expected.append(df.format(args[1]));
            expected.append(" Salary: ");
            expected.append(nf.format(args[2]));
            this.assertPatternsEqual("pattern comparison for locale " + locale, expectedPattern, emf.toPattern());
            Assert.assertEquals((String)String.valueOf(locale), (Object)expected.toString(), (Object)emf.format((Object)args));
        }
    }

    @Test
    public void testBuiltInChoiceFormat() {
        Number[] values = new Number[]{1, Double.valueOf("2.2"), Double.valueOf("1234.5")};
        String choicePattern = null;
        Locale[] availableLocales = ChoiceFormat.getAvailableLocales();
        choicePattern = "{0,choice,1#One|2#Two|3#Many {0,number}}";
        for (Number value : values) {
            this.checkBuiltInFormat(value + ": " + choicePattern, new Object[]{value}, availableLocales);
        }
        choicePattern = "{0,choice,1#''One''|2#\"Two\"|3#''{Many}'' {0,number}}";
        for (Number value : values) {
            this.checkBuiltInFormat(value + ": " + choicePattern, new Object[]{value}, availableLocales);
        }
    }

    @Test
    public void testBuiltInDateTimeFormat() {
        Calendar cal = Calendar.getInstance();
        cal.set(2007, 0, 23, 18, 33, 5);
        Object[] args = new Object[]{cal.getTime()};
        Locale[] availableLocales = DateFormat.getAvailableLocales();
        this.checkBuiltInFormat("1: {0,date,short}", args, availableLocales);
        this.checkBuiltInFormat("2: {0,date,medium}", args, availableLocales);
        this.checkBuiltInFormat("3: {0,date,long}", args, availableLocales);
        this.checkBuiltInFormat("4: {0,date,full}", args, availableLocales);
        this.checkBuiltInFormat("5: {0,date,d MMM yy}", args, availableLocales);
        this.checkBuiltInFormat("6: {0,time,short}", args, availableLocales);
        this.checkBuiltInFormat("7: {0,time,medium}", args, availableLocales);
        this.checkBuiltInFormat("8: {0,time,long}", args, availableLocales);
        this.checkBuiltInFormat("9: {0,time,full}", args, availableLocales);
        this.checkBuiltInFormat("10: {0,time,HH:mm}", args, availableLocales);
        this.checkBuiltInFormat("11: {0,date}", args, availableLocales);
        this.checkBuiltInFormat("12: {0,time}", args, availableLocales);
    }

    @Test
    public void testOverriddenBuiltinFormat() {
        Calendar cal = Calendar.getInstance();
        cal.set(2007, 0, 23);
        Object[] args = new Object[]{cal.getTime()};
        Locale[] availableLocales = DateFormat.getAvailableLocales();
        Map<String, OverrideShortDateFormatFactory> dateRegistry = Collections.singletonMap("date", new OverrideShortDateFormatFactory());
        this.checkBuiltInFormat("1: {0,date}", dateRegistry, args, availableLocales);
        this.checkBuiltInFormat("2: {0,date,medium}", dateRegistry, args, availableLocales);
        this.checkBuiltInFormat("3: {0,date,long}", dateRegistry, args, availableLocales);
        this.checkBuiltInFormat("4: {0,date,full}", dateRegistry, args, availableLocales);
        this.checkBuiltInFormat("5: {0,date,d MMM yy}", dateRegistry, args, availableLocales);
        for (int i = -1; i < availableLocales.length; ++i) {
            Locale locale = i < 0 ? null : availableLocales[i];
            MessageFormat dateDefault = this.createMessageFormat("{0,date}", locale);
            String pattern = "{0,date,short}";
            ExtendedMessageFormat dateShort = new ExtendedMessageFormat("{0,date,short}", locale, dateRegistry);
            Assert.assertEquals((String)"overridden date,short format", (Object)dateDefault.format(args), (Object)dateShort.format((Object)args));
            Assert.assertEquals((String)"overridden date,short pattern", (Object)"{0,date,short}", (Object)dateShort.toPattern());
        }
    }

    @Test
    public void testBuiltInNumberFormat() {
        Object[] args = new Object[]{Double.valueOf("6543.21")};
        Locale[] availableLocales = NumberFormat.getAvailableLocales();
        this.checkBuiltInFormat("1: {0,number}", args, availableLocales);
        this.checkBuiltInFormat("2: {0,number,integer}", args, availableLocales);
        this.checkBuiltInFormat("3: {0,number,currency}", args, availableLocales);
        this.checkBuiltInFormat("4: {0,number,percent}", args, availableLocales);
        this.checkBuiltInFormat("5: {0,number,00000.000}", args, availableLocales);
    }

    @Test
    public void testEqualsHashcode() {
        Map<String, LowerCaseFormatFactory> fmtRegistry = Collections.singletonMap("testfmt", new LowerCaseFormatFactory());
        Map<String, UpperCaseFormatFactory> otherRegitry = Collections.singletonMap("testfmt", new UpperCaseFormatFactory());
        String pattern = "Pattern: {0,testfmt}";
        ExtendedMessageFormat emf = new ExtendedMessageFormat("Pattern: {0,testfmt}", Locale.US, fmtRegistry);
        ExtendedMessageFormat other = null;
        Assert.assertTrue((String)"same, equals()", (boolean)emf.equals((Object)emf));
        Assert.assertTrue((String)"same, hashcode()", (emf.hashCode() == emf.hashCode() ? 1 : 0) != 0);
        other = new ExtendedMessageFormat("Pattern: {0,testfmt}", Locale.US, fmtRegistry);
        Assert.assertTrue((String)"equal, equals()", (boolean)emf.equals((Object)other));
        Assert.assertTrue((String)"equal, hashcode()", (emf.hashCode() == other.hashCode() ? 1 : 0) != 0);
        other = new OtherExtendedMessageFormat("Pattern: {0,testfmt}", Locale.US, fmtRegistry);
        Assert.assertFalse((String)"class, equals()", (boolean)emf.equals((Object)other));
        Assert.assertTrue((String)"class, hashcode()", (emf.hashCode() == other.hashCode() ? 1 : 0) != 0);
        other = new ExtendedMessageFormat("XPattern: {0,testfmt}", Locale.US, fmtRegistry);
        Assert.assertFalse((String)"pattern, equals()", (boolean)emf.equals((Object)other));
        Assert.assertFalse((String)"pattern, hashcode()", (emf.hashCode() == other.hashCode() ? 1 : 0) != 0);
        other = new ExtendedMessageFormat("Pattern: {0,testfmt}", Locale.US, otherRegitry);
        Assert.assertFalse((String)"registry, equals()", (boolean)emf.equals((Object)other));
        Assert.assertFalse((String)"registry, hashcode()", (emf.hashCode() == other.hashCode() ? 1 : 0) != 0);
        other = new ExtendedMessageFormat("Pattern: {0,testfmt}", Locale.FRANCE, fmtRegistry);
        Assert.assertFalse((String)"locale, equals()", (boolean)emf.equals((Object)other));
        Assert.assertTrue((String)"locale, hashcode()", (emf.hashCode() == other.hashCode() ? 1 : 0) != 0);
    }

    private void checkBuiltInFormat(String pattern, Object[] args, Locale[] locales) {
        this.checkBuiltInFormat(pattern, null, args, locales);
    }

    private void checkBuiltInFormat(String pattern, Map<String, ?> fmtRegistry, Object[] args, Locale[] locales) {
        this.checkBuiltInFormat(pattern, fmtRegistry, args, (Locale)null);
        for (Locale locale : locales) {
            this.checkBuiltInFormat(pattern, fmtRegistry, args, locale);
        }
    }

    private void checkBuiltInFormat(String pattern, Map<String, ?> registryUnused, Object[] args, Locale locale) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Pattern=[");
        buffer.append(pattern);
        buffer.append("], locale=[");
        buffer.append(locale);
        buffer.append("]");
        MessageFormat mf = this.createMessageFormat(pattern, locale);
        ExtendedMessageFormat emf = null;
        emf = locale == null ? new ExtendedMessageFormat(pattern) : new ExtendedMessageFormat(pattern, locale);
        Assert.assertEquals((String)("format " + buffer.toString()), (Object)mf.format(args), (Object)emf.format((Object)args));
        this.assertPatternsEqual("toPattern " + buffer.toString(), mf.toPattern(), emf.toPattern());
    }

    private void assertPatternsEqual(String message, String expected, String actual) {
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4)) {
            Assert.assertEquals((String)message, (Object)expected, (Object)actual);
        }
    }

    private MessageFormat createMessageFormat(String pattern, Locale locale) {
        MessageFormat result = new MessageFormat(pattern);
        if (locale != null) {
            result.setLocale(locale);
            result.applyPattern(pattern);
        }
        return result;
    }

    private static class OtherExtendedMessageFormat
    extends ExtendedMessageFormat {
        private static final long serialVersionUID = 1L;

        public OtherExtendedMessageFormat(String pattern, Locale locale, Map<String, ? extends FormatFactory> registry) {
            super(pattern, locale, registry);
        }
    }

    private static class OverrideShortDateFormatFactory
    implements FormatFactory {
        private OverrideShortDateFormatFactory() {
        }

        public Format getFormat(String name, String arguments, Locale locale) {
            return !"short".equals(arguments) ? null : (locale == null ? DateFormat.getDateInstance(2) : DateFormat.getDateInstance(2, locale));
        }
    }

    private static class UpperCaseFormatFactory
    implements FormatFactory {
        private static final Format UPPER_INSTANCE = new UpperCaseFormat();

        private UpperCaseFormatFactory() {
        }

        public Format getFormat(String name, String arguments, Locale locale) {
            return UPPER_INSTANCE;
        }
    }

    private static class LowerCaseFormatFactory
    implements FormatFactory {
        private static final Format LOWER_INSTANCE = new LowerCaseFormat();

        private LowerCaseFormatFactory() {
        }

        public Format getFormat(String name, String arguments, Locale locale) {
            return LOWER_INSTANCE;
        }
    }

    private static class UpperCaseFormat
    extends Format {
        private static final long serialVersionUID = 1L;

        private UpperCaseFormat() {
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(((String)obj).toUpperCase());
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            throw new UnsupportedOperationException();
        }
    }

    private static class LowerCaseFormat
    extends Format {
        private static final long serialVersionUID = 1L;

        private LowerCaseFormat() {
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(((String)obj).toLowerCase());
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            throw new UnsupportedOperationException();
        }
    }
}

