/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text.translate;

import org.apache.commons.lang3.text.translate.NumericEntityUnescaper;
import org.junit.Assert;
import org.junit.Test;

public class NumericEntityUnescaperTest {
    @Test
    public void testSupplementaryUnescaping() {
        NumericEntityUnescaper neu = new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0]);
        String input = "&#68642;";
        String expected = "\ud803\udc22";
        String result = neu.translate((CharSequence)"&#68642;");
        Assert.assertEquals((String)"Failed to unescape numeric entities supplementary characters", (Object)"\ud803\udc22", (Object)result);
    }

    @Test
    public void testOutOfBounds() {
        NumericEntityUnescaper neu = new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0]);
        Assert.assertEquals((String)"Failed to ignore when last character is &", (Object)"Test &", (Object)neu.translate((CharSequence)"Test &"));
        Assert.assertEquals((String)"Failed to ignore when last character is &", (Object)"Test &#", (Object)neu.translate((CharSequence)"Test &#"));
        Assert.assertEquals((String)"Failed to ignore when last character is &", (Object)"Test &#x", (Object)neu.translate((CharSequence)"Test &#x"));
        Assert.assertEquals((String)"Failed to ignore when last character is &", (Object)"Test &#X", (Object)neu.translate((CharSequence)"Test &#X"));
    }

    @Test
    public void testUnfinishedEntity() {
        NumericEntityUnescaper neu = new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[]{NumericEntityUnescaper.OPTION.semiColonOptional});
        String input = "Test &#x30 not test";
        String expected = "Test 0 not test";
        String result = neu.translate((CharSequence)input);
        Assert.assertEquals((String)"Failed to support unfinished entities (i.e. missing semi-colon)", (Object)expected, (Object)result);
        neu = new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0]);
        expected = input = "Test &#x30 not test";
        result = neu.translate((CharSequence)input);
        Assert.assertEquals((String)"Failed to ignore unfinished entities (i.e. missing semi-colon)", (Object)expected, (Object)result);
        neu = new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[]{NumericEntityUnescaper.OPTION.errorIfNoSemiColon});
        input = "Test &#x30 not test";
        try {
            result = neu.translate((CharSequence)input);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
    }
}

