/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.junit.Assert;
import org.junit.Test;

public class DateFormatUtilsTest {
    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)new DateFormatUtils());
        Constructor<?>[] cons = DateFormatUtils.class.getDeclaredConstructors();
        Assert.assertEquals((long)1L, (long)cons.length);
        Assert.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assert.assertTrue((boolean)Modifier.isPublic(DateFormatUtils.class.getModifiers()));
        Assert.assertFalse((boolean)Modifier.isFinal(DateFormatUtils.class.getModifiers()));
    }

    @Test
    public void testFormat() {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        c.set(2005, 0, 1, 12, 0, 0);
        c.setTimeZone(TimeZone.getDefault());
        StringBuilder buffer = new StringBuilder();
        int year = c.get(1);
        int month = c.get(2) + 1;
        int day = c.get(5);
        int hour = c.get(11);
        buffer.append(year);
        buffer.append(month);
        buffer.append(day);
        buffer.append(hour);
        Assert.assertEquals((Object)buffer.toString(), (Object)DateFormatUtils.format((Date)c.getTime(), (String)"yyyyMdH"));
        Assert.assertEquals((Object)buffer.toString(), (Object)DateFormatUtils.format((long)c.getTime().getTime(), (String)"yyyyMdH"));
        Assert.assertEquals((Object)buffer.toString(), (Object)DateFormatUtils.format((Date)c.getTime(), (String)"yyyyMdH", (Locale)Locale.US));
        Assert.assertEquals((Object)buffer.toString(), (Object)DateFormatUtils.format((long)c.getTime().getTime(), (String)"yyyyMdH", (Locale)Locale.US));
    }

    @Test
    public void testFormatCalendar() {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        c.set(2005, 0, 1, 12, 0, 0);
        c.setTimeZone(TimeZone.getDefault());
        StringBuilder buffer = new StringBuilder();
        int year = c.get(1);
        int month = c.get(2) + 1;
        int day = c.get(5);
        int hour = c.get(11);
        buffer.append(year);
        buffer.append(month);
        buffer.append(day);
        buffer.append(hour);
        Assert.assertEquals((Object)buffer.toString(), (Object)DateFormatUtils.format((Calendar)c, (String)"yyyyMdH"));
        Assert.assertEquals((Object)buffer.toString(), (Object)DateFormatUtils.format((Date)c.getTime(), (String)"yyyyMdH"));
        Assert.assertEquals((Object)buffer.toString(), (Object)DateFormatUtils.format((Calendar)c, (String)"yyyyMdH", (Locale)Locale.US));
        Assert.assertEquals((Object)buffer.toString(), (Object)DateFormatUtils.format((Date)c.getTime(), (String)"yyyyMdH", (Locale)Locale.US));
    }

    @Test
    public void testFormatUTC() {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        c.set(2005, 0, 1, 12, 0, 0);
        Assert.assertEquals((Object)"2005-01-01T12:00:00", (Object)DateFormatUtils.formatUTC((Date)c.getTime(), (String)DateFormatUtils.ISO_DATETIME_FORMAT.getPattern()));
        Assert.assertEquals((Object)"2005-01-01T12:00:00", (Object)DateFormatUtils.formatUTC((long)c.getTime().getTime(), (String)DateFormatUtils.ISO_DATETIME_FORMAT.getPattern()));
        Assert.assertEquals((Object)"2005-01-01T12:00:00", (Object)DateFormatUtils.formatUTC((Date)c.getTime(), (String)DateFormatUtils.ISO_DATETIME_FORMAT.getPattern(), (Locale)Locale.US));
        Assert.assertEquals((Object)"2005-01-01T12:00:00", (Object)DateFormatUtils.formatUTC((long)c.getTime().getTime(), (String)DateFormatUtils.ISO_DATETIME_FORMAT.getPattern(), (Locale)Locale.US));
    }

    @Test
    public void testDateTimeISO() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT-3");
        Calendar cal = Calendar.getInstance(timeZone);
        cal.set(2002, 1, 23, 9, 11, 12);
        String text = DateFormatUtils.format((Date)cal.getTime(), (String)DateFormatUtils.ISO_DATETIME_FORMAT.getPattern(), (TimeZone)timeZone);
        Assert.assertEquals((Object)"2002-02-23T09:11:12", (Object)text);
        text = DateFormatUtils.format((long)cal.getTime().getTime(), (String)DateFormatUtils.ISO_DATETIME_FORMAT.getPattern(), (TimeZone)timeZone);
        Assert.assertEquals((Object)"2002-02-23T09:11:12", (Object)text);
        text = DateFormatUtils.ISO_DATETIME_FORMAT.format(cal);
        Assert.assertEquals((Object)"2002-02-23T09:11:12", (Object)text);
        text = DateFormatUtils.format((Date)cal.getTime(), (String)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern(), (TimeZone)timeZone);
        Assert.assertEquals((Object)"2002-02-23T09:11:12-03:00", (Object)text);
        text = DateFormatUtils.format((long)cal.getTime().getTime(), (String)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern(), (TimeZone)timeZone);
        Assert.assertEquals((Object)"2002-02-23T09:11:12-03:00", (Object)text);
        text = DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(cal);
        Assert.assertEquals((Object)"2002-02-23T09:11:12-03:00", (Object)text);
    }

    @Test
    public void testDateISO() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT-3");
        Calendar cal = Calendar.getInstance(timeZone);
        cal.set(2002, 1, 23, 10, 11, 12);
        String text = DateFormatUtils.format((Date)cal.getTime(), (String)DateFormatUtils.ISO_DATE_FORMAT.getPattern(), (TimeZone)timeZone);
        Assert.assertEquals((Object)"2002-02-23", (Object)text);
        text = DateFormatUtils.format((long)cal.getTime().getTime(), (String)DateFormatUtils.ISO_DATE_FORMAT.getPattern(), (TimeZone)timeZone);
        Assert.assertEquals((Object)"2002-02-23", (Object)text);
        text = DateFormatUtils.ISO_DATE_FORMAT.format(cal);
        Assert.assertEquals((Object)"2002-02-23", (Object)text);
        text = DateFormatUtils.format((Date)cal.getTime(), (String)DateFormatUtils.ISO_DATE_TIME_ZONE_FORMAT.getPattern(), (TimeZone)timeZone);
        Assert.assertEquals((Object)"2002-02-23-03:00", (Object)text);
        text = DateFormatUtils.format((long)cal.getTime().getTime(), (String)DateFormatUtils.ISO_DATE_TIME_ZONE_FORMAT.getPattern(), (TimeZone)timeZone);
        Assert.assertEquals((Object)"2002-02-23-03:00", (Object)text);
        text = DateFormatUtils.ISO_DATE_TIME_ZONE_FORMAT.format(cal);
        Assert.assertEquals((Object)"2002-02-23-03:00", (Object)text);
    }

    @Test
    public void testTimeISO() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT-3");
        Calendar cal = Calendar.getInstance(timeZone);
        cal.set(2002, 1, 23, 10, 11, 12);
        String text = DateFormatUtils.format((Date)cal.getTime(), (String)DateFormatUtils.ISO_TIME_FORMAT.getPattern(), (TimeZone)timeZone);
        Assert.assertEquals((Object)"T10:11:12", (Object)text);
        text = DateFormatUtils.format((long)cal.getTime().getTime(), (String)DateFormatUtils.ISO_TIME_FORMAT.getPattern(), (TimeZone)timeZone);
        Assert.assertEquals((Object)"T10:11:12", (Object)text);
        text = DateFormatUtils.ISO_TIME_FORMAT.format(cal);
        Assert.assertEquals((Object)"T10:11:12", (Object)text);
        text = DateFormatUtils.format((Date)cal.getTime(), (String)DateFormatUtils.ISO_TIME_TIME_ZONE_FORMAT.getPattern(), (TimeZone)timeZone);
        Assert.assertEquals((Object)"T10:11:12-03:00", (Object)text);
        text = DateFormatUtils.format((long)cal.getTime().getTime(), (String)DateFormatUtils.ISO_TIME_TIME_ZONE_FORMAT.getPattern(), (TimeZone)timeZone);
        Assert.assertEquals((Object)"T10:11:12-03:00", (Object)text);
        text = DateFormatUtils.ISO_TIME_TIME_ZONE_FORMAT.format(cal);
        Assert.assertEquals((Object)"T10:11:12-03:00", (Object)text);
    }

    @Test
    public void testTimeNoTISO() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT-3");
        Calendar cal = Calendar.getInstance(timeZone);
        cal.set(2002, 1, 23, 10, 11, 12);
        String text = DateFormatUtils.format((Date)cal.getTime(), (String)DateFormatUtils.ISO_TIME_NO_T_FORMAT.getPattern(), (TimeZone)timeZone);
        Assert.assertEquals((Object)"10:11:12", (Object)text);
        text = DateFormatUtils.format((long)cal.getTime().getTime(), (String)DateFormatUtils.ISO_TIME_NO_T_FORMAT.getPattern(), (TimeZone)timeZone);
        Assert.assertEquals((Object)"10:11:12", (Object)text);
        text = DateFormatUtils.ISO_TIME_NO_T_FORMAT.format(cal);
        Assert.assertEquals((Object)"10:11:12", (Object)text);
        text = DateFormatUtils.format((Date)cal.getTime(), (String)DateFormatUtils.ISO_TIME_NO_T_TIME_ZONE_FORMAT.getPattern(), (TimeZone)timeZone);
        Assert.assertEquals((Object)"10:11:12-03:00", (Object)text);
        text = DateFormatUtils.format((long)cal.getTime().getTime(), (String)DateFormatUtils.ISO_TIME_NO_T_TIME_ZONE_FORMAT.getPattern(), (TimeZone)timeZone);
        Assert.assertEquals((Object)"10:11:12-03:00", (Object)text);
        text = DateFormatUtils.ISO_TIME_NO_T_TIME_ZONE_FORMAT.format(cal);
        Assert.assertEquals((Object)"10:11:12-03:00", (Object)text);
    }

    @Test
    public void testSMTP() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT-3");
        Calendar cal = Calendar.getInstance(timeZone);
        cal.set(2003, 5, 8, 10, 11, 12);
        String text = DateFormatUtils.format((Date)cal.getTime(), (String)DateFormatUtils.SMTP_DATETIME_FORMAT.getPattern(), (TimeZone)timeZone, (Locale)DateFormatUtils.SMTP_DATETIME_FORMAT.getLocale());
        Assert.assertEquals((Object)"Sun, 08 Jun 2003 10:11:12 -0300", (Object)text);
        text = DateFormatUtils.format((long)cal.getTime().getTime(), (String)DateFormatUtils.SMTP_DATETIME_FORMAT.getPattern(), (TimeZone)timeZone, (Locale)DateFormatUtils.SMTP_DATETIME_FORMAT.getLocale());
        Assert.assertEquals((Object)"Sun, 08 Jun 2003 10:11:12 -0300", (Object)text);
        text = DateFormatUtils.SMTP_DATETIME_FORMAT.format(cal);
        Assert.assertEquals((Object)"Sun, 08 Jun 2003 10:11:12 -0300", (Object)text);
        text = DateFormatUtils.formatUTC((long)cal.getTime().getTime(), (String)DateFormatUtils.SMTP_DATETIME_FORMAT.getPattern(), (Locale)DateFormatUtils.SMTP_DATETIME_FORMAT.getLocale());
        Assert.assertEquals((Object)"Sun, 08 Jun 2003 13:11:12 +0000", (Object)text);
    }
}

