/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.time.FastDateFormat;
import org.junit.Assert;
import org.junit.Test;

public class FastDateFormatTest {
    private static final int NTHREADS = 10;
    private static final int NROUNDS = 10000;

    @Test
    public void test_getInstance() {
        FastDateFormat format1 = FastDateFormat.getInstance();
        FastDateFormat format2 = FastDateFormat.getInstance();
        Assert.assertSame((Object)format1, (Object)format2);
    }

    @Test
    public void test_getInstance_String() {
        FastDateFormat format1 = FastDateFormat.getInstance((String)"MM/DD/yyyy");
        FastDateFormat format2 = FastDateFormat.getInstance((String)"MM-DD-yyyy");
        FastDateFormat format3 = FastDateFormat.getInstance((String)"MM-DD-yyyy");
        Assert.assertTrue((format1 != format2 ? 1 : 0) != 0);
        Assert.assertSame((Object)format2, (Object)format3);
        Assert.assertEquals((Object)"MM/DD/yyyy", (Object)format1.getPattern());
        Assert.assertEquals((Object)TimeZone.getDefault(), (Object)format1.getTimeZone());
        Assert.assertEquals((Object)TimeZone.getDefault(), (Object)format2.getTimeZone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_getInstance_String_TimeZone() {
        Locale realDefaultLocale = Locale.getDefault();
        TimeZone realDefaultZone = TimeZone.getDefault();
        try {
            Locale.setDefault(Locale.US);
            TimeZone.setDefault(TimeZone.getTimeZone("America/New_York"));
            FastDateFormat format1 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (TimeZone)TimeZone.getTimeZone("Atlantic/Reykjavik"));
            FastDateFormat format2 = FastDateFormat.getInstance((String)"MM/DD/yyyy");
            FastDateFormat format3 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (TimeZone)TimeZone.getDefault());
            FastDateFormat format4 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (TimeZone)TimeZone.getDefault());
            FastDateFormat format5 = FastDateFormat.getInstance((String)"MM-DD-yyyy", (TimeZone)TimeZone.getDefault());
            FastDateFormat format6 = FastDateFormat.getInstance((String)"MM-DD-yyyy");
            Assert.assertTrue((format1 != format2 ? 1 : 0) != 0);
            Assert.assertEquals((Object)TimeZone.getTimeZone("Atlantic/Reykjavik"), (Object)format1.getTimeZone());
            Assert.assertEquals((Object)TimeZone.getDefault(), (Object)format2.getTimeZone());
            Assert.assertSame((Object)format3, (Object)format4);
            Assert.assertTrue((format3 != format5 ? 1 : 0) != 0);
            Assert.assertTrue((format4 != format6 ? 1 : 0) != 0);
        }
        finally {
            Locale.setDefault(realDefaultLocale);
            TimeZone.setDefault(realDefaultZone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_getInstance_String_Locale() {
        Locale realDefaultLocale = Locale.getDefault();
        try {
            Locale.setDefault(Locale.US);
            FastDateFormat format1 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (Locale)Locale.GERMANY);
            FastDateFormat format2 = FastDateFormat.getInstance((String)"MM/DD/yyyy");
            FastDateFormat format3 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (Locale)Locale.GERMANY);
            Assert.assertTrue((format1 != format2 ? 1 : 0) != 0);
            Assert.assertSame((Object)format1, (Object)format3);
            Assert.assertEquals((Object)Locale.GERMANY, (Object)format1.getLocale());
        }
        finally {
            Locale.setDefault(realDefaultLocale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_changeDefault_Locale_DateInstance() {
        Locale realDefaultLocale = Locale.getDefault();
        try {
            Locale.setDefault(Locale.US);
            FastDateFormat format1 = FastDateFormat.getDateInstance((int)0, (Locale)Locale.GERMANY);
            FastDateFormat format2 = FastDateFormat.getDateInstance((int)0);
            Locale.setDefault(Locale.GERMANY);
            FastDateFormat format3 = FastDateFormat.getDateInstance((int)0);
            Assert.assertSame((Object)Locale.GERMANY, (Object)format1.getLocale());
            Assert.assertSame((Object)Locale.US, (Object)format2.getLocale());
            Assert.assertSame((Object)Locale.GERMANY, (Object)format3.getLocale());
            Assert.assertTrue((format1 != format2 ? 1 : 0) != 0);
            Assert.assertTrue((format2 != format3 ? 1 : 0) != 0);
        }
        finally {
            Locale.setDefault(realDefaultLocale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_changeDefault_Locale_DateTimeInstance() {
        Locale realDefaultLocale = Locale.getDefault();
        try {
            Locale.setDefault(Locale.US);
            FastDateFormat format1 = FastDateFormat.getDateTimeInstance((int)0, (int)0, (Locale)Locale.GERMANY);
            FastDateFormat format2 = FastDateFormat.getDateTimeInstance((int)0, (int)0);
            Locale.setDefault(Locale.GERMANY);
            FastDateFormat format3 = FastDateFormat.getDateTimeInstance((int)0, (int)0);
            Assert.assertSame((Object)Locale.GERMANY, (Object)format1.getLocale());
            Assert.assertSame((Object)Locale.US, (Object)format2.getLocale());
            Assert.assertSame((Object)Locale.GERMANY, (Object)format3.getLocale());
            Assert.assertTrue((format1 != format2 ? 1 : 0) != 0);
            Assert.assertTrue((format2 != format3 ? 1 : 0) != 0);
        }
        finally {
            Locale.setDefault(realDefaultLocale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_getInstance_String_TimeZone_Locale() {
        Locale realDefaultLocale = Locale.getDefault();
        TimeZone realDefaultZone = TimeZone.getDefault();
        try {
            Locale.setDefault(Locale.US);
            TimeZone.setDefault(TimeZone.getTimeZone("America/New_York"));
            FastDateFormat format1 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (TimeZone)TimeZone.getTimeZone("Atlantic/Reykjavik"), (Locale)Locale.GERMANY);
            FastDateFormat format2 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (Locale)Locale.GERMANY);
            FastDateFormat format3 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (TimeZone)TimeZone.getDefault(), (Locale)Locale.GERMANY);
            Assert.assertTrue((format1 != format2 ? 1 : 0) != 0);
            Assert.assertEquals((Object)TimeZone.getTimeZone("Atlantic/Reykjavik"), (Object)format1.getTimeZone());
            Assert.assertEquals((Object)TimeZone.getDefault(), (Object)format2.getTimeZone());
            Assert.assertEquals((Object)TimeZone.getDefault(), (Object)format3.getTimeZone());
            Assert.assertEquals((Object)Locale.GERMANY, (Object)format1.getLocale());
            Assert.assertEquals((Object)Locale.GERMANY, (Object)format2.getLocale());
            Assert.assertEquals((Object)Locale.GERMANY, (Object)format3.getLocale());
        }
        finally {
            Locale.setDefault(realDefaultLocale);
            TimeZone.setDefault(realDefaultZone);
        }
    }

    @Test
    public void testCheckDefaults() {
        FastDateFormat format = FastDateFormat.getInstance();
        FastDateFormat medium = FastDateFormat.getDateTimeInstance((int)3, (int)3);
        Assert.assertEquals((Object)medium, (Object)format);
        SimpleDateFormat sdf = new SimpleDateFormat();
        Assert.assertEquals((Object)sdf.toPattern(), (Object)format.getPattern());
        Assert.assertEquals((Object)Locale.getDefault(), (Object)format.getLocale());
        Assert.assertEquals((Object)TimeZone.getDefault(), (Object)format.getTimeZone());
    }

    @Test
    public void testCheckDifferingStyles() {
        FastDateFormat shortShort = FastDateFormat.getDateTimeInstance((int)3, (int)3, (Locale)Locale.US);
        FastDateFormat shortLong = FastDateFormat.getDateTimeInstance((int)3, (int)1, (Locale)Locale.US);
        FastDateFormat longShort = FastDateFormat.getDateTimeInstance((int)1, (int)3, (Locale)Locale.US);
        FastDateFormat longLong = FastDateFormat.getDateTimeInstance((int)1, (int)1, (Locale)Locale.US);
        Assert.assertFalse((boolean)shortShort.equals((Object)shortLong));
        Assert.assertFalse((boolean)shortShort.equals((Object)longShort));
        Assert.assertFalse((boolean)shortShort.equals((Object)longLong));
        Assert.assertFalse((boolean)shortLong.equals((Object)longShort));
        Assert.assertFalse((boolean)shortLong.equals((Object)longLong));
        Assert.assertFalse((boolean)longShort.equals((Object)longLong));
    }

    @Test
    public void testDateDefaults() {
        Assert.assertEquals((Object)FastDateFormat.getDateInstance((int)1, (Locale)Locale.CANADA), (Object)FastDateFormat.getDateInstance((int)1, (TimeZone)TimeZone.getDefault(), (Locale)Locale.CANADA));
        Assert.assertEquals((Object)FastDateFormat.getDateInstance((int)1, (TimeZone)TimeZone.getTimeZone("America/New_York")), (Object)FastDateFormat.getDateInstance((int)1, (TimeZone)TimeZone.getTimeZone("America/New_York"), (Locale)Locale.getDefault()));
        Assert.assertEquals((Object)FastDateFormat.getDateInstance((int)1), (Object)FastDateFormat.getDateInstance((int)1, (TimeZone)TimeZone.getDefault(), (Locale)Locale.getDefault()));
    }

    @Test
    public void testTimeDefaults() {
        Assert.assertEquals((Object)FastDateFormat.getTimeInstance((int)1, (Locale)Locale.CANADA), (Object)FastDateFormat.getTimeInstance((int)1, (TimeZone)TimeZone.getDefault(), (Locale)Locale.CANADA));
        Assert.assertEquals((Object)FastDateFormat.getTimeInstance((int)1, (TimeZone)TimeZone.getTimeZone("America/New_York")), (Object)FastDateFormat.getTimeInstance((int)1, (TimeZone)TimeZone.getTimeZone("America/New_York"), (Locale)Locale.getDefault()));
        Assert.assertEquals((Object)FastDateFormat.getTimeInstance((int)1), (Object)FastDateFormat.getTimeInstance((int)1, (TimeZone)TimeZone.getDefault(), (Locale)Locale.getDefault()));
    }

    @Test
    public void testTimeDateDefaults() {
        Assert.assertEquals((Object)FastDateFormat.getDateTimeInstance((int)1, (int)2, (Locale)Locale.CANADA), (Object)FastDateFormat.getDateTimeInstance((int)1, (int)2, (TimeZone)TimeZone.getDefault(), (Locale)Locale.CANADA));
        Assert.assertEquals((Object)FastDateFormat.getDateTimeInstance((int)1, (int)2, (TimeZone)TimeZone.getTimeZone("America/New_York")), (Object)FastDateFormat.getDateTimeInstance((int)1, (int)2, (TimeZone)TimeZone.getTimeZone("America/New_York"), (Locale)Locale.getDefault()));
        Assert.assertEquals((Object)FastDateFormat.getDateTimeInstance((int)1, (int)2), (Object)FastDateFormat.getDateTimeInstance((int)1, (int)2, (TimeZone)TimeZone.getDefault(), (Locale)Locale.getDefault()));
    }

    @Test
    public void testLang954() throws Exception {
        String pattern = "yyyy-MM-dd'T'";
        FastDateFormat.getInstance((String)pattern);
    }

    @Test
    public void testParseSync() throws InterruptedException {
        String pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS Z";
        FastDateFormat formatter = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSS Z");
        long sdfTime = this.measureTime((Format)formatter, new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS Z"){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object parseObject(String formattedDate) throws ParseException {
                1 var2_2 = this;
                synchronized (var2_2) {
                    return super.parse(formattedDate);
                }
            }
        });
        long fdfTime = this.measureTime((Format)formatter, (Format)FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSS Z"));
        String times = ">>FastDateFormatTest: FastDateParser:" + fdfTime + "  SimpleDateFormat:" + sdfTime;
        System.out.println(times);
    }

    private long measureTime(final Format formatter, final Format parser) throws InterruptedException {
        ExecutorService pool = Executors.newFixedThreadPool(10);
        final AtomicInteger failures = new AtomicInteger(0);
        final AtomicLong totalElapsed = new AtomicLong(0L);
        for (int i = 0; i < 10; ++i) {
            pool.submit(new Runnable(){

                @Override
                public void run() {
                    for (int j = 0; j < 10000; ++j) {
                        try {
                            Date date = new Date();
                            String formattedDate = formatter.format(date);
                            long start = System.currentTimeMillis();
                            Object pd = parser.parseObject(formattedDate);
                            totalElapsed.addAndGet(System.currentTimeMillis() - start);
                            if (date.equals(pd)) continue;
                            failures.incrementAndGet();
                            continue;
                        }
                        catch (Exception e) {
                            failures.incrementAndGet();
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        pool.shutdown();
        if (!pool.awaitTermination(20L, TimeUnit.SECONDS)) {
            pool.shutdownNow();
            Assert.fail((String)"did not complete tasks");
        }
        Assert.assertEquals((long)0L, (long)failures.get());
        return totalElapsed.get();
    }
}

