/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import org.apache.commons.lang3.time.StopWatch;
import org.junit.Assert;
import org.junit.Test;

public class StopWatchTest {
    @Test
    public void testStopWatchSimple() {
        StopWatch watch = new StopWatch();
        watch.start();
        try {
            Thread.sleep(550L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        watch.stop();
        long time = watch.getTime();
        Assert.assertEquals((long)time, (long)watch.getTime());
        Assert.assertTrue((time >= 500L ? 1 : 0) != 0);
        Assert.assertTrue((time < 700L ? 1 : 0) != 0);
        watch.reset();
        Assert.assertEquals((long)0L, (long)watch.getTime());
    }

    @Test
    public void testStopWatchSimpleGet() {
        StopWatch watch = new StopWatch();
        Assert.assertEquals((long)0L, (long)watch.getTime());
        Assert.assertEquals((Object)"0:00:00.000", (Object)watch.toString());
        watch.start();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((watch.getTime() < 2000L ? 1 : 0) != 0);
    }

    @Test
    public void testStopWatchSplit() {
        StopWatch watch = new StopWatch();
        watch.start();
        try {
            Thread.sleep(550L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        watch.split();
        long splitTime = watch.getSplitTime();
        String splitStr = watch.toSplitString();
        try {
            Thread.sleep(550L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        watch.unsplit();
        try {
            Thread.sleep(550L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        watch.stop();
        long totalTime = watch.getTime();
        Assert.assertEquals((String)"Formatted split string not the correct length", (long)splitStr.length(), (long)11L);
        Assert.assertTrue((splitTime >= 500L ? 1 : 0) != 0);
        Assert.assertTrue((splitTime < 700L ? 1 : 0) != 0);
        Assert.assertTrue((totalTime >= 1500L ? 1 : 0) != 0);
        Assert.assertTrue((totalTime < 1900L ? 1 : 0) != 0);
    }

    @Test
    public void testStopWatchSuspend() {
        StopWatch watch = new StopWatch();
        watch.start();
        try {
            Thread.sleep(550L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        watch.suspend();
        long suspendTime = watch.getTime();
        try {
            Thread.sleep(550L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        watch.resume();
        try {
            Thread.sleep(550L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        watch.stop();
        long totalTime = watch.getTime();
        Assert.assertTrue((suspendTime >= 500L ? 1 : 0) != 0);
        Assert.assertTrue((suspendTime < 700L ? 1 : 0) != 0);
        Assert.assertTrue((totalTime >= 1000L ? 1 : 0) != 0);
        Assert.assertTrue((totalTime < 1300L ? 1 : 0) != 0);
    }

    @Test
    public void testLang315() {
        StopWatch watch = new StopWatch();
        watch.start();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        watch.suspend();
        long suspendTime = watch.getTime();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        watch.stop();
        long totalTime = watch.getTime();
        Assert.assertTrue((suspendTime == totalTime ? 1 : 0) != 0);
    }

    @Test
    public void testBadStates() {
        StopWatch watch = new StopWatch();
        try {
            watch.stop();
            Assert.fail((String)"Calling stop on an unstarted StopWatch should throw an exception. ");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            watch.stop();
            Assert.fail((String)"Calling stop on an unstarted StopWatch should throw an exception. ");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            watch.suspend();
            Assert.fail((String)"Calling suspend on an unstarted StopWatch should throw an exception. ");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            watch.split();
            Assert.fail((String)"Calling split on a non-running StopWatch should throw an exception. ");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            watch.unsplit();
            Assert.fail((String)"Calling unsplit on an unsplit StopWatch should throw an exception. ");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            watch.resume();
            Assert.fail((String)"Calling resume on an unsuspended StopWatch should throw an exception. ");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        watch.start();
        try {
            watch.start();
            Assert.fail((String)"Calling start on a started StopWatch should throw an exception. ");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            watch.unsplit();
            Assert.fail((String)"Calling unsplit on an unsplit StopWatch should throw an exception. ");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            watch.getSplitTime();
            Assert.fail((String)"Calling getSplitTime on an unsplit StopWatch should throw an exception. ");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            watch.resume();
            Assert.fail((String)"Calling resume on an unsuspended StopWatch should throw an exception. ");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        watch.stop();
        try {
            watch.start();
            Assert.fail((String)"Calling start on a stopped StopWatch should throw an exception as it needs to be reset. ");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testGetStartTime() {
        long beforeStopWatch = System.currentTimeMillis();
        StopWatch watch = new StopWatch();
        try {
            watch.getStartTime();
            Assert.fail((String)"Calling getStartTime on an unstarted StopWatch should throw an exception");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        watch.start();
        try {
            watch.getStartTime();
            Assert.assertTrue((watch.getStartTime() >= beforeStopWatch ? 1 : 0) != 0);
        }
        catch (IllegalStateException ex) {
            Assert.fail((String)("Start time should be available: " + ex.getMessage()));
        }
        watch.reset();
        try {
            watch.getStartTime();
            Assert.fail((String)"Calling getStartTime on a reset, but unstarted StopWatch should throw an exception");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
    }

    @Test
    public void testBooleanStates() {
        StopWatch watch = new StopWatch();
        Assert.assertFalse((boolean)watch.isStarted());
        Assert.assertFalse((boolean)watch.isSuspended());
        Assert.assertTrue((boolean)watch.isStopped());
        watch.start();
        Assert.assertTrue((boolean)watch.isStarted());
        Assert.assertFalse((boolean)watch.isSuspended());
        Assert.assertFalse((boolean)watch.isStopped());
        watch.suspend();
        Assert.assertTrue((boolean)watch.isStarted());
        Assert.assertTrue((boolean)watch.isSuspended());
        Assert.assertFalse((boolean)watch.isStopped());
        watch.stop();
        Assert.assertFalse((boolean)watch.isStarted());
        Assert.assertFalse((boolean)watch.isSuspended());
        Assert.assertTrue((boolean)watch.isStopped());
    }
}

