/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.tuple;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.junit.Assert;
import org.junit.Test;

public class ImmutableTripleTest {
    @Test
    public void testBasic() throws Exception {
        ImmutableTriple triple = new ImmutableTriple((Object)0, (Object)"foo", (Object)Boolean.TRUE);
        Assert.assertEquals((long)0L, (long)((Integer)triple.left).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)triple.getLeft()).intValue());
        Assert.assertEquals((Object)"foo", (Object)triple.middle);
        Assert.assertEquals((Object)"foo", (Object)triple.getMiddle());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)triple.right);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)triple.getRight());
        ImmutableTriple triple2 = new ImmutableTriple(null, (Object)"bar", (Object)42);
        Assert.assertNull((Object)triple2.left);
        Assert.assertNull((Object)triple2.getLeft());
        Assert.assertEquals((Object)"bar", (Object)triple2.middle);
        Assert.assertEquals((Object)"bar", (Object)triple2.getMiddle());
        Assert.assertEquals((Object)new Integer(42), (Object)triple2.right);
        Assert.assertEquals((Object)new Integer(42), (Object)triple2.getRight());
    }

    @Test
    public void testTripleOf() throws Exception {
        ImmutableTriple triple = ImmutableTriple.of((Object)0, (Object)"foo", (Object)Boolean.FALSE);
        Assert.assertEquals((long)0L, (long)((Integer)triple.left).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)triple.getLeft()).intValue());
        Assert.assertEquals((Object)"foo", (Object)triple.middle);
        Assert.assertEquals((Object)"foo", (Object)triple.getMiddle());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)triple.right);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)triple.getRight());
        ImmutableTriple triple2 = ImmutableTriple.of(null, (Object)"bar", (Object)Boolean.TRUE);
        Assert.assertNull((Object)triple2.left);
        Assert.assertNull((Object)triple2.getLeft());
        Assert.assertEquals((Object)"bar", (Object)triple2.middle);
        Assert.assertEquals((Object)"bar", (Object)triple2.getMiddle());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)triple2.right);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)triple2.getRight());
    }

    @Test
    public void testEquals() throws Exception {
        Assert.assertEquals((Object)ImmutableTriple.of(null, (Object)"foo", (Object)42), (Object)ImmutableTriple.of(null, (Object)"foo", (Object)42));
        Assert.assertFalse((boolean)ImmutableTriple.of((Object)"foo", (Object)0, (Object)Boolean.TRUE).equals((Object)ImmutableTriple.of((Object)"foo", null, null)));
        Assert.assertFalse((boolean)ImmutableTriple.of((Object)"foo", (Object)"bar", (Object)"baz").equals((Object)ImmutableTriple.of((Object)"xyz", (Object)"bar", (Object)"blo")));
        ImmutableTriple p = ImmutableTriple.of((Object)"foo", (Object)"bar", (Object)"baz");
        Assert.assertTrue((boolean)p.equals((Object)p));
        Assert.assertFalse((boolean)p.equals(new Object()));
    }

    @Test
    public void testHashCode() throws Exception {
        Assert.assertEquals((long)ImmutableTriple.of(null, (Object)"foo", (Object)Boolean.TRUE).hashCode(), (long)ImmutableTriple.of(null, (Object)"foo", (Object)Boolean.TRUE).hashCode());
    }

    @Test
    public void testToString() throws Exception {
        Assert.assertEquals((Object)"(null,null,null)", (Object)ImmutableTriple.of(null, null, null).toString());
        Assert.assertEquals((Object)"(null,two,null)", (Object)ImmutableTriple.of(null, (Object)"two", null).toString());
        Assert.assertEquals((Object)"(one,null,null)", (Object)ImmutableTriple.of((Object)"one", null, null).toString());
        Assert.assertEquals((Object)"(one,two,null)", (Object)ImmutableTriple.of((Object)"one", (Object)"two", null).toString());
        Assert.assertEquals((Object)"(null,two,three)", (Object)ImmutableTriple.of(null, (Object)"two", (Object)"three").toString());
        Assert.assertEquals((Object)"(one,null,three)", (Object)ImmutableTriple.of((Object)"one", null, (Object)"three").toString());
        Assert.assertEquals((Object)"(one,two,three)", (Object)MutableTriple.of((Object)"one", (Object)"two", (Object)"three").toString());
    }

    @Test
    public void testSerialization() throws Exception {
        ImmutableTriple origTriple = ImmutableTriple.of((Object)0, (Object)"foo", (Object)Boolean.TRUE);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(origTriple);
        ImmutableTriple deserializedTriple = (ImmutableTriple)new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray())).readObject();
        Assert.assertEquals((Object)origTriple, (Object)deserializedTriple);
        Assert.assertEquals((long)origTriple.hashCode(), (long)deserializedTriple.hashCode());
    }
}

