/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.BitSet;
import java.util.HashSet;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;

public class HashSetvBitSetTest {
    private static final int LOOPS = 2000;
    private static final int LOOPS2 = 10000;

    @Test
    public void testTimes() {
        HashSetvBitSetTest.timeHashSet(10);
        HashSetvBitSetTest.timeBitSet(10);
        long timeDiff = this.printTimes(0);
        timeDiff += this.printTimes(5);
        timeDiff += this.printTimes(10);
        timeDiff += this.printTimes(200);
        timeDiff += this.printTimes(50);
        timeDiff += this.printTimes(100);
        timeDiff += this.printTimes(1000);
        Assert.assertTrue(((timeDiff += this.printTimes(2000)) <= 0L ? 1 : 0) != 0);
    }

    private long printTimes(int count) {
        long hashSet = HashSetvBitSetTest.timeHashSet(count);
        long bitSet = HashSetvBitSetTest.timeBitSet(count);
        System.out.println("Ratio=" + bitSet * 100L / hashSet + "% count=" + count + " hash=" + hashSet + " bits=" + bitSet);
        return bitSet - hashSet;
    }

    private static long timeHashSet(int count) {
        int[] result = new int[]{};
        long start = System.nanoTime();
        for (int i = 0; i < 2000; ++i) {
            result = HashSetvBitSetTest.testHashSet(count);
        }
        long elapsed = System.nanoTime() - start;
        Assert.assertEquals((long)count, (long)result.length);
        return elapsed;
    }

    private static long timeBitSet(int count) {
        int[] result = new int[]{};
        long start = System.nanoTime();
        for (int i = 0; i < 2000; ++i) {
            result = HashSetvBitSetTest.testBitSet(count);
        }
        long elapsed = System.nanoTime() - start;
        Assert.assertEquals((long)count, (long)result.length);
        return elapsed;
    }

    private static int[] testHashSet(int count) {
        HashSet<Integer> toRemove = new HashSet<Integer>();
        int found = 0;
        for (int i = 0; i < count; ++i) {
            toRemove.add(found++);
        }
        return HashSetvBitSetTest.extractIndices(toRemove);
    }

    private static int[] testBitSet(int count) {
        BitSet toRemove = new BitSet();
        int found = 0;
        for (int i = 0; i < count; ++i) {
            toRemove.set(found++);
        }
        return HashSetvBitSetTest.extractIndices(toRemove);
    }

    private static int[] extractIndices(HashSet<Integer> coll) {
        int[] result = new int[coll.size()];
        int i = 0;
        for (Integer index : coll) {
            result[i++] = index;
        }
        return result;
    }

    private static int[] extractIndices(BitSet coll) {
        int[] result = new int[coll.cardinality()];
        int i = 0;
        int j = 0;
        while ((j = coll.nextSetBit(j)) != -1) {
            result[i++] = j++;
        }
        return result;
    }

    @Test
    public void testTimesExtractOrBitset() {
        BitSet toRemove = new BitSet();
        int[] array = new int[100];
        toRemove.set(10, 20);
        this.timeBitSetRemoveAll(array, toRemove);
        this.timeExtractRemoveAll(array, toRemove);
        long timeDiff = this.printTimes(100, 1);
        timeDiff += this.printTimes(100, 10);
        timeDiff += this.printTimes(100, 50);
        timeDiff += this.printTimes(100, 100);
        timeDiff += this.printTimes(1000, 10);
        timeDiff += this.printTimes(1000, 100);
        timeDiff += this.printTimes(1000, 500);
        Assert.assertTrue(((timeDiff += this.printTimes(1000, 1000)) <= 0L ? 1 : 0) != 0);
    }

    private long printTimes(int arraySize, int bitSetSize) {
        int[] array = new int[arraySize];
        BitSet remove = new BitSet();
        for (int i = 0; i < bitSetSize; ++i) {
            remove.set(i);
        }
        long bitSet = this.timeBitSetRemoveAll(array, remove);
        long extract = this.timeExtractRemoveAll(array, remove);
        System.out.println("Ratio=" + bitSet * 100L / extract + "% array=" + array.length + " count=" + remove.cardinality() + " extract=" + extract + " bitset=" + bitSet);
        return bitSet - extract;
    }

    private long timeBitSetRemoveAll(int[] array, BitSet toRemove) {
        int[] output = new int[]{};
        long start = System.nanoTime();
        for (int i = 0; i < 10000; ++i) {
            output = (int[])ArrayUtils.removeAll((Object)array, (BitSet)toRemove);
        }
        long end = System.nanoTime();
        Assert.assertEquals((long)(array.length - toRemove.cardinality()), (long)output.length);
        return end - start;
    }

    private long timeExtractRemoveAll(int[] array, BitSet toRemove) {
        int[] output = new int[]{};
        long start = System.nanoTime();
        for (int i = 0; i < 10000; ++i) {
            int[] extractIndices = HashSetvBitSetTest.extractIndices(toRemove);
            output = (int[])ArrayUtils.removeAll((Object)array, (int[])extractIndices);
        }
        long end = System.nanoTime();
        Assert.assertEquals((long)(array.length - toRemove.cardinality()), (long)output.length);
        return end - start;
    }
}

