/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Assert;
import org.junit.Test;

public class RandomStringUtilsTest {
    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)new RandomStringUtils());
        Constructor<?>[] cons = RandomStringUtils.class.getDeclaredConstructors();
        Assert.assertEquals((long)1L, (long)cons.length);
        Assert.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assert.assertTrue((boolean)Modifier.isPublic(RandomStringUtils.class.getModifiers()));
        Assert.assertFalse((boolean)Modifier.isFinal(RandomStringUtils.class.getModifiers()));
    }

    @Test
    public void testRandomStringUtils() {
        int i;
        int i2;
        String r1 = RandomStringUtils.random((int)50);
        Assert.assertEquals((String)"random(50) length", (long)50L, (long)r1.length());
        String r2 = RandomStringUtils.random((int)50);
        Assert.assertEquals((String)"random(50) length", (long)50L, (long)r2.length());
        Assert.assertTrue((String)"!r1.equals(r2)", (!r1.equals(r2) ? 1 : 0) != 0);
        r1 = RandomStringUtils.randomAscii((int)50);
        Assert.assertEquals((String)"randomAscii(50) length", (long)50L, (long)r1.length());
        for (i2 = 0; i2 < r1.length(); ++i2) {
            Assert.assertTrue((String)"char between 32 and 127", (r1.charAt(i2) >= ' ' && r1.charAt(i2) <= '\u007f' ? 1 : 0) != 0);
        }
        r2 = RandomStringUtils.randomAscii((int)50);
        Assert.assertTrue((String)"!r1.equals(r2)", (!r1.equals(r2) ? 1 : 0) != 0);
        r1 = RandomStringUtils.randomAlphabetic((int)50);
        Assert.assertEquals((String)"randomAlphabetic(50)", (long)50L, (long)r1.length());
        for (i2 = 0; i2 < r1.length(); ++i2) {
            Assert.assertTrue((String)"r1 contains alphabetic", (Character.isLetter(r1.charAt(i2)) && !Character.isDigit(r1.charAt(i2)) ? 1 : 0) != 0);
        }
        r2 = RandomStringUtils.randomAlphabetic((int)50);
        Assert.assertTrue((String)"!r1.equals(r2)", (!r1.equals(r2) ? 1 : 0) != 0);
        r1 = RandomStringUtils.randomAlphanumeric((int)50);
        Assert.assertEquals((String)"randomAlphanumeric(50)", (long)50L, (long)r1.length());
        for (i2 = 0; i2 < r1.length(); ++i2) {
            Assert.assertTrue((String)"r1 contains alphanumeric", (boolean)Character.isLetterOrDigit(r1.charAt(i2)));
        }
        r2 = RandomStringUtils.randomAlphabetic((int)50);
        Assert.assertTrue((String)"!r1.equals(r2)", (!r1.equals(r2) ? 1 : 0) != 0);
        r1 = RandomStringUtils.randomNumeric((int)50);
        Assert.assertEquals((String)"randomNumeric(50)", (long)50L, (long)r1.length());
        for (i2 = 0; i2 < r1.length(); ++i2) {
            Assert.assertTrue((String)"r1 contains numeric", (Character.isDigit(r1.charAt(i2)) && !Character.isLetter(r1.charAt(i2)) ? 1 : 0) != 0);
        }
        r2 = RandomStringUtils.randomNumeric((int)50);
        Assert.assertTrue((String)"!r1.equals(r2)", (!r1.equals(r2) ? 1 : 0) != 0);
        String set = "abcdefg";
        r1 = RandomStringUtils.random((int)50, (String)set);
        Assert.assertEquals((String)"random(50, \"abcdefg\")", (long)50L, (long)r1.length());
        for (i = 0; i < r1.length(); ++i) {
            Assert.assertTrue((String)"random char in set", (set.indexOf(r1.charAt(i)) > -1 ? 1 : 0) != 0);
        }
        r2 = RandomStringUtils.random((int)50, (String)set);
        Assert.assertTrue((String)"!r1.equals(r2)", (!r1.equals(r2) ? 1 : 0) != 0);
        r1 = RandomStringUtils.random((int)50, (String)null);
        Assert.assertEquals((String)"random(50) length", (long)50L, (long)r1.length());
        r2 = RandomStringUtils.random((int)50, (String)null);
        Assert.assertEquals((String)"random(50) length", (long)50L, (long)r2.length());
        Assert.assertTrue((String)"!r1.equals(r2)", (!r1.equals(r2) ? 1 : 0) != 0);
        set = "stuvwxyz";
        r1 = RandomStringUtils.random((int)50, (char[])set.toCharArray());
        Assert.assertEquals((String)"random(50, \"stuvwxyz\")", (long)50L, (long)r1.length());
        for (i = 0; i < r1.length(); ++i) {
            Assert.assertTrue((String)"random char in set", (set.indexOf(r1.charAt(i)) > -1 ? 1 : 0) != 0);
        }
        r2 = RandomStringUtils.random((int)50, (String)set);
        Assert.assertTrue((String)"!r1.equals(r2)", (!r1.equals(r2) ? 1 : 0) != 0);
        r1 = RandomStringUtils.random((int)50, (char[])null);
        Assert.assertEquals((String)"random(50) length", (long)50L, (long)r1.length());
        r2 = RandomStringUtils.random((int)50, (char[])null);
        Assert.assertEquals((String)"random(50) length", (long)50L, (long)r2.length());
        Assert.assertTrue((String)"!r1.equals(r2)", (!r1.equals(r2) ? 1 : 0) != 0);
        long seed = System.currentTimeMillis();
        r1 = RandomStringUtils.random((int)50, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)new Random(seed));
        r2 = RandomStringUtils.random((int)50, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)new Random(seed));
        Assert.assertEquals((String)"r1.equals(r2)", (Object)r1, (Object)r2);
        r1 = RandomStringUtils.random((int)0);
        Assert.assertEquals((String)"random(0).equals(\"\")", (Object)"", (Object)r1);
    }

    @Test
    public void testLANG805() {
        long seed = System.currentTimeMillis();
        Assert.assertEquals((Object)"aaa", (Object)RandomStringUtils.random((int)3, (int)0, (int)0, (boolean)false, (boolean)false, (char[])new char[]{'a'}, (Random)new Random(seed)));
    }

    @Test
    public void testLANG807() {
        try {
            RandomStringUtils.random((int)3, (int)5, (int)5, (boolean)false, (boolean)false);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            String msg = ex.getMessage();
            Assert.assertTrue((String)("Message (" + msg + ") must contain 'start'"), (boolean)msg.contains("start"));
            Assert.assertTrue((String)("Message (" + msg + ") must contain 'end'"), (boolean)msg.contains("end"));
        }
    }

    @Test
    public void testExceptions() {
        char[] DUMMY = new char[]{'a'};
        try {
            RandomStringUtils.random((int)-1);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            RandomStringUtils.random((int)-1, (boolean)true, (boolean)true);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            RandomStringUtils.random((int)-1, (char[])DUMMY);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            RandomStringUtils.random((int)1, (char[])new char[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            RandomStringUtils.random((int)-1, (String)"");
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            RandomStringUtils.random((int)-1, (String)null);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            RandomStringUtils.random((int)-1, (int)97, (int)122, (boolean)false, (boolean)false);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            RandomStringUtils.random((int)-1, (int)97, (int)122, (boolean)false, (boolean)false, (char[])DUMMY);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            RandomStringUtils.random((int)-1, (int)97, (int)122, (boolean)false, (boolean)false, (char[])DUMMY, (Random)new Random());
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRandomAlphaNumeric() {
        int i;
        char[] testChars = new char[]{'a', 'z', 'A', 'Z', '0', '9'};
        boolean[] found = new boolean[]{false, false, false, false, false, false};
        for (i = 0; i < 100; ++i) {
            String randString = RandomStringUtils.randomAlphanumeric((int)10);
            for (int j = 0; j < testChars.length; ++j) {
                if (randString.indexOf(testChars[j]) <= 0) continue;
                found[j] = true;
            }
        }
        for (i = 0; i < testChars.length; ++i) {
            if (found[i]) continue;
            Assert.fail((String)("alphanumeric character not generated in 1000 attempts: " + testChars[i] + " -- repeated failures indicate a problem "));
        }
    }

    @Test
    public void testRandomNumeric() {
        int i;
        char[] testChars = new char[]{'0', '9'};
        boolean[] found = new boolean[]{false, false};
        for (i = 0; i < 100; ++i) {
            String randString = RandomStringUtils.randomNumeric((int)10);
            for (int j = 0; j < testChars.length; ++j) {
                if (randString.indexOf(testChars[j]) <= 0) continue;
                found[j] = true;
            }
        }
        for (i = 0; i < testChars.length; ++i) {
            if (found[i]) continue;
            Assert.fail((String)("digit not generated in 1000 attempts: " + testChars[i] + " -- repeated failures indicate a problem "));
        }
    }

    @Test
    public void testRandomAlphabetic() {
        int i;
        char[] testChars = new char[]{'a', 'z', 'A', 'Z'};
        boolean[] found = new boolean[]{false, false, false, false};
        for (i = 0; i < 100; ++i) {
            String randString = RandomStringUtils.randomAlphabetic((int)10);
            for (int j = 0; j < testChars.length; ++j) {
                if (randString.indexOf(testChars[j]) <= 0) continue;
                found[j] = true;
            }
        }
        for (i = 0; i < testChars.length; ++i) {
            if (found[i]) continue;
            Assert.fail((String)("alphanumeric character not generated in 1000 attempts: " + testChars[i] + " -- repeated failures indicate a problem "));
        }
    }

    @Test
    public void testRandomAscii() {
        int i;
        char[] testChars = new char[]{' ', '~'};
        boolean[] found = new boolean[]{false, false};
        for (i = 0; i < 100; ++i) {
            String randString = RandomStringUtils.randomAscii((int)10);
            for (int j = 0; j < testChars.length; ++j) {
                if (randString.indexOf(testChars[j]) <= 0) continue;
                found[j] = true;
            }
        }
        for (i = 0; i < testChars.length; ++i) {
            if (found[i]) continue;
            Assert.fail((String)("ascii character not generated in 1000 attempts: " + testChars[i] + " -- repeated failures indicate a problem"));
        }
    }

    @Test
    public void testRandomStringUtilsHomog() {
        String set = "abc";
        char[] chars = "abc".toCharArray();
        String gen = "";
        int[] counts = new int[]{0, 0, 0};
        int[] expected = new int[]{200, 200, 200};
        for (int i = 0; i < 100; ++i) {
            gen = RandomStringUtils.random((int)6, (char[])chars);
            block6: for (int j = 0; j < 6; ++j) {
                switch (gen.charAt(j)) {
                    case 'a': {
                        counts[0] = counts[0] + 1;
                        continue block6;
                    }
                    case 'b': {
                        counts[1] = counts[1] + 1;
                        continue block6;
                    }
                    case 'c': {
                        counts[2] = counts[2] + 1;
                        continue block6;
                    }
                    default: {
                        Assert.fail((String)"generated character not in set");
                    }
                }
            }
        }
        Assert.assertTrue((String)"test homogeneity -- will fail about 1 in 1000 times", (this.chiSquare(expected, counts) < 13.82 ? 1 : 0) != 0);
    }

    private double chiSquare(int[] expected, int[] observed) {
        double sumSq = 0.0;
        double dev = 0.0;
        for (int i = 0; i < observed.length; ++i) {
            dev = observed[i] - expected[i];
            sumSq += dev * dev / (double)expected[i];
        }
        return sumSq;
    }

    @Test
    public void testLang100() {
        int size = 5000;
        Charset charset = Charset.forName("UTF-8");
        String orig = RandomStringUtils.random((int)5000);
        byte[] bytes = orig.getBytes(charset);
        String copy = new String(bytes, charset);
        for (int i = 0; i < orig.length() && i < copy.length(); ++i) {
            char o = orig.charAt(i);
            char c = copy.charAt(i);
            Assert.assertEquals((String)("differs at " + i + "(" + Integer.toHexString(new Character(o).hashCode()) + "," + Integer.toHexString(new Character(c).hashCode()) + ")"), (long)o, (long)c);
        }
        Assert.assertEquals((long)orig.length(), (long)copy.length());
        Assert.assertEquals((Object)orig, (Object)copy);
    }
}

