/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.StringUtilsTest;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilsTrimEmptyTest {
    private static final String FOO = "foo";

    @Test
    public void testIsEmpty() {
        Assert.assertTrue((boolean)StringUtils.isEmpty(null));
        Assert.assertTrue((boolean)StringUtils.isEmpty((CharSequence)""));
        Assert.assertFalse((boolean)StringUtils.isEmpty((CharSequence)" "));
        Assert.assertFalse((boolean)StringUtils.isEmpty((CharSequence)FOO));
        Assert.assertFalse((boolean)StringUtils.isEmpty((CharSequence)"  foo  "));
    }

    @Test
    public void testIsNotEmpty() {
        Assert.assertFalse((boolean)StringUtils.isNotEmpty(null));
        Assert.assertFalse((boolean)StringUtils.isNotEmpty((CharSequence)""));
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((CharSequence)" "));
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((CharSequence)FOO));
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((CharSequence)"  foo  "));
    }

    @Test
    public void testIsBlank() {
        Assert.assertTrue((boolean)StringUtils.isBlank(null));
        Assert.assertTrue((boolean)StringUtils.isBlank((CharSequence)""));
        Assert.assertTrue((boolean)StringUtils.isBlank((CharSequence)StringUtilsTest.WHITESPACE));
        Assert.assertFalse((boolean)StringUtils.isBlank((CharSequence)FOO));
        Assert.assertFalse((boolean)StringUtils.isBlank((CharSequence)"  foo  "));
    }

    @Test
    public void testIsNotBlank() {
        Assert.assertFalse((boolean)StringUtils.isNotBlank(null));
        Assert.assertFalse((boolean)StringUtils.isNotBlank((CharSequence)""));
        Assert.assertFalse((boolean)StringUtils.isNotBlank((CharSequence)StringUtilsTest.WHITESPACE));
        Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)FOO));
        Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)"  foo  "));
    }

    @Test
    public void testTrim() {
        Assert.assertEquals((Object)FOO, (Object)StringUtils.trim((String)"foo  "));
        Assert.assertEquals((Object)FOO, (Object)StringUtils.trim((String)" foo  "));
        Assert.assertEquals((Object)FOO, (Object)StringUtils.trim((String)" foo"));
        Assert.assertEquals((Object)FOO, (Object)StringUtils.trim((String)FOO));
        Assert.assertEquals((Object)"", (Object)StringUtils.trim((String)" \t\r\n\b "));
        Assert.assertEquals((Object)"", (Object)StringUtils.trim((String)StringUtilsTest.TRIMMABLE));
        Assert.assertEquals((Object)StringUtilsTest.NON_TRIMMABLE, (Object)StringUtils.trim((String)StringUtilsTest.NON_TRIMMABLE));
        Assert.assertEquals((Object)"", (Object)StringUtils.trim((String)""));
        Assert.assertEquals(null, (Object)StringUtils.trim(null));
    }

    @Test
    public void testTrimToNull() {
        Assert.assertEquals((Object)FOO, (Object)StringUtils.trimToNull((String)"foo  "));
        Assert.assertEquals((Object)FOO, (Object)StringUtils.trimToNull((String)" foo  "));
        Assert.assertEquals((Object)FOO, (Object)StringUtils.trimToNull((String)" foo"));
        Assert.assertEquals((Object)FOO, (Object)StringUtils.trimToNull((String)FOO));
        Assert.assertEquals(null, (Object)StringUtils.trimToNull((String)" \t\r\n\b "));
        Assert.assertEquals(null, (Object)StringUtils.trimToNull((String)StringUtilsTest.TRIMMABLE));
        Assert.assertEquals((Object)StringUtilsTest.NON_TRIMMABLE, (Object)StringUtils.trimToNull((String)StringUtilsTest.NON_TRIMMABLE));
        Assert.assertEquals(null, (Object)StringUtils.trimToNull((String)""));
        Assert.assertEquals(null, (Object)StringUtils.trimToNull(null));
    }

    @Test
    public void testTrimToEmpty() {
        Assert.assertEquals((Object)FOO, (Object)StringUtils.trimToEmpty((String)"foo  "));
        Assert.assertEquals((Object)FOO, (Object)StringUtils.trimToEmpty((String)" foo  "));
        Assert.assertEquals((Object)FOO, (Object)StringUtils.trimToEmpty((String)" foo"));
        Assert.assertEquals((Object)FOO, (Object)StringUtils.trimToEmpty((String)FOO));
        Assert.assertEquals((Object)"", (Object)StringUtils.trimToEmpty((String)" \t\r\n\b "));
        Assert.assertEquals((Object)"", (Object)StringUtils.trimToEmpty((String)StringUtilsTest.TRIMMABLE));
        Assert.assertEquals((Object)StringUtilsTest.NON_TRIMMABLE, (Object)StringUtils.trimToEmpty((String)StringUtilsTest.NON_TRIMMABLE));
        Assert.assertEquals((Object)"", (Object)StringUtils.trimToEmpty((String)""));
        Assert.assertEquals((Object)"", (Object)StringUtils.trimToEmpty(null));
    }

    @Test
    public void testStrip_String() {
        Assert.assertEquals(null, (Object)StringUtils.strip(null));
        Assert.assertEquals((Object)"", (Object)StringUtils.strip((String)""));
        Assert.assertEquals((Object)"", (Object)StringUtils.strip((String)"        "));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.strip((String)"  abc  "));
        Assert.assertEquals((Object)StringUtilsTest.NON_WHITESPACE, (Object)StringUtils.strip((String)(StringUtilsTest.WHITESPACE + StringUtilsTest.NON_WHITESPACE + StringUtilsTest.WHITESPACE)));
    }

    @Test
    public void testStripToNull_String() {
        Assert.assertEquals(null, (Object)StringUtils.stripToNull(null));
        Assert.assertEquals(null, (Object)StringUtils.stripToNull((String)""));
        Assert.assertEquals(null, (Object)StringUtils.stripToNull((String)"        "));
        Assert.assertEquals(null, (Object)StringUtils.stripToNull((String)StringUtilsTest.WHITESPACE));
        Assert.assertEquals((Object)"ab c", (Object)StringUtils.stripToNull((String)"  ab c  "));
        Assert.assertEquals((Object)StringUtilsTest.NON_WHITESPACE, (Object)StringUtils.stripToNull((String)(StringUtilsTest.WHITESPACE + StringUtilsTest.NON_WHITESPACE + StringUtilsTest.WHITESPACE)));
    }

    @Test
    public void testStripToEmpty_String() {
        Assert.assertEquals((Object)"", (Object)StringUtils.stripToEmpty(null));
        Assert.assertEquals((Object)"", (Object)StringUtils.stripToEmpty((String)""));
        Assert.assertEquals((Object)"", (Object)StringUtils.stripToEmpty((String)"        "));
        Assert.assertEquals((Object)"", (Object)StringUtils.stripToEmpty((String)StringUtilsTest.WHITESPACE));
        Assert.assertEquals((Object)"ab c", (Object)StringUtils.stripToEmpty((String)"  ab c  "));
        Assert.assertEquals((Object)StringUtilsTest.NON_WHITESPACE, (Object)StringUtils.stripToEmpty((String)(StringUtilsTest.WHITESPACE + StringUtilsTest.NON_WHITESPACE + StringUtilsTest.WHITESPACE)));
    }

    @Test
    public void testStrip_StringString() {
        Assert.assertEquals(null, (Object)StringUtils.strip(null, null));
        Assert.assertEquals((Object)"", (Object)StringUtils.strip((String)"", null));
        Assert.assertEquals((Object)"", (Object)StringUtils.strip((String)"        ", null));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.strip((String)"  abc  ", null));
        Assert.assertEquals((Object)StringUtilsTest.NON_WHITESPACE, (Object)StringUtils.strip((String)(StringUtilsTest.WHITESPACE + StringUtilsTest.NON_WHITESPACE + StringUtilsTest.WHITESPACE), null));
        Assert.assertEquals(null, (Object)StringUtils.strip(null, (String)""));
        Assert.assertEquals((Object)"", (Object)StringUtils.strip((String)"", (String)""));
        Assert.assertEquals((Object)"        ", (Object)StringUtils.strip((String)"        ", (String)""));
        Assert.assertEquals((Object)"  abc  ", (Object)StringUtils.strip((String)"  abc  ", (String)""));
        Assert.assertEquals((Object)StringUtilsTest.WHITESPACE, (Object)StringUtils.strip((String)StringUtilsTest.WHITESPACE, (String)""));
        Assert.assertEquals(null, (Object)StringUtils.strip(null, (String)" "));
        Assert.assertEquals((Object)"", (Object)StringUtils.strip((String)"", (String)" "));
        Assert.assertEquals((Object)"", (Object)StringUtils.strip((String)"        ", (String)" "));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.strip((String)"  abc  ", (String)" "));
        Assert.assertEquals(null, (Object)StringUtils.strip(null, (String)"ab"));
        Assert.assertEquals((Object)"", (Object)StringUtils.strip((String)"", (String)"ab"));
        Assert.assertEquals((Object)"        ", (Object)StringUtils.strip((String)"        ", (String)"ab"));
        Assert.assertEquals((Object)"  abc  ", (Object)StringUtils.strip((String)"  abc  ", (String)"ab"));
        Assert.assertEquals((Object)"c", (Object)StringUtils.strip((String)"abcabab", (String)"ab"));
        Assert.assertEquals((Object)StringUtilsTest.WHITESPACE, (Object)StringUtils.strip((String)StringUtilsTest.WHITESPACE, (String)""));
    }

    @Test
    public void testStripStart_StringString() {
        Assert.assertEquals(null, (Object)StringUtils.stripStart(null, null));
        Assert.assertEquals((Object)"", (Object)StringUtils.stripStart((String)"", null));
        Assert.assertEquals((Object)"", (Object)StringUtils.stripStart((String)"        ", null));
        Assert.assertEquals((Object)"abc  ", (Object)StringUtils.stripStart((String)"  abc  ", null));
        Assert.assertEquals((Object)(StringUtilsTest.NON_WHITESPACE + StringUtilsTest.WHITESPACE), (Object)StringUtils.stripStart((String)(StringUtilsTest.WHITESPACE + StringUtilsTest.NON_WHITESPACE + StringUtilsTest.WHITESPACE), null));
        Assert.assertEquals(null, (Object)StringUtils.stripStart(null, (String)""));
        Assert.assertEquals((Object)"", (Object)StringUtils.stripStart((String)"", (String)""));
        Assert.assertEquals((Object)"        ", (Object)StringUtils.stripStart((String)"        ", (String)""));
        Assert.assertEquals((Object)"  abc  ", (Object)StringUtils.stripStart((String)"  abc  ", (String)""));
        Assert.assertEquals((Object)StringUtilsTest.WHITESPACE, (Object)StringUtils.stripStart((String)StringUtilsTest.WHITESPACE, (String)""));
        Assert.assertEquals(null, (Object)StringUtils.stripStart(null, (String)" "));
        Assert.assertEquals((Object)"", (Object)StringUtils.stripStart((String)"", (String)" "));
        Assert.assertEquals((Object)"", (Object)StringUtils.stripStart((String)"        ", (String)" "));
        Assert.assertEquals((Object)"abc  ", (Object)StringUtils.stripStart((String)"  abc  ", (String)" "));
        Assert.assertEquals(null, (Object)StringUtils.stripStart(null, (String)"ab"));
        Assert.assertEquals((Object)"", (Object)StringUtils.stripStart((String)"", (String)"ab"));
        Assert.assertEquals((Object)"        ", (Object)StringUtils.stripStart((String)"        ", (String)"ab"));
        Assert.assertEquals((Object)"  abc  ", (Object)StringUtils.stripStart((String)"  abc  ", (String)"ab"));
        Assert.assertEquals((Object)"cabab", (Object)StringUtils.stripStart((String)"abcabab", (String)"ab"));
        Assert.assertEquals((Object)StringUtilsTest.WHITESPACE, (Object)StringUtils.stripStart((String)StringUtilsTest.WHITESPACE, (String)""));
    }

    @Test
    public void testStripEnd_StringString() {
        Assert.assertEquals(null, (Object)StringUtils.stripEnd(null, null));
        Assert.assertEquals((Object)"", (Object)StringUtils.stripEnd((String)"", null));
        Assert.assertEquals((Object)"", (Object)StringUtils.stripEnd((String)"        ", null));
        Assert.assertEquals((Object)"  abc", (Object)StringUtils.stripEnd((String)"  abc  ", null));
        Assert.assertEquals((Object)(StringUtilsTest.WHITESPACE + StringUtilsTest.NON_WHITESPACE), (Object)StringUtils.stripEnd((String)(StringUtilsTest.WHITESPACE + StringUtilsTest.NON_WHITESPACE + StringUtilsTest.WHITESPACE), null));
        Assert.assertEquals(null, (Object)StringUtils.stripEnd(null, (String)""));
        Assert.assertEquals((Object)"", (Object)StringUtils.stripEnd((String)"", (String)""));
        Assert.assertEquals((Object)"        ", (Object)StringUtils.stripEnd((String)"        ", (String)""));
        Assert.assertEquals((Object)"  abc  ", (Object)StringUtils.stripEnd((String)"  abc  ", (String)""));
        Assert.assertEquals((Object)StringUtilsTest.WHITESPACE, (Object)StringUtils.stripEnd((String)StringUtilsTest.WHITESPACE, (String)""));
        Assert.assertEquals(null, (Object)StringUtils.stripEnd(null, (String)" "));
        Assert.assertEquals((Object)"", (Object)StringUtils.stripEnd((String)"", (String)" "));
        Assert.assertEquals((Object)"", (Object)StringUtils.stripEnd((String)"        ", (String)" "));
        Assert.assertEquals((Object)"  abc", (Object)StringUtils.stripEnd((String)"  abc  ", (String)" "));
        Assert.assertEquals(null, (Object)StringUtils.stripEnd(null, (String)"ab"));
        Assert.assertEquals((Object)"", (Object)StringUtils.stripEnd((String)"", (String)"ab"));
        Assert.assertEquals((Object)"        ", (Object)StringUtils.stripEnd((String)"        ", (String)"ab"));
        Assert.assertEquals((Object)"  abc  ", (Object)StringUtils.stripEnd((String)"  abc  ", (String)"ab"));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.stripEnd((String)"abcabab", (String)"ab"));
        Assert.assertEquals((Object)StringUtilsTest.WHITESPACE, (Object)StringUtils.stripEnd((String)StringUtilsTest.WHITESPACE, (String)""));
    }

    @Test
    public void testStripAll() {
        Object[] empty = new String[]{};
        String[] fooSpace = new String[]{"  foo  ", "  foo", "foo  "};
        String[] fooDots = new String[]{"..foo..", "..foo", "foo.."};
        Object[] foo = new String[]{FOO, FOO, FOO};
        Assert.assertNull((Object)StringUtils.stripAll((String[])null));
        Assert.assertArrayEquals((Object[])empty, (Object[])StringUtils.stripAll((String[])new String[0]));
        Assert.assertArrayEquals((Object[])new String[]{null}, (Object[])StringUtils.stripAll((String[])new String[]{null}));
        Assert.assertArrayEquals((Object[])empty, (Object[])StringUtils.stripAll((String[])empty));
        Assert.assertArrayEquals((Object[])foo, (Object[])StringUtils.stripAll((String[])fooSpace));
        Assert.assertNull((Object)StringUtils.stripAll(null, null));
        Assert.assertArrayEquals((Object[])foo, (Object[])StringUtils.stripAll((String[])fooSpace, null));
        Assert.assertArrayEquals((Object[])foo, (Object[])StringUtils.stripAll((String[])fooDots, (String)"."));
    }

    @Test
    public void testStripAccents() {
        String cue = "\u00c7\u00fa\u00ea";
        Assert.assertEquals((String)"Failed to strip accents from \u00c7\u00fa\u00ea", (Object)"Cue", (Object)StringUtils.stripAccents((String)"\u00c7\u00fa\u00ea"));
        String lots = "\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d9\u00da\u00db\u00dc\u00dd";
        Assert.assertEquals((String)"Failed to strip accents from \u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d9\u00da\u00db\u00dc\u00dd", (Object)"AAAAAACEEEEIIIINOOOOOUUUUY", (Object)StringUtils.stripAccents((String)"\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d9\u00da\u00db\u00dc\u00dd"));
        Assert.assertNull((String)"Failed null safety", (Object)StringUtils.stripAccents(null));
        Assert.assertEquals((String)"Failed empty String", (Object)"", (Object)StringUtils.stripAccents((String)""));
        Assert.assertEquals((String)"Failed to handle non-accented text", (Object)"control", (Object)StringUtils.stripAccents((String)"control"));
        Assert.assertEquals((String)"Failed to handle easy example", (Object)"eclair", (Object)StringUtils.stripAccents((String)"\u00e9clair"));
    }
}

