/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.Diff;
import org.apache.commons.lang3.builder.DiffBuilder;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.Diffable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;

public class DiffBuilderTest {
    private static final ToStringStyle SHORT_STYLE = ToStringStyle.SHORT_PREFIX_STYLE;

    @Test
    public void testBoolean() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        class2.booleanField = false;
        DiffResult list = class1.diff(class2);
        Assert.assertEquals((long)1L, (long)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assert.assertEquals(Boolean.class, (Object)diff.getType());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)diff.getLeft());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)diff.getRight());
    }

    @Test
    public void testBooleanArray() throws Exception {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        TypeTestClass.access$302(class2, new boolean[]{false, false});
        DiffResult list = class1.diff(class2);
        Assert.assertEquals((long)1L, (long)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assert.assertArrayEquals((Object[])ArrayUtils.toObject((boolean[])class1.booleanArrayField), (Object[])((Object[])diff.getLeft()));
        Assert.assertArrayEquals((Object[])ArrayUtils.toObject((boolean[])class2.booleanArrayField), (Object[])((Object[])diff.getRight()));
    }

    @Test
    public void testByte() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        class2.byteField = (byte)1;
        DiffResult list = class1.diff(class2);
        Assert.assertEquals((long)1L, (long)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assert.assertEquals((Object)class1.byteField, (Object)diff.getLeft());
        Assert.assertEquals((Object)class2.byteField, (Object)diff.getRight());
    }

    @Test
    public void testByteArray() throws Exception {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        TypeTestClass.access$502(class2, new byte[]{1, 2});
        DiffResult list = class1.diff(class2);
        Assert.assertEquals((long)1L, (long)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assert.assertArrayEquals((Object[])ArrayUtils.toObject((byte[])class1.byteArrayField), (Object[])((Object[])diff.getLeft()));
        Assert.assertArrayEquals((Object[])ArrayUtils.toObject((byte[])class2.byteArrayField), (Object[])((Object[])diff.getRight()));
    }

    @Test
    public void testChar() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        class2.charField = 'z';
        DiffResult list = class1.diff(class2);
        Assert.assertEquals((long)1L, (long)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assert.assertEquals((Object)Character.valueOf(class1.charField), (Object)diff.getLeft());
        Assert.assertEquals((Object)Character.valueOf(class2.charField), (Object)diff.getRight());
    }

    @Test
    public void testCharArray() throws Exception {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        TypeTestClass.access$702(class2, new char[]{'f', 'o', 'o'});
        DiffResult list = class1.diff(class2);
        Assert.assertEquals((long)1L, (long)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assert.assertArrayEquals((Object[])ArrayUtils.toObject((char[])class1.charArrayField), (Object[])((Object[])diff.getLeft()));
        Assert.assertArrayEquals((Object[])ArrayUtils.toObject((char[])class2.charArrayField), (Object[])((Object[])diff.getRight()));
    }

    @Test
    public void testDouble() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        class2.doubleField = 99.99;
        DiffResult list = class1.diff(class2);
        Assert.assertEquals((long)1L, (long)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assert.assertEquals((Object)class1.doubleField, (Object)diff.getLeft());
        Assert.assertEquals((Object)class2.doubleField, (Object)diff.getRight());
    }

    @Test
    public void testDoubleArray() throws Exception {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        TypeTestClass.access$902(class2, new double[]{3.0, 2.9, 2.8});
        DiffResult list = class1.diff(class2);
        Assert.assertEquals((long)1L, (long)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assert.assertArrayEquals((Object[])ArrayUtils.toObject((double[])class1.doubleArrayField), (Object[])((Object[])diff.getLeft()));
        Assert.assertArrayEquals((Object[])ArrayUtils.toObject((double[])class2.doubleArrayField), (Object[])((Object[])diff.getRight()));
    }

    @Test
    public void testFloat() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        class2.floatField = 99.99f;
        DiffResult list = class1.diff(class2);
        Assert.assertEquals((long)1L, (long)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assert.assertEquals((Object)Float.valueOf(class1.floatField), (Object)diff.getLeft());
        Assert.assertEquals((Object)Float.valueOf(class2.floatField), (Object)diff.getRight());
    }

    @Test
    public void testFloatArray() throws Exception {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        TypeTestClass.access$1102(class2, new float[]{3.0f, 2.9f, 2.8f});
        DiffResult list = class1.diff(class2);
        Assert.assertEquals((long)1L, (long)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assert.assertArrayEquals((Object[])ArrayUtils.toObject((float[])class1.floatArrayField), (Object[])((Object[])diff.getLeft()));
        Assert.assertArrayEquals((Object[])ArrayUtils.toObject((float[])class2.floatArrayField), (Object[])((Object[])diff.getRight()));
    }

    @Test
    public void testInt() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        class2.intField = 42;
        DiffResult list = class1.diff(class2);
        Assert.assertEquals((long)1L, (long)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assert.assertEquals((Object)class1.intField, (Object)diff.getLeft());
        Assert.assertEquals((Object)class2.intField, (Object)diff.getRight());
    }

    @Test
    public void testIntArray() throws Exception {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        TypeTestClass.access$1302(class2, new int[]{3, 2, 1});
        DiffResult list = class1.diff(class2);
        Assert.assertEquals((long)1L, (long)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assert.assertArrayEquals((Object[])ArrayUtils.toObject((int[])class1.intArrayField), (Object[])((Object[])diff.getLeft()));
        Assert.assertArrayEquals((Object[])ArrayUtils.toObject((int[])class2.intArrayField), (Object[])((Object[])diff.getRight()));
    }

    @Test
    public void testLong() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        class2.longField = 42L;
        DiffResult list = class1.diff(class2);
        Assert.assertEquals((long)1L, (long)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assert.assertEquals((Object)class1.longField, (Object)diff.getLeft());
        Assert.assertEquals((Object)class2.longField, (Object)diff.getRight());
    }

    @Test
    public void testLongArray() throws Exception {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        TypeTestClass.access$1502(class2, new long[]{3L, 2L, 1L});
        DiffResult list = class1.diff(class2);
        Assert.assertEquals((long)1L, (long)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assert.assertArrayEquals((Object[])ArrayUtils.toObject((long[])class1.longArrayField), (Object[])((Object[])diff.getLeft()));
        Assert.assertArrayEquals((Object[])ArrayUtils.toObject((long[])class2.longArrayField), (Object[])((Object[])diff.getRight()));
    }

    @Test
    public void testShort() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        class2.shortField = (short)42;
        DiffResult list = class1.diff(class2);
        Assert.assertEquals((long)1L, (long)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assert.assertEquals((Object)class1.shortField, (Object)diff.getLeft());
        Assert.assertEquals((Object)class2.shortField, (Object)diff.getRight());
    }

    @Test
    public void testShortArray() throws Exception {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        TypeTestClass.access$1702(class2, new short[]{3, 2, 1});
        DiffResult list = class1.diff(class2);
        Assert.assertEquals((long)1L, (long)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assert.assertArrayEquals((Object[])ArrayUtils.toObject((short[])class1.shortArrayField), (Object[])((Object[])diff.getLeft()));
        Assert.assertArrayEquals((Object[])ArrayUtils.toObject((short[])class2.shortArrayField), (Object[])((Object[])diff.getRight()));
    }

    @Test
    public void testObject() throws Exception {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        class2.objectField = "Some string";
        DiffResult list = class1.diff(class2);
        Assert.assertEquals((long)1L, (long)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assert.assertEquals((Object)class1.objectField, (Object)diff.getLeft());
        Assert.assertEquals((Object)class2.objectField, (Object)diff.getRight());
    }

    @Test
    public void testObjectsSameAndEqual() throws Exception {
        Integer sameObject = 1;
        TypeTestClass left = new TypeTestClass();
        left.objectField = sameObject;
        TypeTestClass right = new TypeTestClass();
        right.objectField = sameObject;
        Assert.assertTrue((left.objectField == right.objectField ? 1 : 0) != 0);
        Assert.assertTrue((boolean)left.objectField.equals(right.objectField));
        DiffResult list = left.diff(right);
        Assert.assertEquals((long)0L, (long)list.getNumberOfDiffs());
    }

    @Test
    public void testObjectsNotSameButEqual() throws Exception {
        TypeTestClass left = new TypeTestClass();
        left.objectField = new Integer(1);
        TypeTestClass right = new TypeTestClass();
        right.objectField = new Integer(1);
        Assert.assertFalse((left.objectField == right.objectField ? 1 : 0) != 0);
        Assert.assertTrue((boolean)left.objectField.equals(right.objectField));
        DiffResult list = left.diff(right);
        Assert.assertEquals((long)0L, (long)list.getNumberOfDiffs());
    }

    @Test
    public void testObjectsNotSameNorEqual() throws Exception {
        TypeTestClass left = new TypeTestClass();
        left.objectField = 4;
        TypeTestClass right = new TypeTestClass();
        right.objectField = 100;
        Assert.assertFalse((left.objectField == right.objectField ? 1 : 0) != 0);
        Assert.assertFalse((boolean)left.objectField.equals(right.objectField));
        DiffResult list = left.diff(right);
        Assert.assertEquals((long)1L, (long)list.getNumberOfDiffs());
    }

    @Test
    public void testObjectArray() throws Exception {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        TypeTestClass.access$1902(class2, new Object[]{"string", 1, 2});
        DiffResult list = class1.diff(class2);
        Assert.assertEquals((long)1L, (long)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assert.assertArrayEquals((Object[])class1.objectArrayField, (Object[])((Object[])diff.getLeft()));
        Assert.assertArrayEquals((Object[])class2.objectArrayField, (Object[])((Object[])diff.getRight()));
    }

    @Test
    public void testObjectArrayEqual() throws Exception {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        TypeTestClass.access$1902(class1, new Object[]{"string", 1, 2});
        TypeTestClass.access$1902(class2, new Object[]{"string", 1, 2});
        DiffResult list = class1.diff(class2);
        Assert.assertEquals((long)0L, (long)list.getNumberOfDiffs());
    }

    @Test
    public void testByteArrayEqualAsObject() throws Exception {
        DiffResult list = new DiffBuilder((Object)"String1", (Object)"String2", SHORT_STYLE).append("foo", (Object)new boolean[]{false}, (Object)new boolean[]{false}).append("foo", (Object)new byte[]{1}, (Object)new byte[]{1}).append("foo", (Object)new char[]{'a'}, (Object)new char[]{'a'}).append("foo", (Object)new double[]{1.0}, (Object)new double[]{1.0}).append("foo", (Object)new float[]{1.0f}, (Object)new float[]{1.0f}).append("foo", (Object)new int[]{1}, (Object)new int[]{1}).append("foo", (Object)new long[]{1L}, (Object)new long[]{1L}).append("foo", (Object)new short[]{1}, (Object)new short[]{1}).append("foo", (Object)new Object[]{1, "two"}, (Object)new Object[]{1, "two"}).build();
        Assert.assertEquals((long)0L, (long)list.getNumberOfDiffs());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullLhs() {
        new DiffBuilder(null, (Object)this, ToStringStyle.DEFAULT_STYLE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullRhs() {
        new DiffBuilder((Object)this, null, ToStringStyle.DEFAULT_STYLE);
    }

    @Test
    public void testSameObjectIgnoresAppends() {
        TypeTestClass testClass = new TypeTestClass();
        DiffResult list = new DiffBuilder((Object)testClass, (Object)testClass, SHORT_STYLE).append("ignored", false, true).build();
        Assert.assertEquals((long)0L, (long)list.getNumberOfDiffs());
    }

    @Test
    public void testSimilarObjectIgnoresAppends() {
        TypeTestClass testClass1 = new TypeTestClass();
        TypeTestClass testClass2 = new TypeTestClass();
        DiffResult list = new DiffBuilder((Object)testClass1, (Object)testClass2, SHORT_STYLE).append("ignored", false, true).build();
        Assert.assertEquals((long)0L, (long)list.getNumberOfDiffs());
    }

    @Test
    public void testStylePassedToDiffResult() {
        TypeTestClass class1 = new TypeTestClass();
        DiffResult list = class1.diff(class1);
        Assert.assertEquals((Object)SHORT_STYLE, (Object)list.getToStringStyle());
        class1.style = ToStringStyle.MULTI_LINE_STYLE;
        list = class1.diff(class1);
        Assert.assertEquals((Object)ToStringStyle.MULTI_LINE_STYLE, (Object)list.getToStringStyle());
    }

    @Test
    public void testTriviallyEqualTestDisabled() {
        Matcher equalToOne = IsEqual.equalTo((Object)1);
        DiffBuilder explicitTestAndNotEqual1 = new DiffBuilder((Object)1, (Object)2, null, false);
        explicitTestAndNotEqual1.append("letter", (Object)"X", (Object)"Y");
        Assert.assertThat((Object)explicitTestAndNotEqual1.build().getNumberOfDiffs(), (Matcher)equalToOne);
        DiffBuilder explicitTestAndNotEqual2 = new DiffBuilder((Object)1, (Object)1, null, false);
        explicitTestAndNotEqual2.append("letter", (Object)"X", (Object)"Y");
        Assert.assertThat((Object)explicitTestAndNotEqual2.build().getNumberOfDiffs(), (Matcher)equalToOne);
    }

    @Test
    public void testTriviallyEqualTestEnabled() {
        Matcher equalToZero = IsEqual.equalTo((Object)0);
        Matcher equalToOne = IsEqual.equalTo((Object)1);
        DiffBuilder implicitTestAndEqual = new DiffBuilder((Object)1, (Object)1, null);
        implicitTestAndEqual.append("letter", (Object)"X", (Object)"Y");
        Assert.assertThat((Object)implicitTestAndEqual.build().getNumberOfDiffs(), (Matcher)equalToZero);
        DiffBuilder implicitTestAndNotEqual = new DiffBuilder((Object)1, (Object)2, null);
        implicitTestAndNotEqual.append("letter", (Object)"X", (Object)"Y");
        Assert.assertThat((Object)implicitTestAndNotEqual.build().getNumberOfDiffs(), (Matcher)equalToOne);
        DiffBuilder explicitTestAndEqual = new DiffBuilder((Object)1, (Object)1, null, true);
        explicitTestAndEqual.append("letter", (Object)"X", (Object)"Y");
        Assert.assertThat((Object)explicitTestAndEqual.build().getNumberOfDiffs(), (Matcher)equalToZero);
    }

    static /* synthetic */ ToStringStyle access$000() {
        return SHORT_STYLE;
    }

    private static class TypeTestClass
    implements Diffable<TypeTestClass> {
        private ToStringStyle style = DiffBuilderTest.access$000();
        private boolean booleanField = true;
        private boolean[] booleanArrayField = new boolean[]{true};
        private byte byteField = (byte)-1;
        private byte[] byteArrayField = new byte[]{-1};
        private char charField = (char)97;
        private char[] charArrayField = new char[]{'a'};
        private double doubleField = 1.0;
        private double[] doubleArrayField = new double[]{1.0};
        private float floatField = 1.0f;
        private float[] floatArrayField = new float[]{1.0f};
        private int intField = 1;
        private int[] intArrayField = new int[]{1};
        private long longField = 1L;
        private long[] longArrayField = new long[]{1L};
        private short shortField = 1;
        private short[] shortArrayField = new short[]{1};
        private Object objectField = null;
        private Object[] objectArrayField = new Object[]{null};

        private TypeTestClass() {
        }

        public DiffResult diff(TypeTestClass obj) {
            return new DiffBuilder((Object)this, (Object)obj, this.style).append("boolean", this.booleanField, obj.booleanField).append("booleanArray", this.booleanArrayField, obj.booleanArrayField).append("byte", this.byteField, obj.byteField).append("byteArray", this.byteArrayField, obj.byteArrayField).append("char", this.charField, obj.charField).append("charArray", this.charArrayField, obj.charArrayField).append("double", this.doubleField, obj.doubleField).append("doubleArray", this.doubleArrayField, obj.doubleArrayField).append("float", this.floatField, obj.floatField).append("floatArray", this.floatArrayField, obj.floatArrayField).append("int", this.intField, obj.intField).append("intArray", this.intArrayField, obj.intArrayField).append("long", this.longField, obj.longField).append("longArray", this.longArrayField, obj.longArrayField).append("short", this.shortField, obj.shortField).append("shortArray", this.shortArrayField, obj.shortArrayField).append("objectField", this.objectField, obj.objectField).append("objectArrayField", this.objectArrayField, obj.objectArrayField).build();
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (boolean)false);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (boolean)false);
        }

        static /* synthetic */ boolean[] access$302(TypeTestClass x0, boolean[] x1) {
            x0.booleanArrayField = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$502(TypeTestClass x0, byte[] x1) {
            x0.byteArrayField = x1;
            return x1;
        }

        static /* synthetic */ char[] access$702(TypeTestClass x0, char[] x1) {
            x0.charArrayField = x1;
            return x1;
        }

        static /* synthetic */ double[] access$902(TypeTestClass x0, double[] x1) {
            x0.doubleArrayField = x1;
            return x1;
        }

        static /* synthetic */ float[] access$1102(TypeTestClass x0, float[] x1) {
            x0.floatArrayField = x1;
            return x1;
        }

        static /* synthetic */ int[] access$1302(TypeTestClass x0, int[] x1) {
            x0.intArrayField = x1;
            return x1;
        }

        static /* synthetic */ long[] access$1502(TypeTestClass x0, long[] x1) {
            x0.longArrayField = x1;
            return x1;
        }

        static /* synthetic */ short[] access$1702(TypeTestClass x0, short[] x1) {
            x0.shortArrayField = x1;
            return x1;
        }

        static /* synthetic */ Object[] access$1902(TypeTestClass x0, Object[] x1) {
            x0.objectArrayField = x1;
            return x1;
        }
    }
}

