/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.TimedSemaphore;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class TimedSemaphoreTest {
    private static final long PERIOD = 500L;
    private static final TimeUnit UNIT = TimeUnit.MILLISECONDS;
    private static final int LIMIT = 10;

    @Test
    public void testInit() {
        ScheduledExecutorService service = (ScheduledExecutorService)EasyMock.createMock(ScheduledExecutorService.class);
        EasyMock.replay((Object[])new Object[]{service});
        TimedSemaphore semaphore = new TimedSemaphore(service, 500L, UNIT, 10);
        EasyMock.verify((Object[])new Object[]{service});
        Assert.assertEquals((String)"Wrong service", (Object)service, (Object)semaphore.getExecutorService());
        Assert.assertEquals((String)"Wrong period", (long)500L, (long)semaphore.getPeriod());
        Assert.assertEquals((String)"Wrong unit", (Object)((Object)UNIT), (Object)((Object)semaphore.getUnit()));
        Assert.assertEquals((String)"Statistic available", (long)0L, (long)semaphore.getLastAcquiresPerPeriod());
        Assert.assertEquals((String)"Average available", (double)0.0, (double)semaphore.getAverageCallsPerPeriod(), (double)0.05);
        Assert.assertFalse((String)"Already shutdown", (boolean)semaphore.isShutdown());
        Assert.assertEquals((String)"Wrong limit", (long)10L, (long)semaphore.getLimit());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitInvalidPeriod() {
        new TimedSemaphore(0L, UNIT, 10);
    }

    @Test
    public void testInitDefaultService() {
        TimedSemaphore semaphore = new TimedSemaphore(500L, UNIT, 10);
        ScheduledThreadPoolExecutor exec = (ScheduledThreadPoolExecutor)semaphore.getExecutorService();
        Assert.assertFalse((String)"Wrong periodic task policy", (boolean)exec.getContinueExistingPeriodicTasksAfterShutdownPolicy());
        Assert.assertFalse((String)"Wrong delayed task policy", (boolean)exec.getExecuteExistingDelayedTasksAfterShutdownPolicy());
        Assert.assertFalse((String)"Already shutdown", (boolean)exec.isShutdown());
        semaphore.shutdown();
    }

    @Test
    public void testStartTimer() throws InterruptedException {
        TimedSemaphoreTestImpl semaphore = new TimedSemaphoreTestImpl(500L, UNIT, 10);
        ScheduledFuture<?> future = semaphore.startTimer();
        Assert.assertNotNull((String)"No future returned", future);
        Thread.sleep(500L);
        int trials = 10;
        int count = 0;
        do {
            Thread.sleep(500L);
            if (count++ <= 10) continue;
            Assert.fail((String)"endOfPeriod() not called!");
        } while (semaphore.getPeriodEnds() <= 0);
        semaphore.shutdown();
    }

    @Test
    public void testShutdownOwnExecutor() {
        TimedSemaphore semaphore = new TimedSemaphore(500L, UNIT, 10);
        semaphore.shutdown();
        Assert.assertTrue((String)"Not shutdown", (boolean)semaphore.isShutdown());
        Assert.assertTrue((String)"Executor not shutdown", (boolean)semaphore.getExecutorService().isShutdown());
    }

    @Test
    public void testShutdownSharedExecutorNoTask() {
        ScheduledExecutorService service = (ScheduledExecutorService)EasyMock.createMock(ScheduledExecutorService.class);
        EasyMock.replay((Object[])new Object[]{service});
        TimedSemaphore semaphore = new TimedSemaphore(service, 500L, UNIT, 10);
        semaphore.shutdown();
        Assert.assertTrue((String)"Not shutdown", (boolean)semaphore.isShutdown());
        EasyMock.verify((Object[])new Object[]{service});
    }

    private void prepareStartTimer(ScheduledExecutorService service, ScheduledFuture<?> future) {
        service.scheduleAtFixedRate((Runnable)EasyMock.anyObject(), EasyMock.eq((long)500L), EasyMock.eq((long)500L), (TimeUnit)((Object)EasyMock.eq((Object)((Object)UNIT))));
        EasyMock.expectLastCall().andReturn(future);
    }

    @Test
    public void testShutdownSharedExecutorTask() throws InterruptedException {
        ScheduledExecutorService service = (ScheduledExecutorService)EasyMock.createMock(ScheduledExecutorService.class);
        ScheduledFuture future = (ScheduledFuture)EasyMock.createMock(ScheduledFuture.class);
        this.prepareStartTimer(service, future);
        EasyMock.expect((Object)future.cancel(false)).andReturn((Object)Boolean.TRUE);
        EasyMock.replay((Object[])new Object[]{service, future});
        TimedSemaphoreTestImpl semaphore = new TimedSemaphoreTestImpl(service, 500L, UNIT, 10);
        semaphore.acquire();
        semaphore.shutdown();
        Assert.assertTrue((String)"Not shutdown", (boolean)semaphore.isShutdown());
        EasyMock.verify((Object[])new Object[]{service, future});
    }

    @Test
    public void testShutdownMultipleTimes() throws InterruptedException {
        ScheduledExecutorService service = (ScheduledExecutorService)EasyMock.createMock(ScheduledExecutorService.class);
        ScheduledFuture future = (ScheduledFuture)EasyMock.createMock(ScheduledFuture.class);
        this.prepareStartTimer(service, future);
        EasyMock.expect((Object)future.cancel(false)).andReturn((Object)Boolean.TRUE);
        EasyMock.replay((Object[])new Object[]{service, future});
        TimedSemaphoreTestImpl semaphore = new TimedSemaphoreTestImpl(service, 500L, UNIT, 10);
        semaphore.acquire();
        for (int i = 0; i < 10; ++i) {
            semaphore.shutdown();
        }
        EasyMock.verify((Object[])new Object[]{service, future});
    }

    @Test
    public void testAcquireLimit() throws InterruptedException {
        ScheduledExecutorService service = (ScheduledExecutorService)EasyMock.createMock(ScheduledExecutorService.class);
        ScheduledFuture future = (ScheduledFuture)EasyMock.createMock(ScheduledFuture.class);
        this.prepareStartTimer(service, future);
        EasyMock.replay((Object[])new Object[]{service, future});
        int count = 10;
        CountDownLatch latch = new CountDownLatch(9);
        TimedSemaphore semaphore = new TimedSemaphore(service, 500L, UNIT, 1);
        SemaphoreThread t = new SemaphoreThread(semaphore, latch, 10, 9);
        semaphore.setLimit(9);
        t.start();
        latch.await();
        Assert.assertEquals((String)"Wrong semaphore count", (long)9L, (long)semaphore.getAcquireCount());
        semaphore.endOfPeriod();
        t.join();
        Assert.assertEquals((String)"Wrong semaphore count (2)", (long)1L, (long)semaphore.getAcquireCount());
        Assert.assertEquals((String)"Wrong acquire() count", (long)9L, (long)semaphore.getLastAcquiresPerPeriod());
        EasyMock.verify((Object[])new Object[]{service, future});
    }

    @Test
    public void testAcquireMultipleThreads() throws InterruptedException {
        int i;
        ScheduledExecutorService service = (ScheduledExecutorService)EasyMock.createMock(ScheduledExecutorService.class);
        ScheduledFuture future = (ScheduledFuture)EasyMock.createMock(ScheduledFuture.class);
        this.prepareStartTimer(service, future);
        EasyMock.replay((Object[])new Object[]{service, future});
        TimedSemaphoreTestImpl semaphore = new TimedSemaphoreTestImpl(service, 500L, UNIT, 1);
        semaphore.latch = new CountDownLatch(1);
        int count = 10;
        SemaphoreThread[] threads = new SemaphoreThread[10];
        for (i = 0; i < 10; ++i) {
            threads[i] = new SemaphoreThread(semaphore, null, 1, 0);
            threads[i].start();
        }
        for (i = 0; i < 10; ++i) {
            semaphore.latch.await();
            Assert.assertEquals((String)"Wrong count", (long)1L, (long)semaphore.getAcquireCount());
            semaphore.latch = new CountDownLatch(1);
            semaphore.endOfPeriod();
            Assert.assertEquals((String)"Wrong acquire count", (long)1L, (long)semaphore.getLastAcquiresPerPeriod());
        }
        for (i = 0; i < 10; ++i) {
            threads[i].join();
        }
        EasyMock.verify((Object[])new Object[]{service, future});
    }

    @Test
    public void testAcquireNoLimit() throws InterruptedException {
        ScheduledExecutorService service = (ScheduledExecutorService)EasyMock.createMock(ScheduledExecutorService.class);
        ScheduledFuture future = (ScheduledFuture)EasyMock.createMock(ScheduledFuture.class);
        this.prepareStartTimer(service, future);
        EasyMock.replay((Object[])new Object[]{service, future});
        TimedSemaphoreTestImpl semaphore = new TimedSemaphoreTestImpl(service, 500L, UNIT, 0);
        int count = 1000;
        CountDownLatch latch = new CountDownLatch(1000);
        SemaphoreThread t = new SemaphoreThread(semaphore, latch, 1000, 1000);
        t.start();
        latch.await();
        EasyMock.verify((Object[])new Object[]{service, future});
    }

    @Test(expected=IllegalStateException.class)
    public void testPassAfterShutdown() throws InterruptedException {
        TimedSemaphore semaphore = new TimedSemaphore(500L, UNIT, 10);
        semaphore.shutdown();
        semaphore.acquire();
    }

    @Test
    public void testAcquireMultiplePeriods() throws InterruptedException {
        int count = 1000;
        TimedSemaphoreTestImpl semaphore = new TimedSemaphoreTestImpl(50L, TimeUnit.MILLISECONDS, 1);
        semaphore.setLimit(250);
        CountDownLatch latch = new CountDownLatch(1000);
        SemaphoreThread t = new SemaphoreThread(semaphore, latch, 1000, 1000);
        t.start();
        latch.await();
        semaphore.shutdown();
        Assert.assertTrue((String)"End of period not reached", (semaphore.getPeriodEnds() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetAverageCallsPerPeriod() throws InterruptedException {
        ScheduledExecutorService service = (ScheduledExecutorService)EasyMock.createMock(ScheduledExecutorService.class);
        ScheduledFuture future = (ScheduledFuture)EasyMock.createMock(ScheduledFuture.class);
        this.prepareStartTimer(service, future);
        EasyMock.replay((Object[])new Object[]{service, future});
        TimedSemaphore semaphore = new TimedSemaphore(service, 500L, UNIT, 10);
        semaphore.acquire();
        semaphore.endOfPeriod();
        Assert.assertEquals((String)"Wrong average (1)", (double)1.0, (double)semaphore.getAverageCallsPerPeriod(), (double)0.005);
        semaphore.acquire();
        semaphore.acquire();
        semaphore.endOfPeriod();
        Assert.assertEquals((String)"Wrong average (2)", (double)1.5, (double)semaphore.getAverageCallsPerPeriod(), (double)0.005);
        EasyMock.verify((Object[])new Object[]{service, future});
    }

    @Test
    public void testGetAvailablePermits() throws InterruptedException {
        ScheduledExecutorService service = (ScheduledExecutorService)EasyMock.createMock(ScheduledExecutorService.class);
        ScheduledFuture future = (ScheduledFuture)EasyMock.createMock(ScheduledFuture.class);
        this.prepareStartTimer(service, future);
        EasyMock.replay((Object[])new Object[]{service, future});
        TimedSemaphore semaphore = new TimedSemaphore(service, 500L, UNIT, 10);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((String)("Wrong available count at " + i), (long)(10 - i), (long)semaphore.getAvailablePermits());
            semaphore.acquire();
        }
        semaphore.endOfPeriod();
        Assert.assertEquals((String)"Wrong available count in new period", (long)10L, (long)semaphore.getAvailablePermits());
        EasyMock.verify((Object[])new Object[]{service, future});
    }

    private static class SemaphoreThread
    extends Thread {
        private final TimedSemaphore semaphore;
        private final CountDownLatch latch;
        private final int count;
        private final int latchCount;

        public SemaphoreThread(TimedSemaphore b, CountDownLatch l, int c, int lc) {
            this.semaphore = b;
            this.latch = l;
            this.count = c;
            this.latchCount = lc;
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < this.count; ++i) {
                    this.semaphore.acquire();
                    if (i >= this.latchCount) continue;
                    this.latch.countDown();
                }
            }
            catch (InterruptedException iex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static class TimedSemaphoreTestImpl
    extends TimedSemaphore {
        ScheduledFuture<?> schedFuture;
        volatile CountDownLatch latch;
        private int periodEnds;

        public TimedSemaphoreTestImpl(long timePeriod, TimeUnit timeUnit, int limit) {
            super(timePeriod, timeUnit, limit);
        }

        public TimedSemaphoreTestImpl(ScheduledExecutorService service, long timePeriod, TimeUnit timeUnit, int limit) {
            super(service, timePeriod, timeUnit, limit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getPeriodEnds() {
            TimedSemaphoreTestImpl timedSemaphoreTestImpl = this;
            synchronized (timedSemaphoreTestImpl) {
                return this.periodEnds;
            }
        }

        public synchronized void acquire() throws InterruptedException {
            super.acquire();
            if (this.latch != null) {
                this.latch.countDown();
            }
        }

        protected synchronized void endOfPeriod() {
            super.endOfPeriod();
            ++this.periodEnds;
        }

        protected ScheduledFuture<?> startTimer() {
            return this.schedFuture != null ? this.schedFuture : super.startTimer();
        }
    }
}

