/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.event;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.event.EventListenerSupport;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class EventListenerSupportTest {
    @Test(expected=NullPointerException.class)
    public void testAddNullListener() {
        EventListenerSupport listenerSupport = EventListenerSupport.create(VetoableChangeListener.class);
        listenerSupport.addListener(null);
    }

    @Test(expected=NullPointerException.class)
    public void testRemoveNullListener() {
        EventListenerSupport listenerSupport = EventListenerSupport.create(VetoableChangeListener.class);
        listenerSupport.removeListener(null);
    }

    @Test
    public void testEventDispatchOrder() throws PropertyVetoException {
        EventListenerSupport listenerSupport = EventListenerSupport.create(VetoableChangeListener.class);
        ArrayList<VetoableChangeListener> calledListeners = new ArrayList<VetoableChangeListener>();
        VetoableChangeListener listener1 = this.createListener(calledListeners);
        VetoableChangeListener listener2 = this.createListener(calledListeners);
        listenerSupport.addListener((Object)listener1);
        listenerSupport.addListener((Object)listener2);
        ((VetoableChangeListener)listenerSupport.fire()).vetoableChange(new PropertyChangeEvent(new Date(), "Day", 4, 5));
        Assert.assertEquals((long)calledListeners.size(), (long)2L);
        Assert.assertSame(calledListeners.get(0), (Object)listener1);
        Assert.assertSame(calledListeners.get(1), (Object)listener2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateWithNonInterfaceParameter() {
        EventListenerSupport.create(String.class);
    }

    @Test(expected=NullPointerException.class)
    public void testCreateWithNullParameter() {
        EventListenerSupport.create(null);
    }

    @Test
    public void testRemoveListenerDuringEvent() throws PropertyVetoException {
        EventListenerSupport listenerSupport = EventListenerSupport.create(VetoableChangeListener.class);
        for (int i = 0; i < 10; ++i) {
            this.addDeregisterListener((EventListenerSupport<VetoableChangeListener>)listenerSupport);
        }
        Assert.assertEquals((long)listenerSupport.getListenerCount(), (long)10L);
        ((VetoableChangeListener)listenerSupport.fire()).vetoableChange(new PropertyChangeEvent(new Date(), "Day", 4, 5));
        Assert.assertEquals((long)listenerSupport.getListenerCount(), (long)0L);
    }

    @Test
    public void testGetListeners() {
        EventListenerSupport listenerSupport = EventListenerSupport.create(VetoableChangeListener.class);
        VetoableChangeListener[] listeners = (VetoableChangeListener[])listenerSupport.getListeners();
        Assert.assertEquals((long)0L, (long)listeners.length);
        Assert.assertEquals(VetoableChangeListener.class, listeners.getClass().getComponentType());
        VetoableChangeListener[] empty = listeners;
        Assert.assertSame((Object)empty, (Object)listenerSupport.getListeners());
        VetoableChangeListener listener1 = (VetoableChangeListener)EasyMock.createNiceMock(VetoableChangeListener.class);
        listenerSupport.addListener((Object)listener1);
        Assert.assertEquals((long)1L, (long)((VetoableChangeListener[])listenerSupport.getListeners()).length);
        VetoableChangeListener listener2 = (VetoableChangeListener)EasyMock.createNiceMock(VetoableChangeListener.class);
        listenerSupport.addListener((Object)listener2);
        Assert.assertEquals((long)2L, (long)((VetoableChangeListener[])listenerSupport.getListeners()).length);
        listenerSupport.removeListener((Object)listener1);
        Assert.assertEquals((long)1L, (long)((VetoableChangeListener[])listenerSupport.getListeners()).length);
        listenerSupport.removeListener((Object)listener2);
        Assert.assertSame((Object)empty, (Object)listenerSupport.getListeners());
    }

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException, PropertyVetoException {
        EventListenerSupport listenerSupport = EventListenerSupport.create(VetoableChangeListener.class);
        listenerSupport.addListener((Object)new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent e) {
            }
        });
        listenerSupport.addListener(EasyMock.createNiceMock(VetoableChangeListener.class));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(listenerSupport);
        objectOutputStream.close();
        EventListenerSupport deserializedListenerSupport = (EventListenerSupport)new ObjectInputStream(new ByteArrayInputStream(outputStream.toByteArray())).readObject();
        VetoableChangeListener[] listeners = (VetoableChangeListener[])deserializedListenerSupport.getListeners();
        Assert.assertEquals(VetoableChangeListener.class, listeners.getClass().getComponentType());
        Assert.assertEquals((long)1L, (long)listeners.length);
        VetoableChangeListener listener = listeners[0];
        PropertyChangeEvent evt = new PropertyChangeEvent(new Date(), "Day", 7, 9);
        listener.vetoableChange(evt);
        EasyMock.replay((Object[])new Object[]{listener});
        ((VetoableChangeListener)deserializedListenerSupport.fire()).vetoableChange(evt);
        EasyMock.verify((Object[])new Object[]{listener});
        deserializedListenerSupport.removeListener((Object)listener);
        Assert.assertEquals((long)0L, (long)((VetoableChangeListener[])deserializedListenerSupport.getListeners()).length);
    }

    @Test
    public void testSubclassInvocationHandling() throws PropertyVetoException {
        EventListenerSupport<VetoableChangeListener> eventListenerSupport = new EventListenerSupport<VetoableChangeListener>(VetoableChangeListener.class){
            private static final long serialVersionUID = 1L;

            protected InvocationHandler createInvocationHandler() {
                return new EventListenerSupport.ProxyInvocationHandler(){

                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        return "vetoableChange".equals(method.getName()) && "Hour".equals(((PropertyChangeEvent)args[0]).getPropertyName()) ? null : super.invoke(proxy, method, args);
                    }
                };
            }
        };
        VetoableChangeListener listener = (VetoableChangeListener)EasyMock.createNiceMock(VetoableChangeListener.class);
        eventListenerSupport.addListener((Object)listener);
        Date source = new Date();
        PropertyChangeEvent ignore = new PropertyChangeEvent(source, "Hour", 5, 6);
        PropertyChangeEvent respond = new PropertyChangeEvent(source, "Day", 6, 7);
        listener.vetoableChange(respond);
        EasyMock.replay((Object[])new Object[]{listener});
        ((VetoableChangeListener)eventListenerSupport.fire()).vetoableChange(ignore);
        ((VetoableChangeListener)eventListenerSupport.fire()).vetoableChange(respond);
        EasyMock.verify((Object[])new Object[]{listener});
    }

    private void addDeregisterListener(final EventListenerSupport<VetoableChangeListener> listenerSupport) {
        listenerSupport.addListener((Object)new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent e) {
                listenerSupport.removeListener((Object)this);
            }
        });
    }

    private VetoableChangeListener createListener(final List<VetoableChangeListener> calledListeners) {
        return new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent e) {
                calledListeners.add(this);
            }
        };
    }
}

