/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.event;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import javax.naming.event.ObjectChangeListener;
import org.apache.commons.lang3.event.EventListenerSupport;
import org.apache.commons.lang3.event.EventUtils;
import org.junit.Assert;
import org.junit.Test;

public class EventUtilsTest {
    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)new EventUtils());
        Constructor<?>[] cons = EventUtils.class.getDeclaredConstructors();
        Assert.assertEquals((long)1L, (long)cons.length);
        Assert.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assert.assertTrue((boolean)Modifier.isPublic(EventUtils.class.getModifiers()));
        Assert.assertFalse((boolean)Modifier.isFinal(EventUtils.class.getModifiers()));
    }

    @Test
    public void testAddEventListener() {
        PropertyChangeSource src = new PropertyChangeSource();
        EventCountingInvociationHandler handler = new EventCountingInvociationHandler();
        PropertyChangeListener listener = handler.createListener(PropertyChangeListener.class);
        Assert.assertEquals((long)0L, (long)handler.getEventCount("propertyChange"));
        EventUtils.addEventListener((Object)src, PropertyChangeListener.class, (Object)listener);
        Assert.assertEquals((long)0L, (long)handler.getEventCount("propertyChange"));
        src.setProperty("newValue");
        Assert.assertEquals((long)1L, (long)handler.getEventCount("propertyChange"));
    }

    @Test
    public void testAddEventListenerWithNoAddMethod() {
        PropertyChangeSource src = new PropertyChangeSource();
        EventCountingInvociationHandler handler = new EventCountingInvociationHandler();
        ObjectChangeListener listener = handler.createListener(ObjectChangeListener.class);
        try {
            EventUtils.addEventListener((Object)src, ObjectChangeListener.class, (Object)listener);
            Assert.fail((String)"Should not be allowed to add a listener to an object that doesn't support it.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)("Class " + src.getClass().getName() + " does not have a public add" + ObjectChangeListener.class.getSimpleName() + " method which takes a parameter of type " + ObjectChangeListener.class.getName() + "."), (Object)e.getMessage());
        }
    }

    @Test
    public void testAddEventListenerThrowsException() {
        ExceptionEventSource src = new ExceptionEventSource();
        try {
            EventUtils.addEventListener((Object)src, PropertyChangeListener.class, (Object)new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                }
            });
            Assert.fail((String)"Add method should have thrown an exception, so method should fail.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testAddEventListenerWithPrivateAddMethod() {
        PropertyChangeSource src = new PropertyChangeSource();
        EventCountingInvociationHandler handler = new EventCountingInvociationHandler();
        VetoableChangeListener listener = handler.createListener(VetoableChangeListener.class);
        try {
            EventUtils.addEventListener((Object)src, VetoableChangeListener.class, (Object)listener);
            Assert.fail((String)"Should not be allowed to add a listener to an object that doesn't support it.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)("Class " + src.getClass().getName() + " does not have a public add" + VetoableChangeListener.class.getSimpleName() + " method which takes a parameter of type " + VetoableChangeListener.class.getName() + "."), (Object)e.getMessage());
        }
    }

    @Test
    public void testBindEventsToMethod() {
        PropertyChangeSource src = new PropertyChangeSource();
        EventCounter counter = new EventCounter();
        EventUtils.bindEventsToMethod((Object)counter, (String)"eventOccurred", (Object)src, PropertyChangeListener.class, (String[])new String[0]);
        Assert.assertEquals((long)0L, (long)counter.getCount());
        src.setProperty("newValue");
        Assert.assertEquals((long)1L, (long)counter.getCount());
    }

    @Test
    public void testBindEventsToMethodWithEvent() {
        PropertyChangeSource src = new PropertyChangeSource();
        EventCounterWithEvent counter = new EventCounterWithEvent();
        EventUtils.bindEventsToMethod((Object)counter, (String)"eventOccurred", (Object)src, PropertyChangeListener.class, (String[])new String[0]);
        Assert.assertEquals((long)0L, (long)counter.getCount());
        src.setProperty("newValue");
        Assert.assertEquals((long)1L, (long)counter.getCount());
    }

    @Test
    public void testBindFilteredEventsToMethod() {
        MultipleEventSource src = new MultipleEventSource();
        EventCounter counter = new EventCounter();
        EventUtils.bindEventsToMethod((Object)counter, (String)"eventOccurred", (Object)src, MultipleEventListener.class, (String[])new String[]{"event1"});
        Assert.assertEquals((long)0L, (long)counter.getCount());
        ((MultipleEventListener)src.listeners.fire()).event1(new PropertyChangeEvent(new Date(), "Day", 0, 1));
        Assert.assertEquals((long)1L, (long)counter.getCount());
        ((MultipleEventListener)src.listeners.fire()).event2(new PropertyChangeEvent(new Date(), "Day", 1, 2));
        Assert.assertEquals((long)1L, (long)counter.getCount());
    }

    public static class PropertyChangeSource {
        private final EventListenerSupport<PropertyChangeListener> listeners = EventListenerSupport.create(PropertyChangeListener.class);
        private String property;

        public void setProperty(String property) {
            String oldValue = this.property;
            this.property = property;
            ((PropertyChangeListener)this.listeners.fire()).propertyChange(new PropertyChangeEvent(this, "property", oldValue, property));
        }

        protected void addVetoableChangeListener(VetoableChangeListener listener) {
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.listeners.addListener((Object)listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.listeners.removeListener((Object)listener);
        }
    }

    public static class ExceptionEventSource {
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            throw new RuntimeException();
        }
    }

    public static class MultipleEventSource {
        private final EventListenerSupport<MultipleEventListener> listeners = EventListenerSupport.create(MultipleEventListener.class);

        public void addMultipleEventListener(MultipleEventListener listener) {
            this.listeners.addListener((Object)listener);
        }
    }

    private static class EventCountingInvociationHandler
    implements InvocationHandler {
        private final Map<String, Integer> eventCounts = new TreeMap<String, Integer>();

        private EventCountingInvociationHandler() {
        }

        public <L> L createListener(Class<L> listenerType) {
            return listenerType.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{listenerType}, (InvocationHandler)this));
        }

        public int getEventCount(String eventName) {
            Integer count = this.eventCounts.get(eventName);
            return count == null ? 0 : count;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Integer count = this.eventCounts.get(method.getName());
            if (count == null) {
                this.eventCounts.put(method.getName(), 1);
            } else {
                this.eventCounts.put(method.getName(), count + 1);
            }
            return null;
        }
    }

    public static class EventCounterWithEvent {
        private int count;

        public void eventOccurred(PropertyChangeEvent e) {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static class EventCounter {
        private int count;

        public void eventOccurred() {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static interface MultipleEventListener {
        public void event1(PropertyChangeEvent var1);

        public void event2(PropertyChangeEvent var1);
    }
}

