/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import org.apache.commons.lang3.mutable.MutableByte;
import org.junit.Assert;
import org.junit.Test;

public class MutableByteTest {
    @Test
    public void testConstructors() {
        Assert.assertEquals((long)0L, (long)new MutableByte().byteValue());
        Assert.assertEquals((long)1L, (long)new MutableByte(1).byteValue());
        Assert.assertEquals((long)2L, (long)new MutableByte((Number)2).byteValue());
        Assert.assertEquals((long)3L, (long)new MutableByte((Number)new MutableByte(3)).byteValue());
        Assert.assertEquals((long)2L, (long)new MutableByte("2").byteValue());
    }

    @Test(expected=NullPointerException.class)
    public void testConstructorNull() {
        new MutableByte((Number)null);
    }

    @Test
    public void testGetSet() {
        MutableByte mutNum = new MutableByte(0);
        Assert.assertEquals((long)0L, (long)new MutableByte().byteValue());
        Assert.assertEquals((Object)0, (Object)new MutableByte().getValue());
        mutNum.setValue((byte)1);
        Assert.assertEquals((long)1L, (long)mutNum.byteValue());
        Assert.assertEquals((Object)1, (Object)mutNum.getValue());
        mutNum.setValue((Number)2);
        Assert.assertEquals((long)2L, (long)mutNum.byteValue());
        Assert.assertEquals((Object)2, (Object)mutNum.getValue());
        mutNum.setValue((Number)new MutableByte(3));
        Assert.assertEquals((long)3L, (long)mutNum.byteValue());
        Assert.assertEquals((Object)3, (Object)mutNum.getValue());
    }

    @Test(expected=NullPointerException.class)
    public void testSetNull() {
        MutableByte mutNum = new MutableByte(0);
        mutNum.setValue(null);
    }

    @Test
    public void testEquals() {
        MutableByte mutNumA = new MutableByte(0);
        MutableByte mutNumB = new MutableByte(0);
        MutableByte mutNumC = new MutableByte(1);
        Assert.assertTrue((boolean)mutNumA.equals((Object)mutNumA));
        Assert.assertTrue((boolean)mutNumA.equals((Object)mutNumB));
        Assert.assertTrue((boolean)mutNumB.equals((Object)mutNumA));
        Assert.assertTrue((boolean)mutNumB.equals((Object)mutNumB));
        Assert.assertFalse((boolean)mutNumA.equals((Object)mutNumC));
        Assert.assertFalse((boolean)mutNumB.equals((Object)mutNumC));
        Assert.assertTrue((boolean)mutNumC.equals((Object)mutNumC));
        Assert.assertFalse((boolean)mutNumA.equals(null));
        Assert.assertFalse((boolean)mutNumA.equals((Object)0));
        Assert.assertFalse((boolean)mutNumA.equals((Object)"0"));
    }

    @Test
    public void testHashCode() {
        MutableByte mutNumA = new MutableByte(0);
        MutableByte mutNumB = new MutableByte(0);
        MutableByte mutNumC = new MutableByte(1);
        Assert.assertTrue((mutNumA.hashCode() == mutNumA.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((mutNumA.hashCode() == mutNumB.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((mutNumA.hashCode() == mutNumC.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((mutNumA.hashCode() == Byte.valueOf((byte)0).hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testCompareTo() {
        MutableByte mutNum = new MutableByte(0);
        Assert.assertEquals((long)0L, (long)mutNum.compareTo(new MutableByte(0)));
        Assert.assertEquals((long)1L, (long)mutNum.compareTo(new MutableByte(-1)));
        Assert.assertEquals((long)-1L, (long)mutNum.compareTo(new MutableByte(1)));
    }

    @Test(expected=NullPointerException.class)
    public void testCompareToNull() {
        MutableByte mutNum = new MutableByte(0);
        mutNum.compareTo(null);
    }

    @Test
    public void testPrimitiveValues() {
        MutableByte mutNum = new MutableByte(1);
        Assert.assertEquals((float)1.0f, (float)mutNum.floatValue(), (float)0.0f);
        Assert.assertEquals((double)1.0, (double)mutNum.doubleValue(), (double)0.0);
        Assert.assertEquals((long)1L, (long)mutNum.byteValue());
        Assert.assertEquals((long)1L, (long)mutNum.shortValue());
        Assert.assertEquals((long)1L, (long)mutNum.intValue());
        Assert.assertEquals((long)1L, (long)mutNum.longValue());
    }

    @Test
    public void testToByte() {
        Assert.assertEquals((Object)0, (Object)new MutableByte(0).toByte());
        Assert.assertEquals((Object)123, (Object)new MutableByte(123).toByte());
    }

    @Test
    public void testIncrement() {
        MutableByte mutNum = new MutableByte(1);
        mutNum.increment();
        Assert.assertEquals((long)2L, (long)mutNum.intValue());
        Assert.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    public void testDecrement() {
        MutableByte mutNum = new MutableByte(1);
        mutNum.decrement();
        Assert.assertEquals((long)0L, (long)mutNum.intValue());
        Assert.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    public void testAddValuePrimitive() {
        MutableByte mutNum = new MutableByte(1);
        mutNum.add((byte)1);
        Assert.assertEquals((long)2L, (long)mutNum.byteValue());
    }

    @Test
    public void testAddValueObject() {
        MutableByte mutNum = new MutableByte(1);
        mutNum.add((Number)1);
        Assert.assertEquals((long)2L, (long)mutNum.byteValue());
    }

    @Test
    public void testSubtractValuePrimitive() {
        MutableByte mutNum = new MutableByte(1);
        mutNum.subtract((byte)1);
        Assert.assertEquals((long)0L, (long)mutNum.byteValue());
    }

    @Test
    public void testSubtractValueObject() {
        MutableByte mutNum = new MutableByte(1);
        mutNum.subtract((Number)1);
        Assert.assertEquals((long)0L, (long)mutNum.byteValue());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"0", (Object)new MutableByte(0).toString());
        Assert.assertEquals((Object)"10", (Object)new MutableByte(10).toString());
        Assert.assertEquals((Object)"-123", (Object)new MutableByte(-123).toString());
    }
}

