/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import org.apache.commons.lang3.mutable.MutableLong;
import org.junit.Assert;
import org.junit.Test;

public class MutableLongTest {
    @Test
    public void testConstructors() {
        Assert.assertEquals((long)0L, (long)new MutableLong().longValue());
        Assert.assertEquals((long)1L, (long)new MutableLong(1L).longValue());
        Assert.assertEquals((long)2L, (long)new MutableLong((Number)2L).longValue());
        Assert.assertEquals((long)3L, (long)new MutableLong((Number)new MutableLong(3L)).longValue());
        Assert.assertEquals((long)2L, (long)new MutableLong("2").longValue());
    }

    @Test(expected=NullPointerException.class)
    public void testConstructorNull() {
        new MutableLong((Number)null);
    }

    @Test
    public void testGetSet() {
        MutableLong mutNum = new MutableLong(0L);
        Assert.assertEquals((long)0L, (long)new MutableLong().longValue());
        Assert.assertEquals((Object)0L, (Object)new MutableLong().getValue());
        mutNum.setValue(1L);
        Assert.assertEquals((long)1L, (long)mutNum.longValue());
        Assert.assertEquals((Object)1L, (Object)mutNum.getValue());
        mutNum.setValue((Number)2L);
        Assert.assertEquals((long)2L, (long)mutNum.longValue());
        Assert.assertEquals((Object)2L, (Object)mutNum.getValue());
        mutNum.setValue((Number)new MutableLong(3L));
        Assert.assertEquals((long)3L, (long)mutNum.longValue());
        Assert.assertEquals((Object)3L, (Object)mutNum.getValue());
    }

    @Test(expected=NullPointerException.class)
    public void testSetNull() {
        MutableLong mutNum = new MutableLong(0L);
        mutNum.setValue(null);
    }

    @Test
    public void testEquals() {
        MutableLong mutNumA = new MutableLong(0L);
        MutableLong mutNumB = new MutableLong(0L);
        MutableLong mutNumC = new MutableLong(1L);
        Assert.assertTrue((boolean)mutNumA.equals((Object)mutNumA));
        Assert.assertTrue((boolean)mutNumA.equals((Object)mutNumB));
        Assert.assertTrue((boolean)mutNumB.equals((Object)mutNumA));
        Assert.assertTrue((boolean)mutNumB.equals((Object)mutNumB));
        Assert.assertFalse((boolean)mutNumA.equals((Object)mutNumC));
        Assert.assertFalse((boolean)mutNumB.equals((Object)mutNumC));
        Assert.assertTrue((boolean)mutNumC.equals((Object)mutNumC));
        Assert.assertFalse((boolean)mutNumA.equals(null));
        Assert.assertFalse((boolean)mutNumA.equals((Object)0L));
        Assert.assertFalse((boolean)mutNumA.equals((Object)"0"));
    }

    @Test
    public void testHashCode() {
        MutableLong mutNumA = new MutableLong(0L);
        MutableLong mutNumB = new MutableLong(0L);
        MutableLong mutNumC = new MutableLong(1L);
        Assert.assertTrue((mutNumA.hashCode() == mutNumA.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((mutNumA.hashCode() == mutNumB.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((mutNumA.hashCode() == mutNumC.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((mutNumA.hashCode() == Long.valueOf(0L).hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testCompareTo() {
        MutableLong mutNum = new MutableLong(0L);
        Assert.assertEquals((long)0L, (long)mutNum.compareTo(new MutableLong(0L)));
        Assert.assertEquals((long)1L, (long)mutNum.compareTo(new MutableLong(-1L)));
        Assert.assertEquals((long)-1L, (long)mutNum.compareTo(new MutableLong(1L)));
    }

    @Test(expected=NullPointerException.class)
    public void testCompareToNull() {
        MutableLong mutNum = new MutableLong(0L);
        mutNum.compareTo(null);
    }

    @Test
    public void testPrimitiveValues() {
        MutableLong mutNum = new MutableLong(1L);
        Assert.assertEquals((float)1.0f, (float)mutNum.floatValue(), (float)0.0f);
        Assert.assertEquals((double)1.0, (double)mutNum.doubleValue(), (double)0.0);
        Assert.assertEquals((long)1L, (long)mutNum.byteValue());
        Assert.assertEquals((long)1L, (long)mutNum.shortValue());
        Assert.assertEquals((long)1L, (long)mutNum.intValue());
        Assert.assertEquals((long)1L, (long)mutNum.longValue());
    }

    @Test
    public void testToLong() {
        Assert.assertEquals((Object)0L, (Object)new MutableLong(0L).toLong());
        Assert.assertEquals((Object)123L, (Object)new MutableLong(123L).toLong());
    }

    @Test
    public void testIncrement() {
        MutableLong mutNum = new MutableLong(1L);
        mutNum.increment();
        Assert.assertEquals((long)2L, (long)mutNum.intValue());
        Assert.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    public void testDecrement() {
        MutableLong mutNum = new MutableLong(1L);
        mutNum.decrement();
        Assert.assertEquals((long)0L, (long)mutNum.intValue());
        Assert.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    public void testAddValuePrimitive() {
        MutableLong mutNum = new MutableLong(1L);
        mutNum.add(1L);
        Assert.assertEquals((long)2L, (long)mutNum.intValue());
        Assert.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    public void testAddValueObject() {
        MutableLong mutNum = new MutableLong(1L);
        mutNum.add((Number)1L);
        Assert.assertEquals((long)2L, (long)mutNum.intValue());
        Assert.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    public void testSubtractValuePrimitive() {
        MutableLong mutNum = new MutableLong(1L);
        mutNum.subtract(1L);
        Assert.assertEquals((long)0L, (long)mutNum.intValue());
        Assert.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    public void testSubtractValueObject() {
        MutableLong mutNum = new MutableLong(1L);
        mutNum.subtract((Number)1L);
        Assert.assertEquals((long)0L, (long)mutNum.intValue());
        Assert.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"0", (Object)new MutableLong(0L).toString());
        Assert.assertEquals((Object)"10", (Object)new MutableLong(10L).toString());
        Assert.assertEquals((Object)"-123", (Object)new MutableLong(-123L).toString());
    }
}

