/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.reflect.FieldUtilsTest;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.commons.lang3.reflect.testbed.Annotated;
import org.apache.commons.lang3.reflect.testbed.GenericConsumer;
import org.apache.commons.lang3.reflect.testbed.GenericParent;
import org.apache.commons.lang3.reflect.testbed.StringParameterizedChild;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MethodUtilsTest {
    private TestBean testBean;
    private final Map<Class<?>, Class<?>[]> classCache = new HashMap();

    @Before
    public void setUp() throws Exception {
        this.testBean = new TestBean();
        this.classCache.clear();
    }

    @Test
    public void testConstructor() throws Exception {
        Assert.assertNotNull(MethodUtils.class.newInstance());
    }

    @Test
    public void testInvokeMethod() throws Exception {
        Assert.assertEquals((Object)"foo()", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])ArrayUtils.EMPTY_CLASS_ARRAY));
        Assert.assertEquals((Object)"foo()", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo"));
        Assert.assertEquals((Object)"foo()", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])null));
        Assert.assertEquals((Object)"foo()", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])null, (Class[])null));
        Assert.assertEquals((Object)"foo(String)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{""}));
        Assert.assertEquals((Object)"foo(Object)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{new Object()}));
        Assert.assertEquals((Object)"foo(Object)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{Boolean.TRUE}));
        Assert.assertEquals((Object)"foo(Integer)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.INTEGER_ONE}));
        Assert.assertEquals((Object)"foo(int)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.BYTE_ONE}));
        Assert.assertEquals((Object)"foo(double)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.LONG_ONE}));
        Assert.assertEquals((Object)"foo(double)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.DOUBLE_ONE}));
    }

    @Test
    public void testInvokeExactMethod() throws Exception {
        Assert.assertEquals((Object)"foo()", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])ArrayUtils.EMPTY_CLASS_ARRAY));
        Assert.assertEquals((Object)"foo()", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo"));
        Assert.assertEquals((Object)"foo()", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])null));
        Assert.assertEquals((Object)"foo()", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])null, (Class[])null));
        Assert.assertEquals((Object)"foo(String)", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{""}));
        Assert.assertEquals((Object)"foo(Object)", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{new Object()}));
        Assert.assertEquals((Object)"foo(Integer)", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.INTEGER_ONE}));
        Assert.assertEquals((Object)"foo(double)", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.DOUBLE_ONE}, (Class[])new Class[]{Double.TYPE}));
        try {
            MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.BYTE_ONE});
            Assert.fail((String)"should throw NoSuchMethodException");
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.LONG_ONE});
            Assert.fail((String)"should throw NoSuchMethodException");
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{Boolean.TRUE});
            Assert.fail((String)"should throw NoSuchMethodException");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @Test
    public void testInvokeStaticMethod() throws Exception {
        Assert.assertEquals((Object)"bar()", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])ArrayUtils.EMPTY_CLASS_ARRAY));
        Assert.assertEquals((Object)"bar()", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])null));
        Assert.assertEquals((Object)"bar()", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])null, (Class[])null));
        Assert.assertEquals((Object)"bar(String)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{""}));
        Assert.assertEquals((Object)"bar(Object)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{new Object()}));
        Assert.assertEquals((Object)"bar(Object)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{Boolean.TRUE}));
        Assert.assertEquals((Object)"bar(Integer)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.INTEGER_ONE}));
        Assert.assertEquals((Object)"bar(int)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.BYTE_ONE}));
        Assert.assertEquals((Object)"bar(double)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.LONG_ONE}));
        Assert.assertEquals((Object)"bar(double)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.DOUBLE_ONE}));
        try {
            MethodUtils.invokeStaticMethod(TestBean.class, (String)"does_not_exist", (Object[])new Object[0]);
            Assert.fail((String)"should throw NoSuchMethodException");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @Test
    public void testInvokeExactStaticMethod() throws Exception {
        Assert.assertEquals((Object)"bar()", (Object)MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])ArrayUtils.EMPTY_CLASS_ARRAY));
        Assert.assertEquals((Object)"bar()", (Object)MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])null));
        Assert.assertEquals((Object)"bar()", (Object)MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])null, (Class[])null));
        Assert.assertEquals((Object)"bar(String)", (Object)MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{""}));
        Assert.assertEquals((Object)"bar(Object)", (Object)MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{new Object()}));
        Assert.assertEquals((Object)"bar(Integer)", (Object)MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.INTEGER_ONE}));
        Assert.assertEquals((Object)"bar(double)", (Object)MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.DOUBLE_ONE}, (Class[])new Class[]{Double.TYPE}));
        try {
            MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.BYTE_ONE});
            Assert.fail((String)"should throw NoSuchMethodException");
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.LONG_ONE});
            Assert.fail((String)"should throw NoSuchMethodException");
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{Boolean.TRUE});
            Assert.fail((String)"should throw NoSuchMethodException");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @Test
    public void testGetAccessibleInterfaceMethod() throws Exception {
        Class[][] p;
        for (Class[] element : p = new Class[][]{ArrayUtils.EMPTY_CLASS_ARRAY, null}) {
            Method method = TestMutable.class.getMethod("getValue", element);
            Method accessibleMethod = MethodUtils.getAccessibleMethod((Method)method);
            Assert.assertNotSame((Object)accessibleMethod, (Object)method);
            Assert.assertSame(Mutable.class, accessibleMethod.getDeclaringClass());
        }
    }

    @Test
    public void testGetAccessibleMethodPrivateInterface() throws Exception {
        Method expected = TestBeanWithInterfaces.class.getMethod("foo", new Class[0]);
        Assert.assertNotNull((Object)expected);
        Method actual = MethodUtils.getAccessibleMethod(TestBeanWithInterfaces.class, (String)"foo", (Class[])new Class[0]);
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testGetAccessibleInterfaceMethodFromDescription() throws Exception {
        Class[][] p;
        for (Class[] element : p = new Class[][]{ArrayUtils.EMPTY_CLASS_ARRAY, null}) {
            Method accessibleMethod = MethodUtils.getAccessibleMethod(TestMutable.class, (String)"getValue", (Class[])element);
            Assert.assertSame(Mutable.class, accessibleMethod.getDeclaringClass());
        }
    }

    @Test
    public void testGetAccessiblePublicMethod() throws Exception {
        Assert.assertSame(MutableObject.class, MethodUtils.getAccessibleMethod((Method)MutableObject.class.getMethod("getValue", ArrayUtils.EMPTY_CLASS_ARRAY)).getDeclaringClass());
    }

    @Test
    public void testGetAccessiblePublicMethodFromDescription() throws Exception {
        Assert.assertSame(MutableObject.class, MethodUtils.getAccessibleMethod(MutableObject.class, (String)"getValue", (Class[])ArrayUtils.EMPTY_CLASS_ARRAY).getDeclaringClass());
    }

    @Test
    public void testGetAccessibleMethodInaccessible() throws Exception {
        Method expected = TestBean.class.getDeclaredMethod("privateStuff", new Class[0]);
        Method actual = MethodUtils.getAccessibleMethod((Method)expected);
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testGetMatchingAccessibleMethod() throws Exception {
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", ArrayUtils.EMPTY_CLASS_ARRAY, ArrayUtils.EMPTY_CLASS_ARRAY);
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", null, ArrayUtils.EMPTY_CLASS_ARRAY);
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(String.class), this.singletonArray(String.class));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Object.class), this.singletonArray(Object.class));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Boolean.class), this.singletonArray(Object.class));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Byte.class), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Byte.TYPE), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Short.class), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Short.TYPE), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Character.class), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Character.TYPE), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Integer.class), this.singletonArray(Integer.class));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Integer.TYPE), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Long.class), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Long.TYPE), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Float.class), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Float.TYPE), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Double.class), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Double.TYPE), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Double.TYPE), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(InheritanceBean.class, "testOne", this.singletonArray(ParentObject.class), this.singletonArray(ParentObject.class));
        this.expectMatchingAccessibleMethodParameterTypes(InheritanceBean.class, "testOne", this.singletonArray(ChildObject.class), this.singletonArray(ParentObject.class));
        this.expectMatchingAccessibleMethodParameterTypes(InheritanceBean.class, "testTwo", this.singletonArray(ParentObject.class), this.singletonArray(GrandParentObject.class));
        this.expectMatchingAccessibleMethodParameterTypes(InheritanceBean.class, "testTwo", this.singletonArray(ChildObject.class), this.singletonArray(ChildInterface.class));
    }

    @Test
    public void testNullArgument() {
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "oneParameter", this.singletonArray(null), this.singletonArray(String.class));
    }

    @Test
    public void testGetOverrideHierarchyIncludingInterfaces() {
        Method method = MethodUtils.getAccessibleMethod(StringParameterizedChild.class, (String)"consume", (Class[])new Class[]{String.class});
        Iterator<MethodDescriptor> expected = Arrays.asList(new MethodDescriptor(StringParameterizedChild.class, "consume", new Type[]{String.class}), new MethodDescriptor(GenericParent.class, "consume", GenericParent.class.getTypeParameters()[0]), new MethodDescriptor(GenericConsumer.class, "consume", GenericConsumer.class.getTypeParameters()[0])).iterator();
        for (Method m : MethodUtils.getOverrideHierarchy((Method)method, (ClassUtils.Interfaces)ClassUtils.Interfaces.INCLUDE)) {
            Assert.assertTrue((boolean)expected.hasNext());
            MethodDescriptor md = expected.next();
            Assert.assertEquals(md.declaringClass, m.getDeclaringClass());
            Assert.assertEquals((Object)md.name, (Object)m.getName());
            Assert.assertEquals((long)md.parameterTypes.length, (long)m.getParameterTypes().length);
            for (int i = 0; i < md.parameterTypes.length; ++i) {
                Assert.assertTrue((boolean)TypeUtils.equals((Type)md.parameterTypes[i], (Type)m.getGenericParameterTypes()[i]));
            }
        }
        Assert.assertFalse((boolean)expected.hasNext());
    }

    @Test
    public void testGetOverrideHierarchyExcludingInterfaces() {
        Method method = MethodUtils.getAccessibleMethod(StringParameterizedChild.class, (String)"consume", (Class[])new Class[]{String.class});
        Iterator<MethodDescriptor> expected = Arrays.asList(new MethodDescriptor(StringParameterizedChild.class, "consume", new Type[]{String.class}), new MethodDescriptor(GenericParent.class, "consume", GenericParent.class.getTypeParameters()[0])).iterator();
        for (Method m : MethodUtils.getOverrideHierarchy((Method)method, (ClassUtils.Interfaces)ClassUtils.Interfaces.EXCLUDE)) {
            Assert.assertTrue((boolean)expected.hasNext());
            MethodDescriptor md = expected.next();
            Assert.assertEquals(md.declaringClass, m.getDeclaringClass());
            Assert.assertEquals((Object)md.name, (Object)m.getName());
            Assert.assertEquals((long)md.parameterTypes.length, (long)m.getParameterTypes().length);
            for (int i = 0; i < md.parameterTypes.length; ++i) {
                Assert.assertTrue((boolean)TypeUtils.equals((Type)md.parameterTypes[i], (Type)m.getGenericParameterTypes()[i]));
            }
        }
        Assert.assertFalse((boolean)expected.hasNext());
    }

    @Test
    @Annotated
    public void testGetMethodsWithAnnotation() throws NoSuchMethodException {
        Assert.assertArrayEquals((Object[])new Method[0], (Object[])MethodUtils.getMethodsWithAnnotation(Object.class, Annotated.class));
        Method[] methodsWithAnnotation = MethodUtils.getMethodsWithAnnotation(MethodUtilsTest.class, Annotated.class);
        Assert.assertEquals((long)2L, (long)methodsWithAnnotation.length);
        Assert.assertThat((Object)methodsWithAnnotation, (Matcher)Matchers.hasItemInArray((Object)MethodUtilsTest.class.getMethod("testGetMethodsWithAnnotation", new Class[0])));
        Assert.assertThat((Object)methodsWithAnnotation, (Matcher)Matchers.hasItemInArray((Object)MethodUtilsTest.class.getMethod("testGetMethodsListWithAnnotation", new Class[0])));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetMethodsWithAnnotationIllegalArgumentException1() {
        MethodUtils.getMethodsWithAnnotation(FieldUtilsTest.class, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetMethodsWithAnnotationIllegalArgumentException2() {
        MethodUtils.getMethodsWithAnnotation(null, Annotated.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetMethodsWithAnnotationIllegalArgumentException3() {
        MethodUtils.getMethodsWithAnnotation(null, null);
    }

    @Test
    @Annotated
    public void testGetMethodsListWithAnnotation() throws NoSuchMethodException {
        Assert.assertEquals((long)0L, (long)MethodUtils.getMethodsListWithAnnotation(Object.class, Annotated.class).size());
        List methodWithAnnotation = MethodUtils.getMethodsListWithAnnotation(MethodUtilsTest.class, Annotated.class);
        Assert.assertEquals((long)2L, (long)methodWithAnnotation.size());
        Assert.assertThat((Object)methodWithAnnotation, (Matcher)Matchers.hasItems((Object[])new Method[]{MethodUtilsTest.class.getMethod("testGetMethodsWithAnnotation", new Class[0]), MethodUtilsTest.class.getMethod("testGetMethodsListWithAnnotation", new Class[0])}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetMethodsListWithAnnotationIllegalArgumentException1() {
        MethodUtils.getMethodsListWithAnnotation(FieldUtilsTest.class, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetMethodsListWithAnnotationIllegalArgumentException2() {
        MethodUtils.getMethodsListWithAnnotation(null, Annotated.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetMethodsListWithAnnotationIllegalArgumentException3() {
        MethodUtils.getMethodsListWithAnnotation(null, null);
    }

    private void expectMatchingAccessibleMethodParameterTypes(Class<?> cls, String methodName, Class<?>[] requestTypes, Class<?>[] actualTypes) {
        Method m = MethodUtils.getMatchingAccessibleMethod(cls, (String)methodName, (Class[])requestTypes);
        Assert.assertTrue((String)(this.toString(m.getParameterTypes()) + " not equals " + this.toString(actualTypes)), (boolean)Arrays.equals(actualTypes, m.getParameterTypes()));
    }

    private String toString(Class<?>[] c) {
        return Arrays.asList(c).toString();
    }

    private Class<?>[] singletonArray(Class<?> c) {
        Class<?>[] result = this.classCache.get(c);
        if (result == null) {
            result = new Class[]{c};
            this.classCache.put(c, result);
        }
        return result;
    }

    private static class MethodDescriptor {
        final Class<?> declaringClass;
        final String name;
        final Type[] parameterTypes;

        MethodDescriptor(Class<?> declaringClass, String name, Type ... parameterTypes) {
            this.declaringClass = declaringClass;
            this.name = name;
            this.parameterTypes = parameterTypes;
        }
    }

    public static class ChildObject
    extends ParentObject
    implements ChildInterface {
    }

    public static class ParentObject
    extends GrandParentObject {
    }

    public static class GrandParentObject {
    }

    static interface ChildInterface {
    }

    public static class InheritanceBean {
        public void testOne(Object obj) {
        }

        public void testOne(GrandParentObject obj) {
        }

        public void testOne(ParentObject obj) {
        }

        public void testTwo(Object obj) {
        }

        public void testTwo(GrandParentObject obj) {
        }

        public void testTwo(ChildInterface obj) {
        }
    }

    private static class TestMutable
    implements Mutable<Object> {
        private TestMutable() {
        }

        public Object getValue() {
            return null;
        }

        public void setValue(Object value) {
        }
    }

    public static class TestBean {
        public static String bar() {
            return "bar()";
        }

        public static String bar(int i) {
            return "bar(int)";
        }

        public static String bar(Integer i) {
            return "bar(Integer)";
        }

        public static String bar(double d) {
            return "bar(double)";
        }

        public static String bar(String s) {
            return "bar(String)";
        }

        public static String bar(Object o) {
            return "bar(Object)";
        }

        public static void oneParameterStatic(String s) {
        }

        private void privateStuff() {
        }

        public String foo() {
            return "foo()";
        }

        public String foo(int i) {
            return "foo(int)";
        }

        public String foo(Integer i) {
            return "foo(Integer)";
        }

        public String foo(double d) {
            return "foo(double)";
        }

        public String foo(String s) {
            return "foo(String)";
        }

        public String foo(Object o) {
            return "foo(Object)";
        }

        public void oneParameter(String s) {
        }
    }

    static class TestBeanWithInterfaces
    implements PrivateInterface {
        TestBeanWithInterfaces() {
        }

        public String foo() {
            return "foo()";
        }
    }

    private static interface PrivateInterface {
    }
}

