/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.text.StrLookup;
import org.junit.Assert;
import org.junit.Test;

public class StrLookupTest {
    @Test
    public void testNoneLookup() {
        Assert.assertEquals(null, (Object)StrLookup.noneLookup().lookup(null));
        Assert.assertEquals(null, (Object)StrLookup.noneLookup().lookup(""));
        Assert.assertEquals(null, (Object)StrLookup.noneLookup().lookup("any"));
    }

    @Test
    public void testSystemProperiesLookup() {
        Assert.assertEquals((Object)System.getProperty("os.name"), (Object)StrLookup.systemPropertiesLookup().lookup("os.name"));
        Assert.assertEquals(null, (Object)StrLookup.systemPropertiesLookup().lookup(""));
        Assert.assertEquals(null, (Object)StrLookup.systemPropertiesLookup().lookup("other"));
        try {
            StrLookup.systemPropertiesLookup().lookup(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testSystemPropertiesLookupNotSingleton() {
        String osName = "os.name";
        String originalOsName = System.getProperty("os.name");
        StrLookup properties1 = StrLookup.systemPropertiesLookup();
        Assert.assertEquals((Object)originalOsName, (Object)properties1.lookup("os.name"));
        String differentOsName = "HAL-9000";
        System.setProperty("os.name", "HAL-9000");
        StrLookup properties2 = StrLookup.systemPropertiesLookup();
        Assert.assertEquals((Object)originalOsName, (Object)properties1.lookup("os.name"));
        Assert.assertEquals((Object)"HAL-9000", (Object)properties2.lookup("os.name"));
    }

    @Test
    public void testMapLookup() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", "value");
        map.put("number", 2);
        Assert.assertEquals((Object)"value", (Object)StrLookup.mapLookup(map).lookup("key"));
        Assert.assertEquals((Object)"2", (Object)StrLookup.mapLookup(map).lookup("number"));
        Assert.assertEquals(null, (Object)StrLookup.mapLookup(map).lookup(null));
        Assert.assertEquals(null, (Object)StrLookup.mapLookup(map).lookup(""));
        Assert.assertEquals(null, (Object)StrLookup.mapLookup(map).lookup("other"));
    }

    @Test
    public void testMapLookup_nullMap() {
        Map map = null;
        Assert.assertEquals(null, (Object)StrLookup.mapLookup(map).lookup(null));
        Assert.assertEquals(null, (Object)StrLookup.mapLookup(map).lookup(""));
        Assert.assertEquals(null, (Object)StrLookup.mapLookup(map).lookup("any"));
    }
}

