/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FastDatePrinterTimeZonesTest {
    private static final String PATTERN = "h:mma z";
    private TimeZone timeZone;

    @Parameterized.Parameters
    public static Collection<TimeZone> data() {
        String[] zoneIds = TimeZone.getAvailableIDs();
        ArrayList<TimeZone> timeZones = new ArrayList<TimeZone>();
        for (String zoneId : zoneIds) {
            timeZones.add(TimeZone.getTimeZone(zoneId));
        }
        return timeZones;
    }

    public FastDatePrinterTimeZonesTest(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Test
    public void testCalendarTimezoneRespected() {
        Calendar cal = Calendar.getInstance(this.timeZone);
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN);
        sdf.setTimeZone(this.timeZone);
        String expectedValue = sdf.format(cal.getTime());
        String actualValue = FastDateFormat.getInstance((String)PATTERN).format(cal);
        Assert.assertEquals((Object)expectedValue, (Object)actualValue);
    }
}

