/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.RegExUtils;
import org.junit.Assert;
import org.junit.Test;

public class RegExUtilsTest {
    @Test
    public void testRemoveAll_StringPattern() {
        Assert.assertNull((Object)RegExUtils.removeAll(null, (Pattern)Pattern.compile("")));
        Assert.assertEquals((Object)"any", (Object)RegExUtils.removeAll((String)"any", (Pattern)null));
        Assert.assertEquals((Object)"any", (Object)RegExUtils.removeAll((String)"any", (Pattern)Pattern.compile("")));
        Assert.assertEquals((Object)"", (Object)RegExUtils.removeAll((String)"any", (Pattern)Pattern.compile(".*")));
        Assert.assertEquals((Object)"", (Object)RegExUtils.removeAll((String)"any", (Pattern)Pattern.compile(".+")));
        Assert.assertEquals((Object)"", (Object)RegExUtils.removeAll((String)"any", (Pattern)Pattern.compile(".?")));
        Assert.assertEquals((Object)"A\nB", (Object)RegExUtils.removeAll((String)"A<__>\n<__>B", (Pattern)Pattern.compile("<.*>")));
        Assert.assertEquals((Object)"AB", (Object)RegExUtils.removeAll((String)"A<__>\n<__>B", (Pattern)Pattern.compile("(?s)<.*>")));
        Assert.assertEquals((Object)"ABC123", (Object)RegExUtils.removeAll((String)"ABCabc123abc", (Pattern)Pattern.compile("[a-z]")));
        Assert.assertEquals((Object)"AB", (Object)RegExUtils.removeAll((String)"A<__>\n<__>B", (Pattern)Pattern.compile("<.*>", 32)));
        Assert.assertEquals((Object)"AB", (Object)RegExUtils.removeAll((String)"A<__>\\n<__>B", (Pattern)Pattern.compile("<.*>")));
        Assert.assertEquals((Object)"", (Object)RegExUtils.removeAll((String)"<A>x\\ny</A>", (Pattern)Pattern.compile("<A>.*</A>")));
        Assert.assertEquals((Object)"", (Object)RegExUtils.removeAll((String)"<A>\nxy\n</A>", (Pattern)Pattern.compile("<A>.*</A>", 32)));
    }

    @Test
    public void testRemoveAll_StringString() {
        Assert.assertNull((Object)RegExUtils.removeAll(null, (String)""));
        Assert.assertEquals((Object)"any", (Object)RegExUtils.removeAll((String)"any", (String)null));
        Assert.assertEquals((Object)"any", (Object)RegExUtils.removeAll((String)"any", (String)""));
        Assert.assertEquals((Object)"", (Object)RegExUtils.removeAll((String)"any", (String)".*"));
        Assert.assertEquals((Object)"", (Object)RegExUtils.removeAll((String)"any", (String)".+"));
        Assert.assertEquals((Object)"", (Object)RegExUtils.removeAll((String)"any", (String)".?"));
        Assert.assertEquals((Object)"A\nB", (Object)RegExUtils.removeAll((String)"A<__>\n<__>B", (String)"<.*>"));
        Assert.assertEquals((Object)"AB", (Object)RegExUtils.removeAll((String)"A<__>\n<__>B", (String)"(?s)<.*>"));
        Assert.assertEquals((Object)"ABC123", (Object)RegExUtils.removeAll((String)"ABCabc123abc", (String)"[a-z]"));
        try {
            RegExUtils.removeAll((String)"any", (String)"{badRegexSyntax}");
            Assert.fail((String)"RegExUtils.removeAll expecting PatternSyntaxException");
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveFirst_StringPattern() {
        Assert.assertNull((Object)RegExUtils.removeFirst(null, (Pattern)Pattern.compile("")));
        Assert.assertEquals((Object)"any", (Object)RegExUtils.removeFirst((String)"any", (Pattern)null));
        Assert.assertEquals((Object)"any", (Object)RegExUtils.removeFirst((String)"any", (Pattern)Pattern.compile("")));
        Assert.assertEquals((Object)"", (Object)RegExUtils.removeFirst((String)"any", (Pattern)Pattern.compile(".*")));
        Assert.assertEquals((Object)"", (Object)RegExUtils.removeFirst((String)"any", (Pattern)Pattern.compile(".+")));
        Assert.assertEquals((Object)"bc", (Object)RegExUtils.removeFirst((String)"abc", (Pattern)Pattern.compile(".?")));
        Assert.assertEquals((Object)"A\n<__>B", (Object)RegExUtils.removeFirst((String)"A<__>\n<__>B", (Pattern)Pattern.compile("<.*>")));
        Assert.assertEquals((Object)"AB", (Object)RegExUtils.removeFirst((String)"A<__>\n<__>B", (Pattern)Pattern.compile("(?s)<.*>")));
        Assert.assertEquals((Object)"ABCbc123", (Object)RegExUtils.removeFirst((String)"ABCabc123", (Pattern)Pattern.compile("[a-z]")));
        Assert.assertEquals((Object)"ABC123abc", (Object)RegExUtils.removeFirst((String)"ABCabc123abc", (Pattern)Pattern.compile("[a-z]+")));
    }

    @Test
    public void testRemoveFirst_StringString() {
        Assert.assertNull((Object)RegExUtils.removeFirst(null, (String)""));
        Assert.assertEquals((Object)"any", (Object)RegExUtils.removeFirst((String)"any", (String)null));
        Assert.assertEquals((Object)"any", (Object)RegExUtils.removeFirst((String)"any", (String)""));
        Assert.assertEquals((Object)"", (Object)RegExUtils.removeFirst((String)"any", (String)".*"));
        Assert.assertEquals((Object)"", (Object)RegExUtils.removeFirst((String)"any", (String)".+"));
        Assert.assertEquals((Object)"bc", (Object)RegExUtils.removeFirst((String)"abc", (String)".?"));
        Assert.assertEquals((Object)"A\n<__>B", (Object)RegExUtils.removeFirst((String)"A<__>\n<__>B", (String)"<.*>"));
        Assert.assertEquals((Object)"AB", (Object)RegExUtils.removeFirst((String)"A<__>\n<__>B", (String)"(?s)<.*>"));
        Assert.assertEquals((Object)"ABCbc123", (Object)RegExUtils.removeFirst((String)"ABCabc123", (String)"[a-z]"));
        Assert.assertEquals((Object)"ABC123abc", (Object)RegExUtils.removeFirst((String)"ABCabc123abc", (String)"[a-z]+"));
        try {
            RegExUtils.removeFirst((String)"any", (String)"{badRegexSyntax}");
            Assert.fail((String)"RegExUtils.removeFirst expecting PatternSyntaxException");
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }

    @Test
    public void testRemovePattern_StringString() {
        Assert.assertNull((Object)RegExUtils.removePattern(null, (String)""));
        Assert.assertEquals((Object)"any", (Object)RegExUtils.removePattern((String)"any", (String)null));
        Assert.assertEquals((Object)"", (Object)RegExUtils.removePattern((String)"", (String)""));
        Assert.assertEquals((Object)"", (Object)RegExUtils.removePattern((String)"", (String)".*"));
        Assert.assertEquals((Object)"", (Object)RegExUtils.removePattern((String)"", (String)".+"));
        Assert.assertEquals((Object)"AB", (Object)RegExUtils.removePattern((String)"A<__>\n<__>B", (String)"<.*>"));
        Assert.assertEquals((Object)"AB", (Object)RegExUtils.removePattern((String)"A<__>\\n<__>B", (String)"<.*>"));
        Assert.assertEquals((Object)"", (Object)RegExUtils.removePattern((String)"<A>x\\ny</A>", (String)"<A>.*</A>"));
        Assert.assertEquals((Object)"", (Object)RegExUtils.removePattern((String)"<A>\nxy\n</A>", (String)"<A>.*</A>"));
        Assert.assertEquals((Object)"ABC123", (Object)RegExUtils.removePattern((String)"ABCabc123", (String)"[a-z]"));
    }

    @Test
    public void testReplaceAll_StringPatternString() {
        Assert.assertNull((Object)RegExUtils.replaceAll(null, (Pattern)Pattern.compile(""), (String)""));
        Assert.assertEquals((Object)"any", (Object)RegExUtils.replaceAll((String)"any", (Pattern)null, (String)""));
        Assert.assertEquals((Object)"any", (Object)RegExUtils.replaceAll((String)"any", (Pattern)Pattern.compile(""), null));
        Assert.assertEquals((Object)"zzz", (Object)RegExUtils.replaceAll((String)"", (Pattern)Pattern.compile(""), (String)"zzz"));
        Assert.assertEquals((Object)"zzz", (Object)RegExUtils.replaceAll((String)"", (Pattern)Pattern.compile(".*"), (String)"zzz"));
        Assert.assertEquals((Object)"", (Object)RegExUtils.replaceAll((String)"", (Pattern)Pattern.compile(".+"), (String)"zzz"));
        Assert.assertEquals((Object)"ZZaZZbZZcZZ", (Object)RegExUtils.replaceAll((String)"abc", (Pattern)Pattern.compile(""), (String)"ZZ"));
        Assert.assertEquals((Object)"z\nz", (Object)RegExUtils.replaceAll((String)"<__>\n<__>", (Pattern)Pattern.compile("<.*>"), (String)"z"));
        Assert.assertEquals((Object)"z", (Object)RegExUtils.replaceAll((String)"<__>\n<__>", (Pattern)Pattern.compile("(?s)<.*>"), (String)"z"));
        Assert.assertEquals((Object)"z", (Object)RegExUtils.replaceAll((String)"<__>\n<__>", (Pattern)Pattern.compile("<.*>", 32), (String)"z"));
        Assert.assertEquals((Object)"z", (Object)RegExUtils.replaceAll((String)"<__>\\n<__>", (Pattern)Pattern.compile("<.*>"), (String)"z"));
        Assert.assertEquals((Object)"X", (Object)RegExUtils.replaceAll((String)"<A>\nxy\n</A>", (Pattern)Pattern.compile("<A>.*</A>", 32), (String)"X"));
        Assert.assertEquals((Object)"ABC___123", (Object)RegExUtils.replaceAll((String)"ABCabc123", (Pattern)Pattern.compile("[a-z]"), (String)"_"));
        Assert.assertEquals((Object)"ABC_123", (Object)RegExUtils.replaceAll((String)"ABCabc123", (Pattern)Pattern.compile("[^A-Z0-9]+"), (String)"_"));
        Assert.assertEquals((Object)"ABC123", (Object)RegExUtils.replaceAll((String)"ABCabc123", (Pattern)Pattern.compile("[^A-Z0-9]+"), (String)""));
        Assert.assertEquals((Object)"Lorem_ipsum_dolor_sit", (Object)RegExUtils.replaceAll((String)"Lorem ipsum  dolor   sit", (Pattern)Pattern.compile("( +)([a-z]+)"), (String)"_$2"));
    }

    @Test
    public void testReplaceAll_StringStringString() {
        Assert.assertNull((Object)RegExUtils.replaceAll(null, (String)"", (String)""));
        Assert.assertEquals((Object)"any", (Object)RegExUtils.replaceAll((String)"any", (String)null, (String)""));
        Assert.assertEquals((Object)"any", (Object)RegExUtils.replaceAll((String)"any", (String)"", null));
        Assert.assertEquals((Object)"zzz", (Object)RegExUtils.replaceAll((String)"", (String)"", (String)"zzz"));
        Assert.assertEquals((Object)"zzz", (Object)RegExUtils.replaceAll((String)"", (String)".*", (String)"zzz"));
        Assert.assertEquals((Object)"", (Object)RegExUtils.replaceAll((String)"", (String)".+", (String)"zzz"));
        Assert.assertEquals((Object)"ZZaZZbZZcZZ", (Object)RegExUtils.replaceAll((String)"abc", (String)"", (String)"ZZ"));
        Assert.assertEquals((Object)"z\nz", (Object)RegExUtils.replaceAll((String)"<__>\n<__>", (String)"<.*>", (String)"z"));
        Assert.assertEquals((Object)"z", (Object)RegExUtils.replaceAll((String)"<__>\n<__>", (String)"(?s)<.*>", (String)"z"));
        Assert.assertEquals((Object)"ABC___123", (Object)RegExUtils.replaceAll((String)"ABCabc123", (String)"[a-z]", (String)"_"));
        Assert.assertEquals((Object)"ABC_123", (Object)RegExUtils.replaceAll((String)"ABCabc123", (String)"[^A-Z0-9]+", (String)"_"));
        Assert.assertEquals((Object)"ABC123", (Object)RegExUtils.replaceAll((String)"ABCabc123", (String)"[^A-Z0-9]+", (String)""));
        Assert.assertEquals((Object)"Lorem_ipsum_dolor_sit", (Object)RegExUtils.replaceAll((String)"Lorem ipsum  dolor   sit", (String)"( +)([a-z]+)", (String)"_$2"));
        try {
            RegExUtils.replaceAll((String)"any", (String)"{badRegexSyntax}", (String)"");
            Assert.fail((String)"RegExUtils.replaceAll expecting PatternSyntaxException");
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }

    @Test
    public void testReplaceFirst_StringPatternString() {
        Assert.assertNull((Object)RegExUtils.replaceFirst(null, (Pattern)Pattern.compile(""), (String)""));
        Assert.assertEquals((Object)"any", (Object)RegExUtils.replaceFirst((String)"any", (Pattern)null, (String)""));
        Assert.assertEquals((Object)"any", (Object)RegExUtils.replaceFirst((String)"any", (Pattern)Pattern.compile(""), null));
        Assert.assertEquals((Object)"zzz", (Object)RegExUtils.replaceFirst((String)"", (Pattern)Pattern.compile(""), (String)"zzz"));
        Assert.assertEquals((Object)"zzz", (Object)RegExUtils.replaceFirst((String)"", (Pattern)Pattern.compile(".*"), (String)"zzz"));
        Assert.assertEquals((Object)"", (Object)RegExUtils.replaceFirst((String)"", (Pattern)Pattern.compile(".+"), (String)"zzz"));
        Assert.assertEquals((Object)"ZZabc", (Object)RegExUtils.replaceFirst((String)"abc", (Pattern)Pattern.compile(""), (String)"ZZ"));
        Assert.assertEquals((Object)"z\n<__>", (Object)RegExUtils.replaceFirst((String)"<__>\n<__>", (Pattern)Pattern.compile("<.*>"), (String)"z"));
        Assert.assertEquals((Object)"z", (Object)RegExUtils.replaceFirst((String)"<__>\n<__>", (Pattern)Pattern.compile("(?s)<.*>"), (String)"z"));
        Assert.assertEquals((Object)"ABC_bc123", (Object)RegExUtils.replaceFirst((String)"ABCabc123", (Pattern)Pattern.compile("[a-z]"), (String)"_"));
        Assert.assertEquals((Object)"ABC_123abc", (Object)RegExUtils.replaceFirst((String)"ABCabc123abc", (Pattern)Pattern.compile("[^A-Z0-9]+"), (String)"_"));
        Assert.assertEquals((Object)"ABC123abc", (Object)RegExUtils.replaceFirst((String)"ABCabc123abc", (Pattern)Pattern.compile("[^A-Z0-9]+"), (String)""));
        Assert.assertEquals((Object)"Lorem_ipsum  dolor   sit", (Object)RegExUtils.replaceFirst((String)"Lorem ipsum  dolor   sit", (Pattern)Pattern.compile("( +)([a-z]+)"), (String)"_$2"));
    }

    @Test
    public void testReplaceFirst_StringStringString() {
        Assert.assertNull((Object)RegExUtils.replaceFirst(null, (String)"", (String)""));
        Assert.assertEquals((Object)"any", (Object)RegExUtils.replaceFirst((String)"any", (String)null, (String)""));
        Assert.assertEquals((Object)"any", (Object)RegExUtils.replaceFirst((String)"any", (String)"", null));
        Assert.assertEquals((Object)"zzz", (Object)RegExUtils.replaceFirst((String)"", (String)"", (String)"zzz"));
        Assert.assertEquals((Object)"zzz", (Object)RegExUtils.replaceFirst((String)"", (String)".*", (String)"zzz"));
        Assert.assertEquals((Object)"", (Object)RegExUtils.replaceFirst((String)"", (String)".+", (String)"zzz"));
        Assert.assertEquals((Object)"ZZabc", (Object)RegExUtils.replaceFirst((String)"abc", (String)"", (String)"ZZ"));
        Assert.assertEquals((Object)"z\n<__>", (Object)RegExUtils.replaceFirst((String)"<__>\n<__>", (String)"<.*>", (String)"z"));
        Assert.assertEquals((Object)"z", (Object)RegExUtils.replaceFirst((String)"<__>\n<__>", (String)"(?s)<.*>", (String)"z"));
        Assert.assertEquals((Object)"ABC_bc123", (Object)RegExUtils.replaceFirst((String)"ABCabc123", (String)"[a-z]", (String)"_"));
        Assert.assertEquals((Object)"ABC_123abc", (Object)RegExUtils.replaceFirst((String)"ABCabc123abc", (String)"[^A-Z0-9]+", (String)"_"));
        Assert.assertEquals((Object)"ABC123abc", (Object)RegExUtils.replaceFirst((String)"ABCabc123abc", (String)"[^A-Z0-9]+", (String)""));
        Assert.assertEquals((Object)"Lorem_ipsum  dolor   sit", (Object)RegExUtils.replaceFirst((String)"Lorem ipsum  dolor   sit", (String)"( +)([a-z]+)", (String)"_$2"));
        try {
            RegExUtils.replaceFirst((String)"any", (String)"{badRegexSyntax}", (String)"");
            Assert.fail((String)"RegExUtils.replaceFirst expecting PatternSyntaxException");
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }

    @Test
    public void testReplacePattern_StringStringString() {
        Assert.assertNull((Object)RegExUtils.replacePattern(null, (String)"", (String)""));
        Assert.assertEquals((Object)"any", (Object)RegExUtils.replacePattern((String)"any", (String)null, (String)""));
        Assert.assertEquals((Object)"any", (Object)RegExUtils.replacePattern((String)"any", (String)"", null));
        Assert.assertEquals((Object)"zzz", (Object)RegExUtils.replacePattern((String)"", (String)"", (String)"zzz"));
        Assert.assertEquals((Object)"zzz", (Object)RegExUtils.replacePattern((String)"", (String)".*", (String)"zzz"));
        Assert.assertEquals((Object)"", (Object)RegExUtils.replacePattern((String)"", (String)".+", (String)"zzz"));
        Assert.assertEquals((Object)"z", (Object)RegExUtils.replacePattern((String)"<__>\n<__>", (String)"<.*>", (String)"z"));
        Assert.assertEquals((Object)"z", (Object)RegExUtils.replacePattern((String)"<__>\\n<__>", (String)"<.*>", (String)"z"));
        Assert.assertEquals((Object)"X", (Object)RegExUtils.replacePattern((String)"<A>\nxy\n</A>", (String)"<A>.*</A>", (String)"X"));
        Assert.assertEquals((Object)"ABC___123", (Object)RegExUtils.replacePattern((String)"ABCabc123", (String)"[a-z]", (String)"_"));
        Assert.assertEquals((Object)"ABC_123", (Object)RegExUtils.replacePattern((String)"ABCabc123", (String)"[^A-Z0-9]+", (String)"_"));
        Assert.assertEquals((Object)"ABC123", (Object)RegExUtils.replacePattern((String)"ABCabc123", (String)"[^A-Z0-9]+", (String)""));
        Assert.assertEquals((Object)"Lorem_ipsum_dolor_sit", (Object)RegExUtils.replacePattern((String)"Lorem ipsum  dolor   sit", (String)"( +)([a-z]+)", (String)"_$2"));
    }
}

