/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.StringUtilsTest;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilsEmptyBlankTest {
    @Test
    public void testIsEmpty() {
        Assert.assertTrue((boolean)StringUtils.isEmpty(null));
        Assert.assertTrue((boolean)StringUtils.isEmpty((CharSequence)""));
        Assert.assertFalse((boolean)StringUtils.isEmpty((CharSequence)" "));
        Assert.assertFalse((boolean)StringUtils.isEmpty((CharSequence)"foo"));
        Assert.assertFalse((boolean)StringUtils.isEmpty((CharSequence)"  foo  "));
    }

    @Test
    public void testIsNotEmpty() {
        Assert.assertFalse((boolean)StringUtils.isNotEmpty(null));
        Assert.assertFalse((boolean)StringUtils.isNotEmpty((CharSequence)""));
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((CharSequence)" "));
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((CharSequence)"foo"));
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((CharSequence)"  foo  "));
    }

    @Test
    public void testIsAnyEmpty() {
        Assert.assertTrue((boolean)StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{null}));
        Assert.assertFalse((boolean)StringUtils.isAnyEmpty((CharSequence[])null));
        Assert.assertTrue((boolean)StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{null, "foo"}));
        Assert.assertTrue((boolean)StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{"", "bar"}));
        Assert.assertTrue((boolean)StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{"bob", ""}));
        Assert.assertTrue((boolean)StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{"  bob  ", null}));
        Assert.assertFalse((boolean)StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{" ", "bar"}));
        Assert.assertFalse((boolean)StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{"foo", "bar"}));
    }

    @Test
    public void testIsNoneEmpty() {
        Assert.assertFalse((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{null}));
        Assert.assertTrue((boolean)StringUtils.isNoneEmpty((CharSequence[])null));
        Assert.assertFalse((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{null, "foo"}));
        Assert.assertFalse((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{"", "bar"}));
        Assert.assertFalse((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{"bob", ""}));
        Assert.assertFalse((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{"  bob  ", null}));
        Assert.assertTrue((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{" ", "bar"}));
        Assert.assertTrue((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{"foo", "bar"}));
    }

    @Test
    public void testIsAllEmpty() {
        Assert.assertTrue((boolean)StringUtils.isAllEmpty((CharSequence[])new CharSequence[0]));
        Assert.assertTrue((boolean)StringUtils.isAllEmpty((CharSequence[])new String[0]));
        Assert.assertTrue((boolean)StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{null}));
        Assert.assertTrue((boolean)StringUtils.isAllEmpty((CharSequence[])null));
        Assert.assertFalse((boolean)StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{null, "foo"}));
        Assert.assertFalse((boolean)StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{"", "bar"}));
        Assert.assertFalse((boolean)StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{"bob", ""}));
        Assert.assertFalse((boolean)StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{"  bob  ", null}));
        Assert.assertFalse((boolean)StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{" ", "bar"}));
        Assert.assertFalse((boolean)StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{"foo", "bar"}));
        Assert.assertTrue((boolean)StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{"", null}));
    }

    @Test
    public void testIsBlank() {
        Assert.assertTrue((boolean)StringUtils.isBlank(null));
        Assert.assertTrue((boolean)StringUtils.isBlank((CharSequence)""));
        Assert.assertTrue((boolean)StringUtils.isBlank((CharSequence)StringUtilsTest.WHITESPACE));
        Assert.assertFalse((boolean)StringUtils.isBlank((CharSequence)"foo"));
        Assert.assertFalse((boolean)StringUtils.isBlank((CharSequence)"  foo  "));
    }

    @Test
    public void testIsNotBlank() {
        Assert.assertFalse((boolean)StringUtils.isNotBlank(null));
        Assert.assertFalse((boolean)StringUtils.isNotBlank((CharSequence)""));
        Assert.assertFalse((boolean)StringUtils.isNotBlank((CharSequence)StringUtilsTest.WHITESPACE));
        Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)"foo"));
        Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)"  foo  "));
    }

    @Test
    public void testIsAnyBlank() {
        Assert.assertTrue((boolean)StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{null}));
        Assert.assertFalse((boolean)StringUtils.isAnyBlank((CharSequence[])null));
        Assert.assertTrue((boolean)StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{null, "foo"}));
        Assert.assertTrue((boolean)StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{null, null}));
        Assert.assertTrue((boolean)StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{"", "bar"}));
        Assert.assertTrue((boolean)StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{"bob", ""}));
        Assert.assertTrue((boolean)StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{"  bob  ", null}));
        Assert.assertTrue((boolean)StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{" ", "bar"}));
        Assert.assertFalse((boolean)StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{"foo", "bar"}));
    }

    @Test
    public void testIsNoneBlank() {
        Assert.assertFalse((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{null}));
        Assert.assertTrue((boolean)StringUtils.isNoneBlank((CharSequence[])null));
        Assert.assertFalse((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{null, "foo"}));
        Assert.assertFalse((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{null, null}));
        Assert.assertFalse((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{"", "bar"}));
        Assert.assertFalse((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{"bob", ""}));
        Assert.assertFalse((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{"  bob  ", null}));
        Assert.assertFalse((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{" ", "bar"}));
        Assert.assertTrue((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{"foo", "bar"}));
    }

    @Test
    public void testIsAllBlank() {
        Assert.assertTrue((boolean)StringUtils.isAllBlank((CharSequence[])new CharSequence[]{null}));
        Assert.assertTrue((boolean)StringUtils.isAllBlank((CharSequence[])null));
        Assert.assertTrue((boolean)StringUtils.isAllBlank((CharSequence[])new CharSequence[]{null, null}));
        Assert.assertTrue((boolean)StringUtils.isAllBlank((CharSequence[])new CharSequence[]{null, " "}));
        Assert.assertFalse((boolean)StringUtils.isAllBlank((CharSequence[])new CharSequence[]{null, "foo"}));
        Assert.assertFalse((boolean)StringUtils.isAllBlank((CharSequence[])new CharSequence[]{"", "bar"}));
        Assert.assertFalse((boolean)StringUtils.isAllBlank((CharSequence[])new CharSequence[]{"bob", ""}));
        Assert.assertFalse((boolean)StringUtils.isAllBlank((CharSequence[])new CharSequence[]{"  bob  ", null}));
        Assert.assertFalse((boolean)StringUtils.isAllBlank((CharSequence[])new CharSequence[]{" ", "bar"}));
        Assert.assertFalse((boolean)StringUtils.isAllBlank((CharSequence[])new CharSequence[]{"foo", "bar"}));
    }

    @Test
    public void testFirstNonBlank() {
        Assert.assertNull((Object)StringUtils.firstNonBlank((CharSequence[])new CharSequence[0]));
        Assert.assertNull((Object)StringUtils.firstNonBlank((CharSequence[])null));
        Assert.assertNull((Object)StringUtils.firstNonBlank((CharSequence[])new CharSequence[]{null, null, null}));
        Assert.assertNull((Object)StringUtils.firstNonBlank((CharSequence[])new String[]{null, "", " "}));
        Assert.assertNull((Object)StringUtils.firstNonBlank((CharSequence[])new String[]{null, null, " "}));
        Assert.assertEquals((Object)"zz", (Object)StringUtils.firstNonBlank((CharSequence[])new String[]{null, "zz"}));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.firstNonBlank((CharSequence[])new String[]{"abc"}));
        Assert.assertEquals((Object)"xyz", (Object)StringUtils.firstNonBlank((CharSequence[])new String[]{null, "xyz"}));
        Assert.assertEquals((Object)"xyz", (Object)StringUtils.firstNonBlank((CharSequence[])new String[]{null, "xyz", "abc"}));
    }

    @Test
    public void testFirstNonEmpty() {
        Assert.assertNull((Object)StringUtils.firstNonEmpty((CharSequence[])new CharSequence[0]));
        Assert.assertNull((Object)StringUtils.firstNonEmpty((CharSequence[])null));
        Assert.assertNull((Object)StringUtils.firstNonEmpty((CharSequence[])new CharSequence[]{null, null, null}));
        Assert.assertEquals((Object)" ", (Object)StringUtils.firstNonEmpty((CharSequence[])new String[]{null, "", " "}));
        Assert.assertNull((Object)StringUtils.firstNonEmpty((CharSequence[])new String[]{null, null, ""}));
        Assert.assertEquals((Object)"zz", (Object)StringUtils.firstNonEmpty((CharSequence[])new String[]{null, "zz"}));
        Assert.assertEquals((Object)"abc", (Object)StringUtils.firstNonEmpty((CharSequence[])new String[]{"abc"}));
        Assert.assertEquals((Object)"xyz", (Object)StringUtils.firstNonEmpty((CharSequence[])new String[]{null, "xyz"}));
        Assert.assertEquals((Object)"xyz", (Object)StringUtils.firstNonEmpty((CharSequence[])new String[]{null, "xyz", "abc"}));
    }
}

