/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilsStartsEndsWithTest {
    private static final String foo = "foo";
    private static final String bar = "bar";
    private static final String foobar = "foobar";
    private static final String FOO = "FOO";
    private static final String BAR = "BAR";
    private static final String FOOBAR = "FOOBAR";

    @Test
    public void testStartsWith() {
        Assert.assertTrue((String)"startsWith(null, null)", (boolean)StringUtils.startsWith(null, null));
        Assert.assertFalse((String)"startsWith(FOOBAR, null)", (boolean)StringUtils.startsWith((CharSequence)FOOBAR, null));
        Assert.assertFalse((String)"startsWith(null, FOO)", (boolean)StringUtils.startsWith(null, (CharSequence)FOO));
        Assert.assertTrue((String)"startsWith(FOOBAR, \"\")", (boolean)StringUtils.startsWith((CharSequence)FOOBAR, (CharSequence)""));
        Assert.assertTrue((String)"startsWith(foobar, foo)", (boolean)StringUtils.startsWith((CharSequence)foobar, (CharSequence)foo));
        Assert.assertTrue((String)"startsWith(FOOBAR, FOO)", (boolean)StringUtils.startsWith((CharSequence)FOOBAR, (CharSequence)FOO));
        Assert.assertFalse((String)"startsWith(foobar, FOO)", (boolean)StringUtils.startsWith((CharSequence)foobar, (CharSequence)FOO));
        Assert.assertFalse((String)"startsWith(FOOBAR, foo)", (boolean)StringUtils.startsWith((CharSequence)FOOBAR, (CharSequence)foo));
        Assert.assertFalse((String)"startsWith(foo, foobar)", (boolean)StringUtils.startsWith((CharSequence)foo, (CharSequence)foobar));
        Assert.assertFalse((String)"startsWith(foo, foobar)", (boolean)StringUtils.startsWith((CharSequence)bar, (CharSequence)foobar));
        Assert.assertFalse((String)"startsWith(foobar, bar)", (boolean)StringUtils.startsWith((CharSequence)foobar, (CharSequence)bar));
        Assert.assertFalse((String)"startsWith(FOOBAR, BAR)", (boolean)StringUtils.startsWith((CharSequence)FOOBAR, (CharSequence)BAR));
        Assert.assertFalse((String)"startsWith(foobar, BAR)", (boolean)StringUtils.startsWith((CharSequence)foobar, (CharSequence)BAR));
        Assert.assertFalse((String)"startsWith(FOOBAR, bar)", (boolean)StringUtils.startsWith((CharSequence)FOOBAR, (CharSequence)bar));
    }

    @Test
    public void testStartsWithIgnoreCase() {
        Assert.assertTrue((String)"startsWithIgnoreCase(null, null)", (boolean)StringUtils.startsWithIgnoreCase(null, null));
        Assert.assertFalse((String)"startsWithIgnoreCase(FOOBAR, null)", (boolean)StringUtils.startsWithIgnoreCase((CharSequence)FOOBAR, null));
        Assert.assertFalse((String)"startsWithIgnoreCase(null, FOO)", (boolean)StringUtils.startsWithIgnoreCase(null, (CharSequence)FOO));
        Assert.assertTrue((String)"startsWithIgnoreCase(FOOBAR, \"\")", (boolean)StringUtils.startsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)""));
        Assert.assertTrue((String)"startsWithIgnoreCase(foobar, foo)", (boolean)StringUtils.startsWithIgnoreCase((CharSequence)foobar, (CharSequence)foo));
        Assert.assertTrue((String)"startsWithIgnoreCase(FOOBAR, FOO)", (boolean)StringUtils.startsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)FOO));
        Assert.assertTrue((String)"startsWithIgnoreCase(foobar, FOO)", (boolean)StringUtils.startsWithIgnoreCase((CharSequence)foobar, (CharSequence)FOO));
        Assert.assertTrue((String)"startsWithIgnoreCase(FOOBAR, foo)", (boolean)StringUtils.startsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)foo));
        Assert.assertFalse((String)"startsWithIgnoreCase(foo, foobar)", (boolean)StringUtils.startsWithIgnoreCase((CharSequence)foo, (CharSequence)foobar));
        Assert.assertFalse((String)"startsWithIgnoreCase(foo, foobar)", (boolean)StringUtils.startsWithIgnoreCase((CharSequence)bar, (CharSequence)foobar));
        Assert.assertFalse((String)"startsWithIgnoreCase(foobar, bar)", (boolean)StringUtils.startsWithIgnoreCase((CharSequence)foobar, (CharSequence)bar));
        Assert.assertFalse((String)"startsWithIgnoreCase(FOOBAR, BAR)", (boolean)StringUtils.startsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)BAR));
        Assert.assertFalse((String)"startsWithIgnoreCase(foobar, BAR)", (boolean)StringUtils.startsWithIgnoreCase((CharSequence)foobar, (CharSequence)BAR));
        Assert.assertFalse((String)"startsWithIgnoreCase(FOOBAR, bar)", (boolean)StringUtils.startsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)bar));
    }

    @Test
    public void testStartsWithAny() {
        Assert.assertFalse((boolean)StringUtils.startsWithAny(null, (CharSequence[])null));
        Assert.assertFalse((boolean)StringUtils.startsWithAny(null, (CharSequence[])new CharSequence[]{"abc"}));
        Assert.assertFalse((boolean)StringUtils.startsWithAny((CharSequence)"abcxyz", (CharSequence[])null));
        Assert.assertFalse((boolean)StringUtils.startsWithAny((CharSequence)"abcxyz", (CharSequence[])new CharSequence[0]));
        Assert.assertTrue((boolean)StringUtils.startsWithAny((CharSequence)"abcxyz", (CharSequence[])new CharSequence[]{"abc"}));
        Assert.assertTrue((boolean)StringUtils.startsWithAny((CharSequence)"abcxyz", (CharSequence[])new CharSequence[]{null, "xyz", "abc"}));
        Assert.assertFalse((boolean)StringUtils.startsWithAny((CharSequence)"abcxyz", (CharSequence[])new CharSequence[]{null, "xyz", "abcd"}));
        Assert.assertTrue((boolean)StringUtils.startsWithAny((CharSequence)"abcxyz", (CharSequence[])new String[]{""}));
        Assert.assertFalse((boolean)StringUtils.startsWithAny((CharSequence)"abcxyz", (CharSequence[])new CharSequence[]{null, "xyz", "ABCX"}));
        Assert.assertFalse((boolean)StringUtils.startsWithAny((CharSequence)"ABCXYZ", (CharSequence[])new CharSequence[]{null, "xyz", "abc"}));
        Assert.assertTrue((String)"StringUtils.startsWithAny(abcxyz, StringBuilder(xyz), StringBuffer(abc))", (boolean)StringUtils.startsWithAny((CharSequence)"abcxyz", (CharSequence[])new CharSequence[]{new StringBuilder("xyz"), new StringBuffer("abc")}));
        Assert.assertTrue((String)"StringUtils.startsWithAny(StringBuffer(abcxyz), StringBuilder(xyz), StringBuffer(abc))", (boolean)StringUtils.startsWithAny((CharSequence)new StringBuffer("abcxyz"), (CharSequence[])new CharSequence[]{new StringBuilder("xyz"), new StringBuffer("abc")}));
    }

    @Test
    public void testEndsWith() {
        Assert.assertTrue((String)"endsWith(null, null)", (boolean)StringUtils.endsWith(null, null));
        Assert.assertFalse((String)"endsWith(FOOBAR, null)", (boolean)StringUtils.endsWith((CharSequence)FOOBAR, null));
        Assert.assertFalse((String)"endsWith(null, FOO)", (boolean)StringUtils.endsWith(null, (CharSequence)FOO));
        Assert.assertTrue((String)"endsWith(FOOBAR, \"\")", (boolean)StringUtils.endsWith((CharSequence)FOOBAR, (CharSequence)""));
        Assert.assertFalse((String)"endsWith(foobar, foo)", (boolean)StringUtils.endsWith((CharSequence)foobar, (CharSequence)foo));
        Assert.assertFalse((String)"endsWith(FOOBAR, FOO)", (boolean)StringUtils.endsWith((CharSequence)FOOBAR, (CharSequence)FOO));
        Assert.assertFalse((String)"endsWith(foobar, FOO)", (boolean)StringUtils.endsWith((CharSequence)foobar, (CharSequence)FOO));
        Assert.assertFalse((String)"endsWith(FOOBAR, foo)", (boolean)StringUtils.endsWith((CharSequence)FOOBAR, (CharSequence)foo));
        Assert.assertFalse((String)"endsWith(foo, foobar)", (boolean)StringUtils.endsWith((CharSequence)foo, (CharSequence)foobar));
        Assert.assertFalse((String)"endsWith(foo, foobar)", (boolean)StringUtils.endsWith((CharSequence)bar, (CharSequence)foobar));
        Assert.assertTrue((String)"endsWith(foobar, bar)", (boolean)StringUtils.endsWith((CharSequence)foobar, (CharSequence)bar));
        Assert.assertTrue((String)"endsWith(FOOBAR, BAR)", (boolean)StringUtils.endsWith((CharSequence)FOOBAR, (CharSequence)BAR));
        Assert.assertFalse((String)"endsWith(foobar, BAR)", (boolean)StringUtils.endsWith((CharSequence)foobar, (CharSequence)BAR));
        Assert.assertFalse((String)"endsWith(FOOBAR, bar)", (boolean)StringUtils.endsWith((CharSequence)FOOBAR, (CharSequence)bar));
        Assert.assertTrue((String)"endsWith(\u03b1\u03b2\u03b3\u03b4, \u03b4)", (boolean)StringUtils.endsWith((CharSequence)"\u03b1\u03b2\u03b3\u03b4", (CharSequence)"\u03b4"));
        Assert.assertFalse((String)"endsWith(\u03b1\u03b2\u03b3\u03b4, \u03b3\u0394)", (boolean)StringUtils.endsWith((CharSequence)"\u03b1\u03b2\u03b3\u03b4", (CharSequence)"\u03b3\u0394"));
    }

    @Test
    public void testEndsWithIgnoreCase() {
        Assert.assertTrue((String)"endsWithIgnoreCase(null, null)", (boolean)StringUtils.endsWithIgnoreCase(null, null));
        Assert.assertFalse((String)"endsWithIgnoreCase(FOOBAR, null)", (boolean)StringUtils.endsWithIgnoreCase((CharSequence)FOOBAR, null));
        Assert.assertFalse((String)"endsWithIgnoreCase(null, FOO)", (boolean)StringUtils.endsWithIgnoreCase(null, (CharSequence)FOO));
        Assert.assertTrue((String)"endsWithIgnoreCase(FOOBAR, \"\")", (boolean)StringUtils.endsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)""));
        Assert.assertFalse((String)"endsWithIgnoreCase(foobar, foo)", (boolean)StringUtils.endsWithIgnoreCase((CharSequence)foobar, (CharSequence)foo));
        Assert.assertFalse((String)"endsWithIgnoreCase(FOOBAR, FOO)", (boolean)StringUtils.endsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)FOO));
        Assert.assertFalse((String)"endsWithIgnoreCase(foobar, FOO)", (boolean)StringUtils.endsWithIgnoreCase((CharSequence)foobar, (CharSequence)FOO));
        Assert.assertFalse((String)"endsWithIgnoreCase(FOOBAR, foo)", (boolean)StringUtils.endsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)foo));
        Assert.assertFalse((String)"endsWithIgnoreCase(foo, foobar)", (boolean)StringUtils.endsWithIgnoreCase((CharSequence)foo, (CharSequence)foobar));
        Assert.assertFalse((String)"endsWithIgnoreCase(foo, foobar)", (boolean)StringUtils.endsWithIgnoreCase((CharSequence)bar, (CharSequence)foobar));
        Assert.assertTrue((String)"endsWithIgnoreCase(foobar, bar)", (boolean)StringUtils.endsWithIgnoreCase((CharSequence)foobar, (CharSequence)bar));
        Assert.assertTrue((String)"endsWithIgnoreCase(FOOBAR, BAR)", (boolean)StringUtils.endsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)BAR));
        Assert.assertTrue((String)"endsWithIgnoreCase(foobar, BAR)", (boolean)StringUtils.endsWithIgnoreCase((CharSequence)foobar, (CharSequence)BAR));
        Assert.assertTrue((String)"endsWithIgnoreCase(FOOBAR, bar)", (boolean)StringUtils.endsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)bar));
        Assert.assertTrue((boolean)StringUtils.endsWithIgnoreCase((CharSequence)"abcdef", (CharSequence)"def"));
        Assert.assertTrue((boolean)StringUtils.endsWithIgnoreCase((CharSequence)"ABCDEF", (CharSequence)"def"));
        Assert.assertFalse((boolean)StringUtils.endsWithIgnoreCase((CharSequence)"ABCDEF", (CharSequence)"cde"));
        Assert.assertTrue((String)"endsWith(\u03b1\u03b2\u03b3\u03b4, \u0394)", (boolean)StringUtils.endsWithIgnoreCase((CharSequence)"\u03b1\u03b2\u03b3\u03b4", (CharSequence)"\u0394"));
        Assert.assertFalse((String)"endsWith(\u03b1\u03b2\u03b3\u03b4, \u0393)", (boolean)StringUtils.endsWithIgnoreCase((CharSequence)"\u03b1\u03b2\u03b3\u03b4", (CharSequence)"\u0393"));
    }

    @Test
    public void testEndsWithAny() {
        Assert.assertFalse((String)"StringUtils.endsWithAny(null, null)", (boolean)StringUtils.endsWithAny(null, (CharSequence[])new CharSequence[]{null}));
        Assert.assertFalse((String)"StringUtils.endsWithAny(null, new String[] {abc})", (boolean)StringUtils.endsWithAny(null, (CharSequence[])new String[]{"abc"}));
        Assert.assertFalse((String)"StringUtils.endsWithAny(abcxyz, null)", (boolean)StringUtils.endsWithAny((CharSequence)"abcxyz", (CharSequence[])new CharSequence[]{null}));
        Assert.assertTrue((String)"StringUtils.endsWithAny(abcxyz, new String[] {\"\"})", (boolean)StringUtils.endsWithAny((CharSequence)"abcxyz", (CharSequence[])new String[]{""}));
        Assert.assertTrue((String)"StringUtils.endsWithAny(abcxyz, new String[] {xyz})", (boolean)StringUtils.endsWithAny((CharSequence)"abcxyz", (CharSequence[])new String[]{"xyz"}));
        Assert.assertTrue((String)"StringUtils.endsWithAny(abcxyz, new String[] {null, xyz, abc})", (boolean)StringUtils.endsWithAny((CharSequence)"abcxyz", (CharSequence[])new String[]{null, "xyz", "abc"}));
        Assert.assertFalse((String)"StringUtils.endsWithAny(defg, new String[] {null, xyz, abc})", (boolean)StringUtils.endsWithAny((CharSequence)"defg", (CharSequence[])new String[]{null, "xyz", "abc"}));
        Assert.assertTrue((boolean)StringUtils.endsWithAny((CharSequence)"abcXYZ", (CharSequence[])new CharSequence[]{"def", "XYZ"}));
        Assert.assertFalse((boolean)StringUtils.endsWithAny((CharSequence)"abcXYZ", (CharSequence[])new CharSequence[]{"def", "xyz"}));
        Assert.assertTrue((boolean)StringUtils.endsWithAny((CharSequence)"abcXYZ", (CharSequence[])new CharSequence[]{"def", "YZ"}));
        Assert.assertFalse((boolean)StringUtils.endsWithAny((CharSequence)"abcXYZ", (CharSequence[])new CharSequence[]{null}));
        Assert.assertFalse((boolean)StringUtils.endsWithAny((CharSequence)"abcXYZ", (CharSequence[])null));
        Assert.assertTrue((boolean)StringUtils.endsWithAny((CharSequence)"abcXYZ", (CharSequence[])new CharSequence[]{""}));
        Assert.assertTrue((String)"StringUtils.endsWithAny(abcxyz, StringBuilder(abc), StringBuffer(xyz))", (boolean)StringUtils.endsWithAny((CharSequence)"abcxyz", (CharSequence[])new CharSequence[]{new StringBuilder("abc"), new StringBuffer("xyz")}));
        Assert.assertTrue((String)"StringUtils.endsWithAny(StringBuffer(abcxyz), StringBuilder(abc), StringBuffer(xyz))", (boolean)StringUtils.endsWithAny((CharSequence)new StringBuffer("abcxyz"), (CharSequence[])new CharSequence[]{new StringBuilder("abc"), new StringBuffer("xyz")}));
    }
}

