/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.CallableBackgroundInitializer;
import org.junit.Assert;
import org.junit.Test;

public class CallableBackgroundInitializerTest {
    private static final Integer RESULT = 42;

    @Test(expected=IllegalArgumentException.class)
    public void testInitNullCallable() {
        new CallableBackgroundInitializer(null);
    }

    @Test
    public void testInitExecutor() throws InterruptedException {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        CallableBackgroundInitializer init = new CallableBackgroundInitializer((Callable)new TestCallable(), exec);
        Assert.assertEquals((String)"Executor not set", (Object)exec, (Object)init.getExternalExecutor());
        exec.shutdown();
        exec.awaitTermination(1L, TimeUnit.SECONDS);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitExecutorNullCallable() throws InterruptedException {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        try {
            new CallableBackgroundInitializer(null, exec);
        }
        finally {
            exec.shutdown();
            exec.awaitTermination(1L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testInitialize() throws Exception {
        TestCallable call = new TestCallable();
        CallableBackgroundInitializer init = new CallableBackgroundInitializer((Callable)call);
        Assert.assertEquals((String)"Wrong result", (Object)RESULT, (Object)init.initialize());
        Assert.assertEquals((String)"Wrong number of invocations", (long)1L, (long)call.callCount);
    }

    private static class TestCallable
    implements Callable<Integer> {
        int callCount;

        private TestCallable() {
        }

        @Override
        public Integer call() throws Exception {
            ++this.callCount;
            return RESULT;
        }
    }
}

