/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.AbstractExceptionContextTest;
import org.apache.commons.lang3.exception.ContextedException;
import org.apache.commons.lang3.exception.DefaultExceptionContext;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.Assert;
import org.junit.Test;

public class ContextedExceptionTest
extends AbstractExceptionContextTest<ContextedException> {
    @Override
    public void setUp() throws Exception {
        this.exceptionContext = new ContextedException((Throwable)new Exception("Test Message"));
        super.setUp();
    }

    @Test
    public void testContextedException() {
        this.exceptionContext = new ContextedException();
        String message = ((ContextedException)this.exceptionContext).getMessage();
        String trace = ExceptionUtils.getStackTrace((Throwable)((Throwable)this.exceptionContext));
        Assert.assertTrue((boolean)trace.contains("ContextedException"));
        Assert.assertTrue((boolean)StringUtils.isEmpty((CharSequence)message));
    }

    @Test
    public void testContextedExceptionString() {
        this.exceptionContext = new ContextedException("Test Message");
        Assert.assertEquals((Object)"Test Message", (Object)((ContextedException)this.exceptionContext).getMessage());
        String trace = ExceptionUtils.getStackTrace((Throwable)((Throwable)this.exceptionContext));
        Assert.assertTrue((boolean)trace.contains("Test Message"));
    }

    @Test
    public void testContextedExceptionThrowable() {
        this.exceptionContext = new ContextedException((Throwable)new Exception("Test Message"));
        String message = ((ContextedException)this.exceptionContext).getMessage();
        String trace = ExceptionUtils.getStackTrace((Throwable)((Throwable)this.exceptionContext));
        Assert.assertTrue((boolean)trace.contains("ContextedException"));
        Assert.assertTrue((boolean)trace.contains("Test Message"));
        Assert.assertTrue((boolean)message.contains("Test Message"));
    }

    @Test
    public void testContextedExceptionStringThrowable() {
        this.exceptionContext = new ContextedException("This is monotonous", (Throwable)new Exception("Test Message"));
        String message = ((ContextedException)this.exceptionContext).getMessage();
        String trace = ExceptionUtils.getStackTrace((Throwable)((Throwable)this.exceptionContext));
        Assert.assertTrue((boolean)trace.contains("ContextedException"));
        Assert.assertTrue((boolean)trace.contains("Test Message"));
        Assert.assertTrue((boolean)trace.contains("This is monotonous"));
        Assert.assertTrue((boolean)message.contains("This is monotonous"));
    }

    @Test
    public void testContextedExceptionStringThrowableContext() {
        this.exceptionContext = new ContextedException("This is monotonous", (Throwable)new Exception("Test Message"), (ExceptionContext)new DefaultExceptionContext());
        String message = ((ContextedException)this.exceptionContext).getMessage();
        String trace = ExceptionUtils.getStackTrace((Throwable)((Throwable)this.exceptionContext));
        Assert.assertTrue((boolean)trace.contains("ContextedException"));
        Assert.assertTrue((boolean)trace.contains("Test Message"));
        Assert.assertTrue((boolean)trace.contains("This is monotonous"));
        Assert.assertTrue((boolean)message.contains("This is monotonous"));
    }

    @Test
    public void testNullExceptionPassing() {
        this.exceptionContext = new ContextedException("This is monotonous", (Throwable)new Exception("Test Message"), null).addContextValue("test1", null).addContextValue("test2", (Object)"some value").addContextValue("test Date", (Object)new Date()).addContextValue("test Nbr", (Object)5).addContextValue("test Poorly written obj", (Object)new AbstractExceptionContextTest.ObjectWithFaultyToString());
        String message = ((ContextedException)this.exceptionContext).getMessage();
        Assert.assertTrue((message != null ? 1 : 0) != 0);
    }

    @Test
    public void testRawMessage() {
        Assert.assertEquals((Object)(Exception.class.getName() + ": " + "Test Message"), (Object)((ContextedException)this.exceptionContext).getRawMessage());
        this.exceptionContext = new ContextedException("This is monotonous", (Throwable)new Exception("Test Message"), (ExceptionContext)new DefaultExceptionContext());
        Assert.assertEquals((Object)"This is monotonous", (Object)((ContextedException)this.exceptionContext).getRawMessage());
        this.exceptionContext = new ContextedException(null, (Throwable)new Exception("Test Message"), (ExceptionContext)new DefaultExceptionContext());
        Assert.assertNull((Object)((ContextedException)this.exceptionContext).getRawMessage());
    }
}

