/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import org.apache.commons.lang3.mutable.MutableObject;
import org.junit.Assert;
import org.junit.Test;

public class MutableObjectTest {
    @Test
    public void testConstructors() {
        Assert.assertNull((Object)new MutableObject().getValue());
        Integer i = 6;
        Assert.assertSame((Object)i, (Object)new MutableObject((Object)i).getValue());
        Assert.assertSame((Object)"HI", (Object)new MutableObject((Object)"HI").getValue());
        Assert.assertSame(null, (Object)new MutableObject(null).getValue());
    }

    @Test
    public void testGetSet() {
        MutableObject mutNum = new MutableObject();
        Assert.assertNull((Object)new MutableObject().getValue());
        mutNum.setValue((Object)"HELLO");
        Assert.assertSame((Object)"HELLO", (Object)mutNum.getValue());
        mutNum.setValue(null);
        Assert.assertSame(null, (Object)mutNum.getValue());
    }

    @Test
    public void testEquals() {
        MutableObject mutNumA = new MutableObject((Object)"ALPHA");
        MutableObject mutNumB = new MutableObject((Object)"ALPHA");
        MutableObject mutNumC = new MutableObject((Object)"BETA");
        MutableObject mutNumD = new MutableObject(null);
        Assert.assertTrue((boolean)mutNumA.equals((Object)mutNumA));
        Assert.assertTrue((boolean)mutNumA.equals((Object)mutNumB));
        Assert.assertTrue((boolean)mutNumB.equals((Object)mutNumA));
        Assert.assertTrue((boolean)mutNumB.equals((Object)mutNumB));
        Assert.assertFalse((boolean)mutNumA.equals((Object)mutNumC));
        Assert.assertFalse((boolean)mutNumB.equals((Object)mutNumC));
        Assert.assertTrue((boolean)mutNumC.equals((Object)mutNumC));
        Assert.assertFalse((boolean)mutNumA.equals((Object)mutNumD));
        Assert.assertTrue((boolean)mutNumD.equals((Object)mutNumD));
        Assert.assertFalse((boolean)mutNumA.equals(null));
        Assert.assertFalse((boolean)mutNumA.equals(new Object()));
        Assert.assertFalse((boolean)mutNumA.equals((Object)"0"));
    }

    @Test
    public void testHashCode() {
        MutableObject mutNumA = new MutableObject((Object)"ALPHA");
        MutableObject mutNumB = new MutableObject((Object)"ALPHA");
        MutableObject mutNumC = new MutableObject((Object)"BETA");
        MutableObject mutNumD = new MutableObject(null);
        Assert.assertTrue((mutNumA.hashCode() == mutNumA.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((mutNumA.hashCode() == mutNumB.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((mutNumA.hashCode() == mutNumC.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((mutNumA.hashCode() == mutNumD.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((mutNumA.hashCode() == "ALPHA".hashCode() ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)mutNumD.hashCode());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"HI", (Object)new MutableObject((Object)"HI").toString());
        Assert.assertEquals((Object)"10.0", (Object)new MutableObject((Object)10.0).toString());
        Assert.assertEquals((Object)"null", (Object)new MutableObject(null).toString());
    }
}

