/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.URI;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.reflect.AAAClass;
import org.apache.commons.lang3.reflect.AAClass;
import org.apache.commons.lang3.reflect.AClass;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.commons.lang3.reflect.testbed.Foo;
import org.apache.commons.lang3.reflect.testbed.GenericParent;
import org.apache.commons.lang3.reflect.testbed.GenericTypeHolder;
import org.apache.commons.lang3.reflect.testbed.StringParameterizedChild;
import org.junit.Assert;
import org.junit.Test;

public class TypeUtilsTest<B> {
    public This<String, String> dis;
    public That<String, String> dat;
    public The<String, String> da;
    public Other<String> uhder;
    public Thing ding;
    public Tester tester;
    public Tester tester2;
    public That<String, String> dat2;
    public That<String, String> dat3;
    public Comparable<? extends Integer>[] intWildcardComparable;
    public static Comparable<String> stringComparable;
    public static Comparable<URI> uriComparable;
    public static Comparable<Integer> intComparable;
    public static Comparable<Long> longComparable;
    public static Comparable<?> wildcardComparable;
    public static URI uri;
    public static List<String>[] stringListArray;
    public Iterable<? extends Map<Integer, ? extends Collection<?>>> iterable;

    public void dummyMethod(List list0, List<Object> list1, List<?> list2, List<? super Object> list3, List<String> list4, List<? extends String> list5, List<? super String> list6, List[] list7, List<Object>[] list8, List<?>[] list9, List<? super Object>[] list10, List<String>[] list11, List<? extends String>[] list12, List<? super String>[] list13) {
    }

    @Test
    public void testIsAssignable() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        Object list0 = null;
        Object list1 = null;
        Object list2 = null;
        Object list3 = null;
        Object list4 = null;
        Object list5 = null;
        Object list6 = null;
        List[] list7 = null;
        List[] list8 = null;
        List[] list9 = null;
        List[] list10 = null;
        List[] list11 = null;
        List[] list12 = null;
        Class<?> clazz = this.getClass();
        Method method = clazz.getMethod("dummyMethod", List.class, List.class, List.class, List.class, List.class, List.class, List.class, List[].class, List[].class, List[].class, List[].class, List[].class, List[].class, List[].class);
        Type[] types = method.getGenericParameterTypes();
        this.delegateBooleanAssertion(types, 0, 0, true);
        list1 = list0;
        this.delegateBooleanAssertion(types, 0, 1, true);
        list0 = list1;
        this.delegateBooleanAssertion(types, 1, 0, true);
        list2 = list0;
        this.delegateBooleanAssertion(types, 0, 2, true);
        list0 = list2;
        this.delegateBooleanAssertion(types, 2, 0, true);
        list3 = list0;
        this.delegateBooleanAssertion(types, 0, 3, true);
        list0 = list3;
        this.delegateBooleanAssertion(types, 3, 0, true);
        list4 = list0;
        this.delegateBooleanAssertion(types, 0, 4, true);
        list0 = list4;
        this.delegateBooleanAssertion(types, 4, 0, true);
        list5 = list0;
        this.delegateBooleanAssertion(types, 0, 5, true);
        list0 = list5;
        this.delegateBooleanAssertion(types, 5, 0, true);
        list6 = list0;
        this.delegateBooleanAssertion(types, 0, 6, true);
        list0 = list6;
        this.delegateBooleanAssertion(types, 6, 0, true);
        this.delegateBooleanAssertion(types, 1, 1, true);
        list2 = list1;
        this.delegateBooleanAssertion(types, 1, 2, true);
        list1 = list2;
        this.delegateBooleanAssertion(types, 2, 1, false);
        list3 = list1;
        this.delegateBooleanAssertion(types, 1, 3, true);
        list1 = list3;
        this.delegateBooleanAssertion(types, 3, 1, false);
        this.delegateBooleanAssertion(types, 1, 4, false);
        this.delegateBooleanAssertion(types, 4, 1, false);
        this.delegateBooleanAssertion(types, 1, 5, false);
        this.delegateBooleanAssertion(types, 5, 1, false);
        list6 = list1;
        this.delegateBooleanAssertion(types, 1, 6, true);
        list1 = list6;
        this.delegateBooleanAssertion(types, 6, 1, false);
        this.delegateBooleanAssertion(types, 2, 2, true);
        list2 = list3;
        this.delegateBooleanAssertion(types, 2, 3, false);
        list2 = list4;
        this.delegateBooleanAssertion(types, 3, 2, true);
        list3 = list2;
        this.delegateBooleanAssertion(types, 2, 4, false);
        list2 = list5;
        this.delegateBooleanAssertion(types, 4, 2, true);
        list4 = list2;
        this.delegateBooleanAssertion(types, 2, 5, false);
        list2 = list6;
        this.delegateBooleanAssertion(types, 5, 2, true);
        list5 = list2;
        this.delegateBooleanAssertion(types, 2, 6, false);
        this.delegateBooleanAssertion(types, 6, 2, true);
        list6 = list2;
        this.delegateBooleanAssertion(types, 3, 3, true);
        this.delegateBooleanAssertion(types, 3, 4, false);
        this.delegateBooleanAssertion(types, 4, 3, false);
        this.delegateBooleanAssertion(types, 3, 5, false);
        this.delegateBooleanAssertion(types, 5, 3, false);
        list6 = list3;
        this.delegateBooleanAssertion(types, 3, 6, true);
        list3 = list6;
        this.delegateBooleanAssertion(types, 6, 3, false);
        this.delegateBooleanAssertion(types, 4, 4, true);
        list5 = list4;
        this.delegateBooleanAssertion(types, 4, 5, true);
        list4 = list5;
        this.delegateBooleanAssertion(types, 5, 4, false);
        list6 = list4;
        this.delegateBooleanAssertion(types, 4, 6, true);
        list4 = list6;
        this.delegateBooleanAssertion(types, 6, 4, false);
        this.delegateBooleanAssertion(types, 5, 5, true);
        list6 = list5;
        this.delegateBooleanAssertion(types, 5, 6, false);
        list5 = list6;
        this.delegateBooleanAssertion(types, 6, 5, false);
        this.delegateBooleanAssertion(types, 6, 6, true);
        this.delegateBooleanAssertion(types, 7, 7, true);
        list8 = list7;
        this.delegateBooleanAssertion(types, 7, 8, true);
        list7 = list8;
        this.delegateBooleanAssertion(types, 8, 7, true);
        list9 = list7;
        this.delegateBooleanAssertion(types, 7, 9, true);
        list7 = list9;
        this.delegateBooleanAssertion(types, 9, 7, true);
        list10 = list7;
        this.delegateBooleanAssertion(types, 7, 10, true);
        list7 = list10;
        this.delegateBooleanAssertion(types, 10, 7, true);
        list11 = list7;
        this.delegateBooleanAssertion(types, 7, 11, true);
        list7 = list11;
        this.delegateBooleanAssertion(types, 11, 7, true);
        list12 = list7;
        this.delegateBooleanAssertion(types, 7, 12, true);
        list7 = list12;
        this.delegateBooleanAssertion(types, 12, 7, true);
        List[] list13 = list7;
        this.delegateBooleanAssertion(types, 7, 13, true);
        list7 = list13;
        this.delegateBooleanAssertion(types, 13, 7, true);
        this.delegateBooleanAssertion(types, 8, 8, true);
        list9 = list8;
        this.delegateBooleanAssertion(types, 8, 9, true);
        list8 = list9;
        this.delegateBooleanAssertion(types, 9, 8, false);
        list10 = list8;
        this.delegateBooleanAssertion(types, 8, 10, true);
        list8 = list10;
        this.delegateBooleanAssertion(types, 10, 8, false);
        this.delegateBooleanAssertion(types, 8, 11, false);
        this.delegateBooleanAssertion(types, 11, 8, false);
        this.delegateBooleanAssertion(types, 8, 12, false);
        this.delegateBooleanAssertion(types, 12, 8, false);
        list13 = list8;
        this.delegateBooleanAssertion(types, 8, 13, true);
        list8 = list13;
        this.delegateBooleanAssertion(types, 13, 8, false);
        this.delegateBooleanAssertion(types, 9, 9, true);
        list10 = list9;
        this.delegateBooleanAssertion(types, 9, 10, false);
        list9 = list10;
        this.delegateBooleanAssertion(types, 10, 9, true);
        list11 = list9;
        this.delegateBooleanAssertion(types, 9, 11, false);
        list9 = list11;
        this.delegateBooleanAssertion(types, 11, 9, true);
        list12 = list9;
        this.delegateBooleanAssertion(types, 9, 12, false);
        list9 = list12;
        this.delegateBooleanAssertion(types, 12, 9, true);
        list13 = list9;
        this.delegateBooleanAssertion(types, 9, 13, false);
        list9 = list13;
        this.delegateBooleanAssertion(types, 13, 9, true);
        this.delegateBooleanAssertion(types, 10, 10, true);
        this.delegateBooleanAssertion(types, 10, 11, false);
        this.delegateBooleanAssertion(types, 11, 10, false);
        this.delegateBooleanAssertion(types, 10, 12, false);
        this.delegateBooleanAssertion(types, 12, 10, false);
        list13 = list10;
        this.delegateBooleanAssertion(types, 10, 13, true);
        list10 = list13;
        this.delegateBooleanAssertion(types, 13, 10, false);
        this.delegateBooleanAssertion(types, 11, 11, true);
        list12 = list11;
        this.delegateBooleanAssertion(types, 11, 12, true);
        list11 = list12;
        this.delegateBooleanAssertion(types, 12, 11, false);
        list13 = list11;
        this.delegateBooleanAssertion(types, 11, 13, true);
        list11 = list13;
        this.delegateBooleanAssertion(types, 13, 11, false);
        this.delegateBooleanAssertion(types, 12, 12, true);
        list13 = list12;
        this.delegateBooleanAssertion(types, 12, 13, false);
        list12 = list13;
        this.delegateBooleanAssertion(types, 13, 12, false);
        this.delegateBooleanAssertion(types, 13, 13, true);
        Type disType = this.getClass().getField("dis").getGenericType();
        Type datType = this.getClass().getField("dat").getGenericType();
        Type daType = this.getClass().getField("da").getGenericType();
        Type uhderType = this.getClass().getField("uhder").getGenericType();
        Type dingType = this.getClass().getField("ding").getGenericType();
        Type testerType = this.getClass().getField("tester").getGenericType();
        Type tester2Type = this.getClass().getField("tester2").getGenericType();
        Type dat2Type = this.getClass().getField("dat2").getGenericType();
        Type dat3Type = this.getClass().getField("dat3").getGenericType();
        this.dis = this.dat;
        Assert.assertTrue((boolean)TypeUtils.isAssignable((Type)datType, (Type)disType));
        Assert.assertFalse((boolean)TypeUtils.isAssignable((Type)daType, (Type)disType));
        this.dis = this.uhder;
        Assert.assertTrue((boolean)TypeUtils.isAssignable((Type)uhderType, (Type)disType));
        this.dis = this.ding;
        Assert.assertFalse((String)String.format("type %s not assignable to %s!", dingType, disType), (boolean)TypeUtils.isAssignable((Type)dingType, (Type)disType));
        this.dis = this.tester;
        Assert.assertTrue((boolean)TypeUtils.isAssignable((Type)testerType, (Type)disType));
        Assert.assertFalse((boolean)TypeUtils.isAssignable((Type)tester2Type, (Type)disType));
        Assert.assertFalse((boolean)TypeUtils.isAssignable((Type)dat2Type, (Type)datType));
        Assert.assertFalse((boolean)TypeUtils.isAssignable((Type)datType, (Type)dat2Type));
        Assert.assertFalse((boolean)TypeUtils.isAssignable((Type)dat3Type, (Type)datType));
        boolean ch = false;
        boolean bo = false;
        boolean by = false;
        boolean sh = false;
        int in = 0;
        long lo = 0L;
        float fl = 0.0f;
        double du = 0.0;
        du = 0.0;
        Assert.assertTrue((boolean)TypeUtils.isAssignable(Character.TYPE, Double.TYPE));
        du = 0.0;
        Assert.assertTrue((boolean)TypeUtils.isAssignable(Byte.TYPE, Double.TYPE));
        du = 0.0;
        Assert.assertTrue((boolean)TypeUtils.isAssignable(Short.TYPE, Double.TYPE));
        du = in;
        Assert.assertTrue((boolean)TypeUtils.isAssignable(Integer.TYPE, Double.TYPE));
        du = lo;
        Assert.assertTrue((boolean)TypeUtils.isAssignable(Long.TYPE, Double.TYPE));
        du = 0.0;
        Assert.assertTrue((boolean)TypeUtils.isAssignable(Float.TYPE, Double.TYPE));
        lo = in;
        Assert.assertTrue((boolean)TypeUtils.isAssignable(Integer.TYPE, Long.TYPE));
        lo = Integer.valueOf(0).intValue();
        Assert.assertTrue((boolean)TypeUtils.isAssignable(Integer.class, Long.TYPE));
        Assert.assertFalse((boolean)TypeUtils.isAssignable(Integer.TYPE, Long.class));
        Assert.assertFalse((boolean)TypeUtils.isAssignable(Integer.class, Long.class));
        in = 0;
        Assert.assertTrue((boolean)TypeUtils.isAssignable(Integer.class, Integer.TYPE));
        Integer inte = in;
        Assert.assertTrue((boolean)TypeUtils.isAssignable(Integer.TYPE, Integer.class));
        Assert.assertTrue((boolean)TypeUtils.isAssignable(Integer.TYPE, Number.class));
        Assert.assertTrue((boolean)TypeUtils.isAssignable(Integer.TYPE, Object.class));
        Type intComparableType = this.getClass().getField("intComparable").getGenericType();
        intComparable = 1;
        Assert.assertTrue((boolean)TypeUtils.isAssignable(Integer.TYPE, (Type)intComparableType));
        Assert.assertTrue((boolean)TypeUtils.isAssignable(Integer.TYPE, Comparable.class));
        Integer ser = 1;
        Assert.assertTrue((boolean)TypeUtils.isAssignable(Integer.TYPE, Serializable.class));
        Type longComparableType = this.getClass().getField("longComparable").getGenericType();
        Assert.assertFalse((boolean)TypeUtils.isAssignable(Integer.TYPE, (Type)longComparableType));
        Assert.assertFalse((boolean)TypeUtils.isAssignable(Integer.class, (Type)longComparableType));
        Assert.assertFalse((boolean)TypeUtils.isAssignable(int[].class, long[].class));
        Object ia = null;
        Type caType = this.getClass().getField("intWildcardComparable").getGenericType();
        this.intWildcardComparable = ia;
        Assert.assertTrue((boolean)TypeUtils.isAssignable(Integer[].class, (Type)caType));
        Assert.assertFalse((boolean)TypeUtils.isAssignable(Integer[].class, int[].class));
        Object ina = null;
        Assert.assertFalse((boolean)TypeUtils.isAssignable(int[].class, Object[].class));
        Integer[] oa = new Integer[]{};
        Assert.assertTrue((boolean)TypeUtils.isAssignable(Integer[].class, Object[].class));
        Type bClassType = AClass.class.getField("bClass").getGenericType();
        Type cClassType = AClass.class.getField("cClass").getGenericType();
        Type dClassType = AClass.class.getField("dClass").getGenericType();
        Type eClassType = AClass.class.getField("eClass").getGenericType();
        Type fClassType = AClass.class.getField("fClass").getGenericType();
        AClass aClass = new AClass(new AAClass<String>());
        aClass.bClass = aClass.cClass;
        Assert.assertTrue((boolean)TypeUtils.isAssignable((Type)cClassType, (Type)bClassType));
        aClass.bClass = aClass.dClass;
        Assert.assertTrue((boolean)TypeUtils.isAssignable((Type)dClassType, (Type)bClassType));
        aClass.bClass = aClass.eClass;
        Assert.assertTrue((boolean)TypeUtils.isAssignable((Type)eClassType, (Type)bClassType));
        aClass.bClass = aClass.fClass;
        Assert.assertTrue((boolean)TypeUtils.isAssignable((Type)fClassType, (Type)bClassType));
        aClass.cClass = aClass.dClass;
        Assert.assertTrue((boolean)TypeUtils.isAssignable((Type)dClassType, (Type)cClassType));
        aClass.cClass = aClass.eClass;
        Assert.assertTrue((boolean)TypeUtils.isAssignable((Type)eClassType, (Type)cClassType));
        aClass.cClass = aClass.fClass;
        Assert.assertTrue((boolean)TypeUtils.isAssignable((Type)fClassType, (Type)cClassType));
        aClass.dClass = aClass.eClass;
        Assert.assertTrue((boolean)TypeUtils.isAssignable((Type)eClassType, (Type)dClassType));
        aClass.dClass = aClass.fClass;
        Assert.assertTrue((boolean)TypeUtils.isAssignable((Type)fClassType, (Type)dClassType));
        aClass.eClass = aClass.fClass;
        Assert.assertTrue((boolean)TypeUtils.isAssignable((Type)fClassType, (Type)eClassType));
    }

    public void delegateBooleanAssertion(Type[] types, int i2, int i1, boolean expected) {
        Type type1 = types[i1];
        Type type2 = types[i2];
        boolean isAssignable = TypeUtils.isAssignable((Type)type2, (Type)type1);
        if (expected) {
            Assert.assertTrue((String)("[" + i1 + ", " + i2 + "]: From " + String.valueOf(type2) + " to " + String.valueOf(type1)), (boolean)isAssignable);
        } else {
            Assert.assertFalse((String)("[" + i1 + ", " + i2 + "]: From " + String.valueOf(type2) + " to " + String.valueOf(type1)), (boolean)isAssignable);
        }
    }

    @Test
    public void testIsInstance() throws SecurityException, NoSuchFieldException {
        Type intComparableType = this.getClass().getField("intComparable").getGenericType();
        Type uriComparableType = this.getClass().getField("uriComparable").getGenericType();
        intComparable = 1;
        Assert.assertTrue((boolean)TypeUtils.isInstance((Object)1, (Type)intComparableType));
        Assert.assertFalse((boolean)TypeUtils.isInstance((Object)1, (Type)uriComparableType));
    }

    @Test
    public void testGetTypeArguments() {
        Map typeVarAssigns = TypeUtils.getTypeArguments(Integer.class, Comparable.class);
        TypeVariable treeSetTypeVar = Comparable.class.getTypeParameters()[0];
        Assert.assertTrue((String)("Type var assigns for Comparable from Integer: " + typeVarAssigns), (boolean)typeVarAssigns.containsKey(treeSetTypeVar));
        Type typeArg = (Type)typeVarAssigns.get(treeSetTypeVar);
        Assert.assertEquals((String)("Type argument of Comparable from Integer: " + typeArg), Integer.class, typeVarAssigns.get(treeSetTypeVar));
        typeVarAssigns = TypeUtils.getTypeArguments(Integer.TYPE, Comparable.class);
        treeSetTypeVar = Comparable.class.getTypeParameters()[0];
        Assert.assertTrue((String)("Type var assigns for Comparable from int: " + typeVarAssigns), (boolean)typeVarAssigns.containsKey(treeSetTypeVar));
        typeArg = (Type)typeVarAssigns.get(treeSetTypeVar);
        Assert.assertEquals((String)("Type argument of Comparable from int: " + typeArg), Integer.class, typeVarAssigns.get(treeSetTypeVar));
        List<Integer> col = Arrays.asList(new Integer[0]);
        typeVarAssigns = TypeUtils.getTypeArguments(List.class, Collection.class);
        treeSetTypeVar = Comparable.class.getTypeParameters()[0];
        Assert.assertFalse((String)("Type var assigns for Collection from List: " + typeVarAssigns), (boolean)typeVarAssigns.containsKey(treeSetTypeVar));
        typeVarAssigns = TypeUtils.getTypeArguments(AAAClass.BBBClass.class, AAClass.BBClass.class);
        Assert.assertEquals((long)2L, (long)typeVarAssigns.size());
        Assert.assertEquals(String.class, typeVarAssigns.get(AAClass.class.getTypeParameters()[0]));
        Assert.assertEquals(String.class, typeVarAssigns.get(AAClass.BBClass.class.getTypeParameters()[0]));
        typeVarAssigns = TypeUtils.getTypeArguments(Other.class, This.class);
        Assert.assertEquals((long)2L, (long)typeVarAssigns.size());
        Assert.assertEquals(String.class, typeVarAssigns.get(This.class.getTypeParameters()[0]));
        Assert.assertEquals(Other.class.getTypeParameters()[0], typeVarAssigns.get(This.class.getTypeParameters()[1]));
        typeVarAssigns = TypeUtils.getTypeArguments(And.class, This.class);
        Assert.assertEquals((long)2L, (long)typeVarAssigns.size());
        Assert.assertEquals(Number.class, typeVarAssigns.get(This.class.getTypeParameters()[0]));
        Assert.assertEquals(Number.class, typeVarAssigns.get(This.class.getTypeParameters()[1]));
        typeVarAssigns = TypeUtils.getTypeArguments(Thing.class, Other.class);
        Assert.assertEquals((long)2L, (long)typeVarAssigns.size());
        Assert.assertEquals(this.getClass().getTypeParameters()[0], typeVarAssigns.get(this.getClass().getTypeParameters()[0]));
        Assert.assertEquals(this.getClass().getTypeParameters()[0], typeVarAssigns.get(Other.class.getTypeParameters()[0]));
    }

    @Test
    public void testTypesSatisfyVariables() throws SecurityException, NoSuchFieldException, NoSuchMethodException {
        HashMap<TypeVariable<Method>, Class<Integer>> typeVarAssigns = new HashMap<TypeVariable<Method>, Class<Integer>>();
        Integer max = (Integer)TypeUtilsTest.stub();
        typeVarAssigns.put(this.getClass().getMethod("stub", new Class[0]).getTypeParameters()[0], Integer.class);
        Assert.assertTrue((boolean)TypeUtils.typesSatisfyVariables(typeVarAssigns));
        typeVarAssigns.clear();
        typeVarAssigns.put(this.getClass().getMethod("stub2", new Class[0]).getTypeParameters()[0], Integer.class);
        Assert.assertTrue((boolean)TypeUtils.typesSatisfyVariables(typeVarAssigns));
        typeVarAssigns.clear();
        typeVarAssigns.put(this.getClass().getMethod("stub3", new Class[0]).getTypeParameters()[0], Integer.class);
        Assert.assertTrue((boolean)TypeUtils.typesSatisfyVariables(typeVarAssigns));
    }

    @Test
    public void testDetermineTypeVariableAssignments() throws SecurityException, NoSuchFieldException, NoSuchMethodException {
        ParameterizedType iterableType = (ParameterizedType)this.getClass().getField("iterable").getGenericType();
        Map typeVarAssigns = TypeUtils.determineTypeArguments(TreeSet.class, (ParameterizedType)iterableType);
        TypeVariable treeSetTypeVar = TreeSet.class.getTypeParameters()[0];
        Assert.assertTrue((boolean)typeVarAssigns.containsKey(treeSetTypeVar));
        Assert.assertEquals((Object)iterableType.getActualTypeArguments()[0], typeVarAssigns.get(treeSetTypeVar));
    }

    @Test
    public void testGetRawType() throws SecurityException, NoSuchFieldException {
        Type stringParentFieldType = GenericTypeHolder.class.getDeclaredField("stringParent").getGenericType();
        Type integerParentFieldType = GenericTypeHolder.class.getDeclaredField("integerParent").getGenericType();
        Type foosFieldType = GenericTypeHolder.class.getDeclaredField("foos").getGenericType();
        TypeVariable genericParentT = GenericParent.class.getTypeParameters()[0];
        Assert.assertEquals(GenericParent.class, (Object)TypeUtils.getRawType((Type)stringParentFieldType, null));
        Assert.assertEquals(GenericParent.class, (Object)TypeUtils.getRawType((Type)integerParentFieldType, null));
        Assert.assertEquals(List.class, (Object)TypeUtils.getRawType((Type)foosFieldType, null));
        Assert.assertEquals(String.class, (Object)TypeUtils.getRawType(genericParentT, StringParameterizedChild.class));
        Assert.assertEquals(String.class, (Object)TypeUtils.getRawType(genericParentT, (Type)stringParentFieldType));
        Assert.assertEquals(Foo.class, (Object)TypeUtils.getRawType(Iterable.class.getTypeParameters()[0], (Type)foosFieldType));
        Assert.assertEquals(Foo.class, (Object)TypeUtils.getRawType(List.class.getTypeParameters()[0], (Type)foosFieldType));
        Assert.assertNull((Object)TypeUtils.getRawType(genericParentT, GenericParent.class));
        Assert.assertEquals(GenericParent[].class, (Object)TypeUtils.getRawType((Type)GenericTypeHolder.class.getDeclaredField("barParents").getGenericType(), null));
    }

    @Test
    public void testIsArrayTypeClasses() {
        Assert.assertTrue((boolean)TypeUtils.isArrayType(boolean[].class));
        Assert.assertTrue((boolean)TypeUtils.isArrayType(byte[].class));
        Assert.assertTrue((boolean)TypeUtils.isArrayType(short[].class));
        Assert.assertTrue((boolean)TypeUtils.isArrayType(int[].class));
        Assert.assertTrue((boolean)TypeUtils.isArrayType(char[].class));
        Assert.assertTrue((boolean)TypeUtils.isArrayType(long[].class));
        Assert.assertTrue((boolean)TypeUtils.isArrayType(float[].class));
        Assert.assertTrue((boolean)TypeUtils.isArrayType(double[].class));
        Assert.assertTrue((boolean)TypeUtils.isArrayType(Object[].class));
        Assert.assertTrue((boolean)TypeUtils.isArrayType(String[].class));
        Assert.assertFalse((boolean)TypeUtils.isArrayType(Boolean.TYPE));
        Assert.assertFalse((boolean)TypeUtils.isArrayType(Byte.TYPE));
        Assert.assertFalse((boolean)TypeUtils.isArrayType(Short.TYPE));
        Assert.assertFalse((boolean)TypeUtils.isArrayType(Integer.TYPE));
        Assert.assertFalse((boolean)TypeUtils.isArrayType(Character.TYPE));
        Assert.assertFalse((boolean)TypeUtils.isArrayType(Long.TYPE));
        Assert.assertFalse((boolean)TypeUtils.isArrayType(Float.TYPE));
        Assert.assertFalse((boolean)TypeUtils.isArrayType(Double.TYPE));
        Assert.assertFalse((boolean)TypeUtils.isArrayType(Object.class));
        Assert.assertFalse((boolean)TypeUtils.isArrayType(String.class));
    }

    @Test
    public void testIsArrayGenericTypes() throws Exception {
        Method method = this.getClass().getMethod("dummyMethod", List.class, List.class, List.class, List.class, List.class, List.class, List.class, List[].class, List[].class, List[].class, List[].class, List[].class, List[].class, List[].class);
        Type[] types = method.getGenericParameterTypes();
        Assert.assertFalse((boolean)TypeUtils.isArrayType((Type)types[0]));
        Assert.assertFalse((boolean)TypeUtils.isArrayType((Type)types[1]));
        Assert.assertFalse((boolean)TypeUtils.isArrayType((Type)types[2]));
        Assert.assertFalse((boolean)TypeUtils.isArrayType((Type)types[3]));
        Assert.assertFalse((boolean)TypeUtils.isArrayType((Type)types[4]));
        Assert.assertFalse((boolean)TypeUtils.isArrayType((Type)types[5]));
        Assert.assertFalse((boolean)TypeUtils.isArrayType((Type)types[6]));
        Assert.assertTrue((boolean)TypeUtils.isArrayType((Type)types[7]));
        Assert.assertTrue((boolean)TypeUtils.isArrayType((Type)types[8]));
        Assert.assertTrue((boolean)TypeUtils.isArrayType((Type)types[9]));
        Assert.assertTrue((boolean)TypeUtils.isArrayType((Type)types[10]));
        Assert.assertTrue((boolean)TypeUtils.isArrayType((Type)types[11]));
        Assert.assertTrue((boolean)TypeUtils.isArrayType((Type)types[12]));
        Assert.assertTrue((boolean)TypeUtils.isArrayType((Type)types[13]));
    }

    @Test
    public void testGetPrimitiveArrayComponentType() throws Exception {
        Assert.assertEquals(Boolean.TYPE, (Object)TypeUtils.getArrayComponentType(boolean[].class));
        Assert.assertEquals(Byte.TYPE, (Object)TypeUtils.getArrayComponentType(byte[].class));
        Assert.assertEquals(Short.TYPE, (Object)TypeUtils.getArrayComponentType(short[].class));
        Assert.assertEquals(Integer.TYPE, (Object)TypeUtils.getArrayComponentType(int[].class));
        Assert.assertEquals(Character.TYPE, (Object)TypeUtils.getArrayComponentType(char[].class));
        Assert.assertEquals(Long.TYPE, (Object)TypeUtils.getArrayComponentType(long[].class));
        Assert.assertEquals(Float.TYPE, (Object)TypeUtils.getArrayComponentType(float[].class));
        Assert.assertEquals(Double.TYPE, (Object)TypeUtils.getArrayComponentType(double[].class));
        Assert.assertNull((Object)TypeUtils.getArrayComponentType(Boolean.TYPE));
        Assert.assertNull((Object)TypeUtils.getArrayComponentType(Byte.TYPE));
        Assert.assertNull((Object)TypeUtils.getArrayComponentType(Short.TYPE));
        Assert.assertNull((Object)TypeUtils.getArrayComponentType(Integer.TYPE));
        Assert.assertNull((Object)TypeUtils.getArrayComponentType(Character.TYPE));
        Assert.assertNull((Object)TypeUtils.getArrayComponentType(Long.TYPE));
        Assert.assertNull((Object)TypeUtils.getArrayComponentType(Float.TYPE));
        Assert.assertNull((Object)TypeUtils.getArrayComponentType(Double.TYPE));
    }

    @Test
    public void testGetArrayComponentType() throws Exception {
        Method method = this.getClass().getMethod("dummyMethod", List.class, List.class, List.class, List.class, List.class, List.class, List.class, List[].class, List[].class, List[].class, List[].class, List[].class, List[].class, List[].class);
        Type[] types = method.getGenericParameterTypes();
        Assert.assertNull((Object)TypeUtils.getArrayComponentType((Type)types[0]));
        Assert.assertNull((Object)TypeUtils.getArrayComponentType((Type)types[1]));
        Assert.assertNull((Object)TypeUtils.getArrayComponentType((Type)types[2]));
        Assert.assertNull((Object)TypeUtils.getArrayComponentType((Type)types[3]));
        Assert.assertNull((Object)TypeUtils.getArrayComponentType((Type)types[4]));
        Assert.assertNull((Object)TypeUtils.getArrayComponentType((Type)types[5]));
        Assert.assertNull((Object)TypeUtils.getArrayComponentType((Type)types[6]));
        Assert.assertEquals((Object)types[0], (Object)TypeUtils.getArrayComponentType((Type)types[7]));
        Assert.assertEquals((Object)types[1], (Object)TypeUtils.getArrayComponentType((Type)types[8]));
        Assert.assertEquals((Object)types[2], (Object)TypeUtils.getArrayComponentType((Type)types[9]));
        Assert.assertEquals((Object)types[3], (Object)TypeUtils.getArrayComponentType((Type)types[10]));
        Assert.assertEquals((Object)types[4], (Object)TypeUtils.getArrayComponentType((Type)types[11]));
        Assert.assertEquals((Object)types[5], (Object)TypeUtils.getArrayComponentType((Type)types[12]));
        Assert.assertEquals((Object)types[6], (Object)TypeUtils.getArrayComponentType((Type)types[13]));
    }

    @Test
    public void testLang820() throws Exception {
        Type[] typeArray = new Type[]{String.class, String.class};
        Object[] expectedArray = new Type[]{String.class};
        Assert.assertArrayEquals((Object[])expectedArray, (Object[])TypeUtils.normalizeUpperBounds((Type[])typeArray));
    }

    @Test
    public void testParameterize() throws Exception {
        ParameterizedType stringComparableType = TypeUtils.parameterize(Comparable.class, (Type[])new Type[]{String.class});
        Assert.assertTrue((boolean)TypeUtils.equals((Type)this.getClass().getField("stringComparable").getGenericType(), (Type)stringComparableType));
        Assert.assertEquals((Object)"java.lang.Comparable<java.lang.String>", (Object)stringComparableType.toString());
    }

    @Test
    public void testParameterizeNarrowerTypeArray() {
        Type[] variables = ArrayList.class.getTypeParameters();
        ParameterizedType parameterizedType = TypeUtils.parameterize(ArrayList.class, (Type[])variables);
        Map<Type, Class<String>> mapping = Collections.singletonMap(variables[0], String.class);
        Type unrolled = TypeUtils.unrollVariables(mapping, (Type)parameterizedType);
        Assert.assertEquals((Object)TypeUtils.parameterize(ArrayList.class, (Type[])new Type[]{String.class}), (Object)unrolled);
    }

    @Test
    public void testParameterizeWithOwner() throws Exception {
        ParameterizedType owner = TypeUtils.parameterize(TypeUtilsTest.class, (Type[])new Type[]{String.class});
        ParameterizedType dat2Type = TypeUtils.parameterizeWithOwner((Type)owner, That.class, (Type[])new Type[]{String.class, String.class});
        Assert.assertTrue((boolean)TypeUtils.equals((Type)this.getClass().getField("dat2").getGenericType(), (Type)dat2Type));
    }

    @Test
    public void testWildcardType() throws Exception {
        WildcardType simpleWildcard = TypeUtils.wildcardType().withUpperBounds(new Type[]{String.class}).build();
        Field cClass = AClass.class.getField("cClass");
        Assert.assertTrue((boolean)TypeUtils.equals((Type)((ParameterizedType)cClass.getGenericType()).getActualTypeArguments()[0], (Type)simpleWildcard));
        Assert.assertEquals((Object)String.format("? extends %s", String.class.getName()), (Object)TypeUtils.toString((Type)simpleWildcard));
        Assert.assertEquals((Object)String.format("? extends %s", String.class.getName()), (Object)simpleWildcard.toString());
    }

    @Test
    public void testUnboundedWildcardType() {
        WildcardType unbounded = TypeUtils.wildcardType().withLowerBounds(new Type[]{null}).withUpperBounds(new Type[0]).build();
        Assert.assertTrue((boolean)TypeUtils.equals((Type)TypeUtils.WILDCARD_ALL, (Type)unbounded));
        Assert.assertArrayEquals((Object[])new Type[]{Object.class}, (Object[])TypeUtils.getImplicitUpperBounds((WildcardType)unbounded));
        Assert.assertArrayEquals((Object[])new Type[]{null}, (Object[])TypeUtils.getImplicitLowerBounds((WildcardType)unbounded));
        Assert.assertEquals((Object)"?", (Object)TypeUtils.toString((Type)unbounded));
        Assert.assertEquals((Object)"?", (Object)unbounded.toString());
    }

    @Test
    public void testLowerBoundedWildcardType() {
        WildcardType lowerBounded = TypeUtils.wildcardType().withLowerBounds(new Type[]{Date.class}).build();
        Assert.assertEquals((Object)String.format("? super %s", Date.class.getName()), (Object)TypeUtils.toString((Type)lowerBounded));
        Assert.assertEquals((Object)String.format("? super %s", Date.class.getName()), (Object)lowerBounded.toString());
        TypeVariable iterableT0 = Iterable.class.getTypeParameters()[0];
        WildcardType lowerTypeVariable = TypeUtils.wildcardType().withLowerBounds(new Type[]{iterableT0}).build();
        Assert.assertEquals((Object)String.format("? super %s", iterableT0.getName()), (Object)TypeUtils.toString((Type)lowerTypeVariable));
        Assert.assertEquals((Object)String.format("? super %s", iterableT0.getName()), (Object)lowerTypeVariable.toString());
    }

    @Test
    public void testLang1114() throws Exception {
        Type nonWildcardType = this.getClass().getDeclaredField("wildcardComparable").getGenericType();
        Type wildcardType = ((ParameterizedType)nonWildcardType).getActualTypeArguments()[0];
        Assert.assertFalse((boolean)TypeUtils.equals((Type)wildcardType, (Type)nonWildcardType));
        Assert.assertFalse((boolean)TypeUtils.equals((Type)nonWildcardType, (Type)wildcardType));
    }

    @Test
    public void testGenericArrayType() throws Exception {
        Type expected = this.getClass().getField("intWildcardComparable").getGenericType();
        GenericArrayType actual = TypeUtils.genericArrayType((Type)TypeUtils.parameterize(Comparable.class, (Type[])new Type[]{TypeUtils.wildcardType().withUpperBounds(new Type[]{Integer.class}).build()}));
        Assert.assertTrue((boolean)TypeUtils.equals((Type)expected, (Type)actual));
        Assert.assertEquals((Object)"java.lang.Comparable<? extends java.lang.Integer>[]", (Object)actual.toString());
    }

    @Test
    public void testToStringLang1311() {
        Assert.assertEquals((Object)"int[]", (Object)TypeUtils.toString(int[].class));
        Assert.assertEquals((Object)"java.lang.Integer[]", (Object)TypeUtils.toString(Integer[].class));
        Field stringListField = FieldUtils.getDeclaredField(this.getClass(), (String)"stringListArray");
        Assert.assertEquals((Object)"java.util.List<java.lang.String>[]", (Object)TypeUtils.toString((Type)stringListField.getGenericType()));
    }

    @Test
    public void testToLongString() {
        Assert.assertEquals((Object)(this.getClass().getName() + ":B"), (Object)TypeUtils.toLongString(this.getClass().getTypeParameters()[0]));
    }

    @Test
    public void testWrap() {
        TypeVariable<Class<?>> t = this.getClass().getTypeParameters()[0];
        Assert.assertTrue((boolean)TypeUtils.equals(t, (Type)TypeUtils.wrap(t).getType()));
        Assert.assertEquals(String.class, (Object)TypeUtils.wrap(String.class).getType());
    }

    @Test
    public void testLANG1190() throws Exception {
        Type fromType = ClassWithSuperClassWithGenericType.class.getDeclaredMethod("methodWithGenericReturnType", new Class[0]).getGenericReturnType();
        WildcardType failingToType = TypeUtils.wildcardType().withLowerBounds(new Type[]{ClassWithSuperClassWithGenericType.class}).build();
        Assert.assertTrue((boolean)TypeUtils.isAssignable((Type)fromType, (Type)failingToType));
    }

    @Test
    public void testLANG1348() throws Exception {
        Method method = Enum.class.getMethod("valueOf", Class.class, String.class);
        Assert.assertEquals((Object)"T extends java.lang.Enum<T>", (Object)TypeUtils.toString((Type)method.getGenericReturnType()));
    }

    public static <G extends Comparable<G>> G stub() {
        return null;
    }

    public static <G extends Comparable<? super G>> G stub2() {
        return null;
    }

    public static <T extends Comparable<? extends T>> T stub3() {
        return null;
    }

    public static class ClassWithSuperClassWithGenericType
    extends ArrayList<Object> {
        private static final long serialVersionUID = 1L;

        public static <U> Iterable<U> methodWithGenericReturnType() {
            return null;
        }
    }

    public class Tester
    implements This<String, B> {
    }

    public class Thing<Q>
    extends Other<B> {
    }

    public class Other<T>
    implements This<String, T> {
    }

    public class The<K, V>
    extends That<Number, Number>
    implements And<String, String> {
    }

    public static interface And<K, V>
    extends This<Number, Number> {
    }

    public class That<K, V>
    implements This<K, V> {
    }

    public static interface This<K, V> {
    }
}

