/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.distribution.IntegerDistributionAbstractTest;
import org.apache.commons.math3.distribution.PoissonDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class PoissonDistributionTest
extends IntegerDistributionAbstractTest {
    private static final double DEFAULT_TEST_POISSON_PARAMETER = 4.0;

    public PoissonDistributionTest() {
        this.setTolerance(1.0E-12);
    }

    public IntegerDistribution makeDistribution() {
        return new PoissonDistribution(4.0);
    }

    public int[] makeDensityTestPoints() {
        return new int[]{-1, 0, 1, 2, 3, 4, 5, 10, 20};
    }

    public double[] makeDensityTestValues() {
        return new double[]{0.0, 0.0183156388887, 0.073262555555, 0.14652511111, 0.195366814813, 0.195366814813, 0.156293451851, 0.00529247667642, 8.27746364655E-9};
    }

    public double[] makeLogDensityTestValues() {
        return new double[]{Double.NEGATIVE_INFINITY, -4.0, -2.61370563888, -1.92055845832, -1.632876385868, -1.632876385868, -1.856019937183, -5.241468961877, -18.609729238356};
    }

    public int[] makeCumulativeTestPoints() {
        return new int[]{-1, 0, 1, 2, 3, 4, 5, 10, 20};
    }

    public double[] makeCumulativeTestValues() {
        return new double[]{0.0, 0.0183156388887, 0.0915781944437, 0.238103305554, 0.433470120367, 0.62883693518, 0.78513038703, 0.99716023388, 0.999999998077};
    }

    public double[] makeInverseCumulativeTestPoints() {
        IntegerDistribution dist = this.getDistribution();
        return new double[]{0.0, 0.018315638886, 0.01831563889, 0.091578194441, 0.091578194445, 0.238103305552, 0.238103305556, dist.cumulativeProbability(3), dist.cumulativeProbability(4), dist.cumulativeProbability(5), dist.cumulativeProbability(10), dist.cumulativeProbability(20)};
    }

    public int[] makeInverseCumulativeTestValues() {
        return new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 5, 10, 20};
    }

    @Test
    public void testNormalApproximateProbability() {
        PoissonDistribution dist = new PoissonDistribution(100.0);
        double result = dist.normalApproximateProbability(110) - dist.normalApproximateProbability(89);
        Assert.assertEquals((double)0.706281887248, (double)result, (double)1.0E-10);
        dist = new PoissonDistribution(10000.0);
        result = dist.normalApproximateProbability(10200) - dist.normalApproximateProbability(9899);
        Assert.assertEquals((double)0.820070051552, (double)result, (double)1.0E-10);
    }

    @Test
    public void testDegenerateInverseCumulativeProbability() {
        PoissonDistribution dist = new PoissonDistribution(4.0);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)dist.inverseCumulativeProbability(1.0));
        Assert.assertEquals((long)0L, (long)dist.inverseCumulativeProbability(0.0));
    }

    @Test(expected=NotStrictlyPositiveException.class)
    public void testNegativeMean() {
        new PoissonDistribution(-1.0);
    }

    @Test
    public void testMean() {
        PoissonDistribution dist = new PoissonDistribution(10.0);
        Assert.assertEquals((double)10.0, (double)dist.getMean(), (double)0.0);
    }

    @Test
    public void testLargeMeanCumulativeProbability() {
        for (double mean = 1.0; mean <= 1.0E7; mean *= 10.0) {
            double x;
            PoissonDistribution dist = new PoissonDistribution(mean);
            double dx = x / 10.0;
            double p = Double.NaN;
            double sigma = FastMath.sqrt((double)mean);
            for (x = mean * 2.0; x >= 0.0; x -= dx) {
                try {
                    p = dist.cumulativeProbability((int)x);
                    Assert.assertFalse((String)("NaN cumulative probability returned for mean = " + mean + " x = " + x), (boolean)Double.isNaN(p));
                    if (!(x > mean - 2.0 * sigma)) continue;
                    Assert.assertTrue((String)("Zero cum probaility returned for mean = " + mean + " x = " + x), (p > 0.0 ? 1 : 0) != 0);
                    continue;
                }
                catch (Exception ex) {
                    Assert.fail((String)("mean of " + mean + " and x of " + x + " caused " + ex.getMessage()));
                }
            }
        }
    }

    @Test
    public void testCumulativeProbabilitySpecial() {
        PoissonDistribution dist = new PoissonDistribution(9120.0);
        this.checkProbability(dist, 9075);
        this.checkProbability(dist, 9102);
        dist = new PoissonDistribution(5058.0);
        this.checkProbability(dist, 5044);
        dist = new PoissonDistribution(6986.0);
        this.checkProbability(dist, 6950);
    }

    private void checkProbability(PoissonDistribution dist, int x) {
        double p = dist.cumulativeProbability(x);
        Assert.assertFalse((String)("NaN cumulative probability returned for mean = " + dist.getMean() + " x = " + x), (boolean)Double.isNaN(p));
        Assert.assertTrue((String)("Zero cum probability returned for mean = " + dist.getMean() + " x = " + x), (p > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testLargeMeanInverseCumulativeProbability() {
        for (double mean = 1.0; mean <= 100000.0; mean *= 10.0) {
            double p;
            PoissonDistribution dist = new PoissonDistribution(mean);
            double dp = p = 0.1;
            while (p < 0.99) {
                try {
                    int ret = dist.inverseCumulativeProbability(p);
                    Assert.assertTrue((p <= dist.cumulativeProbability(ret) ? 1 : 0) != 0);
                    Assert.assertTrue((p > dist.cumulativeProbability(ret - 1) ? 1 : 0) != 0);
                }
                catch (Exception ex) {
                    Assert.fail((String)("mean of " + mean + " and p of " + p + " caused " + ex.getMessage()));
                }
                p += dp;
            }
        }
    }

    @Test
    public void testMoments() {
        double tol = 1.0E-9;
        PoissonDistribution dist = new PoissonDistribution(1.0);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)1.0, (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)1.0, (double)1.0E-9);
        dist = new PoissonDistribution(11.23);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)11.23, (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)11.23, (double)1.0E-9);
    }
}

