/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.fraction;

import org.apache.commons.numbers.core.Precision;
import org.apache.commons.numbers.fraction.FractionException;

public abstract class ContinuedFraction {
    private static final double SMALL = 1.0E-50;

    protected abstract double getA(int var1, double var2);

    protected abstract double getB(int var1, double var2);

    public double evaluate(double x, double epsilon) {
        return this.evaluate(x, epsilon, Integer.MAX_VALUE);
    }

    public double evaluate(double x, double epsilon, int maxIterations) {
        double hPrev = ContinuedFraction.updateIfCloseToZero(this.getB(0, x));
        double dPrev = 0.0;
        double cPrev = hPrev;
        for (int n = 1; n <= maxIterations; ++n) {
            double a = this.getA(n, x);
            double b = this.getB(n, x);
            double dN = ContinuedFraction.updateIfCloseToZero(b + a * dPrev);
            double cN = ContinuedFraction.updateIfCloseToZero(b + a / cPrev);
            double deltaN = cN * (dN = 1.0 / dN);
            double hN = hPrev * deltaN;
            if (Double.isInfinite(hN)) {
                throw new FractionException("Continued fraction convergents diverged to +/- infinity for value {0}", x);
            }
            if (Double.isNaN(hN)) {
                throw new FractionException("Continued fraction diverged to NaN for value {0}", x);
            }
            if (Math.abs(deltaN - 1.0) < epsilon) {
                return hN;
            }
            dPrev = dN;
            cPrev = cN;
            hPrev = hN;
        }
        throw new FractionException("maximal count ({0}) exceeded", maxIterations);
    }

    private static double updateIfCloseToZero(double value) {
        return Precision.equals((double)value, (double)0.0, (double)1.0E-50) ? 1.0E-50 : value;
    }
}

