/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.gamma;

import java.text.MessageFormat;
import org.apache.commons.numbers.fraction.ContinuedFraction;
import org.apache.commons.numbers.gamma.LogGamma;

public final class RegularizedGamma {
    private static final double DEFAULT_EPSILON = 1.0E-15;

    private RegularizedGamma() {
    }

    public static final class Q {
        private Q() {
        }

        public static double value(double a, double x) {
            return Q.value(a, x, 1.0E-15, Integer.MAX_VALUE);
        }

        public static double value(final double a, double x, double epsilon, int maxIterations) {
            if (Double.isNaN(a) || Double.isNaN(x) || a <= 0.0 || x < 0.0) {
                return Double.NaN;
            }
            if (x == 0.0) {
                return 1.0;
            }
            if (x < a + 1.0) {
                return 1.0 - P.value(a, x, epsilon, maxIterations);
            }
            ContinuedFraction cf = new ContinuedFraction(){

                protected double getA(int n, double x) {
                    return (double)n * (a - (double)n);
                }

                protected double getB(int n, double x) {
                    return (double)(2 * n + 1) - a + x;
                }
            };
            return Math.exp(-x + a * Math.log(x) - LogGamma.value(a)) / cf.evaluate(x, epsilon, maxIterations);
        }
    }

    public static final class P {
        private P() {
        }

        public static double value(double a, double x) {
            return P.value(a, x, 1.0E-15, Integer.MAX_VALUE);
        }

        public static double value(double a, double x, double epsilon, int maxIterations) {
            double sum;
            double an;
            if (Double.isNaN(a) || Double.isNaN(x) || a <= 0.0 || x < 0.0) {
                return Double.NaN;
            }
            if (x == 0.0) {
                return 0.0;
            }
            if (x >= a + 1.0) {
                return 1.0 - Q.value(a, x, epsilon, maxIterations);
            }
            double n = 0.0;
            for (sum = an = 1.0 / a; Math.abs(an / sum) > epsilon && n < (double)maxIterations && sum < Double.POSITIVE_INFINITY; sum += (an *= x / (a + (n += 1.0)))) {
            }
            if (n >= (double)maxIterations) {
                throw new ArithmeticException(MessageFormat.format("Failed to converge within {0} iterations", maxIterations));
            }
            if (Double.isInfinite(sum)) {
                return 1.0;
            }
            double result = Math.exp(-x + a * Math.log(x) - LogGamma.value(a)) * sum;
            return result > 1.0 ? 1.0 : result;
        }
    }
}

