/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.Waiter;
import org.apache.commons.pool2.impl.DefaultPooledObject;

public class AtomicIntegerFactory
extends BasePooledObjectFactory<AtomicInteger> {
    private long activateLatency;
    private long passivateLatency;
    private long createLatency;
    private long destroyLatency;
    private long validateLatency;

    public void activateObject(PooledObject<AtomicInteger> p) {
        ((AtomicInteger)p.getObject()).incrementAndGet();
        Waiter.sleepQuietly(this.activateLatency);
    }

    public AtomicInteger create() {
        Waiter.sleepQuietly(this.createLatency);
        return new AtomicInteger(0);
    }

    public void destroyObject(PooledObject<AtomicInteger> p) {
        Waiter.sleepQuietly(this.destroyLatency);
    }

    public void passivateObject(PooledObject<AtomicInteger> p) {
        ((AtomicInteger)p.getObject()).decrementAndGet();
        Waiter.sleepQuietly(this.passivateLatency);
    }

    public void setActivateLatency(long activateLatency) {
        this.activateLatency = activateLatency;
    }

    public void setCreateLatency(long createLatency) {
        this.createLatency = createLatency;
    }

    public void setDestroyLatency(long destroyLatency) {
        this.destroyLatency = destroyLatency;
    }

    public void setPassivateLatency(long passivateLatency) {
        this.passivateLatency = passivateLatency;
    }

    public void setValidateLatency(long validateLatency) {
        this.validateLatency = validateLatency;
    }

    public boolean validateObject(PooledObject<AtomicInteger> instance) {
        Waiter.sleepQuietly(this.validateLatency);
        return ((AtomicInteger)instance.getObject()).intValue() == 1;
    }

    public PooledObject<AtomicInteger> wrap(AtomicInteger integer) {
        return new DefaultPooledObject((Object)integer);
    }
}

