/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sourceforge.cobertura.coveragedata.LightClassmapListener;
import net.sourceforge.cobertura.coveragedata.TouchCollector;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;

public final class PoolUtils {
    public static final transient int[] __cobertura_counters;

    public PoolUtils() {
        int n = 0;
        __cobertura_counters[1] = __cobertura_counters[1] + 1;
        __cobertura_counters[2] = __cobertura_counters[2] + 1;
    }

    public static void checkRethrow(Throwable throwable) {
        Throwable t;
        PoolUtils.__cobertura_init();
        int n = 0;
        __cobertura_counters[3] = __cobertura_counters[3] + 1;
        n = 5;
        if (t instanceof ThreadDeath) {
            __cobertura_counters[4] = __cobertura_counters[4] + 1;
            n = 0;
            __cobertura_counters[6] = __cobertura_counters[6] + 1;
            throw (ThreadDeath)t;
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[7] = __cobertura_counters[7] + 1;
        n = 9;
        if (t instanceof VirtualMachineError) {
            __cobertura_counters[8] = __cobertura_counters[8] + 1;
            n = 0;
            __cobertura_counters[10] = __cobertura_counters[10] + 1;
            throw (VirtualMachineError)t;
        }
        int n3 = n;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n = 0;
        __cobertura_counters[11] = __cobertura_counters[11] + 1;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> TimerTask checkMinIdle(ObjectPool<T> objectPool, int n, long l) throws IllegalArgumentException {
        void period;
        void minIdle;
        ObjectPool<T> pool;
        PoolUtils.__cobertura_init();
        int n2 = 0;
        __cobertura_counters[12] = __cobertura_counters[12] + 1;
        n2 = 14;
        if (pool == null) {
            __cobertura_counters[13] = __cobertura_counters[13] + 1;
            n2 = 0;
            __cobertura_counters[15] = __cobertura_counters[15] + 1;
            throw new IllegalArgumentException("keyedPool must not be null.");
        }
        int n3 = n2;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n2 = 0;
        __cobertura_counters[16] = __cobertura_counters[16] + 1;
        n2 = 18;
        if (minIdle < 0) {
            __cobertura_counters[17] = __cobertura_counters[17] + 1;
            n2 = 0;
            __cobertura_counters[19] = __cobertura_counters[19] + 1;
            throw new IllegalArgumentException("minIdle must be non-negative.");
        }
        int n4 = n2;
        __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
        n2 = 0;
        __cobertura_counters[20] = __cobertura_counters[20] + 1;
        ObjectPoolMinIdleTimerTask<T> task = new ObjectPoolMinIdleTimerTask<T>(pool, (int)minIdle);
        __cobertura_counters[21] = __cobertura_counters[21] + 1;
        PoolUtils.getMinIdleTimer().schedule(task, 0L, (long)period);
        __cobertura_counters[22] = __cobertura_counters[22] + 1;
        return task;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> TimerTask checkMinIdle(KeyedObjectPool<K, V> keyedObjectPool, K k, int n, long l) throws IllegalArgumentException {
        void period;
        void minIdle;
        void key;
        KeyedObjectPool<K, V> keyedPool;
        PoolUtils.__cobertura_init();
        int n2 = 0;
        __cobertura_counters[23] = __cobertura_counters[23] + 1;
        n2 = 25;
        if (keyedPool == null) {
            __cobertura_counters[24] = __cobertura_counters[24] + 1;
            n2 = 0;
            __cobertura_counters[26] = __cobertura_counters[26] + 1;
            throw new IllegalArgumentException("keyedPool must not be null.");
        }
        int n3 = n2;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n2 = 0;
        __cobertura_counters[27] = __cobertura_counters[27] + 1;
        n2 = 29;
        if (key == null) {
            __cobertura_counters[28] = __cobertura_counters[28] + 1;
            n2 = 0;
            __cobertura_counters[30] = __cobertura_counters[30] + 1;
            throw new IllegalArgumentException("key must not be null.");
        }
        int n4 = n2;
        __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
        n2 = 0;
        __cobertura_counters[31] = __cobertura_counters[31] + 1;
        n2 = 33;
        if (minIdle < 0) {
            __cobertura_counters[32] = __cobertura_counters[32] + 1;
            n2 = 0;
            __cobertura_counters[34] = __cobertura_counters[34] + 1;
            throw new IllegalArgumentException("minIdle must be non-negative.");
        }
        int n5 = n2;
        __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
        n2 = 0;
        __cobertura_counters[35] = __cobertura_counters[35] + 1;
        KeyedObjectPoolMinIdleTimerTask<void, V> task = new KeyedObjectPoolMinIdleTimerTask<void, V>(keyedPool, key, (int)minIdle);
        __cobertura_counters[36] = __cobertura_counters[36] + 1;
        PoolUtils.getMinIdleTimer().schedule(task, 0L, (long)period);
        __cobertura_counters[37] = __cobertura_counters[37] + 1;
        return task;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, TimerTask> checkMinIdle(KeyedObjectPool<K, V> keyedObjectPool, Collection<K> collection, int n, long l) throws IllegalArgumentException {
        void keys;
        PoolUtils.__cobertura_init();
        int n2 = 0;
        __cobertura_counters[38] = __cobertura_counters[38] + 1;
        n2 = 40;
        if (keys == null) {
            __cobertura_counters[39] = __cobertura_counters[39] + 1;
            n2 = 0;
            __cobertura_counters[41] = __cobertura_counters[41] + 1;
            throw new IllegalArgumentException("keys must not be null.");
        }
        int n3 = n2;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n2 = 0;
        __cobertura_counters[42] = __cobertura_counters[42] + 1;
        HashMap tasks = new HashMap(keys.size());
        __cobertura_counters[43] = __cobertura_counters[43] + 1;
        Iterator iter = keys.iterator();
        while (true) {
            void period;
            void minIdle;
            KeyedObjectPool<K, V> keyedPool;
            __cobertura_counters[44] = __cobertura_counters[44] + 1;
            n2 = 46;
            if (!iter.hasNext()) break;
            __cobertura_counters[45] = __cobertura_counters[45] + 1;
            n2 = 0;
            __cobertura_counters[47] = __cobertura_counters[47] + 1;
            Object key = iter.next();
            __cobertura_counters[48] = __cobertura_counters[48] + 1;
            TimerTask task = PoolUtils.checkMinIdle(keyedPool, key, (int)minIdle, (long)period);
            __cobertura_counters[49] = __cobertura_counters[49] + 1;
            tasks.put(key, task);
            __cobertura_counters[50] = __cobertura_counters[50] + 1;
        }
        int n4 = n2;
        __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
        n2 = 0;
        __cobertura_counters[51] = __cobertura_counters[51] + 1;
        return tasks;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> void prefill(ObjectPool<T> objectPool, int n) throws Exception, IllegalArgumentException {
        ObjectPool<T> pool;
        PoolUtils.__cobertura_init();
        int n2 = 0;
        __cobertura_counters[52] = __cobertura_counters[52] + 1;
        n2 = 54;
        if (pool == null) {
            __cobertura_counters[53] = __cobertura_counters[53] + 1;
            n2 = 0;
            __cobertura_counters[55] = __cobertura_counters[55] + 1;
            throw new IllegalArgumentException("pool must not be null.");
        }
        int n3 = n2;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n2 = 0;
        __cobertura_counters[56] = __cobertura_counters[56] + 1;
        int i = 0;
        while (true) {
            void count;
            n2 = 58;
            if (i >= count) break;
            __cobertura_counters[57] = __cobertura_counters[57] + 1;
            n2 = 0;
            __cobertura_counters[60] = __cobertura_counters[60] + 1;
            pool.addObject();
            __cobertura_counters[59] = __cobertura_counters[59] + 1;
            ++i;
        }
        int n4 = n2;
        __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
        n2 = 0;
        __cobertura_counters[61] = __cobertura_counters[61] + 1;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> void prefill(KeyedObjectPool<K, V> keyedObjectPool, K k, int n) throws Exception, IllegalArgumentException {
        void key;
        KeyedObjectPool<void, V> keyedPool;
        PoolUtils.__cobertura_init();
        int n2 = 0;
        __cobertura_counters[62] = __cobertura_counters[62] + 1;
        n2 = 64;
        if (keyedPool == null) {
            __cobertura_counters[63] = __cobertura_counters[63] + 1;
            n2 = 0;
            __cobertura_counters[65] = __cobertura_counters[65] + 1;
            throw new IllegalArgumentException("keyedPool must not be null.");
        }
        int n3 = n2;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n2 = 0;
        __cobertura_counters[66] = __cobertura_counters[66] + 1;
        n2 = 68;
        if (key == null) {
            __cobertura_counters[67] = __cobertura_counters[67] + 1;
            n2 = 0;
            __cobertura_counters[69] = __cobertura_counters[69] + 1;
            throw new IllegalArgumentException("key must not be null.");
        }
        int n4 = n2;
        __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
        n2 = 0;
        __cobertura_counters[70] = __cobertura_counters[70] + 1;
        int i = 0;
        while (true) {
            void count;
            n2 = 72;
            if (i >= count) break;
            __cobertura_counters[71] = __cobertura_counters[71] + 1;
            n2 = 0;
            __cobertura_counters[74] = __cobertura_counters[74] + 1;
            keyedPool.addObject(key);
            __cobertura_counters[73] = __cobertura_counters[73] + 1;
            ++i;
        }
        int n5 = n2;
        __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
        n2 = 0;
        __cobertura_counters[75] = __cobertura_counters[75] + 1;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> void prefill(KeyedObjectPool<K, V> keyedObjectPool, Collection<K> collection, int n) throws Exception, IllegalArgumentException {
        void keys;
        PoolUtils.__cobertura_init();
        int n2 = 0;
        __cobertura_counters[76] = __cobertura_counters[76] + 1;
        n2 = 78;
        if (keys == null) {
            __cobertura_counters[77] = __cobertura_counters[77] + 1;
            n2 = 0;
            __cobertura_counters[79] = __cobertura_counters[79] + 1;
            throw new IllegalArgumentException("keys must not be null.");
        }
        int n3 = n2;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n2 = 0;
        __cobertura_counters[80] = __cobertura_counters[80] + 1;
        Iterator iter = keys.iterator();
        while (true) {
            void count;
            KeyedObjectPool<K, V> keyedPool;
            __cobertura_counters[81] = __cobertura_counters[81] + 1;
            n2 = 83;
            if (!iter.hasNext()) break;
            __cobertura_counters[82] = __cobertura_counters[82] + 1;
            n2 = 0;
            __cobertura_counters[84] = __cobertura_counters[84] + 1;
            PoolUtils.prefill(keyedPool, iter.next(), (int)count);
        }
        int n4 = n2;
        __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
        n2 = 0;
        __cobertura_counters[85] = __cobertura_counters[85] + 1;
    }

    public static <T> ObjectPool<T> synchronizedPool(ObjectPool<T> objectPool) {
        ObjectPool<T> pool;
        PoolUtils.__cobertura_init();
        int n = 0;
        __cobertura_counters[86] = __cobertura_counters[86] + 1;
        n = 88;
        if (pool == null) {
            __cobertura_counters[87] = __cobertura_counters[87] + 1;
            n = 0;
            __cobertura_counters[89] = __cobertura_counters[89] + 1;
            throw new IllegalArgumentException("pool must not be null.");
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[90] = __cobertura_counters[90] + 1;
        return new SynchronizedObjectPool<T>(pool);
    }

    public static <K, V> KeyedObjectPool<K, V> synchronizedPool(KeyedObjectPool<K, V> keyedObjectPool) {
        KeyedObjectPool<K, V> keyedPool;
        PoolUtils.__cobertura_init();
        int n = 0;
        __cobertura_counters[91] = __cobertura_counters[91] + 1;
        return new SynchronizedKeyedObjectPool<K, V>(keyedPool);
    }

    public static <T> PooledObjectFactory<T> synchronizedPooledFactory(PooledObjectFactory<T> pooledObjectFactory) {
        PooledObjectFactory<T> factory;
        PoolUtils.__cobertura_init();
        int n = 0;
        __cobertura_counters[92] = __cobertura_counters[92] + 1;
        return new SynchronizedPooledObjectFactory<T>(factory);
    }

    public static <K, V> KeyedPooledObjectFactory<K, V> synchronizedKeyedPooledFactory(KeyedPooledObjectFactory<K, V> keyedPooledObjectFactory) {
        KeyedPooledObjectFactory<K, V> keyedFactory;
        PoolUtils.__cobertura_init();
        int n = 0;
        __cobertura_counters[93] = __cobertura_counters[93] + 1;
        return new SynchronizedKeyedPooledObjectFactory<K, V>(keyedFactory);
    }

    public static <T> ObjectPool<T> erodingPool(ObjectPool<T> objectPool) {
        ObjectPool<T> pool;
        PoolUtils.__cobertura_init();
        int n = 0;
        __cobertura_counters[94] = __cobertura_counters[94] + 1;
        return PoolUtils.erodingPool(pool, 1.0f);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> ObjectPool<T> erodingPool(ObjectPool<T> objectPool, float f) {
        void factor;
        ObjectPool<T> pool;
        PoolUtils.__cobertura_init();
        int n = 0;
        __cobertura_counters[95] = __cobertura_counters[95] + 1;
        n = 97;
        if (pool == null) {
            __cobertura_counters[96] = __cobertura_counters[96] + 1;
            n = 0;
            __cobertura_counters[98] = __cobertura_counters[98] + 1;
            throw new IllegalArgumentException("pool must not be null.");
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[99] = __cobertura_counters[99] + 1;
        n = 101;
        if (factor <= 0.0f) {
            __cobertura_counters[100] = __cobertura_counters[100] + 1;
            n = 0;
            __cobertura_counters[102] = __cobertura_counters[102] + 1;
            throw new IllegalArgumentException("factor must be positive.");
        }
        int n3 = n;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n = 0;
        __cobertura_counters[103] = __cobertura_counters[103] + 1;
        return new ErodingObjectPool<T>(pool, (float)factor);
    }

    public static <K, V> KeyedObjectPool<K, V> erodingPool(KeyedObjectPool<K, V> keyedObjectPool) {
        KeyedObjectPool<K, V> keyedPool;
        PoolUtils.__cobertura_init();
        int n = 0;
        __cobertura_counters[104] = __cobertura_counters[104] + 1;
        return PoolUtils.erodingPool(keyedPool, 1.0f);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> KeyedObjectPool<K, V> erodingPool(KeyedObjectPool<K, V> keyedObjectPool, float f) {
        void factor;
        KeyedObjectPool<K, V> keyedPool;
        PoolUtils.__cobertura_init();
        int n = 0;
        __cobertura_counters[105] = __cobertura_counters[105] + 1;
        return PoolUtils.erodingPool(keyedPool, (float)factor, false);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> KeyedObjectPool<K, V> erodingPool(KeyedObjectPool<K, V> keyedObjectPool, float f, boolean bl) {
        void perKey;
        void factor;
        KeyedObjectPool<K, V> keyedPool;
        PoolUtils.__cobertura_init();
        int n = 0;
        __cobertura_counters[106] = __cobertura_counters[106] + 1;
        n = 108;
        if (keyedPool == null) {
            __cobertura_counters[107] = __cobertura_counters[107] + 1;
            n = 0;
            __cobertura_counters[109] = __cobertura_counters[109] + 1;
            throw new IllegalArgumentException("keyedPool must not be null.");
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[110] = __cobertura_counters[110] + 1;
        n = 112;
        if (factor <= 0.0f) {
            __cobertura_counters[111] = __cobertura_counters[111] + 1;
            n = 0;
            __cobertura_counters[113] = __cobertura_counters[113] + 1;
            throw new IllegalArgumentException("factor must be positive.");
        }
        int n3 = n;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n = 0;
        __cobertura_counters[114] = __cobertura_counters[114] + 1;
        n = 116;
        if (perKey != false) {
            __cobertura_counters[115] = __cobertura_counters[115] + 1;
            n = 0;
            __cobertura_counters[117] = __cobertura_counters[117] + 1;
            return new ErodingPerKeyKeyedObjectPool<K, V>(keyedPool, (float)factor);
        }
        int n4 = n;
        __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
        n = 0;
        __cobertura_counters[118] = __cobertura_counters[118] + 1;
        return new ErodingKeyedObjectPool<K, V>(keyedPool, (float)factor);
    }

    private static Timer getMinIdleTimer() {
        PoolUtils.__cobertura_init();
        int n = 0;
        __cobertura_counters[119] = __cobertura_counters[119] + 1;
        return TimerHolder.MIN_IDLE_TIMER;
    }

    static {
        PoolUtils.__cobertura_init();
    }

    public static void __cobertura_init() {
        if (__cobertura_counters == null) {
            __cobertura_counters = new int[120];
            TouchCollector.registerClass((String)"org/apache/commons/pool2/PoolUtils");
        }
    }

    public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
        LightClassmapListener lightClassmapListener2 = lightClassmapListener;
        lightClassmapListener2.putLineTouchPoint(55, 1, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(56, 2, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(72, 3, "checkRethrow", "(Ljava/lang/Throwable;)V");
        lightClassmapListener2.putJumpTouchPoint(72, 5, 4);
        lightClassmapListener2.putLineTouchPoint(73, 6, "checkRethrow", "(Ljava/lang/Throwable;)V");
        lightClassmapListener2.putLineTouchPoint(75, 7, "checkRethrow", "(Ljava/lang/Throwable;)V");
        lightClassmapListener2.putJumpTouchPoint(75, 9, 8);
        lightClassmapListener2.putLineTouchPoint(76, 10, "checkRethrow", "(Ljava/lang/Throwable;)V");
        lightClassmapListener2.putLineTouchPoint(79, 11, "checkRethrow", "(Ljava/lang/Throwable;)V");
        lightClassmapListener2.putLineTouchPoint(105, 12, "checkMinIdle", "(Lorg/apache/commons/pool2/ObjectPool;IJ)Ljava/util/TimerTask;");
        lightClassmapListener2.putJumpTouchPoint(105, 14, 13);
        lightClassmapListener2.putLineTouchPoint(106, 15, "checkMinIdle", "(Lorg/apache/commons/pool2/ObjectPool;IJ)Ljava/util/TimerTask;");
        lightClassmapListener2.putLineTouchPoint(108, 16, "checkMinIdle", "(Lorg/apache/commons/pool2/ObjectPool;IJ)Ljava/util/TimerTask;");
        lightClassmapListener2.putJumpTouchPoint(108, 18, 17);
        lightClassmapListener2.putLineTouchPoint(109, 19, "checkMinIdle", "(Lorg/apache/commons/pool2/ObjectPool;IJ)Ljava/util/TimerTask;");
        lightClassmapListener2.putLineTouchPoint(111, 20, "checkMinIdle", "(Lorg/apache/commons/pool2/ObjectPool;IJ)Ljava/util/TimerTask;");
        lightClassmapListener2.putLineTouchPoint(112, 21, "checkMinIdle", "(Lorg/apache/commons/pool2/ObjectPool;IJ)Ljava/util/TimerTask;");
        lightClassmapListener2.putLineTouchPoint(113, 22, "checkMinIdle", "(Lorg/apache/commons/pool2/ObjectPool;IJ)Ljava/util/TimerTask;");
        lightClassmapListener2.putLineTouchPoint(146, 23, "checkMinIdle", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/lang/Object;IJ)Ljava/util/TimerTask;");
        lightClassmapListener2.putJumpTouchPoint(146, 25, 24);
        lightClassmapListener2.putLineTouchPoint(147, 26, "checkMinIdle", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/lang/Object;IJ)Ljava/util/TimerTask;");
        lightClassmapListener2.putLineTouchPoint(149, 27, "checkMinIdle", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/lang/Object;IJ)Ljava/util/TimerTask;");
        lightClassmapListener2.putJumpTouchPoint(149, 29, 28);
        lightClassmapListener2.putLineTouchPoint(150, 30, "checkMinIdle", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/lang/Object;IJ)Ljava/util/TimerTask;");
        lightClassmapListener2.putLineTouchPoint(152, 31, "checkMinIdle", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/lang/Object;IJ)Ljava/util/TimerTask;");
        lightClassmapListener2.putJumpTouchPoint(152, 33, 32);
        lightClassmapListener2.putLineTouchPoint(153, 34, "checkMinIdle", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/lang/Object;IJ)Ljava/util/TimerTask;");
        lightClassmapListener2.putLineTouchPoint(155, 35, "checkMinIdle", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/lang/Object;IJ)Ljava/util/TimerTask;");
        lightClassmapListener2.putLineTouchPoint(157, 36, "checkMinIdle", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/lang/Object;IJ)Ljava/util/TimerTask;");
        lightClassmapListener2.putLineTouchPoint(158, 37, "checkMinIdle", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/lang/Object;IJ)Ljava/util/TimerTask;");
        lightClassmapListener2.putLineTouchPoint(192, 38, "checkMinIdle", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/util/Collection;IJ)Ljava/util/Map;");
        lightClassmapListener2.putJumpTouchPoint(192, 40, 39);
        lightClassmapListener2.putLineTouchPoint(193, 41, "checkMinIdle", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/util/Collection;IJ)Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(195, 42, "checkMinIdle", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/util/Collection;IJ)Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(196, 43, "checkMinIdle", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/util/Collection;IJ)Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(197, 44, "checkMinIdle", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/util/Collection;IJ)Ljava/util/Map;");
        lightClassmapListener2.putJumpTouchPoint(197, 46, 45);
        lightClassmapListener2.putLineTouchPoint(198, 47, "checkMinIdle", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/util/Collection;IJ)Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(199, 48, "checkMinIdle", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/util/Collection;IJ)Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(200, 49, "checkMinIdle", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/util/Collection;IJ)Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(201, 50, "checkMinIdle", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/util/Collection;IJ)Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(202, 51, "checkMinIdle", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/util/Collection;IJ)Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(221, 52, "prefill", "(Lorg/apache/commons/pool2/ObjectPool;I)V");
        lightClassmapListener2.putJumpTouchPoint(221, 54, 53);
        lightClassmapListener2.putLineTouchPoint(222, 55, "prefill", "(Lorg/apache/commons/pool2/ObjectPool;I)V");
        lightClassmapListener2.putLineTouchPoint(224, 56, "prefill", "(Lorg/apache/commons/pool2/ObjectPool;I)V");
        lightClassmapListener2.putJumpTouchPoint(224, 58, 57);
        lightClassmapListener2.putLineTouchPoint(224, 59, "prefill", "(Lorg/apache/commons/pool2/ObjectPool;I)V");
        lightClassmapListener2.putLineTouchPoint(225, 60, "prefill", "(Lorg/apache/commons/pool2/ObjectPool;I)V");
        lightClassmapListener2.putLineTouchPoint(227, 61, "prefill", "(Lorg/apache/commons/pool2/ObjectPool;I)V");
        lightClassmapListener2.putLineTouchPoint(250, 62, "prefill", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/lang/Object;I)V");
        lightClassmapListener2.putJumpTouchPoint(250, 64, 63);
        lightClassmapListener2.putLineTouchPoint(251, 65, "prefill", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/lang/Object;I)V");
        lightClassmapListener2.putLineTouchPoint(253, 66, "prefill", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/lang/Object;I)V");
        lightClassmapListener2.putJumpTouchPoint(253, 68, 67);
        lightClassmapListener2.putLineTouchPoint(254, 69, "prefill", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/lang/Object;I)V");
        lightClassmapListener2.putLineTouchPoint(256, 70, "prefill", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/lang/Object;I)V");
        lightClassmapListener2.putJumpTouchPoint(256, 72, 71);
        lightClassmapListener2.putLineTouchPoint(256, 73, "prefill", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/lang/Object;I)V");
        lightClassmapListener2.putLineTouchPoint(257, 74, "prefill", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/lang/Object;I)V");
        lightClassmapListener2.putLineTouchPoint(259, 75, "prefill", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/lang/Object;I)V");
        lightClassmapListener2.putLineTouchPoint(285, 76, "prefill", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/util/Collection;I)V");
        lightClassmapListener2.putJumpTouchPoint(285, 78, 77);
        lightClassmapListener2.putLineTouchPoint(286, 79, "prefill", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/util/Collection;I)V");
        lightClassmapListener2.putLineTouchPoint(288, 80, "prefill", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/util/Collection;I)V");
        lightClassmapListener2.putLineTouchPoint(289, 81, "prefill", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/util/Collection;I)V");
        lightClassmapListener2.putJumpTouchPoint(289, 83, 82);
        lightClassmapListener2.putLineTouchPoint(290, 84, "prefill", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/util/Collection;I)V");
        lightClassmapListener2.putLineTouchPoint(292, 85, "prefill", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/util/Collection;I)V");
        lightClassmapListener2.putLineTouchPoint(312, 86, "synchronizedPool", "(Lorg/apache/commons/pool2/ObjectPool;)Lorg/apache/commons/pool2/ObjectPool;");
        lightClassmapListener2.putJumpTouchPoint(312, 88, 87);
        lightClassmapListener2.putLineTouchPoint(313, 89, "synchronizedPool", "(Lorg/apache/commons/pool2/ObjectPool;)Lorg/apache/commons/pool2/ObjectPool;");
        lightClassmapListener2.putLineTouchPoint(326, 90, "synchronizedPool", "(Lorg/apache/commons/pool2/ObjectPool;)Lorg/apache/commons/pool2/ObjectPool;");
        lightClassmapListener2.putLineTouchPoint(359, 91, "synchronizedPool", "(Lorg/apache/commons/pool2/KeyedObjectPool;)Lorg/apache/commons/pool2/KeyedObjectPool;");
        lightClassmapListener2.putLineTouchPoint(374, 92, "synchronizedPooledFactory", "(Lorg/apache/commons/pool2/PooledObjectFactory;)Lorg/apache/commons/pool2/PooledObjectFactory;");
        lightClassmapListener2.putLineTouchPoint(390, 93, "synchronizedKeyedPooledFactory", "(Lorg/apache/commons/pool2/KeyedPooledObjectFactory;)Lorg/apache/commons/pool2/KeyedPooledObjectFactory;");
        lightClassmapListener2.putLineTouchPoint(409, 94, "erodingPool", "(Lorg/apache/commons/pool2/ObjectPool;)Lorg/apache/commons/pool2/ObjectPool;");
        lightClassmapListener2.putLineTouchPoint(440, 95, "erodingPool", "(Lorg/apache/commons/pool2/ObjectPool;F)Lorg/apache/commons/pool2/ObjectPool;");
        lightClassmapListener2.putJumpTouchPoint(440, 97, 96);
        lightClassmapListener2.putLineTouchPoint(441, 98, "erodingPool", "(Lorg/apache/commons/pool2/ObjectPool;F)Lorg/apache/commons/pool2/ObjectPool;");
        lightClassmapListener2.putLineTouchPoint(443, 99, "erodingPool", "(Lorg/apache/commons/pool2/ObjectPool;F)Lorg/apache/commons/pool2/ObjectPool;");
        lightClassmapListener2.putJumpTouchPoint(443, 101, 100);
        lightClassmapListener2.putLineTouchPoint(444, 102, "erodingPool", "(Lorg/apache/commons/pool2/ObjectPool;F)Lorg/apache/commons/pool2/ObjectPool;");
        lightClassmapListener2.putLineTouchPoint(446, 103, "erodingPool", "(Lorg/apache/commons/pool2/ObjectPool;F)Lorg/apache/commons/pool2/ObjectPool;");
        lightClassmapListener2.putLineTouchPoint(468, 104, "erodingPool", "(Lorg/apache/commons/pool2/KeyedObjectPool;)Lorg/apache/commons/pool2/KeyedObjectPool;");
        lightClassmapListener2.putLineTouchPoint(500, 105, "erodingPool", "(Lorg/apache/commons/pool2/KeyedObjectPool;F)Lorg/apache/commons/pool2/KeyedObjectPool;");
        lightClassmapListener2.putLineTouchPoint(542, 106, "erodingPool", "(Lorg/apache/commons/pool2/KeyedObjectPool;FZ)Lorg/apache/commons/pool2/KeyedObjectPool;");
        lightClassmapListener2.putJumpTouchPoint(542, 108, 107);
        lightClassmapListener2.putLineTouchPoint(543, 109, "erodingPool", "(Lorg/apache/commons/pool2/KeyedObjectPool;FZ)Lorg/apache/commons/pool2/KeyedObjectPool;");
        lightClassmapListener2.putLineTouchPoint(545, 110, "erodingPool", "(Lorg/apache/commons/pool2/KeyedObjectPool;FZ)Lorg/apache/commons/pool2/KeyedObjectPool;");
        lightClassmapListener2.putJumpTouchPoint(545, 112, 111);
        lightClassmapListener2.putLineTouchPoint(546, 113, "erodingPool", "(Lorg/apache/commons/pool2/KeyedObjectPool;FZ)Lorg/apache/commons/pool2/KeyedObjectPool;");
        lightClassmapListener2.putLineTouchPoint(548, 114, "erodingPool", "(Lorg/apache/commons/pool2/KeyedObjectPool;FZ)Lorg/apache/commons/pool2/KeyedObjectPool;");
        lightClassmapListener2.putJumpTouchPoint(548, 116, 115);
        lightClassmapListener2.putLineTouchPoint(549, 117, "erodingPool", "(Lorg/apache/commons/pool2/KeyedObjectPool;FZ)Lorg/apache/commons/pool2/KeyedObjectPool;");
        lightClassmapListener2.putLineTouchPoint(551, 118, "erodingPool", "(Lorg/apache/commons/pool2/KeyedObjectPool;FZ)Lorg/apache/commons/pool2/KeyedObjectPool;");
        lightClassmapListener2.putLineTouchPoint(560, 119, "getMinIdleTimer", "()Ljava/util/Timer;");
    }

    public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
        LightClassmapListener lightClassmapListener2 = lightClassmapListener;
        lightClassmapListener2.setClazz("org/apache/commons/pool2/PoolUtils");
        lightClassmapListener2.setSource("PoolUtils.java");
        PoolUtils.__cobertura_classmap_0(lightClassmapListener2);
    }

    public static int[] __cobertura_get_and_reset_counters() {
        int[] nArray = __cobertura_counters;
        __cobertura_counters = new int[__cobertura_counters.length];
        return nArray;
    }

    private static class ErodingPerKeyKeyedObjectPool<K, V>
    extends ErodingKeyedObjectPool<K, V> {
        public static final transient int[] __cobertura_counters;
        private final float factor;
        private final Map<K, ErodingFactor> factors;

        /*
         * WARNING - void declaration
         */
        public ErodingPerKeyKeyedObjectPool(KeyedObjectPool<K, V> keyedObjectPool, float f) {
            void factor;
            void keyedPool;
            int n = 0;
            __cobertura_counters[2] = __cobertura_counters[2] + 1;
            super(keyedPool, (ErodingFactor)null);
            __cobertura_counters[1] = __cobertura_counters[1] + 1;
            this.factors = Collections.synchronizedMap(new HashMap());
            __cobertura_counters[3] = __cobertura_counters[3] + 1;
            this.factor = factor;
            __cobertura_counters[4] = __cobertura_counters[4] + 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected ErodingFactor getErodingFactor(K k) {
            void key;
            int n = 0;
            __cobertura_counters[5] = __cobertura_counters[5] + 1;
            ErodingFactor eFactor = this.factors.get(key);
            __cobertura_counters[6] = __cobertura_counters[6] + 1;
            n = 8;
            if (eFactor == null) {
                __cobertura_counters[7] = __cobertura_counters[7] + 1;
                n = 0;
                __cobertura_counters[9] = __cobertura_counters[9] + 1;
                eFactor = new ErodingFactor(this.factor);
                __cobertura_counters[10] = __cobertura_counters[10] + 1;
                this.factors.put(key, eFactor);
            }
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[11] = __cobertura_counters[11] + 1;
            return eFactor;
        }

        @Override
        public String toString() {
            int n = 0;
            __cobertura_counters[12] = __cobertura_counters[12] + 1;
            __cobertura_counters[13] = __cobertura_counters[13] + 1;
            return "ErodingPerKeyKeyedObjectPool{factor=" + this.factor + ", keyedPool=" + this.getKeyedPool() + '}';
        }

        static {
            ErodingPerKeyKeyedObjectPool.__cobertura_init();
        }

        public static void __cobertura_init() {
            if (__cobertura_counters == null) {
                __cobertura_counters = new int[14];
                TouchCollector.registerClass((String)"org/apache/commons/pool2/PoolUtils$ErodingPerKeyKeyedObjectPool");
            }
        }

        public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.putLineTouchPoint(1762, 1, "<init>", "(Lorg/apache/commons/pool2/KeyedObjectPool;F)V");
            lightClassmapListener2.putLineTouchPoint(1775, 2, "<init>", "(Lorg/apache/commons/pool2/KeyedObjectPool;F)V");
            lightClassmapListener2.putLineTouchPoint(1776, 3, "<init>", "(Lorg/apache/commons/pool2/KeyedObjectPool;F)V");
            lightClassmapListener2.putLineTouchPoint(1777, 4, "<init>", "(Lorg/apache/commons/pool2/KeyedObjectPool;F)V");
            lightClassmapListener2.putLineTouchPoint(1784, 5, "getErodingFactor", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PoolUtils$ErodingFactor;");
            lightClassmapListener2.putLineTouchPoint(1787, 6, "getErodingFactor", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PoolUtils$ErodingFactor;");
            lightClassmapListener2.putJumpTouchPoint(1787, 8, 7);
            lightClassmapListener2.putLineTouchPoint(1788, 9, "getErodingFactor", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PoolUtils$ErodingFactor;");
            lightClassmapListener2.putLineTouchPoint(1789, 10, "getErodingFactor", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PoolUtils$ErodingFactor;");
            lightClassmapListener2.putLineTouchPoint(1791, 11, "getErodingFactor", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PoolUtils$ErodingFactor;");
            lightClassmapListener2.putLineTouchPoint(1799, 12, "toString", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(1800, 13, "toString", "()Ljava/lang/String;");
        }

        public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.setClazz("org/apache/commons/pool2/PoolUtils$ErodingPerKeyKeyedObjectPool");
            lightClassmapListener2.setSource("PoolUtils.java");
            ErodingPerKeyKeyedObjectPool.__cobertura_classmap_0(lightClassmapListener2);
        }

        public static int[] __cobertura_get_and_reset_counters() {
            int[] nArray = __cobertura_counters;
            __cobertura_counters = new int[__cobertura_counters.length];
            return nArray;
        }
    }

    private static class ErodingKeyedObjectPool<K, V>
    implements KeyedObjectPool<K, V> {
        public static final transient int[] __cobertura_counters;
        private final KeyedObjectPool<K, V> keyedPool;
        private final ErodingFactor erodingFactor;

        /*
         * WARNING - void declaration
         */
        public ErodingKeyedObjectPool(KeyedObjectPool<K, V> keyedObjectPool, float f) {
            void factor;
            void keyedPool;
            int n = 0;
            __cobertura_counters[1] = __cobertura_counters[1] + 1;
            this((KeyedObjectPool<K, V>)keyedPool, new ErodingFactor((float)factor));
            __cobertura_counters[2] = __cobertura_counters[2] + 1;
        }

        /*
         * WARNING - void declaration
         */
        protected ErodingKeyedObjectPool(KeyedObjectPool<K, V> keyedObjectPool, ErodingFactor erodingFactor) {
            void erodingFactor2;
            void keyedPool;
            int n = 0;
            __cobertura_counters[3] = __cobertura_counters[3] + 1;
            __cobertura_counters[4] = __cobertura_counters[4] + 1;
            n = 6;
            if (keyedPool == null) {
                __cobertura_counters[5] = __cobertura_counters[5] + 1;
                n = 0;
                __cobertura_counters[7] = __cobertura_counters[7] + 1;
                throw new IllegalArgumentException("keyedPool must not be null.");
            }
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[8] = __cobertura_counters[8] + 1;
            this.keyedPool = keyedPool;
            __cobertura_counters[9] = __cobertura_counters[9] + 1;
            this.erodingFactor = erodingFactor2;
            __cobertura_counters[10] = __cobertura_counters[10] + 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V borrowObject(K k) throws Exception, NoSuchElementException, IllegalStateException {
            void key;
            int n = 0;
            __cobertura_counters[11] = __cobertura_counters[11] + 1;
            return this.keyedPool.borrowObject(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void returnObject(K k, V v) throws Exception {
            block8: {
                void key;
                int n = 0;
                __cobertura_counters[12] = __cobertura_counters[12] + 1;
                boolean discard = false;
                __cobertura_counters[13] = __cobertura_counters[13] + 1;
                long now = System.currentTimeMillis();
                __cobertura_counters[14] = __cobertura_counters[14] + 1;
                ErodingFactor factor = this.getErodingFactor(key);
                __cobertura_counters[15] = __cobertura_counters[15] + 1;
                Object object = this.keyedPool;
                synchronized (object) {
                    __cobertura_counters[16] = __cobertura_counters[16] + 1;
                    n = 18;
                    if (factor.getNextShrink() < now) {
                        __cobertura_counters[17] = __cobertura_counters[17] + 1;
                        n = 0;
                        __cobertura_counters[19] = __cobertura_counters[19] + 1;
                        int numIdle = this.getNumIdle(key);
                        __cobertura_counters[20] = __cobertura_counters[20] + 1;
                        n = 22;
                        if (numIdle > 0) {
                            __cobertura_counters[21] = __cobertura_counters[21] + 1;
                            n = 0;
                            __cobertura_counters[23] = __cobertura_counters[23] + 1;
                            discard = true;
                        }
                        int n2 = n;
                        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                        n = 0;
                        __cobertura_counters[24] = __cobertura_counters[24] + 1;
                        factor.update(now, numIdle);
                    }
                    int n3 = n;
                    __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
                    n = 0;
                    __cobertura_counters[25] = __cobertura_counters[25] + 1;
                }
                try {
                    void obj;
                    __cobertura_counters[26] = __cobertura_counters[26] + 1;
                    n = 28;
                    if (discard) {
                        __cobertura_counters[27] = __cobertura_counters[27] + 1;
                        n = 0;
                        __cobertura_counters[29] = __cobertura_counters[29] + 1;
                        this.keyedPool.invalidateObject(key, obj);
                        break block8;
                    }
                    int n4 = n;
                    __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
                    n = 0;
                    __cobertura_counters[30] = __cobertura_counters[30] + 1;
                    this.keyedPool.returnObject(key, obj);
                }
                catch (Exception exception) {
                    __cobertura_counters[31] = __cobertura_counters[31] + 1;
                    object = exception;
                }
            }
            __cobertura_counters[32] = __cobertura_counters[32] + 1;
            __cobertura_counters[33] = __cobertura_counters[33] + 1;
        }

        protected ErodingFactor getErodingFactor(K k) {
            int n = 0;
            __cobertura_counters[34] = __cobertura_counters[34] + 1;
            return this.erodingFactor;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void invalidateObject(K k, V v) {
            int n = 0;
            try {
                void obj;
                void key;
                __cobertura_counters[35] = __cobertura_counters[35] + 1;
                this.keyedPool.invalidateObject(key, obj);
            }
            catch (Exception exception) {
                __cobertura_counters[36] = __cobertura_counters[36] + 1;
                Exception exception2 = exception;
            }
            __cobertura_counters[37] = __cobertura_counters[37] + 1;
            __cobertura_counters[38] = __cobertura_counters[38] + 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void addObject(K k) throws Exception, IllegalStateException, UnsupportedOperationException {
            void key;
            int n = 0;
            __cobertura_counters[39] = __cobertura_counters[39] + 1;
            this.keyedPool.addObject(key);
            __cobertura_counters[40] = __cobertura_counters[40] + 1;
        }

        @Override
        public int getNumIdle() {
            int n = 0;
            __cobertura_counters[41] = __cobertura_counters[41] + 1;
            return this.keyedPool.getNumIdle();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int getNumIdle(K k) {
            void key;
            int n = 0;
            __cobertura_counters[42] = __cobertura_counters[42] + 1;
            return this.keyedPool.getNumIdle(key);
        }

        @Override
        public int getNumActive() {
            int n = 0;
            __cobertura_counters[43] = __cobertura_counters[43] + 1;
            return this.keyedPool.getNumActive();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int getNumActive(K k) {
            void key;
            int n = 0;
            __cobertura_counters[44] = __cobertura_counters[44] + 1;
            return this.keyedPool.getNumActive(key);
        }

        @Override
        public void clear() throws Exception, UnsupportedOperationException {
            int n = 0;
            __cobertura_counters[45] = __cobertura_counters[45] + 1;
            this.keyedPool.clear();
            __cobertura_counters[46] = __cobertura_counters[46] + 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void clear(K k) throws Exception, UnsupportedOperationException {
            void key;
            int n = 0;
            __cobertura_counters[47] = __cobertura_counters[47] + 1;
            this.keyedPool.clear(key);
            __cobertura_counters[48] = __cobertura_counters[48] + 1;
        }

        @Override
        public void close() {
            int n = 0;
            try {
                __cobertura_counters[49] = __cobertura_counters[49] + 1;
                this.keyedPool.close();
            }
            catch (Exception exception) {
                __cobertura_counters[50] = __cobertura_counters[50] + 1;
                Exception exception2 = exception;
            }
            __cobertura_counters[51] = __cobertura_counters[51] + 1;
            __cobertura_counters[52] = __cobertura_counters[52] + 1;
        }

        protected KeyedObjectPool<K, V> getKeyedPool() {
            int n = 0;
            __cobertura_counters[53] = __cobertura_counters[53] + 1;
            return this.keyedPool;
        }

        public String toString() {
            int n = 0;
            __cobertura_counters[54] = __cobertura_counters[54] + 1;
            return "ErodingKeyedObjectPool{factor=" + this.erodingFactor + ", keyedPool=" + this.keyedPool + '}';
        }

        static {
            ErodingKeyedObjectPool.__cobertura_init();
        }

        public static void __cobertura_init() {
            if (__cobertura_counters == null) {
                __cobertura_counters = new int[55];
                TouchCollector.registerClass((String)"org/apache/commons/pool2/PoolUtils$ErodingKeyedObjectPool");
            }
        }

        public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.putLineTouchPoint(1567, 1, "<init>", "(Lorg/apache/commons/pool2/KeyedObjectPool;F)V");
            lightClassmapListener2.putLineTouchPoint(1568, 2, "<init>", "(Lorg/apache/commons/pool2/KeyedObjectPool;F)V");
            lightClassmapListener2.putLineTouchPoint(1582, 3, "<init>", "(Lorg/apache/commons/pool2/KeyedObjectPool;Lorg/apache/commons/pool2/PoolUtils$ErodingFactor;)V");
            lightClassmapListener2.putLineTouchPoint(1583, 4, "<init>", "(Lorg/apache/commons/pool2/KeyedObjectPool;Lorg/apache/commons/pool2/PoolUtils$ErodingFactor;)V");
            lightClassmapListener2.putJumpTouchPoint(1583, 6, 5);
            lightClassmapListener2.putLineTouchPoint(1584, 7, "<init>", "(Lorg/apache/commons/pool2/KeyedObjectPool;Lorg/apache/commons/pool2/PoolUtils$ErodingFactor;)V");
            lightClassmapListener2.putLineTouchPoint(1587, 8, "<init>", "(Lorg/apache/commons/pool2/KeyedObjectPool;Lorg/apache/commons/pool2/PoolUtils$ErodingFactor;)V");
            lightClassmapListener2.putLineTouchPoint(1588, 9, "<init>", "(Lorg/apache/commons/pool2/KeyedObjectPool;Lorg/apache/commons/pool2/PoolUtils$ErodingFactor;)V");
            lightClassmapListener2.putLineTouchPoint(1589, 10, "<init>", "(Lorg/apache/commons/pool2/KeyedObjectPool;Lorg/apache/commons/pool2/PoolUtils$ErodingFactor;)V");
            lightClassmapListener2.putLineTouchPoint(1597, 11, "borrowObject", "(Ljava/lang/Object;)Ljava/lang/Object;");
            lightClassmapListener2.putLineTouchPoint(1615, 12, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1616, 13, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1617, 14, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1618, 15, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1619, 16, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putJumpTouchPoint(1619, 18, 17);
            lightClassmapListener2.putLineTouchPoint(1620, 19, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1621, 20, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putJumpTouchPoint(1621, 22, 21);
            lightClassmapListener2.putLineTouchPoint(1622, 23, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1625, 24, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1627, 25, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1629, 26, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putJumpTouchPoint(1629, 28, 27);
            lightClassmapListener2.putLineTouchPoint(1630, 29, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1632, 30, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1634, 31, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1636, 32, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1637, 33, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1647, 34, "getErodingFactor", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PoolUtils$ErodingFactor;");
            lightClassmapListener2.putLineTouchPoint(1656, 35, "invalidateObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1657, 36, "invalidateObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1659, 37, "invalidateObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1660, 38, "invalidateObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1668, 39, "addObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1669, 40, "addObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1676, 41, "getNumIdle", "()I");
            lightClassmapListener2.putLineTouchPoint(1684, 42, "getNumIdle", "(Ljava/lang/Object;)I");
            lightClassmapListener2.putLineTouchPoint(1692, 43, "getNumActive", "()I");
            lightClassmapListener2.putLineTouchPoint(1700, 44, "getNumActive", "(Ljava/lang/Object;)I");
            lightClassmapListener2.putLineTouchPoint(1708, 45, "clear", "()V");
            lightClassmapListener2.putLineTouchPoint(1709, 46, "clear", "()V");
            lightClassmapListener2.putLineTouchPoint(1717, 47, "clear", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1718, 48, "clear", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1726, 49, "close", "()V");
            lightClassmapListener2.putLineTouchPoint(1727, 50, "close", "()V");
            lightClassmapListener2.putLineTouchPoint(1729, 51, "close", "()V");
            lightClassmapListener2.putLineTouchPoint(1730, 52, "close", "()V");
            lightClassmapListener2.putLineTouchPoint(1738, 53, "getKeyedPool", "()Lorg/apache/commons/pool2/KeyedObjectPool;");
            lightClassmapListener2.putLineTouchPoint(1746, 54, "toString", "()Ljava/lang/String;");
        }

        public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.setClazz("org/apache/commons/pool2/PoolUtils$ErodingKeyedObjectPool");
            lightClassmapListener2.setSource("PoolUtils.java");
            ErodingKeyedObjectPool.__cobertura_classmap_0(lightClassmapListener2);
        }

        public static int[] __cobertura_get_and_reset_counters() {
            int[] nArray = __cobertura_counters;
            __cobertura_counters = new int[__cobertura_counters.length];
            return nArray;
        }
    }

    private static class ErodingObjectPool<T>
    implements ObjectPool<T> {
        public static final transient int[] __cobertura_counters;
        private final ObjectPool<T> pool;
        private final ErodingFactor factor;

        /*
         * WARNING - void declaration
         */
        public ErodingObjectPool(ObjectPool<T> objectPool, float f) {
            void factor;
            void pool;
            int n = 0;
            __cobertura_counters[1] = __cobertura_counters[1] + 1;
            __cobertura_counters[2] = __cobertura_counters[2] + 1;
            this.pool = pool;
            __cobertura_counters[3] = __cobertura_counters[3] + 1;
            this.factor = new ErodingFactor((float)factor);
            __cobertura_counters[4] = __cobertura_counters[4] + 1;
        }

        @Override
        public T borrowObject() throws Exception, NoSuchElementException, IllegalStateException {
            int n = 0;
            __cobertura_counters[5] = __cobertura_counters[5] + 1;
            return this.pool.borrowObject();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void returnObject(T t) {
            block8: {
                int n = 0;
                __cobertura_counters[6] = __cobertura_counters[6] + 1;
                boolean discard = false;
                __cobertura_counters[7] = __cobertura_counters[7] + 1;
                long now = System.currentTimeMillis();
                __cobertura_counters[8] = __cobertura_counters[8] + 1;
                Object object = this.pool;
                synchronized (object) {
                    __cobertura_counters[9] = __cobertura_counters[9] + 1;
                    n = 11;
                    if (this.factor.getNextShrink() < now) {
                        __cobertura_counters[10] = __cobertura_counters[10] + 1;
                        n = 0;
                        __cobertura_counters[12] = __cobertura_counters[12] + 1;
                        int numIdle = this.pool.getNumIdle();
                        __cobertura_counters[13] = __cobertura_counters[13] + 1;
                        n = 15;
                        if (numIdle > 0) {
                            __cobertura_counters[14] = __cobertura_counters[14] + 1;
                            n = 0;
                            __cobertura_counters[16] = __cobertura_counters[16] + 1;
                            discard = true;
                        }
                        int n2 = n;
                        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                        n = 0;
                        __cobertura_counters[17] = __cobertura_counters[17] + 1;
                        this.factor.update(now, numIdle);
                    }
                    int n3 = n;
                    __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
                    n = 0;
                    __cobertura_counters[18] = __cobertura_counters[18] + 1;
                }
                try {
                    void obj;
                    __cobertura_counters[19] = __cobertura_counters[19] + 1;
                    n = 21;
                    if (discard) {
                        __cobertura_counters[20] = __cobertura_counters[20] + 1;
                        n = 0;
                        __cobertura_counters[22] = __cobertura_counters[22] + 1;
                        this.pool.invalidateObject(obj);
                        break block8;
                    }
                    int n4 = n;
                    __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
                    n = 0;
                    __cobertura_counters[23] = __cobertura_counters[23] + 1;
                    this.pool.returnObject(obj);
                }
                catch (Exception exception) {
                    __cobertura_counters[24] = __cobertura_counters[24] + 1;
                    object = exception;
                }
            }
            __cobertura_counters[25] = __cobertura_counters[25] + 1;
            __cobertura_counters[26] = __cobertura_counters[26] + 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void invalidateObject(T t) {
            int n = 0;
            try {
                void obj;
                __cobertura_counters[27] = __cobertura_counters[27] + 1;
                this.pool.invalidateObject(obj);
            }
            catch (Exception exception) {
                __cobertura_counters[28] = __cobertura_counters[28] + 1;
                Exception exception2 = exception;
            }
            __cobertura_counters[29] = __cobertura_counters[29] + 1;
            __cobertura_counters[30] = __cobertura_counters[30] + 1;
        }

        @Override
        public void addObject() throws Exception, IllegalStateException, UnsupportedOperationException {
            int n = 0;
            __cobertura_counters[31] = __cobertura_counters[31] + 1;
            this.pool.addObject();
            __cobertura_counters[32] = __cobertura_counters[32] + 1;
        }

        @Override
        public int getNumIdle() {
            int n = 0;
            __cobertura_counters[33] = __cobertura_counters[33] + 1;
            return this.pool.getNumIdle();
        }

        @Override
        public int getNumActive() {
            int n = 0;
            __cobertura_counters[34] = __cobertura_counters[34] + 1;
            return this.pool.getNumActive();
        }

        @Override
        public void clear() throws Exception, UnsupportedOperationException {
            int n = 0;
            __cobertura_counters[35] = __cobertura_counters[35] + 1;
            this.pool.clear();
            __cobertura_counters[36] = __cobertura_counters[36] + 1;
        }

        @Override
        public void close() {
            int n = 0;
            try {
                __cobertura_counters[37] = __cobertura_counters[37] + 1;
                this.pool.close();
            }
            catch (Exception exception) {
                __cobertura_counters[38] = __cobertura_counters[38] + 1;
                Exception exception2 = exception;
            }
            __cobertura_counters[39] = __cobertura_counters[39] + 1;
            __cobertura_counters[40] = __cobertura_counters[40] + 1;
        }

        public String toString() {
            int n = 0;
            __cobertura_counters[41] = __cobertura_counters[41] + 1;
            return "ErodingObjectPool{factor=" + this.factor + ", pool=" + this.pool + '}';
        }

        static {
            ErodingObjectPool.__cobertura_init();
        }

        public static void __cobertura_init() {
            if (__cobertura_counters == null) {
                __cobertura_counters = new int[42];
                TouchCollector.registerClass((String)"org/apache/commons/pool2/PoolUtils$ErodingObjectPool");
            }
        }

        public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.putLineTouchPoint(1423, 1, "<init>", "(Lorg/apache/commons/pool2/ObjectPool;F)V");
            lightClassmapListener2.putLineTouchPoint(1424, 2, "<init>", "(Lorg/apache/commons/pool2/ObjectPool;F)V");
            lightClassmapListener2.putLineTouchPoint(1425, 3, "<init>", "(Lorg/apache/commons/pool2/ObjectPool;F)V");
            lightClassmapListener2.putLineTouchPoint(1426, 4, "<init>", "(Lorg/apache/commons/pool2/ObjectPool;F)V");
            lightClassmapListener2.putLineTouchPoint(1434, 5, "borrowObject", "()Ljava/lang/Object;");
            lightClassmapListener2.putLineTouchPoint(1450, 6, "returnObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1451, 7, "returnObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1452, 8, "returnObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1453, 9, "returnObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putJumpTouchPoint(1453, 11, 10);
            lightClassmapListener2.putLineTouchPoint(1455, 12, "returnObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1456, 13, "returnObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putJumpTouchPoint(1456, 15, 14);
            lightClassmapListener2.putLineTouchPoint(1457, 16, "returnObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1460, 17, "returnObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1462, 18, "returnObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1464, 19, "returnObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putJumpTouchPoint(1464, 21, 20);
            lightClassmapListener2.putLineTouchPoint(1465, 22, "returnObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1467, 23, "returnObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1469, 24, "returnObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1471, 25, "returnObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1472, 26, "returnObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1480, 27, "invalidateObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1481, 28, "invalidateObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1483, 29, "invalidateObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1484, 30, "invalidateObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1492, 31, "addObject", "()V");
            lightClassmapListener2.putLineTouchPoint(1493, 32, "addObject", "()V");
            lightClassmapListener2.putLineTouchPoint(1500, 33, "getNumIdle", "()I");
            lightClassmapListener2.putLineTouchPoint(1508, 34, "getNumActive", "()I");
            lightClassmapListener2.putLineTouchPoint(1516, 35, "clear", "()V");
            lightClassmapListener2.putLineTouchPoint(1517, 36, "clear", "()V");
            lightClassmapListener2.putLineTouchPoint(1525, 37, "close", "()V");
            lightClassmapListener2.putLineTouchPoint(1526, 38, "close", "()V");
            lightClassmapListener2.putLineTouchPoint(1528, 39, "close", "()V");
            lightClassmapListener2.putLineTouchPoint(1529, 40, "close", "()V");
            lightClassmapListener2.putLineTouchPoint(1536, 41, "toString", "()Ljava/lang/String;");
        }

        public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.setClazz("org/apache/commons/pool2/PoolUtils$ErodingObjectPool");
            lightClassmapListener2.setSource("PoolUtils.java");
            ErodingObjectPool.__cobertura_classmap_0(lightClassmapListener2);
        }

        public static int[] __cobertura_get_and_reset_counters() {
            int[] nArray = __cobertura_counters;
            __cobertura_counters = new int[__cobertura_counters.length];
            return nArray;
        }
    }

    private static class ErodingFactor {
        public static final transient int[] __cobertura_counters;
        private final float factor;
        private volatile transient long nextShrink;
        private volatile transient int idleHighWaterMark;

        /*
         * WARNING - void declaration
         */
        public ErodingFactor(float f) {
            void factor;
            int n = 0;
            __cobertura_counters[1] = __cobertura_counters[1] + 1;
            __cobertura_counters[2] = __cobertura_counters[2] + 1;
            this.factor = factor;
            __cobertura_counters[3] = __cobertura_counters[3] + 1;
            this.nextShrink = System.currentTimeMillis() + (long)(900000.0f * factor);
            __cobertura_counters[4] = __cobertura_counters[4] + 1;
            this.idleHighWaterMark = 1;
            __cobertura_counters[5] = __cobertura_counters[5] + 1;
        }

        /*
         * WARNING - void declaration
         */
        public void update(long l, int n) {
            void now;
            void numIdle;
            int n2 = 0;
            __cobertura_counters[6] = __cobertura_counters[6] + 1;
            int idle = Math.max(0, (int)numIdle);
            __cobertura_counters[7] = __cobertura_counters[7] + 1;
            this.idleHighWaterMark = Math.max(idle, this.idleHighWaterMark);
            __cobertura_counters[8] = __cobertura_counters[8] + 1;
            float maxInterval = 15.0f;
            __cobertura_counters[9] = __cobertura_counters[9] + 1;
            float minutes = 15.0f + -14.0f / (float)this.idleHighWaterMark * (float)idle;
            __cobertura_counters[10] = __cobertura_counters[10] + 1;
            this.nextShrink = now + (long)(minutes * 60000.0f * this.factor);
            __cobertura_counters[11] = __cobertura_counters[11] + 1;
        }

        public long getNextShrink() {
            int n = 0;
            __cobertura_counters[12] = __cobertura_counters[12] + 1;
            return this.nextShrink;
        }

        public String toString() {
            int n = 0;
            __cobertura_counters[13] = __cobertura_counters[13] + 1;
            return "ErodingFactor{factor=" + this.factor + ", idleHighWaterMark=" + this.idleHighWaterMark + '}';
        }

        static {
            ErodingFactor.__cobertura_init();
        }

        public static void __cobertura_init() {
            if (__cobertura_counters == null) {
                __cobertura_counters = new int[14];
                TouchCollector.registerClass((String)"org/apache/commons/pool2/PoolUtils$ErodingFactor");
            }
        }

        public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.putLineTouchPoint(1353, 1, "<init>", "(F)V");
            lightClassmapListener2.putLineTouchPoint(1354, 2, "<init>", "(F)V");
            lightClassmapListener2.putLineTouchPoint(1355, 3, "<init>", "(F)V");
            lightClassmapListener2.putLineTouchPoint(1361, 4, "<init>", "(F)V");
            lightClassmapListener2.putLineTouchPoint(1362, 5, "<init>", "(F)V");
            lightClassmapListener2.putLineTouchPoint(1373, 6, "update", "(JI)V");
            lightClassmapListener2.putLineTouchPoint(1374, 7, "update", "(JI)V");
            lightClassmapListener2.putLineTouchPoint(1375, 8, "update", "(JI)V");
            lightClassmapListener2.putLineTouchPoint(1376, 9, "update", "(JI)V");
            lightClassmapListener2.putLineTouchPoint(1378, 10, "update", "(JI)V");
            lightClassmapListener2.putLineTouchPoint(1379, 11, "update", "(JI)V");
            lightClassmapListener2.putLineTouchPoint(1387, 12, "getNextShrink", "()J");
            lightClassmapListener2.putLineTouchPoint(1395, 13, "toString", "()Ljava/lang/String;");
        }

        public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.setClazz("org/apache/commons/pool2/PoolUtils$ErodingFactor");
            lightClassmapListener2.setSource("PoolUtils.java");
            ErodingFactor.__cobertura_classmap_0(lightClassmapListener2);
        }

        public static int[] __cobertura_get_and_reset_counters() {
            int[] nArray = __cobertura_counters;
            __cobertura_counters = new int[__cobertura_counters.length];
            return nArray;
        }
    }

    private static class SynchronizedKeyedPooledObjectFactory<K, V>
    implements KeyedPooledObjectFactory<K, V> {
        public static final transient int[] __cobertura_counters;
        private final ReentrantReadWriteLock.WriteLock writeLock;
        private final KeyedPooledObjectFactory<K, V> keyedFactory;

        /*
         * WARNING - void declaration
         */
        SynchronizedKeyedPooledObjectFactory(KeyedPooledObjectFactory<K, V> keyedPooledObjectFactory) throws IllegalArgumentException {
            void keyedFactory;
            int n = 0;
            __cobertura_counters[2] = __cobertura_counters[2] + 1;
            __cobertura_counters[1] = __cobertura_counters[1] + 1;
            this.writeLock = new ReentrantReadWriteLock().writeLock();
            __cobertura_counters[3] = __cobertura_counters[3] + 1;
            n = 5;
            if (keyedFactory == null) {
                __cobertura_counters[4] = __cobertura_counters[4] + 1;
                n = 0;
                __cobertura_counters[6] = __cobertura_counters[6] + 1;
                throw new IllegalArgumentException("keyedFactory must not be null.");
            }
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[7] = __cobertura_counters[7] + 1;
            this.keyedFactory = keyedFactory;
            __cobertura_counters[8] = __cobertura_counters[8] + 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public PooledObject<V> makeObject(K k) throws Exception {
            PooledObject<V> pooledObject;
            int n = 0;
            __cobertura_counters[9] = __cobertura_counters[9] + 1;
            this.writeLock.lock();
            try {
                void key;
                __cobertura_counters[10] = __cobertura_counters[10] + 1;
                pooledObject = this.keyedFactory.makeObject(key);
            }
            catch (Throwable throwable) {
                this.writeLock.unlock();
                throw throwable;
            }
            __cobertura_counters[11] = __cobertura_counters[11] + 1;
            this.writeLock.unlock();
            return pooledObject;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void destroyObject(K k, PooledObject<V> pooledObject) throws Exception {
            int n = 0;
            __cobertura_counters[12] = __cobertura_counters[12] + 1;
            this.writeLock.lock();
            try {
                void p;
                void key;
                __cobertura_counters[13] = __cobertura_counters[13] + 1;
                this.keyedFactory.destroyObject(key, (PooledObject<V>)p);
            }
            catch (Throwable throwable) {
                __cobertura_counters[14] = __cobertura_counters[14] + 1;
                Throwable throwable2 = throwable;
                this.writeLock.unlock();
                throw throwable2;
            }
            __cobertura_counters[14] = __cobertura_counters[14] + 1;
            this.writeLock.unlock();
            __cobertura_counters[15] = __cobertura_counters[15] + 1;
            __cobertura_counters[16] = __cobertura_counters[16] + 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public boolean validateObject(K k, PooledObject<V> pooledObject) {
            boolean bl;
            int n = 0;
            __cobertura_counters[17] = __cobertura_counters[17] + 1;
            this.writeLock.lock();
            try {
                void p;
                void key;
                __cobertura_counters[18] = __cobertura_counters[18] + 1;
                bl = this.keyedFactory.validateObject(key, (PooledObject<V>)p);
            }
            catch (Throwable throwable) {
                this.writeLock.unlock();
                throw throwable;
            }
            __cobertura_counters[19] = __cobertura_counters[19] + 1;
            this.writeLock.unlock();
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void activateObject(K k, PooledObject<V> pooledObject) throws Exception {
            int n = 0;
            __cobertura_counters[20] = __cobertura_counters[20] + 1;
            this.writeLock.lock();
            try {
                void p;
                void key;
                __cobertura_counters[21] = __cobertura_counters[21] + 1;
                this.keyedFactory.activateObject(key, (PooledObject<V>)p);
            }
            catch (Throwable throwable) {
                __cobertura_counters[22] = __cobertura_counters[22] + 1;
                Throwable throwable2 = throwable;
                this.writeLock.unlock();
                throw throwable2;
            }
            __cobertura_counters[22] = __cobertura_counters[22] + 1;
            this.writeLock.unlock();
            __cobertura_counters[23] = __cobertura_counters[23] + 1;
            __cobertura_counters[24] = __cobertura_counters[24] + 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void passivateObject(K k, PooledObject<V> pooledObject) throws Exception {
            int n = 0;
            __cobertura_counters[25] = __cobertura_counters[25] + 1;
            this.writeLock.lock();
            try {
                void p;
                void key;
                __cobertura_counters[26] = __cobertura_counters[26] + 1;
                this.keyedFactory.passivateObject(key, (PooledObject<V>)p);
            }
            catch (Throwable throwable) {
                __cobertura_counters[27] = __cobertura_counters[27] + 1;
                Throwable throwable2 = throwable;
                this.writeLock.unlock();
                throw throwable2;
            }
            __cobertura_counters[27] = __cobertura_counters[27] + 1;
            this.writeLock.unlock();
            __cobertura_counters[28] = __cobertura_counters[28] + 1;
            __cobertura_counters[29] = __cobertura_counters[29] + 1;
        }

        public String toString() {
            int n = 0;
            __cobertura_counters[30] = __cobertura_counters[30] + 1;
            StringBuilder sb = new StringBuilder();
            __cobertura_counters[31] = __cobertura_counters[31] + 1;
            sb.append("SynchronizedKeyedPoolableObjectFactory");
            __cobertura_counters[32] = __cobertura_counters[32] + 1;
            sb.append("{keyedFactory=").append(this.keyedFactory);
            __cobertura_counters[33] = __cobertura_counters[33] + 1;
            sb.append('}');
            __cobertura_counters[34] = __cobertura_counters[34] + 1;
            return sb.toString();
        }

        static {
            SynchronizedKeyedPooledObjectFactory.__cobertura_init();
        }

        public static void __cobertura_init() {
            if (__cobertura_counters == null) {
                __cobertura_counters = new int[35];
                TouchCollector.registerClass((String)"org/apache/commons/pool2/PoolUtils$SynchronizedKeyedPooledObjectFactory");
            }
        }

        public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.putLineTouchPoint(1225, 1, "<init>", "(Lorg/apache/commons/pool2/KeyedPooledObjectFactory;)V");
            lightClassmapListener2.putLineTouchPoint(1241, 2, "<init>", "(Lorg/apache/commons/pool2/KeyedPooledObjectFactory;)V");
            lightClassmapListener2.putLineTouchPoint(1242, 3, "<init>", "(Lorg/apache/commons/pool2/KeyedPooledObjectFactory;)V");
            lightClassmapListener2.putJumpTouchPoint(1242, 5, 4);
            lightClassmapListener2.putLineTouchPoint(1243, 6, "<init>", "(Lorg/apache/commons/pool2/KeyedPooledObjectFactory;)V");
            lightClassmapListener2.putLineTouchPoint(1246, 7, "<init>", "(Lorg/apache/commons/pool2/KeyedPooledObjectFactory;)V");
            lightClassmapListener2.putLineTouchPoint(1247, 8, "<init>", "(Lorg/apache/commons/pool2/KeyedPooledObjectFactory;)V");
            lightClassmapListener2.putLineTouchPoint(1254, 9, "makeObject", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
            lightClassmapListener2.putLineTouchPoint(1256, 10, "makeObject", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
            lightClassmapListener2.putLineTouchPoint(1258, 11, "makeObject", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/PooledObject;");
            lightClassmapListener2.putLineTouchPoint(1267, 12, "destroyObject", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1269, 13, "destroyObject", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1271, 14, "destroyObject", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1272, 15, "destroyObject", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1273, 16, "destroyObject", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1280, 17, "validateObject", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;)Z");
            lightClassmapListener2.putLineTouchPoint(1282, 18, "validateObject", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;)Z");
            lightClassmapListener2.putLineTouchPoint(1284, 19, "validateObject", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;)Z");
            lightClassmapListener2.putLineTouchPoint(1293, 20, "activateObject", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1295, 21, "activateObject", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1297, 22, "activateObject", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1298, 23, "activateObject", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1299, 24, "activateObject", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1306, 25, "passivateObject", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1308, 26, "passivateObject", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1310, 27, "passivateObject", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1311, 28, "passivateObject", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1312, 29, "passivateObject", "(Ljava/lang/Object;Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1319, 30, "toString", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(1320, 31, "toString", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(1321, 32, "toString", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(1322, 33, "toString", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(1323, 34, "toString", "()Ljava/lang/String;");
        }

        public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.setClazz("org/apache/commons/pool2/PoolUtils$SynchronizedKeyedPooledObjectFactory");
            lightClassmapListener2.setSource("PoolUtils.java");
            SynchronizedKeyedPooledObjectFactory.__cobertura_classmap_0(lightClassmapListener2);
        }

        public static int[] __cobertura_get_and_reset_counters() {
            int[] nArray = __cobertura_counters;
            __cobertura_counters = new int[__cobertura_counters.length];
            return nArray;
        }
    }

    private static class SynchronizedPooledObjectFactory<T>
    implements PooledObjectFactory<T> {
        public static final transient int[] __cobertura_counters;
        private final ReentrantReadWriteLock.WriteLock writeLock;
        private final PooledObjectFactory<T> factory;

        /*
         * WARNING - void declaration
         */
        SynchronizedPooledObjectFactory(PooledObjectFactory<T> pooledObjectFactory) throws IllegalArgumentException {
            void factory;
            int n = 0;
            __cobertura_counters[2] = __cobertura_counters[2] + 1;
            __cobertura_counters[1] = __cobertura_counters[1] + 1;
            this.writeLock = new ReentrantReadWriteLock().writeLock();
            __cobertura_counters[3] = __cobertura_counters[3] + 1;
            n = 5;
            if (factory == null) {
                __cobertura_counters[4] = __cobertura_counters[4] + 1;
                n = 0;
                __cobertura_counters[6] = __cobertura_counters[6] + 1;
                throw new IllegalArgumentException("factory must not be null.");
            }
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[7] = __cobertura_counters[7] + 1;
            this.factory = factory;
            __cobertura_counters[8] = __cobertura_counters[8] + 1;
        }

        @Override
        public PooledObject<T> makeObject() throws Exception {
            PooledObject<T> pooledObject;
            int n = 0;
            __cobertura_counters[9] = __cobertura_counters[9] + 1;
            this.writeLock.lock();
            try {
                __cobertura_counters[10] = __cobertura_counters[10] + 1;
                pooledObject = this.factory.makeObject();
            }
            catch (Throwable throwable) {
                this.writeLock.unlock();
                throw throwable;
            }
            __cobertura_counters[11] = __cobertura_counters[11] + 1;
            this.writeLock.unlock();
            return pooledObject;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void destroyObject(PooledObject<T> pooledObject) throws Exception {
            int n = 0;
            __cobertura_counters[12] = __cobertura_counters[12] + 1;
            this.writeLock.lock();
            try {
                void p;
                __cobertura_counters[13] = __cobertura_counters[13] + 1;
                this.factory.destroyObject((PooledObject<T>)p);
            }
            catch (Throwable throwable) {
                __cobertura_counters[14] = __cobertura_counters[14] + 1;
                Throwable throwable2 = throwable;
                this.writeLock.unlock();
                throw throwable2;
            }
            __cobertura_counters[14] = __cobertura_counters[14] + 1;
            this.writeLock.unlock();
            __cobertura_counters[15] = __cobertura_counters[15] + 1;
            __cobertura_counters[16] = __cobertura_counters[16] + 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean validateObject(PooledObject<T> pooledObject) {
            boolean bl;
            int n = 0;
            __cobertura_counters[17] = __cobertura_counters[17] + 1;
            this.writeLock.lock();
            try {
                void p;
                __cobertura_counters[18] = __cobertura_counters[18] + 1;
                bl = this.factory.validateObject((PooledObject<T>)p);
            }
            catch (Throwable throwable) {
                this.writeLock.unlock();
                throw throwable;
            }
            __cobertura_counters[19] = __cobertura_counters[19] + 1;
            this.writeLock.unlock();
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void activateObject(PooledObject<T> pooledObject) throws Exception {
            int n = 0;
            __cobertura_counters[20] = __cobertura_counters[20] + 1;
            this.writeLock.lock();
            try {
                void p;
                __cobertura_counters[21] = __cobertura_counters[21] + 1;
                this.factory.activateObject((PooledObject<T>)p);
            }
            catch (Throwable throwable) {
                __cobertura_counters[22] = __cobertura_counters[22] + 1;
                Throwable throwable2 = throwable;
                this.writeLock.unlock();
                throw throwable2;
            }
            __cobertura_counters[22] = __cobertura_counters[22] + 1;
            this.writeLock.unlock();
            __cobertura_counters[23] = __cobertura_counters[23] + 1;
            __cobertura_counters[24] = __cobertura_counters[24] + 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void passivateObject(PooledObject<T> pooledObject) throws Exception {
            int n = 0;
            __cobertura_counters[25] = __cobertura_counters[25] + 1;
            this.writeLock.lock();
            try {
                void p;
                __cobertura_counters[26] = __cobertura_counters[26] + 1;
                this.factory.passivateObject((PooledObject<T>)p);
            }
            catch (Throwable throwable) {
                __cobertura_counters[27] = __cobertura_counters[27] + 1;
                Throwable throwable2 = throwable;
                this.writeLock.unlock();
                throw throwable2;
            }
            __cobertura_counters[27] = __cobertura_counters[27] + 1;
            this.writeLock.unlock();
            __cobertura_counters[28] = __cobertura_counters[28] + 1;
            __cobertura_counters[29] = __cobertura_counters[29] + 1;
        }

        public String toString() {
            int n = 0;
            __cobertura_counters[30] = __cobertura_counters[30] + 1;
            StringBuilder sb = new StringBuilder();
            __cobertura_counters[31] = __cobertura_counters[31] + 1;
            sb.append("SynchronizedPoolableObjectFactory");
            __cobertura_counters[32] = __cobertura_counters[32] + 1;
            sb.append("{factory=").append(this.factory);
            __cobertura_counters[33] = __cobertura_counters[33] + 1;
            sb.append('}');
            __cobertura_counters[34] = __cobertura_counters[34] + 1;
            return sb.toString();
        }

        static {
            SynchronizedPooledObjectFactory.__cobertura_init();
        }

        public static void __cobertura_init() {
            if (__cobertura_counters == null) {
                __cobertura_counters = new int[35];
                TouchCollector.registerClass((String)"org/apache/commons/pool2/PoolUtils$SynchronizedPooledObjectFactory");
            }
        }

        public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.putLineTouchPoint(1112, 1, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;)V");
            lightClassmapListener2.putLineTouchPoint(1127, 2, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;)V");
            lightClassmapListener2.putLineTouchPoint(1128, 3, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;)V");
            lightClassmapListener2.putJumpTouchPoint(1128, 5, 4);
            lightClassmapListener2.putLineTouchPoint(1129, 6, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;)V");
            lightClassmapListener2.putLineTouchPoint(1131, 7, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;)V");
            lightClassmapListener2.putLineTouchPoint(1132, 8, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;)V");
            lightClassmapListener2.putLineTouchPoint(1139, 9, "makeObject", "()Lorg/apache/commons/pool2/PooledObject;");
            lightClassmapListener2.putLineTouchPoint(1141, 10, "makeObject", "()Lorg/apache/commons/pool2/PooledObject;");
            lightClassmapListener2.putLineTouchPoint(1143, 11, "makeObject", "()Lorg/apache/commons/pool2/PooledObject;");
            lightClassmapListener2.putLineTouchPoint(1152, 12, "destroyObject", "(Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1154, 13, "destroyObject", "(Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1156, 14, "destroyObject", "(Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1157, 15, "destroyObject", "(Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1158, 16, "destroyObject", "(Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1165, 17, "validateObject", "(Lorg/apache/commons/pool2/PooledObject;)Z");
            lightClassmapListener2.putLineTouchPoint(1167, 18, "validateObject", "(Lorg/apache/commons/pool2/PooledObject;)Z");
            lightClassmapListener2.putLineTouchPoint(1169, 19, "validateObject", "(Lorg/apache/commons/pool2/PooledObject;)Z");
            lightClassmapListener2.putLineTouchPoint(1178, 20, "activateObject", "(Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1180, 21, "activateObject", "(Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1182, 22, "activateObject", "(Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1183, 23, "activateObject", "(Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1184, 24, "activateObject", "(Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1191, 25, "passivateObject", "(Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1193, 26, "passivateObject", "(Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1195, 27, "passivateObject", "(Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1196, 28, "passivateObject", "(Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1197, 29, "passivateObject", "(Lorg/apache/commons/pool2/PooledObject;)V");
            lightClassmapListener2.putLineTouchPoint(1204, 30, "toString", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(1205, 31, "toString", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(1206, 32, "toString", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(1207, 33, "toString", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(1208, 34, "toString", "()Ljava/lang/String;");
        }

        public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.setClazz("org/apache/commons/pool2/PoolUtils$SynchronizedPooledObjectFactory");
            lightClassmapListener2.setSource("PoolUtils.java");
            SynchronizedPooledObjectFactory.__cobertura_classmap_0(lightClassmapListener2);
        }

        public static int[] __cobertura_get_and_reset_counters() {
            int[] nArray = __cobertura_counters;
            __cobertura_counters = new int[__cobertura_counters.length];
            return nArray;
        }
    }

    private static class SynchronizedKeyedObjectPool<K, V>
    implements KeyedObjectPool<K, V> {
        public static final transient int[] __cobertura_counters;
        private final ReentrantReadWriteLock readWriteLock;
        private final KeyedObjectPool<K, V> keyedPool;

        /*
         * WARNING - void declaration
         */
        SynchronizedKeyedObjectPool(KeyedObjectPool<K, V> keyedObjectPool) throws IllegalArgumentException {
            void keyedPool;
            int n = 0;
            __cobertura_counters[2] = __cobertura_counters[2] + 1;
            __cobertura_counters[1] = __cobertura_counters[1] + 1;
            this.readWriteLock = new ReentrantReadWriteLock();
            __cobertura_counters[3] = __cobertura_counters[3] + 1;
            n = 5;
            if (keyedPool == null) {
                __cobertura_counters[4] = __cobertura_counters[4] + 1;
                n = 0;
                __cobertura_counters[6] = __cobertura_counters[6] + 1;
                throw new IllegalArgumentException("keyedPool must not be null.");
            }
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[7] = __cobertura_counters[7] + 1;
            this.keyedPool = keyedPool;
            __cobertura_counters[8] = __cobertura_counters[8] + 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public V borrowObject(K k) throws Exception, NoSuchElementException, IllegalStateException {
            V v;
            int n = 0;
            __cobertura_counters[9] = __cobertura_counters[9] + 1;
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            __cobertura_counters[10] = __cobertura_counters[10] + 1;
            writeLock.lock();
            try {
                void key;
                __cobertura_counters[11] = __cobertura_counters[11] + 1;
                v = this.keyedPool.borrowObject(key);
            }
            catch (Throwable throwable) {
                writeLock.unlock();
                throw throwable;
            }
            __cobertura_counters[12] = __cobertura_counters[12] + 1;
            writeLock.unlock();
            return v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void returnObject(K k, V v) {
            int n = 0;
            __cobertura_counters[13] = __cobertura_counters[13] + 1;
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            __cobertura_counters[14] = __cobertura_counters[14] + 1;
            writeLock.lock();
            try {
                void obj;
                void key;
                __cobertura_counters[15] = __cobertura_counters[15] + 1;
                this.keyedPool.returnObject(key, obj);
            }
            catch (Exception exception) {
                try {
                    __cobertura_counters[16] = __cobertura_counters[16] + 1;
                    Exception exception2 = exception;
                }
                catch (Throwable throwable) {
                    __cobertura_counters[17] = __cobertura_counters[17] + 1;
                    Throwable throwable2 = throwable;
                    writeLock.unlock();
                    throw throwable2;
                }
                __cobertura_counters[17] = __cobertura_counters[17] + 1;
                writeLock.unlock();
                __cobertura_counters[19] = __cobertura_counters[19] + 1;
            }
            __cobertura_counters[17] = __cobertura_counters[17] + 1;
            writeLock.unlock();
            __cobertura_counters[18] = __cobertura_counters[18] + 1;
            __cobertura_counters[20] = __cobertura_counters[20] + 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void invalidateObject(K k, V v) {
            int n = 0;
            __cobertura_counters[21] = __cobertura_counters[21] + 1;
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            __cobertura_counters[22] = __cobertura_counters[22] + 1;
            writeLock.lock();
            try {
                void obj;
                void key;
                __cobertura_counters[23] = __cobertura_counters[23] + 1;
                this.keyedPool.invalidateObject(key, obj);
            }
            catch (Exception exception) {
                try {
                    __cobertura_counters[24] = __cobertura_counters[24] + 1;
                    Exception exception2 = exception;
                }
                catch (Throwable throwable) {
                    __cobertura_counters[25] = __cobertura_counters[25] + 1;
                    Throwable throwable2 = throwable;
                    writeLock.unlock();
                    throw throwable2;
                }
                __cobertura_counters[25] = __cobertura_counters[25] + 1;
                writeLock.unlock();
                __cobertura_counters[27] = __cobertura_counters[27] + 1;
            }
            __cobertura_counters[25] = __cobertura_counters[25] + 1;
            writeLock.unlock();
            __cobertura_counters[26] = __cobertura_counters[26] + 1;
            __cobertura_counters[28] = __cobertura_counters[28] + 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void addObject(K k) throws Exception, IllegalStateException, UnsupportedOperationException {
            int n = 0;
            __cobertura_counters[29] = __cobertura_counters[29] + 1;
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            __cobertura_counters[30] = __cobertura_counters[30] + 1;
            writeLock.lock();
            try {
                void key;
                __cobertura_counters[31] = __cobertura_counters[31] + 1;
                this.keyedPool.addObject(key);
            }
            catch (Throwable throwable) {
                __cobertura_counters[32] = __cobertura_counters[32] + 1;
                Throwable throwable2 = throwable;
                writeLock.unlock();
                throw throwable2;
            }
            __cobertura_counters[32] = __cobertura_counters[32] + 1;
            writeLock.unlock();
            __cobertura_counters[33] = __cobertura_counters[33] + 1;
            __cobertura_counters[34] = __cobertura_counters[34] + 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public int getNumIdle(K k) {
            int n;
            int n2 = 0;
            __cobertura_counters[35] = __cobertura_counters[35] + 1;
            ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
            __cobertura_counters[36] = __cobertura_counters[36] + 1;
            readLock.lock();
            try {
                void key;
                __cobertura_counters[37] = __cobertura_counters[37] + 1;
                n = this.keyedPool.getNumIdle(key);
            }
            catch (Throwable throwable) {
                readLock.unlock();
                throw throwable;
            }
            __cobertura_counters[38] = __cobertura_counters[38] + 1;
            readLock.unlock();
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public int getNumActive(K k) {
            int n;
            int n2 = 0;
            __cobertura_counters[39] = __cobertura_counters[39] + 1;
            ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
            __cobertura_counters[40] = __cobertura_counters[40] + 1;
            readLock.lock();
            try {
                void key;
                __cobertura_counters[41] = __cobertura_counters[41] + 1;
                n = this.keyedPool.getNumActive(key);
            }
            catch (Throwable throwable) {
                readLock.unlock();
                throw throwable;
            }
            __cobertura_counters[42] = __cobertura_counters[42] + 1;
            readLock.unlock();
            return n;
        }

        @Override
        public int getNumIdle() {
            int n;
            int n2 = 0;
            __cobertura_counters[43] = __cobertura_counters[43] + 1;
            ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
            __cobertura_counters[44] = __cobertura_counters[44] + 1;
            readLock.lock();
            try {
                __cobertura_counters[45] = __cobertura_counters[45] + 1;
                n = this.keyedPool.getNumIdle();
            }
            catch (Throwable throwable) {
                readLock.unlock();
                throw throwable;
            }
            __cobertura_counters[46] = __cobertura_counters[46] + 1;
            readLock.unlock();
            return n;
        }

        @Override
        public int getNumActive() {
            int n;
            int n2 = 0;
            __cobertura_counters[47] = __cobertura_counters[47] + 1;
            ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
            __cobertura_counters[48] = __cobertura_counters[48] + 1;
            readLock.lock();
            try {
                __cobertura_counters[49] = __cobertura_counters[49] + 1;
                n = this.keyedPool.getNumActive();
            }
            catch (Throwable throwable) {
                readLock.unlock();
                throw throwable;
            }
            __cobertura_counters[50] = __cobertura_counters[50] + 1;
            readLock.unlock();
            return n;
        }

        @Override
        public void clear() throws Exception, UnsupportedOperationException {
            int n = 0;
            __cobertura_counters[51] = __cobertura_counters[51] + 1;
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            __cobertura_counters[52] = __cobertura_counters[52] + 1;
            writeLock.lock();
            try {
                __cobertura_counters[53] = __cobertura_counters[53] + 1;
                this.keyedPool.clear();
            }
            catch (Throwable throwable) {
                __cobertura_counters[54] = __cobertura_counters[54] + 1;
                Throwable throwable2 = throwable;
                writeLock.unlock();
                throw throwable2;
            }
            __cobertura_counters[54] = __cobertura_counters[54] + 1;
            writeLock.unlock();
            __cobertura_counters[55] = __cobertura_counters[55] + 1;
            __cobertura_counters[56] = __cobertura_counters[56] + 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void clear(K k) throws Exception, UnsupportedOperationException {
            int n = 0;
            __cobertura_counters[57] = __cobertura_counters[57] + 1;
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            __cobertura_counters[58] = __cobertura_counters[58] + 1;
            writeLock.lock();
            try {
                void key;
                __cobertura_counters[59] = __cobertura_counters[59] + 1;
                this.keyedPool.clear(key);
            }
            catch (Throwable throwable) {
                __cobertura_counters[60] = __cobertura_counters[60] + 1;
                Throwable throwable2 = throwable;
                writeLock.unlock();
                throw throwable2;
            }
            __cobertura_counters[60] = __cobertura_counters[60] + 1;
            writeLock.unlock();
            __cobertura_counters[61] = __cobertura_counters[61] + 1;
            __cobertura_counters[62] = __cobertura_counters[62] + 1;
        }

        @Override
        public void close() {
            int n = 0;
            __cobertura_counters[63] = __cobertura_counters[63] + 1;
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            __cobertura_counters[64] = __cobertura_counters[64] + 1;
            writeLock.lock();
            try {
                __cobertura_counters[65] = __cobertura_counters[65] + 1;
                this.keyedPool.close();
            }
            catch (Exception exception) {
                __cobertura_counters[66] = __cobertura_counters[66] + 1;
                Exception exception2 = exception;
                __cobertura_counters[67] = __cobertura_counters[67] + 1;
                writeLock.unlock();
                __cobertura_counters[69] = __cobertura_counters[69] + 1;
            }
            catch (Throwable throwable) {
                __cobertura_counters[67] = __cobertura_counters[67] + 1;
                Throwable throwable2 = throwable;
                writeLock.unlock();
                throw throwable2;
            }
            __cobertura_counters[67] = __cobertura_counters[67] + 1;
            writeLock.unlock();
            __cobertura_counters[68] = __cobertura_counters[68] + 1;
            __cobertura_counters[70] = __cobertura_counters[70] + 1;
        }

        public String toString() {
            int n = 0;
            __cobertura_counters[71] = __cobertura_counters[71] + 1;
            StringBuilder sb = new StringBuilder();
            __cobertura_counters[72] = __cobertura_counters[72] + 1;
            sb.append("SynchronizedKeyedObjectPool");
            __cobertura_counters[73] = __cobertura_counters[73] + 1;
            sb.append("{keyedPool=").append(this.keyedPool);
            __cobertura_counters[74] = __cobertura_counters[74] + 1;
            sb.append('}');
            __cobertura_counters[75] = __cobertura_counters[75] + 1;
            return sb.toString();
        }

        static {
            SynchronizedKeyedObjectPool.__cobertura_init();
        }

        public static void __cobertura_init() {
            if (__cobertura_counters == null) {
                __cobertura_counters = new int[76];
                TouchCollector.registerClass((String)"org/apache/commons/pool2/PoolUtils$SynchronizedKeyedObjectPool");
            }
        }

        public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.putLineTouchPoint(901, 1, "<init>", "(Lorg/apache/commons/pool2/KeyedObjectPool;)V");
            lightClassmapListener2.putLineTouchPoint(915, 2, "<init>", "(Lorg/apache/commons/pool2/KeyedObjectPool;)V");
            lightClassmapListener2.putLineTouchPoint(916, 3, "<init>", "(Lorg/apache/commons/pool2/KeyedObjectPool;)V");
            lightClassmapListener2.putJumpTouchPoint(916, 5, 4);
            lightClassmapListener2.putLineTouchPoint(917, 6, "<init>", "(Lorg/apache/commons/pool2/KeyedObjectPool;)V");
            lightClassmapListener2.putLineTouchPoint(920, 7, "<init>", "(Lorg/apache/commons/pool2/KeyedObjectPool;)V");
            lightClassmapListener2.putLineTouchPoint(921, 8, "<init>", "(Lorg/apache/commons/pool2/KeyedObjectPool;)V");
            lightClassmapListener2.putLineTouchPoint(929, 9, "borrowObject", "(Ljava/lang/Object;)Ljava/lang/Object;");
            lightClassmapListener2.putLineTouchPoint(930, 10, "borrowObject", "(Ljava/lang/Object;)Ljava/lang/Object;");
            lightClassmapListener2.putLineTouchPoint(932, 11, "borrowObject", "(Ljava/lang/Object;)Ljava/lang/Object;");
            lightClassmapListener2.putLineTouchPoint(934, 12, "borrowObject", "(Ljava/lang/Object;)Ljava/lang/Object;");
            lightClassmapListener2.putLineTouchPoint(943, 13, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(944, 14, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(946, 15, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(947, 16, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(950, 17, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(951, 18, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(951, 19, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(952, 20, "returnObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(959, 21, "invalidateObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(960, 22, "invalidateObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(962, 23, "invalidateObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(963, 24, "invalidateObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(966, 25, "invalidateObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(967, 26, "invalidateObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(967, 27, "invalidateObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(968, 28, "invalidateObject", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(976, 29, "addObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(977, 30, "addObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(979, 31, "addObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(981, 32, "addObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(982, 33, "addObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(983, 34, "addObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(990, 35, "getNumIdle", "(Ljava/lang/Object;)I");
            lightClassmapListener2.putLineTouchPoint(991, 36, "getNumIdle", "(Ljava/lang/Object;)I");
            lightClassmapListener2.putLineTouchPoint(993, 37, "getNumIdle", "(Ljava/lang/Object;)I");
            lightClassmapListener2.putLineTouchPoint(995, 38, "getNumIdle", "(Ljava/lang/Object;)I");
            lightClassmapListener2.putLineTouchPoint(1004, 39, "getNumActive", "(Ljava/lang/Object;)I");
            lightClassmapListener2.putLineTouchPoint(1005, 40, "getNumActive", "(Ljava/lang/Object;)I");
            lightClassmapListener2.putLineTouchPoint(1007, 41, "getNumActive", "(Ljava/lang/Object;)I");
            lightClassmapListener2.putLineTouchPoint(1009, 42, "getNumActive", "(Ljava/lang/Object;)I");
            lightClassmapListener2.putLineTouchPoint(1018, 43, "getNumIdle", "()I");
            lightClassmapListener2.putLineTouchPoint(1019, 44, "getNumIdle", "()I");
            lightClassmapListener2.putLineTouchPoint(1021, 45, "getNumIdle", "()I");
            lightClassmapListener2.putLineTouchPoint(1023, 46, "getNumIdle", "()I");
            lightClassmapListener2.putLineTouchPoint(1032, 47, "getNumActive", "()I");
            lightClassmapListener2.putLineTouchPoint(1033, 48, "getNumActive", "()I");
            lightClassmapListener2.putLineTouchPoint(1035, 49, "getNumActive", "()I");
            lightClassmapListener2.putLineTouchPoint(1037, 50, "getNumActive", "()I");
            lightClassmapListener2.putLineTouchPoint(1046, 51, "clear", "()V");
            lightClassmapListener2.putLineTouchPoint(1047, 52, "clear", "()V");
            lightClassmapListener2.putLineTouchPoint(1049, 53, "clear", "()V");
            lightClassmapListener2.putLineTouchPoint(1051, 54, "clear", "()V");
            lightClassmapListener2.putLineTouchPoint(1052, 55, "clear", "()V");
            lightClassmapListener2.putLineTouchPoint(1053, 56, "clear", "()V");
            lightClassmapListener2.putLineTouchPoint(1061, 57, "clear", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1062, 58, "clear", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1064, 59, "clear", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1066, 60, "clear", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1067, 61, "clear", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1068, 62, "clear", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1075, 63, "close", "()V");
            lightClassmapListener2.putLineTouchPoint(1076, 64, "close", "()V");
            lightClassmapListener2.putLineTouchPoint(1078, 65, "close", "()V");
            lightClassmapListener2.putLineTouchPoint(1079, 66, "close", "()V");
            lightClassmapListener2.putLineTouchPoint(1082, 67, "close", "()V");
            lightClassmapListener2.putLineTouchPoint(1083, 68, "close", "()V");
            lightClassmapListener2.putLineTouchPoint(1083, 69, "close", "()V");
            lightClassmapListener2.putLineTouchPoint(1084, 70, "close", "()V");
            lightClassmapListener2.putLineTouchPoint(1091, 71, "toString", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(1092, 72, "toString", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(1093, 73, "toString", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(1094, 74, "toString", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(1095, 75, "toString", "()Ljava/lang/String;");
        }

        public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.setClazz("org/apache/commons/pool2/PoolUtils$SynchronizedKeyedObjectPool");
            lightClassmapListener2.setSource("PoolUtils.java");
            SynchronizedKeyedObjectPool.__cobertura_classmap_0(lightClassmapListener2);
        }

        public static int[] __cobertura_get_and_reset_counters() {
            int[] nArray = __cobertura_counters;
            __cobertura_counters = new int[__cobertura_counters.length];
            return nArray;
        }
    }

    private static class SynchronizedObjectPool<T>
    implements ObjectPool<T> {
        public static final transient int[] __cobertura_counters;
        private final ReentrantReadWriteLock readWriteLock;
        private final ObjectPool<T> pool;

        /*
         * WARNING - void declaration
         */
        SynchronizedObjectPool(ObjectPool<T> objectPool) throws IllegalArgumentException {
            void pool;
            int n = 0;
            __cobertura_counters[2] = __cobertura_counters[2] + 1;
            __cobertura_counters[1] = __cobertura_counters[1] + 1;
            this.readWriteLock = new ReentrantReadWriteLock();
            __cobertura_counters[3] = __cobertura_counters[3] + 1;
            n = 5;
            if (pool == null) {
                __cobertura_counters[4] = __cobertura_counters[4] + 1;
                n = 0;
                __cobertura_counters[6] = __cobertura_counters[6] + 1;
                throw new IllegalArgumentException("pool must not be null.");
            }
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[7] = __cobertura_counters[7] + 1;
            this.pool = pool;
            __cobertura_counters[8] = __cobertura_counters[8] + 1;
        }

        @Override
        public T borrowObject() throws Exception, NoSuchElementException, IllegalStateException {
            T t;
            int n = 0;
            __cobertura_counters[9] = __cobertura_counters[9] + 1;
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            __cobertura_counters[10] = __cobertura_counters[10] + 1;
            writeLock.lock();
            try {
                __cobertura_counters[11] = __cobertura_counters[11] + 1;
                t = this.pool.borrowObject();
            }
            catch (Throwable throwable) {
                writeLock.unlock();
                throw throwable;
            }
            __cobertura_counters[12] = __cobertura_counters[12] + 1;
            writeLock.unlock();
            return t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void returnObject(T t) {
            int n = 0;
            __cobertura_counters[13] = __cobertura_counters[13] + 1;
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            __cobertura_counters[14] = __cobertura_counters[14] + 1;
            writeLock.lock();
            try {
                void obj;
                __cobertura_counters[15] = __cobertura_counters[15] + 1;
                this.pool.returnObject(obj);
            }
            catch (Exception exception) {
                __cobertura_counters[16] = __cobertura_counters[16] + 1;
                Exception exception2 = exception;
                __cobertura_counters[17] = __cobertura_counters[17] + 1;
                writeLock.unlock();
                __cobertura_counters[19] = __cobertura_counters[19] + 1;
            }
            catch (Throwable throwable) {
                __cobertura_counters[17] = __cobertura_counters[17] + 1;
                Throwable throwable2 = throwable;
                writeLock.unlock();
                throw throwable2;
            }
            __cobertura_counters[17] = __cobertura_counters[17] + 1;
            writeLock.unlock();
            __cobertura_counters[18] = __cobertura_counters[18] + 1;
            __cobertura_counters[20] = __cobertura_counters[20] + 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void invalidateObject(T t) {
            int n = 0;
            __cobertura_counters[21] = __cobertura_counters[21] + 1;
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            __cobertura_counters[22] = __cobertura_counters[22] + 1;
            writeLock.lock();
            try {
                void obj;
                __cobertura_counters[23] = __cobertura_counters[23] + 1;
                this.pool.invalidateObject(obj);
            }
            catch (Exception exception) {
                __cobertura_counters[24] = __cobertura_counters[24] + 1;
                Exception exception2 = exception;
                __cobertura_counters[25] = __cobertura_counters[25] + 1;
                writeLock.unlock();
                __cobertura_counters[27] = __cobertura_counters[27] + 1;
            }
            catch (Throwable throwable) {
                __cobertura_counters[25] = __cobertura_counters[25] + 1;
                Throwable throwable2 = throwable;
                writeLock.unlock();
                throw throwable2;
            }
            __cobertura_counters[25] = __cobertura_counters[25] + 1;
            writeLock.unlock();
            __cobertura_counters[26] = __cobertura_counters[26] + 1;
            __cobertura_counters[28] = __cobertura_counters[28] + 1;
        }

        @Override
        public void addObject() throws Exception, IllegalStateException, UnsupportedOperationException {
            int n = 0;
            __cobertura_counters[29] = __cobertura_counters[29] + 1;
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            __cobertura_counters[30] = __cobertura_counters[30] + 1;
            writeLock.lock();
            try {
                __cobertura_counters[31] = __cobertura_counters[31] + 1;
                this.pool.addObject();
            }
            catch (Throwable throwable) {
                __cobertura_counters[32] = __cobertura_counters[32] + 1;
                Throwable throwable2 = throwable;
                writeLock.unlock();
                throw throwable2;
            }
            __cobertura_counters[32] = __cobertura_counters[32] + 1;
            writeLock.unlock();
            __cobertura_counters[33] = __cobertura_counters[33] + 1;
            __cobertura_counters[34] = __cobertura_counters[34] + 1;
        }

        @Override
        public int getNumIdle() {
            int n;
            int n2 = 0;
            __cobertura_counters[35] = __cobertura_counters[35] + 1;
            ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
            __cobertura_counters[36] = __cobertura_counters[36] + 1;
            readLock.lock();
            try {
                __cobertura_counters[37] = __cobertura_counters[37] + 1;
                n = this.pool.getNumIdle();
            }
            catch (Throwable throwable) {
                readLock.unlock();
                throw throwable;
            }
            __cobertura_counters[38] = __cobertura_counters[38] + 1;
            readLock.unlock();
            return n;
        }

        @Override
        public int getNumActive() {
            int n;
            int n2 = 0;
            __cobertura_counters[39] = __cobertura_counters[39] + 1;
            ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
            __cobertura_counters[40] = __cobertura_counters[40] + 1;
            readLock.lock();
            try {
                __cobertura_counters[41] = __cobertura_counters[41] + 1;
                n = this.pool.getNumActive();
            }
            catch (Throwable throwable) {
                readLock.unlock();
                throw throwable;
            }
            __cobertura_counters[42] = __cobertura_counters[42] + 1;
            readLock.unlock();
            return n;
        }

        @Override
        public void clear() throws Exception, UnsupportedOperationException {
            int n = 0;
            __cobertura_counters[43] = __cobertura_counters[43] + 1;
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            __cobertura_counters[44] = __cobertura_counters[44] + 1;
            writeLock.lock();
            try {
                __cobertura_counters[45] = __cobertura_counters[45] + 1;
                this.pool.clear();
            }
            catch (Throwable throwable) {
                __cobertura_counters[46] = __cobertura_counters[46] + 1;
                Throwable throwable2 = throwable;
                writeLock.unlock();
                throw throwable2;
            }
            __cobertura_counters[46] = __cobertura_counters[46] + 1;
            writeLock.unlock();
            __cobertura_counters[47] = __cobertura_counters[47] + 1;
            __cobertura_counters[48] = __cobertura_counters[48] + 1;
        }

        @Override
        public void close() {
            int n = 0;
            __cobertura_counters[49] = __cobertura_counters[49] + 1;
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            __cobertura_counters[50] = __cobertura_counters[50] + 1;
            writeLock.lock();
            try {
                __cobertura_counters[51] = __cobertura_counters[51] + 1;
                this.pool.close();
            }
            catch (Exception exception) {
                __cobertura_counters[52] = __cobertura_counters[52] + 1;
                Exception exception2 = exception;
                __cobertura_counters[53] = __cobertura_counters[53] + 1;
                writeLock.unlock();
                __cobertura_counters[55] = __cobertura_counters[55] + 1;
            }
            catch (Throwable throwable) {
                __cobertura_counters[53] = __cobertura_counters[53] + 1;
                Throwable throwable2 = throwable;
                writeLock.unlock();
                throw throwable2;
            }
            __cobertura_counters[53] = __cobertura_counters[53] + 1;
            writeLock.unlock();
            __cobertura_counters[54] = __cobertura_counters[54] + 1;
            __cobertura_counters[56] = __cobertura_counters[56] + 1;
        }

        public String toString() {
            int n = 0;
            __cobertura_counters[57] = __cobertura_counters[57] + 1;
            StringBuilder sb = new StringBuilder();
            __cobertura_counters[58] = __cobertura_counters[58] + 1;
            sb.append("SynchronizedObjectPool");
            __cobertura_counters[59] = __cobertura_counters[59] + 1;
            sb.append("{pool=").append(this.pool);
            __cobertura_counters[60] = __cobertura_counters[60] + 1;
            sb.append('}');
            __cobertura_counters[61] = __cobertura_counters[61] + 1;
            return sb.toString();
        }

        static {
            SynchronizedObjectPool.__cobertura_init();
        }

        public static void __cobertura_init() {
            if (__cobertura_counters == null) {
                __cobertura_counters = new int[62];
                TouchCollector.registerClass((String)"org/apache/commons/pool2/PoolUtils$SynchronizedObjectPool");
            }
        }

        public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.putLineTouchPoint(727, 1, "<init>", "(Lorg/apache/commons/pool2/ObjectPool;)V");
            lightClassmapListener2.putLineTouchPoint(742, 2, "<init>", "(Lorg/apache/commons/pool2/ObjectPool;)V");
            lightClassmapListener2.putLineTouchPoint(743, 3, "<init>", "(Lorg/apache/commons/pool2/ObjectPool;)V");
            lightClassmapListener2.putJumpTouchPoint(743, 5, 4);
            lightClassmapListener2.putLineTouchPoint(744, 6, "<init>", "(Lorg/apache/commons/pool2/ObjectPool;)V");
            lightClassmapListener2.putLineTouchPoint(746, 7, "<init>", "(Lorg/apache/commons/pool2/ObjectPool;)V");
            lightClassmapListener2.putLineTouchPoint(747, 8, "<init>", "(Lorg/apache/commons/pool2/ObjectPool;)V");
            lightClassmapListener2.putLineTouchPoint(755, 9, "borrowObject", "()Ljava/lang/Object;");
            lightClassmapListener2.putLineTouchPoint(756, 10, "borrowObject", "()Ljava/lang/Object;");
            lightClassmapListener2.putLineTouchPoint(758, 11, "borrowObject", "()Ljava/lang/Object;");
            lightClassmapListener2.putLineTouchPoint(760, 12, "borrowObject", "()Ljava/lang/Object;");
            lightClassmapListener2.putLineTouchPoint(769, 13, "returnObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(770, 14, "returnObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(772, 15, "returnObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(773, 16, "returnObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(776, 17, "returnObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(777, 18, "returnObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(777, 19, "returnObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(778, 20, "returnObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(785, 21, "invalidateObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(786, 22, "invalidateObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(788, 23, "invalidateObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(789, 24, "invalidateObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(792, 25, "invalidateObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(793, 26, "invalidateObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(793, 27, "invalidateObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(794, 28, "invalidateObject", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(802, 29, "addObject", "()V");
            lightClassmapListener2.putLineTouchPoint(803, 30, "addObject", "()V");
            lightClassmapListener2.putLineTouchPoint(805, 31, "addObject", "()V");
            lightClassmapListener2.putLineTouchPoint(807, 32, "addObject", "()V");
            lightClassmapListener2.putLineTouchPoint(808, 33, "addObject", "()V");
            lightClassmapListener2.putLineTouchPoint(809, 34, "addObject", "()V");
            lightClassmapListener2.putLineTouchPoint(816, 35, "getNumIdle", "()I");
            lightClassmapListener2.putLineTouchPoint(817, 36, "getNumIdle", "()I");
            lightClassmapListener2.putLineTouchPoint(819, 37, "getNumIdle", "()I");
            lightClassmapListener2.putLineTouchPoint(821, 38, "getNumIdle", "()I");
            lightClassmapListener2.putLineTouchPoint(830, 39, "getNumActive", "()I");
            lightClassmapListener2.putLineTouchPoint(831, 40, "getNumActive", "()I");
            lightClassmapListener2.putLineTouchPoint(833, 41, "getNumActive", "()I");
            lightClassmapListener2.putLineTouchPoint(835, 42, "getNumActive", "()I");
            lightClassmapListener2.putLineTouchPoint(844, 43, "clear", "()V");
            lightClassmapListener2.putLineTouchPoint(845, 44, "clear", "()V");
            lightClassmapListener2.putLineTouchPoint(847, 45, "clear", "()V");
            lightClassmapListener2.putLineTouchPoint(849, 46, "clear", "()V");
            lightClassmapListener2.putLineTouchPoint(850, 47, "clear", "()V");
            lightClassmapListener2.putLineTouchPoint(851, 48, "clear", "()V");
            lightClassmapListener2.putLineTouchPoint(858, 49, "close", "()V");
            lightClassmapListener2.putLineTouchPoint(859, 50, "close", "()V");
            lightClassmapListener2.putLineTouchPoint(861, 51, "close", "()V");
            lightClassmapListener2.putLineTouchPoint(862, 52, "close", "()V");
            lightClassmapListener2.putLineTouchPoint(865, 53, "close", "()V");
            lightClassmapListener2.putLineTouchPoint(866, 54, "close", "()V");
            lightClassmapListener2.putLineTouchPoint(866, 55, "close", "()V");
            lightClassmapListener2.putLineTouchPoint(867, 56, "close", "()V");
            lightClassmapListener2.putLineTouchPoint(874, 57, "toString", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(875, 58, "toString", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(876, 59, "toString", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(877, 60, "toString", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(878, 61, "toString", "()Ljava/lang/String;");
        }

        public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.setClazz("org/apache/commons/pool2/PoolUtils$SynchronizedObjectPool");
            lightClassmapListener2.setSource("PoolUtils.java");
            SynchronizedObjectPool.__cobertura_classmap_0(lightClassmapListener2);
        }

        public static int[] __cobertura_get_and_reset_counters() {
            int[] nArray = __cobertura_counters;
            __cobertura_counters = new int[__cobertura_counters.length];
            return nArray;
        }
    }

    private static class KeyedObjectPoolMinIdleTimerTask<K, V>
    extends TimerTask {
        public static final transient int[] __cobertura_counters;
        private final int minIdle;
        private final K key;
        private final KeyedObjectPool<K, V> keyedPool;

        /*
         * WARNING - void declaration
         */
        KeyedObjectPoolMinIdleTimerTask(KeyedObjectPool<K, V> keyedObjectPool, K k, int n) throws IllegalArgumentException {
            void minIdle;
            void key;
            void keyedPool;
            int n2 = 0;
            __cobertura_counters[1] = __cobertura_counters[1] + 1;
            __cobertura_counters[2] = __cobertura_counters[2] + 1;
            n2 = 4;
            if (keyedPool == null) {
                __cobertura_counters[3] = __cobertura_counters[3] + 1;
                n2 = 0;
                __cobertura_counters[5] = __cobertura_counters[5] + 1;
                throw new IllegalArgumentException("keyedPool must not be null.");
            }
            int n3 = n2;
            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
            n2 = 0;
            __cobertura_counters[6] = __cobertura_counters[6] + 1;
            this.keyedPool = keyedPool;
            __cobertura_counters[7] = __cobertura_counters[7] + 1;
            this.key = key;
            __cobertura_counters[8] = __cobertura_counters[8] + 1;
            this.minIdle = minIdle;
            __cobertura_counters[9] = __cobertura_counters[9] + 1;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            var1_1 = 0;
            KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[10] = KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[10] + 1;
            success = false;
            try {
                KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[11] = KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[11] + 1;
                var1_1 = 13;
                if (this.keyedPool.getNumIdle(this.key) < this.minIdle) {
                    KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[12] = KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[12] + 1;
                    var1_1 = 0;
                    KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[14] = KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[14] + 1;
                    this.keyedPool.addObject(this.key);
                }
                v0 = var1_1;
                KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[v0] = KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[v0] + 1;
                var1_1 = 0;
                KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[15] = KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[15] + 1;
                success = true;
            }
            catch (Exception v1) {
                try {
                    KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[16] = KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[16] + 1;
                    e = v1;
                    KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[17] = KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[17] + 1;
                    this.cancel();
                }
                catch (Throwable v2) {
                    KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[18] = KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[18] + 1;
                    var4_4 = v2;
                    var1_1 = 20;
                    if (!success) {
                        KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[19] = KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[19] + 1;
                        var1_1 = 0;
                        KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[21] = KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[21] + 1;
                        this.cancel();
                    }
                    throw var4_4;
                }
                KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[18] = KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[18] + 1;
                var1_1 = 20;
                if (!success) {
                    KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[19] = KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[19] + 1;
                    var1_1 = 0;
                    KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[21] = KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[21] + 1;
                    this.cancel();
                } else {
                    ** GOTO lbl53
                }
            }
            KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[18] = KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[18] + 1;
            var1_1 = 20;
            if (!success) {
                KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[19] = KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[19] + 1;
                var1_1 = 0;
                KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[21] = KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[21] + 1;
                this.cancel();
            }
            v3 = var1_1;
            KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[v3] = KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[v3] + 1;
            var1_1 = 0;
            KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[22] = KeyedObjectPoolMinIdleTimerTask.__cobertura_counters[22] + 1;
        }

        public String toString() {
            int n = 0;
            __cobertura_counters[23] = __cobertura_counters[23] + 1;
            StringBuilder sb = new StringBuilder();
            __cobertura_counters[24] = __cobertura_counters[24] + 1;
            sb.append("KeyedObjectPoolMinIdleTimerTask");
            __cobertura_counters[25] = __cobertura_counters[25] + 1;
            sb.append("{minIdle=").append(this.minIdle);
            __cobertura_counters[26] = __cobertura_counters[26] + 1;
            sb.append(", key=").append(this.key);
            __cobertura_counters[27] = __cobertura_counters[27] + 1;
            sb.append(", keyedPool=").append(this.keyedPool);
            __cobertura_counters[28] = __cobertura_counters[28] + 1;
            sb.append('}');
            __cobertura_counters[29] = __cobertura_counters[29] + 1;
            return sb.toString();
        }

        static {
            KeyedObjectPoolMinIdleTimerTask.__cobertura_init();
        }

        public static void __cobertura_init() {
            if (__cobertura_counters == null) {
                __cobertura_counters = new int[30];
                TouchCollector.registerClass((String)"org/apache/commons/pool2/PoolUtils$KeyedObjectPoolMinIdleTimerTask");
            }
        }

        public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.putLineTouchPoint(661, 1, "<init>", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/lang/Object;I)V");
            lightClassmapListener2.putLineTouchPoint(662, 2, "<init>", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/lang/Object;I)V");
            lightClassmapListener2.putJumpTouchPoint(662, 4, 3);
            lightClassmapListener2.putLineTouchPoint(663, 5, "<init>", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/lang/Object;I)V");
            lightClassmapListener2.putLineTouchPoint(666, 6, "<init>", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/lang/Object;I)V");
            lightClassmapListener2.putLineTouchPoint(667, 7, "<init>", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/lang/Object;I)V");
            lightClassmapListener2.putLineTouchPoint(668, 8, "<init>", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/lang/Object;I)V");
            lightClassmapListener2.putLineTouchPoint(669, 9, "<init>", "(Lorg/apache/commons/pool2/KeyedObjectPool;Ljava/lang/Object;I)V");
            lightClassmapListener2.putLineTouchPoint(676, 10, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(678, 11, "run", "()V");
            lightClassmapListener2.putJumpTouchPoint(678, 13, 12);
            lightClassmapListener2.putLineTouchPoint(679, 14, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(681, 15, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(683, 16, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(684, 17, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(688, 18, "run", "()V");
            lightClassmapListener2.putJumpTouchPoint(688, 20, 19);
            lightClassmapListener2.putLineTouchPoint(689, 21, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(692, 22, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(699, 23, "toString", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(700, 24, "toString", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(701, 25, "toString", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(702, 26, "toString", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(703, 27, "toString", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(704, 28, "toString", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(705, 29, "toString", "()Ljava/lang/String;");
        }

        public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.setClazz("org/apache/commons/pool2/PoolUtils$KeyedObjectPoolMinIdleTimerTask");
            lightClassmapListener2.setSource("PoolUtils.java");
            KeyedObjectPoolMinIdleTimerTask.__cobertura_classmap_0(lightClassmapListener2);
        }

        public static int[] __cobertura_get_and_reset_counters() {
            int[] nArray = __cobertura_counters;
            __cobertura_counters = new int[__cobertura_counters.length];
            return nArray;
        }
    }

    private static class ObjectPoolMinIdleTimerTask<T>
    extends TimerTask {
        public static final transient int[] __cobertura_counters;
        private final int minIdle;
        private final ObjectPool<T> pool;

        /*
         * WARNING - void declaration
         */
        ObjectPoolMinIdleTimerTask(ObjectPool<T> objectPool, int n) throws IllegalArgumentException {
            void minIdle;
            void pool;
            int n2 = 0;
            __cobertura_counters[1] = __cobertura_counters[1] + 1;
            __cobertura_counters[2] = __cobertura_counters[2] + 1;
            n2 = 4;
            if (pool == null) {
                __cobertura_counters[3] = __cobertura_counters[3] + 1;
                n2 = 0;
                __cobertura_counters[5] = __cobertura_counters[5] + 1;
                throw new IllegalArgumentException("pool must not be null.");
            }
            int n3 = n2;
            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
            n2 = 0;
            __cobertura_counters[6] = __cobertura_counters[6] + 1;
            this.pool = pool;
            __cobertura_counters[7] = __cobertura_counters[7] + 1;
            this.minIdle = minIdle;
            __cobertura_counters[8] = __cobertura_counters[8] + 1;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            var1_1 = 0;
            ObjectPoolMinIdleTimerTask.__cobertura_counters[9] = ObjectPoolMinIdleTimerTask.__cobertura_counters[9] + 1;
            success = false;
            try {
                ObjectPoolMinIdleTimerTask.__cobertura_counters[10] = ObjectPoolMinIdleTimerTask.__cobertura_counters[10] + 1;
                var1_1 = 12;
                if (this.pool.getNumIdle() < this.minIdle) {
                    ObjectPoolMinIdleTimerTask.__cobertura_counters[11] = ObjectPoolMinIdleTimerTask.__cobertura_counters[11] + 1;
                    var1_1 = 0;
                    ObjectPoolMinIdleTimerTask.__cobertura_counters[13] = ObjectPoolMinIdleTimerTask.__cobertura_counters[13] + 1;
                    this.pool.addObject();
                }
                v0 = var1_1;
                ObjectPoolMinIdleTimerTask.__cobertura_counters[v0] = ObjectPoolMinIdleTimerTask.__cobertura_counters[v0] + 1;
                var1_1 = 0;
                ObjectPoolMinIdleTimerTask.__cobertura_counters[14] = ObjectPoolMinIdleTimerTask.__cobertura_counters[14] + 1;
                success = true;
            }
            catch (Exception v1) {
                try {
                    ObjectPoolMinIdleTimerTask.__cobertura_counters[15] = ObjectPoolMinIdleTimerTask.__cobertura_counters[15] + 1;
                    e = v1;
                    ObjectPoolMinIdleTimerTask.__cobertura_counters[16] = ObjectPoolMinIdleTimerTask.__cobertura_counters[16] + 1;
                    this.cancel();
                }
                catch (Throwable v2) {
                    ObjectPoolMinIdleTimerTask.__cobertura_counters[17] = ObjectPoolMinIdleTimerTask.__cobertura_counters[17] + 1;
                    var4_4 = v2;
                    var1_1 = 19;
                    if (!success) {
                        ObjectPoolMinIdleTimerTask.__cobertura_counters[18] = ObjectPoolMinIdleTimerTask.__cobertura_counters[18] + 1;
                        var1_1 = 0;
                        ObjectPoolMinIdleTimerTask.__cobertura_counters[20] = ObjectPoolMinIdleTimerTask.__cobertura_counters[20] + 1;
                        this.cancel();
                    }
                    throw var4_4;
                }
                ObjectPoolMinIdleTimerTask.__cobertura_counters[17] = ObjectPoolMinIdleTimerTask.__cobertura_counters[17] + 1;
                var1_1 = 19;
                if (!success) {
                    ObjectPoolMinIdleTimerTask.__cobertura_counters[18] = ObjectPoolMinIdleTimerTask.__cobertura_counters[18] + 1;
                    var1_1 = 0;
                    ObjectPoolMinIdleTimerTask.__cobertura_counters[20] = ObjectPoolMinIdleTimerTask.__cobertura_counters[20] + 1;
                    this.cancel();
                } else {
                    ** GOTO lbl53
                }
            }
            ObjectPoolMinIdleTimerTask.__cobertura_counters[17] = ObjectPoolMinIdleTimerTask.__cobertura_counters[17] + 1;
            var1_1 = 19;
            if (!success) {
                ObjectPoolMinIdleTimerTask.__cobertura_counters[18] = ObjectPoolMinIdleTimerTask.__cobertura_counters[18] + 1;
                var1_1 = 0;
                ObjectPoolMinIdleTimerTask.__cobertura_counters[20] = ObjectPoolMinIdleTimerTask.__cobertura_counters[20] + 1;
                this.cancel();
            }
            v3 = var1_1;
            ObjectPoolMinIdleTimerTask.__cobertura_counters[v3] = ObjectPoolMinIdleTimerTask.__cobertura_counters[v3] + 1;
            var1_1 = 0;
            ObjectPoolMinIdleTimerTask.__cobertura_counters[21] = ObjectPoolMinIdleTimerTask.__cobertura_counters[21] + 1;
        }

        public String toString() {
            int n = 0;
            __cobertura_counters[22] = __cobertura_counters[22] + 1;
            StringBuilder sb = new StringBuilder();
            __cobertura_counters[23] = __cobertura_counters[23] + 1;
            sb.append("ObjectPoolMinIdleTimerTask");
            __cobertura_counters[24] = __cobertura_counters[24] + 1;
            sb.append("{minIdle=").append(this.minIdle);
            __cobertura_counters[25] = __cobertura_counters[25] + 1;
            sb.append(", pool=").append(this.pool);
            __cobertura_counters[26] = __cobertura_counters[26] + 1;
            sb.append('}');
            __cobertura_counters[27] = __cobertura_counters[27] + 1;
            return sb.toString();
        }

        static {
            ObjectPoolMinIdleTimerTask.__cobertura_init();
        }

        public static void __cobertura_init() {
            if (__cobertura_counters == null) {
                __cobertura_counters = new int[28];
                TouchCollector.registerClass((String)"org/apache/commons/pool2/PoolUtils$ObjectPoolMinIdleTimerTask");
            }
        }

        public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.putLineTouchPoint(588, 1, "<init>", "(Lorg/apache/commons/pool2/ObjectPool;I)V");
            lightClassmapListener2.putLineTouchPoint(589, 2, "<init>", "(Lorg/apache/commons/pool2/ObjectPool;I)V");
            lightClassmapListener2.putJumpTouchPoint(589, 4, 3);
            lightClassmapListener2.putLineTouchPoint(590, 5, "<init>", "(Lorg/apache/commons/pool2/ObjectPool;I)V");
            lightClassmapListener2.putLineTouchPoint(592, 6, "<init>", "(Lorg/apache/commons/pool2/ObjectPool;I)V");
            lightClassmapListener2.putLineTouchPoint(593, 7, "<init>", "(Lorg/apache/commons/pool2/ObjectPool;I)V");
            lightClassmapListener2.putLineTouchPoint(594, 8, "<init>", "(Lorg/apache/commons/pool2/ObjectPool;I)V");
            lightClassmapListener2.putLineTouchPoint(601, 9, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(603, 10, "run", "()V");
            lightClassmapListener2.putJumpTouchPoint(603, 12, 11);
            lightClassmapListener2.putLineTouchPoint(604, 13, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(606, 14, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(608, 15, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(609, 16, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(612, 17, "run", "()V");
            lightClassmapListener2.putJumpTouchPoint(612, 19, 18);
            lightClassmapListener2.putLineTouchPoint(613, 20, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(616, 21, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(623, 22, "toString", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(624, 23, "toString", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(625, 24, "toString", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(626, 25, "toString", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(627, 26, "toString", "()Ljava/lang/String;");
            lightClassmapListener2.putLineTouchPoint(628, 27, "toString", "()Ljava/lang/String;");
        }

        public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.setClazz("org/apache/commons/pool2/PoolUtils$ObjectPoolMinIdleTimerTask");
            lightClassmapListener2.setSource("PoolUtils.java");
            ObjectPoolMinIdleTimerTask.__cobertura_classmap_0(lightClassmapListener2);
        }

        public static int[] __cobertura_get_and_reset_counters() {
            int[] nArray = __cobertura_counters;
            __cobertura_counters = new int[__cobertura_counters.length];
            return nArray;
        }
    }

    static class TimerHolder {
        public static final transient int[] __cobertura_counters;
        static final Timer MIN_IDLE_TIMER;

        TimerHolder() {
            int n = 0;
            __cobertura_counters[1] = __cobertura_counters[1] + 1;
        }

        static {
            TimerHolder.__cobertura_init();
            int n = 0;
            __cobertura_counters[2] = __cobertura_counters[2] + 1;
            MIN_IDLE_TIMER = new Timer(true);
        }

        public static void __cobertura_init() {
            if (__cobertura_counters == null) {
                __cobertura_counters = new int[3];
                TouchCollector.registerClass((String)"org/apache/commons/pool2/PoolUtils$TimerHolder");
            }
        }

        public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.putLineTouchPoint(45, 1, "<init>", "()V");
            lightClassmapListener2.putLineTouchPoint(46, 2, "<clinit>", "()V");
        }

        public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.setClazz("org/apache/commons/pool2/PoolUtils$TimerHolder");
            lightClassmapListener2.setSource("PoolUtils.java");
            TimerHolder.__cobertura_classmap_0(lightClassmapListener2);
        }

        public static int[] __cobertura_get_and_reset_counters() {
            int[] nArray = __cobertura_counters;
            __cobertura_counters = new int[__cobertura_counters.length];
            return nArray;
        }
    }
}

