/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.junit.Assert;
import org.junit.Test;

public class TestDefaultPooledObject {
    @Test
    public void testgetIdleTimeMillis() throws Exception {
        DefaultPooledObject dpo = new DefaultPooledObject(new Object());
        AtomicBoolean negativeIdleTimeReturned = new AtomicBoolean(false);
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 3);
        Runnable allocateAndDeallocateTask = () -> {
            for (int i1 = 0; i1 < 10000; ++i1) {
                if (dpo.getIdleTimeMillis() >= 0L) continue;
                negativeIdleTimeReturned.set(true);
                break;
            }
            dpo.allocate();
            for (int i2 = 0; i2 < 10000; ++i2) {
                if (dpo.getIdleTimeMillis() >= 0L) continue;
                negativeIdleTimeReturned.set(true);
                break;
            }
            dpo.deallocate();
        };
        Runnable getIdleTimeTask = () -> {
            for (int i = 0; i < 10000; ++i) {
                if (dpo.getIdleTimeMillis() >= 0L) continue;
                negativeIdleTimeReturned.set(true);
                break;
            }
        };
        double probabilityOfAllocationTask = 0.7;
        ArrayList futures = new ArrayList();
        for (int i = 1; i <= 10000; ++i) {
            Runnable runnable = Math.random() < 0.7 ? allocateAndDeallocateTask : getIdleTimeTask;
            futures.add(executor.submit(runnable));
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertFalse((String)"DefaultPooledObject.getIdleTimeMillis() returned a negative value", (boolean)negativeIdleTimeReturned.get());
    }
}

