/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.api;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.BlankNode;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Dataset;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Literal;
import org.apache.commons.rdf.api.Quad;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractDatasetTest {
    protected RDF factory;
    protected Dataset dataset;
    protected IRI alice;
    protected IRI bob;
    protected IRI name;
    protected IRI knows;
    protected IRI member;
    protected BlankNode bnode1;
    protected BlankNode bnode2;
    protected Literal aliceName;
    protected Literal bobName;
    protected Literal secretClubName;
    protected Literal companyName;
    protected Quad bobNameQuad;
    private IRI isPrimaryTopicOf;
    private IRI graph1;
    private BlankNode graph2;

    protected abstract RDF createFactory();

    @Before
    public void createDatasetAndAdd() {
        this.factory = this.createFactory();
        this.dataset = this.factory.createDataset();
        Assert.assertEquals((long)0L, (long)this.dataset.size());
        this.graph1 = this.factory.createIRI("http://example.com/graph1");
        this.graph2 = this.factory.createBlankNode();
        this.alice = this.factory.createIRI("http://example.com/alice");
        this.bob = this.factory.createIRI("http://example.com/bob");
        this.name = this.factory.createIRI("http://xmlns.com/foaf/0.1/name");
        this.knows = this.factory.createIRI("http://xmlns.com/foaf/0.1/knows");
        this.member = this.factory.createIRI("http://xmlns.com/foaf/0.1/member");
        this.bnode1 = this.factory.createBlankNode("org1");
        this.bnode2 = this.factory.createBlankNode("org2");
        this.secretClubName = this.factory.createLiteral("The Secret Club");
        this.companyName = this.factory.createLiteral("A company");
        this.aliceName = this.factory.createLiteral("Alice");
        this.bobName = this.factory.createLiteral("Bob", "en-US");
        this.dataset.add((BlankNodeOrIRI)this.graph1, (BlankNodeOrIRI)this.alice, this.name, (RDFTerm)this.aliceName);
        this.dataset.add((BlankNodeOrIRI)this.graph1, (BlankNodeOrIRI)this.alice, this.knows, (RDFTerm)this.bob);
        this.dataset.add((BlankNodeOrIRI)this.graph1, (BlankNodeOrIRI)this.alice, this.member, (RDFTerm)this.bnode1);
        this.bobNameQuad = this.factory.createQuad((BlankNodeOrIRI)this.graph2, (BlankNodeOrIRI)this.bob, this.name, (RDFTerm)this.bobName);
        this.dataset.add(this.bobNameQuad);
        this.dataset.add(this.factory.createQuad((BlankNodeOrIRI)this.graph2, (BlankNodeOrIRI)this.bob, this.member, (RDFTerm)this.bnode1));
        this.dataset.add(this.factory.createQuad((BlankNodeOrIRI)this.graph2, (BlankNodeOrIRI)this.bob, this.member, (RDFTerm)this.bnode2));
        this.dataset.add((BlankNodeOrIRI)this.graph1, (BlankNodeOrIRI)this.bnode1, this.name, (RDFTerm)this.secretClubName);
        this.dataset.add((BlankNodeOrIRI)this.graph2, (BlankNodeOrIRI)this.bnode2, this.name, (RDFTerm)this.companyName);
        this.isPrimaryTopicOf = this.factory.createIRI("http://xmlns.com/foaf/0.1/isPrimaryTopicOf");
        this.dataset.add(null, (BlankNodeOrIRI)this.alice, this.isPrimaryTopicOf, (RDFTerm)this.graph1);
        this.dataset.add(null, (BlankNodeOrIRI)this.bob, this.isPrimaryTopicOf, (RDFTerm)this.graph2);
    }

    @Test
    public void size() throws Exception {
        Assert.assertEquals((long)10L, (long)this.dataset.size());
    }

    @Test
    public void iterate() throws Exception {
        Assume.assumeTrue((this.dataset.size() > 0L ? 1 : 0) != 0);
        ArrayList<Quad> quads = new ArrayList<Quad>();
        for (Quad t : this.dataset.iterate()) {
            quads.add(t);
        }
        Assert.assertEquals((long)this.dataset.size(), (long)quads.size());
        Quad q = this.factory.createQuad((BlankNodeOrIRI)this.graph1, (BlankNodeOrIRI)this.alice, this.name, (RDFTerm)this.aliceName);
        quads.contains(q);
        Iterable iterate = this.dataset.iterate();
        Iterator it = iterate.iterator();
        Assert.assertTrue((boolean)it.hasNext());
        it.next();
        this.closeIterable(iterate);
        long count = 0L;
        Iterable iterable = this.dataset.iterate();
        for (Object t : iterable) {
            ++count;
        }
        Assert.assertEquals((long)this.dataset.size(), (long)count);
        HashSet<Quad> aliceQuads = new HashSet<Quad>();
        for (Quad aliceQ : this.dataset.iterate(null, (BlankNodeOrIRI)this.alice, null, null)) {
            aliceQuads.add(aliceQ);
        }
        Assert.assertTrue((boolean)aliceQuads.contains(this.factory.createQuad((BlankNodeOrIRI)this.graph1, (BlankNodeOrIRI)this.alice, this.name, (RDFTerm)this.aliceName)));
        Assert.assertTrue((boolean)aliceQuads.contains(this.factory.createQuad((BlankNodeOrIRI)this.graph1, (BlankNodeOrIRI)this.alice, this.knows, (RDFTerm)this.bob)));
        Assert.assertTrue((boolean)aliceQuads.contains(this.factory.createQuad(null, (BlankNodeOrIRI)this.alice, this.isPrimaryTopicOf, (RDFTerm)this.graph1)));
        Assert.assertEquals((long)4L, (long)aliceQuads.size());
        int topics = 0;
        for (Quad topic : this.dataset.iterate(null, null, this.isPrimaryTopicOf, null)) {
            ++topics;
            Assert.assertFalse((boolean)topic.getGraphName().isPresent());
        }
        Assert.assertEquals((long)2L, (long)topics);
    }

    @Test
    public void streamDefaultGraphNameAlice() throws Exception {
        Optional aliceTopic = this.dataset.stream(null, (BlankNodeOrIRI)this.alice, this.isPrimaryTopicOf, null).findAny();
        Assert.assertTrue((boolean)aliceTopic.isPresent());
        Assert.assertNull(((Quad)aliceTopic.get()).getGraphName().orElse(null));
        Assert.assertFalse((boolean)((Quad)aliceTopic.get()).getGraphName().isPresent());
    }

    @Test
    public void streamDefaultGraphNameByPattern() throws Exception {
        Optional aliceTopic = this.dataset.stream(Optional.empty(), null, null, null).findAny();
        Assert.assertTrue((boolean)aliceTopic.isPresent());
        Assert.assertNull(((Quad)aliceTopic.get()).getGraphName().orElse(null));
        Assert.assertFalse((boolean)((Quad)aliceTopic.get()).getGraphName().isPresent());
    }

    private void closeIterable(Iterable<Quad> iterate) throws Exception {
        if (iterate instanceof AutoCloseable) {
            ((AutoCloseable)((Object)iterate)).close();
        }
    }

    @Test
    public void iterateFilter() throws Exception {
        ArrayList<RDFTerm> friends = new ArrayList<RDFTerm>();
        IRI alice = this.factory.createIRI("http://example.com/alice");
        IRI knows = this.factory.createIRI("http://xmlns.com/foaf/0.1/knows");
        for (Quad t : this.dataset.iterate(null, (BlankNodeOrIRI)alice, knows, null)) {
            friends.add(t.getObject());
        }
        Assert.assertEquals((long)1L, (long)friends.size());
        Assert.assertEquals((Object)this.bob, friends.get(0));
        Iterable iterate = this.dataset.iterate(Optional.of(this.graph2), (BlankNodeOrIRI)this.bob, knows, (RDFTerm)alice);
        for (Quad unexpected : iterate) {
            Assert.fail((String)("Unexpected quad " + unexpected));
        }
    }

    @Test
    public void contains() throws Exception {
        Assert.assertFalse((boolean)this.dataset.contains(null, (BlankNodeOrIRI)this.bob, this.knows, (RDFTerm)this.alice));
        Assert.assertTrue((boolean)this.dataset.contains(Optional.of(this.graph1), (BlankNodeOrIRI)this.alice, this.knows, (RDFTerm)this.bob));
        try (Stream stream = this.dataset.stream();){
            Optional first = stream.skip(4L).findFirst();
            Assume.assumeTrue((boolean)first.isPresent());
            Quad existingQuad = (Quad)first.get();
            Assert.assertTrue((boolean)this.dataset.contains(existingQuad));
        }
        Quad nonExistingQuad = this.factory.createQuad((BlankNodeOrIRI)this.graph2, (BlankNodeOrIRI)this.bob, this.knows, (RDFTerm)this.alice);
        Assert.assertFalse((boolean)this.dataset.contains(nonExistingQuad));
        Quad quad = this.factory.createQuad((BlankNodeOrIRI)this.graph1, (BlankNodeOrIRI)this.alice, this.knows, (RDFTerm)this.bob);
        Assert.assertTrue((boolean)this.dataset.contains(quad));
    }

    @Test
    public void remove() throws Exception {
        Quad otherQuad;
        long fullSize = this.dataset.size();
        this.dataset.remove(Optional.of(this.graph1), (BlankNodeOrIRI)this.alice, this.knows, (RDFTerm)this.bob);
        long shrunkSize = this.dataset.size();
        Assert.assertEquals((long)1L, (long)(fullSize - shrunkSize));
        this.dataset.remove(Optional.of(this.graph1), (BlankNodeOrIRI)this.alice, this.knows, (RDFTerm)this.bob);
        Assert.assertEquals((long)shrunkSize, (long)this.dataset.size());
        this.dataset.add((BlankNodeOrIRI)this.graph1, (BlankNodeOrIRI)this.alice, this.knows, (RDFTerm)this.bob);
        this.dataset.add((BlankNodeOrIRI)this.graph2, (BlankNodeOrIRI)this.alice, this.knows, (RDFTerm)this.bob);
        this.dataset.add((BlankNodeOrIRI)this.graph2, (BlankNodeOrIRI)this.alice, this.knows, (RDFTerm)this.bob);
        Assert.assertTrue((this.dataset.size() > shrunkSize ? 1 : 0) != 0);
        this.dataset.remove(null, (BlankNodeOrIRI)this.alice, this.knows, (RDFTerm)this.bob);
        Assert.assertEquals((long)shrunkSize, (long)this.dataset.size());
        try (Stream stream = this.dataset.stream();){
            Optional anyQuad = stream.findAny();
            Assume.assumeTrue((boolean)anyQuad.isPresent());
            otherQuad = (Quad)anyQuad.get();
        }
        this.dataset.remove(otherQuad);
        Assert.assertEquals((long)(shrunkSize - 1L), (long)this.dataset.size());
        this.dataset.remove(otherQuad);
        Assert.assertEquals((long)(shrunkSize - 1L), (long)this.dataset.size());
        this.dataset.add(otherQuad);
        Assert.assertTrue((this.dataset.size() >= shrunkSize ? 1 : 0) != 0);
    }

    @Test
    public void clear() throws Exception {
        this.dataset.clear();
        Assert.assertFalse((boolean)this.dataset.contains(null, (BlankNodeOrIRI)this.alice, this.knows, (RDFTerm)this.bob));
        Assert.assertEquals((long)0L, (long)this.dataset.size());
        this.dataset.clear();
        Assert.assertEquals((long)0L, (long)this.dataset.size());
        Assert.assertFalse((boolean)this.dataset.contains(null, null, null, null));
    }

    @Test
    public void getQuads() throws Exception {
        long quadCount;
        try (Stream stream = this.dataset.stream();){
            quadCount = stream.count();
        }
        Assert.assertTrue((quadCount > 0L ? 1 : 0) != 0);
        stream = this.dataset.stream();
        var4_2 = null;
        try {
            Assert.assertTrue((boolean)stream.allMatch(t -> this.dataset.contains(t)));
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (var4_2 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
        Assume.assumeNotNull((Object[])new Object[]{this.bnode1, this.bnode2, this.aliceName, this.bobName, this.secretClubName, this.companyName, this.bobNameQuad});
        Assert.assertEquals((long)10L, (long)quadCount);
    }

    @Test
    public void getQuadsQuery() throws Exception {
        try (Stream stream = this.dataset.stream(Optional.of(this.graph1), (BlankNodeOrIRI)this.alice, null, null);){
            long aliceCount = stream.count();
            Assert.assertTrue((aliceCount > 0L ? 1 : 0) != 0);
            Assume.assumeNotNull((Object[])new Object[]{this.aliceName});
            Assert.assertEquals((long)3L, (long)aliceCount);
        }
        Assume.assumeNotNull((Object[])new Object[]{this.bnode1, this.bnode2, this.bobName, this.companyName, this.secretClubName});
        stream = this.dataset.stream(null, null, this.name, null);
        var2_2 = null;
        try {
            Assert.assertEquals((long)4L, (long)stream.count());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (var2_2 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
        Assume.assumeNotNull((Object[])new Object[]{this.bnode1});
        stream = this.dataset.stream(null, null, this.member, null);
        var2_2 = null;
        try {
            Assert.assertEquals((long)3L, (long)stream.count());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (var2_2 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
    }

    @Test
    public void addBlankNodesFromMultipleDatasets() throws Exception {
        try (Dataset g1 = this.createDataset1();
             Dataset g2 = this.createDataset2();
             Dataset g3 = this.factory.createDataset();){
            this.addAllQuads(g1, g3);
            this.addAllQuads(g2, g3);
            ConcurrentHashMap whoIsWho = new ConcurrentHashMap();
            IRI name = this.factory.createIRI("http://xmlns.com/foaf/0.1/name");
            try (Stream stream = g3.stream(null, null, name, null);){
                ((Stream)stream.parallel()).forEach(t -> whoIsWho.put(t.getObject().ntriplesString(), t.getSubject()));
            }
            Assert.assertEquals((long)4L, (long)whoIsWho.size());
            Assert.assertEquals((long)4L, (long)new HashSet(whoIsWho.values()).size());
            BlankNodeOrIRI b1Alice = (BlankNodeOrIRI)whoIsWho.get("\"Alice\"");
            Assert.assertNotNull((Object)b1Alice);
            BlankNodeOrIRI b2Bob = (BlankNodeOrIRI)whoIsWho.get("\"Bob\"");
            Assert.assertNotNull((Object)b2Bob);
            BlankNodeOrIRI b1Charlie = (BlankNodeOrIRI)whoIsWho.get("\"Charlie\"");
            Assert.assertNotNull((Object)b1Charlie);
            BlankNodeOrIRI b2Dave = (BlankNodeOrIRI)whoIsWho.get("\"Dave\"");
            Assert.assertNotNull((Object)b2Dave);
            this.notEquals(b1Alice, b2Bob);
            this.notEquals(b1Alice, b1Charlie);
            this.notEquals(b1Alice, b2Dave);
            this.notEquals(b2Bob, b1Charlie);
            this.notEquals(b2Bob, b2Dave);
            this.notEquals(b1Charlie, b2Dave);
            IRI hasChild = this.factory.createIRI("http://example.com/hasChild");
            Assert.assertTrue((boolean)g3.contains(null, b1Alice, hasChild, (RDFTerm)b2Bob));
            Assert.assertTrue((boolean)g3.contains(null, b2Dave, hasChild, (RDFTerm)b1Charlie));
            Assert.assertFalse((boolean)g3.contains(null, b1Alice, hasChild, (RDFTerm)b1Alice));
            Assert.assertFalse((boolean)g3.contains(null, b1Alice, hasChild, (RDFTerm)b1Charlie));
            Assert.assertFalse((boolean)g3.contains(null, b1Alice, hasChild, (RDFTerm)b2Dave));
            Assert.assertFalse((boolean)g3.contains(null, b2Dave, hasChild, (RDFTerm)b1Alice));
            Assert.assertFalse((boolean)g3.contains(null, b2Dave, hasChild, (RDFTerm)b1Alice));
            Assert.assertFalse((boolean)g3.contains(null, b2Bob, hasChild, null));
            Assert.assertFalse((boolean)g3.contains(null, b1Charlie, hasChild, null));
        }
    }

    private void notEquals(BlankNodeOrIRI node1, BlankNodeOrIRI node2) {
        Assert.assertFalse((boolean)node1.equals(node2));
        Assert.assertFalse((boolean)node1.ntriplesString().equals(node2.ntriplesString()));
    }

    private void addAllQuads(Dataset source, Dataset target) {
        try (Stream stream = source.stream();){
            ((Stream)((Stream)stream.unordered()).sequential()).forEach(t -> target.add(t));
        }
    }

    private Dataset createDataset1() {
        RDF factory1 = this.createFactory();
        IRI name = factory1.createIRI("http://xmlns.com/foaf/0.1/name");
        Dataset g1 = factory1.createDataset();
        BlankNode b1 = this.createOwnBlankNode("b1", "0240eaaa-d33e-4fc0-a4f1-169d6ced3680");
        g1.add((BlankNodeOrIRI)b1, (BlankNodeOrIRI)b1, name, (RDFTerm)factory1.createLiteral("Alice"));
        BlankNode b2 = this.createOwnBlankNode("b2", "9de7db45-0ce7-4b0f-a1ce-c9680ffcfd9f");
        g1.add((BlankNodeOrIRI)b2, (BlankNodeOrIRI)b2, name, (RDFTerm)factory1.createLiteral("Bob"));
        IRI hasChild = factory1.createIRI("http://example.com/hasChild");
        g1.add(null, (BlankNodeOrIRI)b1, hasChild, (RDFTerm)b2);
        return g1;
    }

    private BlankNode createOwnBlankNode(final String name, final String uuid) {
        return new BlankNode(){

            public String ntriplesString() {
                return "_: " + name;
            }

            public String uniqueReference() {
                return uuid;
            }

            public int hashCode() {
                return uuid.hashCode();
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof BlankNode)) {
                    return false;
                }
                BlankNode other = (BlankNode)obj;
                return uuid.equals(other.uniqueReference());
            }
        };
    }

    private Dataset createDataset2() {
        RDF factory2 = this.createFactory();
        IRI name = factory2.createIRI("http://xmlns.com/foaf/0.1/name");
        Dataset g2 = factory2.createDataset();
        BlankNode b1 = this.createOwnBlankNode("b1", "bc8d3e45-a08f-421d-85b3-c25b373abf87");
        g2.add((BlankNodeOrIRI)b1, (BlankNodeOrIRI)b1, name, (RDFTerm)factory2.createLiteral("Charlie"));
        BlankNode b2 = this.createOwnBlankNode("b2", "2209097a-5078-4b03-801a-6a2d2f50d739");
        g2.add((BlankNodeOrIRI)b2, (BlankNodeOrIRI)b2, name, (RDFTerm)factory2.createLiteral("Dave"));
        IRI hasChild = factory2.createIRI("http://example.com/hasChild");
        g2.add((BlankNodeOrIRI)b2, (BlankNodeOrIRI)b2, hasChild, (RDFTerm)b1);
        return g2;
    }

    @Test
    public void getGraphNames() throws Exception {
        Set names = this.dataset.getGraphNames().collect(Collectors.toSet());
        Assert.assertTrue((String)("Can't find graph name " + this.graph1), (boolean)names.contains(this.graph1));
        Assert.assertTrue((String)"Found no quads in graph1", (boolean)this.dataset.contains(Optional.of(this.graph1), null, null, null));
        Optional<BlankNodeOrIRI> graphName2 = this.dataset.getGraphNames().filter(BlankNode.class::isInstance).findAny();
        Assert.assertTrue((String)"Could not find graph2-like BlankNode", (boolean)graphName2.isPresent());
        Assert.assertTrue((String)"Found no quads in graph2", (boolean)this.dataset.contains(graphName2, null, null, null));
    }

    @Test
    public void getGraph() throws Exception {
        try (Graph defaultGraph = this.dataset.getGraph();){
            Assert.assertEquals((long)2L, (long)defaultGraph.size());
            Assert.assertTrue((boolean)defaultGraph.contains((BlankNodeOrIRI)this.alice, this.isPrimaryTopicOf, (RDFTerm)this.graph1));
            Assert.assertTrue((boolean)defaultGraph.contains((BlankNodeOrIRI)this.bob, this.isPrimaryTopicOf, null));
        }
    }

    @Test
    public void getGraphNull() throws Exception {
        try (Graph defaultGraph = (Graph)this.dataset.getGraph(null).get();){
            Assert.assertEquals((long)2L, (long)defaultGraph.size());
            Assert.assertTrue((boolean)defaultGraph.contains((BlankNodeOrIRI)this.alice, this.isPrimaryTopicOf, (RDFTerm)this.graph1));
            Assert.assertTrue((boolean)defaultGraph.contains((BlankNodeOrIRI)this.bob, this.isPrimaryTopicOf, null));
        }
    }

    @Test
    public void getGraph1() throws Exception {
        try (Graph g1 = (Graph)this.dataset.getGraph((BlankNodeOrIRI)this.graph1).get();){
            Assert.assertEquals((long)4L, (long)g1.size());
            Assert.assertTrue((boolean)g1.contains((BlankNodeOrIRI)this.alice, this.name, (RDFTerm)this.aliceName));
            Assert.assertTrue((boolean)g1.contains((BlankNodeOrIRI)this.alice, this.knows, (RDFTerm)this.bob));
            Assert.assertTrue((boolean)g1.contains((BlankNodeOrIRI)this.alice, this.member, null));
            Assert.assertTrue((boolean)g1.contains(null, this.name, (RDFTerm)this.secretClubName));
        }
    }

    @Test
    public void getGraph2() throws Exception {
        BlankNodeOrIRI graph2Name = (BlankNodeOrIRI)this.dataset.stream(Optional.empty(), (BlankNodeOrIRI)this.bob, this.isPrimaryTopicOf, null).map(Quad::getObject).findAny().get();
        try (Graph g2 = (Graph)this.dataset.getGraph(graph2Name).get();){
            Assert.assertEquals((long)4L, (long)g2.size());
            Triple bobNameTriple = this.bobNameQuad.asTriple();
            Assert.assertTrue((boolean)g2.contains(bobNameTriple));
            Assert.assertTrue((boolean)g2.contains((BlankNodeOrIRI)this.bob, this.member, (RDFTerm)this.bnode1));
            Assert.assertTrue((boolean)g2.contains((BlankNodeOrIRI)this.bob, this.member, (RDFTerm)this.bnode2));
            Assert.assertFalse((boolean)g2.contains((BlankNodeOrIRI)this.bnode1, this.name, (RDFTerm)this.secretClubName));
            Assert.assertTrue((boolean)g2.contains((BlankNodeOrIRI)this.bnode2, this.name, (RDFTerm)this.companyName));
        }
    }

    @Test
    public void containsLanguageTagsCaseInsensitive() {
        Literal lower = this.factory.createLiteral("Hello there", "en-gb");
        Literal upper = this.factory.createLiteral("Hello there", "EN-GB");
        Literal mixed = this.factory.createLiteral("Hello there", "en-GB");
        IRI example1 = this.factory.createIRI("http://example.com/s1");
        IRI greeting = this.factory.createIRI("http://example.com/greeting");
        this.dataset.add(null, (BlankNodeOrIRI)example1, greeting, (RDFTerm)upper);
        Assert.assertTrue((boolean)this.dataset.contains(this.factory.createQuad(null, (BlankNodeOrIRI)example1, greeting, (RDFTerm)upper)));
        Assert.assertTrue((boolean)this.dataset.contains(this.factory.createQuad(null, (BlankNodeOrIRI)example1, greeting, (RDFTerm)lower)));
        Assert.assertTrue((boolean)this.dataset.contains(this.factory.createQuad(null, (BlankNodeOrIRI)example1, greeting, (RDFTerm)mixed)));
        Assert.assertTrue((boolean)this.dataset.contains(null, null, null, (RDFTerm)upper));
        Assert.assertTrue((boolean)this.dataset.contains(null, null, null, (RDFTerm)lower));
        Assert.assertTrue((boolean)this.dataset.contains(null, null, null, (RDFTerm)mixed));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void containsLanguageTagsCaseInsensitiveTurkish() {
        Locale defaultLocale = Locale.getDefault();
        try {
            Locale.setDefault(Locale.ROOT);
            Literal lowerROOT = this.factory.createLiteral("moi", "fi");
            Literal upperROOT = this.factory.createLiteral("moi", "FI");
            Literal mixedROOT = this.factory.createLiteral("moi", "fI");
            IRI exampleROOT = this.factory.createIRI("http://example.com/s1");
            IRI greeting = this.factory.createIRI("http://example.com/greeting");
            this.dataset.add(null, (BlankNodeOrIRI)exampleROOT, greeting, (RDFTerm)mixedROOT);
            Locale turkish = Locale.forLanguageTag("TR");
            Locale.setDefault(turkish);
            Assume.assumeFalse((boolean)"FI".toLowerCase().equals("fi"));
            Literal lower = this.factory.createLiteral("moi", "fi");
            Literal upper = this.factory.createLiteral("moi", "FI");
            Literal mixed = this.factory.createLiteral("moi", "fI");
            IRI exampleTR = this.factory.createIRI("http://example.com/s2");
            this.dataset.add(null, (BlankNodeOrIRI)exampleTR, greeting, (RDFTerm)upper);
            Assert.assertTrue((boolean)this.dataset.contains(this.factory.createQuad(null, (BlankNodeOrIRI)exampleTR, greeting, (RDFTerm)upper)));
            Assert.assertTrue((boolean)this.dataset.contains(this.factory.createQuad(null, (BlankNodeOrIRI)exampleTR, greeting, (RDFTerm)upperROOT)));
            Assert.assertTrue((boolean)this.dataset.contains(this.factory.createQuad(null, (BlankNodeOrIRI)exampleTR, greeting, (RDFTerm)lower)));
            Assert.assertTrue((boolean)this.dataset.contains(this.factory.createQuad(null, (BlankNodeOrIRI)exampleTR, greeting, (RDFTerm)lowerROOT)));
            Assert.assertTrue((boolean)this.dataset.contains(this.factory.createQuad(null, (BlankNodeOrIRI)exampleTR, greeting, (RDFTerm)mixed)));
            Assert.assertTrue((boolean)this.dataset.contains(this.factory.createQuad(null, (BlankNodeOrIRI)exampleTR, greeting, (RDFTerm)mixedROOT)));
            Assert.assertTrue((boolean)this.dataset.contains(null, (BlankNodeOrIRI)exampleTR, null, (RDFTerm)upper));
            Assert.assertTrue((boolean)this.dataset.contains(null, (BlankNodeOrIRI)exampleTR, null, (RDFTerm)upperROOT));
            Assert.assertTrue((boolean)this.dataset.contains(null, (BlankNodeOrIRI)exampleTR, null, (RDFTerm)lower));
            Assert.assertTrue((boolean)this.dataset.contains(null, (BlankNodeOrIRI)exampleTR, null, (RDFTerm)lowerROOT));
            Assert.assertTrue((boolean)this.dataset.contains(null, (BlankNodeOrIRI)exampleTR, null, (RDFTerm)mixed));
            Assert.assertTrue((boolean)this.dataset.contains(null, (BlankNodeOrIRI)exampleTR, null, (RDFTerm)mixedROOT));
            Assert.assertTrue((boolean)this.dataset.contains(this.factory.createQuad(null, (BlankNodeOrIRI)exampleROOT, greeting, (RDFTerm)upper)));
            Assert.assertTrue((boolean)this.dataset.contains(this.factory.createQuad(null, (BlankNodeOrIRI)exampleROOT, greeting, (RDFTerm)lower)));
            Assert.assertTrue((boolean)this.dataset.contains(this.factory.createQuad(null, (BlankNodeOrIRI)exampleROOT, greeting, (RDFTerm)mixed)));
            Assert.assertTrue((boolean)this.dataset.contains(null, (BlankNodeOrIRI)exampleROOT, null, (RDFTerm)upper));
            Assert.assertTrue((boolean)this.dataset.contains(null, (BlankNodeOrIRI)exampleROOT, null, (RDFTerm)lower));
            Assert.assertTrue((boolean)this.dataset.contains(null, (BlankNodeOrIRI)exampleROOT, null, (RDFTerm)mixed));
        }
        finally {
            Locale.setDefault(defaultLocale);
        }
    }

    @Test
    public void removeLanguageTagsCaseInsensitive() {
        Literal lower = this.factory.createLiteral("Howdy", "en-us");
        Literal upper = this.factory.createLiteral("Howdy", "EN-US");
        Literal mixed = this.factory.createLiteral("Howdy", "en-US");
        IRI example1 = this.factory.createIRI("http://example.com/s1");
        IRI greeting = this.factory.createIRI("http://example.com/greeting");
        this.dataset.add(null, (BlankNodeOrIRI)example1, greeting, (RDFTerm)upper);
        this.dataset.remove(null, (BlankNodeOrIRI)example1, null, (RDFTerm)mixed);
        Assert.assertFalse((boolean)this.dataset.contains(null, null, greeting, null));
        this.dataset.add(null, (BlankNodeOrIRI)example1, greeting, (RDFTerm)lower);
        this.dataset.remove(null, (BlankNodeOrIRI)example1, null, (RDFTerm)upper);
        this.dataset.add(this.factory.createQuad(null, (BlankNodeOrIRI)example1, greeting, (RDFTerm)mixed));
        this.dataset.remove(this.factory.createQuad(null, (BlankNodeOrIRI)example1, greeting, (RDFTerm)upper));
        Assert.assertFalse((boolean)this.dataset.contains(null, null, greeting, null));
    }

    private static Optional<? extends Quad> closableFindAny(Stream<? extends Quad> stream) {
        try (Stream<? extends Quad> s = stream;){
            Optional<? extends Quad> optional = s.findAny();
            return optional;
        }
    }

    @Test
    public void streamLanguageTagsCaseInsensitive() {
        Literal lower = this.factory.createLiteral("Good afternoon", "en-gb");
        Literal upper = this.factory.createLiteral("Good afternoon", "EN-GB");
        Literal mixed = this.factory.createLiteral("Good afternoon", "en-GB");
        IRI example1 = this.factory.createIRI("http://example.com/s1");
        IRI greeting = this.factory.createIRI("http://example.com/greeting");
        this.dataset.add(null, (BlankNodeOrIRI)example1, greeting, (RDFTerm)upper);
        Assert.assertTrue((boolean)AbstractDatasetTest.closableFindAny(this.dataset.stream(null, null, null, (RDFTerm)upper)).isPresent());
        Assert.assertTrue((boolean)AbstractDatasetTest.closableFindAny(this.dataset.stream(null, null, null, (RDFTerm)lower)).isPresent());
        Assert.assertTrue((boolean)AbstractDatasetTest.closableFindAny(this.dataset.stream(null, null, null, (RDFTerm)mixed)).isPresent());
        Quad q = AbstractDatasetTest.closableFindAny(this.dataset.stream(null, null, null, (RDFTerm)lower)).get();
        Assert.assertEquals((Object)q, (Object)this.factory.createQuad(null, (BlankNodeOrIRI)example1, greeting, (RDFTerm)mixed));
    }

    @Test
    public void whyJavaStreamsMightNotTakeOverFromSparql() throws Exception {
        Assume.assumeNotNull((Object[])new Object[]{this.bnode1, this.bnode2, this.secretClubName});
        try (Stream stream = this.dataset.stream(null, null, this.knows, null);){
            Assert.assertEquals((Object)"\"The Secret Club\"", (Object)stream.filter(t -> !this.dataset.contains(null, (BlankNodeOrIRI)t.getObject(), this.knows, (RDFTerm)t.getSubject())).map(knowsQuad -> {
                try (Stream memberOf = this.dataset.stream(null, (BlankNodeOrIRI)knowsQuad.getObject(), this.member, null);){
                    RDFTerm rDFTerm = memberOf.filter(memberQuad -> this.dataset.contains(null, knowsQuad.getSubject(), this.member, memberQuad.getObject())).findFirst().get().getObject();
                    return rDFTerm;
                }
            }).map(org -> {
                try (Stream orgName = this.dataset.stream(null, (BlankNodeOrIRI)org, this.name, null);){
                    String string = ((Quad)orgName.findFirst().get()).getObject().ntriplesString();
                    return string;
                }
            }).findFirst().get());
        }
    }
}

